
import gmsh


def GenerateConductionPlate(y_axis_start, x_axis_start):
    
    copper_thickness = .01
    steel_thickness = .05
    
    plate_length = .7           # 20 mm length is the smallest stage. Make the plate 18 mm
    
    N_num_x_incs = 50
    
    point = []
    
    for x_inc in range(N_num_x_increments):
        pnt = gmsh.model.occ.addPoint((-plate_length*x_inc/N_num_x_incs)+x_axis_start, -copper_thickness+y_axis_start, 0)
        point.append(pnt)