
import gmsh


def GenerateConductionPlate_iron(y_axis_start, x_axis_start):
    
    iron_thickness = .05
    
    plate_length = .7           # 20 mm length is the smallest stage. Make the plate 18 mm
    
    gmsh.model.occ.synchronize()
    
    copper_offset = .01  #Thickness of copper skin on plate
    
    N_num_x_incs = 100
    N_num_y_incs = 4
    
    point = []
    
        # Points along the bottom of the iron plate (right to left)
    for x_inc in range(N_num_x_incs):
        x_pos = (plate_length*x_inc/N_num_x_incs)+x_axis_start 
        y_pos = (0)+copper_offset+y_axis_start
        pnt = gmsh.model.occ.addPoint(x_pos, y_pos, 0)
        point.append(pnt)
        
        #Points up the right side of the copper plate...
    for y_inc in range(N_num_y_incs):
        x_pos = (plate_length)+x_axis_start 
        y_pos = (iron_thickness*y_inc/N_num_y_incs)+copper_offset+y_axis_start
        pnt = gmsh.model.occ.addPoint(x_pos, y_pos, 0)
        point.append(pnt)        
        
        # Points along the top of the copper plate (left to right)
    for x_inc in range(N_num_x_incs):
        x_pos = (plate_length*(1.0 - x_inc/N_num_x_incs))+x_axis_start 
        y_pos = (iron_thickness)+copper_offset+y_axis_start
        pnt = gmsh.model.occ.addPoint(x_pos, y_pos, 0)
        point.append(pnt)        
        
        #Points down the left side of the copper plate...
    for y_inc in range(N_num_y_incs):
        x_pos = (0)+x_axis_start 
        y_pos = (iron_thickness*(1.0 - y_inc/N_num_y_incs))+copper_offset+y_axis_start
        pnt = gmsh.model.occ.addPoint(x_pos, y_pos, 0)
        point.append(pnt)            
        
    line = []   

    N_num_incs = 2 * N_num_x_incs + 2 * N_num_y_incs



    for pnt_inc in range(N_num_incs):
        if pnt_inc == N_num_incs - 1:
            line_seg = gmsh.model.occ.addLine(point[pnt_inc], point[0])
        else:   
            line_seg = gmsh.model.occ.addLine(point[pnt_inc], point[pnt_inc+1])
        line.append(line_seg)



    cl = gmsh.model.occ.addCurveLoop(line)
    plate = gmsh.model.occ.addPlaneSurface([cl])   

    plate_mass = plate_length * iron_thickness  
    
    rtn_vals = []

    rtn_vals.append(plate_mass)
    rtn_vals.append(plate)
    return rtn_vals        

