
import gmsh


def GenerateCore_4_Gap_Rev_3(y_start_pos, x_start_pos):
    
    
    pc_trace_length = 0.025
    core_gap = pc_trace_length + .01 + .01   # Allow .01 inch tolerance between tooth and trace (each side)
    
    pc_trace_offset = .06   
    tooth_width = pc_trace_offset - .015     # tooth - gap - tooth - gap - tooth - gap - tooth  should total to .315 inchs (8 mm)
    
            #Rev_3 has 4 core_gap's and 5 teeth...
    core_base_length = 4 * core_gap + 5 * tooth_width
    
    pc_trace_height = .0014  # 35 um       
    pc_trace_height_gap = pc_trace_height + .0087   #thickness of trace + pre-preg or FR-4 core which is approx. .22 mm
    N_num_trace_layers = 10
    core_gap_depth = pc_trace_height_gap * (N_num_trace_layers + 2)  # Factor of 2 for pc board thickness tolerance.
    
    core_base_depth = .1
    core_side_depth = core_gap_depth + core_base_depth
    
    
    gmsh.model.occ.synchronize()
    
    N_num_of_core_base_incs = 50
    N_num_of_core_side_incs = 24
    N_num_of_top_tooth_incs = 10
    N_num_of_gap_incs = 8
    N_num_of_tooth_side_incs = 16
    
    point = []
    
        # Points along base of core (left to right)...
    for x_inc in range(N_num_of_core_base_incs):
        x_pos = (core_base_length*x_inc/N_num_of_core_base_incs)+x_start_pos
        y_pos = (0)+y_start_pos
        pnt = gmsh.model.occ.addPoint(x_pos, y_pos, 0)
        point.append(pnt)
        
        # Points up the right side of core...
    for y_inc in range(N_num_of_core_side_incs):
        x_pos = (core_base_length)+x_start_pos
        y_pos = (core_side_depth*y_inc/N_num_of_core_side_incs)+y_start_pos
        pnt = gmsh.model.occ.addPoint(x_pos, y_pos, 0)
        point.append(pnt)     
        
        # Points along first right tooth (right to left)...
    for x_inc in range(N_num_of_top_tooth_incs):
        x_pos = (core_base_length - tooth_width*x_inc/N_num_of_top_tooth_incs)+x_start_pos
        y_pos = (core_side_depth)+y_start_pos
        pnt = gmsh.model.occ.addPoint(x_pos, y_pos, 0)
        point.append(pnt)    
        
        # Points down first right tooth gap (right to left)...
    for y_inc in range(N_num_of_tooth_side_incs):
        x_pos = (core_base_length - tooth_width)+x_start_pos
        y_pos = (core_side_depth - core_gap_depth*y_inc/N_num_of_tooth_side_incs)+y_start_pos
        pnt = gmsh.model.occ.addPoint(x_pos, y_pos, 0)
        point.append(pnt)   
        
        # Points along first right gap (right to left)...
    for x_inc in range(N_num_of_gap_incs):
        x_pos = (core_base_length - tooth_width - core_gap*x_inc/N_num_of_gap_incs)+x_start_pos
        y_pos = (core_side_depth - core_gap_depth)+y_start_pos
        pnt = gmsh.model.occ.addPoint(x_pos, y_pos, 0)
        point.append(pnt)   
        
        # Points up first right tooth gap (right to left)...
    for y_inc in range(N_num_of_tooth_side_incs):
        x_pos = (core_base_length - tooth_width - core_gap)+x_start_pos
        y_pos = (core_side_depth - core_gap_depth*(1.0 - y_inc/N_num_of_tooth_side_incs))+y_start_pos
        pnt = gmsh.model.occ.addPoint(x_pos, y_pos, 0)
        point.append(pnt)           
        
        # Points along second right tooth (right to left)...
    for x_inc in range(N_num_of_top_tooth_incs):
        x_pos = (core_base_length - tooth_width*x_inc/N_num_of_top_tooth_incs - tooth_width - core_gap)+x_start_pos
        y_pos = (core_side_depth)+y_start_pos
        pnt = gmsh.model.occ.addPoint(x_pos, y_pos, 0)
        point.append(pnt)           
        
        # Points down second right tooth gap (right to left)...
    for y_inc in range(N_num_of_tooth_side_incs):
        x_pos = (core_base_length - 2.0*tooth_width - core_gap)+x_start_pos
        y_pos = (core_side_depth - core_gap_depth*y_inc/N_num_of_tooth_side_incs)+y_start_pos
        pnt = gmsh.model.occ.addPoint(x_pos, y_pos, 0)
        point.append(pnt)  
        
        # Points along second right gap (right to left)...
    for x_inc in range(N_num_of_gap_incs):
        x_pos = (core_base_length - 2.0*tooth_width - core_gap - core_gap*x_inc/N_num_of_gap_incs)+x_start_pos
        y_pos = (core_side_depth - core_gap_depth)+y_start_pos
        pnt = gmsh.model.occ.addPoint(x_pos, y_pos, 0)
        point.append(pnt) 
        
        # Points up second right tooth gap (right to left)...
    for y_inc in range(N_num_of_tooth_side_incs):
        x_pos = (core_base_length - 2.0*tooth_width - 2.0*core_gap)+x_start_pos
        y_pos = (core_side_depth - core_gap_depth*(1.0 - y_inc/N_num_of_tooth_side_incs))+y_start_pos
        pnt = gmsh.model.occ.addPoint(x_pos, y_pos, 0)
        point.append(pnt)   
        
        # Points along third right tooth (right to left)...
    for x_inc in range(N_num_of_top_tooth_incs):
        x_pos = (core_base_length - tooth_width*x_inc/N_num_of_top_tooth_incs - 2.0*tooth_width - 2.0*core_gap)+x_start_pos
        y_pos = (core_side_depth)+y_start_pos
        pnt = gmsh.model.occ.addPoint(x_pos, y_pos, 0)
        point.append(pnt)  
        
        # Points down third right tooth gap (right to left)...
    for y_inc in range(N_num_of_tooth_side_incs):
        x_pos = (core_base_length - 3.0*tooth_width - 2.0*core_gap)+x_start_pos
        y_pos = (core_side_depth - core_gap_depth*y_inc/N_num_of_tooth_side_incs)+y_start_pos
        pnt = gmsh.model.occ.addPoint(x_pos, y_pos, 0)
        point.append(pnt)   
        
        # Points along third right gap (right to left)...
    for x_inc in range(N_num_of_gap_incs):
        x_pos = (core_base_length - 3.0*tooth_width - 2.0*core_gap - core_gap*x_inc/N_num_of_gap_incs)+x_start_pos
        y_pos = (core_side_depth - core_gap_depth)+y_start_pos
        pnt = gmsh.model.occ.addPoint(x_pos, y_pos, 0)
        point.append(pnt) 
        
        # Points up third right tooth gap (right to left)...
    for y_inc in range(N_num_of_tooth_side_incs):
        x_pos = (core_base_length - 3.0*tooth_width - 3.0*core_gap)+x_start_pos
        y_pos = (core_side_depth - core_gap_depth*(1.0 - y_inc/N_num_of_tooth_side_incs))+y_start_pos
        pnt = gmsh.model.occ.addPoint(x_pos, y_pos, 0)
        point.append(pnt)   
        
        # Points along forth right tooth (right to left)...
    for x_inc in range(N_num_of_top_tooth_incs):
        x_pos = (core_base_length - tooth_width*x_inc/N_num_of_top_tooth_incs - 3.0*tooth_width - 3.0*core_gap)+x_start_pos
        y_pos = (core_side_depth)+y_start_pos
        pnt = gmsh.model.occ.addPoint(x_pos, y_pos, 0)
        point.append(pnt)         
        
# xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx        
        
        # Points down forth right tooth gap (right to left)...
    for y_inc in range(N_num_of_tooth_side_incs):
        x_pos = (core_base_length - 4.0*tooth_width - 3.0*core_gap)+x_start_pos
        y_pos = (core_side_depth - core_gap_depth*y_inc/N_num_of_tooth_side_incs)+y_start_pos
        pnt = gmsh.model.occ.addPoint(x_pos, y_pos, 0)
        point.append(pnt)   
        
        # Points along forth right gap (right to left)...
    for x_inc in range(N_num_of_gap_incs):
        x_pos = (core_base_length - 4.0*tooth_width - 3.0*core_gap - core_gap*x_inc/N_num_of_gap_incs)+x_start_pos
        y_pos = (core_side_depth - core_gap_depth)+y_start_pos
        pnt = gmsh.model.occ.addPoint(x_pos, y_pos, 0)
        point.append(pnt) 
        
        # Points up third right tooth gap (right to left)...
    for y_inc in range(N_num_of_tooth_side_incs):
        x_pos = (core_base_length - 4.0*tooth_width - 4.0*core_gap)+x_start_pos
        y_pos = (core_side_depth - core_gap_depth*(1.0 - y_inc/N_num_of_tooth_side_incs))+y_start_pos
        pnt = gmsh.model.occ.addPoint(x_pos, y_pos, 0)
        point.append(pnt)   
        
        # Points along fifth right tooth (right to left)...
    for x_inc in range(N_num_of_top_tooth_incs):
        x_pos = (core_base_length - tooth_width*x_inc/N_num_of_top_tooth_incs - 4.0*tooth_width - 4.0*core_gap)+x_start_pos
        y_pos = (core_side_depth)+y_start_pos
        pnt = gmsh.model.occ.addPoint(x_pos, y_pos, 0)
        point.append(pnt)                 
        
        
# xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx        
        
        # Points down the left side of core...
    for y_inc in range(N_num_of_core_side_incs):
        x_pos = (core_base_length - 5.0*tooth_width - 4.0*core_gap)+x_start_pos
        y_pos = (core_side_depth*(1.0 - y_inc/N_num_of_core_side_incs))+y_start_pos
        pnt = gmsh.model.occ.addPoint(x_pos, y_pos, 0)
        point.append(pnt)     
        
        
    line = []   
                                                 #Rev_3 has 5 teeth and 4 gaps                
    N_num_incs = N_num_of_core_base_incs + 2*N_num_of_core_side_incs + 5*N_num_of_top_tooth_incs + 4*N_num_of_gap_incs + 8*N_num_of_tooth_side_incs



    for pnt_inc in range(N_num_incs):
        if pnt_inc == N_num_incs - 1:
            line_seg = gmsh.model.occ.addLine(point[pnt_inc], point[0])
        else:   
            line_seg = gmsh.model.occ.addLine(point[pnt_inc], point[pnt_inc+1])
        line.append(line_seg)



    cl = gmsh.model.occ.addCurveLoop(line)
    core = gmsh.model.occ.addPlaneSurface([cl])   
                                                #Rev_3 has 4 gaps
    core_mass = core_base_length * core_side_depth - 4.0 * core_gap * core_gap_depth  
    
    rtn_vals = []

    rtn_vals.append(core_mass)
    rtn_vals.append(core)
    return rtn_vals