
import gmsh


def GenerateConductionPlate_copper(y_axis_start, x_axis_start):
    
    copper_thickness = .01
    
    plate_length = .7           # 20 mm length is the smallest stage. Make the plate 18 mm
    
    gmsh.model.occ.synchronize()
    
    N_num_x_incs = 100
    N_num_y_incs = 4
    
    point = []
    
        # Points along the bottom of the copper plate (right to left)
    for x_inc in range(N_num_x_incs):
        x_pos = (plate_length*x_inc/N_num_x_incs)+x_axis_start 
        y_pos = (0)+y_axis_start
        pnt = gmsh.model.occ.addPoint(x_pos, y_pos, 0)
        point.append(pnt)
        
        #Points up the right side of the copper plate...
    for y_inc in range(N_num_y_incs):
        x_pos = (plate_length)+x_axis_start 
        y_pos = (copper_thickness*y_inc/N_num_y_incs)+y_axis_start
        pnt = gmsh.model.occ.addPoint(x_pos, y_pos, 0)
        point.append(pnt)        
        
        # Points along the top of the copper plate (left to right)
    for x_inc in range(N_num_x_incs):
        x_pos = (plate_length*(1.0 - x_inc/N_num_x_incs))+x_axis_start 
        y_pos = (copper_thickness)+y_axis_start
        pnt = gmsh.model.occ.addPoint(x_pos, y_pos, 0)
        point.append(pnt)        
        
        #Points down the left side of the copper plate...
    for y_inc in range(N_num_y_incs):
        x_pos = (0)+x_axis_start 
        y_pos = (copper_thickness*(1.0 - y_inc/N_num_y_incs))+y_axis_start
        pnt = gmsh.model.occ.addPoint(x_pos, y_pos, 0)
        point.append(pnt)            
        
    line = []   

    N_num_incs = 2 * N_num_x_incs + 2 * N_num_y_incs



    for pnt_inc in range(N_num_incs):
        if pnt_inc == N_num_incs - 1:
            line_seg = gmsh.model.occ.addLine(point[pnt_inc], point[0])
        else:   
            line_seg = gmsh.model.occ.addLine(point[pnt_inc], point[pnt_inc+1])
        line.append(line_seg)



    cl = gmsh.model.occ.addCurveLoop(line)
    plate = gmsh.model.occ.addPlaneSurface([cl])   

    plate_mass = plate_length * copper_thickness  
    
    rtn_vals = []

    rtn_vals.append(plate_mass)
    rtn_vals.append(plate)
    return rtn_vals        
        