#include <iostream>
#include <cmath>

double  *linsolve( double** A, int n, double * vec, int m, double &residual, int &flag);

int main(void) {

  double **A;
  double *rhs;
  double *x;
  double res = 0.0;
  int flag = 0;
  A = new double* [2];
  for (int i=0; i<2; i++) A[i] = new double [2];

  A[0][0] = 2.0;
  A[0][1] = A[1][0] = 0.0;
  A[1][1] = 4.0;

  // assign the right-hand-side...
  rhs = new double[2];
  rhs[0] = 7.0;
  rhs[1] = 8.0;

  x = linsolve( A, 2, rhs, 2, res, flag );

  for (int i=0; i<2; i++) {
    std::cout << x[i] << std::endl;
  }

  return 0;
}


double *linsolve( double** A, int n, double * vec, int m, double &residual, int &flag)
{
  // declare our variables...
  double **ab;
  double *x;
  int i,j,k,l,np1,nm1,kp1,bigindex;
  double sumr, rowmax, scale, big, tempb, tempi, qout, sum;
  ab = new double* [n];
  x = new double [n];

  // initialize our 2-D matrix to solve with...
  for (i=0; i<n; i++) ab[i] = new double [n+1];

  np1 = n+1;
  nm1 = n-1;
  // the columns of AB are [A, vec]
  for (i=0; i<n; i++) {
    rowmax = 0.0;
    for (j=0; j<n; j++) {
      rowmax = rowmax > fabs( A[i][j] ) ? rowmax : fabs(A[i][j]);
    }
    // if the vector is NULL (zero-filled), then there is no solution
    if ( rowmax == 0.0 ) {
      flag = -1;
      return( NULL );
    }
    
    // scale and assign values for AB...
    scale = 1.0 / rowmax;
    for (j=0; j<n; j++) {
      ab[i][j] = A[i][j] * scale;
    }
    ab[i][n] = vec[i] * scale;
  }


  // begin the elimination loop where rows of AB are interchanged to bring into 
  // alignment for pivotal positioning...
  for (k=0; k<n-1; k++) {
    big = 0.0;
    for (i=k; i<n; i++) {
      tempb = fabs( A[i][k] );
      if ( big >= tempb ) continue;
      big = tempb;
      bigindex = i;
    }

    // again if we have a null vector then bail out...
    if ( big == 0.0 ) {
      flag = -2;
      return NULL;
    }

    // interchange rows (if we're not in the same row..)...
    if ( bigindex != k ) {
      for (i=k; i<n+1; i++) { 
	tempi = ab[k][i];
	ab[k][i] = ab[bigindex][i];
	ab[bigindex][i] = tempi;
      }
    }

    kp1 = k+1;
    
    // eliminate x(k) from equations 
    for (i=kp1; i<n; i++) {
      qout = ab[i][k] / ab[k][k];
      for (j=kp1; j<n+1; j++) {
	ab[i][j] = ab[i][j] - qout * ab[k][j];
      }
    }
  } // end of elimination loop

  //begin the calculation of the solution vector using back substitution...
  if ( ab[n-1][n-1] == 0.0 ) {
    // no solution 
    flag = -3;
    return NULL;
  }

  x[n-1] = ab[n-1][n] / ab[n-1][n-1];
  for (i=1; i<=n; i++) {
    k = n - i;
    sum = 0.0;
    for (j=k+1; j<n; j++) {
      sum += ab[k][j] * x[j];
    }
    x[k] = ( ab[k][n] - sum ) / ab[k][k];
  }

  // calculate the maximum residual...
  residual = 0.0;
  for (i=0; i<n; i++) {
    sumr = 0.0;
    for (j=0; j<n; j++) {
      sumr += A[i][j] * x[j];
      residual = residual > fabs(sumr-vec[i]) ? residual : fabs(sumr-vec[i]);
      flag = 0;
    }
  }
  
  return( x );
}
