fc_1 = 50; % Cut-off frequency (Hz) for "high" pass filter.
fc_2 = 200; % Cut-off frequency (Hz) for "low" pass filter.
fs = 20000; % Sampling rate (Hz)
order = 2; % Filter order
% [B,A] = butter(order,[2*fc_1/fs 2*fc_2/fs]) % [0:pi] maps to [0:1] here
[B_1,A_1] = butter(order, 2*fc_1/fs, "high") % [0:pi] maps to [0:1] here 
[B_2,A_2] = butter(order, 2*fc_2/fs, "low") % [0:pi] maps to [0:1] here 

load iq_actual.dat
lng=length(iq_actual);
t = 0:.000050:.000050*(lng-1);

% y = filter(B,A,iq_actual);

y_1 = filter(B_1,A_1,iq_actual);
y = filter(B_2,A_2, y_1);

plot(t,y, ';Filtered iq_actual (octave derived);'); 

load iq_actual_filtered.dat

	% Close. Octave filter() seems to show better passband result, why?
% plot(t,y, ';Filtered iq_actual (octave derived);', t, iq_actual_filtered, ';iq_actual_filtered from simulator;'); 
