#ifndef __foc_and_dtc_svm_tests_hpp__
#define __foc_and_dtc_svm_tests_hpp__


//Reference: /home/maiello/Desktop/Development-Simulation/InductionMotor_DTC_SVM/controlSUITE_ref/v4.3/cur_mod.h


#include "controlSuite.hpp"




#define FOC_AND_DTC_SVM_TEST_NUM  1
//
//      1 - Control algorythm
//      2 - Measure L/R rotor time constant.
//
//
//
//      NOTE: Assumes the following:
//
//          TRIANGLE_REF_MODE - undefined.
//          LINEAR_AMP_MODE - undefined.
//              (both of the above "undefined" implies "Space-Vector PWM mode")
//
//          FREQUENCY_SWEEP_MODE - undefined
//              (implies that we are running tests defined by FOC_AND_DTC_SVM_TEST_NUM in this file).
//
//
//      INPORTANT: I noticed at this point that  h_max = .00002 in App_InductionMotor_DTC_SVM.hpp which effectively
//                 forces QUANTUM_PERIOD to be set at this same value! (It is set to .0000125).
//                 In other words EVERYTHING (including the CtrlObj's) are running at .00002 update.
//                 Will leave this be for now.
//
//
//      IMPORTANT: Also, at this point, determined that we had to change change h_start = .000001;  "fixed".
//                 Before doing this, notices that $h showed a max 1.2x10-5 peak but jumps around!
//                 After this change, this looks the best for omega_r and irdqd.
//                 Without changes this a strange disturbance was happening at around 2.0 seconds in simulation time.
//                 (probably in other points in time as well but less pronounced).

    // Define for executing fix-point version of the control model below.
//#define PU_MODEL


double theta_ctrl = 0;

int FOC_and_DTC_special_plotting = 0;
double VCmd_a_custom;     //VCmd_a
double VCmd_b_custom;     //VCmd_b
double VCmd_mag_custom;   //VCmd_mag
double VCmd_ang_custom;   //VCmd_ang





#if (FOC_AND_DTC_SVM_TEST_NUM == 1)

double IdRef;
fpt IdRef_fix;

double vdd_fix;
double vqd_fix;
double theta_ctrl_fix;




void FOC_and_DTC_SVM_init(void)
{
    init_cm1();
    init_pi_spd_pi_id_pi_iq();

    init_cm1_fix();
    init_pi_spd_pi_id_pi_iq_fix();

    FOC_and_DTC_special_plotting = 1;




}

void FOC_and_DTC_SVM_tests_fast(double t)
{


}

void FOC_and_DTC_SVM_tests(double t)
{

    //      "printf("%g  \n", t);" verifies 50 uSec update here.


    //From /home/maiello/Desktop/Development-Simulation/InductionMotor_DTC_SVM/controlSUITE_ref/HVACI_Sensored/HVACI_Sensored.c


    // =============================== LEVEL 5 ======================================
    //  Level 5 verifies verifies the speed regulator performed by PI module.
    //  The system speed loop is closed by using the measured speed from capture
    //  signal as a feedback.
    // ==============================================================================

//#ifdef PU_MODEL     //!!!! Temporarily commented out !!!!!

    // ------------------------------------------------------------------------------
    //  Measure phase currents, subtract the offset and normalize from (-0.5,+0.5) to (-1,+1).
    //  Connect inputs of the CLARKE module and call the clarke transformation macro
    // ------------------------------------------------------------------------------
        clarke1_fix.As = is[0];       // Phase A curr.
        clarke1_fix.Bs = is[1];       // Phase B curr.
        clarke1_fix.Cs = is[2];       // Phase C curr.
        CLARKE1_MACRO_fix(clarke1_fix)

    // ------------------------------------------------------------------------------
    //  Connect inputs of the PARK module and call the park trans. macro
    // ------------------------------------------------------------------------------
        park1_fix.Alpha = clarke1_fix.Alpha;
        park1_fix.Beta  = clarke1_fix.Beta;
        park1_fix.Angle = cm1_fix.Theta;
        park1_fix.Sine  = sin(fpt2fl(park1_fix.Angle) * 6.283185307);  // NOTE: In the actual C2000 implementation the RG_MACRO was used in place with fpt2fl().
        park1_fix.Cosine= cos(fpt2fl(park1_fix.Angle) * 6.283185307);  //       The code here is just to maintain equivalence with the double precision model.
        PARK_MACRO_fix(park1_fix)


        // ------------------------------------------------------------------------------
        //  Connect inputs of the PI module and call the PID IQ controller macro
        // ------------------------------------------------------------------------------

        pi_spd_fix.Ref = fl2fpt((float) omegad);
        pi_spd_fix.Fbk = fl2fpt((float) omega_r);
        PI_MACRO_fix(pi_spd_fix)


        // ------------------------------------------------------------------------------
        //  Connect inputs of the PI module and call the PID IQ controller macro
        // ------------------------------------------------------------------------------
        pi_iq_fix.Ref = pi_spd_fix.Out;
        pi_iq_fix.Fbk = park1_fix.Qs;
        PI_MACRO_fix(pi_iq_fix)

        //MEA: Not sure what constant to set for IdRef. TI ref design as this set via IdRef     = _IQ(0.1);
        IdRef_fix = fl2fpt(20);

        // ------------------------------------------------------------------------------
        //  Connect inputs of the PI module and call the PID ID controller macro
        // ------------------------------------------------------------------------------
        pi_id_fix.Ref = IdRef_fix;
        pi_id_fix.Fbk = park1_fix.Ds;
        PI_MACRO_fix(pi_id_fix)

        // ------------------------------------------------------------------------------
        //  Connect inputs of the INV_PARK module and call the inverse park trans. macro
        //  (In our model, pi_id connects to vdd and pi_iq connects to vqd. We use are own SV PWM algorithm which takes care of INV_PARK calculation)
        // ------------------------------------------------------------------------------
        vdd_fix = (double) fpt2fl(pi_id_fix.Out);
        vqd_fix = (double) fpt2fl(pi_iq_fix.Out);
        theta_ctrl_fix = (double) (fpt2fl(cm1_fix.Theta) * 6.283185307);


        // ------------------------------------------------------------------------------
        //    Connect inputs of the CUR_MOD module and call the current model
        //    calculation function.
        // ------------------------------------------------------------------------------
        cm1_fix.IDs = park1_fix.Ds;
        cm1_fix.IQs = park1_fix.Qs;
        cm1_fix.Wr = omega_r;
        CUR_MOD_MACRO_fix(cm1_fix)


//#else               //!!!! Temporarily commented out !!!!!

    // ------------------------------------------------------------------------------
    //  Measure phase currents, subtract the offset and normalize from (-0.5,+0.5) to (-1,+1).
    //  Connect inputs of the CLARKE module and call the clarke transformation macro
    // ------------------------------------------------------------------------------
        clarke1.As = is[0];       // Phase A curr.
        clarke1.Bs = is[1];       // Phase B curr.
        clarke1.Cs = is[2];       // Phase C curr.
        CLARKE1_MACRO(clarke1)

    // ------------------------------------------------------------------------------
    //  Connect inputs of the PARK module and call the park trans. macro
    // ------------------------------------------------------------------------------
        park1.Alpha = clarke1.Alpha;
        park1.Beta  = clarke1.Beta;
        park1.Angle = cm1.Theta;
        park1.Sine  = sin(park1.Angle);
        park1.Cosine= cos(park1.Angle);
        PARK_MACRO(park1)

        // ------------------------------------------------------------------------------
        //  Connect inputs of the PI module and call the PID IQ controller macro
        // ------------------------------------------------------------------------------

        pi_spd.Ref = omegad;
        pi_spd.Fbk = omega_r;
        PI_MACRO(pi_spd)


        // ------------------------------------------------------------------------------
        //  Connect inputs of the PI module and call the PID IQ controller macro
        // ------------------------------------------------------------------------------
        pi_iq.Ref = pi_spd.Out;
        pi_iq.Fbk = park1.Qs;
        PI_MACRO(pi_iq)

        //MEA: Not sure what constant to set for IdRef. TI ref design as this set via IdRef     = _IQ(0.1);
        IdRef = 20;

        // ------------------------------------------------------------------------------
        //  Connect inputs of the PI module and call the PID ID controller macro
        // ------------------------------------------------------------------------------
        pi_id.Ref = IdRef;
        pi_id.Fbk = park1.Ds;
        PI_MACRO(pi_id)

        // ------------------------------------------------------------------------------
        //  Connect inputs of the INV_PARK module and call the inverse park trans. macro
        //  (In our model, pi_id connects to vdd and pi_iq connects to vqd. We use are own SV PWM algorithm which takes care of INV_PARK calculation)
        // ------------------------------------------------------------------------------
        vdd = pi_id.Out;
        vqd = pi_iq.Out;
        theta_ctrl = cm1.Theta;

        // ------------------------------------------------------------------------------
        //    Connect inputs of the CUR_MOD module and call the current model
        //    calculation function.
        // ------------------------------------------------------------------------------
        cm1.IDs = park1.Ds;
        cm1.IQs = park1.Qs;
        cm1.Wr = omega_r;
        CUR_MOD_MACRO(cm1)



//#endif         //!!!! Temporarily commented out !!!!!


        //!!!!!!! Test only !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

    //    VCmd_a_custom = clarke1.Alpha;                              //  OK
    //    VCmd_b_custom = clarke1_fix.Alpha / (double) FPT_ONE;       //

    //    VCmd_a_custom = clarke1.Beta;                              //  OK
    //    VCmd_b_custom = clarke1_fix.Beta / (double) FPT_ONE;       //

       //        VCmd_a_custom = park1.Sine;                                   //  NO good!!!!
      //           VCmd_b_custom = park1_fix.Sine / (double) FPT_ONE;          //

    //       VCmd_a_custom = park1.Ds;                               // OK
    //       VCmd_b_custom = park1_fix.Ds / (double) FPT_ONE;        //

    //        VCmd_a_custom = park1.Qs;                               // OK
   //         VCmd_b_custom = park1_fix.Qs / (double) FPT_ONE;        //           (running away because open loop?)

    //         VCmd_a_custom = cm1.IMDs;                                    // OK
    //         VCmd_b_custom = cm1_fix.IMDs / (double) FPT_ONE;             //

   //     VCmd_a_custom = cm1.Wslip;                                    // OK
   //     VCmd_b_custom = cm1_fix.Wslip / (double) FPT_ONE;             //

      //       VCmd_a_custom = cm1.We;
      //       VCmd_b_custom = cm1_fix.We / (double) FPT_ONE;

   //          VCmd_a_custom = cm1.Theta;                               //OK (somewhat)
   //          VCmd_b_custom = cm1_fix.Theta / (double) FPT_ONE;        // (need gain adjustment?)


    //    VCmd_a_custom = pi_spd.Out;                                   // OK
    //    VCmd_b_custom = pi_spd_fix.Out / (double) FPT_ONE;            //

     //       VCmd_a_custom = pi_iq.Out;                                   // OK
     //       VCmd_b_custom = pi_iq_fix.Out / (double) FPT_ONE;            //      (running away because open loop?)

    //    VCmd_a_custom = pi_id.Out;                                            // OK
     //   VCmd_b_custom = pi_id_fix.Out / (double) FPT_ONE;                    //      (running away because open loop?)

        // ##### override #######

         vdd = vdd_fix;                                         // Little poorer performance but I think it is working!
         vqd = vqd_fix;                                         // (may need gain adjustment? Voltage is +/100 so I do not think we can bump Q up.)
         theta_ctrl = theta_ctrl_fix;

        VCmd_a_custom = theta_ctrl;

        // ###########################

        // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

}

#endif




#if (FOC_AND_DTC_SVM_TEST_NUM == 2)

FILE * fp_v_0_rotor_inductance;
FILE * fp_v_0_stator_rotor_inductance;

#undef Ti
//#define Ti 0                 // No load
#define Ti (1000 * omega_r)    //Essentially, locked rotor.

void FOC_and_DTC_SVM_init(void)
{
    FOC_and_DTC_special_plotting = 1;

    fp_v_0_rotor_inductance = fopen("v_0_rotor_inductance.dat", "w");
    fp_v_0_stator_rotor_inductance = fopen("v_0_stator_rotor_inductance.dat", "w");
}

void FOC_and_DTC_SVM_tests_fast(double t)
{
    if((t > 2.0) && (t < 3.0))
    {
        fprintf(fp_v_0_rotor_inductance, "%g\n", d_ir[0]*Mrr[0][0] + d_ir[1]*Mrr[0][1] + d_ir[2]*Mrr[0][2]);
        fprintf(fp_v_0_stator_rotor_inductance, "%g\n", d_is[0] * cal_MSR[0][0] + d_is[1] * cal_MSR[1][0] + d_is[2] * cal_MSR[2][0]);
    }
    else if((t >= 3.0) && fp_v_0_rotor_inductance)
    {
        fclose(fp_v_0_rotor_inductance);
        fclose(fp_v_0_stator_rotor_inductance);
        fp_v_0_rotor_inductance = 0;
    }




}


void FOC_and_DTC_SVM_tests(double t)
{

    // Setting Lr = 2.71067e-06 or Ts = .0005 gives the effect we want. This makes the gain 10x from the specified Lr/Rr. Find out why.


    //Do this next using this info

    //     d_is[0]*Msr[theta_r][0][0]  +
    //     d_is[1]*Msr[theta_r][1][0]  +
    //     d_is[2]*Msr[theta_r][2][0]  + d_ir[0]*Mrr[0][0] +
    //                                   d_ir[1]*Mrr[0][1] +
    //                                   d_ir[2]*Mrr[0][2]            .......

    //With a conditionally controlled variable,
    //
    // Fix ..
    // vr1 = d_is[0]*Msr[theta_r][0][0] + d_is[1]*Msr[theta_r][1][0] + d_is[2]*Msr[theta_r][2][0]    <== this is the impressed voltage...
    //   or
    // vr1 = d_ir[0]*Mrr[0][0] + d_ir[1]*Mrr[0][1] + d_ir[2]*Mrr[0][2]                               <== voltage across rotor phase inductance (with ir[0] we can see real/reactive power?)

    //  dido for vr2 and vr3
    //
    //  To do this we need to add global variables d_is[3] and d_ir[3] and assign where dy/dt's are computed for current.

    vqd = .5 * DC_BUS_VOLTAGE;
    vdd = 0;




#define LOCK_ROTOR_OR_NO_LOAD
#ifdef LOCK_ROTOR_OR_NO_LOAD
    theta_ctrl += .0188 * omegad; //60 Hz with VO_TRAJ = 1
#else
    theta_ctrl = PI/2;
#endif


#define STATOR_MEASURE
#ifdef STATOR_MEASURE
 //   VCmd_a_custom = (V_xo[0] - V_xo[1]) * DC_BUS_VOLTAGE / PWM_GAIN;
  //  VCmd_b_custom = is[0];
 //   VCmd_mag_custom = VCmd_a_custom * VCmd_b_custom;

        //P_BR_15
    VCmd_mag_custom = is[0] * (V_xo[0] - V_xo[1]) * DC_BUS_VOLTAGE / PWM_GAIN;

    VCmd_a_custom = is[0] * is[0];

#else
    VCmd_mag_custom = V_xo[0] * DC_BUS_VOLTAGE / PWM_GAIN;




#endif


        //Before going any further here there is a problem T_Z_SCALED should equal T_Z. With T1 and T2 zero
        //why are we still seeing offset on V_xo_local relative to triangle wave??
}

#endif


#if (FOC_AND_DTC_SVM_TEST_NUM == 3)





#endif



#endif
