#ifndef __controlSuite_hpp__
#define __controlSuite_hpp__






#define FPT_WBITS 8               //It looks like in IQmathLib.h, HVACI_Sensored.c is using  GLOBAL_Q == 24
                                  //NOTE: Here FPT_WBITS means size of integer not fraction! (Reversed meaning to GLOBAL_Q in TI IQ MATH)
                                   //According to various links including to this one (https://s2.smu.edu/~mitch/class/5385/DSPArithmeticTutorial.pdf)
                                   //IQMathLib.h is where this is set.
#include "./fptc-lib/src/fptc.h"







// ***** CUR_MOD_MACRO and CUR_CONST_MACRO Macros ********************************************************************************************************************

    //From: /home/maiello/Desktop/Development-Simulation/InductionMotor_DTC_SVM/controlSUITE_ref/v4.3/cur_mod.h


//File name:       CUR_MOD.H
//===================================================================================*/
//#ifndef __CUR_MOD_H__
//#define __CUR_MOD_H__
//
//typedef struct  { _iq  IDs;         // Input: Syn. rotating d-axis current (pu)
//                  _iq  IQs;         // Input: Syn. rotating q-axis current (pu)
//                  _iq  Wr;          // Input: Rotor electrically angular velocity (pu)
//                  _iq  IMDs;        // Variable: Syn. rotating d-axis magnetizing current (pu)
//                  _iq  Theta;       // Output: Rotor flux angle (pu)
//                  _iq  Kr;          // Parameter: constant using in magnetizing current calculation
//                  _iq  Kt;          // Parameter: constant using in slip calculation
//                  _iq  K;           // Parameter: constant using in rotor flux angle calculation
//                  _iq  Wslip;       // Variable: Slip
//                  _iq  We;          // Variable: Angular freq of the stator
//                } CURMOD;
//
//
///*-----------------------------------------------------------------------------
//Default initalizer for the CURMOD object.
//-----------------------------------------------------------------------------*/
//#define CURMOD_DEFAULTS { 0,0,0,0,0, \
//                          0,0,0,0,0 \
//                       }
//
///*------------------------------------------------------------------------------
// CUR_MOD Macro Definition
//------------------------------------------------------------------------------*/
//
//
//#define CUR_MOD_MACRO(v)                            \
//    v.IMDs +=  _IQmpy(v.Kr,(v.IDs - v.IMDs));       \
//    v.Wslip = _IQdiv(_IQmpy(v.Kt,v.IQs),v.IMDs);    \
//    v.We = v.Wr + v.Wslip;                          \
//    v.Theta +=  _IQmpy(v.K,v.We);                   \
//                                                    \
//    if (v.Theta > _IQ(1))                           \
//       v.Theta -=  _IQ(1);                          \
//    else if (v.Theta < _IQ(0))                      \
//       v.Theta += _IQ(1);
//
////v.Theta=(v.Theta+_IQ(1.0))&& 0x00ffffff;
//
//#endif


    //From: /home/maiello/Desktop/Development-Simulation/InductionMotor_DTC_SVM/controlSUITE_ref/v4.3/cur_const.h

///* =================================================================================
//File name:       CUR_CONST.H
//===================================================================================*/
//#ifndef __CUR_CONST_H__
//#define __CUR_CONST_H__
//
//typedef struct  { float32  Rr;          // Input: Rotor resistance (ohm)
//                  float32  Lr;          // Input: Rotor inductance (H)
//                  float32  fb;          // Input: Base electrical frequency (Hz)
//                  float32  Ts;          // Input: Sampling period (sec)
//                  float32  Kr;          // Output: constant using in magnetizing current calculation
//                  float32  Kt;          // Output: constant using in slip calculation
//                  float32  K;           // Output: constant using in rotor flux angle calculation
//                  float32  Tr;          // Variable: Rotor time constant (sec)
//                } CURMOD_CONST;
//
//
///*-----------------------------------------------------------------------------
//Default initalizer for the CURMOD_CONST object.
//-----------------------------------------------------------------------------*/
//#define CURMOD_CONST_DEFAULTS { 0,0,0,0, \
//                                0,0,0,0  \
//                               }
//
///*------------------------------------------------------------------------------
// CUR_CONST Macro Definition
//------------------------------------------------------------------------------*/
//
//#define PI 3.14159265358979
//
//
//#define CUR_CONST_MACRO(v)      \
//    v.Tr = v.Lr/v.Rr;           \
//                                \
//    v.Kr = v.Ts/v.Tr;           \
//    v.Kt = 1/(v.Tr*2*PI*v.fb);  \
//    v.K = v.Ts*v.fb;
//
//#endif

    //From: /home/maiello/Desktop/Development-Simulation/InductionMotor_DTC_SVM/controlSUITE_ref/HVACI_Sensored/HVACI_Sensored.c

//// Initialize the CUR_MOD constant module
//    cm1_const.Rr = RR;
//    cm1_const.Lr = LR;
//    cm1_const.fb = BASE_FREQ;
//    cm1_const.Ts = T;
//    CUR_CONST_MACRO(cm1_const)


//See: Chaisson - Control of Electric Drives, Induction Motor Control Eq. 6 on Page 8 and
//           and "The rotor flux angle dynamics are then ..." on Page 12


// #### "fixed" version model ###########################################################################################################

typedef struct  { fpt   IDs;         // Input: Syn. rotating d-axis current (pu)
                  fpt   IQs;         // Input: Syn. rotating q-axis current (pu)
                  float Wr;          // Input: Rotor electrically angular velocity (pu)
                  fpt   IMDs;        // Variable: Syn. rotating d-axis magnetizing current (pu)
                  fpt   Theta;       // Output: Rotor flux angle (pu)
                  fpt   Kr;          // Parameter: constant using in magnetizing current calculation
                  fpt   Kt;          // Parameter: constant using in slip calculation
                  fpt   K;           // Parameter: constant using in rotor flux angle calculation
                  fpt   Wslip;       // Variable: Slip
                  fpt   We;          // Variable: Angular freq of the stator
                } CURMOD_fix;




typedef struct  { float  Rr;          // Input: Rotor resistance (ohm)
                  float  Lr;          // Input: Rotor inductance (H)
                  float  fb;          // Input: Base electrical frequency (Hz)
                  float  Ts;          // Input: Sampling period (sec)
                  float  Kr;          // Output: constant using in magnetizing current calculation
                  float  Kt;          // Output: constant using in slip calculation
                  float  K;           // Output: constant using in rotor flux angle calculation
                  float  Tr;          // Variable: Rotor time constant (sec)
                } CURMOD_CONST_fix;


#define CUR_CONST_MACRO_fix(v)      \
    v.Tr = v.Lr/v.Rr;           \
                                \
    v.Kr = v.Ts/v.Tr;           \
    v.Kt = 1/(v.Tr*2*PI*v.fb);  \
    v.K = v.Ts*v.fb;

fpt prev_IMDs_fix = FPT_ONE;
fpt guard__IMDS_zero_fix(fpt imds_val)
{
    if(imds_val == 0)
    {
        imds_val = prev_IMDs_fix;
    }
    else
    {
        prev_IMDs_fix = imds_val;
    }
    return imds_val;
}

#define CUR_MOD_MACRO_fix(v)                            \
    v.IMDs +=  fpt_mul(v.Kr,(v.IDs - v.IMDs));       \
    v.IMDs = guard__IMDS_zero_fix(v.IMDs);            \
    v.Wslip = fpt_div(fpt_mul(v.Kt,v.IQs),v.IMDs);    \
    v.We = fl2fpt(v.Wr) + v.Wslip;                          \
    v.Theta +=  fpt_mul(v.K,v.We);                   \
                                                    \
    if (v.Theta > FPT_ONE)                           \
       v.Theta -= FPT_ONE;                          \
    else if (v.Theta < fl2fpt(0))                      \
       v.Theta += FPT_ONE;




#define CURMOD_DEFAULTS_fix { 0,0,0,0,0, \
                          0,0,0,0,0 \
                       }

#define CURMOD_CONST_DEFAULTS_fix { 0,0,0,0, \
                                0,0,0,0  \
                               }

CURMOD_fix cm1_fix = CURMOD_DEFAULTS_fix;
CURMOD_CONST_fix cm1_const_fix = CURMOD_CONST_DEFAULTS_fix;

    // Setting Lr = 2.71067e-06 or Ts = .0005 gives the effect we want. This makes the gain 10x from the specified Lr/Rr. Find out why.
    // Setting to .01 also works and seems to provide a much higher gain but with instability. (NOTE: 100 is the turns ratio between Stator and Rotor conductors?)
#define Lr_Rr_SCALING_CONST  .1

void init_cm1_fix(void)
{

    // Initialize the CUR_MOD constant module     (Start with some values...)
    cm1_const_fix.Rr = (.0001);                               // RR;
    cm1_const_fix.Lr = (Lr_Rr_SCALING_CONST * 2.71067e-05);   // LR;
    cm1_const_fix.fb = .5 * VO_TRAJ /( 2 * PI);               // BASE_FREQ;
    cm1_const_fix.Ts = .00005;
    CUR_CONST_MACRO_fix(cm1_const_fix)

    // Initialize the CUR_MOD module
    cm1_fix.Kr = fl2fpt(cm1_const_fix.Kr);
    cm1_fix.Kt = fl2fpt(cm1_const_fix.Kt);
    cm1_fix.K  = fl2fpt(cm1_const_fix.K);

}



// ############################################################################################################################################

// #### "double" version model ################################################################################################################

typedef struct  { double  IDs;         // Input: Syn. rotating d-axis current (pu)
                  double  IQs;         // Input: Syn. rotating q-axis current (pu)
                  double  Wr;          // Input: Rotor electrically angular velocity (pu)
                  double  IMDs;        // Variable: Syn. rotating d-axis magnetizing current (pu)
                  double  Theta;       // Output: Rotor flux angle (pu)
                  double  Kr;          // Parameter: constant using in magnetizing current calculation
                  double  Kt;          // Parameter: constant using in slip calculation
                  double  K;           // Parameter: constant using in rotor flux angle calculation
                  double  Wslip;       // Variable: Slip
                  double  We;          // Variable: Angular freq of the stator
                } CURMOD;

typedef struct  { double  Rr;          // Input: Rotor resistance (ohm)
                  double  Lr;          // Input: Rotor inductance (H)
                  double  fb;          // Input: Base electrical frequency (Hz)
                  double  Ts;          // Input: Sampling period (sec)
                  double  Kr;          // Output: constant using in magnetizing current calculation
                  double  Kt;          // Output: constant using in slip calculation
                  double  K;           // Output: constant using in rotor flux angle calculation
                  double  Tr;          // Variable: Rotor time constant (sec)
                } CURMOD_CONST;


#define CUR_CONST_MACRO(v)      \
    v.Tr = v.Lr/v.Rr;           \
                                \
    v.Kr = v.Ts/v.Tr;           \
    v.Kt = 1/(v.Tr*2*PI*v.fb);  \
    v.K = v.Ts*v.fb;


double prev_IMDs = 1.0;
double guard__IMDS_zero(double imds_val)
{
    if(imds_val == 0)
    {
        imds_val = prev_IMDs;
    }
    else
    {
        prev_IMDs = imds_val;
    }
    return imds_val;
}
double saturate(double sum, double max, double min);  //(defined below)

#define CUR_MOD_MACRO(v)                            \
    v.IMDs +=  v.Kr * (v.IDs - v.IMDs);              \
    v.IMDs = guard__IMDS_zero(v.IMDs);                    \
    v.Wslip =  saturate(v.Kt * v.IQs / v.IMDs, PI/.00005, -PI/.00005);    \
    v.We = v.Wr + v.Wslip;                          \
    v.Theta +=  v.K * v.We;                   \
                                                    \
    if (v.Theta > 2*PI)                           \
       v.Theta -=  2*PI;                          \
    else if (v.Theta < 2*PI)                      \
       v.Theta += 2*PI;

#define CURMOD_DEFAULTS { 0,0,0,0,0, \
                          0,0,0,0,0 \
                       }

#define CURMOD_CONST_DEFAULTS { 0,0,0,0, \
                                0,0,0,0  \
                               }

CURMOD cm1 = CURMOD_DEFAULTS;
CURMOD_CONST cm1_const = CURMOD_CONST_DEFAULTS;

    // Setting Lr = 2.71067e-06 or Ts = .0005 gives the effect we want. This makes the gain 10x from the specified Lr/Rr. Find out why.
    // Setting to .01 also works and seems to provide a much higher gain but with instability. (NOTE: 100 is the turns ratio between Stator and Rotor conductors?)
#define Lr_Rr_SCALING_CONST  .1

void init_cm1(void)
{

    // Initialize the CUR_MOD constant module     (Start with some values...)
    cm1_const.Rr = (.0001);                               // RR;
    cm1_const.Lr = (Lr_Rr_SCALING_CONST * 2.71067e-05);   // LR;
    cm1_const.fb = .5 * VO_TRAJ /( 2 * PI);               // BASE_FREQ;
    cm1_const.Ts = .00005;
    CUR_CONST_MACRO(cm1_const)

    // Initialize the CUR_MOD module
    cm1.Kr = cm1_const.Kr;
    cm1.Kt = cm1_const.Kt;
    cm1.K  = cm1_const.K;




}

// ############################################################################################################################################



// ************************************************************************************************************************************

// ***** PI_MACRO  Macro ********************************************************************************************************************

    //From: /home/maiello/Desktop/Development-Simulation/InductionMotor_DTC_SVM/controlSUITE_ref/v4.3/pi.h


///* =================================================================================
//File name:       PI.H
//===================================================================================*/
//
//
//#ifndef __PI_H__
//#define __PI_H__
//
//typedef struct {  _iq  Ref;             // Input: reference set-point
//                  _iq  Fbk;             // Input: feedback
//                  _iq  Out;             // Output: controller output
//                  _iq  Kp;              // Parameter: proportional loop gain
//                  _iq  Ki;              // Parameter: integral gain
//                  _iq  Umax;            // Parameter: upper saturation limit
//                  _iq  Umin;            // Parameter: lower saturation limit
//                  _iq  up;              // Data: proportional term
//                  _iq  ui;              // Data: integral term
//                  _iq  v1;              // Data: pre-saturated controller output
//                  _iq  i1;              // Data: integrator storage: ui(k-1)
//                  _iq  w1;              // Data: saturation record: [u(k-1) - v(k-1)]
//                } PI_CONTROLLER;
//
//
///*-----------------------------------------------------------------------------
//Default initalisation values for the PI_GRANDO objects
//-----------------------------------------------------------------------------*/
//
//#define PI_CONTROLLER_DEFAULTS {        \
//                           0,           \
//                           0,           \
//                           0,           \
//                           _IQ(1.0),    \
//                           _IQ(0.0),    \
//                           _IQ(1.0),    \
//                           _IQ(-1.0),   \
//                           _IQ(0.0),    \
//                           _IQ(0.0),    \
//                           _IQ(0.0),    \
//                           _IQ(0.0),    \
//                           _IQ(1.0)     \
//                          }
//
///*------------------------------------------------------------------------------
//    PI_GRANDO Macro Definition
//------------------------------------------------------------------------------*/
//
//#define PI_MACRO(v)                                             \
//                                                                \
//    /* proportional term */                                     \
//    v.up = _IQmpy(v.Kp, (v.Ref - v.Fbk));                       \
//                                                                \
//    /* integral term */                                         \
//    v.ui = (v.Out == v.v1)?(_IQmpy(v.Ki, v.up)+ v.i1) : v.i1;   \
//    v.i1 = v.ui;                                                \
//                                                                \
//    /* control output */                                        \
//    v.v1 = v.up + v.ui;                                         \
//    v.Out= _IQsat(v.v1, v.Umax, v.Umin);                        \
//    //v.w1 = (v.Out == v.v1) ? _IQ(1.0) : _IQ(0.0);             \
//
//// ***********************************************************************************
////   This macro works with angles as inputs, hence error is rolled within -pi to +pi
//// ***********************************************************************************
//#define PI_POS_MACRO(v)                                         \
//    /* proportional term */                                     \
//    v.up = v.Ref - v.Fbk;                                       \
//    if (v.up >= _IQ(0.5))                                       \
//      v.up -= _IQ(1.0);             /* roll in the error */     \
//    else if (v.up <= _IQ(-0.5))                                 \
//      v.up += _IQ(1.0);             /* roll in the error */     \
//                                                                \
//    /* integral term */                                         \
//    v.up = _IQmpy(v.Kp, v.up);                                  \
//    v.ui = (v.Out == v.v1)?(_IQmpy(v.Ki, v.up)+ v.i1) : v.i1;   \
//    v.i1 = v.ui;                                                \
//                                                                \
//    /* control output */                                        \
//    v.v1 = v.up + v.ui;                                         \
//    v.Out= _IQsat(v.v1, v.Umax, v.Umin);                        \
//    //v.w1 = (v.Out == v.v1) ? _IQ(1.0) : _IQ(0.0);             \
//
//
//#endif // __PI_H__



// #### "fixed" version model #################################################################################################################

fpt saturate_fix(fpt sum, fpt max, fpt min)
{

        //Read this:  https://e2e.ti.com/support/microcontrollers/c2000-microcontrollers-group/c2000/f/c2000-microcontrollers-forum/1217249/tmdscncd28335-__iqsat-definition-missing-using-pid_grando_iq-function-from-the-solar-library
        //            https://www.ti.com.cn/cn/lit/ug/spru430f/spru430f.pdf  (TMS320C28x CPU and Instruction Set Reference Guide)
    if((sum > 0) && (sum > max))
       return max;
    else if((sum < 0) && (sum < min))
       return min;
    else
       return sum;

}

typedef struct {  fpt  Ref;             // Input: reference set-point
                  fpt  Fbk;             // Input: feedback
                  fpt  Out;             // Output: controller output
                  fpt  Kp;              // Parameter: proportional loop gain
                  fpt  Ki;              // Parameter: integral gain
                  fpt  Umax;            // Parameter: upper saturation limit
                  fpt  Umin;            // Parameter: lower saturation limit
                  fpt  up;              // Data: proportional term
                  fpt  ui;              // Data: integral term
                  fpt  v1;              // Data: pre-saturated controller output
                  fpt  i1;              // Data: integrator storage: ui(k-1)
                  fpt  w1;              // Data: saturation record: [u(k-1) - v(k-1)]
                } PI_CONTROLLER_fix;


#define PI_MACRO_fix(v)                                         \
                                                                \
    /* proportional term */                                     \
    v.up = fpt_mul(v.Kp, (v.Ref - v.Fbk));                      \
                                                                \
    /* integral term */                                         \
    v.ui = (v.Out == v.v1)?(fpt_mul(v.Ki, v.up)+ v.i1) : v.i1;  \
    v.i1 = v.ui;                                                \
                                                                \
    /* control output */                                        \
    v.v1 = v.up + v.ui;                                         \
    v.Out= saturate_fix(v.v1, v.Umax, v.Umin);                  \
    //v.w1 = (v.Out == v.v1) ? _IQ(1.0) : _IQ(0.0);             \


#define PI_CONTROLLER_DEFAULTS_fix {     \
                    fl2fpt(0),           \
                    fl2fpt(0),           \
                    fl2fpt(0),           \
                    fl2fpt(1.0),         \
                    fl2fpt(0.0),         \
                    fl2fpt(1.0),         \
                    fl2fpt(-1.0),        \
                    fl2fpt(0.0),         \
                    fl2fpt(0.0),         \
                    fl2fpt(0.0),         \
                    fl2fpt(0.0),         \
                    fl2fpt(1.0)          \
                                  }

PI_CONTROLLER_fix pi_spd_fix = PI_CONTROLLER_DEFAULTS_fix;
PI_CONTROLLER_fix pi_id_fix = PI_CONTROLLER_DEFAULTS_fix;
PI_CONTROLLER_fix pi_iq_fix = PI_CONTROLLER_DEFAULTS_fix;

uint16_t SpeedLoopPrescaler_fix = 10;

void init_pi_spd_pi_id_pi_iq_fix(void)
{
    // Initialize the PI module for Id
        pi_spd_fix.Kp=fl2fpt(50.0);
        pi_spd_fix.Ki=fl2fpt(cm1_const.Ts*SpeedLoopPrescaler_fix/0.5);
        pi_spd_fix.Umax =fl2fpt(80);
        pi_spd_fix.Umin =fl2fpt(-80);

    // Initialize the PI module for Iq
        pi_id_fix.Kp=fl2fpt(10.0);
        pi_id_fix.Ki=fl2fpt(cm1_const.Ts/0.004);
        pi_id_fix.Umax =fl2fpt(DC_BUS_VOLTAGE);
        pi_id_fix.Umin =fl2fpt(-DC_BUS_VOLTAGE);

    // Initialize the PI module for speed
        pi_iq_fix.Kp=fl2fpt(10.0);
        pi_iq_fix.Ki=fl2fpt(cm1_const.Ts/0.004);
        pi_iq_fix.Umax =fl2fpt(DC_BUS_VOLTAGE);
        pi_iq_fix.Umin =fl2fpt(-DC_BUS_VOLTAGE);



}



// ############################################################################################################################################

// #### "double" version model ################################################################################################################

    //For some reason, cannot find intrinic for _IQsat in /ti/controlSUITE search.
    //Use this (from https://software-dl.ti.com/C2000/docs/optimization_guide/phase1/saturation.html)
double saturate(double sum, double max, double min)
{
    if( sum > max )
        sum = max;
    if( sum < min )
        sum = min;

    return sum;
}

typedef struct {  double  Ref;             // Input: reference set-point
                  double  Fbk;             // Input: feedback
                  double  Out;             // Output: controller output
                  double  Kp;              // Parameter: proportional loop gain
                  double  Ki;              // Parameter: integral gain
                  double  Umax;            // Parameter: upper saturation limit
                  double  Umin;            // Parameter: lower saturation limit
                  double  up;              // Data: proportional term
                  double  ui;              // Data: integral term
                  double  v1;              // Data: pre-saturated controller output
                  double  i1;              // Data: integrator storage: ui(k-1)
                  double  w1;              // Data: saturation record: [u(k-1) - v(k-1)]
                } PI_CONTROLLER;




#define PI_MACRO(v)                                             \
                                                                \
    /* proportional term */                                     \
    v.up = v.Kp * (v.Ref - v.Fbk);                              \
                                                                \
    /* integral term */                                         \
    v.ui = (v.Out == v.v1)?((v.Ki * v.up)+ v.i1) : v.i1;        \
    v.i1 = v.ui;                                                \
                                                                \
    /* control output */                                        \
    v.v1 = v.up + v.ui;                                         \
    v.Out= saturate(v.v1, v.Umax, v.Umin);                      \
    //v.w1 = (v.Out == v.v1) ? _IQ(1.0) : _IQ(0.0);             \

#define PI_CONTROLLER_DEFAULTS {        \
                           0,           \
                           0,           \
                           0,           \
                           1.0,         \
                           0.0,         \
                           1.0,         \
                           -1.0,        \
                           0.0,         \
                           0.0,         \
                           0.0,         \
                           0.0,         \
                           1.0          \
                          }

PI_CONTROLLER pi_spd = PI_CONTROLLER_DEFAULTS;
PI_CONTROLLER pi_id = PI_CONTROLLER_DEFAULTS;
PI_CONTROLLER pi_iq = PI_CONTROLLER_DEFAULTS;

uint16_t SpeedLoopPrescaler = 10;

void init_pi_spd_pi_id_pi_iq(void)
{
    // Initialize the PI module for Id
        pi_spd.Kp=50.0;
        pi_spd.Ki=cm1_const.Ts*SpeedLoopPrescaler/0.5;
        pi_spd.Umax =80;
        pi_spd.Umin =-80;

    // Initialize the PI module for Iq
        pi_id.Kp=10.0;
        pi_id.Ki=cm1_const.Ts/0.004;
        pi_id.Umax =DC_BUS_VOLTAGE;
        pi_id.Umin =-DC_BUS_VOLTAGE;

    // Initialize the PI module for speed
        pi_iq.Kp=10.0;
        pi_iq.Ki=cm1_const.Ts/0.004;
        pi_iq.Umax =DC_BUS_VOLTAGE;
        pi_iq.Umin =-DC_BUS_VOLTAGE;



}

// ############################################################################################################################################


// *********************************************************************************************************************************************


// ***** CLARKE_MACRO Macro ********************************************************************************************************************


//From: /home/maiello/Desktop/Development-Simulation/InductionMotor_DTC_SVM/controlSUITE_ref/v4.3/clarke.h

///* =================================================================================
//File name:       CLARKE.H
//===================================================================================*/
//
//
//#ifndef __CLARKE_H__
//#define __CLARKE_H__
//
//typedef struct {  _iq  As;          // Input: phase-a stator variable
//                  _iq  Bs;          // Input: phase-b stator variable
//                  _iq  Cs;          // Input: phase-c stator variable
//                  _iq  Alpha;       // Output: stationary d-axis stator variable
//                  _iq  Beta;        // Output: stationary q-axis stator variable
//                } CLARKE;
//
///*-----------------------------------------------------------------------------
//    Default initalizer for the CLARKE object.
//-----------------------------------------------------------------------------*/
//#define CLARKE_DEFAULTS { 0, \
//                          0, \
//                          0, \
//                          0, \
//                          0, \
//                        }
//
///*------------------------------------------------------------------------------
//    CLARKE Transformation Macro Definition
//------------------------------------------------------------------------------*/
//
////  1/sqrt(3) = 0.57735026918963
//#define  ONEbySQRT3   0.57735026918963    /* 1/sqrt(3) */
//
//
//// Clarke transform macro (with 2 currents)
////==========================================
//#define CLARKE_MACRO(v)                                     \
//v.Alpha = v.As;                                             \
//v.Beta = _IQmpy((v.As +_IQmpy2(v.Bs)),_IQ(ONEbySQRT3));
//
//
//// Clarke transform macro (with 3 currents)
////==========================================
//#define CLARKE1_MACRO(v)                                    \
//v.Alpha = v.As;                                             \
//v.Beta  = _IQmpy((v.Bs - v.Cs),_IQ(ONEbySQRT3));
//
//#endif // __CLARKE_H__


// #### "fixed" version model #################################################################################################################

typedef struct {  float  As;          // Input: phase-a stator variable
                  float  Bs;          // Input: phase-b stator variable
                  float  Cs;          // Input: phase-c stator variable
                  fpt  Alpha;         // Output: stationary d-axis stator variable
                  fpt  Beta;          // Output: stationary q-axis stator variable
                } CLARKE_fix;


#define  ONEbySQRT3_fix   fl2fpt(0.57735026918963)    /* 1/sqrt(3) */

#define CLARKE_MACRO_fix(v)                                                           \
v.Alpha = fl2fpt(v.As);                                                               \
v.Beta = fpt_mul(fl2fpt(v.As) + fpt_mul(fl2fpt(v.Bs), fl2fpt(v.Bs)), ONEbySQRT3_fix);

#define CLARKE1_MACRO_fix(v)                                        \
        v.Alpha = fl2fpt(v.As);                                     \
        v.Beta  = fpt_mul(fl2fpt(v.Bs - v.Cs), ONEbySQRT3_fix);


#define CLARKE_DEFAULTS_fix { 0, \
                          0, \
                          0, \
                          fl2fpt(0), \
                          fl2fpt(0), \
                        }


CLARKE_fix clarke1_fix = CLARKE_DEFAULTS_fix;



// ############################################################################################################################################

// #### "double" version model ################################################################################################################

typedef struct {  double  As;          // Input: phase-a stator variable
                  double  Bs;          // Input: phase-b stator variable
                  double  Cs;          // Input: phase-c stator variable
                  double  Alpha;       // Output: stationary d-axis stator variable
                  double  Beta;        // Output: stationary q-axis stator variable
                } CLARKE;


#define  ONEbySQRT3   0.57735026918963    /* 1/sqrt(3) */

#define CLARKE_MACRO(v)                                     \
v.Alpha = v.As;                                             \
v.Beta = v.As + (v.Bs * v.Bs) * ONEbySQRT3;

#define CLARKE1_MACRO(v)                                    \
        v.Alpha = v.As;                                     \
        v.Beta  = (v.Bs - v.Cs) * ONEbySQRT3;


#define CLARKE_DEFAULTS { 0, \
                          0, \
                          0, \
                          0, \
                          0, \
                        }


CLARKE clarke1 = CLARKE_DEFAULTS;


// ############################################################################################################################################


// *********************************************************************************************************************************************


// ***** PARK_MACRO Macro ********************************************************************************************************************


        //From: /home/maiello/Desktop/Development-Simulation/InductionMotor_DTC_SVM/controlSUITE_ref/v4.3/park.h

///* =================================================================================
//File name:       PARK.H
//===================================================================================*/
//
//#ifndef __PARK_H__
//#define __PARK_H__
//
//typedef struct {  _iq  Alpha;       // Input: stationary d-axis stator variable
//                  _iq  Beta;        // Input: stationary q-axis stator variable
//                  _iq  Angle;       // Input: rotating angle (pu)
//                  _iq  Ds;          // Output: rotating d-axis stator variable
//                  _iq  Qs;          // Output: rotating q-axis stator variable
//                  _iq  Sine;
//                  _iq  Cosine;
//                } PARK;
//
///*-----------------------------------------------------------------------------
//Default initalizer for the PARK object.
//-----------------------------------------------------------------------------*/
//#define PARK_DEFAULTS {   0, \
//                          0, \
//                          0, \
//                          0, \
//                          0, \
//                          0, \
//                          0, \
//                          }
//
///*------------------------------------------------------------------------------
//    PARK Transformation Macro Definition
//------------------------------------------------------------------------------*/
//
//
//#define PARK_MACRO(v)                                           \
//                                                                \
//    v.Ds = _IQmpy(v.Alpha,v.Cosine) + _IQmpy(v.Beta,v.Sine);    \
//    v.Qs = _IQmpy(v.Beta,v.Cosine) - _IQmpy(v.Alpha,v.Sine);
//
//#endif // __PARK_H__


// #### "fixed" version model #################################################################################################################

typedef struct {  fpt  Alpha;       // Input: stationary d-axis stator variable
                  fpt  Beta;        // Input: stationary q-axis stator variable
                  fpt  Angle;       // Input: rotating angle (pu)
                  fpt  Ds;          // Output: rotating d-axis stator variable
                  fpt  Qs;          // Output: rotating q-axis stator variable
                  float Sine;
                  float Cosine;
                } PARK_fix;

#define PARK_MACRO_fix(v)                                                           \
                                                                                    \
    v.Ds = fpt_mul(v.Alpha, fl2fpt(v.Cosine)) + fpt_mul(v.Beta, fl2fpt(v.Sine));    \
    v.Qs = fpt_mul(v.Beta, fl2fpt(v.Cosine)) - fpt_mul(v.Alpha, fl2fpt(v.Sine));



#define PARK_DEFAULTS_fix {   fl2fpt(0), \
                              fl2fpt(0), \
                              fl2fpt(0), \
                              fl2fpt(0), \
                              fl2fpt(0), \
                              0, \
                              0, \
                              }


PARK_fix park1_fix = PARK_DEFAULTS_fix;

        //!!!!!!!!!!!!!!!!!!!!!! DONE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

// ############################################################################################################################################


// #### "double" version model ################################################################################################################



typedef struct {  double  Alpha;       // Input: stationary d-axis stator variable
                  double  Beta;        // Input: stationary q-axis stator variable
                  double  Angle;       // Input: rotating angle (pu)
                  double  Ds;          // Output: rotating d-axis stator variable
                  double  Qs;          // Output: rotating q-axis stator variable
                  double  Sine;
                  double  Cosine;
                } PARK;

#define PARK_MACRO(v)                                           \
                                                                \
    v.Ds = v.Alpha * v.Cosine + v.Beta * v.Sine;                \
    v.Qs = v.Beta * v.Cosine - v.Alpha * v.Sine;



#define PARK_DEFAULTS {   0, \
                          0, \
                          0, \
                          0, \
                          0, \
                          0, \
                          0, \
                          }


PARK park1 = PARK_DEFAULTS;



// ############################################################################################################################################




// *********************************************************************************************************************************************

#endif
