#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

FILE * fp_sdq_d_stator_stator_mu_ind_h;


#define PI 3.1415926535897932384626433832795

//Varifacation of the transformation of the D/Q element Mdq0s contained in Equation 7.8 on page 179 of "Roberts..."


//Invocation:
//
// gcc -g Verify_Eq_7_8_for_Qsyncd0s.c -lm  (Ubuntu 14.04 gcc requires "-lm" after file(s) to be compiled)

// Using Eq. 7.3 on page 177 with Eq. 7.4 on page 178 and the definition for Mdq in Eq. 3.35 on page 83,
// we break up this definition for Qsync into a seperate elements because we intend to expand the motor equation
// like we did for the  physical and D/Q definitions.
//
double Qsyncd0s[3][3] = {0};


double Tsync_phi[3][3] = {0};

double dTsync_phi_less_omegad_omega_r_terms[3][3] = {0};


//Use the variable names for rotor position and stator electrical frequency we use in "App_InductionMotor.hpp".
double theta_r;
double thetad;

double phi;

//			"../BDFM-Dissertation-2005-Tests/Verify_Eq_3_19/dq_Stator_Stator_Mutual_Inductance_ideal.h"

double Mdq0s[3][3] = {
									{0.418313		,0						,0},
									{0					,0.418313			,0},
									{0					,0						,0},
								};


double Mdq0s_dTsync_phi_less_omegad_omega_r_terms_t[3][3] = {0};

main()
{
	int i,j,k;
	int test_count_0;
	int test_count_1;

			//Create include file for simulation program "App_InductionMotor.hpp"
	fp_sdq_d_stator_stator_mu_ind_h = fopen("sdq_d_Stator_Stator_Mutual_Inductance.h", "w");
	fprintf(fp_sdq_d_stator_stator_mu_ind_h, "\n\n\ndouble Qsyncd0s[3][3] = {\n");









	phi = .12 * PI;

	  for(test_count_0 = 0; test_count_0 <= 3; test_count_0++)
	  {

		if(test_count_0 == 0)
			theta_r = 0;
		else if(test_count_0 == 1)
			theta_r = .23 *  PI;
		else if(test_count_0 == 2)
			theta_r = .356 * PI;
		else
			theta_r = .678 * PI;

		  for(test_count_1 = 0; test_count_1 <= 3; test_count_1++)
		  {
				memset(Mdq0s_dTsync_phi_less_omegad_omega_r_terms_t, 0, sizeof(Mdq0s_dTsync_phi_less_omegad_omega_r_terms_t));
				memset(Qsyncd0s, 0, sizeof(Qsyncd0s));
				if(test_count_1 == 0)
					thetad = 0;
				else if(test_count_1 == 1)
					thetad = .23 *  PI;
				else if(test_count_1 == 2)
					thetad = .356 * PI;
				else
					thetad = .678 * PI;

				//From Eq 7.3 page 177 of "Roberts..."

				Tsync_phi[0][0] = cos(1.0* theta_r - thetad + phi);
				Tsync_phi[0][1] = sin(1.0* theta_r - thetad + phi);
				Tsync_phi[1][0] = -sin(1.0* theta_r - thetad + phi);
				Tsync_phi[1][1] = cos(1.0* theta_r - thetad + phi);
				Tsync_phi[2][2] = 1.0;

				//Form page 181 of "Roberts..." (Careful! This is not the tranposed (inverted) form on this page becase we perform the transpose below).

				dTsync_phi_less_omegad_omega_r_terms[0][0] = -sin(1.0* theta_r - thetad + phi);
				dTsync_phi_less_omegad_omega_r_terms[0][1] = cos(1.0* theta_r - thetad + phi);
				dTsync_phi_less_omegad_omega_r_terms[1][0] = -cos(1.0* theta_r - thetad + phi);
				dTsync_phi_less_omegad_omega_r_terms[1][1] = -sin(1.0* theta_r - thetad + phi);


				//   Tsync_phi * Mdq0s * (dTsync_phi_less_omegad_omega_r_terms)_t
							//((dTsync_phi_less_omegad_omega_r_terms)_t same as (dTsync_phi_less_omegad_omega_r_terms)-1  because it is orthogonal)

				 for(i = 0; i < 3; i++)
				 {
					for(j = 0; j < 3; j++)
					{

						for(k = 0; k < 3; k++)
						{
							Mdq0s_dTsync_phi_less_omegad_omega_r_terms_t[i][j] =  Mdq0s_dTsync_phi_less_omegad_omega_r_terms_t[i][j] +
																		Mdq0s[i][k] * dTsync_phi_less_omegad_omega_r_terms[j][k];

						}
					}
				 }

				 for(i = 0; i < 3; i++)
				 {
					for(j = 0; j < 3; j++)
					{

						for(k = 0; k < 3; k++)
						{
							Qsyncd0s[i][j] = Qsyncd0s[i][j] + Tsync_phi[i][k] * Mdq0s_dTsync_phi_less_omegad_omega_r_terms_t[k][j];


						}
					  }
				   }

				 printf("\n\nQsyncd0s= \n");
				 printf("%g\t%g\t%g\n", Qsyncd0s[0][0], Qsyncd0s[0][1], Qsyncd0s[0][2]);
				 printf("%g\t%g\t%g\n", Qsyncd0s[1][0], Qsyncd0s[1][1], Qsyncd0s[1][2]);
				 printf("%g\t%g\t%g\n", Qsyncd0s[2][0], Qsyncd0s[2][1], Qsyncd0s[2][2]);

				if((test_count_0 == 0) && (test_count_1 == 0))
				{
					fprintf(fp_sdq_d_stator_stator_mu_ind_h, "\t\t{%g\t,%g\t,%g},\n", Qsyncd0s[0][0],  Qsyncd0s[0][1],  Qsyncd0s[0][2]);
			 		fprintf(fp_sdq_d_stator_stator_mu_ind_h, "\t\t{%g\t,%g\t,%g},\n", Qsyncd0s[1][0],  Qsyncd0s[1][1],  Qsyncd0s[1][2]);
			 		fprintf(fp_sdq_d_stator_stator_mu_ind_h, "\t\t{%g\t,%g\t,%g},\n", Qsyncd0s[2][0],  Qsyncd0s[2][1],  Qsyncd0s[2][2]);
			 		fprintf(fp_sdq_d_stator_stator_mu_ind_h, "\t\t};\n");


			 		fclose(fp_sdq_d_stator_stator_mu_ind_h);
				}

		  }
	  }



}


