#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

FILE * fp_d_sdq_stator_rotor_mu_ind_h;


#define PI 3.1415926535897932384626433832795

//Varifacation of the transformation of the D/Q element Qdqsr contained in Equation 7.8 on page 179 of "Roberts..."


//Invocation:
//
// gcc -g Verify_Eq_7_8_for_Qsyncsr.c -lm  (Ubuntu 14.04 gcc requires "-lm" after file(s) to be compiled)

// Using Eq. 7.3 on page 177 with Eq. 7.4 on page 178 and the definition for Qdq in Eq. 3.35 on page 83,
// we break up this definition for Qsync into a seperate elements because we intend to expand the motor equation
// like we did for the  physical and D/Q definitions.
//
double Qsyncsr[3][3] = {0};


double Tsync_phi[3][3] = {0};




//Use the variable names for rotor position and stator electrical frequency we use in "App_InductionMotor.hpp".
double theta_r;
double thetad;

double phi;

//			"../BDFM-Dissertation-2005-Tests/Verify_Eq_3_28/d_dq_Stator_Rotor_Mutual_Inductance_ideal.h"

double Qdqsr[3][3] = {
									{0							,0.002204475		,0	},
									{-0.002204475		,0						,0	},
									{0							,0						,0	},
								};



double Qdqsr_Tsync_phi_t[3][3] = {0};

main()
{
	int i,j,k;
	int test_count_0;
	int test_count_1;

			//Create include file for simulation program "App_InductionMotor.hpp"
	fp_d_sdq_stator_rotor_mu_ind_h = fopen("d_sdq_Stator_Rotor_Mutual_Inductance.h", "w");
	fprintf(fp_d_sdq_stator_rotor_mu_ind_h, "\n\n\ndouble Qsyncsr[3][3] = {\n");








		//"phi" always zero because we are analizing a matrix that has a rotor component (see Eq. 7.4 of "Roberts...")
	phi = 0;

	  for(test_count_0 = 0; test_count_0 <= 3; test_count_0++)
	  {

		if(test_count_0 == 0)
			theta_r = 0;
		else if(test_count_0 == 1)
			theta_r = .23 *  PI;
		else if(test_count_0 == 2)
			theta_r = .356 * PI;
		else
			theta_r = .678 * PI;

		  for(test_count_1 = 0; test_count_1 <= 3; test_count_1++)
		  {
				memset(Qdqsr_Tsync_phi_t, 0, sizeof(Qdqsr_Tsync_phi_t));
				memset(Qsyncsr, 0, sizeof(Qsyncsr));
				if(test_count_1 == 0)
					thetad = 0;
				else if(test_count_1 == 1)
					thetad = .23 *  PI;
				else if(test_count_1 == 2)
					thetad = .356 * PI;
				else
					thetad = .678 * PI;

				//From Eq 7.3 page 177 of "Roberts...

				Tsync_phi[0][0] = cos(1.0* theta_r - thetad + phi);
				Tsync_phi[0][1] = sin(1.0* theta_r - thetad + phi);
				Tsync_phi[1][0] = -sin(1.0* theta_r - thetad + phi);
				Tsync_phi[1][1] = cos(1.0* theta_r - thetad + phi);
				Tsync_phi[2][2] = 1.0;




				//   Tsync_phi * Qdqsr * (Tsync_phi)_t     ((Tsync_phi)_t same as (Tsync_phi)-1  because it is orthogonal)

				 for(i = 0; i < 3; i++)
				 {
					for(j = 0; j < 3; j++)
					{

						for(k = 0; k < 3; k++)
						{
							Qdqsr_Tsync_phi_t[i][j] =  Qdqsr_Tsync_phi_t[i][j] +  Qdqsr[i][k] * Tsync_phi[j][k];

						}
					}
				 }

				 for(i = 0; i < 3; i++)
				 {
					for(j = 0; j < 3; j++)
					{

						for(k = 0; k < 3; k++)
						{
							Qsyncsr[i][j] = Qsyncsr[i][j] + Tsync_phi[i][k] * Qdqsr_Tsync_phi_t[k][j];


						}
					  }
				   }

				 printf("\n\nQsyncsr= \n");
				 printf("%g\t%g\t%g\n", Qsyncsr[0][0], Qsyncsr[0][1], Qsyncsr[0][2]);
				 printf("%g\t%g\t%g\n", Qsyncsr[1][0], Qsyncsr[1][1], Qsyncsr[1][2]);
				 printf("%g\t%g\t%g\n", Qsyncsr[2][0], Qsyncsr[2][1], Qsyncsr[2][2]);

				if((test_count_0 == 0) && (test_count_1 == 0))
				{
					fprintf(fp_d_sdq_stator_rotor_mu_ind_h, "\t\t{%g\t,%g\t,%g},\n", Qsyncsr[0][0],  Qsyncsr[0][1],  Qsyncsr[0][2]);
			 		fprintf(fp_d_sdq_stator_rotor_mu_ind_h, "\t\t{%g\t,%g\t,%g},\n", Qsyncsr[1][0],  Qsyncsr[1][1],  Qsyncsr[1][2]);
			 		fprintf(fp_d_sdq_stator_rotor_mu_ind_h, "\t\t{%g\t,%g\t,%g},\n", Qsyncsr[2][0],  Qsyncsr[2][1],  Qsyncsr[2][2]);
			 		fprintf(fp_d_sdq_stator_rotor_mu_ind_h, "\t\t};\n");


			 		fclose(fp_d_sdq_stator_rotor_mu_ind_h);
				}

		  }
	  }



}


