






//
//
//
//
//    												   
//                i13 -+						  iBus_p -+					
//                -----------------------------------+----- VBus_p                
//               |      i1ct   						 |
//               |-------- +                         |
//             |-   |D11  |-                         |
//           - |- + ^   <C11>                        |
//          S11|-|- |i1st |                          |
//               |--------                           |
//    -----------| v1   i1cb                         |
//   |    i12 -+ |-------- +                         |
//   |         |-   |D12  |-                         |
//   |       - |- + ^   <C12>                        |
//   |      S12|-|- |i1sb |                          |
//   |           |--------                           |
//   |     i11 + | v11                   +- iBus_m   |
//   |         -  ------------<R12>----+----- VBus_m |
//   |                	  			   |             |
//    --------------<L1>------<R11>------------      |
//                   .    v12          |       |     |
//      ..............                 |       |     |
//      .                              |       |     |
//      .                              |       |     |
//      .         i23 -+               |       |     |
//      .         -----------------------------------+       
//      .        |      i2ct           |       |     |
//      .        |-------- +           |       |     |
//      .      |-   |D21  |-           |       |     |
//      .    - |- + ^   <C21>          |       |     |
//      .   S21|-|- |i2st |            |    ---+     |       
//      .        |--------             |i_n|   |     |
//    -----------| v2   i2cb           |  +|   |     |
//   |  . i22 -+ |-------- +           |  -|   |     |
//   |  .      |-   |D22  |-           |   |   |     |
//   |  .    - |- + ^   <C22>          | <C_n> |     |    Note: A small value of "C_n" is required to stablize the
//   |  .   S22|-|- |i2sb |            |   |   |     |          SPICE computation algorythm. It is also noted that
//   |  .        |--------             |   |   |     |          a larger value of "C_n" can eliminate the imbalance
//   |  .  i21 + | v21                 |   |   |     |          in phase currents "i12", "i22", "i23". In an actual
//   |  .      -  ------------<R22>----+---    |     |          motor design, "v_n" can be brought out as "forth"
//   |  .                              |    v_n|     |          connection and be connected to "C_n" on the amplifier.
//    --------------<L2>------<R21>------------+     |
//      .            .    v22          |       |     |
//      ..............                 |       |     |
//      .                              |       |     |
//      .                              |       |     |
//      .         i33 -+               |       |     |
//      .         -----------------------------------
//      .        |      i3ct           |       |
//      .        |-------- +           |       | 
//      .      |-   |D31  |-           |       |
//      .    - |- + ^   <C31>          |       |
//      .   S31|-|- |i3st |            |       |
//      .        |--------             |       |
//    -----------| v3   i3cb           |       |
//   |  . i32 -+ |-------- +           |       |
//   |  .      |-   |D32  |-           |       |
//   |  .    - |- + ^   <C32>          |       |
//   |  .   S32|-|- |i3sb |            |       |
//   |  .        |--------             |       |
//   |  .  i31 + | v31                 |       |
//   |  .      -  ------------<R32>----        |
//   |  .                                      |
//    --------------<L3>------<R31>------------      
//		.    		 . 	  v32
//      ..............
//
//
//
//			   NOTE: Removed "Trapezoidal" equations from CoefObject's.  
//					 (see https://en.wikipedia.org/wiki/Trapezoidal_rule_(differential_equations) )
//
//			   NOTE: i1st, i1sb, i2st, i2sb, i3st, and i3sb is the total current through the respective transistor AND diode.
//
//             NOTE: For all equations below, VBus_p and VBus_m are constant. As such VBus_p = VBus_p_ and VBus_m = VBus_m.
//
//	 v1/rS11 - VBus_p/rS11 + v1/rD11 - VBus_p/rD11 = i1st    		=> v1*(1/rS11 + 1/rD11) - i1st = VBus_p*(1/rS11 + 1/rD11)        	(1)
//
//	 v11/rS12 - v1/rS12 + v11/rD12 - v1/rD12 = i1sb          		=> v11*(1/rS12 + 1/rD12) - v1*(1/rS12 + 1/rD12) - ilsb = 0       	(2)
//
// 	 i12 + i11 = i13										 		=> i12 + i11 - i13 = 0											  	(3)
//
//   i1st + i1ct = i13										 		=> i1st + i1ct - i13 = 0										  	(4)
//
//   i1sb + i1cb = i11												=> i1sb + i1cb - i11 = 0										  	(5)
//
//   v1*C11/h - VBus_p*C11/h - v1_*C11/h + VBus_p_*C11/h = i1ct 	=> v1*C11/h - i1ct = v1_*C11/h 										(6)	
//
//	 v11*C12/h - v1*C12/h - v11_*C12/h + v1_*C12/h = i1cb    		=> v11*C12/h - v1*C12/h - i1cb = v11_*C12/h - v1_*C12/h  			(7)
//
//	 VBus_m/R12 - v11/R12 = i11   									=> v11/R12 + i11 = VBus_m/R12							    		(8)
//
//	 (L1*i12/h - L1*i12_/h) -  										=> L1*i12/h -  
//	 (M12*i22/h - M12*i22_/h) -  									   M12*i22/h -
//	 (M31*i32/h - M31*i32_/h) = v12 - v1							   M31*i32/h - v12 + v1 = L1*i12_/h - M12*i22_/h - M31*i32_/h       (9)
//
//	 v_n/R11 - v12/R11 = i12										=> v_n/R11 - v12/R11 - i12 = 0										(10)
//
//
//
//
//	 v2/rS21 - VBus_p/rS21 + v2/rD21 - VBus_p/rD21 = i2st    		=> v2*(1/rS21 + 1/rD21) - i2st = VBus_p*(1/rS21 + 1/rD21)        	(11)
//
//	 v21/rS22 - v2/rS22 + v21/rD22 - v2/rD22 = i2sb          		=> v21*(1/rS22 + 1/rD22) - v2*(1/rS22 + 1/rD22) - i2sb = 0       	(12)
//
// 	 i22 + i21 = i23										 		=> i22 + i21 - i23 = 0											  	(13)
//
//   i2st + i2ct = i23										 		=> i2st + i2ct - i23 = 0										  	(14)
//
//   i2sb + i2cb = i21												=> i2sb + i2cb - i21 = 0										  	(15)
//
//   v2*C21/h - VBus_p*C21/h - v2_*C21/h + VBus_p_*C21/h = i2ct 	=> v2*C21/h - i2ct = v2_*C21/h 										(16)
//
//	 v21*C22/h - v2*C22/h - v21_*C22/h + v2_*C22/h = i2cb    		=> v21*C22/h - v2*C22/h - i2cb = v21_*C22/h - v2_*C22/h  			(17)
//
//	 VBus_m/R22 - v21/R22 = i21   									=> v21/R22 + i21 = VBus_m/R22							    		(18)
//
//	 (L2*i22/h - L2*i22_/h) -  										=> L2*i22/h -  
//	 (M12*i12/h - M12*i12_/h) -  									   M12*i12/h -
//	 (M23*i32/h - M23*i32_/h) = v22 - v2							   M23*i32/h - v22 + v2 = L2*i22_/h - M12*i12_/h - M23*i32_/h       (19)
//
//	 v_n/R21 - v22/R21 = i22										=> v_n/R21 - v22/R21 - i22 = 0										(20)
//
//
//
//
//	 v3/rS31 - VBus_p/rS31 + v3/rD31 - VBus_p/rD31 = i3st    		=> v3*(1/rS31 + 1/rD31) - i3st = VBus_p*(1/rS31 + 1/rD31)        	(21)
//
//	 v31/rS32 - v3/rS32 + v31/rD32 - v3/rD32 = i3sb          		=> v31*(1/rS32 + 1/rD32) - v3*(1/rS32 + 1/rD32) - i3sb = 0       	(22)
//
// 	 i32 + i31 = i33										 		=> i32 + i31 - i33 = 0											  	(23)
//
//   i3st + i3ct = i33										 		=> i3st + i3ct - i33 = 0										  	(24)
//
//   i3sb + i3cb = i31												=> i3sb + i3cb - i31 = 0										  	(25)
//
//   v3*C31/h - VBus_p*C31/h - v3_*C31/h + VBus_p_*C31/h = i3ct 	=> v3*C31/h - i3ct = v3_*C31/h 										(26)
//
//	 v31*C32/h - v3*C32/h - v31_*C32/h + v3_*C32/h = i3cb    		=> v31*C32/h - v3*C32/h - i3cb = v31_*C32/h - v3_*C32/h  			(27)
//
//	 VBus_m/R32 - v31/R32 = i31   									=> v31/R32 + i31 = VBus_m/R32							    		(28)
//
//	 (L3*i32/h - L3*i32_/h) -  										=> L3*i32/h -  
//	 (M31*i12/h - M31*i12_/h) -  									   M31*i12/h -
//	 (M23*i22/h - M23*i22_/h) = v32 - v3							   M23*i22/h - v32 + v3 = L3*i32_/h - M31*i12_/h - M23*i22_/h       (29)
//
//	 v_n/R31 - v32/R31 = i32										=> v_n/R31 - v32/R31 - i32 = 0										(30)
//
//
//
//	 i12 + i22 + i32 = i_n											=> i12 + i22 + i32 - i_n = 0										(31)
//
//	 vBus_m*C_n/h - v_n*C_n/h - vBus_m_*C_n/h + v_n_*C_n/h = i_n	=> v_n*C_n/h + i_n = v_n_*C_n/h										(32)
//
//
//
//      Constants: 
//
//				VBus_p and VBus_m
//
//		Variables computed from the previous pass, used as constants in the current pass:
//
//
//				v11_, v1_ 
//				v21_, v2_ 
//				v31_, v3_
//				i12_, i22_, i32_
//              v_n_
//
//      The state vector for the DC solution:
//
//
//				| v1 v11 i1st i1sb i12 i11 i13 i1ct i1cb v12
//				  v2 v21 i2st i2sb i22 i21 i23 i2ct i2cb v22
//				  v3 v31 i3st i3sb i32 i31 i33 i3ct i3cb v32
//				  v_n  i_n |'
//
//

typedef enum {
  SRC_FUNC_NULL = -1,
  SRC_FUNC_TriangleWave,
  SRC_FUNC_PwmA,
  SRC_FUNC_PwmB,
  SRC_FUNC_PwmC,

} SRC_FUNCTION;


typedef enum {
  ODE_FUNC_NULL = -1,
} ODE_FUNCTION;




typedef enum {
  CTRL_FUNC_NULL = -1,
  CTRL_FUNC_VDqCmd,


} CTRL_FUNCTION;


typedef enum {
  COEF_FUNC_NULL = -1,
  
  COEF_FUNC_recp_rSrD11,
  COEF_FUNC_recp_rSrD12,
  COEF_FUNC_C11_h,
  COEF_FUNC_C12_h,
  COEF_FUNC_v1_h_prev_C11,
  COEF_FUNC_v11_v1_h_prev_C12,
  COEF_FUNC_L1_h,
  COEF_FUNC_M12_h,
  COEF_FUNC_M31_h,
  COEF_FUNC_L1_M12_M31_h_prev_i12_i22_i32,

  COEF_FUNC_recp_rSrD21,
  COEF_FUNC_recp_rSrD22,
  COEF_FUNC_C21_h,
  COEF_FUNC_C22_h,
  COEF_FUNC_v2_h_prev_C21,
  COEF_FUNC_v21_v2_h_prev_C22,
  COEF_FUNC_L2_h,
  COEF_FUNC_M23_h,
  COEF_FUNC_L2_M12_M23_h_prev_i12_i22_i32,

  COEF_FUNC_recp_rSrD31,
  COEF_FUNC_recp_rSrD32,
  COEF_FUNC_C31_h,
  COEF_FUNC_C32_h,
  COEF_FUNC_v3_h_prev_C31,
  COEF_FUNC_v31_v3_h_prev_C32,
  COEF_FUNC_L3_h,
  COEF_FUNC_L3_M31_M23_h_prev_i12_i22_i32,
  
  COEF_FUNC_C_n_h,
  COEF_FUNC_v_n_h_prev_C_n,

} COEF_FUNCTION; 


typedef enum {
  SWITCH_FUNC_NULL = -1,
  SWITCH_FUNC_rS11,
  SWITCH_FUNC_rS12,
  SWITCH_FUNC_rS21,
  SWITCH_FUNC_rS22,
  SWITCH_FUNC_rS31,
  SWITCH_FUNC_rS32,
  
 
} SWITCH_FUNCTION; 

typedef enum {
  SPICE_FUNC_NULL = -1,
  SPICE_FUNC_ThreePhaseBridge,
  
} SPICE_FUNCTION;


//define this only for debugging the matrix of any declared SpiceObjects. The size must appropriately.
//#define DEBUG_SPICE_MATRIX
//#define SPICE_DEBUG_MATRIX_SIZE ?? 


//if "DEBUG_SPICE_MATRIX" defined above, as an option we can also elect to dump the "a_matrix" and "a_equate_vector" for
//analysis using Octave.
//#define DUMP_MATRIX_EQUATE_VECTOR_TO_FILE_FOR_EXTERNAL_ANALYSIS 


#include "../Simulation/Simulation.hpp"


//Parameters....

#define M12  .2e-3 // (App_Observer.hpp could handle ".495e-3", maybe because of varible time step which could drive time step lower than fixed value uses here?)
#define M23  M12
#define M31  M12

#define L1  1.0e-3               
#define L2  L1  
#define L3  L1  

#define R11 1.0
#define R21 R11
#define R31 R11

#define RECEP_R11  ((double) 1.0/R11)
#define RECEP_R21  ((double) 1.0/R21)
#define RECEP_R31  ((double) 1.0/R31)

#define R12 .1
#define R22 R12
#define R32 R12

#define RECEP_R12  ((double) 1.0/R12)
#define RECEP_R22  ((double) 1.0/R22)
#define RECEP_R32  ((double) 1.0/R32)


#define C11	 .0000005
#define C12	 .0000005
#define C21	 .0000005
#define C22	 .0000005
#define C31	 .0000005
#define C32	 .0000005

#define C_n  .0000001

#define INIT_COEF_RS_RD  1000000.0

#define MIN_PWM_FREQ_SCALE    1.0
#define MAX_PWM_FREQ_SCALE    10.0

      //Value is such such that "PwmFreqScale" equals MIN_PWM_FREQ_SCALE  when "vcmd_mag" obtains a value >= "PWM_FREQ_GAIN * v_bus"
#define PWM_FREQ_GAIN  .2            // (.000010 / (PWM_CYCLE_QUANTUM_CNT * QUANTUM_PERIOD)) //*** Original test ***


#define VDQ_CMD_QUANTUM_CNT       2
#define PWM_CYCLE_QUANTUM_CNT     2


#define QUANTUM_PERIOD .000025

     //Un-comment to allow PWM time period to be scaled dynamically.
//#define CTRL_PWM_SCALE

#ifdef CTRL_PWM_SCALE

           //NOTE: "PwmFreqScale" is a local variable defined in CtrlObject "VDqCmd" and SrcObject "TrangleWave"
           //      In this context, it is combined into definitions HALF_PWM_CYCLE, T_Z, PWM_GAIN and PWM_OFFSET.
           //      There is sourced by "VDqCmd" and use as an R-Value in "TriangleWave"
#define HALF_PWM_CYCLE (QUANTUM_PERIOD*PwmFreqScale)
 
#else

#define HALF_PWM_CYCLE QUANTUM_PERIOD

#endif

#define DEADTIME_VALUE  .000003


#define SECTOR_ANGLE   (PI / 3.0)
#define T_Z            (HALF_PWM_CYCLE * (double) PWM_CYCLE_QUANTUM_CNT)
#define SQRT_3          1.7320508075688772935274463415059


#define PWM_GAIN    T_Z
#define PWM_OFFSET  (.5*T_Z)


#define VBus_p 200.0
#define VBus_m 0

#define PI   3.1415926535897932384626433832795

        // Indices for the vector to solve.
#define Ind_v1      0
#define Ind_v11     1
#define Ind_i1st    2
#define Ind_i1sb    3
#define Ind_i12     4
#define Ind_i11     5
#define Ind_i13     6
#define Ind_i1ct    7
#define Ind_i1cb    8
#define Ind_v12     9
#define Ind_v2      10
#define Ind_v21     11
#define Ind_i2st    12
#define Ind_i2sb    13
#define Ind_i22     14
#define Ind_i21     15
#define Ind_i23     16
#define Ind_i2ct    17
#define Ind_i2cb    18
#define Ind_v22     19
#define Ind_v3      20
#define Ind_v31     21
#define Ind_i3st    22
#define Ind_i3sb    23
#define Ind_i32     24
#define Ind_i31     25
#define Ind_i33     26
#define Ind_i3ct    27
#define Ind_i3cb    28
#define Ind_v32     29
#define Ind_v_n     30
#define Ind_i_n		31



typedef enum {TIME_NONE,
	      TIME_T1,
	      TIME_T2,
	      TIME_T1_T2
} REFERENCE_CONSTRUCT;

// un-comment to view current sampling parameters.
#define RECORD_PWM_PROBES

// un-comment to plot all probes and object outputs.
//#define RECORD_ALL_PROBES


#define PLOT_SWITCHOBJECT_PROBES_rS11
#define DO_PROBE_rS11_res
//#define DO_PROBE_rS11_cur
#define DO_PROBE_rS11_gate

#define PLOT_SWITCHOBJECT_PROBES_rS12
#define DO_PROBE_rS12_res
//#define DO_PROBE_rS12_cur
#define DO_PROBE_rS12_gate

//#define PLOT_SWITCHOBJECT_PROBES_rS21
//#define DO_PROBE_rS21_res
//#define DO_PROBE_rS21_cur
//#define DO_PROBE_rS21_gate

//#define PLOT_SWITCHOBJECT_PROBES_rS22
//#define DO_PROBE_rS22_res
//#define DO_PROBE_rS22_cur
//#define DO_PROBE_rS22_gate

//#define PLOT_SWITCHOBJECT_PROBES_rS31
//#define DO_PROBE_rS31_res
//#define DO_PROBE_rS31_cur
//#define DO_PROBE_rS31_gate

//#define PLOT_SWITCHOBJECT_PROBES_rS32
//#define DO_PROBE_rS32_res
//#define DO_PROBE_rS32_cur
//#define DO_PROBE_rS32_gate




#define PLOT_SPICEOBJECT_PROBES_solution_vector

#define DO_PROBE_v1
//#define DO_PROBE_v11
//#define DO_PROBE_i1st
//#define DO_PROBE_i1sb
#define DO_PROBE_i12
#define DO_PROBE_i11
#define DO_PROBE_i13
//#define DO_PROBE_i1ct
//#define DO_PROBE_i1cb
//#define DO_PROBE_v12

#define DO_PROBE_v2
//#define DO_PROBE_v21
//#define DO_PROBE_i2st
//#define DO_PROBE_i2sb
#define DO_PROBE_i22
#define DO_PROBE_i21
//#define DO_PROBE_i23
//#define DO_PROBE_i2ct
//#define DO_PROBE_i2cb
//#define DO_PROBE_v22

#define DO_PROBE_v3
//#define DO_PROBE_v31
//#define DO_PROBE_i3st
//#define DO_PROBE_i3sb
#define DO_PROBE_i32
#define DO_PROBE_i31
//#define DO_PROBE_i33
//#define DO_PROBE_i3ct
//#define DO_PROBE_i3cb
//#define DO_PROBE_v32

#define DO_PROBE_v_n
#define DO_PROBE_i_n




// ---- BiQuad filter used by Pwm1, Pwm2, and Pwm3 SrcObjects -----------------------------------------------------


//Reference for filter design:
// 		https://www.dsprelated.com/freebooks/filters/Butterworth_Lowpass_Filter_Example.html
//		https://octave.sourceforge.io/signal/function/butter.html
//
//		Both refernces used to construct Octave "FilterCalculator.m"
//
//      Here are the calculated coefficients:
//
//
//			B =
//
//			   0.020083   0.040167   0.020083
//
//			A =
//
//			   1.00000  -1.56102   0.64135
//



//Here a good description of the filter:
//		https://en.wikipedia.org/wiki/Digital_biquad_filter   <-- **(1)**



// Code Sample:
// 		http://www.iowahills.com/A7ExampleCodePage.html
//          	--> http://www.iowahills.com/Example%20Code/IIRSecondOrderImplementation.txt  (Form 2 agrees with **(1)** above)
//
// The following code is modification of the example to be used for this application.

// This code is assuming these are globals.
#define REG_SIZE 3  //(Here, REG_SIZE is 3 selection of Pwm1, Pwm2, and Pwm3 SrcObjects.)
double Reg0[REG_SIZE], Reg1[REG_SIZE], Reg2[REG_SIZE];  // Used in the Form 2 code
double a2, a1, a0, b2, b1, b0; // The 2nd order IIR coefficients.


// Form 2 Biquad
// This uses one set of shift registers, Reg0, Reg1, and Reg2 in the center.
void SetupIIRBiquadForm2(void)
{

 int j;

 for(j=0; j<REG_SIZE; j++) // Init the shift registers.
  {
   Reg0[j] = 0.0;
   Reg1[j] = 0.0;
   Reg2[j] = 0.0;
  }
  
  a0 = 1.0;
  a1 = -1.56102;
  a2 = 0.64135;
  
  b0 = 0.020083;
  b1 = 0.040167;
  b2 = 0.020083; 
 
}

// Form 2 Biquad Section Calc, called by RunIIRBiquadForm2 (This agrees with **(1)** reference above.)
// NOTE: Here, parameter "k" is 0, 1 or 2 for Pwm1, Pwm2, and Pwm3 SrcObjects.
double SectCalcForm2(int k, double x)
{
 double y;

 Reg0[k] = x - a1 * Reg1[k] - a2 * Reg2[k];
 y = b0 * Reg0[k] + b1 * Reg1[k] + b2 * Reg2[k];

 // Shift the register values
 Reg2[k] = Reg1[k];
 Reg1[k] = Reg0[k];

 return(y);
}




// -----------------------------------------------------------------------------------------------------------------------------


// **** SrcObject Classes ********************************

// ---- TriangleWave ---------------------------------------

class TriangleWave : public SrcObject
{
public:
  virtual void SrcFunction(double t);
  virtual void SrcRValueUpdate(void);
  TriangleWave(void);
  ~TriangleWave(void);
  double t_mod;
  double t_prev;
  double PwmRampDir;
  double PwmFreqScale;



};


TriangleWave Inst_TriangleWave;


// --------------------------------------------------------

// ---- PwmA  ---------------------------------------------

class PwmA : public SrcObject
{
public:
  virtual void SrcFunction(double t);
  virtual void SwitchRValueUpdate(void);
  virtual void RecordProbes(void);
  virtual void PlotProbes(Gnuplot & SimuPlot, vector<double> & Plot_t, string TagNamesToPlot[]);
  PwmA(void);
  ~PwmA(void);
  bool DeadtimeGenerator(double t, bool current_state);
  //source for this ODE
  double TriAngWave;
  double PwmRampDir;
  double PwmRampDirPrev;
  double V_xo; 
  double V_xo_offset;
  double i11;
  double i11_sample;
  double i21;
  double i21_sample;
  double i31;
  double i31_sample;
  double i_total;
  double i_sample_total;
  int SectorNumber;
  double i11_sample_filtered;
  bool   GateCtrl_11;
  bool   GateCtrl_12;      

  //storage for probes..
  vector<double> TW_wave;
  vector<double> PwmDir;  
  vector<double> Ref;
  vector<double> Current;
  vector<double> CurSmp;
  vector<double> LegCurSmp;
  vector<double> SectNum;
  vector<double> LegCurSmpFilt;
 
};



PwmA Inst_PwmA;

// -------------------------------------------------------------

// ---- PwmB  ---------------------------------------------

class PwmB : public SrcObject
{
public:
  virtual void SrcFunction(double t);
  virtual void SwitchRValueUpdate(void);
  virtual void RecordProbes(void);
  virtual void PlotProbes(Gnuplot & SimuPlot, vector<double> & Plot_t, string TagNamesToPlot[]);
  PwmB(void);
  ~PwmB(void);
  bool DeadtimeGenerator(double t, bool current_state);
  //source for this ODE
  double TriAngWave;
  double PwmRampDir;
  double PwmRampDirPrev;
  double V_xo;   
  double V_xo_offset;
  double i11;
  double i11_sample;
  double i21;
  double i21_sample;
  double i31;
  double i31_sample;  
  double i_total;
  double i_sample_total;  
  int SectorNumber;
  double i21_sample_filtered;
  bool   GateCtrl_21;
  bool   GateCtrl_22;   

  //storage for probes..
  vector<double> TW_wave;
  vector<double> PwmDir;  
  vector<double> Ref;
  vector<double> Current;
  vector<double> CurSmp;     
  vector<double> LegCurSmp;
  vector<double> SectNum;
  vector<double> LegCurSmpFilt;

};



PwmB Inst_PwmB;

// -------------------------------------------------------------

// ---- PwmC  ---------------------------------------------

class PwmC : public SrcObject
{
public:
  virtual void SrcFunction(double t);
  virtual void SwitchRValueUpdate(void);
  virtual void RecordProbes(void);
  virtual void PlotProbes(Gnuplot & SimuPlot, vector<double> & Plot_t, string TagNamesToPlot[]);
  PwmC(void);
  ~PwmC(void);
  bool DeadtimeGenerator(double t, bool current_state);
  //source for this ODE
  double TriAngWave;
  double PwmRampDir;
  double PwmRampDirPrev;
  double V_xo;   
  double V_xo_offset;
  double i11;
  double i11_sample;
  double i21;
  double i21_sample; 
  double i31;
  double i31_sample;
  double i_total;
  double i_sample_total;
  int SectorNumber;
  double i31_sample_filtered;
  bool   GateCtrl_31;
  bool   GateCtrl_32;                     
                  
  //storage for probes..
  vector<double> TW_wave;
  vector<double> PwmDir;  
  vector<double> Ref;
  vector<double> Current;
  vector<double> CurSmp; 
  vector<double> LegCurSmp;
  vector<double> SectNum;
  vector<double> LegCurSmpFilt;

};



PwmC Inst_PwmC;

// -------------------------------------------------------------


SrcObject * SrcObjectList[] = {(SrcObject *) &Inst_TriangleWave,
			       (SrcObject *) &Inst_PwmA,
			       (SrcObject *) &Inst_PwmB,
			       (SrcObject *) &Inst_PwmC,
			       0};


// ***********************************************************



// **** OdeObject Classes ********************************

OdeObject * OdeObjectList[] = {
			       0};


// ***********************************************************


// **** CtrlObject Classes **********************************




// ---- VDqCmd  ---------------------------------------------

class VDqCmd : public CtrlObject
{
public:
  virtual void CtrlFunction(double t);
  virtual void SrcRValueUpdate(void);
  virtual void RecordProbes(void);
  virtual void PlotProbes(Gnuplot & SimuPlot, vector<double> & Plot_t, string TagNamesToPlot[]);
  VDqCmd(void);
  ~VDqCmd(void);
  void SpaceVectorControl(void);
  //source for this CTRL
  double V_xo[3];
  double Freq;
  double Period;
  double theta;
  int SectorNumber; 
    
  double vcmd_mag;
  double vcmd_ang;
    
  double v_bus;
     
  REFERENCE_CONSTRUCT SVTable[6][3];  
     
  double PwmFreqScale;
  
  //storage for probes..
  vector<double> VCmd_a;  //value of V_xo[0].
  vector<double> VCmd_b;  //value of V_xo[1].
  vector<double> VCmd_c;  //value of V_xo[2].
  vector<double> VCmd_mag; 
  vector<double> VCmd_ang; 
  vector<double> FreqScale;

};



VDqCmd Inst_VDqCmd;

// -------------------------------------------------------------


CtrlObject * CtrlObjectList[] = {(CtrlObject *) &Inst_VDqCmd,
									0};

int CtrlObjectQuantum[] = { VDQ_CMD_QUANTUM_CNT,
                          };
						  
						  
// **************************************************************



// **** CoefObject Classes ****************************************

// ---- Coef_recp_rSrD11 ---------------------------------------------

class Coef_recp_rSrD11 : public CoefObject
{
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_recp_rSrD11(void);
  ~Coef_recp_rSrD11(void);
  double rS11;
  double rD11;

};

Coef_recp_rSrD11 Coef_recp_rSrD11_i;

// -------------------------------------------------------------

// ---- Coef_recp_rSrD12 ---------------------------------------------

class Coef_recp_rSrD12 : public CoefObject
{
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_recp_rSrD12(void);
  ~Coef_recp_rSrD12(void);
  double rS12;
  double rD12;


};

Coef_recp_rSrD12 Coef_recp_rSrD12_i;

// -------------------------------------------------------------


// ---- Coef_C11_h ---------------------------------------------

class Coef_C11_h : public CoefObject
{
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_C11_h(void);
  ~Coef_C11_h(void);




};

Coef_C11_h Coef_C11_h_i;

// -------------------------------------------------------------


// ---- Coef_C12_h ---------------------------------------------

class Coef_C12_h : public CoefObject
{
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_C12_h(void);
  ~Coef_C12_h(void);




};

Coef_C12_h Coef_C12_h_i;

// -------------------------------------------------------------


// ---- Coef_v1_h_prev_C11 -------------------------------------

class Coef_v1_h_prev_C11 : public CoefObject
{
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_v1_h_prev_C11(void);
  ~Coef_v1_h_prev_C11(void);
  double v1_;
  
  
  
};

Coef_v1_h_prev_C11 Coef_v1_h_prev_C11_i;

// -------------------------------------------------------------


// ---- Coef_v11_v1_h_prev_C12 ---------------------------------

class Coef_v11_v1_h_prev_C12 : public CoefObject
{
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_v11_v1_h_prev_C12(void);
  ~Coef_v11_v1_h_prev_C12(void);
  double v11_;
  double v1_;
  	 




};

Coef_v11_v1_h_prev_C12 Coef_v11_v1_h_prev_C12_i;

// -------------------------------------------------------------


// ---- Coef_L1_h ---------------------------------------------

class Coef_L1_h : public CoefObject
{
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_L1_h(void);
  ~Coef_L1_h(void);

  


};

Coef_L1_h Coef_L1_h_i;

// -------------------------------------------------------------


// ---- Coef_M12_h ---------------------------------------------

class Coef_M12_h : public CoefObject
{
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_M12_h(void);
  ~Coef_M12_h(void);

  


};

Coef_M12_h Coef_M12_h_i;

// -------------------------------------------------------------


// ---- Coef_M31_h ---------------------------------------------

class Coef_M31_h : public CoefObject
{
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_M31_h(void);
  ~Coef_M31_h(void);

  


};

Coef_M31_h Coef_M31_h_i;

// -------------------------------------------------------------



// ---- Coef_L1_M12_M31_h_prev_i12_i22_i32 -------------------------------------

class Coef_L1_M12_M31_h_prev_i12_i22_i32  : public CoefObject
{
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_L1_M12_M31_h_prev_i12_i22_i32(void);
  ~Coef_L1_M12_M31_h_prev_i12_i22_i32(void);
  double i12_;
  double i22_;
  double i32_;
  	   


};

Coef_L1_M12_M31_h_prev_i12_i22_i32 Coef_L1_M12_M31_h_prev_i12_i22_i32_i;

// -------------------------------------------------------------




// ---- Coef_recp_rSrD21 ---------------------------------------------

class Coef_recp_rSrD21 : public CoefObject
{
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_recp_rSrD21(void);
  ~Coef_recp_rSrD21(void);
  double rS21;
  double rD21;

};

Coef_recp_rSrD21 Coef_recp_rSrD21_i;

// -------------------------------------------------------------

// ---- Coef_recp_rSrD22 ---------------------------------------------

class Coef_recp_rSrD22 : public CoefObject
{
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_recp_rSrD22(void);
  ~Coef_recp_rSrD22(void);
  double rS22;
  double rD22;


};

Coef_recp_rSrD22 Coef_recp_rSrD22_i;

// -------------------------------------------------------------


// ---- Coef_C21_h ---------------------------------------------

class Coef_C21_h : public CoefObject
{
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_C21_h(void);
  ~Coef_C21_h(void);




};

Coef_C21_h Coef_C21_h_i;

// -------------------------------------------------------------


// ---- Coef_C22_h ---------------------------------------------

class Coef_C22_h : public CoefObject
{
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_C22_h(void);
  ~Coef_C22_h(void);




};

Coef_C22_h Coef_C22_h_i;

// -------------------------------------------------------------


// ---- Coef_v2_h_prev_C21 -------------------------------------

class Coef_v2_h_prev_C21 : public CoefObject
{
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_v2_h_prev_C21(void);
  ~Coef_v2_h_prev_C21(void);
  double v2_;
  
  
  
  
};

Coef_v2_h_prev_C21 Coef_v2_h_prev_C21_i;

// -------------------------------------------------------------


// ---- Coef_v21_v2_h_prev_C22 ---------------------------------

class Coef_v21_v2_h_prev_C22 : public CoefObject
{
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_v21_v2_h_prev_C22(void);
  ~Coef_v21_v2_h_prev_C22(void);
  double v21_;
  double v2_;
  	 




};

Coef_v21_v2_h_prev_C22 Coef_v21_v2_h_prev_C22_i;

// -------------------------------------------------------------


// ---- Coef_L2_h ---------------------------------------------

class Coef_L2_h : public CoefObject
{
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_L2_h(void);
  ~Coef_L2_h(void);

  


};

Coef_L2_h Coef_L2_h_i;

// -------------------------------------------------------------


// ---- Coef_M12_h ---------------------------------------------

	// (Previous defined above.)

// -------------------------------------------------------------


// ---- Coef_M23_h ---------------------------------------------

class Coef_M23_h : public CoefObject
{
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_M23_h(void);
  ~Coef_M23_h(void);

  


};

Coef_M23_h Coef_M23_h_i;

// -------------------------------------------------------------



// ---- Coef_L2_M12_M23_h_prev_i12_i22_i32 -------------------------------------

class Coef_L2_M12_M23_h_prev_i12_i22_i32  : public CoefObject
{
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_L2_M12_M23_h_prev_i12_i22_i32(void);
  ~Coef_L2_M12_M23_h_prev_i12_i22_i32(void);
  double i12_;
  double i22_;
  double i32_;
  	   


};

Coef_L2_M12_M23_h_prev_i12_i22_i32 Coef_L2_M12_M23_h_prev_i12_i22_i32_i;

// -------------------------------------------------------------


 
 
 // ---- Coef_recp_rSrD31 ---------------------------------------------

class Coef_recp_rSrD31 : public CoefObject
{
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_recp_rSrD31(void);
  ~Coef_recp_rSrD31(void);
  double rS31;
  double rD31;

};

Coef_recp_rSrD31 Coef_recp_rSrD31_i;

// -------------------------------------------------------------

// ---- Coef_recp_rSrD32 ---------------------------------------------

class Coef_recp_rSrD32 : public CoefObject
{
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_recp_rSrD32(void);
  ~Coef_recp_rSrD32(void);
  double rS32;
  double rD32;


};

Coef_recp_rSrD32 Coef_recp_rSrD32_i;

// -------------------------------------------------------------


// ---- Coef_C31_h ---------------------------------------------

class Coef_C31_h : public CoefObject
{
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_C31_h(void);
  ~Coef_C31_h(void);




};

Coef_C31_h Coef_C31_h_i;

// -------------------------------------------------------------


// ---- Coef_C32_h ---------------------------------------------

class Coef_C32_h : public CoefObject
{
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_C32_h(void);
  ~Coef_C32_h(void);




};

Coef_C32_h Coef_C32_h_i;

// -------------------------------------------------------------


// ---- Coef_v3_h_prev_C31 -------------------------------------

class Coef_v3_h_prev_C31 : public CoefObject
{
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_v3_h_prev_C31(void);
  ~Coef_v3_h_prev_C31(void);
  double v3_;
  
  
  
  
};

Coef_v3_h_prev_C31 Coef_v3_h_prev_C31_i;

// -------------------------------------------------------------


// ---- Coef_v31_v3_h_prev_C32 ---------------------------------

class Coef_v31_v3_h_prev_C32 : public CoefObject
{
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_v31_v3_h_prev_C32(void);
  ~Coef_v31_v3_h_prev_C32(void);
  double v31_;
  double v3_;
  	  




};

Coef_v31_v3_h_prev_C32 Coef_v31_v3_h_prev_C32_i;

// -------------------------------------------------------------


// ---- Coef_L3_h ---------------------------------------------

class Coef_L3_h : public CoefObject
{
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_L3_h(void);
  ~Coef_L3_h(void);

  


};

Coef_L3_h Coef_L3_h_i;

// -------------------------------------------------------------


// ---- Coef_M31_h ---------------------------------------------

	// (Previous defined above.)

// -------------------------------------------------------------


// ---- Coef_M23_h ---------------------------------------------

	// (Previous defined above.)

 // -------------------------------------------------------------



// ---- Coef_L3_M31_M23_h_prev_i12_i22_i32 -------------------------------------

class Coef_L3_M31_M23_h_prev_i12_i22_i32  : public CoefObject
{
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_L3_M31_M23_h_prev_i12_i22_i32(void);
  ~Coef_L3_M31_M23_h_prev_i12_i22_i32(void);
  double i12_;
  double i22_;
  double i32_;
  	   


};

Coef_L3_M31_M23_h_prev_i12_i22_i32 Coef_L3_M31_M23_h_prev_i12_i22_i32_i;

// -------------------------------------------------------------


// ---- Coef_C_n_h ---------------------------------------------

class Coef_C_n_h : public CoefObject
{
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_C_n_h(void);
  ~Coef_C_n_h(void);
	
};

Coef_C_n_h Coef_C_n_h_i;

// -------------------------------------------------------------


// ---- Coef_v_n_h_prev_C_n ------------------------------------

class Coef_v_n_h_prev_C_n : public CoefObject
{
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_v_n_h_prev_C_n(void);
  ~Coef_v_n_h_prev_C_n(void);
  double v_n_;
	
};

Coef_v_n_h_prev_C_n Coef_v_n_h_prev_C_n_i;


// --------------------------------------------------------------
 
 
 CoefObject * CoefObjectList[] = {(CoefObject *)  &Coef_recp_rSrD11_i,
								  (CoefObject *)  &Coef_recp_rSrD12_i,
								  (CoefObject *)  &Coef_C11_h_i,
								  (CoefObject *)  &Coef_C12_h_i,
								  (CoefObject *)  &Coef_v1_h_prev_C11_i,
								  (CoefObject *)  &Coef_v11_v1_h_prev_C12_i,
								  (CoefObject *)  &Coef_L1_h_i,
								  (CoefObject *)  &Coef_M12_h_i,
								  (CoefObject *)  &Coef_M31_h_i,
								  (CoefObject *)  &Coef_L1_M12_M31_h_prev_i12_i22_i32_i,

								  (CoefObject *)  &Coef_recp_rSrD21_i,
								  (CoefObject *)  &Coef_recp_rSrD22_i,
								  (CoefObject *)  &Coef_C21_h_i,
								  (CoefObject *)  &Coef_C22_h_i,
								  (CoefObject *)  &Coef_v2_h_prev_C21_i,
								  (CoefObject *)  &Coef_v21_v2_h_prev_C22_i,
								  (CoefObject *)  &Coef_L2_h_i,
								  (CoefObject *)  &Coef_M23_h_i,
								  (CoefObject *)  &Coef_L2_M12_M23_h_prev_i12_i22_i32_i,

								  (CoefObject *)  &Coef_recp_rSrD31_i,
								  (CoefObject *)  &Coef_recp_rSrD32_i,
								  (CoefObject *)  &Coef_C31_h_i,
								  (CoefObject *)  &Coef_C32_h_i,
								  (CoefObject *)  &Coef_v3_h_prev_C31_i,
								  (CoefObject *)  &Coef_v31_v3_h_prev_C32_i,
								  (CoefObject *)  &Coef_L3_h_i,
								  (CoefObject *)  &Coef_L3_M31_M23_h_prev_i12_i22_i32_i,
								  
								  (CoefObject *)  &Coef_C_n_h_i,
								  (CoefObject *)  &Coef_v_n_h_prev_C_n_i,

								  
								  0};								  
	
	
// ****************************************************************


// **** SwitchObject Classes **************************************

// ---- Switch_rS11 -----------------------------------------------

class Switch_rS11 : public SwitchObject
{
public:
  virtual void CoefRValueUpdate(void);
  Switch_rS11(void);
  ~Switch_rS11(void);

};

Switch_rS11 Switch_rS11_i;

// ----------------------------------------------------------------


// ---- Switch_rS12 -----------------------------------------------

class Switch_rS12 : public SwitchObject
{
public:
  virtual void CoefRValueUpdate(void);
  Switch_rS12(void);
  ~Switch_rS12(void);
};

Switch_rS12 Switch_rS12_i;

// ----------------------------------------------------------------


// ---- Switch_rS21 -----------------------------------------------

class Switch_rS21 : public SwitchObject
{
public:
  virtual void CoefRValueUpdate(void);
  Switch_rS21(void);
  ~Switch_rS21(void);

};

Switch_rS21 Switch_rS21_i;

// ----------------------------------------------------------------


// ---- Switch_rS22 -----------------------------------------------

class Switch_rS22 : public SwitchObject
{
public:
  virtual void CoefRValueUpdate(void);
  Switch_rS22(void);
  ~Switch_rS22(void);
};

Switch_rS22 Switch_rS22_i;

// ----------------------------------------------------------------


// ---- Switch_rS31 -----------------------------------------------

class Switch_rS31 : public SwitchObject
{
public:
  virtual void CoefRValueUpdate(void);
  Switch_rS31(void);
  ~Switch_rS31(void);
};

Switch_rS31 Switch_rS31_i;

// ----------------------------------------------------------------


// ---- Switch_rS32 -----------------------------------------------

class Switch_rS32 : public SwitchObject
{
public:
  virtual void CoefRValueUpdate(void);
  Switch_rS32(void);
  ~Switch_rS32(void);
};

Switch_rS32 Switch_rS32_i;

// ----------------------------------------------------------------


SwitchObject * SwitchObjectList[] = {(SwitchObject *) &Switch_rS11_i,
									 (SwitchObject *) &Switch_rS12_i,
									 (SwitchObject *) &Switch_rS21_i,
									 (SwitchObject *) &Switch_rS22_i,
									 (SwitchObject *) &Switch_rS31_i,
									 (SwitchObject *) &Switch_rS32_i,
									0};

									
									
									
// ****************************************************************




// **** SpiceObject Classes ***************************************

// ---- Spice_ThreePhaseBridge ------------------------------------------

class Spice_ThreePhaseBridge : public SpiceObject
{
public:

  Spice_ThreePhaseBridge(void);
  ~Spice_ThreePhaseBridge(void);
  virtual void SwitchRValueUpdate(void);
  virtual void CoefRValueUpdate(void);
  virtual void SrcRValueUpdate(void);


};


Spice_ThreePhaseBridge Spice_ThreePhaseBridge_i;


// ---------------------------------------------------------------

SpiceObject * SpiceObjectList[] = {(SpiceObject *) &Spice_ThreePhaseBridge_i,
				   0};
				    



// **************************************************************




// **** SrcObject Functions **************************************

// ---- TriangleWave  ----------------------------------------------------

TriangleWave::TriangleWave(void)
{
 
  SrcObjItem * pCurSrcItem;

  SrcFuncName = SRC_FUNC_TriangleWave;
  LiteralName = "TriangleWave";


  //build the SRC Rvalue list.

  pSrcObjRValList = new SrcObjItem;
  pCurSrcItem = pSrcObjRValList;

  pCurSrcItem->pSrcObject = SrcObjectList[SRC_FUNC_PwmA];
  pCurSrcItem->pNextSrcItem = new SrcObjItem;
  pCurSrcItem = pCurSrcItem->pNextSrcItem;
  pCurSrcItem->pSrcObject = SrcObjectList[SRC_FUNC_PwmB];
  pCurSrcItem->pNextSrcItem = new SrcObjItem;
  pCurSrcItem = pCurSrcItem->pNextSrcItem;
  pCurSrcItem->pSrcObject = SrcObjectList[SRC_FUNC_PwmC];

   



  PwmRampDir = 1.0;
#ifdef RECORD_ALL_PROBES
  PlotThisOutput = TRUE;
#endif 
  Plot_Tag = "TriangleWave";
}

TriangleWave::~TriangleWave(void)
{



}

void TriangleWave::SrcFunction(double t)
{
  t_mod += (t - t_prev);
  t_prev = t;

  if(t_mod > HALF_PWM_CYCLE){
    t_mod -=  HALF_PWM_CYCLE;
    PwmRampDir *= -1.0;
  }
 
  y = PWM_GAIN*(t_mod/HALF_PWM_CYCLE - .5)*PwmRampDir + PWM_OFFSET;

}

void TriangleWave::SrcRValueUpdate(void)          
{
  SrcObjItem * pCurSrcItem;

  //Update Rvalues
  pCurSrcItem = pSrcObjRValList;

  ((PwmA *) pCurSrcItem->pSrcObject)->TriAngWave = y;
  ((PwmA *) pCurSrcItem->pSrcObject)->PwmRampDir = PwmRampDir;
  pCurSrcItem = pCurSrcItem->pNextSrcItem;    
  ((PwmB *) pCurSrcItem->pSrcObject)->TriAngWave = y;
  ((PwmB *) pCurSrcItem->pSrcObject)->PwmRampDir = PwmRampDir;
  pCurSrcItem = pCurSrcItem->pNextSrcItem;    
  ((PwmC *) pCurSrcItem->pSrcObject)->TriAngWave = y;
  ((PwmC *) pCurSrcItem->pSrcObject)->PwmRampDir = PwmRampDir;

 

}




// -----------------------------------------------------------------

// ---- PwmA ---------------------------------------------------

PwmA::PwmA(void)
{
  SwitchObjItem * pCurSwitchItem;
  
  SrcFuncName = SRC_FUNC_PwmA;
  LiteralName = "PwmA";
  
 //build the Switch Rvalue list.

  pSwitchObjRValList = new SwitchObjItem;
  pCurSwitchItem = pSwitchObjRValList;

  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS11];
  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS12];
  
  DoProbes = TRUE;
	
	//BiQuad filter initialization. (Initialization for PwmB and PwmC as well).
  SetupIIRBiquadForm2();

}

PwmA::~PwmA(void)
{



}

void PwmA::SrcFunction(double t)
{
	
// !!!!!!!!!!!!!! temp !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

	if((PwmRampDirPrev == 1) and (PwmRampDir == -1))
	{
		i11_sample = i11;
		i21_sample = i21;
		i31_sample = i31;
		i_sample_total = - i21_sample - i31_sample;
		
		i11_sample_filtered = SectCalcForm2(0, i11_sample);
		
		
	//	if(!((SectorNumber == 3) || (SectorNumber == 4)))
		{
			if(i11_sample_filtered >= 0)
			{
				
				V_xo_offset = PWM_GAIN * .06;     //((Ideal is .06 which is 3uS/50uS  .6 and .7 show Spacevector "notch"
			}
			else
			{
				V_xo_offset = 0; // - PWM_GAIN * .01;
				
			}
			
		}		
		
	}
	PwmRampDirPrev = PwmRampDir;
	
	i_total = - i21 - i31;

	bool EnableSwitching = DeadtimeGenerator(t, V_xo >= TriAngWave);
	
	
	if((V_xo + V_xo_offset) > TriAngWave)
	{
		GateCtrl_11 = EnableSwitching;
		GateCtrl_12 = 0;
	}
	else
	{
		GateCtrl_11 = 0;
		GateCtrl_12 = EnableSwitching;
	} 
	
	

// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!	
	

//#define DEADTIME_CTRL_LEGACY
//#define DEADTIME_CTRL_SMART

#if defined(DEADTIME_CTRL_LEGACY)
	bool EnableSwitching = DeadtimeGenerator(t, V_xo >= TriAngWave);
	
	if(V_xo >= TriAngWave)
	{
		GateCtrl_11 = EnableSwitching;
		GateCtrl_12 = 0;
	}
	else
	{
		GateCtrl_11 = 0;
		GateCtrl_12 = EnableSwitching;
	} 
	 
	 
	
#elif defined(DEADTIME_CTRL_SMART)

//	       /\            /\
//	      / A\        B /  \
//     ------------------------ V_xo
//      /      \      /      \
//     /        \    /        \
//    /          \  /          \ 
//	 /            \/            \
// ---------------------------------
//
//
//  A and B are determined by the values of TriAngWave,
//  PwmRampDir and V_xo.   
//
//  If we are using a 12 bit ADC, averaging 16 samples of i11 between A and B will give us an equivilent of 16 bits of resolution.
//  This can only be done when the modulation reference V_xo is at a level which is producing very little output voltage.
//  As the output voltage goes up, we get to the point of allowing only one sample of i11 (12 bit resolution). However, this
//  condition would be associated with high velocity (rapid traverse of the motor) where less accuracy can be tolerated. 
	 
	//For now, we only take one sample at the center of the flyback current.
	if((PwmRampDirPrev == 1) and (PwmRampDir == -1))
	{
		i21_sample = i21;
		i31_sample = i31;
		i_sample_total = - i21_sample - i31_sample;
	}
	PwmRampDirPrev = PwmRampDir;
	
	i_total = - i21 - i31;
	
	

#else

/* 	if(V_xo >= TriAngWave)
	{
		GateCtrl_11 = 1;
		GateCtrl_12 = 0;
	}
	else
	{
		GateCtrl_11 = 0;
		GateCtrl_12 = 1;

	} */
#endif	

}

void PwmA::SwitchRValueUpdate(void)
{
  SwitchObjItem * pCurSwitchItem;

  //Update RValues
  pCurSwitchItem = pSwitchObjRValList;

  ((Switch_rS11 *) pCurSwitchItem->pSwitchObject)->DevGate = GateCtrl_11;
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  ((Switch_rS12 *) pCurSwitchItem->pSwitchObject)->DevGate = GateCtrl_12;



}


bool PwmA::DeadtimeGenerator(double t, bool state)
{
  static double t_previous = DEADTIME_VALUE;
  static bool state_previous = 0;
	
	//"state" is either the value of the phase current (smart deadtime control mode) or
	//the difference between V_xo and TriAngWave (standard deadtime control mode).
	
	if(state != state_previous)
	{
		t_previous = t + DEADTIME_VALUE;
	}
	state_previous = state;
 	
	if(t >= t_previous)
	{
		t_previous = t;
		return TRUE;
	}
	else
	{
		return FALSE;
	}
	
	
}


 
void PwmA::RecordProbes(void)
{
	
#ifdef RECORD_PWM_PROBES
	//(normalize)
  TW_wave.push_back(TriAngWave/PWM_GAIN);
  PwmDir.push_back(PwmRampDir);  
  Ref.push_back((V_xo + V_xo_offset)/PWM_GAIN);
  Current.push_back((i11/10.0 < -2.0) ? -2.0 : i11/10.0);
  CurSmp.push_back((i_sample_total/10.0 < -2.0) ? -2.0 : i_sample_total/10.0);
  LegCurSmp.push_back((i11_sample/10.0 < -2.0) ? -2.0 : i11_sample/10.0);
  SectNum.push_back((double) SectorNumber / 6);
  LegCurSmpFilt.push_back(i11_sample_filtered/10.0);
#endif
 

}

void PwmA::PlotProbes(Gnuplot & SimuPlot, vector<double> & Plot_t, string TagNamesToPlot[])
{

  int i;
  if(TagNamesToPlot[0] == ""){
    SimuPlot.plot_xy(Plot_t, TW_wave, "pwm_carrier");
    SimuPlot.plot_xy(Plot_t, PwmDir, "phase_1_sample");
    SimuPlot.plot_xy(Plot_t, Ref, "phase_1_ref");  
    SimuPlot.plot_xy(Plot_t, Current, "i11");
	SimuPlot.plot_xy(Plot_t, CurSmp, "i21_plus_i31_sample");
	SimuPlot.plot_xy(Plot_t, LegCurSmp, "i11_sample");
	SimuPlot.plot_xy(Plot_t, SectNum, "sector_num");
	SimuPlot.plot_xy(Plot_t, LegCurSmpFilt, "i11_sample_filt");
  }
  else{
    for(i = 0; i < 20; i++){
      if(TagNamesToPlot[i] == "pwm_carrier_1"){
	SimuPlot.plot_xy(Plot_t, TW_wave, "pwm_carrier");
      }
      else if(TagNamesToPlot[i] == "phase_1_sample"){
	SimuPlot.plot_xy(Plot_t, PwmDir, "phase_1_sample");
      }
      else if(TagNamesToPlot[i] == "phase_1_ref"){
	SimuPlot.plot_xy(Plot_t, Ref, "phase_1_ref");  
      }
      else if(TagNamesToPlot[i] == "i11"){
	SimuPlot.plot_xy(Plot_t, Current, "i11");
      }
      else if(TagNamesToPlot[i] == "i21_plus_i31_sample"){
	SimuPlot.plot_xy(Plot_t, CurSmp, "i21_plus_i31_sample");
      }	  
       else if(TagNamesToPlot[i] == "i11_sample"){
	SimuPlot.plot_xy(Plot_t, LegCurSmp, "i11_sample");
      }	
       else if(TagNamesToPlot[i] == "sector_num_1"){
	SimuPlot.plot_xy(Plot_t, SectNum, "sector_num");
      }	 
       else if(TagNamesToPlot[i] == "i11_sample_filt"){
	SimuPlot.plot_xy(Plot_t, LegCurSmpFilt, "i11_sample_filt");
      }		

    }
  }
 
} 
 
 
 
 
 
// -----------------------------------------------------------------


// ---- PwmB ---------------------------------------------------


PwmB::PwmB(void)
{
  SwitchObjItem * pCurSwitchItem;

  SrcFuncName = SRC_FUNC_PwmB;
  LiteralName = "PwmB";
  
   //build the Switch Rvalue list.

  pSwitchObjRValList = new SwitchObjItem;
  pCurSwitchItem = pSwitchObjRValList;

  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS21];
  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS22];  
  
  DoProbes = TRUE;

}


PwmB::~PwmB(void)
{


}


void PwmB::SrcFunction(double t)
{

// !!!!!!!!!!!!!! temp !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

	if((PwmRampDirPrev == 1) and (PwmRampDir == -1))
	{
		i11_sample = i11;
		i21_sample = i21;
		i31_sample = i31;
		i_sample_total = - i11_sample - i31_sample;
		
		i21_sample_filtered = SectCalcForm2(1, i21_sample);
		
		
	//	if(!((SectorNumber == 5) || (SectorNumber == 6)))
		{
			if(i21_sample_filtered >= 0)
			{
				
				V_xo_offset = PWM_GAIN * .06;     //((Ideal is .06 which is 3uS/50uS  .6 and .7 show Spacevector "notch"
			}
			else
			{
				V_xo_offset = 0; // - PWM_GAIN * .01;
				
			}
			
		}		
		
	}
	PwmRampDirPrev = PwmRampDir;
	
	i_total = - i11 - i31;

	bool EnableSwitching = DeadtimeGenerator(t, V_xo >= TriAngWave);
	
	
	if((V_xo + V_xo_offset) > TriAngWave)
	{
		GateCtrl_21 = EnableSwitching;
		GateCtrl_22 = 0;
	}
	else
	{
		GateCtrl_21 = 0;
		GateCtrl_22 = EnableSwitching;
	} 
	
	

// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!	



#if defined(DEADTIME_CTRL_LEGACY)
	bool EnableSwitching = DeadtimeGenerator(t, V_xo >= TriAngWave);

	if(V_xo >= TriAngWave)
	{
		GateCtrl_21 = EnableSwitching;
		GateCtrl_22 = 0;
	}
	else
	{
		GateCtrl_21 = 0;
		GateCtrl_22 = EnableSwitching;

	}  	 
	
#elif defined(DEADTIME_CTRL_SMART)

#else	 
		
/* 	if(V_xo >= TriAngWave)
	{
		GateCtrl_21 = 1;
		GateCtrl_22 = 0;
	}
	else
	{
		GateCtrl_21 = 0;
		GateCtrl_22 = 1;

	}   */
#endif

}

void PwmB::SwitchRValueUpdate(void)
{
  SwitchObjItem * pCurSwitchItem;

  //Update RValues
  pCurSwitchItem = pSwitchObjRValList;

  ((Switch_rS21 *) pCurSwitchItem->pSwitchObject)->DevGate = GateCtrl_21;
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  ((Switch_rS22 *) pCurSwitchItem->pSwitchObject)->DevGate = GateCtrl_22;



}


bool PwmB::DeadtimeGenerator(double t, bool state)
{
  static double t_previous = DEADTIME_VALUE;
  static bool state_previous = 0;
	
	//"state" is either the value of the phase current (smart deadtime control mode) or
	//the difference between V_xo and TriAngWave (standard deadtime control mode).
	
	if(state != state_previous)
	{
		t_previous = t + DEADTIME_VALUE;
	}
	state_previous = state;
 	
	if(t >= t_previous)
	{
		t_previous = t;
		return TRUE;
	}
	else
	{
		return FALSE;
	}
	
	
}


 
void PwmB::RecordProbes(void)
{
	
#ifdef RECORD_PWM_PROBES
	//(normalize)
  TW_wave.push_back(TriAngWave/PWM_GAIN);
  PwmDir.push_back(PwmRampDir);  
  Ref.push_back((V_xo + V_xo_offset)/PWM_GAIN);
  Current.push_back((i21/10.0 < -2.0) ? -2.0 : i21/10.0);
  CurSmp.push_back((i_sample_total/10.0 < -2.0) ? -2.0 : i_sample_total/10.0);
  LegCurSmp.push_back((i21_sample/10.0 < -2.0) ? -2.0 : i21_sample/10.0);
  SectNum.push_back((double) SectorNumber / 6);
  LegCurSmpFilt.push_back(i21_sample_filtered/10.0);
#endif
 

}

void PwmB::PlotProbes(Gnuplot & SimuPlot, vector<double> & Plot_t, string TagNamesToPlot[])
{

  int i;
  if(TagNamesToPlot[0] == ""){
    SimuPlot.plot_xy(Plot_t, TW_wave, "pwm_carrier");
    SimuPlot.plot_xy(Plot_t, PwmDir, "phase_2_sample");
    SimuPlot.plot_xy(Plot_t, Ref, "phase_2_ref");  
    SimuPlot.plot_xy(Plot_t, Current, "i21");
	SimuPlot.plot_xy(Plot_t, CurSmp, "i11_plus_i31_sample");
	SimuPlot.plot_xy(Plot_t, LegCurSmp, "i21_sample");
	SimuPlot.plot_xy(Plot_t, SectNum, "sector_num");
	SimuPlot.plot_xy(Plot_t, LegCurSmpFilt, "i21_sample_filt");
  }
  else{
    for(i = 0; i < 20; i++){
      if(TagNamesToPlot[i] == "pwm_carrier_2"){
	SimuPlot.plot_xy(Plot_t, TW_wave, "pwm_carrier");
      }
      else if(TagNamesToPlot[i] == "phase_2_sample"){
	SimuPlot.plot_xy(Plot_t, PwmDir, "phase_2_sample");
      }
      else if(TagNamesToPlot[i] == "phase_2_ref"){
	SimuPlot.plot_xy(Plot_t, Ref, "phase_2_ref");  
      }
      else if(TagNamesToPlot[i] == "i21"){
	SimuPlot.plot_xy(Plot_t, Current, "i21");
      }
      else if(TagNamesToPlot[i] == "i11_plus_i31_sample"){
	SimuPlot.plot_xy(Plot_t, CurSmp, "i11_plus_i31_sample");
      }  
	  else if(TagNamesToPlot[i] == "i21_sample"){
	SimuPlot.plot_xy(Plot_t, LegCurSmp, "i21_sample");
	  }
	  else if(TagNamesToPlot[i] == "sector_num_2"){
	SimuPlot.plot_xy(Plot_t, SectNum, "sector_num");
      }	 
       else if(TagNamesToPlot[i] == "i21_sample_filt"){
	SimuPlot.plot_xy(Plot_t, LegCurSmpFilt, "i21_sample_filt");
      }		  	  

    }
  }
 
} 






// ----------------------------------------------------------------- 


// ---- PwmC ---------------------------------------------------

PwmC::PwmC(void)
{
  SwitchObjItem * pCurSwitchItem;

  SrcFuncName = SRC_FUNC_PwmC;
  LiteralName = "PwmC";
  
 
    //build the Switch Rvalue list.

  pSwitchObjRValList = new SwitchObjItem;
  pCurSwitchItem = pSwitchObjRValList;

  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS31];
  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS32];  
 
  DoProbes = TRUE;
}

PwmC::~PwmC(void)
{


}


void PwmC::SrcFunction(double t)
{

// !!!!!!!!!!!!!! temp !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

	if((PwmRampDirPrev == 1) and (PwmRampDir == -1))
	{
		i11_sample = i11;
		i21_sample = i21;
		i31_sample = i31;
		i_sample_total = - i11_sample - i21_sample;
		
		i31_sample_filtered = SectCalcForm2(2, i31_sample);
		
		
		//if(!((SectorNumber == 1) || (SectorNumber == 2)))
		{
			if(i31_sample_filtered >= 0)
			{
				
				V_xo_offset = PWM_GAIN * .06;     //((Ideal is .06 which is 3uS/50uS  .6 and .7 show Spacevector "notch"
			}
			else
			{
				V_xo_offset = 0; // - PWM_GAIN * .01;
				
			}
			
		}		
		
	}
	PwmRampDirPrev = PwmRampDir;
	
	i_total = - i11 - i21;

	bool EnableSwitching = DeadtimeGenerator(t, V_xo >= TriAngWave);
	
	
	if((V_xo + V_xo_offset) > TriAngWave)
	{
		GateCtrl_31 = EnableSwitching;
		GateCtrl_32 = 0;
	}
	else
	{
		GateCtrl_31 = 0;
		GateCtrl_32 = EnableSwitching;
	} 
	
	

// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!	




#if defined(DEADTIME_CTRL_LEGACY)
	bool EnableSwitching = DeadtimeGenerator(t, V_xo >= TriAngWave);
	
	if(V_xo >= TriAngWave)
	{
		GateCtrl_31 = EnableSwitching;
		GateCtrl_32 = 0;
	}
	else
	{
		GateCtrl_31 = 0;
		GateCtrl_32 = EnableSwitching;

	}	 
	 
	 
	
#elif defined(DEADTIME_CTRL_SMART)

#else
/* 	if(V_xo >= TriAngWave)
	{
		GateCtrl_31 = 1;
		GateCtrl_32 = 0;
	}
	else
	{
		GateCtrl_31 = 0;
		GateCtrl_32 = 1;

	} */
#endif


}

void PwmC::SwitchRValueUpdate(void)
{
  SwitchObjItem * pCurSwitchItem;

  //Update RValues
  pCurSwitchItem = pSwitchObjRValList;

  ((Switch_rS31 *) pCurSwitchItem->pSwitchObject)->DevGate = GateCtrl_31;
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  ((Switch_rS32 *) pCurSwitchItem->pSwitchObject)->DevGate = GateCtrl_32;



}


bool PwmC::DeadtimeGenerator(double t, bool state)
{
  static double t_previous = DEADTIME_VALUE;
  static bool state_previous = 0;
	
	//"state" is either the value of the phase current (smart deadtime control mode) or
	//the difference between V_xo and TriAngWave (standard deadtime control mode).
	
	if(state != state_previous)
	{
		t_previous = t + DEADTIME_VALUE;
	}
	state_previous = state;
 	
	if(t >= t_previous)
	{
		t_previous = t;
		return TRUE;
	}
	else
	{
		return FALSE;
	}
	
	
}



 
void PwmC::RecordProbes(void)
{
	
#ifdef RECORD_PWM_PROBES
	//(normalize)
  TW_wave.push_back(TriAngWave/PWM_GAIN);
  PwmDir.push_back(PwmRampDir);  
  Ref.push_back((V_xo + V_xo_offset)/PWM_GAIN);
  Current.push_back((i31/10.0 < -2.0) ? -2.0 : i31/10.0);
  CurSmp.push_back((i_sample_total/10.0 < -2.0) ? -2.0 : i_sample_total/10.0);
  LegCurSmp.push_back((i31_sample/10.0 < -2.0) ? -2.0 : i31_sample/10.0);
  SectNum.push_back((double) SectorNumber / 6);
  LegCurSmpFilt.push_back(i31_sample_filtered/10.0);
#endif
 

}

void PwmC::PlotProbes(Gnuplot & SimuPlot, vector<double> & Plot_t, string TagNamesToPlot[])
{

  int i;
  if(TagNamesToPlot[0] == ""){
    SimuPlot.plot_xy(Plot_t, TW_wave, "pwm_carrier");
    SimuPlot.plot_xy(Plot_t, PwmDir, "phase_3_sample");
    SimuPlot.plot_xy(Plot_t, Ref, "phase_3_ref");  
    SimuPlot.plot_xy(Plot_t, Current, "i31");
	SimuPlot.plot_xy(Plot_t, CurSmp, "i11_pluw_i21_sample");
	SimuPlot.plot_xy(Plot_t, LegCurSmp, "i31_sample");
	SimuPlot.plot_xy(Plot_t, SectNum, "sector_num");
	SimuPlot.plot_xy(Plot_t, LegCurSmpFilt, "i31_sample_filt");
  }
  else{
    for(i = 0; i < 20; i++){
      if(TagNamesToPlot[i] == "pwm_carrier_3"){
	SimuPlot.plot_xy(Plot_t, TW_wave, "pwm_carrier");
      }
      else if(TagNamesToPlot[i] == "phase_3_sample"){
	SimuPlot.plot_xy(Plot_t, PwmDir, "phase_3_sample");
      }
      else if(TagNamesToPlot[i] == "phase_3_ref"){
	SimuPlot.plot_xy(Plot_t, Ref, "phase_3_ref");  
      }
      else if(TagNamesToPlot[i] == "i31"){
	SimuPlot.plot_xy(Plot_t, Current, "i31");
      }
      else if(TagNamesToPlot[i] == "i11_pluw_i21_sample"){
	SimuPlot.plot_xy(Plot_t, CurSmp, "i11_pluw_i21_sample");
      }  
	  else if(TagNamesToPlot[i] == "i31_sample"){
	SimuPlot.plot_xy(Plot_t, LegCurSmp, "i31_sample");
	  }
	  else if(TagNamesToPlot[i] == "sector_num_3"){
	SimuPlot.plot_xy(Plot_t, SectNum, "sector_num");
      }	  
        else if(TagNamesToPlot[i] == "i31_sample_filt"){
	SimuPlot.plot_xy(Plot_t, LegCurSmpFilt, "i31_sample_filt");
      }		  
	  
    }
  }
 
} 




// ----------------------------------------------------------------- 



// *****************************************************************


// **** OdeObject Functions ****************************************


// *****************************************************************

// **** CtrlObject Functions ****************************************

// ---- VDqCmd  ---------------------------------------------------

VDqCmd::VDqCmd(void)
{
  SrcObjItem * pCurSrcItem;

  CtrlFuncName = CTRL_FUNC_VDqCmd;
  LiteralName = "VDqCmd";  

    // Definitions here are for minus side "clamped" SVPWM. For regular SVPWM, add ".5*T_Z" to all reference values.
  SVTable[0][0] = TIME_T1_T2;
  SVTable[0][1] = TIME_T2;
  SVTable[0][2] = TIME_NONE;
  SVTable[1][0] = TIME_T1; 
  SVTable[1][1] = TIME_T1_T2;
  SVTable[1][2] = TIME_NONE;
  SVTable[2][0] = TIME_NONE;
  SVTable[2][1] = TIME_T1_T2;
  SVTable[2][2] = TIME_T2;
  SVTable[3][0] = TIME_NONE;
  SVTable[3][1] = TIME_T1;
  SVTable[3][2] = TIME_T1_T2;
  SVTable[4][0] = TIME_T2;
  SVTable[4][1] = TIME_NONE;
  SVTable[4][2] = TIME_T1_T2;
  SVTable[5][0] = TIME_T1_T2;
  SVTable[5][1] = TIME_NONE;
  SVTable[5][2] = TIME_T1;
  
  v_bus = VBus_p - VBus_m;
  
  
   //build the SRC Rvalue list.

  pSrcObjRValList = new SrcObjItem;
  pCurSrcItem = pSrcObjRValList;

  pCurSrcItem->pSrcObject = SrcObjectList[SRC_FUNC_PwmA];  
  pCurSrcItem->pNextSrcItem = new SrcObjItem;
  pCurSrcItem = pCurSrcItem->pNextSrcItem;
  pCurSrcItem->pSrcObject = SrcObjectList[SRC_FUNC_PwmB];
  pCurSrcItem->pNextSrcItem = new SrcObjItem;
  pCurSrcItem = pCurSrcItem->pNextSrcItem;
  pCurSrcItem->pSrcObject = SrcObjectList[SRC_FUNC_PwmC];
  pCurSrcItem->pNextSrcItem = new SrcObjItem;
  pCurSrcItem = pCurSrcItem->pNextSrcItem;
  pCurSrcItem->pSrcObject = SrcObjectList[SRC_FUNC_TriangleWave]; 
  
#ifdef RECORD_ALL_PROBES  
    DoProbes = TRUE;
#endif  

}

VDqCmd::~VDqCmd(void)
{



}

void VDqCmd::CtrlFunction(double t)
{
  int i;

     
#ifdef CTRL_PWM_SCALE

  //For now, we provide constant commands for magnitude and angle.
  //These will come form seperate CTRL later.
  vcmd_mag = 10.0;
  vcmd_ang = PI/2;   //valid values are  +/-PI/2 <= vcmd_ang < +/-PI (pure "q" to pure "d") 
#else
  vcmd_mag = 20.0;
  Freq = 50.0;
  Period = 1.0 / Freq;
  theta = 2.0 * PI * t / Period;
  vcmd_ang = PI/2 + theta;

#endif

  //generate the references.
  SpaceVectorControl();

  
}

void VDqCmd::RecordProbes(void)
{


#ifdef RECORD_ALL_PROBES
  VCmd_a.push_back(V_xo[0]);
  VCmd_b.push_back(V_xo[1]);
  VCmd_c.push_back(V_xo[2]);


  VCmd_mag.push_back(vcmd_mag);
  VCmd_ang.push_back(vcmd_ang);
  FreqScale.push_back(PwmFreqScale);
#endif

}

void VDqCmd::PlotProbes(Gnuplot & SimuPlot, vector<double> & Plot_t, string TagNamesToPlot[])
{

  int i;
  if(TagNamesToPlot[0] == ""){
    SimuPlot.plot_xy(Plot_t, VCmd_a, "VCmd_a");
    SimuPlot.plot_xy(Plot_t, VCmd_b, "VCmd_b");
    SimuPlot.plot_xy(Plot_t, VCmd_c, "VCmd_c");  
    SimuPlot.plot_xy(Plot_t, VCmd_mag, "VCmd_mag");
    SimuPlot.plot_xy(Plot_t, VCmd_ang, "VCmd_ang");  
    SimuPlot.plot_xy(Plot_t, FreqScale, "FreqScale"); 
  }
  else{
    for(i = 0; i < 20; i++){
      if(TagNamesToPlot[i] == "VCmd_a"){
	SimuPlot.plot_xy(Plot_t, VCmd_a, "VCmd_a");
      }
      else if(TagNamesToPlot[i] == "VCmd_b"){
	SimuPlot.plot_xy(Plot_t, VCmd_b, "VCmd_b");
      }
      else if(TagNamesToPlot[i] == "VCmd_c"){
	SimuPlot.plot_xy(Plot_t, VCmd_c, "VCmd_c");
      }
      else if(TagNamesToPlot[i] == "VCmd_mag"){
	SimuPlot.plot_xy(Plot_t, VCmd_mag, "VCmd_mag");
      }
      else if(TagNamesToPlot[i] == "VCmd_ang"){
	SimuPlot.plot_xy(Plot_t, VCmd_ang, "VCmd_ang");
      }
      else if(TagNamesToPlot[i] == "FreqScale"){
	SimuPlot.plot_xy(Plot_t, FreqScale, "FreqScale");
      }

    }
  }


}

void  VDqCmd::SrcRValueUpdate(void)      
{
  SrcObjItem * pCurSrcItem;

  //Update Rvalues
  pCurSrcItem = pSrcObjRValList;

  ((PwmA *) pCurSrcItem->pSrcObject)->V_xo = V_xo[0];
  ((PwmA *) pCurSrcItem->pSrcObject)->SectorNumber = SectorNumber;
  pCurSrcItem = pCurSrcItem->pNextSrcItem;       
  ((PwmB *) pCurSrcItem->pSrcObject)->V_xo = V_xo[1];
  ((PwmB *) pCurSrcItem->pSrcObject)->SectorNumber = SectorNumber;
  pCurSrcItem = pCurSrcItem->pNextSrcItem;       
  ((PwmC *) pCurSrcItem->pSrcObject)->V_xo = V_xo[2];
  ((PwmC *) pCurSrcItem->pSrcObject)->SectorNumber = SectorNumber;
  pCurSrcItem = pCurSrcItem->pNextSrcItem;       
  ((TriangleWave *) pCurSrcItem->pSrcObject)->PwmFreqScale = PwmFreqScale;


}

void VDqCmd::SpaceVectorControl(void) 
{ 
  int SectorIndex;
  double SectorAngle;
  double CtrlAngle;
  double T0, T1, T2;
  double Amplitude;
  double T_Z_Scaled;
  int i;	

  
	
  CtrlAngle = vcmd_ang;                  
  SectorIndex = (int) (CtrlAngle / SECTOR_ANGLE);	
  
  
   if(CtrlAngle >= 0){
    SectorNumber = SectorIndex % 6 + 1;
    SectorAngle = CtrlAngle - (double) (SectorIndex / 6) * SECTOR_ANGLE * 6.0; 
  }
  else{
    SectorNumber = 6 + SectorIndex % 6;
    SectorAngle = CtrlAngle + (double) (6 - SectorIndex / 6) * SECTOR_ANGLE * 6.0; 
  }
  
  T_Z_Scaled = (2.0 / 3.0) * T_Z;

  T1 = SQRT_3 * T_Z_Scaled * vcmd_mag * sin((PI * (double) SectorNumber / 3.0) - SectorAngle) / v_bus;
  T2 = SQRT_3 * T_Z_Scaled * vcmd_mag * sin(SectorAngle - (SectorNumber - 1) * PI / 3.0) / v_bus;
  T0 = T_Z_Scaled - T1 - T2; 
  
	
  for(i = 0; i < 3; i++){	
	
    switch(SVTable[SectorNumber-1][i]){
    case TIME_NONE:
      V_xo[i] = 0;
      break;
    case TIME_T1:
      V_xo[i] = T1;
      break;
    case TIME_T2:
      V_xo[i] = T2;
      break;
    case TIME_T1_T2:
      V_xo[i] = T1 + T2;
      break;
    }	
	
  }
  
#ifdef CTRL_PWM_SCALE
  

  PwmFreqScale = PWM_FREQ_GAIN  * v_bus / vcmd_mag;

  

  if(PwmFreqScale < MIN_PWM_FREQ_SCALE){
    PwmFreqScale = MIN_PWM_FREQ_SCALE;
  }
  else if(PwmFreqScale > MAX_PWM_FREQ_SCALE){
    PwmFreqScale = MAX_PWM_FREQ_SCALE;
  }

#endif 
  
	
}

// ******************************************************************


// **** CoefObject Functions ****************************************


// ---- Coef_recp_rSrD11 ---------------------------------------------

Coef_recp_rSrD11::Coef_recp_rSrD11(void)
{
  CoefFuncName = COEF_FUNC_recp_rSrD11;
  LiteralName = "recp_rSrD11"; 
  rS11 = INIT_COEF_RS_RD;
  rD11 = INIT_COEF_RS_RD;

}

Coef_recp_rSrD11::~Coef_recp_rSrD11(void)
{


}

void Coef_recp_rSrD11::CoefFunction(double recp_h, bool DoTrapezoidal)
{

  y = 1/rS11 + 1/rD11;

}



// ------------------------------------------------------------------

// ---- Coef_recp_rSrD12 ---------------------------------------------

Coef_recp_rSrD12::Coef_recp_rSrD12(void)
{
  CoefFuncName = COEF_FUNC_recp_rSrD12;
  LiteralName = "recp_rSrD12"; 
  rS12 = INIT_COEF_RS_RD;
  rD12 = INIT_COEF_RS_RD;

}

Coef_recp_rSrD12::~Coef_recp_rSrD12(void)
{


}

void Coef_recp_rSrD12::CoefFunction(double recp_h, bool DoTrapezoidal)
{

  y = 1/rS12 + 1/rD12;

}



// ------------------------------------------------------------------        


// ---- Coef_C11_h ----------------------------------------------------

Coef_C11_h::Coef_C11_h(void)
{
  CoefFuncName = COEF_FUNC_C11_h;
  LiteralName = "C11_h";

}

Coef_C11_h::~Coef_C11_h(void)
{


}

void Coef_C11_h::CoefFunction(double recp_h, bool DoTrapezoidal)
{

 	y = C11 * recp_h;

}

// ------------------------------------------------------------------

// ---- Coef_C12_h ----------------------------------------------------

Coef_C12_h::Coef_C12_h(void)
{
  CoefFuncName = COEF_FUNC_C12_h;
  LiteralName = "C12_h";

}

Coef_C12_h::~Coef_C12_h(void)
{


}

void Coef_C12_h::CoefFunction(double recp_h, bool DoTrapezoidal)
{

	y = C12 * recp_h;

}

// ------------------------------------------------------------------


// ---- Coef_v1_h_prev_C11 ------------------------------------------

Coef_v1_h_prev_C11::Coef_v1_h_prev_C11(void)
{
  CoefFuncName = COEF_FUNC_v1_h_prev_C11;
  LiteralName = "v1_h_prev_C11";	
	
  v1_ = (VBus_p - VBus_m) / 2.0;	

}

Coef_v1_h_prev_C11::~Coef_v1_h_prev_C11(void)
{
	
	
}

void Coef_v1_h_prev_C11::CoefFunction(double recp_h, bool DoTrapezoidal)
{
	
   y = v1_ * C11 * recp_h;
	
}


// -------------------------------------------------------------------


// ---- Coef_v11_v1_h_prev_C12 --------------------------------------

Coef_v11_v1_h_prev_C12::Coef_v11_v1_h_prev_C12(void)
{
  CoefFuncName = COEF_FUNC_v11_v1_h_prev_C12;
  LiteralName = "v11_v1_h_prev_C12";
	
  v1_ = (VBus_p - VBus_m) / 2.0;
  v11_ = 0;
}

Coef_v11_v1_h_prev_C12::~Coef_v11_v1_h_prev_C12(void)
{
	
	
}


void Coef_v11_v1_h_prev_C12::CoefFunction(double recp_h, bool DoTrapezoidal)
{

  y = (v11_ - v1_) * C12 * recp_h;

}


// ------------------------------------------------------------------

// ---- Coef_L1_h ---------------------------------------------------

Coef_L1_h::Coef_L1_h(void)
{
  CoefFuncName = COEF_FUNC_L1_h;
  LiteralName = "L1_h";	
	
}
	
Coef_L1_h::~Coef_L1_h(void)
{
	
	
}

void Coef_L1_h::CoefFunction(double recp_h, bool DoTrapezoidal)
{
  y = L1 * recp_h;
	
}

// ------------------------------------------------------------------

// ---- Coef_M12_h ---------------------------------------------------

Coef_M12_h::Coef_M12_h(void)
{
  CoefFuncName = COEF_FUNC_M12_h;
  LiteralName = "M12_h";	
	
}
	
Coef_M12_h::~Coef_M12_h(void)
{
	
	
}

void Coef_M12_h::CoefFunction(double recp_h, bool DoTrapezoidal)
{
  y = M12 * recp_h;
	
}

// ------------------------------------------------------------------


// ---- Coef_M31_h ---------------------------------------------------

Coef_M31_h::Coef_M31_h(void)
{
  CoefFuncName = COEF_FUNC_M31_h;
  LiteralName = "M31_h";	
	
}
	
Coef_M31_h::~Coef_M31_h(void)
{
	
	
}

void Coef_M31_h::CoefFunction(double recp_h, bool DoTrapezoidal)
{
  y = M31 * recp_h;
	
}

// ------------------------------------------------------------------


// ---- Coef_L1_M12_M31_h_prev_i12_i22_i32 --------------------------

Coef_L1_M12_M31_h_prev_i12_i22_i32::Coef_L1_M12_M31_h_prev_i12_i22_i32(void)
{
  CoefFuncName = COEF_FUNC_L1_M12_M31_h_prev_i12_i22_i32;	
  LiteralName = "L1_M12_M31_h_prev_i12_i22_i32";
  
  i12_ = 0;
  i22_ = 0;
  i32_ = 0;
  
}
	
Coef_L1_M12_M31_h_prev_i12_i22_i32::~Coef_L1_M12_M31_h_prev_i12_i22_i32(void)
{
	
	
}	

void Coef_L1_M12_M31_h_prev_i12_i22_i32::CoefFunction(double recp_h, bool DoTrapezoidal)
{
  y = L1*i12_*recp_h - M12*i22_*recp_h - M31*i32_*recp_h;
	
}
	
// ------------------------------------------------------------------	








// ---- Coef_recp_rSrD21 ---------------------------------------------

Coef_recp_rSrD21::Coef_recp_rSrD21(void)
{
  CoefFuncName = COEF_FUNC_recp_rSrD21;
  LiteralName = "recp_rSrD21"; 
  rS21 = INIT_COEF_RS_RD;
  rD21 = INIT_COEF_RS_RD;

}

Coef_recp_rSrD21::~Coef_recp_rSrD21(void)
{


}

void Coef_recp_rSrD21::CoefFunction(double recp_h, bool DoTrapezoidal)
{

  y = 1/rS21 + 1/rD21;

}



// ------------------------------------------------------------------

// ---- Coef_recp_rSrD22 ---------------------------------------------

Coef_recp_rSrD22::Coef_recp_rSrD22(void)
{
  CoefFuncName = COEF_FUNC_recp_rSrD22;
  LiteralName = "recp_rSrD22"; 
  rS22 = INIT_COEF_RS_RD;
  rD22 = INIT_COEF_RS_RD;

}

Coef_recp_rSrD22::~Coef_recp_rSrD22(void)
{


}

void Coef_recp_rSrD22::CoefFunction(double recp_h, bool DoTrapezoidal)
{

  y = 1/rS22 + 1/rD22;

}



// ------------------------------------------------------------------        


// ---- Coef_C21_h ----------------------------------------------------

Coef_C21_h::Coef_C21_h(void)
{
  CoefFuncName = COEF_FUNC_C21_h;
  LiteralName = "C21_h";

}

Coef_C21_h::~Coef_C21_h(void)
{


}

void Coef_C21_h::CoefFunction(double recp_h, bool DoTrapezoidal)
{

 	y = C21 * recp_h;

}

// ------------------------------------------------------------------

// ---- Coef_C22_h ----------------------------------------------------

Coef_C22_h::Coef_C22_h(void)
{
  CoefFuncName = COEF_FUNC_C22_h;
  LiteralName = "C22_h";

}

Coef_C22_h::~Coef_C22_h(void)
{


}

void Coef_C22_h::CoefFunction(double recp_h, bool DoTrapezoidal)
{

	y = C22 * recp_h;

}

// ------------------------------------------------------------------


// ---- Coef_v2_h_prev_C21 ------------------------------------------

Coef_v2_h_prev_C21::Coef_v2_h_prev_C21(void)
{
  CoefFuncName = COEF_FUNC_v2_h_prev_C21;
  LiteralName = "v2_h_prev_C21";	
	
  v2_ = (VBus_p - VBus_m) / 2.0;	

}

Coef_v2_h_prev_C21::~Coef_v2_h_prev_C21(void)
{
	
	
}

void Coef_v2_h_prev_C21::CoefFunction(double recp_h, bool DoTrapezoidal)
{
	
   y = v2_ * C21 * recp_h;
	
}


// -------------------------------------------------------------------


// ---- Coef_v21_v2_h_prev_C22 --------------------------------------

Coef_v21_v2_h_prev_C22::Coef_v21_v2_h_prev_C22(void)
{
  CoefFuncName = COEF_FUNC_v21_v2_h_prev_C22;
  LiteralName = "v21_v2_h_prev_C22";
	
  v2_ = (VBus_p - VBus_m) / 2.0;
  v21_ = 0;
}

Coef_v21_v2_h_prev_C22::~Coef_v21_v2_h_prev_C22(void)
{
	
	
}


void Coef_v21_v2_h_prev_C22::CoefFunction(double recp_h, bool DoTrapezoidal)
{

  y = (v21_ - v2_) * C22 * recp_h;

}


// ------------------------------------------------------------------

// ---- Coef_L2_h ---------------------------------------------------

Coef_L2_h::Coef_L2_h(void)
{
  CoefFuncName = COEF_FUNC_L2_h;
  LiteralName = "L2_h";	
	
}
	
Coef_L2_h::~Coef_L2_h(void)
{
	
	
}

void Coef_L2_h::CoefFunction(double recp_h, bool DoTrapezoidal)
{
  y = L2 * recp_h;
	
}

// ------------------------------------------------------------------

// ---- Coef_M12_h ---------------------------------------------------

 	// (Previous defined above.)

// ------------------------------------------------------------------


// ---- Coef_M23_h ---------------------------------------------------

Coef_M23_h::Coef_M23_h(void)
{
  CoefFuncName = COEF_FUNC_M23_h;
  LiteralName = "M23_h";	
	
}
	
Coef_M23_h::~Coef_M23_h(void)
{
	
	
}

void Coef_M23_h::CoefFunction(double recp_h, bool DoTrapezoidal)
{
  y = M23 * recp_h;
	
}

// ------------------------------------------------------------------


// ---- Coef_L2_M12_M23_h_prev_i12_i22_i32 --------------------------

Coef_L2_M12_M23_h_prev_i12_i22_i32::Coef_L2_M12_M23_h_prev_i12_i22_i32(void)
{
  CoefFuncName = COEF_FUNC_L2_M12_M23_h_prev_i12_i22_i32;	
  LiteralName = "L2_M12_M23_h_prev_i12_i22_i32";
  
  i12_ = 0;
  i22_ = 0;
  i32_ = 0;
  
}
	
Coef_L2_M12_M23_h_prev_i12_i22_i32::~Coef_L2_M12_M23_h_prev_i12_i22_i32(void)
{
	
	
}	

void Coef_L2_M12_M23_h_prev_i12_i22_i32::CoefFunction(double recp_h, bool DoTrapezoidal)
{
  y = L2*i22_*recp_h - M12*i12_*recp_h - M23*i32_*recp_h;
	
}
	
// ------------------------------------------------------------------	








// ---- Coef_recp_rSrD31 ---------------------------------------------

Coef_recp_rSrD31::Coef_recp_rSrD31(void)
{
  CoefFuncName = COEF_FUNC_recp_rSrD31;
  LiteralName = "recp_rSrD31";
  rS31 = INIT_COEF_RS_RD;
  rD31 = INIT_COEF_RS_RD;

}

Coef_recp_rSrD31::~Coef_recp_rSrD31(void)
{


}

void Coef_recp_rSrD31::CoefFunction(double recp_h, bool DoTrapezoidal)
{

  y = 1/rS31 + 1/rD31;

}



// ------------------------------------------------------------------

// ---- Coef_recp_rSrD32 ---------------------------------------------

Coef_recp_rSrD32::Coef_recp_rSrD32(void)
{
  CoefFuncName = COEF_FUNC_recp_rSrD32;
  LiteralName = "recp_rSrD32";
  rS32 = INIT_COEF_RS_RD;
  rD32 = INIT_COEF_RS_RD;

}

Coef_recp_rSrD32::~Coef_recp_rSrD32(void)
{


}

void Coef_recp_rSrD32::CoefFunction(double recp_h, bool DoTrapezoidal)
{

  y = 1/rS32 + 1/rD32;

}



// ------------------------------------------------------------------


// ---- Coef_C31_h ----------------------------------------------------

Coef_C31_h::Coef_C31_h(void)
{
  CoefFuncName = COEF_FUNC_C31_h;
  LiteralName = "C31_h";

}

Coef_C31_h::~Coef_C31_h(void)
{


}

void Coef_C31_h::CoefFunction(double recp_h, bool DoTrapezoidal)
{

 	y = C31 * recp_h;

}

// ------------------------------------------------------------------

// ---- Coef_C32_h ----------------------------------------------------

Coef_C32_h::Coef_C32_h(void)
{
  CoefFuncName = COEF_FUNC_C32_h;
  LiteralName = "C32_h";

}

Coef_C32_h::~Coef_C32_h(void)
{


}

void Coef_C32_h::CoefFunction(double recp_h, bool DoTrapezoidal)
{

	y = C32 * recp_h;

}

// ------------------------------------------------------------------


// ---- Coef_v3_h_prev_C31 ------------------------------------------

Coef_v3_h_prev_C31::Coef_v3_h_prev_C31(void)
{
  CoefFuncName = COEF_FUNC_v3_h_prev_C31;
  LiteralName = "v3_h_prev_C31";

  v3_ = (VBus_p - VBus_m) / 2.0;

}

Coef_v3_h_prev_C31::~Coef_v3_h_prev_C31(void)
{


}

void Coef_v3_h_prev_C31::CoefFunction(double recp_h, bool DoTrapezoidal)
{

   y = v3_ * C31 * recp_h;

}


// -------------------------------------------------------------------


// ---- Coef_v31_v3_h_prev_C32 --------------------------------------

Coef_v31_v3_h_prev_C32::Coef_v31_v3_h_prev_C32(void)
{
  CoefFuncName = COEF_FUNC_v31_v3_h_prev_C32;
  LiteralName = "v31_v3_h_prev_C32";

  v3_ = (VBus_p - VBus_m) / 2.0;
  v31_ = 0;
}

Coef_v31_v3_h_prev_C32::~Coef_v31_v3_h_prev_C32(void)
{


}


void Coef_v31_v3_h_prev_C32::CoefFunction(double recp_h, bool DoTrapezoidal)
{

  y = (v31_ - v3_) * C32 * recp_h;

}


// ------------------------------------------------------------------

// ---- Coef_L3_h ---------------------------------------------------

Coef_L3_h::Coef_L3_h(void)
{
  CoefFuncName = COEF_FUNC_L3_h;
  LiteralName = "L3_h";

}

Coef_L3_h::~Coef_L3_h(void)
{


}

void Coef_L3_h::CoefFunction(double recp_h, bool DoTrapezoidal)
{
  y = L3 * recp_h;

}

// ------------------------------------------------------------------

// ---- Coef_M31_h ---------------------------------------------------

 	// (Previous defined above.)

// ------------------------------------------------------------------


// ---- Coef_M23_h ---------------------------------------------------

	// (Previous defined above.)

// ------------------------------------------------------------------


// ---- Coef_L3_M31_M23_h_prev_i12_i22_i32 --------------------------

Coef_L3_M31_M23_h_prev_i12_i22_i32::Coef_L3_M31_M23_h_prev_i12_i22_i32(void)
{
  CoefFuncName = COEF_FUNC_L3_M31_M23_h_prev_i12_i22_i32;
  LiteralName = "L3_M31_M23_h_prev_i12_i22_i32";

  i12_ = 0;
  i22_ = 0;
  i32_ = 0;

}

Coef_L3_M31_M23_h_prev_i12_i22_i32::~Coef_L3_M31_M23_h_prev_i12_i22_i32(void)
{


}

void Coef_L3_M31_M23_h_prev_i12_i22_i32::CoefFunction(double recp_h, bool DoTrapezoidal)
{
  y = L3*i32_*recp_h - M31*i12_*recp_h - M23*i22_*recp_h;

}

// ------------------------------------------------------------------








// ---- Coef_C_n_h ---------------------------------------------

Coef_C_n_h::Coef_C_n_h(void)
{
  CoefFuncName = COEF_FUNC_C_n_h;
  LiteralName = "C_n_h";
	
};

Coef_C_n_h::~Coef_C_n_h(void) 
{
	
	
}
 
void Coef_C_n_h::CoefFunction(double recp_h, bool DoTrapezoidal)
{
  y = C_n * recp_h;

}

// -------------------------------------------------------------


// ---- Coef_v_n_h_prev_C_n ------------------------------------

Coef_v_n_h_prev_C_n::Coef_v_n_h_prev_C_n(void)
{
  CoefFuncName = COEF_FUNC_v_n_h_prev_C_n;
  LiteralName = "v_n_h_prev_C_n";
  
  v_n_ = 0;
	
};

Coef_v_n_h_prev_C_n::~Coef_v_n_h_prev_C_n(void) 
{
	
	
}
 
void Coef_v_n_h_prev_C_n::CoefFunction(double recp_h, bool DoTrapezoidal)
{
  y = v_n_ * C_n * recp_h;

} 


// --------------------------------------------------------------








// ******************************************************************


// **** SwitchObject Functions **************************************

// ---- Switch_rS11 -----------------------------------------------

Switch_rS11::Switch_rS11(void)
{

  CoefObjItem * pCurCoefItem;

  SwitchFuncName = SWITCH_FUNC_rS11;
  LiteralName = "rS11";

  	  //Override defaults to make switch transition faster (look at "rS11_res" probe)
  IgbtOnCondTime =  .0000002;             //seconds delay for intermediate "OnDelayRes"
  IgbtOffCondRate = 20e10;         		 //ohms/second
  GateDelay = .0000001;  					 //seconds


  //build the COEF Rvalue list.

  pCoefObjRValList = new CoefObjItem;
  pCurCoefItem = pCoefObjRValList;

  pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_recp_rSrD11];

  IsIgbt = TRUE;
  IsMinusPol = FALSE;

#ifdef PLOT_SWITCHOBJECT_PROBES_rS11
  DoProbes = TRUE;
#ifdef DO_PROBE_rS11_res
  DoProbes_res = TRUE;
#endif
#ifdef DO_PROBE_rS11_cur
  DoProbes_cur = TRUE;
#endif
#ifdef DO_PROBE_rS11_gate
  DoProbes_gate = TRUE;
#endif
#endif


}

Switch_rS11::~Switch_rS11(void)
{

}

void Switch_rS11::CoefRValueUpdate(void)
{
  CoefObjItem * pCurCoefItem;

  //Update Rvalues
  pCurCoefItem = pCoefObjRValList;

  ((Coef_recp_rSrD11 *) pCurCoefItem->pCoefObject)->rS11 = y_igbt;
  ((Coef_recp_rSrD11 *) pCurCoefItem->pCoefObject)->rD11 = y_diode;

}

// ------------------------------------------------------------------


// ---- Switch_rS12 -----------------------------------------------

Switch_rS12::Switch_rS12(void)
{

  CoefObjItem * pCurCoefItem;

  SwitchFuncName = SWITCH_FUNC_rS12;
  LiteralName = "rS12";

	 //Override defaults to make switch transition faster (look at "rS12_res" probe)
  IgbtOnCondTime =  .0000002;             //seconds delay for intermediate "OnDelayRes"
  IgbtOffCondRate = 20e10;         		 //ohms/second
  GateDelay = .0000001;  					 //seconds


  //build the COEF Rvalue list.

  pCoefObjRValList = new CoefObjItem;
  pCurCoefItem = pCoefObjRValList;

  pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_recp_rSrD12];


  IsIgbt = TRUE;
  IsMinusPol = FALSE;


#ifdef PLOT_SWITCHOBJECT_PROBES_rS12
  DoProbes = TRUE;
#ifdef DO_PROBE_rS12_res
  DoProbes_res = TRUE;
#endif
#ifdef DO_PROBE_rS12_cur
  DoProbes_cur = TRUE;
#endif
#ifdef DO_PROBE_rS12_gate
  DoProbes_gate = TRUE;
#endif
#endif


}

Switch_rS12::~Switch_rS12(void)
{

}

void Switch_rS12::CoefRValueUpdate(void)
{
  CoefObjItem * pCurCoefItem;

  //Update Rvalues
  pCurCoefItem = pCoefObjRValList;

  ((Coef_recp_rSrD12 *) pCurCoefItem->pCoefObject)->rS12 = y_igbt;
  ((Coef_recp_rSrD12 *) pCurCoefItem->pCoefObject)->rD12 = y_diode;

}


// ------------------------------------------------------------------


// ---- Switch_rS21 -----------------------------------------------

Switch_rS21::Switch_rS21(void)
{

  CoefObjItem * pCurCoefItem;

  SwitchFuncName = SWITCH_FUNC_rS21;
  LiteralName = "rS21";

  	  //Override defaults to make switch transition faster (look at "rS11_res" probe)
  IgbtOnCondTime =  .0000002;             //seconds delay for intermediate "OnDelayRes"
  IgbtOffCondRate = 20e10;         		 //ohms/second
  GateDelay = .0000001;  					 //seconds

  //build the COEF Rvalue list.

  pCoefObjRValList = new CoefObjItem;
  pCurCoefItem = pCoefObjRValList;

  pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_recp_rSrD21];

  IsIgbt = TRUE;
  IsMinusPol = FALSE;

#ifdef PLOT_SWITCHOBJECT_PROBES_rS21
  DoProbes = TRUE;
#ifdef DO_PROBE_rS21_res
  DoProbes_res = TRUE;
#endif
#ifdef DO_PROBE_rS21_cur
  DoProbes_cur = TRUE;
#endif
#ifdef DO_PROBE_rS21_gate
  DoProbes_gate = TRUE;
#endif
#endif


}

Switch_rS21::~Switch_rS21(void)
{

}

void Switch_rS21::CoefRValueUpdate(void)
{
  CoefObjItem * pCurCoefItem;

  //Update Rvalues
  pCurCoefItem = pCoefObjRValList;

  ((Coef_recp_rSrD21 *) pCurCoefItem->pCoefObject)->rS21 = y_igbt;
  ((Coef_recp_rSrD21 *) pCurCoefItem->pCoefObject)->rD21 = y_diode;

}


// ------------------------------------------------------------------


// ---- Switch_rS22 -----------------------------------------------

Switch_rS22::Switch_rS22(void)
{

  CoefObjItem * pCurCoefItem;

  SwitchFuncName = SWITCH_FUNC_rS22;
  LiteralName = "rS22";

  //Override defaults to make switch transition faster (look at "rS11_res" probe)
  IgbtOnCondTime =  .0000002;             //seconds delay for intermediate "OnDelayRes"
  IgbtOffCondRate = 20e10;         		 //ohms/second
  GateDelay = .0000001;  					 //seconds


  //build the COEF Rvalue list.

  pCoefObjRValList = new CoefObjItem;
  pCurCoefItem = pCoefObjRValList;

  pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_recp_rSrD22];


  IsIgbt = TRUE;
  IsMinusPol = FALSE;

#ifdef PLOT_SWITCHOBJECT_PROBES_rS22
  DoProbes = TRUE;
#ifdef DO_PROBE_rS22_res
  DoProbes_res = TRUE;
#endif
#ifdef DO_PROBE_rS22_cur
  DoProbes_cur = TRUE;
#endif
#ifdef DO_PROBE_rS22_gate
  DoProbes_gate = TRUE;
#endif
#endif



}

Switch_rS22::~Switch_rS22(void)
{

}

void Switch_rS22::CoefRValueUpdate(void)
{
  CoefObjItem * pCurCoefItem;

  //Update Rvalues
  pCurCoefItem = pCoefObjRValList;

  ((Coef_recp_rSrD22 *) pCurCoefItem->pCoefObject)->rS22 = y_igbt;
  ((Coef_recp_rSrD22 *) pCurCoefItem->pCoefObject)->rD22 = y_diode;

}



// ------------------------------------------------------------------


// ---- Switch_rS31 -----------------------------------------------

Switch_rS31::Switch_rS31(void)
{

  CoefObjItem * pCurCoefItem;

  SwitchFuncName = SWITCH_FUNC_rS31;
  LiteralName = "rS31";

    //Override defaults to make switch transition faster (look at "rS11_res" probe)
  IgbtOnCondTime =  .0000002;             //seconds delay for intermediate "OnDelayRes"
  IgbtOffCondRate = 20e10;         		 //ohms/second
  GateDelay = .0000001;  					 //seconds

  //build the COEF Rvalue list.

  pCoefObjRValList = new CoefObjItem;
  pCurCoefItem = pCoefObjRValList;

  pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_recp_rSrD31];



  IsIgbt = TRUE;
  IsMinusPol = FALSE;


#ifdef PLOT_SWITCHOBJECT_PROBES_rS31
  DoProbes = TRUE;
#ifdef DO_PROBE_rS31_res
  DoProbes_res = TRUE;
#endif
#ifdef DO_PROBE_rS31_cur
  DoProbes_cur = TRUE;
#endif
#ifdef DO_PROBE_rS31_gate
  DoProbes_gate = TRUE;
#endif
#endif



}

Switch_rS31::~Switch_rS31(void)
{

}

void Switch_rS31::CoefRValueUpdate(void)
{
  CoefObjItem * pCurCoefItem;

  //Update Rvalues
  pCurCoefItem = pCoefObjRValList;

  ((Coef_recp_rSrD31 *) pCurCoefItem->pCoefObject)->rS31 = y_igbt;
  ((Coef_recp_rSrD31 *) pCurCoefItem->pCoefObject)->rD31 = y_diode;

}



// ------------------------------------------------------------------


// ---- Switch_rS32 -----------------------------------------------

Switch_rS32::Switch_rS32(void)
{

  CoefObjItem * pCurCoefItem;

  SwitchFuncName = SWITCH_FUNC_rS32;
  LiteralName = "rS32";

    //Override defaults to make switch transition faster (look at "rS11_res" probe)
  IgbtOnCondTime =  .0000002;             //seconds delay for intermediate "OnDelayRes"
  IgbtOffCondRate = 20e10;         		 //ohms/second
  GateDelay = .0000001;  					 //seconds

  //build the COEF Rvalue list.

  pCoefObjRValList = new CoefObjItem;
  pCurCoefItem = pCoefObjRValList;

  pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_recp_rSrD32];


  IsIgbt = TRUE;
  IsMinusPol = FALSE;


#ifdef PLOT_SWITCHOBJECT_PROBES_rS32
  DoProbes = TRUE;
#ifdef DO_PROBE_rS32_res
  DoProbes_res = TRUE;
#endif
#ifdef DO_PROBE_rS32_cur
  DoProbes_cur = TRUE;
#endif
#ifdef DO_PROBE_rS32_gate
  DoProbes_gate = TRUE;
#endif
#endif

}

Switch_rS32::~Switch_rS32(void)
{

}

void Switch_rS32::CoefRValueUpdate(void)
{
  CoefObjItem * pCurCoefItem;

  //Update Rvalues
  pCurCoefItem = pCoefObjRValList;

  ((Coef_recp_rSrD32 *) pCurCoefItem->pCoefObject)->rS32 = y_igbt;
  ((Coef_recp_rSrD32 *) pCurCoefItem->pCoefObject)->rD32 = y_diode;

}


// ------------------------------------------------------------------



// ******************************************************************



	
// **** SpiceObject Functions ***************************************


// ---- Spice_ThreePhaseBridge ------------------------------------------


Spice_ThreePhaseBridge::Spice_ThreePhaseBridge(void)
{

	  SwitchObjItem * pCurSwitchItem;
	  CoefObjItem * pCurCoefItem;
	  SrcObjItem * pCurSrcItem;


	  SpiceFuncName = SPICE_FUNC_ThreePhaseBridge;
	  LiteralName = "TPB";

#ifdef PLOT_SPICEOBJECT_PROBES_solution_vector
  DoProbes = TRUE;
#endif


  InitializeMatrix(32);   //(32 rows, 33 columns)

  //Eq. (1)
  a_CoefObj[0][Ind_v1] = &Coef_recp_rSrD11_i;
  a_Static[0][Ind_v1] = 1.0;
  a_CoefObj[0][Ind_i1st] = 0;
  a_Static[0][Ind_i1st] = -1.0;
  a_CoefObj[0][32] = &Coef_recp_rSrD11_i;
  a_Static[0][32] = VBus_p;

  //Eq. (2)
  a_CoefObj[1][Ind_v11] = &Coef_recp_rSrD12_i;
  a_Static[1][Ind_v11] = 1.0;
  a_CoefObj[1][Ind_v1] = &Coef_recp_rSrD12_i;
  a_Static[1][Ind_v1] = -1.0;
  a_CoefObj[1][Ind_i1sb] = 0;
  a_Static[1][Ind_i1sb] = -1.0;
  a_CoefObj[1][32] = 0;
  a_Static[1][32] = 0;

  //Eq. (3)
  a_CoefObj[2][Ind_i12] = 0;
  a_Static[2][Ind_i12] = 1.0;
  a_CoefObj[2][Ind_i11] = 0;
  a_Static[2][Ind_i11] = 1.0;
  a_CoefObj[2][Ind_i13] = 0;
  a_Static[2][Ind_i13] = -1.0;
  a_CoefObj[2][32] = 0;
  a_Static[2][32] = 0;

   //Eq. (4)
   a_CoefObj[3][Ind_i1st] = 0;
   a_Static[3][Ind_i1st] = 1.0;
   a_CoefObj[3][Ind_i1ct] = 0;
   a_Static[3][Ind_i1ct] = 1.0;
   a_CoefObj[3][Ind_i13] = 0;
   a_Static[3][Ind_i13] = -1.0;
   a_CoefObj[3][32] = 0;
   a_Static[3][32] = 0;

    //Eq. (5)
	a_CoefObj[4][Ind_i1sb] = 0;
	a_Static[4][Ind_i1sb] = 1.0;
	a_CoefObj[4][Ind_i1cb] = 0;
    a_Static[4][Ind_i1cb] = 1.0;
	a_CoefObj[4][Ind_i11] = 0;
	a_Static[4][Ind_i11] = -1.0;
	a_CoefObj[4][32] = 0;
	a_Static[4][32] = 0;

    //Eq. (6)
	a_CoefObj[5][Ind_v1] = &Coef_C11_h_i;
	a_Static[5][Ind_v1] = 1.0;
	a_CoefObj[5][Ind_i1ct] = 0;
	a_Static[5][Ind_i1ct] = -1.0;
	a_CoefObj[5][32] = &Coef_v1_h_prev_C11_i;
	a_Static[5][32] = 1.0;

     //Eq. (7)
	a_CoefObj[6][Ind_v11] = &Coef_C12_h_i;
	a_Static[6][Ind_v11] = 1.0;
	a_CoefObj[6][Ind_v1] = &Coef_C12_h_i;
	a_Static[6][Ind_v1] = -1.0;
	a_CoefObj[6][Ind_i1cb] = 0;
	a_Static[6][Ind_i1cb] = -1.0;
	a_CoefObj[6][32] = &Coef_v11_v1_h_prev_C12_i;
	a_Static[6][32] = 1.0;

    //Eq. (8)
	a_CoefObj[7][Ind_v11] = 0;
	a_Static[7][Ind_v11] = RECEP_R12;
	a_CoefObj[7][Ind_i11] = 0;
	a_Static[7][Ind_i11] = 1.0;;
	a_CoefObj[7][32] = 0;
	a_Static[7][32] = VBus_m*RECEP_R12;;

    //Eq. (9)
	a_CoefObj[8][Ind_i12] = &Coef_L1_h_i;
	a_Static[8][Ind_i12] = 1.0;
	a_CoefObj[8][Ind_i22] = &Coef_M12_h_i;
	a_Static[8][Ind_i22] = -1.0;
	a_CoefObj[8][Ind_i32] = &Coef_M31_h_i;
	a_Static[8][Ind_i32] = -1.0;
	a_CoefObj[8][Ind_v12] = 0;
	a_Static[8][Ind_v12] = -1.0;
	a_CoefObj[8][Ind_v1] = 0;
	a_Static[8][Ind_v1] = 1.0;
	a_CoefObj[8][32] = &Coef_L1_M12_M31_h_prev_i12_i22_i32_i;
	a_Static[8][32] = 1.0;

    //Eq. (10)
	a_CoefObj[9][Ind_v_n] = 0;
	a_Static[9][Ind_v_n] = RECEP_R11;
	a_CoefObj[9][Ind_v12] = 0;
	a_Static[9][Ind_v12] = -RECEP_R11;
	a_CoefObj[9][Ind_i12] = 0;
	a_Static[9][Ind_i12] = -1.0;
	a_CoefObj[9][32] = 0;
	a_Static[9][32] = 0;








	//Eq. (11)
	a_CoefObj[10][Ind_v2] = &Coef_recp_rSrD21_i;
	a_Static[10][Ind_v2] = 1.0;
	a_CoefObj[10][Ind_i2st] = 0;
	a_Static[10][Ind_i2st] = -1.0;
	a_CoefObj[10][32] = &Coef_recp_rSrD21_i;
	a_Static[10][32] = VBus_p;

	//Eq. (12)
	a_CoefObj[11][Ind_v21] = &Coef_recp_rSrD22_i;
	a_Static[11][Ind_v21] = 1.0;
	a_CoefObj[11][Ind_v2] = &Coef_recp_rSrD22_i;
	a_Static[11][Ind_v2] = -1.0;
	a_CoefObj[11][Ind_i2sb] = 0;
	a_Static[11][Ind_i2sb] = -1.0;
	a_CoefObj[11][32] = 0;
	a_Static[11][32] = 0;

	//Eq. (13)
	a_CoefObj[12][Ind_i22] = 0;
	a_Static[12][Ind_i22] = 1.0;
	a_CoefObj[12][Ind_i21] = 0;
	a_Static[12][Ind_i21] = 1.0;
	a_CoefObj[12][Ind_i23] = 0;
	a_Static[12][Ind_i23] = -1.0;
	a_CoefObj[12][32] = 0;
	a_Static[12][32] = 0;

	//Eq. (14)
	a_CoefObj[13][Ind_i2st] = 0;
	a_Static[13][Ind_i2st] = 1.0;
	a_CoefObj[13][Ind_i2ct] = 0;
	a_Static[13][Ind_i2ct] = 1.0;
	a_CoefObj[13][Ind_i23] = 0;
	a_Static[13][Ind_i23] = -1.0;
	a_CoefObj[13][32] = 0;
	a_Static[13][32] = 0;

	//Eq. (15)
	a_CoefObj[14][Ind_i2sb] = 0;
	a_Static[14][Ind_i2sb] = 1.0;
	a_CoefObj[14][Ind_i2cb] = 0;
	a_Static[14][Ind_i2cb] = 1.0;
	a_CoefObj[14][Ind_i21] = 0;
	a_Static[14][Ind_i21] = -1.0;
	a_CoefObj[14][32] = 0;
	a_Static[14][32] = 0;

	//Eq. (16)
	a_CoefObj[15][Ind_v2] = &Coef_C21_h_i;
	a_Static[15][Ind_v2] = 1.0;
	a_CoefObj[15][Ind_i2ct] = 0;
	a_Static[15][Ind_i2ct] = -1.0;
	a_CoefObj[15][32] = &Coef_v2_h_prev_C21_i;
	a_Static[15][32] = 1.0;

	 //Eq. (17)
	a_CoefObj[16][Ind_v21] = &Coef_C22_h_i;
	a_Static[16][Ind_v21] = 1.0;
	a_CoefObj[16][Ind_v2] = &Coef_C22_h_i;
	a_Static[16][Ind_v2] = -1.0;
	a_CoefObj[16][Ind_i2cb] = 0;
	a_Static[16][Ind_i2cb] = -1.0;
	a_CoefObj[16][32] = &Coef_v21_v2_h_prev_C22_i;
	a_Static[16][32] = 1.0;

	//Eq. (18)
	a_CoefObj[17][Ind_v21] = 0;
	a_Static[17][Ind_v21] = RECEP_R22;
	a_CoefObj[17][Ind_i21] = 0;
	a_Static[17][Ind_i21] = 1.0;;
	a_CoefObj[17][32] = 0;
	a_Static[17][32] = VBus_m*RECEP_R22;;

	//Eq. (19)
	a_CoefObj[18][Ind_i22] = &Coef_L2_h_i;
	a_Static[18][Ind_i22] = 1.0;
	a_CoefObj[18][Ind_i12] = &Coef_M12_h_i;
	a_Static[18][Ind_i12] = -1.0;
	a_CoefObj[18][Ind_i32] = &Coef_M23_h_i;
	a_Static[18][Ind_i32] = -1.0;
	a_CoefObj[18][Ind_v22] = 0;
	a_Static[18][Ind_v22] = -1.0;
	a_CoefObj[18][Ind_v2] = 0;
	a_Static[18][Ind_v2] = 1.0;
	a_CoefObj[18][32] = &Coef_L2_M12_M23_h_prev_i12_i22_i32_i;
	a_Static[18][32] = 1.0;

	//Eq. (20)
	a_CoefObj[19][Ind_v_n] = 0;
	a_Static[19][Ind_v_n] = RECEP_R21;
	a_CoefObj[19][Ind_v22] = 0;
	a_Static[19][Ind_v22] = -RECEP_R21;
	a_CoefObj[19][Ind_i22] = 0;
	a_Static[19][Ind_i22] = -1.0;
	a_CoefObj[19][32] = 0;
	a_Static[19][32] = 0;










	//Eq. (21)
	a_CoefObj[20][Ind_v3] = &Coef_recp_rSrD31_i;
	a_Static[20][Ind_v3] = 1.0;
	a_CoefObj[20][Ind_i3st] = 0;
	a_Static[20][Ind_i3st] = -1.0;
	a_CoefObj[20][32] = &Coef_recp_rSrD31_i;
	a_Static[20][32] = VBus_p;

	//Eq. (22)
	a_CoefObj[21][Ind_v31] = &Coef_recp_rSrD32_i;
	a_Static[21][Ind_v31] = 1.0;
	a_CoefObj[21][Ind_v3] = &Coef_recp_rSrD32_i;
	a_Static[21][Ind_v3] = -1.0;
	a_CoefObj[21][Ind_i3sb] = 0;
	a_Static[21][Ind_i3sb] = -1.0;
	a_CoefObj[21][32] = 0;
	a_Static[21][32] = 0;

	//Eq. (23)
	a_CoefObj[22][Ind_i32] = 0;
	a_Static[22][Ind_i32] = 1.0;
	a_CoefObj[22][Ind_i31] = 0;
	a_Static[22][Ind_i31] = 1.0;
	a_CoefObj[22][Ind_i33] = 0;
	a_Static[22][Ind_i33] = -1.0;
	a_CoefObj[22][32] = 0;
	a_Static[22][32] = 0;

	//Eq. (24)
	a_CoefObj[23][Ind_i3st] = 0;
	a_Static[23][Ind_i3st] = 1.0;
	a_CoefObj[23][Ind_i3ct] = 0;
	a_Static[23][Ind_i3ct] = 1.0;
	a_CoefObj[23][Ind_i33] = 0;
	a_Static[23][Ind_i33] = -1.0;
	a_CoefObj[23][32] = 0;
	a_Static[23][32] = 0;

	//Eq. (25)
	a_CoefObj[24][Ind_i3sb] = 0;
	a_Static[24][Ind_i3sb] = 1.0;
	a_CoefObj[24][Ind_i3cb] = 0;
	a_Static[24][Ind_i3cb] = 1.0;
	a_CoefObj[24][Ind_i31] = 0;
	a_Static[24][Ind_i31] = -1.0;
	a_CoefObj[24][32] = 0;
	a_Static[24][32] = 0;

	//Eq. (26)
	a_CoefObj[25][Ind_v3] = &Coef_C31_h_i;
	a_Static[25][Ind_v3] = 1.0;
	a_CoefObj[25][Ind_i3ct] = 0;
	a_Static[25][Ind_i3ct] = -1.0;
	a_CoefObj[25][32] = &Coef_v3_h_prev_C31_i;
	a_Static[25][32] = 1.0;

	 //Eq. (27)
	a_CoefObj[26][Ind_v31] = &Coef_C32_h_i;
	a_Static[26][Ind_v31] = 1.0;
	a_CoefObj[26][Ind_v3] = &Coef_C32_h_i;
	a_Static[26][Ind_v3] = -1.0;
	a_CoefObj[26][Ind_i3cb] = 0;
	a_Static[26][Ind_i3cb] = -1.0;
	a_CoefObj[26][32] = &Coef_v31_v3_h_prev_C32_i;
	a_Static[26][32] = 1.0;

	//Eq. (28)
	a_CoefObj[27][Ind_v31] = 0;
	a_Static[27][Ind_v31] = RECEP_R32;
	a_CoefObj[27][Ind_i31] = 0;
	a_Static[27][Ind_i31] = 1.0;;
	a_CoefObj[27][32] = 0;
	a_Static[27][32] = VBus_m*RECEP_R32;;

	//Eq. (29)
	a_CoefObj[28][Ind_i32] = &Coef_L3_h_i;
	a_Static[28][Ind_i32] = 1.0;
	a_CoefObj[28][Ind_i12] = &Coef_M31_h_i;
	a_Static[28][Ind_i12] = -1.0;
	a_CoefObj[28][Ind_i22] = &Coef_M23_h_i;
	a_Static[28][Ind_i22] = -1.0;
	a_CoefObj[28][Ind_v32] = 0;
	a_Static[28][Ind_v32] = -1.0;
	a_CoefObj[28][Ind_v3] = 0;
	a_Static[28][Ind_v3] = 1.0;
	a_CoefObj[28][32] = &Coef_L3_M31_M23_h_prev_i12_i22_i32_i;
	a_Static[28][32] = 1.0;

	//Eq. (30)
	a_CoefObj[29][Ind_v_n] = 0;
	a_Static[29][Ind_v_n] = RECEP_R31;
	a_CoefObj[29][Ind_v32] = 0;
	a_Static[29][Ind_v32] = -RECEP_R31;
	a_CoefObj[29][Ind_i32] = 0;
	a_Static[29][Ind_i32] = -1.0;
	a_CoefObj[29][32] = 0;
	a_Static[29][32] = 0;



	


	//Eq. (31)
	a_CoefObj[30][Ind_i12] = 0;
	a_Static[30][Ind_i12] = 1.0;
	a_CoefObj[30][Ind_i22] = 0;
	a_Static[30][Ind_i22] = 1.0;
	a_CoefObj[30][Ind_i32] = 0;
	a_Static[30][Ind_i32] = 1.0;
	a_CoefObj[30][Ind_i_n] = 0;
	a_Static[30][Ind_i_n] = -1.0;	
	a_CoefObj[30][32] = 0;
	a_Static[30][32] = 0;
	
	//Ex. (32)
	a_CoefObj[31][Ind_v_n] = &Coef_C_n_h_i;
	a_Static[31][Ind_v_n] = 1.0;
	a_CoefObj[31][Ind_i_n] = 0;
	a_Static[31][Ind_i_n] = 1.0;
	a_CoefObj[31][32] = &Coef_v_n_h_prev_C_n_i;
	a_Static[31][32] = 1.0;	



	//build the SWITCH Rvalue list.

	pSwitchObjRValList = new SwitchObjItem;
	pCurSwitchItem = pSwitchObjRValList;

	pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS11];
	pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS12];
	pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS21];
	pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS22];
	pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS31];
	pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS32];





	//build the COEF Rvalue list.

	pCoefObjRValList = new CoefObjItem;
	pCurCoefItem = pCoefObjRValList;

	pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_v1_h_prev_C11];
	pCurCoefItem->pNextCoefItem = new CoefObjItem;
	pCurCoefItem = pCurCoefItem->pNextCoefItem;
	pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_v11_v1_h_prev_C12];
	pCurCoefItem->pNextCoefItem = new CoefObjItem;
	pCurCoefItem = pCurCoefItem->pNextCoefItem;
	pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_L1_M12_M31_h_prev_i12_i22_i32];
	pCurCoefItem->pNextCoefItem = new CoefObjItem;
	pCurCoefItem = pCurCoefItem->pNextCoefItem;

	pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_v2_h_prev_C21];
	pCurCoefItem->pNextCoefItem = new CoefObjItem;
	pCurCoefItem = pCurCoefItem->pNextCoefItem;
	pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_v21_v2_h_prev_C22];
	pCurCoefItem->pNextCoefItem = new CoefObjItem;
	pCurCoefItem = pCurCoefItem->pNextCoefItem;
	pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_L2_M12_M23_h_prev_i12_i22_i32];
	pCurCoefItem->pNextCoefItem = new CoefObjItem;
	pCurCoefItem = pCurCoefItem->pNextCoefItem;

	pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_v3_h_prev_C31];
	pCurCoefItem->pNextCoefItem = new CoefObjItem;
	pCurCoefItem = pCurCoefItem->pNextCoefItem;
	pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_v31_v3_h_prev_C32];
	pCurCoefItem->pNextCoefItem = new CoefObjItem;
	pCurCoefItem = pCurCoefItem->pNextCoefItem;
	pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_L3_M31_M23_h_prev_i12_i22_i32];
	pCurCoefItem->pNextCoefItem = new CoefObjItem;
	pCurCoefItem = pCurCoefItem->pNextCoefItem;
	
	pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_v_n_h_prev_C_n];	
	
	
	
	//build the SRC Rvalue list.

	pSrcObjRValList = new SrcObjItem;
	pCurSrcItem = pSrcObjRValList;

	pCurSrcItem->pSrcObject = SrcObjectList[SRC_FUNC_PwmA];
	pCurSrcItem->pNextSrcItem = new SrcObjItem;
	pCurSrcItem = pCurSrcItem->pNextSrcItem;
	pCurSrcItem->pSrcObject = SrcObjectList[SRC_FUNC_PwmB];
	pCurSrcItem->pNextSrcItem = new SrcObjItem;
	pCurSrcItem = pCurSrcItem->pNextSrcItem;
	pCurSrcItem->pSrcObject = SrcObjectList[SRC_FUNC_PwmC];	
	
	
	
	
	
	
	
	


#ifdef DO_PROBE_v1
  pDoProbes_[Ind_v1] = TRUE;
  pProbeName[Ind_v1] = "v1";
#endif
#ifdef DO_PROBE_v11
  pDoProbes_[Ind_v11] = TRUE;
  pProbeName[Ind_v11] = "v11";
#endif
#ifdef DO_PROBE_i1st
  pDoProbes_[Ind_i1st] = TRUE;
  pProbeName[Ind_i1st] = "i1st";
#endif
#ifdef DO_PROBE_i1sb
  pDoProbes_[Ind_i1sb] = TRUE;
  pProbeName[Ind_i1sb] = "i1sb";
#endif
#ifdef DO_PROBE_i12
  pDoProbes_[Ind_i12] = TRUE;
  pProbeName[Ind_i12] = "i12";
#endif
#ifdef DO_PROBE_i11
  pDoProbes_[Ind_i11] = TRUE;
  pProbeName[Ind_i11] = "i11";
#endif
#ifdef DO_PROBE_i13
  pDoProbes_[Ind_i13] = TRUE;
  pProbeName[Ind_i13] = "i13";
#endif
#ifdef DO_PROBE_i1ct
  pDoProbes_[Ind_i1ct] = TRUE;
  pProbeName[Ind_i1ct] = "i1ct";
#endif
#ifdef DO_PROBE_i1cb
  pDoProbes_[Ind_i1cb] = TRUE;
  pProbeName[Ind_i1cb] = "i1cb";
#endif
#ifdef DO_PROBE_v12
  pDoProbes_[Ind_v12] = TRUE;
  pProbeName[Ind_v12] = "v12";
#endif



#ifdef DO_PROBE_v2
  pDoProbes_[Ind_v2] = TRUE;
  pProbeName[Ind_v2] = "v2";
#endif
#ifdef DO_PROBE_v21
  pDoProbes_[Ind_v21] = TRUE;
  pProbeName[Ind_v21] = "v21";
#endif
#ifdef DO_PROBE_i2st
  pDoProbes_[Ind_i2st] = TRUE;
  pProbeName[Ind_i2st] = "i2st";
#endif
#ifdef DO_PROBE_i2sb
  pDoProbes_[Ind_i2sb] = TRUE;
  pProbeName[Ind_i2sb] = "i2sb";
#endif
#ifdef DO_PROBE_i22
  pDoProbes_[Ind_i22] = TRUE;
  pProbeName[Ind_i22] = "i22";
#endif
#ifdef DO_PROBE_i21
  pDoProbes_[Ind_i21] = TRUE;
  pProbeName[Ind_i21] = "i21";
#endif
#ifdef DO_PROBE_i23
  pDoProbes_[Ind_i23] = TRUE;
  pProbeName[Ind_i23] = "i23";
#endif
#ifdef DO_PROBE_i2ct
  pDoProbes_[Ind_i2ct] = TRUE;
  pProbeName[Ind_i2ct] = "i2ct";
#endif
#ifdef DO_PROBE_i2cb
  pDoProbes_[Ind_i2cb] = TRUE;
  pProbeName[Ind_i2cb] = "i2cb";
#endif
#ifdef DO_PROBE_v22
  pDoProbes_[Ind_v22] = TRUE;
  pProbeName[Ind_v22] = "v22";
#endif


#ifdef DO_PROBE_v3
  pDoProbes_[Ind_v3] = TRUE;
  pProbeName[Ind_v3] = "v3";
#endif
#ifdef DO_PROBE_v31
  pDoProbes_[Ind_v31] = TRUE;
  pProbeName[Ind_v31] = "v31";
#endif
#ifdef DO_PROBE_i3st
  pDoProbes_[Ind_i3st] = TRUE;
  pProbeName[Ind_i3st] = "i3st";
#endif
#ifdef DO_PROBE_i3sb
  pDoProbes_[Ind_i3sb] = TRUE;
  pProbeName[Ind_i3sb] = "i3sb";
#endif
#ifdef DO_PROBE_i32
  pDoProbes_[Ind_i32] = TRUE;
  pProbeName[Ind_i32] = "i32";
#endif
#ifdef DO_PROBE_i31
  pDoProbes_[Ind_i31] = TRUE;
  pProbeName[Ind_i31] = "i31";
#endif
#ifdef DO_PROBE_i33
  pDoProbes_[Ind_i33] = TRUE;
  pProbeName[Ind_i33] = "i33";
#endif
#ifdef DO_PROBE_i3ct
  pDoProbes_[Ind_i3ct] = TRUE;
  pProbeName[Ind_i3ct] = "i3ct";
#endif
#ifdef DO_PROBE_i3cb
  pDoProbes_[Ind_i3cb] = TRUE;
  pProbeName[Ind_i3cb] = "i3cb";
#endif
#ifdef DO_PROBE_v32
  pDoProbes_[Ind_v32] = TRUE;
  pProbeName[Ind_v32] = "v32";
#endif


#ifdef DO_PROBE_v_n
  pDoProbes_[Ind_v_n] = TRUE;
  pProbeName[Ind_v_n] = "v_n";
#endif
#ifdef DO_PROBE_i_n
  pDoProbes_[Ind_i_n] = TRUE;
  pProbeName[Ind_i_n] = "i_n";
#endif


}

Spice_ThreePhaseBridge::~Spice_ThreePhaseBridge(void)
{


}


void Spice_ThreePhaseBridge::SwitchRValueUpdate(void)
{
  SwitchObjItem * pCurSwitchItem;

  //Update Rvalues
  pCurSwitchItem = pSwitchObjRValList;

  ((class Switch_rS11 *) pCurSwitchItem->pSwitchObject)->DevCur = a[Ind_i1st][32];
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  ((class Switch_rS12 *) pCurSwitchItem->pSwitchObject)->DevCur = a[Ind_i1sb][32];
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  ((class Switch_rS21 *) pCurSwitchItem->pSwitchObject)->DevCur = a[Ind_i2st][32];
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  ((class Switch_rS22 *) pCurSwitchItem->pSwitchObject)->DevCur = a[Ind_i2sb][32];
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  ((class Switch_rS31 *) pCurSwitchItem->pSwitchObject)->DevCur = a[Ind_i3st][32];
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  ((class Switch_rS32 *) pCurSwitchItem->pSwitchObject)->DevCur = a[Ind_i3sb][32];


}

void Spice_ThreePhaseBridge::CoefRValueUpdate(void)
{

  CoefObjItem * pCurCoefItem;

  //Update Rvalues
  pCurCoefItem = pCoefObjRValList;

  ((Coef_v1_h_prev_C11 *) pCurCoefItem->pCoefObject)->v1_ = a[Ind_v1][32];
  pCurCoefItem = pCurCoefItem->pNextCoefItem;
  ((Coef_v11_v1_h_prev_C12 *) pCurCoefItem->pCoefObject)->v11_ = a[Ind_v11][32];
  ((Coef_v11_v1_h_prev_C12 *) pCurCoefItem->pCoefObject)->v1_ = a[Ind_v1][32];
  pCurCoefItem = pCurCoefItem->pNextCoefItem;
  ((Coef_L1_M12_M31_h_prev_i12_i22_i32 *)  pCurCoefItem->pCoefObject)->i12_ = a[Ind_i12][32];
  ((Coef_L1_M12_M31_h_prev_i12_i22_i32 *)  pCurCoefItem->pCoefObject)->i22_ = a[Ind_i22][32];
  ((Coef_L1_M12_M31_h_prev_i12_i22_i32 *)  pCurCoefItem->pCoefObject)->i32_ = a[Ind_i32][32];
  pCurCoefItem = pCurCoefItem->pNextCoefItem;

  ((Coef_v2_h_prev_C21 *) pCurCoefItem->pCoefObject)->v2_ = a[Ind_v2][32];
  pCurCoefItem = pCurCoefItem->pNextCoefItem;
  ((Coef_v21_v2_h_prev_C22 *) pCurCoefItem->pCoefObject)->v21_ = a[Ind_v21][32];
  ((Coef_v21_v2_h_prev_C22 *) pCurCoefItem->pCoefObject)->v2_ = a[Ind_v2][32];
  pCurCoefItem = pCurCoefItem->pNextCoefItem;
  ((Coef_L2_M12_M23_h_prev_i12_i22_i32 *)  pCurCoefItem->pCoefObject)->i12_ = a[Ind_i12][32];
  ((Coef_L2_M12_M23_h_prev_i12_i22_i32 *)  pCurCoefItem->pCoefObject)->i22_ = a[Ind_i22][32];
  ((Coef_L2_M12_M23_h_prev_i12_i22_i32 *)  pCurCoefItem->pCoefObject)->i32_ = a[Ind_i32][32];
  pCurCoefItem = pCurCoefItem->pNextCoefItem;

  ((Coef_v3_h_prev_C31 *) pCurCoefItem->pCoefObject)->v3_ = a[Ind_v3][32];
  pCurCoefItem = pCurCoefItem->pNextCoefItem;
  ((Coef_v31_v3_h_prev_C32 *) pCurCoefItem->pCoefObject)->v31_ = a[Ind_v31][32];
  ((Coef_v31_v3_h_prev_C32 *) pCurCoefItem->pCoefObject)->v3_ = a[Ind_v3][32];
  pCurCoefItem = pCurCoefItem->pNextCoefItem;
  ((Coef_L3_M31_M23_h_prev_i12_i22_i32 *)  pCurCoefItem->pCoefObject)->i12_ = a[Ind_i12][32];
  ((Coef_L3_M31_M23_h_prev_i12_i22_i32 *)  pCurCoefItem->pCoefObject)->i22_ = a[Ind_i22][32];
  ((Coef_L3_M31_M23_h_prev_i12_i22_i32 *)  pCurCoefItem->pCoefObject)->i32_ = a[Ind_i32][32];
  pCurCoefItem = pCurCoefItem->pNextCoefItem; 
  
  ((Coef_v_n_h_prev_C_n *) pCurCoefItem->pCoefObject)->v_n_ = a[Ind_v_n][32];



}

void Spice_ThreePhaseBridge::SrcRValueUpdate(void)          
{
  SrcObjItem * pCurSrcItem;

  //Update Rvalues
  pCurSrcItem = pSrcObjRValList;

  ((PwmA *) pCurSrcItem->pSrcObject)->i11 = a[Ind_i11][32];
  ((PwmA *) pCurSrcItem->pSrcObject)->i21 = a[Ind_i21][32];
  ((PwmA *) pCurSrcItem->pSrcObject)->i31 = a[Ind_i31][32];  
  pCurSrcItem = pCurSrcItem->pNextSrcItem;    
  ((PwmB *) pCurSrcItem->pSrcObject)->i11 = a[Ind_i11][32];
  ((PwmB *) pCurSrcItem->pSrcObject)->i21 = a[Ind_i21][32];
  ((PwmB *) pCurSrcItem->pSrcObject)->i31 = a[Ind_i31][32]; 
  pCurSrcItem = pCurSrcItem->pNextSrcItem;    
  ((PwmC *) pCurSrcItem->pSrcObject)->i11 = a[Ind_i11][32];
  ((PwmC *) pCurSrcItem->pSrcObject)->i21 = a[Ind_i21][32];
  ((PwmC *) pCurSrcItem->pSrcObject)->i31 = a[Ind_i31][32];
 

}



// ---------------------------------------------------------------

// **************************************************************




// **** SimuObject ************************************************




SimuObject Simulation;

SimuObject::SimuObject(void)
{
  OdeObjItem * pCurOdeItem;
  SrcObjItem * pCurSrcItem;
  CtrlObjItem * pCurCtrlItem;
  CtrlObjGroup * pCurCtrlGroup;
  CoefObjItem * pCurCoefItem;
  SpiceObjItem * pCurSpiceItem;
  SwitchObjItem * pCurSwitchItem;


  int i;


  SimuTime = .1;


  MinimumPlotTime = 0;
  MaximumPlotTime = 1;



  ExceptionTime = .05;

  //For this example the setting of "RelTol" is important. If it is set to large
  //the system will become unstable.
  RelTol =  .0000000001;
  //Setting "AbsTol" too small will make a system with a decaying oscillation
  //take too long to finish.
  AbsTol =  .0000000000001;
  //typical error correction setting as per "RungeKutta_java.htm" (never set higher then "1.0")
  Safety = .98;
//  h_start = .000000001;
// !!!!!!!!!!!! TEMPORARY !!!!!!!!!!!!!!!!!!1
  h_start = .0000005;
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!1

  h = h_start;


// !!!!!!!!!!!! TEMPORARY !!!!!!!!!!!!!!!!!!1
  OdeSimuFixed = true;		//Run fixed mode. We do not have adaptive time stepping workin yet for Spice mode.


// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!1



  //set to a value other then "0" to clamp maximum "h";
//  h_max = .0000002;
// !!!!!!!!!!!! TEMPORARY !!!!!!!!!!!!!!!!!!1
  h_max = .0000005;
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!


  //set to store and plot "h" parameter.
  Do_h_Plot = 1;

  TimeQuantum = h;
  CtrlTimeQuantum = QUANTUM_PERIOD;


  //set tp force CTRL update on first ODE update.
  CtrlTimeAccumulator = 0;

  SrcPeriodQuantum = QUANTUM_PERIOD;
  SrcPeriodAccumulator = 0;


  //build the SRC equation list
  pSrcEquationList = new SrcObjItem;
  pCurSrcItem = pSrcEquationList;
  i = 0;
  while(SrcObjectList[i]){
    pCurSrcItem->pSrcObject = SrcObjectList[i];
    i++;
    if(!SrcObjectList[i])
      break;
    pCurSrcItem->pNextSrcItem = new SrcObjItem;
    pCurSrcItem = pCurSrcItem->pNextSrcItem;


  }

  if(OdeObjectList[0]){								//NOTE: Missed this in template. Test for NULL list should be added to all list building routines!
	  //build the ODE equation list.
	  pOdeEquationList = new OdeObjItem;
	  pCurOdeItem = pOdeEquationList;
	  i = 0;
	  while(1){
		pCurOdeItem->pOdeObject = OdeObjectList[i];
		i++;
		if(!OdeObjectList[i])
		  break;
		pCurOdeItem->pNextOdeItem = new OdeObjItem;
		pCurOdeItem = pCurOdeItem->pNextOdeItem;
	  }
  }


  if(CtrlObjectList[0]){

    pCtrlGroupList = new CtrlObjGroup;
    pCurCtrlGroup = pCtrlGroupList;

    pCurCtrlGroup->pCtrlEquationList = new CtrlObjItem;
    pCurCtrlItem = pCurCtrlGroup->pCtrlEquationList;
    //set tp force CTRL update on first ODE update.
    pCurCtrlGroup->QuantumCount = 1;
    pCurCtrlGroup->QuantumNum = CtrlObjectQuantum[0];

    i = 0;
    while(1){
      pCurCtrlItem->pCtrlObject = CtrlObjectList[i];
      i++;
      if(!CtrlObjectList[i])
	break;

      if(CtrlObjectQuantum[i] == CtrlObjectQuantum[i-1]){
	pCurCtrlItem->pNextCtrlItem = new CtrlObjItem;
	pCurCtrlItem = pCurCtrlItem->pNextCtrlItem;
      }
      else{
	//create a new group...
	pCtrlGroupList->pNextCtrlGroup = new CtrlObjGroup;
	pCurCtrlGroup = pCtrlGroupList->pNextCtrlGroup;

	pCurCtrlGroup->pCtrlEquationList = new CtrlObjItem;
	pCurCtrlItem = pCurCtrlGroup->pCtrlEquationList;
	//set tp force CTRL update on first ODE update.
	pCurCtrlGroup->QuantumCount = 1;
	pCurCtrlGroup->QuantumNum = CtrlObjectQuantum[i];
      }
    }
  }

  //build the COEF equation list.              //NOTE: The COEF list is used only for exception processing.
  pCoefEquationList = new CoefObjItem;
  pCurCoefItem = pCoefEquationList;
  i = 0;
  while(1){
    pCurCoefItem->pCoefObject = CoefObjectList[i];
    i++;
    if(!CoefObjectList[i])
      break;
    pCurCoefItem->pNextCoefItem = new CoefObjItem;
    pCurCoefItem = pCurCoefItem->pNextCoefItem;
  }



  //build the SPICE equation list.
  pSpiceEquationList = new SpiceObjItem;
  pCurSpiceItem = pSpiceEquationList;
  i = 0;
  while(1){
    pCurSpiceItem->pSpiceObject = SpiceObjectList[i];
    i++;
    if(!SpiceObjectList[i])
      break;
    pCurSpiceItem->pNextSpiceItem = new SpiceObjItem;
    pCurSpiceItem = pCurSpiceItem->pNextSpiceItem;
  }

  //build the SWITCH equation list.
  pSwitchEquationList = new SwitchObjItem;
  pCurSwitchItem = pSwitchEquationList;
  i = 0;
  while(1){
    pCurSwitchItem->pSwitchObject = SwitchObjectList[i];
    i++;
    if(!SwitchObjectList[i])
      break;
    pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
    pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  }





}

SimuObject::~SimuObject(void)
{

  //(ideally we should delete all make allocation make in the constructor, here)

}



// ************************************************************


bool ExecuteSimulation(void)
{



  Simulation.OdeSimuType = ODE_SIMU_56;

  while(Simulation.t < Simulation.SimuTime){

    if(!Simulation.DoOneInteration())
      return FALSE;

  }
  if(Simulation.GotException){
    cout << Simulation.ExceptionMessageBuffer.str().c_str();
  }

  return TRUE;
}

void PlotResults(string TagNamesToPlot[], double ScaleFactors[], double MinPlotTimes[], double MaxPlotTimes[],
		 double PlotTimeSteps[], double PlotTimeOffset)
{
  Simulation.PlotSimuResults(TagNamesToPlot, ScaleFactors, MinPlotTimes, MaxPlotTimes, PlotTimeSteps, PlotTimeOffset);


}


