fc = 1000; % Cut-off frequency (Hz)
fs = 20000; % Sampling rate (Hz)
order = 2; % Filter order
[B,A] = butter(order,2*fc/fs) % [0:pi] maps to [0:1] here


sf = 20000; sf2 = sf/2;
data=[[1;zeros(sf-1,1)],sinetone(25,sf,1,1),sinetone(500,sf,1,1),sinetone(1000,sf,1,1)];
[b,a]=butter ( 1, 50 / sf2 );
filtered = filter(b,a,data);

clf
subplot ( columns ( filtered ), 1, 1)
plot(filtered(:,1),";Impulse response;")
subplot ( columns ( filtered ), 1, 2 )
plot(filtered(:,2),";25Hz response;")
subplot ( columns ( filtered ), 1, 3 )
plot(filtered(:,3),";500Hz response;")
subplot ( columns ( filtered ), 1, 4 )
plot(filtered(:,4),";1000Hz response;")