

#define FPT_WBITS 8               //It looks like in IQmathLib.h, HVACI_Sensored.c is using  GLOBAL_Q == 24
                                  //NOTE: Here FPT_WBITS means size of integer not fraction! (Reversed meaning to GLOBAL_Q in TI IQ MATH)
                                   //According to various links including to this one (https://s2.smu.edu/~mitch/class/5385/DSPArithmeticTutorial.pdf)
                                   //IQMathLib.h is where this is set.

#define FPT_DIV_OVERFLOW_HANDLING  //Handle overflow and underflow on fixed point divide.
#include "fptc.h"



fpt Lm_a_recp_h_m_plus_Ra_fix;
fpt Lm_b_recp_h_m_plus_Rb_fix;
fpt Lm_c_recp_h_m_plus_Rc_fix;


fpt minus_Mab_recp_h_m_fix;
fpt minus_Mbc_recp_h_m_fix;
fpt minus_Mac_recp_h_m_fix;

fpt Ka_fix;
fpt Kb_fix;
fpt Kc_fix;





fpt Lm_a_recp_h_m_fix;
fpt Lm_b_recp_h_m_fix;
fpt Lm_c_recp_h_m_fix;






fpt one_point_zero_fix;


fpt PHASE_SHIFT_ERROR_fix;


fpt Bm_fix;
fpt Cm_fix;
fpt Dm_fix;
fpt Jm_fix;


void OneTime_fl2fpt_conversion(void)
{

    Lm_a_recp_h_m_plus_Ra_fix = fl2fpt((double)(Lm_a*recp_h_m + Ra));
    Lm_b_recp_h_m_plus_Rb_fix = fl2fpt((double)(Lm_b*recp_h_m + Rb));
    Lm_c_recp_h_m_plus_Rc_fix = fl2fpt((double)(Lm_c*recp_h_m + Rc));

    minus_Mab_recp_h_m_fix = fl2fpt((double)(- Mab*recp_h_m));
    minus_Mbc_recp_h_m_fix = fl2fpt((double)(- Mbc*recp_h_m));
    minus_Mac_recp_h_m_fix = fl2fpt((double)(- Mac*recp_h_m));


    Ka_fix = fl2fpt((double) Ka);
    Kb_fix = fl2fpt((double) Kb);
    Kc_fix = fl2fpt((double) Kc);

    fpt Lm_a_recp_h_m_fix = fl2fpt((double) (Lm_a * recp_h_m));
    fpt Lm_b_recp_h_m_fix = fl2fpt((double) (Lm_b * recp_h_m));
    fpt Lm_c_recp_h_m_fix = fl2fpt((double) (Lm_c * recp_h_m));



    Bm_fix = fl2fpt((double) Bm);
    Cm_fix = fl2fpt((double) Cm);
    Dm_fix = fl2fpt((double) Dm);
    Jm_fix = fl2fpt((double) Jm);




    one_point_zero_fix = fl2fpt((double)(1.0));


}

fpt omegad_m_fix;
fpt thetad_m_fix;
fpt alphad_m_fix;

fpt ia_m__fix;
fpt ib_m__fix;
fpt ic_m__fix;

fpt sin_0_PI_3_fix;
fpt sin_2_PI_3_error_fix;
fpt sin_4_PI_3_fix;

fpt sin_2_0_PI_3_fix;

fpt cos_0_PI_3_fix;
fpt cos_2_PI_3_fix;
fpt cos_4_PI_3_fix;

fpt idd_global_fix;


fpt ia_m_fix;
fpt ib_m_fix;
fpt ic_m_fix;
fpt vs_a_m_fix;
fpt vs_b_m_fix;
fpt vs_c_m_fix;


void EveryCycle_fl2fpt_conversion(void)
{
    float Nr_thetad_m_fl;     //  In real life must be made +/- PU  with C2000 TMU DIV2PIF32 followed by SINPUF32 instruction.
                              //  See https://www.ti.com/lit/ug/spruhs1c/spruhs1c.pdf page 788 and 789
                              //  and, page 784 and 785.
                              //  In addition we must apply


    omegad_m_fix = fl2fpt((float) omegad_m);
    thetad_m_fix = fl2fpt((float) thetad_m);
    alphad_m_fix = fl2fpt((float) alphad_m);

    Nr_thetad_m_fl = (float) Nr*thetad_m;

    sin_0_PI_3_fix = fl2fpt(sinf(Nr_thetad_m_fl));
    sin_2_PI_3_error_fix = fl2fpt(sinf(Nr_thetad_m_fl + PHASE_SHIFT_ERROR - 2*PI/3));
    sin_4_PI_3_fix = fl2fpt(sinf(Nr_thetad_m_fl - 4*PI/3));

    sin_2_0_PI_3_fix = fl2fpt(sinf(2*Nr_thetad_m_fl));

    cos_0_PI_3_fix = fl2fpt(cosf(Nr_thetad_m_fl));
    cos_2_PI_3_fix = fl2fpt(cosf(Nr_thetad_m_fl - 2*PI/3));
    cos_4_PI_3_fix = fl2fpt(cosf(Nr_thetad_m_fl - 4*PI/3));

    idd_global_fix = fl2fpt((double)(idd_global));

}

    //!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! these must be fixed below (retain original terms as comments for each function!) !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!



    //Coef_Eq_1 Functions ...

fpt Coef_Eq_1_ia_fix(void)
{
        //fl2fpt((double)(Lm_a*recp_h_m + Ra))
    return(Lm_a_recp_h_m_plus_Ra_fix);
}

fpt Coef_Eq_1_ib_fix(void)
{
        //fl2fpt((double)(- Mab*recp_h_m))
    return(minus_Mab_recp_h_m_fix);
}

fpt Coef_Eq_1_ic_fix(void)
{
        //fl2fpt((double)(- Mac*recp_h_m))
    return(minus_Mac_recp_h_m_fix);
}

fpt Coef_Eq_1_vs_a_fix(void)
{
        //fl2fpt((double)(- 1.0))
    return(-one_point_zero_fix);
}

fpt Coef_Eq_1_vs_b_fix(void)
{
    return(0);
}

fpt Coef_Eq_1_vs_c_fix(void)
{
    return(0);
}

fpt Coef_Eq_1_result_fix(void)
{
        //fl2fpt((double)(Ka*omegad_m*sin(Nr*thetad_m) + Lm_a*ia_m_*recp_h_m - Mab*ib_m_*recp_h_m - Mac*ic_m_*recp_h_m))
    return(fpt_add(fpt_add(fpt_add(fpt_mul(fpt_mul(Ka_fix, omegad_m_fix), sin_0_PI_3_fix), fpt_mul(ia_m__fix, Lm_a_recp_h_m_fix)), fpt_mul(ib_m__fix, minus_Mab_recp_h_m_fix)), fpt_mul(ic_m__fix, minus_Mac_recp_h_m_fix)));
}


//Coef_Eq_2 Functions ...

fpt Coef_Eq_2_ia_fix(void)
{
        //fl2fpt((double)(- Mab*recp_h_m ))
    return(minus_Mab_recp_h_m_fix);
}

fpt Coef_Eq_2_ib_fix(void)
{
        //fl2fpt((double)(Lm_b*recp_h_m + Rb))
    return(Lm_b_recp_h_m_plus_Rb_fix);
}

fpt Coef_Eq_2_ic_fix(void)
{
        //fl2fpt((double)(- Mbc*recp_h_m))
    return(minus_Mbc_recp_h_m_fix);
}

fpt Coef_Eq_2_vs_a_fix(void)
{
    return(0);
}

fpt Coef_Eq_2_vs_b_fix(void)
{
        //fl2fpt((double)(-1.0))
    return(-one_point_zero_fix);
}

fpt Coef_Eq_2_vs_c_fix(void)
{
    return(0);
}

fpt Coef_Eq_2_result_fix(void)
{
        //fl2fpt((double)(Kb*omegad_m*sin(Nr*thetad_m + PHASE_SHIFT_ERROR - 2*PI/3) - Mab*ia_m_*recp_h_m + Lm_b*ib_m_*recp_h_m - Mbc*ic_m_*recp_h_m))
    return(fpt_add(fpt_add(fpt_add(fpt_mul(fpt_mul(Kb_fix, omegad_m_fix), sin_2_PI_3_error_fix), fpt_mul(ia_m__fix, minus_Mab_recp_h_m_fix)), fpt_mul(ib_m__fix, Lm_b_recp_h_m_fix)), fpt_mul(ic_m__fix, minus_Mbc_recp_h_m_fix)));
}



//Coef_Eq_3 Functions ...

fpt Coef_Eq_3_ia_fix(void)
{
        //fl2fpt((double)(- Mac*recp_h_m))
    return(minus_Mac_recp_h_m_fix);
}

fpt Coef_Eq_3_ib_fix(void)
{
        //fl2fpt((double)(- Mbc*recp_h_m))
    return(minus_Mbc_recp_h_m_fix);
}

fpt Coef_Eq_3_ic_fix(void)
{
        //fl2fpt((double)(Lm_c*recp_h_m + Rc))
    return(Lm_c_recp_h_m_plus_Rc_fix);
}

fpt Coef_Eq_3_vs_a_fix(void)
{
    return(0);
}

fpt Coef_Eq_3_vs_b_fix(void)
{
    return(0);
}

fpt Coef_Eq_3_vs_c_fix(void)
{
        //fl2fpt((double)(-1.0))
    return(-one_point_zero_fix);
}

fpt Coef_Eq_3_result_fix(void)
{
        //fl2fpt((double)(Kc*omegad_m*sin(Nr*thetad_m - 4*PI/3) - Mac*ia_m_*recp_h_m - Mbc*ib_m_*recp_h_m + Lm_c*ic_m_*recp_h_m))
    return(fpt_add(fpt_add(fpt_add(fpt_mul(fpt_mul(Kc_fix, omegad_m_fix), sin_4_PI_3_fix), fpt_mul(ia_m__fix, minus_Mac_recp_h_m_fix)), fpt_mul(ib_m__fix, minus_Mbc_recp_h_m_fix)), fpt_mul(ic_m__fix, Lm_c_recp_h_m_fix)));
}



//Coef_Eq_4 Functions ...

fpt Coef_Eq_4_ia_fix(void)
{
        //fl2fpt((double)(Ka*sin(Nr*thetad_m)))
    return(fpt_mul(Ka_fix, sin_0_PI_3_fix));
}

fpt Coef_Eq_4_ib_fix(void)
{
        //fl2fpt((double)(Kb*sin(Nr*thetad_m + PHASE_SHIFT_ERROR - 2*PI/3)))
    return(fpt_mul(Kb_fix, sin_2_PI_3_error_fix));
}

fpt Coef_Eq_4_ic_fix(void)
{
        //fl2fpt((double)(Kc*sin(Nr*thetad_m - 4*PI/3)))
    return(fpt_mul(Kc_fix, sin_4_PI_3_fix));
}

fpt Coef_Eq_4_vs_a_fix(void)
{
    return(0);
}

fpt Coef_Eq_4_vs_b_fix(void)
{
    return(0);
}

fpt Coef_Eq_4_vs_c_fix(void)
{
    return(0);
}

fpt Coef_Eq_4_result_fix(void)
{
        //fl2fpt((double)(- Bm*omegad_m - Cm*(omegad_m < 0 ? -1 : (omegad_m > 0 ? 1 : 0)) - Dm*sin(2*Nr*thetad_m) - Jm*alphad_m))
    return(fpt_add(fpt_add(fpt_add(fpt_mul(-Bm_fix, omegad_m_fix), fpt_mul(-Cm_fix, omegad_m_fix < 0 ? -one_point_zero_fix : (omegad_m_fix > 0 ? one_point_zero_fix : 0))), fpt_mul(-Dm_fix, sin_2_0_PI_3_fix)),  fpt_mul(-Jm_fix, alphad_m_fix)));
}




//Coef_Eq_5 Functions ...

fpt Coef_Eq_5_ia_fix(void)
{
        //fl2fpt((double)(cos(Nr*thetad_m)))
    return(cos_0_PI_3_fix);
}

fpt Coef_Eq_5_ib_fix(void)
{
        //fl2fpt((double)(cos(Nr*thetad_m - 2*PI/3.0)))
    return(cos_2_PI_3_fix);
}

fpt Coef_Eq_5_ic_fix(void)
{
        //fl2fpt((double)(cos(Nr*thetad_m - 4*PI/3.0)))
    return(cos_4_PI_3_fix);
}

fpt Coef_Eq_5_vs_a_fix(void)
{
    return(0);
}

fpt Coef_Eq_5_vs_b_fix(void)
{
    return(0);
}

fpt Coef_Eq_5_vs_c_fix(void)
{
    return(0);
}

fpt Coef_Eq_5_result_fix(void)
{
        //fl2fpt((double)(idd_global))
    return(idd_global_fix);
}




//Coef_Eq_6 Functions ...

fpt Coef_Eq_6_ia_fix(void)
{
        //fl2fpt((double)(1.0))
    return(one_point_zero_fix);
}

fpt Coef_Eq_6_ib_fix(void)
{
        //fl2fpt((double)(1.0))
    return(one_point_zero_fix);
}

fpt Coef_Eq_6_ic_fix(void)
{
        //fl2fpt((double)(1.0))
    return(one_point_zero_fix);
}

fpt Coef_Eq_6_vs_a_fix(void)
{
    return(0);
}

fpt Coef_Eq_6_vs_b_fix(void)
{
    return(0);
}

fpt Coef_Eq_6_vs_c_fix(void)
{
    return(0);
}

fpt Coef_Eq_6_result_fix(void)
{
    return(0);
}


typedef fpt (* ppa_CoefObj_fix)(void);

ppa_CoefObj_fix ** a_CoefObj_fix;

fpt ** a_fix;

int n_fix;

void InitializeMatrix_fix(unsigned int NumberOfRows)
{

  int i,j;



  n_fix = NumberOfRows;
  // allocate the working matrix and right side column vector
  a_fix = (fpt **)malloc(n_fix*sizeof(fpt *));
  for(i = 0; i < n_fix; i++){
    a_fix[i] = (fpt *)malloc((n_fix+1)*sizeof(fpt));
    for(j = 0; j < n_fix + 1; j++){
      a_fix[i][j] = 0;
    }
  }

  //allocate matrix that contains pointers to "CoefObject's"
  //that coincide with "a[][]"

  a_CoefObj_fix = (ppa_CoefObj_fix **) malloc(n_fix*sizeof(ppa_CoefObj_fix *));
  for(i = 0; i < n_fix; i++){
    a_CoefObj_fix[i] = (ppa_CoefObj_fix *)malloc((n_fix+1)*sizeof(ppa_CoefObj_fix));
    for(j = 0; j < n_fix + 1; j++){
      a_CoefObj_fix[i][j] = NULL;
    }
  }



}





// ---- PhyMotorModelSolve_fix --------------------------------------------------

void PhyMotorModelSolve_fix(void)
{
      InitializeMatrix_fix(6);   //(6 rows, 7 columns)

      //Eq. (1)
      a_CoefObj_fix[0][Ind_ia] = &Coef_Eq_1_ia_fix;
      a_CoefObj_fix[0][Ind_ib] = &Coef_Eq_1_ib_fix;
      a_CoefObj_fix[0][Ind_ic] = &Coef_Eq_1_ic_fix;
      a_CoefObj_fix[0][Ind_vs_a] = &Coef_Eq_1_vs_a_fix;
      a_CoefObj_fix[0][Ind_vs_b] = &Coef_Eq_1_vs_b_fix;
      a_CoefObj_fix[0][Ind_vs_c] = &Coef_Eq_1_vs_c_fix;
      a_CoefObj_fix[0][6] = &Coef_Eq_1_result_fix;


      //Eq. (2)
      a_CoefObj_fix[1][Ind_ia] = &Coef_Eq_2_ia_fix;
      a_CoefObj_fix[1][Ind_ib] = &Coef_Eq_2_ib_fix;
      a_CoefObj_fix[1][Ind_ic] = &Coef_Eq_2_ic_fix;
      a_CoefObj_fix[1][Ind_vs_a] = &Coef_Eq_2_vs_a_fix;
      a_CoefObj_fix[1][Ind_vs_b] = &Coef_Eq_2_vs_b_fix;
      a_CoefObj_fix[1][Ind_vs_c] = &Coef_Eq_2_vs_c_fix;
      a_CoefObj_fix[1][6] = &Coef_Eq_2_result_fix;


      //Eq. (3)
      a_CoefObj_fix[2][Ind_ia] = &Coef_Eq_3_ia_fix;
      a_CoefObj_fix[2][Ind_ib] = &Coef_Eq_3_ib_fix;
      a_CoefObj_fix[2][Ind_ic] = &Coef_Eq_3_ic_fix;
      a_CoefObj_fix[2][Ind_vs_a] = &Coef_Eq_3_vs_a_fix;
      a_CoefObj_fix[2][Ind_vs_b] = &Coef_Eq_3_vs_b_fix;
      a_CoefObj_fix[2][Ind_vs_c] = &Coef_Eq_3_vs_c_fix;
      a_CoefObj_fix[2][6] = &Coef_Eq_3_result_fix;


      //Eq. (4)
      a_CoefObj_fix[3][Ind_ia] = &Coef_Eq_4_ia_fix;
      a_CoefObj_fix[3][Ind_ib] = &Coef_Eq_4_ib_fix;
      a_CoefObj_fix[3][Ind_ic] = &Coef_Eq_4_ic_fix;
      a_CoefObj_fix[3][Ind_vs_a] = &Coef_Eq_4_vs_a_fix;
      a_CoefObj_fix[3][Ind_vs_b] = &Coef_Eq_4_vs_b_fix;
      a_CoefObj_fix[3][Ind_vs_c] = &Coef_Eq_4_vs_c_fix;
      a_CoefObj_fix[3][6] = &Coef_Eq_4_result_fix;


      //Eq. (5)
      a_CoefObj_fix[4][Ind_ia] = &Coef_Eq_5_ia_fix;
      a_CoefObj_fix[4][Ind_ib] = &Coef_Eq_5_ib_fix;
      a_CoefObj_fix[4][Ind_ic] = &Coef_Eq_5_ic_fix;
      a_CoefObj_fix[4][Ind_vs_a] = &Coef_Eq_5_vs_a_fix;
      a_CoefObj_fix[4][Ind_vs_b] = &Coef_Eq_5_vs_b_fix;
      a_CoefObj_fix[4][Ind_vs_c] = &Coef_Eq_5_vs_c_fix;
      a_CoefObj_fix[4][6] = &Coef_Eq_5_result_fix;


      //Eq. (6)
      a_CoefObj_fix[5][Ind_ia] = &Coef_Eq_6_ia_fix;
      a_CoefObj_fix[5][Ind_ib] = &Coef_Eq_6_ib_fix;
      a_CoefObj_fix[5][Ind_ic] = &Coef_Eq_6_ic_fix;
      a_CoefObj_fix[5][Ind_vs_a] = &Coef_Eq_6_vs_a_fix;
      a_CoefObj_fix[5][Ind_vs_b] = &Coef_Eq_6_vs_b_fix;
      a_CoefObj_fix[5][Ind_vs_c] = &Coef_Eq_6_vs_c_fix;
      a_CoefObj_fix[5][6] = &Coef_Eq_6_result_fix;




}






void PreSpiceFunction_fix(void)
{

  int i,j;


  for(i = 0; i < n_fix; i++){
    for(j = 0; j < n_fix + 1; j++){

    //perform required calulation on "dynamic" coefficients.
      a_fix[i][j] = a_CoefObj_fix[i][j]();


    }
  }

}









void ForwardSubstitution_fix(void)
{
  int i, j, k, max;
  fpt tmp_fix;
  for (i = 0; i < n_fix; ++i)
  {
    max = i;

     //There is a mistake in code. See file ./Gaussian-Elimination-With-Partial-Pivoting/TestGaussianElimination.cc"
     //for more information.
    for (j = i + 1; j < n_fix; ++j)
      // if (a[j][i] > a[max][i])
      if (fpt_abs(a_fix[j][i]) > fpt_abs(a_fix[max][i]))
    max = j;

    for (j = 0; j < n_fix + 1; ++j) {
      tmp_fix = a_fix[max][j];
      a_fix[max][j] = a_fix[i][j];
      a_fix[i][j] = tmp_fix;
    }


    for (j = n_fix; j >= i; --j)
      for (k = i + 1; k < n_fix; ++k)
          a_fix[k][j] = fpt_sub(a_fix[k][j],fpt_mul(fpt_div(a_fix[k][i], a_fix[i][i]), a_fix[i][j]));


  }
}


void ReverseElimination_fix(void)
{
  int i, j;
  for (i = n_fix - 1; i >= 0; --i) {
    a_fix[i][n_fix] = fpt_div(a_fix[i][n_fix], a_fix[i][i]);
    a_fix[i][i] = 1;
    for (j = i - 1; j >= 0; --j) {
      a_fix[j][n_fix] = a_fix[j][n_fix] - fpt_mul(a_fix[j][i], a_fix[i][n_fix]);
      a_fix[j][i] = 0;
    }


  }
}



void Gauss_fix(void)
{


  ForwardSubstitution_fix();


  ReverseElimination_fix();




}

    //!!!!! Status: Done. First, integrate into application. For simplicity allow "fix" version to run along side with "double" version
    //                and compare states/outputs (simplest way to debug). This may be the final evaluation or we may allow "fix" to run
    //                in place of "double".




