#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>


#define PI 3.1415926535897932384626433832795



//Invocation:
//
// gcc -g -lm Lemma_A_12.c 


double scale;
 
FILE * fp_evaluate_m; 

main()
{

   fp_evaluate_m = fopen("Evaluate.m", "w");


   scale = sqrt(2.0/6.0);	
   fprintf(fp_evaluate_m, "a = [%g %g %g %g %g %g; %g %g %g %g %g %g; %g %g %g %g %g %g];\n",
	   scale * 1.0, scale * cos(2.0*PI*1.0*2.0/6.0), scale *cos(2.0*PI*2.0*2.0/6.0),  scale * cos(2.0*PI*3.0*2.0/6.0),  scale *cos(2.0*PI*4.0*2.0/6.0), scale * cos(2.0*PI*5.0*2.0/6.0),
           scale * 0.0, scale * sin(2.0*PI*1.0*2.0/6.0), scale *sin(2.0*PI*2.0*2.0/6.0),  scale * sin(2.0*PI*3.0*2.0/6.0),  scale *sin(2.0*PI*4.0*2.0/6.0), scale * sin(2.0*PI*5.0*2.0/6.0),
           scale / sqrt(2.0), scale / sqrt(2.0), scale / sqrt(2.0), scale / sqrt(2.0), scale / sqrt(2.0), scale / sqrt(2.0));

	//(I make the assumption here that it is best to choose these vectors that provide the most "orthogonality" to "a").
	// choose these  vectors to be orthogonal to three rows of "a".
   fprintf(fp_evaluate_m, "b = [%g %g %g %g %g %g];\n", 0.0, 0.0, 1.0, 0.0, 0.0, -1.0);
   fprintf(fp_evaluate_m, "c = [%g %g %g %g %g %g];\n", 0.0, 1.0, 0.0, 0.0, -1.0, 0.0);
   fprintf(fp_evaluate_m, "d = [%g %g %g %g %g %g];\n", 1.0, 0.0, 0.0, -1.0, 0.0, 0.0);	

   fprintf(fp_evaluate_m, "x = transpose(b);\n");
   
   fprintf(fp_evaluate_m, "v = transpose(a);\n");

	
	//(see C:\Simulation-Development\Brushless-DoublyFed-Motor-Dissertation\Gram-Schmidt.pdf)
   fprintf(fp_evaluate_m, "[y, h] = mgorth(x, v);\n");

   fprintf(fp_evaluate_m, "v = [v, y];\n");

   fprintf(fp_evaluate_m, "x = transpose(c);\n");

   fprintf(fp_evaluate_m, "[y, h] = mgorth(x, v);\n");

   fprintf(fp_evaluate_m, "v = [v, y];\n");

   fprintf(fp_evaluate_m, "x = transpose(d);\n");

   fprintf(fp_evaluate_m, "[y, h] = mgorth(x, v);\n");

   fprintf(fp_evaluate_m, "a_extend_t = [v, y];\n");

   fprintf(fp_evaluate_m, "a_extend = transpose(a_extend_t);\n");

    //Do these test on "a_extend_t" and "a_extend" in octave.
    //         > a_extend * inv(a_extend)
    //         > a_extend_t * inv(a_extend_t)
    //         > a_extend_t * a_extend
    // 	       > a_extend * a_extend_t
    //
    //      All four above should result in identity matrix.
    //
    //         > norm(a_extend)
    //         > norm(a_extend_t)
    //
    //      norm should be "1".


}





