
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>


#define PI 3.1415926535897932384626433832795


// Calculation of Mutual Inductance Matrix Msr for stator to rotor windings. Here we extract information from the 
// the stator and rotor tests done in "Section_B_2" and Section_B_7" respectively.
// Again like "Section_B_2", we are working with only the 4 pole stator winding.




 
// Parameters for 4 pole calculation of the Stator and rotor (from Section_B_2.c and Section_B_7.c)
// The "k" will be the stator, the "j" subscript will be  the rotor.


#define w  .1955        //(this "w" was from the stator. We will use it for both stator and rotor)
#define d  .175065      //(this "d" was from the stator. We will use it for both stator and rotor)
#define Nk  10.0
#define Nj  1.0
#define g  .000555              //(this "g" was from the stator. We will use it for both stator and rotor)
#define u0  (4.0*PI*1.0e-7)   //Permeability of vacuum.

#define Ack  (2.0*PI*10.0/48.0)     //From Figure 2.2 on page 42.      
#define Wsk  (2.0*PI*.0032/(2.0*PI*d/2.0))   //


// Here we will modifiy the "j" subscripts for Ac and Ws to be used for the rotor.
    
#define Acj   (2.0*PI/6.0)      
#define Wsj    (2.0*PI*.0084/(2.0*PI*d/2.0))             
 



#define slot_pitch (2.0*PI/48.0)  //degrees center-to-center of two consecutive slots for the stator.
 




double Bk;    	   	  //This changes depending on which row of the stator mutual inductance matrix is being calculated.
double Bj;		       //This becomes the variable for computing each matrix element of the rotor for a given stator element.


double Msr_t_bar[6][48] = {0};		//This should be the mutual inductance matrix definition before reduction by "Ts_4"	
        
 
double Theta;
#define dTheta (2.0*PI/360.0)      //One degree integration.

double integral_cos_cos = 0;


double Ts_4[3][48] =  {{1,  1,  1,  1, -1, -1, -1, -1,  1,  1,  1,  1, -1, -1, -1, -1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0},
		       {0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  1,  1,  1, -1, -1, -1, -1,  1,  1,  1,  1, -1, -1, -1, -1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0}, 
                       {0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  1,  1,  1, -1, -1, -1, -1,  1,  1,  1,  1, -1, -1, -1, -1}}; 


double Msr_t_r[6][3] = {0}; 
double Msr_t[6][3] = {0};
 
FILE * fp_stator_rotor_mu_ind_a_dat;
FILE * fp_stator_rotor_mu_ind_b_dat;
FILE * fp_stator_rotor_mu_ind_c_dat;
FILE * fp_stator_rotor_mu_ind_h;

double Test_integral_1 = 0;
double Test_integral_2 = 0;
double Test_integral_3 = 0;

double Test_harmonic_1 = 0;
double Test_harmonic_2 = 0;
double Test_harmonic_3 = 0; 


//Invocation:
//
// gcc -g -lm Section_2_7_2.c 



main()
{
	int n,i,j,k;
	double RotorTheta;

	printf("\n\n\n");


	//un-comment this to generate Stator 1 - Rotor Mutual inductance vs Rotor Position plot and compare to Figure B.9-a on page 
	// 270 of "Roberts..."
#define EVAL_STATOR_ROTOR_VARIABLE_INDUCTANCE
#ifdef EVAL_STATOR_ROTOR_VARIABLE_INDUCTANCE
	fp_stator_rotor_mu_ind_a_dat = fopen("Stator_Rotor_Mutual_Inductance_a.dat", "w");
	fp_stator_rotor_mu_ind_b_dat = fopen("Stator_Rotor_Mutual_Inductance_b.dat", "w");
	fp_stator_rotor_mu_ind_c_dat = fopen("Stator_Rotor_Mutual_Inductance_c.dat", "w");

	//Create include file for simulation program "App_InductionMotor.hpp" 
	fp_stator_rotor_mu_ind_h = fopen("Stator_Rotor_Mutual_Inductance.h", "w");
	fprintf(fp_stator_rotor_mu_ind_h, "\n\n\nMsr[3][360] = {\n");

	for(RotorTheta = 0; RotorTheta < 2.0*PI; RotorTheta = RotorTheta + dTheta)            
	{
		memset(Msr_t_r, 0, sizeof(Msr_t_r));   
		memset(Msr_t, 0, sizeof(Msr_t));        
		memset(Msr_t_bar, 0, sizeof(Msr_t_bar));   
#endif 

		for(i = 0; i < 48; i++)
		{


			if(i < 16)
			{					//Start of Uout
	
				if(i < 4)
				{
				    Bk = slot_pitch * (double) i;
				}
				else if(i < 8)
				{
				    Bk = 12.0 * slot_pitch + slot_pitch * (double) (i - 4);
				}
				else if(i < 12)
				{
				    Bk = 24.0 * slot_pitch + slot_pitch * (double) (i - 8);
				}
				else
				{
				    Bk = 36.0 * slot_pitch + slot_pitch * (double) (i - 12);	
				}


			}
			else if(i < 32)
			{					//Start of Vout

				if(i < 20)
				{
				    Bk = slot_pitch * (double) (i - 16) + slot_pitch * 8.0;
				}
				else if(i < 24)
				{
				    Bk = 12.0 * slot_pitch + slot_pitch * (double) (i - 20)  + slot_pitch * 8.0;
				}
				else if(i < 28)
				{
				    Bk = 24.0 * slot_pitch + slot_pitch * (double) (i - 24)  + slot_pitch * 8.0;
				}
				else
				{
				    Bk = 36.0 * slot_pitch + slot_pitch * (double) (i - 28) + slot_pitch * 8.0;	
				}
		 

			} 
			else
			{					//Start of Wout
				if(i < 36)
				{
				    Bk = slot_pitch * (double) (i - 32) + slot_pitch * 16.0;
				}
				else if(i < 40)
				{
				    Bk = 12.0 * slot_pitch + slot_pitch * (double) (i - 36)  + slot_pitch * 16.0;
				}
				else if(i < 44)
				{
				    Bk = 24.0 * slot_pitch + slot_pitch * (double) (i - 40)  + slot_pitch * 16.0;
				}
				else
				{
				    Bk = 36.0 * slot_pitch + slot_pitch * (double) (i - 44) + slot_pitch * 16.0;	
				}
		 


			}


		

			for(k = 0; k < 6; k++)
			{ 

				 
			   Bj = 2.0*PI*(double) k / 6.0; 

#ifdef EVAL_STATOR_ROTOR_VARIABLE_INDUCTANCE
			   Bj = Bj + RotorTheta;  
#endif   


			   for(n = 1; n < 100; n++)
			   {
			  
			     for(Theta = 0; Theta < 2.0*PI; Theta = Theta + dTheta)
			     {
				    integral_cos_cos = integral_cos_cos + cos((double) n * (Theta - Bk - Ack/2.0 - Wsk/2.0)) * cos((double) n * (Theta - Bj - Acj/2.0 - Wsj/2.0)) * dTheta;
			     }
		     
			     Msr_t_bar[k][i] = Msr_t_bar[k][i] + ((w*d*2.0*Nk*u0*2.0*Nj)/(2.0*PI*g*PI))*sin((double) n * Ack/2.0) * sin((double) n * Wsk/2.0) * sin((double) n * Acj/2.0) * 
						sin((double) n * Wsj/2.0) * integral_cos_cos /
								  (((double) n * (double) n * Wsk/2.0) * ((double) n * (double) n * Wsj/2.0)); 

				integral_cos_cos = 0;


		 	   }	

	 			

			}

#ifndef EVAL_STATOR_ROTOR_VARIABLE_INDUCTANCE
			 printf("%g\t%g\t%g\t%g\t%g\t%g\n", Msr_t_bar[0][i], Msr_t_bar[1][i], Msr_t_bar[2][i], Msr_t_bar[3][i], Msr_t_bar[4][i], Msr_t_bar[5][i]); 
#endif

		  
		}

	


//	 The redundion is a little bit harder to see than that for the stator example "Section_B_2".
//	 So, I will break it down starting with the reference presented in Eq. 2.30 on page 48 of "Roberts..."
//
//
//		  | Tss   0  | | Mss  	Msr | | Tss   0  |-T
//           M =  |  0   Trr | | Msr_t  Mrr | |  0   Trr |
//
//
//                    Tss is a 3 x 48 matrix (see Ts_4 above).
//		      Trr is a 6 x 6 identity matrix because the 6 rotor circuits are not connected to each other.
//
//		      Mss_bar is a 48 x 48 matrix (see "Section_B_2" test)
//		      Mrr_bar is a 6 x 6 matrix (see "Section_B_7" test)
//		      Msr_t_bar is 6 x 48 matrix (see M[][] above) with it transpose Msr_bar a 48 x 6 matrix.
//
//		After conversion by the combination matrix on th right side of the equation above, we have the following.
//
//		      Mss_r is 48 x 3 matrix.
//		      Mrr_r is a 6 x 6 matrix (unchanged).
//                    Msr_t_r is a 6 x 3 matrix
//		      Msr_r is a 48 x 6 matrix (unchanged)      
//
//		After conversion by the combination matrix on th left side of the equation above, we have the following.
//
//		      Mss is a 3 x 3 matrix
//		      Mrr is a 6 x 6 matrix (unchanged)
//		      Msr_t is a 6 x 3 matrix (unchanged)
//                    Msr is a 3 x 6 matrix
//
//


	 	// Form above, we can solve either for Msr_r or Msr_t_r. We choose Msr_t_r
	 
		for(k = 0; k < 6; k++)
	       	{ 
	   	    for(j = 0; j < 3; j++)
		    {
		      	for(i = 0; i < 48; i++)
		      	{
			    Msr_t_r[k][j] = Msr_t_r[k][j] + Msr_t_bar[k][i]*Ts_4[j][i];
		      	}
			// Transfroming Msr_t_r to Msr_t is straight forward.
			Msr_t[k][j] = Msr_t_r[k][j];
		    }
		}
 
#ifdef EVAL_STATOR_ROTOR_VARIABLE_INDUCTANCE
		printf("%g degrees\n",  (360.0 * RotorTheta / (2.0*PI)));                   
		fprintf(fp_stator_rotor_mu_ind_a_dat, "%g\n", Msr_t[0][0]);
		fprintf(fp_stator_rotor_mu_ind_b_dat, "%g\n", Msr_t[0][1]);
		fprintf(fp_stator_rotor_mu_ind_c_dat, "%g\n", Msr_t[0][1]);

		fprintf(fp_stator_rotor_mu_ind_h, "\t\t{%g\t,%g\t,%g},\n", Msr_t[0][0], Msr_t[0][1], Msr_t[0][1]);

		//To view this data, open "octave" and type "plot_stator_rotor_inductance.m"
		
	} 
	fclose(fp_stator_rotor_mu_ind_a_dat);
	fclose(fp_stator_rotor_mu_ind_b_dat);
	fclose(fp_stator_rotor_mu_ind_c_dat);

	fprintf(fp_stator_rotor_mu_ind_h, "\t\t};\n");

	fclose(fp_stator_rotor_mu_ind_h);
#else
 
	
	 printf("\n\n\n");	
	 printf("%g\t%g\t%g\n", Msr_t[0][0],  Msr_t[0][1],  Msr_t[0][2]); 
	 printf("%g\t%g\t%g\n", Msr_t[1][0],  Msr_t[1][1],  Msr_t[1][2]); 
	 printf("%g\t%g\t%g\n", Msr_t[2][0],  Msr_t[2][1],  Msr_t[2][2]); 
	 printf("%g\t%g\t%g\n", Msr_t[3][0],  Msr_t[3][1],  Msr_t[3][2]); 
	 printf("%g\t%g\t%g\n", Msr_t[4][0],  Msr_t[4][1],  Msr_t[4][2]); 
	 printf("%g\t%g\t%g\n", Msr_t[5][0],  Msr_t[5][1],  Msr_t[5][2]); 
 
#endif


//#define TEST_EQ_2_53 
#ifdef TEST_EQ_2_53

	//Here we verify Section 2.7.2 Equation 2.53 page 63 relative to using the following identity
	//        cos (x – y)  =  ( cos x )( cos y ) + ( sin x )( sin y ) 
	//to bring the rotor angle within it's own "cos" function. There is one conflict with "Roberts..."
	//as noted below.
            
              printf("\n\n\n");
              for(Bj = 0; Bj < 2.0*PI; Bj = Bj + dTheta)
              {
	        
		// for(n = 0; n < 20; n++)       //(TST1)
		//   {                           //

		// for(n = -9; n < 10; n++)	 //(TST2)
		//   {                           //

                       
         	for(i = 1; i < 100; i++)      //(TST3)
                 {                            //

		     n = 2*(2*i);	     // (produces close to 2*PI for all three integrations, like TST1 AND TST2 above)
	          //    n = 2*(2*i - 1);	     // (produces 0 for all three integrations)
		     

		     for(Theta = 0; Theta < 2.0*PI; Theta = Theta + dTheta)
		     {
		        Test_integral_1 = Test_integral_1 + cos((double) n * (Theta - Bj)) * dTheta; 
			 //NOTES:    
			 //        "sin" expression evaluates to zero:
		         //           - Independent of "Bj" 
                         //           - Independent of "n" range +/- infinity or "0" to infinity. (Uncomment TST1, and TST2 above)
                         //	      - Valid for all "even" n multiples of 2 pole, "Test_integral_1/2/3" goes to zero for "n" odd (This contradicts section 2.7.2 of "Roberts"!)
			 //
			 //
			 //
		        Test_integral_2 = Test_integral_2 + (cos((double) n * Theta) * cos((double) n * Bj) + sin((double) n * Theta) * sin((double) n * Bj)) * dTheta;

			Test_integral_3 = Test_integral_3 + cos((double) n * Theta) * cos((double) n * Bj) * dTheta;
                     }

                  }
		  printf("%g\t%g\t%g\n", Test_integral_1,  Test_integral_2, Test_integral_3); 
		  Test_integral_1 = 0;
                  Test_integral_2 = 0;
		  Test_integral_3 = 0;
	      }
#endif	      


}
