
#include <math.h>
#include <stdio.h>
#include <stdlib.h>

#define PI 3.1415926535897932384626433832795


//Calculation of Mutual Inductance Matrix for "Rotor 5: 6 bar cage rotor design" (see page 267)

//Rotor 5: 6 bar squirrel cage design (simulation only) (from page 274, Table B.4)
//
//	Conductor 	Conductor 	Slot 	Fill
//	area                metal       area    factor
//	(mm**2)                         (mm**2)
//
//	205.84 		    Cu 		280 	0.74
//

//Rotor 5: 6 bar squirrel cage design (simulation only)  (see page 284, Table C.2)
//
//diameter 	Stack length 	rotor-stator 	No. slots 	Carter Factor 	Carter Factor 	Carter Factor 	air gap	  air gap 	slot mouth 	air gap
//				stack overlap 					(Approx.) 	(Ossana Approx.) 	  (tol.) 	width 		(eff.)
//
//   d             w                                                K                                             g                       wo             geff
//  (mm)          (mm)             (mm)                                                                          (mm)     +/-(mm)        (mm)            (mm)
//
//  173.971       189.9           189.9            6            K = 1 by assumption                              0.547     0.03          8.4             0.645


FILE * fp_rotor_rotor_mu_ind_h;

#define w  .1899
#define d  .173971
#define Nk  1.0
#define Nj  1.0
#define g  .000645
#define u0  (4.0*PI*1.0e-7)   //Permeability of vacuum.

#define Ack  (2.0*PI/6.0)     //From Figure 2.2 on page 42.
#define Wsk  (2.0*PI*.0084/(2.0*PI*.173971/2.0))   //
#define Bk    0		   	  //This changes depending on which row of the mutual inductance matrix is being calculated.
    
#define Acj  Ack	       //These the same as the k'th circuit.
#define Wsj  Wsk               //

double Bj;		       //This becomes the variable for computing each matrix element of a given row.
double M[6] = {0};		       //One row of the mutual inductance matrix.
 
double Theta;
#define dTheta (2.0*PI/360.0)      //One degree integration.

double integral_cos_cos = 0;
 
//Invocation:
//
// gcc -g Section_B_7.c -lm


main()
{
	int n,j,k;

	//Create include file for simulation program "App_InductionMotor.hpp" 
	fp_rotor_rotor_mu_ind_h = fopen("Rotor_Rotor_Mutual_Inductance.h", "w");
	fprintf(fp_rotor_rotor_mu_ind_h, "\n\n\ndouble Mrr[6][6] = {\n");

	//We use the mutual inductance equation defined in Eq 2.27 on page 46, Section 2.4.3 because there is no coil groups.

	for(k = 0; k < 6; k++)
        { 

	   Bj = 2.0*PI*(double) k / 6.0;

	   for(n = 1; n < 100; n++)
	   {
	  
	  	for(Theta = 0; Theta < 2.0*PI; Theta = Theta + dTheta)
                {
		    integral_cos_cos = integral_cos_cos + cos((double) n * (Theta - Bk - Ack/2.0 - Wsk/2.0)) * cos((double) n * (Theta - Bj - Acj/2.0 - Wsj/2.0)) * dTheta;
		}
     
	        M[k] = M[k] + ((w*d*2.0*Nk*u0*2.0*Nj)/(2.0*PI*g*PI))*sin((double) n * Ack/2.0) * sin((double) n * Wsk/2.0) * sin((double) n * Acj/2.0) * sin((double) n * Wsj/2.0) *
			                   integral_cos_cos /
					          (((double) n * (double) n * Wsk/2.0) * ((double) n * (double) n * Wsj/2.0)); 

		integral_cos_cos = 0;


 	   }	

	   Bj = 2.0*PI*(double) k / 6.0;

	   printf("%g\n", M[k]); 

	  
	}
 
	 fprintf(fp_rotor_rotor_mu_ind_h, "\t\t{%g\t,%g\t,%g\t,%g\t,%g\t,%g},\n", M[0], M[1], M[2], M[3], M[4], M[5]); 
	 fprintf(fp_rotor_rotor_mu_ind_h, "\t\t{%g\t,%g\t,%g\t,%g\t,%g\t,%g},\n", M[5], M[0], M[1], M[2], M[3], M[4]);  
	 fprintf(fp_rotor_rotor_mu_ind_h, "\t\t{%g\t,%g\t,%g\t,%g\t,%g\t,%g},\n", M[4], M[5], M[0], M[1], M[2], M[3]); 
	 fprintf(fp_rotor_rotor_mu_ind_h, "\t\t{%g\t,%g\t,%g\t,%g\t,%g\t,%g},\n", M[3], M[4], M[5], M[0], M[1], M[2]); 
	 fprintf(fp_rotor_rotor_mu_ind_h, "\t\t{%g\t,%g\t,%g\t,%g\t,%g\t,%g},\n", M[2], M[3], M[4], M[5], M[0], M[1]); 
	 fprintf(fp_rotor_rotor_mu_ind_h, "\t\t{%g\t,%g\t,%g\t,%g\t,%g\t,%g},\n", M[1], M[2], M[3], M[4], M[5], M[0]); 
	 fprintf(fp_rotor_rotor_mu_ind_h, "\t\t};\n");


	 fclose(fp_rotor_rotor_mu_ind_h);

}
