#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>


#define PI 3.1415926535897932384626433832795

//Varifacation of Mdq_sr matrix defined in Equation B.41 on page 271 of "Roberts..."
//This is created by using Equation 3.26 on page 79 of "Roberts..."


//Invocation:
//
// gcc -g Section_B_7_2.c -lm



//From Equation 2.53 on page 63 of "Roberts..." we construct Msr based on 4 pole (2 pole pair) stator and 6 bar squirrel cage rotor.
//We use the information obtained from the "Section_2_2_2" test (octave > plot_stator_rotor_inductance) with that verified by
//in Figure B.9 (a) on page 269 of "Roberts...".

double Beta_1;   // Select arbitrary angle between first rotor coil (loop) and first phase of the stator winding. (see explaination for Msr on Page 63 of "Roberts..."
double Theta_r;    // Select arbitrary rotor angle. In reality, Theta_r is a variable.

// By running "plot_stator_rotor_inductance.m" from Section_2_7_2 test octave and noting the peak value of phase a (b and c), we obtain the the
// equivilent of Sum(M1(n) as a coefficient to each element in Msr.
// This comes out to be approximate "1.57e-3"
//This brings in our previously computed M1 (1.3e-3  was the value obtained from Figure B.9 (a) of "Roberts...")
#include "../Section_2_7_2/Stator_Rotor_Mutual_Inductance_Value_M1.h"


 
double Msr[3][6];

// The DQ stator winding transformation is define in Equation 3.1 page 72 of "Roberts..."

double Cs1[3][3];

// We have already determined "Cr" (see Equation 3.4 page 74 of "Roberts..." from the test done in "Lemma_A_12" which is composed.
// Actually we need only Crl (Equation 3.3 on page 73) and not Cr1_ because no inversion is involved in the calculation for determing Mdq_sr
// We run "Evaluate.m" in directory Lemma_A_12 in octave to produce "a_extend" matrix, which is the matrix Cr defined in "Roberts..."
// (Copy "a_extend" produced by "Evaluate.m" and construct Cr here...)

double Cr[6][6] = {{0.57735,  -0.28868,  -0.28868,   0.57735,  -0.28868,  -0.28868},
                   {0.00000,   0.50000,  -0.50000,  -0.00000,   0.50000,  -0.50000},
                   {0.40825,   0.40825,   0.40825,   0.40825,   0.40825,   0.40825},
                   {0.00000,   0.00000,   0.70711,   0.00000,   0.00000,  -0.70711},
                   {0.00000,   0.70711,   0.00000,   0.00000,  -0.70711,   0.00000},
                   {0.70711,  -0.00000,   0.00000,  -0.70711,  -0.00000,   0.00000}};



double Mdq_sr[3][6] = {0};



	//Intermediate matrix 
double Msr_Cr_t[3][6] = {0};

double M1;


FILE * fp_stator_rotor_phase_offset_dat;

#define dTheta (2.0*PI/360.0)      //One degree integration.

main()
{
	int i,j,k;

#define COMPARE_TO_B_34_EXACTLY
#ifdef COMPARE_TO_B_34_EXACTLY
	M1 = 1.3e-3;
#else
		//use our computed value...
	M1 =  M1_inductance_value;
#endif

	
   //Define to view effect of Stator to Rotor offset in Cs1 * Msr * Cr_t calculation defined by Equation 3.26 of "Roberts...".
   //Also, compare to Mdq_sr defined by Equation B.34 on page 269 of "Roberts...".
#define INTERATE_STATOR_ROTOR_PHASE_OFFSET
#ifdef INTERATE_STATOR_ROTOR_PHASE_OFFSET
	double RotorTheta;
	
	fp_stator_rotor_phase_offset_dat = fopen("Stator_Rotor_Phase_Offset.dat", "w");

	Theta_r = 0;

	//Set Beta_1 to a value that tries statisfies Eq. B.34  on page 269 of "Roberts...".  (M1 must be set to 1.3e-3 as per Figure B.9a on page 269)
	//Even when doing this it seems like we have a sign problem?
	Beta_1 =  (((-37.0 +180 )/360) * 2.0 * PI);

	for(RotorTheta = 0; RotorTheta < 2.0*PI; RotorTheta = RotorTheta + dTheta)
	{
	    memset(Mdq_sr, 0, sizeof(Mdq_sr));
	    memset(Msr_Cr_t, 0, sizeof(Msr_Cr_t));	 


	  Theta_r = RotorTheta;

#else
	Beta_1 = (((-37.0 +180 )/360) * 2.0 * PI);;
	Theta_r = 0;;  

#endif 
		
		//Note that we multiply the by 2.0 in all these terms. This reflects the value of Q = p1(2k - 1) for "n" Equation 2.53, page 63 of "Roberts..."
                //for k = 1 (the fundimental frequency).
	Msr[0][0] = M1 * cos(2.0 * (Theta_r - (0.0 * 2.0 * PI / 6.0) - Beta_1));
	Msr[0][1] = M1 * cos(2.0 * (Theta_r - (1.0 * 2.0 * PI / 6.0) - Beta_1));
   	Msr[0][2] = M1 * cos(2.0 * (Theta_r - (2.0 * 2.0 * PI / 6.0) - Beta_1));
        Msr[0][3] = M1 * cos(2.0 * (Theta_r - (3.0 * 2.0 * PI / 6.0) - Beta_1));
        Msr[0][4] = M1 * cos(2.0 * (Theta_r - (4.0 * 2.0 * PI / 6.0) - Beta_1));
        Msr[0][5] = M1 * cos(2.0 * (Theta_r - (5.0 * 2.0 * PI / 6.0) - Beta_1));

	Msr[1][0] = M1 * cos(2.0 * (Theta_r - (0.0 * 2.0 * PI / 6.0) - (2.0 * PI / 6.0) - Beta_1));
	Msr[1][1] = M1 * cos(2.0 * (Theta_r - (1.0 * 2.0 * PI / 6.0) - (2.0 * PI / 6.0) - Beta_1));
   	Msr[1][2] = M1 * cos(2.0 * (Theta_r - (2.0 * 2.0 * PI / 6.0) - (2.0 * PI / 6.0) - Beta_1));
        Msr[1][3] = M1 * cos(2.0 * (Theta_r - (3.0 * 2.0 * PI / 6.0) - (2.0 * PI / 6.0) - Beta_1));
        Msr[1][4] = M1 * cos(2.0 * (Theta_r - (4.0 * 2.0 * PI / 6.0) - (2.0 * PI / 6.0) - Beta_1));
        Msr[1][5] = M1 * cos(2.0 * (Theta_r - (5.0 * 2.0 * PI / 6.0) - (2.0 * PI / 6.0) - Beta_1));

	Msr[2][0] = M1 * cos(2.0 * (Theta_r - (0.0 * 2.0 * PI / 6.0) - (4.0 * PI / 6.0) - Beta_1));
	Msr[2][1] = M1 * cos(2.0 * (Theta_r - (1.0 * 2.0 * PI / 6.0) - (4.0 * PI / 6.0) - Beta_1));
   	Msr[2][2] = M1 * cos(2.0 * (Theta_r - (2.0 * 2.0 * PI / 6.0) - (4.0 * PI / 6.0) - Beta_1));
        Msr[2][3] = M1 * cos(2.0 * (Theta_r - (3.0 * 2.0 * PI / 6.0) - (4.0 * PI / 6.0) - Beta_1));
        Msr[2][4] = M1 * cos(2.0 * (Theta_r - (4.0 * 2.0 * PI / 6.0) - (4.0 * PI / 6.0) - Beta_1));
        Msr[2][5] = M1 * cos(2.0 * (Theta_r - (5.0 * 2.0 * PI / 6.0) - (4.0 * PI / 6.0) - Beta_1));

#ifndef INTERATE_STATOR_ROTOR_PHASE_OFFSET
	printf("\n\nMsr = \n");	
	printf("%g\t%g\t%g\t%g\t%g\t%g\n", Msr[0][0], Msr[0][1], Msr[0][2], Msr[0][3], Msr[0][4], Msr[0][5]); 
	printf("%g\t%g\t%g\t%g\t%g\t%g\n", Msr[1][0], Msr[1][1], Msr[1][2], Msr[1][3], Msr[1][4], Msr[1][5]); 
	printf("%g\t%g\t%g\t%g\t%g\t%g\n", Msr[2][0], Msr[2][1], Msr[2][2], Msr[2][3], Msr[2][4], Msr[2][5]); 
#endif 


	Cs1[0][0] = sqrt(2.0/3.0) * cos(2.0 * (Theta_r - 0.0 * PI / 6.0));
        Cs1[0][1] = sqrt(2.0/3.0) * cos(2.0 * (Theta_r - 2.0 * PI / 6.0));
	Cs1[0][2] = sqrt(2.0/3.0) * cos(2.0 * (Theta_r - 4.0 * PI / 6.0));
	Cs1[1][0] = sqrt(2.0/3.0) * sin(2.0 * (Theta_r - 0.0 * PI / 6.0));
        Cs1[1][1] = sqrt(2.0/3.0) * sin(2.0 * (Theta_r - 2.0 * PI / 6.0));
	Cs1[1][2] = sqrt(2.0/3.0) * sin(2.0 * (Theta_r - 4.0 * PI / 6.0));
	Cs1[2][0] = sqrt(2.0/3.0) * 1.0 / sqrt(2.0); 
        Cs1[2][1] = sqrt(2.0/3.0) * 1.0 / sqrt(2.0);  
	Cs1[2][2] = sqrt(2.0/3.0) * 1.0 / sqrt(2.0);  

	// Cs1 * Msr * Cr_t (Equation 3.26)

	for(i = 0; i < 3; i++)
        {
            for(j = 0; j < 6; j++)
            {
		for(k = 0; k < 6; k++)
		{	
                    Msr_Cr_t[i][j] =  Msr_Cr_t[i][j] +  Msr[i][k] * Cr[j][k];
		}
            }
        }


#ifndef INTERATE_STATOR_ROTOR_PHASE_OFFSET
	 printf("\n\nMsr_Cr_t = \n");	
	 printf("%g\t%g\t%g\t%g\t%g\t%g\n", Msr_Cr_t[0][0], Msr_Cr_t[0][1], Msr_Cr_t[0][2], Msr_Cr_t[0][3], Msr_Cr_t[0][4], Msr_Cr_t[0][5]); 
	 printf("%g\t%g\t%g\t%g\t%g\t%g\n", Msr_Cr_t[1][0], Msr_Cr_t[1][1], Msr_Cr_t[1][2], Msr_Cr_t[1][3], Msr_Cr_t[1][4], Msr_Cr_t[1][5]); 
	 printf("%g\t%g\t%g\t%g\t%g\t%g\n", Msr_Cr_t[2][0], Msr_Cr_t[2][1], Msr_Cr_t[2][2], Msr_Cr_t[2][3], Msr_Cr_t[2][4], Msr_Cr_t[2][5]); 
#endif 

	for(i = 0; i < 3; i++)
        {
	    for(j = 0; j < 6; j++)
            {
		for(k = 0; k < 3; k++)
                {
		   Mdq_sr[i][j] = Mdq_sr[i][j] + Cs1[i][k] * Msr_Cr_t[k][j];
                }
            }
	}
#ifndef INTERATE_STATOR_ROTOR_PHASE_OFFSET
	 printf("\n\nMdq_sr = \n");	
	 printf("%g\t%g\t%g\t%g\t%g\t%g\n", Mdq_sr[0][0], Mdq_sr[0][1], Mdq_sr[0][2], Mdq_sr[0][3], Mdq_sr[0][4], Mdq_sr[0][5]); 
	 printf("%g\t%g\t%g\t%g\t%g\t%g\n", Mdq_sr[1][0], Mdq_sr[1][1], Mdq_sr[1][2], Mdq_sr[1][3], Mdq_sr[1][4], Mdq_sr[1][5]); 
	 printf("%g\t%g\t%g\t%g\t%g\t%g\n", Mdq_sr[2][0], Mdq_sr[2][1], Mdq_sr[2][2], Mdq_sr[2][3], Mdq_sr[2][4], Mdq_sr[2][5]); 
#endif

#ifdef INTERATE_STATOR_ROTOR_PHASE_OFFSET

	    //NOTE: I cannot find  the exact phasing expressed in Equation B.34. (Missing an inversion somewhere?)
	    //      Also note the extra "10e-6" in this equation. Indication is that this is a typo (look at Equation B.41 for "Standard Squirrel Cage Rotor Details"). 
	    //      Other than that, this test seems correct.

	  // As expected howerver, the interation is not effected by the changing value of "Theta_r"

	    fprintf(fp_stator_rotor_phase_offset_dat, "%g\t%g\t\t%g\n", Mdq_sr[0][0], Mdq_sr[0][1], RotorTheta * 360.0 / (2.0 * PI));
	    fprintf(fp_stator_rotor_phase_offset_dat, "%g\t%g\n\n",  Mdq_sr[1][0], Mdq_sr[1][1]);	


	}
	fclose(fp_stator_rotor_phase_offset_dat);
#endif
	
}
