#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

FILE * fp_d_dq_stator_stator_mu_ind_h;


#define PI 3.1415926535897932384626433832795

//Varifacation of Equation 3.17 on page 76 of "Roberts..."


//Invocation:
//
// gcc -g Verify_Eq_3_17.c -lm  (Ubuntu 14.04 gcc requires "-lm" after file(s) to be compiled)

double Cs1[3][3] = {0};
double dCs1_dtheta_r[3][3] = {0};

double Mss_dCs1_t_dtheta_r[3][3] = {0};
double Qdq0s1[3][3] = {0};

double theta_r;

//#define USE_CALCULATED_MSS
#ifdef USE_CALCULATED_MSS
//This brings in our previously computed Ms1 (labeled here as "Mss")
#include "../Section_B_2/Stator_Stator_Mutual_Inductance.h"

#else  //make all L's and M's equal to get a more accurate test result...

double Mss[3][3] = {
		{0.278875	,-0.127427	,-0.127427},
		{-0.127427	,0.278875	,-0.127427},
		{-0.127427	,-0.127427	,0.278875},
		};

#endif
 
main()
{
	int i,j,k;
	int test_count;

	//Create include file for simulation program "App_InductionMotor.hpp" 
	fp_d_dq_stator_stator_mu_ind_h = fopen("d_dq_Stator_Stator_Mutual_Inductance.h", "w");
	fprintf(fp_d_dq_stator_stator_mu_ind_h, "\n\n\ndouble Qdq0s[3][3] = {\n");

	  for(test_count = 0; test_count <= 3; test_count++)
	  {
		memset(Mss_dCs1_t_dtheta_r, 0, sizeof(Mss_dCs1_t_dtheta_r));
		memset(Qdq0s1, 0, sizeof(Qdq0s1));
		if(test_count == 0)
			theta_r = 0;
		else if(test_count == 1)
			theta_r = .23 *  PI;
		else if(test_count == 2)
			theta_r = .356 * PI;
		else
			theta_r = .678 * PI;


		 Cs1[0][0] = sqrt(2.0 / 3.0) * cos(2.0 * theta_r);
		 Cs1[0][1] = sqrt(2.0 / 3.0) * cos(2.0 * theta_r + 2.0 * PI / 3.0);
		 Cs1[0][2] = sqrt(2.0 / 3.0) * cos(2.0 * theta_r + 4.0 * PI / 3.0);
		 Cs1[1][0] = sqrt(2.0 / 3.0) * sin(2.0 * theta_r);
		 Cs1[1][1] = sqrt(2.0 / 3.0) * sin(2.0 * theta_r + 2.0 * PI / 3.0);
		 Cs1[1][2] = sqrt(2.0 / 3.0) * sin(2.0 * theta_r + 4.0 * PI / 3.0);
		 Cs1[2][0] = sqrt(2.0 / 3.0) * 1.0 / sqrt(2.0);
		 Cs1[2][1] = sqrt(2.0 / 3.0) * 1.0 / sqrt(2.0);
		 Cs1[2][2] = sqrt(2.0 / 3.0) * 1.0 / sqrt(2.0);

		 dCs1_dtheta_r[0][0] = - 2.0 * sqrt(2.0 / 3.0) * sin(2.0 * theta_r);
		 dCs1_dtheta_r[0][1] = - 2.0 * sqrt(2.0 / 3.0) * sin(2.0 * theta_r + 2.0 * PI / 3.0);
		 dCs1_dtheta_r[0][2] = - 2.0 * sqrt(2.0 / 3.0) * sin(2.0 * theta_r + 4.0 * PI / 3.0);
		 dCs1_dtheta_r[1][0] = 2.0 * sqrt(2.0 / 3.0) * cos(2.0 * theta_r);
		 dCs1_dtheta_r[1][1] = 2.0 * sqrt(2.0 / 3.0) * cos(2.0 * theta_r + 2.0 * PI / 3.0);
		 dCs1_dtheta_r[1][2] = 2.0 * sqrt(2.0 / 3.0) * cos(2.0 * theta_r + 4.0 * PI / 3.0);
		 dCs1_dtheta_r[2][0] = 0;
		 dCs1_dtheta_r[2][1] = 0;
		 dCs1_dtheta_r[2][2] = 0;






		  //Equation 3.17..
		  // Cs1 * Ms1 * (dCs1_dtheta_r)_t

		 for(i = 0; i < 3; i++)
		 {
			for(j = 0; j < 3; j++)
			{

				for(k = 0; k < 3; k++)
				{
					Mss_dCs1_t_dtheta_r[i][j] =  Mss_dCs1_t_dtheta_r[i][j] +  Mss[i][k] * dCs1_dtheta_r[j][k];

				}
			}
		 }

		 for(i = 0; i < 3; i++)
		 {
			for(j = 0; j < 3; j++)
			{

				for(k = 0; k < 3; k++)
				{
					Qdq0s1[i][j] = Qdq0s1[i][j] + Cs1[i][k] * Mss_dCs1_t_dtheta_r[k][j];


				}
			  }
		   }
	
		 printf("\n\nQdq0s1= \n");
		 printf("%g\t%g\t%g\n", Qdq0s1[0][0], Qdq0s1[0][1], Qdq0s1[0][2]);
		 printf("%g\t%g\t%g\n", Qdq0s1[1][0], Qdq0s1[1][1], Qdq0s1[1][2]);
		 printf("%g\t%g\t%g\n", Qdq0s1[2][0], Qdq0s1[2][1], Qdq0s1[2][2]);

		if(test_count == 0)
		{
			fprintf(fp_d_dq_stator_stator_mu_ind_h, "\t\t{%g\t,%g\t,%g},\n", Qdq0s1[0][0],  Qdq0s1[0][1],  Qdq0s1[0][2]); 
	 		fprintf(fp_d_dq_stator_stator_mu_ind_h, "\t\t{%g\t,%g\t,%g},\n", Qdq0s1[1][0],  Qdq0s1[1][1],  Qdq0s1[1][2]); 
	 		fprintf(fp_d_dq_stator_stator_mu_ind_h, "\t\t{%g\t,%g\t,%g},\n", Qdq0s1[2][0],  Qdq0s1[2][1],  Qdq0s1[2][2]); 
	 		fprintf(fp_d_dq_stator_stator_mu_ind_h, "\t\t};\n");


	 		fclose(fp_d_dq_stator_stator_mu_ind_h);
		}



    }

}
