#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>


FILE * fp_dq_stator_stator_mu_ind_h;

#define PI 3.1415926535897932384626433832795

//Varifacation of Equation 3.19 on page 76 of "Roberts..."


//Invocation:
//
// gcc -g Verify_Eq_3_19_ideal.c -lm  (Ubuntu 14.04 gcc requires "-lm" after file(s) to be compiled)

double Cs1[3][3] = {0};


double Mss_Cs1_t[3][3] = {0};
double Mdq0s1[3][3] = {0};

double theta_r;

//#define USE_CALCULATED_MSS
#ifdef USE_CALCULATED_MSS
//This brings in our previously computed Ms1 (labeled here as "Mss")
#include "../Section_B_2/Stator_Stator_Mutual_Inductance.h"

#else  //use make all L's and M's equal to get a more accurate result...

//***** Use the value for "Mss" selected for "App_InductionMotor.hpp"****
double Mss[3][3] = {
							{0.278875		,-0.1394375	,-0.1394375},
							{-0.1394375	,0.278875		,-0.1394375},
							{-0.1394375	,-0.1394375	,0.278875},
						  };
#endif
 
main()
{
	int i,j,k;
	int test_count;

		//Create include file for simulation program "App_InductionMotor.hpp" 
	fp_dq_stator_stator_mu_ind_h = fopen("dq_Stator_Stator_Mutual_Inductance_ideal.h", "w");
	fprintf(fp_dq_stator_stator_mu_ind_h, "\n\n\ndouble Mdq0s[3][3] = {\n");

	  for(test_count = 0; test_count <= 3; test_count++)
	  {
		memset(Mss_Cs1_t, 0, sizeof(Mss_Cs1_t));
		memset(Mdq0s1, 0, sizeof(Mdq0s1));
		if(test_count == 0)
			theta_r = 0;
		else if(test_count == 1)
			theta_r = .23 *  PI;
		else if(test_count == 2)
			theta_r = .356 * PI;
		else
			theta_r = .678 * PI;

		//***** For the "ideal" case (as simulated by "App_InductionMotor.hpp", p1 = 1 (1 pole pair).   *****

		 Cs1[0][0] = sqrt(2.0 / 3.0) * cos(1.0 * theta_r);
		 Cs1[0][1] = sqrt(2.0 / 3.0) * cos(1.0 * theta_r + 2.0 * PI / 3.0);
		 Cs1[0][2] = sqrt(2.0 / 3.0) * cos(1.0 * theta_r + 4.0 * PI / 3.0);
		 Cs1[1][0] = sqrt(2.0 / 3.0) * sin(1.0 * theta_r);
		 Cs1[1][1] = sqrt(2.0 / 3.0) * sin(1.0 * theta_r + 2.0 * PI / 3.0);
		 Cs1[1][2] = sqrt(2.0 / 3.0) * sin(1.0 * theta_r + 4.0 * PI / 3.0);
		 Cs1[2][0] = sqrt(2.0 / 3.0) * 1.0 / sqrt(2.0);
		 Cs1[2][1] = sqrt(2.0 / 3.0) * 1.0 / sqrt(2.0);
		 Cs1[2][2] = sqrt(2.0 / 3.0) * 1.0 / sqrt(2.0);




		  //Equation 3.19..
		  // Cs1 * Ms1 * (Cs1)_t

		 for(i = 0; i < 3; i++)
		 {
			for(j = 0; j < 3; j++)
			{

				for(k = 0; k < 3; k++)
				{
					Mss_Cs1_t[i][j] =  Mss_Cs1_t[i][j] +  Mss[i][k] * Cs1[j][k];

				}
			}
		 }

		 for(i = 0; i < 3; i++)
		 {
			for(j = 0; j < 3; j++)
			{

				for(k = 0; k < 3; k++)
				{
					Mdq0s1[i][j] = Mdq0s1[i][j] + Cs1[i][k] * Mss_Cs1_t[k][j];


				}
			  }
		   }
	
		 printf("\n\nMdq0s1 = \n");
		 printf("%g\t%g\t%g\n", Mdq0s1[0][0], Mdq0s1[0][1], Mdq0s1[0][2]);
		 printf("%g\t%g\t%g\n", Mdq0s1[1][0], Mdq0s1[1][1], Mdq0s1[1][2]);
		 printf("%g\t%g\t%g\n", Mdq0s1[2][0], Mdq0s1[2][1], Mdq0s1[2][2]);

		if(test_count == 0)
		{
			fprintf(fp_dq_stator_stator_mu_ind_h, "\t\t{%g\t,%g\t,%g},\n", Mdq0s1[0][0],  Mdq0s1[0][1],  Mdq0s1[0][2]); 
	 		fprintf(fp_dq_stator_stator_mu_ind_h, "\t\t{%g\t,%g\t,%g},\n", Mdq0s1[1][0],  Mdq0s1[1][1],  Mdq0s1[1][2]); 
	 		fprintf(fp_dq_stator_stator_mu_ind_h, "\t\t{%g\t,%g\t,%g},\n", Mdq0s1[2][0],  Mdq0s1[2][1],  Mdq0s1[2][2]); 
	 		fprintf(fp_dq_stator_stator_mu_ind_h, "\t\t};\n");


	 		fclose(fp_dq_stator_stator_mu_ind_h);
		}



    }

}
