#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

FILE * fp_dq_rotor_rotor_mu_ind_h;

#define PI 3.1415926535897932384626433832795

//Varifacation of Equation 3.24 on page 77 of "Roberts..."


//Invocation:
//
// gcc -g Verify_Eq_3_24.c -lm  (Ubuntu 14.04 gcc requires "-lm" after file(s) to be compiled)


//This transformation matrix was also used in test project "Section_B_7_2.c" and was generated by test project "Lemma_A_12.c"
double Cr[6][6] = {{0.57735,  -0.28868,  -0.28868,   0.57735,  -0.28868,  -0.28868},
                   {0.00000,   0.50000,  -0.50000,  -0.00000,   0.50000,  -0.50000},
                   {0.40825,   0.40825,   0.40825,   0.40825,   0.40825,   0.40825},
                   {0.00000,   0.00000,   0.70711,   0.00000,   0.00000,  -0.70711},
                   {0.00000,   0.70711,   0.00000,   0.00000,  -0.70711,   0.00000},
                   {0.70711,  -0.00000,   0.00000,  -0.70711,  -0.00000,   0.00000}};



double Mrr_Cr_t[6][6] = {0};
double Mdqr[6][6] = {0};

//#define USE_CALCULATED_MRR
#ifdef USE_CALCULATED_MRR
//This brings in our previously computed Mr (labeled here as "Mrr")
#include "../Section_B_7/Rotor_Rotor_Mutual_Inductance.h"

#else  //make all L's and M's equal to get a more accurate test result...

double Mrr[6][6] = {
		{2.71067e-05	,-5.12801e-06	,-5.12801e-06	,-5.12801e-06	,-5.12801e-06	,-5.12801e-06},
		{-5.12801e-06	,2.71067e-05	,-5.12801e-06	,-5.12801e-06	,-5.12801e-06	,-5.12801e-06},
		{-5.12801e-06	,-5.12801e-06	,2.71067e-05	,-5.12801e-06	,-5.12801e-06	,-5.12801e-06},
		{-5.12801e-06	,-5.12801e-06	,-5.12801e-06	,2.71067e-05	,-5.12801e-06	,-5.12801e-06},
		{-5.12801e-06	,-5.12801e-06	,-5.12801e-06	,-5.12801e-06	,2.71067e-05	,-5.12801e-06},
		{-5.12801e-06	,-5.12801e-06	,-5.12801e-06	,-5.12801e-06	,-5.12801e-06	,2.71067e-05},
		};


#endif

main()
{
	int i,j,k;

			//Create include file for simulation program "App_InductionMotor.hpp" 
	fp_dq_rotor_rotor_mu_ind_h = fopen("dq_Rotor_Rotor_Mutual_Inductance.h", "w");
	fprintf(fp_dq_rotor_rotor_mu_ind_h, "\n\n\ndouble Mdqr[6][6] = {\n");


	  //Equation 3.24..
	  // Cr * Mr * (Cr)_t

	 for(i = 0; i < 6; i++)
	 {
		for(j = 0; j < 6; j++)
		{

			for(k = 0; k < 6; k++)
			{
				Mrr_Cr_t[i][j] =  Mrr_Cr_t[i][j] +  Mrr[i][k] * Cr[j][k];

			}
		}
	 }

	 for(i = 0; i < 6; i++)
	 {
		for(j = 0; j < 6; j++)
		{

			for(k = 0; k < 6; k++)
			{
				Mdqr[i][j] = Mdqr[i][j] + Cr[i][k] * Mrr_Cr_t[k][j];


			}
		  }
	   }

	 printf("\n\nMdqr = \n");
	 printf("%g\t%g\t%g\t%g\t%g\t%g\n", Mdqr[0][0], Mdqr[0][1], Mdqr[0][2], Mdqr[0][3], Mdqr[0][4], Mdqr[0][5]);
	 printf("%g\t%g\t%g\t%g\t%g\t%g\n", Mdqr[1][0], Mdqr[1][1], Mdqr[1][2], Mdqr[1][3], Mdqr[1][4], Mdqr[1][5]);
	 printf("%g\t%g\t%g\t%g\t%g\t%g\n", Mdqr[2][0], Mdqr[2][1], Mdqr[2][2], Mdqr[2][3], Mdqr[2][4], Mdqr[2][5]);
	 printf("%g\t%g\t%g\t%g\t%g\t%g\n", Mdqr[3][0], Mdqr[3][1], Mdqr[3][2], Mdqr[3][3], Mdqr[3][4], Mdqr[3][5]);
	 printf("%g\t%g\t%g\t%g\t%g\t%g\n", Mdqr[4][0], Mdqr[4][1], Mdqr[4][2], Mdqr[4][3], Mdqr[4][4], Mdqr[4][5]);
	 printf("%g\t%g\t%g\t%g\t%g\t%g\n", Mdqr[5][0], Mdqr[5][1], Mdqr[5][2], Mdqr[5][3], Mdqr[5][4], Mdqr[5][5]);

	 //The result reflects the definition for Eq 3.24 and Lemma A.16 for a symmetric matrix,
	 //namily Ldqr1 is defined for row/column elements 0/0 and 1/1. 
	 //Row/column 2/2 is defined as L0r1.
	 //Row/Column 3/3, 4/4, 5/5 are not zero but are defined to be "not relevent". (This  is the result of the "extended" Cr matrix).
	 //All other elements on either side of tht diagonal are "ideally zero" (even though in our test, floating point resolution shows
	 //some elements as small non-zero values.)

	 fprintf(fp_dq_rotor_rotor_mu_ind_h, "\t\t{%g\t,%g\t,%g\t,%g\t,%g\t,%g},\n", Mdqr[0][0], Mdqr[0][1], Mdqr[0][2], Mdqr[0][3], Mdqr[0][4], Mdqr[0][5]);
	 fprintf(fp_dq_rotor_rotor_mu_ind_h, "\t\t{%g\t,%g\t,%g\t,%g\t,%g\t,%g},\n", Mdqr[1][0], Mdqr[1][1], Mdqr[1][2], Mdqr[1][3], Mdqr[1][4], Mdqr[1][5]);
	 fprintf(fp_dq_rotor_rotor_mu_ind_h, "\t\t{%g\t,%g\t,%g\t,%g\t,%g\t,%g},\n", Mdqr[2][0], Mdqr[2][1], Mdqr[2][2], Mdqr[2][3], Mdqr[2][4], Mdqr[2][5]);
	 fprintf(fp_dq_rotor_rotor_mu_ind_h, "\t\t{%g\t,%g\t,%g\t,%g\t,%g\t,%g},\n", Mdqr[3][0], Mdqr[3][1], Mdqr[3][2], Mdqr[3][3], Mdqr[3][4], Mdqr[3][5]);
	 fprintf(fp_dq_rotor_rotor_mu_ind_h, "\t\t{%g\t,%g\t,%g\t,%g\t,%g\t,%g},\n", Mdqr[4][0], Mdqr[4][1], Mdqr[4][2], Mdqr[4][3], Mdqr[4][4], Mdqr[4][5]);
	 fprintf(fp_dq_rotor_rotor_mu_ind_h, "\t\t{%g\t,%g\t,%g\t,%g\t,%g\t,%g},\n", Mdqr[5][0], Mdqr[5][1], Mdqr[5][2], Mdqr[5][3], Mdqr[5][4], Mdqr[5][5]);
	 fprintf(fp_dq_rotor_rotor_mu_ind_h, "\t\t};\n");


	 fclose(fp_dq_rotor_rotor_mu_ind_h);

}
