#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

FILE * fp_dq_rotor_rotor_mu_ind_h;

#define PI 3.1415926535897932384626433832795

//Varifacation of Equation 3.24 on page 77 of "Roberts..."


//Invocation:
//
// gcc -g Verify_Eq_3_24_ideal.c -lm  (Ubuntu 14.04 gcc requires "-lm" after file(s) to be compiled)


//This transformation matrix was also used in test project "Section_B_7_2.c" and was generated by test project "Lemma_A_12.c"
// **** For the "ideal case, the rotor transformation is the same as the "Cs" with "theta_r == 0, See below. *****
//double Cr[6][6] = {{0.57735,  -0.28868,  -0.28868,   0.57735,  -0.28868,  -0.28868},
//                   {0.00000,   0.50000,  -0.50000,  -0.00000,   0.50000,  -0.50000},
//                   {0.40825,   0.40825,   0.40825,   0.40825,   0.40825,   0.40825},
//                   {0.00000,   0.00000,   0.70711,   0.00000,   0.00000,  -0.70711},
//                   {0.00000,   0.70711,   0.00000,   0.00000,  -0.70711,   0.00000},
//                   {0.70711,  -0.00000,   0.00000,  -0.70711,  -0.00000,   0.00000}};



//double Mrr_Cr_t[6][6] = {0};
//double Mdqr[6][6] = {0};

// *** For the "ideal" case, a 3x3 matrix. ***
double Cr[3][3] = {0};
double Mrr_Cr_t[3][3] = {0};
double Mdqr[3][3] = {0};






//#define USE_CALCULATED_MRR
#ifdef USE_CALCULATED_MRR
//This brings in our previously computed Mr (labeled here as "Mrr")
#include "../Section_B_7/Rotor_Rotor_Mutual_Inductance.h"

#else  //make all L's and M's equal to get a more accurate test result...
//***** Use the value for "Mss" selected for "App_InductionMotor.hpp"****
double Mrr[3][3] = {
								{2.71067e-05		,-9.035567e-6		,-9.035567e-6	},
								{-9.035567e-6		,2.71067e-05		,-9.035567e-6	},
								{-9.035567e-6		,-9.035567e-6		,2.71067e-05}
							};


#endif

main()
{
	int i,j,k;

			//Create include file for simulation program "App_InductionMotor.hpp" 
	fp_dq_rotor_rotor_mu_ind_h = fopen("dq_Rotor_Rotor_Mutual_Inductance_ideal.h", "w");
	fprintf(fp_dq_rotor_rotor_mu_ind_h, "\n\n\ndouble Mdqr[3][3] = {\n");


//xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
	// **** For the ideal case, the proceedure is identical to "Verify_Eq_17" and "Verify_Eq_19" with "theta_r" set to zero.****

	//***** For the "ideal" case (as simulated by "App_InductionMotor.hpp", p1 = 1 (1 pole pair).   *****

	 Cr[0][0] = sqrt(2.0 / 3.0) * cos(1.0 * 0);
	 Cr[0][1] = sqrt(2.0 / 3.0) * cos(1.0 * 0 + 2.0 * PI / 3.0);
	 Cr[0][2] = sqrt(2.0 / 3.0) * cos(1.0 * 0 + 4.0 * PI / 3.0);
	 Cr[1][0] = sqrt(2.0 / 3.0) * sin(1.0 * 0);
	 Cr[1][1] = sqrt(2.0 / 3.0) * sin(1.0 * 0 + 2.0 * PI / 3.0);
	 Cr[1][2] = sqrt(2.0 / 3.0) * sin(1.0 * 0 + 4.0 * PI / 3.0);
	 Cr[2][0] = sqrt(2.0 / 3.0) * 1.0 / sqrt(2.0);
	 Cr[2][1] = sqrt(2.0 / 3.0) * 1.0 / sqrt(2.0);
	 Cr[2][2] = sqrt(2.0 / 3.0) * 1.0 / sqrt(2.0);





	  // Cr * Mrr * (Cr)_t

	 for(i = 0; i < 3; i++)
	 {
		for(j = 0; j < 3; j++)
		{

			for(k = 0; k < 3; k++)
			{
				Mrr_Cr_t[i][j] =  Mrr_Cr_t[i][j] +  Mrr[i][k] * Cr[j][k];

			}
		}
	 }

	 for(i = 0; i < 3; i++)
	 {
		for(j = 0; j < 3; j++)
		{

			for(k = 0; k < 3; k++)
			{
				Mdqr[i][j] = Mdqr[i][j] + Cr[i][k] * Mrr_Cr_t[k][j];


			}
		  }
	   }

	 printf("\n\nMdq0s1 = \n");
	 printf("%g\t%g\t%g\n", Mdqr[0][0], Mdqr[0][1], Mdqr[0][2]);
	 printf("%g\t%g\t%g\n", Mdqr[1][0], Mdqr[1][1], Mdqr[1][2]);
	 printf("%g\t%g\t%g\n", Mdqr[2][0], Mdqr[2][1], Mdqr[2][2]);


		fprintf(fp_dq_rotor_rotor_mu_ind_h, "\t\t{%g\t,%g\t,%g},\n", Mdqr[0][0],  Mdqr[0][1],  Mdqr[0][2]);
 		fprintf(fp_dq_rotor_rotor_mu_ind_h, "\t\t{%g\t,%g\t,%g},\n", Mdqr[1][0],  Mdqr[1][1],  Mdqr[1][2]);
 		fprintf(fp_dq_rotor_rotor_mu_ind_h, "\t\t{%g\t,%g\t,%g},\n", Mdqr[2][0],  Mdqr[2][1],  Mdqr[2][2]);
 		fprintf(fp_dq_rotor_rotor_mu_ind_h, "\t\t};\n");


 		fclose(fp_dq_rotor_rotor_mu_ind_h);



	//Now show that Lemma A.16 page 243 of "Roberts..." applies to the result of Mdqr.

	//phi_0 = Sum_of_ith_col_of_row_1 of "Mrr"

	 
	 printf("phy_0 = %g\n\n", Mrr[0][0] + Mrr[0][1] + Mrr[0][2]);    //OK

	
	 //phi = (Sum_of_ith_col_of_row_1 * (cos(2*PI/3) + j*sin(2PI/3)**i of "Mrr") 

	 printf("phy_0 = %g\n\n", Mrr[0][0]*1 + Mrr[0][1]*cos(2*PI/3) + Mrr[0][2]*cos(4*PI/3)); //"j" terms cancel. //OK

//xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx




//	  //Equation 3.24..
//	  // Cr * Mr * (Cr)_t
//
//	 for(i = 0; i < 6; i++)
//	 {
//		for(j = 0; j < 6; j++)
//		{
//
//			for(k = 0; k < 6; k++)
//			{
//				Mrr_Cr_t[i][j] =  Mrr_Cr_t[i][j] +  Mrr[i][k] * Cr[j][k];
//
//			}
//		}
//	 }
//
//	 for(i = 0; i < 6; i++)
//	 {
//		for(j = 0; j < 6; j++)
//		{
//
//			for(k = 0; k < 6; k++)
//			{
//				Mdqr[i][j] = Mdqr[i][j] + Cr[i][k] * Mrr_Cr_t[k][j];
//
//
//			}
//		  }
//	   }
//
//	 printf("\n\nMdqr = \n");
//	 printf("%g\t%g\t%g\t%g\t%g\t%g\n", Mdqr[0][0], Mdqr[0][1], Mdqr[0][2], Mdqr[0][3], Mdqr[0][4], Mdqr[0][5]);
//	 printf("%g\t%g\t%g\t%g\t%g\t%g\n", Mdqr[1][0], Mdqr[1][1], Mdqr[1][2], Mdqr[1][3], Mdqr[1][4], Mdqr[1][5]);
//	 printf("%g\t%g\t%g\t%g\t%g\t%g\n", Mdqr[2][0], Mdqr[2][1], Mdqr[2][2], Mdqr[2][3], Mdqr[2][4], Mdqr[2][5]);
//	 printf("%g\t%g\t%g\t%g\t%g\t%g\n", Mdqr[3][0], Mdqr[3][1], Mdqr[3][2], Mdqr[3][3], Mdqr[3][4], Mdqr[3][5]);
//	 printf("%g\t%g\t%g\t%g\t%g\t%g\n", Mdqr[4][0], Mdqr[4][1], Mdqr[4][2], Mdqr[4][3], Mdqr[4][4], Mdqr[4][5]);
//	 printf("%g\t%g\t%g\t%g\t%g\t%g\n", Mdqr[5][0], Mdqr[5][1], Mdqr[5][2], Mdqr[5][3], Mdqr[5][4], Mdqr[5][5]);
//
//	 //The result reflects the definition for Eq 3.24 and Lemma A.16 for a symmetric matrix,
//	 //namily Ldqr1 is defined for row/column elements 0/0 and 1/1.
//	 //Row/column 2/2 is defined as L0r1.
//	 //Row/Column 3/3, 4/4, 5/5 are not zero but are defined to be "not relevent". (This  is the result of the "extended" Cr matrix).
//	 //All other elements on either side of tht diagonal are "ideally zero" (even though in our test, floating point resolution shows
//	 //some elements as small non-zero values.)
//
//	 fprintf(fp_dq_rotor_rotor_mu_ind_h, "\t\t{%g\t,%g\t,%g\t,%g\t,%g\t,%g},\n", Mdqr[0][0], Mdqr[0][1], Mdqr[0][2], Mdqr[0][3], Mdqr[0][4], Mdqr[0][5]);
//	 fprintf(fp_dq_rotor_rotor_mu_ind_h, "\t\t{%g\t,%g\t,%g\t,%g\t,%g\t,%g},\n", Mdqr[1][0], Mdqr[1][1], Mdqr[1][2], Mdqr[1][3], Mdqr[1][4], Mdqr[1][5]);
//	 fprintf(fp_dq_rotor_rotor_mu_ind_h, "\t\t{%g\t,%g\t,%g\t,%g\t,%g\t,%g},\n", Mdqr[2][0], Mdqr[2][1], Mdqr[2][2], Mdqr[2][3], Mdqr[2][4], Mdqr[2][5]);
//	 fprintf(fp_dq_rotor_rotor_mu_ind_h, "\t\t{%g\t,%g\t,%g\t,%g\t,%g\t,%g},\n", Mdqr[3][0], Mdqr[3][1], Mdqr[3][2], Mdqr[3][3], Mdqr[3][4], Mdqr[3][5]);
//	 fprintf(fp_dq_rotor_rotor_mu_ind_h, "\t\t{%g\t,%g\t,%g\t,%g\t,%g\t,%g},\n", Mdqr[4][0], Mdqr[4][1], Mdqr[4][2], Mdqr[4][3], Mdqr[4][4], Mdqr[4][5]);
//	 fprintf(fp_dq_rotor_rotor_mu_ind_h, "\t\t{%g\t,%g\t,%g\t,%g\t,%g\t,%g},\n", Mdqr[5][0], Mdqr[5][1], Mdqr[5][2], Mdqr[5][3], Mdqr[5][4], Mdqr[5][5]);
//	 fprintf(fp_dq_rotor_rotor_mu_ind_h, "\t\t};\n");
//
//
//	 fclose(fp_dq_rotor_rotor_mu_ind_h);

}
