#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

FILE * fp_dq_stator_rotor_mu_ind_h;

#define PI 3.1415926535897932384626433832795

//Varifacation of Equation 3.26 on page 79 of "Roberts..."

//**** Note: This test is similar to test project "Section_B_7_2"  *****


//Invocation:
//
// gcc -g Verify_Eq_3_26.c -lm  (Ubuntu 14.04 gcc requires "-lm" after file(s) to be compiled)


//This transformation matrix was also used in test project "Section_B_7_2.c" and was generated by test project "Lemma_A_12.c"
double Cr[6][6] = {{0.57735,  -0.28868,  -0.28868,   0.57735,  -0.28868,  -0.28868},
                   {0.00000,   0.50000,  -0.50000,  -0.00000,   0.50000,  -0.50000},
                   {0.40825,   0.40825,   0.40825,   0.40825,   0.40825,   0.40825},
                   {0.00000,   0.00000,   0.70711,   0.00000,   0.00000,  -0.70711},
                   {0.00000,   0.70711,   0.00000,   0.00000,  -0.70711,   0.00000},
                   {0.70711,  -0.00000,   0.00000,  -0.70711,  -0.00000,   0.00000}};


double Cs1[3][3] = {0};


double Msr_phy_Cr_t[3][6] = {0};
double Mdqsr1[3][6] = {0};

double theta_r;
double beta_1;

//This brings in our previously computed M1
#include "../Section_2_7_2/Stator_Rotor_Mutual_Inductance_Value_M1.h"

double Msr_[1][3][6];

double M1;

 

main()
{
	int i,j,k;
	int test_count;

		//Create include file for simulation program "App_InductionMotor.hpp" 
	fp_dq_stator_rotor_mu_ind_h = fopen("dq_Stator_Rotor_Mutual_Inductance.h", "w");
	fprintf(fp_dq_stator_rotor_mu_ind_h, "\n\n\ndouble Mdqsr[3][6] = {\n");


	 beta_1 = 0;

	 	 //Run "plot_stator_rotor_inductance.m" in Section_2_7_2 test and measure peak of "Phase A" inductance. It comes out
	    //to around  .00158. Also look at peak 'Drv-Phase A"  in this plot and test Verify_Eq_3_28. It is approximately .0033 (if you
	    //interpolate the "flatten" peak). This test and test test Verify_Eq_3_28 verify the difference in Equations 3.26 and 3.28 in
	   // of Roberts... page 79. The transformations are 90 degrees phase shifted and with Equation 3.26 having a peak of "M1" and
	   //Equation 3.28 having a peak of "M1*p1" where  "p1" = 2.
	 M1 = M1_inductance_value;

	  for(test_count = 0; test_count <= 3; test_count++)
	  {
		memset(Msr_phy_Cr_t, 0, sizeof(Msr_phy_Cr_t));
		memset(Mdqsr1, 0, sizeof(Mdqsr1));
		if(test_count == 0)
			theta_r = 0;
		else if(test_count == 1)
			theta_r = .23 *  PI;
		else if(test_count == 2)
			theta_r = .356 * PI;
		else
			theta_r = .678 * PI;


		 Cs1[0][0] = sqrt(2.0 / 3.0) * cos(2.0 * theta_r);
		 Cs1[0][1] = sqrt(2.0 / 3.0) * cos(2.0 * theta_r - 2.0 * PI / 3.0);
		 Cs1[0][2] = sqrt(2.0 / 3.0) * cos(2.0 * theta_r - 4.0 * PI / 3.0);
		 Cs1[1][0] = sqrt(2.0 / 3.0) * sin(2.0 * theta_r);
		 Cs1[1][1] = sqrt(2.0 / 3.0) * sin(2.0 * theta_r - 2.0 * PI / 3.0);
		 Cs1[1][2] = sqrt(2.0 / 3.0) * sin(2.0 * theta_r - 4.0 * PI / 3.0);
		 Cs1[2][0] = sqrt(2.0 / 3.0) * 1.0 / sqrt(2.0);
		 Cs1[2][1] = sqrt(2.0 / 3.0) * 1.0 / sqrt(2.0);
		 Cs1[2][2] = sqrt(2.0 / 3.0) * 1.0 / sqrt(2.0);

			//Note that we multiply the by 2.0 in all these terms. This reflects the value of Q = p1(2k - 1) for "n" Equation 2.53, page 63 of "Roberts..."
	         //for k = 1 (the fundimental frequency).

		Msr_[0][0][0] = M1 * cos(2.0 * (theta_r - (0.0 * 2.0 * PI / 6.0) - beta_1));
		Msr_[0][0][1] = M1 * cos(2.0 * (theta_r - (1.0 * 2.0 * PI / 6.0) - beta_1));
		Msr_[0][0][2] = M1 * cos(2.0 * (theta_r - (2.0 * 2.0 * PI / 6.0) - beta_1));
		Msr_[0][0][3] = M1 * cos(2.0 * (theta_r - (3.0 * 2.0 * PI / 6.0) - beta_1));
		Msr_[0][0][4] = M1 * cos(2.0 * (theta_r - (4.0 * 2.0 * PI / 6.0) - beta_1));
		Msr_[0][0][5] = M1 * cos(2.0 * (theta_r - (5.0 * 2.0 * PI / 6.0) - beta_1));

		Msr_[0][1][0] = M1 * cos(2.0 * (theta_r - (0.0 * 2.0 * PI / 6.0) - (2.0 * PI / 6.0) - beta_1));
		Msr_[0][1][1] = M1 * cos(2.0 * (theta_r - (1.0 * 2.0 * PI / 6.0) - (2.0 * PI / 6.0) - beta_1));
		Msr_[0][1][2] = M1 * cos(2.0 * (theta_r - (2.0 * 2.0 * PI / 6.0) - (2.0 * PI / 6.0) - beta_1));
		Msr_[0][1][3] = M1 * cos(2.0 * (theta_r - (3.0 * 2.0 * PI / 6.0) - (2.0 * PI / 6.0) - beta_1));
		Msr_[0][1][4] = M1 * cos(2.0 * (theta_r - (4.0 * 2.0 * PI / 6.0) - (2.0 * PI / 6.0) - beta_1));
		Msr_[0][1][5] = M1 * cos(2.0 * (theta_r - (5.0 * 2.0 * PI / 6.0) - (2.0 * PI / 6.0) - beta_1));

		Msr_[0][2][0] = M1 * cos(2.0 * (theta_r - (0.0 * 2.0 * PI / 6.0) - (4.0 * PI / 6.0) - beta_1));
		Msr_[0][2][1] = M1 * cos(2.0 * (theta_r - (1.0 * 2.0 * PI / 6.0) - (4.0 * PI / 6.0) - beta_1));
		Msr_[0][2][2] = M1 * cos(2.0 * (theta_r - (2.0 * 2.0 * PI / 6.0) - (4.0 * PI / 6.0) - beta_1));
		Msr_[0][2][3] = M1 * cos(2.0 * (theta_r - (3.0 * 2.0 * PI / 6.0) - (4.0 * PI / 6.0) - beta_1));
		Msr_[0][2][4] = M1 * cos(2.0 * (theta_r - (4.0 * 2.0 * PI / 6.0) - (4.0 * PI / 6.0) - beta_1));
		Msr_[0][2][5] = M1 * cos(2.0 * (theta_r - (5.0 * 2.0 * PI / 6.0) - (4.0 * PI / 6.0) - beta_1));



		  //Equation 3.26..
		  // Cs1 * Ms1r * (Cr)_t

		 for(i = 0; i < 3; i++)
		 {
			for(j = 0; j < 6; j++)
			{

				for(k = 0; k < 6; k++)
				{
					Msr_phy_Cr_t[i][j] =  Msr_phy_Cr_t[i][j] +  Msr_[0][i][k] * Cr[j][k];

				}
			}
		 }

		 for(i = 0; i < 3; i++)
		 {
			for(j = 0; j < 6; j++)
			{

				for(k = 0; k < 3; k++)
				{
					Mdqsr1[i][j] = Mdqsr1[i][j] + Cs1[i][k] * Msr_phy_Cr_t[k][j];


				}
			  }
		   }
	
		 printf("\n\nMdqsr1= \n");
		 printf("%g\t%g\t%g\t%g\t%g\t%g\n", Mdqsr1[0][0], Mdqsr1[0][1], Mdqsr1[0][2], Mdqsr1[0][3], Mdqsr1[0][4], Mdqsr1[0][5]);
		 printf("%g\t%g\t%g\t%g\t%g\t%g\n", Mdqsr1[1][0], Mdqsr1[1][1], Mdqsr1[1][2], Mdqsr1[1][3], Mdqsr1[1][4], Mdqsr1[1][5]);
		 printf("%g\t%g\t%g\t%g\t%g\t%g\n", Mdqsr1[2][0], Mdqsr1[2][1], Mdqsr1[2][2], Mdqsr1[2][3], Mdqsr1[2][4], Mdqsr1[2][5]);

		 if(test_count == 0)
		 {

		   fprintf(fp_dq_stator_rotor_mu_ind_h, "\t\t{%g\t,%g\t,%g\t,%g\t,%g\t,%g},\n", Mdqsr1[0][0], Mdqsr1[0][1], Mdqsr1[0][2], Mdqsr1[0][3], Mdqsr1[0][4], Mdqsr1[0][5]);
		   fprintf(fp_dq_stator_rotor_mu_ind_h, "\t\t{%g\t,%g\t,%g\t,%g\t,%g\t,%g},\n", Mdqsr1[1][0], Mdqsr1[1][1], Mdqsr1[1][2], Mdqsr1[1][3], Mdqsr1[1][4], Mdqsr1[1][5]);
		   fprintf(fp_dq_stator_rotor_mu_ind_h, "\t\t{%g\t,%g\t,%g\t,%g\t,%g\t,%g},\n", Mdqsr1[2][0], Mdqsr1[2][1], Mdqsr1[2][2], Mdqsr1[2][3], Mdqsr1[2][4], Mdqsr1[2][5]);
		   fprintf(fp_dq_stator_rotor_mu_ind_h, "\t\t};\n");


	 	   fclose(fp_dq_stator_rotor_mu_ind_h);

		 }

    }

}
