
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>


#define PI 3.1415926535897932384626433832795


// **********************************************************************************************
//		This file is based on file  "../Section_2_7_2/Section_2_7_2_ideal.c"
//      and is an improved version of "Verify_Eq_3_26.c"
//
// **********************************************************************************************




// Parameters for 4 pole calculation of the Stator and rotor (from Section_B_2.c and Section_B_7.c)
// The "k" will be the stator, the "j" subscript will be  the rotor.


#define w  .1955        //(this "w" was from the stator. We will use it for both stator and rotor)
#define d  .175065      //(this "d" was from the stator. We will use it for both stator and rotor)
#define Nk  30.0				//NOTE: Was "10". Increased to get a peak "stator-rotor" mutual inductions close to the original value produced by "Section_2_7_2.c"
#define Nj  1.0                  //           which reflects the value in "Roberts..." Section B.7.2. page 269
#define g  .000555              //(this "g" was from the stator. We will use it for both stator and rotor)
#define u0  (4.0*PI*1.0e-7)   //Permeability of vacuum.

#define Ack  (PI)   //2 pole pairs per phase
#define Wsk  (2.0*PI*.03/(2.0*PI*d/2.0))   //(make this larger)


// Here we will modifiy the "j" subscripts for Ac and Ws to be used for the rotor.
    
#define Acj   (PI) 			//(save as "k" above)
#define Wsj    (2.0*PI*.03/(2.0*PI*d/2.0))
 



#define slot_pitch (2.0*PI/3.0)  //degrees center-to-center of two consecutive slots for the stator.
 




double Bk;    	   	  //This changes depending on which row of the stator mutual inductance matrix is being calculated.
double Bj;		       //This becomes the variable for computing each matrix element of the rotor for a given stator element.



        
 
double Theta;
#define dTheta (2.0*PI/360.0)      //One degree integration.

double integral_cos_cos = 0;
double d_integral_cos_cos = 0;


//double Msr_t_bar[3][3] = {0};
double Msr_t_bar_t[3][3] = {0};



FILE * fp_dq_stator_rotor_mu_ind_dat;

FILE * fp_dq_stator_rotor_mu_ind_h;




double Cs1[3][3] = {0};
double Cr[3][3] = {0};


//double Msr_phy_Cr_t[3][6] = {0};
double Msr_t_phy_Cs1_t[3][6] = {0};
//double Mdqsr1[3][6] = {0};
double Mdqsr1_t[3][6] = {0};






//Invocation:
//
// gcc -g Verify_Eq_3_26_ideal_transpose.c -lm



main()
{
	int n,i,j,k;
	double RotorTheta;





	 Cr[0][0] = sqrt(2.0 / 3.0) * cos(1.0 * 0);
	 Cr[0][1] = sqrt(2.0 / 3.0) * cos(1.0 * 0 + 2.0 * PI / 3.0);
	 Cr[0][2] = sqrt(2.0 / 3.0) * cos(1.0 * 0 + 4.0 * PI / 3.0);
	 Cr[1][0] = sqrt(2.0 / 3.0) * sin(1.0 * 0);
	 Cr[1][1] = sqrt(2.0 / 3.0) * sin(1.0 * 0 + 2.0 * PI / 3.0);
	 Cr[1][2] = sqrt(2.0 / 3.0) * sin(1.0 * 0 + 4.0 * PI / 3.0);
	 Cr[2][0] = sqrt(2.0 / 3.0) * 1.0 / sqrt(2.0);
	 Cr[2][1] = sqrt(2.0 / 3.0) * 1.0 / sqrt(2.0);
	 Cr[2][2] = sqrt(2.0 / 3.0) * 1.0 / sqrt(2.0);







	printf("\n\n\n");


 

	fp_dq_stator_rotor_mu_ind_dat = fopen("dq_Stator_Rotor_Mutual_Inductance_ideal_transpose.dat", "w");

	//Create include file for simulation program "App_InductionMotor.hpp" 
	fp_dq_stator_rotor_mu_ind_h = fopen("dq_Stator_Rotor_Mutual_Inductance_ideal_transpose.h", "w");
	fprintf(fp_dq_stator_rotor_mu_ind_h, "\n\n\ndouble Mdqsr_t[3][3] = {\n");


	for(RotorTheta = 0; RotorTheta < (2.0*PI - dTheta); RotorTheta = RotorTheta + dTheta)            
	{

 
		memset(Msr_t_bar_t, 0, sizeof(Msr_t_bar_t));


 


		memset(Msr_t_phy_Cs1_t, 0, sizeof(Msr_t_phy_Cs1_t));
		memset(Mdqsr1_t, 0, sizeof(Mdqsr1_t));


		 Cs1[0][0] = sqrt(2.0 / 3.0) * cos(1.0 * RotorTheta);
		 Cs1[0][1] = sqrt(2.0 / 3.0) * cos(1.0 * RotorTheta + 2.0 * PI / 3.0);
		 Cs1[0][2] = sqrt(2.0 / 3.0) * cos(1.0 * RotorTheta + 4.0 * PI / 3.0);
		 Cs1[1][0] = sqrt(2.0 / 3.0) * sin(1.0 * RotorTheta);
		 Cs1[1][1] = sqrt(2.0 / 3.0) * sin(1.0 * RotorTheta + 2.0 * PI / 3.0);
		 Cs1[1][2] = sqrt(2.0 / 3.0) * sin(1.0 * RotorTheta + 4.0 * PI / 3.0);
		 Cs1[2][0] = sqrt(2.0 / 3.0) * 1.0 / sqrt(2.0);
		 Cs1[2][1] = sqrt(2.0 / 3.0) * 1.0 / sqrt(2.0);
		 Cs1[2][2] = sqrt(2.0 / 3.0) * 1.0 / sqrt(2.0);



		for(i = 0; i < 3; i++)
		{
			Bk = (double) i * slot_pitch;


			for(k = 0; k < 3; k++)
			{ 

				 
			   Bj = 2.0*PI*(double) k /3.0;


			   Bj = Bj + RotorTheta;
			//	Bj = RotorTheta;


			   	   // **** Here we calculate using the fundimental frequency ****
			   for(n = 1; n < 2; n++)
			   {
			  
			     for(Theta = 0; Theta < 2.0*PI; Theta = Theta + dTheta)
			     {
				    integral_cos_cos = integral_cos_cos + cos((double) n * (Theta - Bk - Ack/2.0 - Wsk/2.0)) * cos((double) n * (Theta - Bj - Acj/2.0 - Wsj/2.0)) * dTheta;
			     }
		     
			//     Msr_t_bar[k][i] = Msr_t_bar[k][i] + ((w*d*2.0*Nk*u0*2.0*Nj)/(2.0*PI*g*PI))*sin((double) n * Ack/2.0) * sin((double) n * Wsk/2.0) * sin((double) n * Acj/2.0) *
			//			sin((double) n * Wsj/2.0) * integral_cos_cos /
			//					  (((double) n * (double) n * Wsk/2.0) * ((double) n * (double) n * Wsj/2.0));

	    			 Msr_t_bar_t[i][k] = Msr_t_bar_t[i][k] + ((w*d*2.0*Nk*u0*2.0*Nj)/(2.0*PI*g*PI))*sin((double) n * Ack/2.0) * sin((double) n * Wsk/2.0) * sin((double) n * Acj/2.0) *
						sin((double) n * Wsj/2.0) * integral_cos_cos /
								  (((double) n * (double) n * Wsk/2.0) * ((double) n * (double) n * Wsj/2.0));



				integral_cos_cos = 0;


		 	   }	

 

	 			

			}

		}



 

		  //Equation 3.26.. (transposed)
		  // Cr * Ms1r_t * (Cs1)_t

		 for(i = 0; i < 3; i++)
		 {
			for(j = 0; j < 3; j++)
			{

				for(k = 0; k < 3; k++)
				{
					//Msr_phy_Cr_t[i][j] =  Msr_phy_Cr_t[i][j] +  Msr_t_bar[i][k] * Cr[j][k];
					Msr_t_phy_Cs1_t[i][j] =  Msr_t_phy_Cs1_t[i][j] +  Msr_t_bar_t[i][k] * Cs1[j][k];

				}
			}
		 }

		 for(i = 0; i < 3; i++)
		 {
			for(j = 0; j < 3; j++)
			{

				for(k = 0; k < 3; k++)
				{
					// Mdqsr1[i][j] = Mdqsr1[i][j] + Cs1[i][k] * Msr_phy_Cr_t[k][j];
					Mdqsr1_t[i][j] = Mdqsr1_t[i][j] + Cr[i][k] * Msr_t_phy_Cs1_t[k][j];




				}
			  }
		   }

				//(replaced Mdqsr1 with Mdqsr1_t below)

		 fprintf(fp_dq_stator_rotor_mu_ind_dat, "\t\t%g\t,%g\t,%g\n", Mdqsr1_t[0][0], Mdqsr1_t[0][1], Mdqsr1_t[0][2]);
		 fprintf(fp_dq_stator_rotor_mu_ind_dat, "\t\t%g\t,%g\t,%g\n", Mdqsr1_t[1][0], Mdqsr1_t[1][1], Mdqsr1_t[1][2]);
		 fprintf(fp_dq_stator_rotor_mu_ind_dat, "\t\t%g\t,%g\t,%g\n\n\n", Mdqsr1_t[2][0], Mdqsr1_t[2][1], Mdqsr1_t[2][2]);

		 if(RotorTheta == 0)
		 {

			 printf("\n\nMdqsr1_t= \n");
			 printf("%g\t%g\t%g\n", Mdqsr1_t[0][0], Mdqsr1_t[0][1], Mdqsr1_t[0][2]);
			 printf("%g\t%g\t%g\n", Mdqsr1_t[1][0], Mdqsr1_t[1][1], Mdqsr1_t[1][2]);
			 printf("%g\t%g\t%g\n", Mdqsr1_t[2][0], Mdqsr1_t[2][1], Mdqsr1_t[2][2]);


		   fprintf(fp_dq_stator_rotor_mu_ind_h, "\t\t{%g\t,%g\t,%g\t},\n", Mdqsr1_t[0][0], Mdqsr1_t[0][1], Mdqsr1_t[0][2]);
		   fprintf(fp_dq_stator_rotor_mu_ind_h, "\t\t{%g\t,%g\t,%g\t},\n", Mdqsr1_t[1][0], Mdqsr1_t[1][1], Mdqsr1_t[1][2]);
		   fprintf(fp_dq_stator_rotor_mu_ind_h, "\t\t{%g\t,%g\t,%g\t},\n", Mdqsr1_t[2][0], Mdqsr1_t[2][1], Mdqsr1_t[2][2]);
		   fprintf(fp_dq_stator_rotor_mu_ind_h, "\t\t};\n");


	 	   fclose(fp_dq_stator_rotor_mu_ind_h);

		 }






		printf("%g degrees\n",  (360.0 * RotorTheta / (2.0*PI)));

   
		
	} 
 

	fclose(fp_dq_stator_rotor_mu_ind_dat);
 


 

}
