#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

FILE * fp_sdq_stator_resistance_h;
FILE * fp_sdq_rotor_resistance_h;

#define PI 3.1415926535897932384626433832795

//Varifacation of Equation 7.7 on page 179 of "Roberts..."


//Invocation:
//
// gcc -g Verify_Eq_7_7_for_Rsyncr_and_Rsync0s.c -lm  (Ubuntu 14.04 gcc requires "-lm" after file(s) to be compiled)

// Using Eq. 7.3 on page 177 with Eq. 7.4 on page 178 and the definition for Rdq in Eq. 3.35 on page 83,
// we break up his definition for Rsync into a seperate stator and rotor definition because we intend to expand the motor equation
// like we did for the  physical and D/Q definitions.
//
double Rsync0s[3][3] = {0};
double Rsyncr[3][3] = {0};

double Tsync_phi[3][3] = {0};




//Use the variable names for rotor position and stator electrical frequency we use in "App_InductionMotor.hpp".
double theta_r;
double thetad;

double phi;

// 			"../BDFM-Dissertation-2005-Tests/Verify_Rr_dq_on_page_80/Verify_Rr_dq_on_page_80_ideal.h"

double Rdqr[3][3] =  {
									{0.000125				,0						,0			},
									{0							,0.000125			,0			},
									{0							,0						,5e-05	},
								};

// 			"../BDFM-Dissertation-2005-Tests/Verify_Rs_dq_on_page_80/Verify_Rr_dq_on_page_80_ideal.h"


double Rdq0s[3][3] = {
									{2.72855				,0						,0				},
									{0							,2.72855			,0				},
									{0							,0						,2.72855	},
								};

double Rdqr_Tsync_phi_t[3][3] = {0};

main()
{
	int i,j,k;
	int test_count_0;
	int test_count_1;

			//Create include file for simulation program "App_InductionMotor.hpp"
	fp_sdq_stator_resistance_h = fopen("sdq_Stator_Resistance.h", "w");
	fprintf(fp_sdq_stator_resistance_h, "\n\n\ndouble Rsync0s[3][3] = {\n");

		//Create include file for simulation program "App_InductionMotor.hpp"
	fp_sdq_rotor_resistance_h = fopen("sdq_Rotor_Resistance.h", "w");
	fprintf(fp_sdq_rotor_resistance_h, "\n\n\ndouble Rsyncr[3][3] = {\n");





		//Test only Rdqr, Rdq0s is similar.

	phi = .12 * PI;

	  for(test_count_0 = 0; test_count_0 <= 3; test_count_0++)
	  {

		if(test_count_0 == 0)
			theta_r = 0;
		else if(test_count_0 == 1)
			theta_r = .23 *  PI;
		else if(test_count_0 == 2)
			theta_r = .356 * PI;
		else
			theta_r = .678 * PI;

		  for(test_count_1 = 0; test_count_1 <= 3; test_count_1++)
		  {
				memset(Rdqr_Tsync_phi_t, 0, sizeof(Rdqr_Tsync_phi_t));
				memset(Rsyncr, 0, sizeof(Rsyncr));
				if(test_count_1 == 0)
					thetad = 0;
				else if(test_count_1 == 1)
					thetad = .23 *  PI;
				else if(test_count_1 == 2)
					thetad = .356 * PI;
				else
					thetad = .678 * PI;

				//From Eq 7.3 page 177 of "Roberts...

				Tsync_phi[0][0] = cos(1.0* theta_r - thetad + phi);
				Tsync_phi[0][1] = sin(1.0* theta_r - thetad + phi);
				Tsync_phi[1][0] = -sin(1.0* theta_r - thetad + phi);
				Tsync_phi[1][1] = cos(1.0* theta_r - thetad + phi);
				Tsync_phi[2][2] = 1.0;



				//Eq. 7.7 verified as  described in Section 7.2.2 page 180 of "Roberts..."
				//   Tsync_phi * Rdqr * (Tsync_phi)_t     ((Tsync_phi)_t same as (Tsync_phi)-1  because it is orthogonal)

				 for(i = 0; i < 3; i++)
				 {
					for(j = 0; j < 3; j++)
					{

						for(k = 0; k < 3; k++)
						{
							Rdqr_Tsync_phi_t[i][j] =  Rdqr_Tsync_phi_t[i][j] +  Rdqr[i][k] * Tsync_phi[j][k];

						}
					}
				 }

				 for(i = 0; i < 3; i++)
				 {
					for(j = 0; j < 3; j++)
					{

						for(k = 0; k < 3; k++)
						{
							Rsyncr[i][j] = Rsyncr[i][j] + Tsync_phi[i][k] * Rdqr_Tsync_phi_t[k][j];


						}
					  }
				   }

				 printf("\n\nRsyncr= \n");
				 printf("%g\t%g\t%g\n", Rsyncr[0][0], Rsyncr[0][1], Rsyncr[0][2]);
				 printf("%g\t%g\t%g\n", Rsyncr[1][0], Rsyncr[1][1], Rsyncr[1][2]);
				 printf("%g\t%g\t%g\n", Rsyncr[2][0], Rsyncr[2][1], Rsyncr[2][2]);

				if((test_count_0 == 0) && (test_count_1 == 0))
				{
					fprintf(fp_sdq_rotor_resistance_h, "\t\t{%g\t,%g\t,%g},\n", Rsyncr[0][0],  Rsyncr[0][1],  Rsyncr[0][2]);
			 		fprintf(fp_sdq_rotor_resistance_h, "\t\t{%g\t,%g\t,%g},\n", Rsyncr[1][0],  Rsyncr[1][1],  Rsyncr[1][2]);
			 		fprintf(fp_sdq_rotor_resistance_h, "\t\t{%g\t,%g\t,%g},\n", Rsyncr[2][0],  Rsyncr[2][1],  Rsyncr[2][2]);
			 		fprintf(fp_sdq_rotor_resistance_h, "\t\t};\n");


			 		fclose(fp_sdq_rotor_resistance_h);
				}

		  }
	  }

	  //Just copy Rdq0s to Rsync0s because we just verified that the transformation does not effect the elements of the original matriix.

		fprintf(fp_sdq_stator_resistance_h, "\t\t{%g\t,%g\t,%g},\n", Rdq0s[0][0],  Rdq0s[0][1],  Rdq0s[0][2]);
		fprintf(fp_sdq_stator_resistance_h, "\t\t{%g\t,%g\t,%g},\n", Rdq0s[1][0],  Rdq0s[1][1],  Rdq0s[1][2]);
		fprintf(fp_sdq_stator_resistance_h, "\t\t{%g\t,%g\t,%g},\n", Rdq0s[2][0],  Rdq0s[2][1],  Rdq0s[2][2]);
		fprintf(fp_sdq_stator_resistance_h, "\t\t};\n");


		fclose(fp_sdq_stator_resistance_h);

}


