#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

FILE * fp_sdq_d_stator_rotor_mu_ind_test_h;


#define PI 3.1415926535897932384626433832795

//Varifacation of the transformation of the D/Q element Mdqsr contained in Equation 7.8 on page 179 of "Roberts..."

//****  Here we just verify that we can use the transpose of Qsyncdsr in place of a seperate calculation  for  Tsync * Mdqsr_t  * dTsync ****
//       The result of this should equal "Qsyncdsr"

//Invocation:
//
// gcc -g Verify_Eq_7_8_for_Qsyncdsr.c -lm  (Ubuntu 14.04 gcc requires "-lm" after file(s) to be compiled)

// Using Eq. 7.3 on page 177 with Eq. 7.4 on page 178 and the definition for Mdq in Eq. 3.35 on page 83,
// we break up this definition for Qsync into a seperate elements because we intend to expand the motor equation
// like we did for the  physical and D/Q definitions.
//
double Qsyncdsr_t[3][3] = {0};


double Tsync_phi[3][3] = {0};

double dTsync_phi_less_omegad_omega_r_terms[3][3] = {0};


//Use the variable names for rotor position and stator electrical frequency we use in "App_InductionMotor.hpp".
double theta_r;
double thetad;

double phi;


  //**** At this point the test is obviously true because the "transpose of Mdqsr" = Mdqsr by definition. ****
  //(See also "../BDFM-Dissertation-2005-Tests/Verify_Eq_3_26_transpose/dq_Stator_Rotor_Mutual_Inductance_ideal_transpose.h"  )
//			There is one more important observation here. The form of the transformation done in Eq. 3.6 of page 76 is different then that done in Eq. 7.5 page 179.
//          If we assume "phi" is zero for the Eq. 7.4, then all the elements on the diagonal are the same. If we ultimately want to use "phi" in the control, then
//			Is the statement  "Qsyncdsr_t" the same as 'Qsyncdsr" true. It still maybe true. We have to work it out in long-hand.  Again this is observable by viewing Eq. 3.6 of page 76.
double Mdqsr_t[3][3] = {
									{0.002204475			,0						,0	},
									{0							,0.002204475		,0	},
									{0							,0						,0	},
								 };



double Mdqsr_t_dTsync_phi_less_omegad_omega_r_terms_t[3][3] = {0};

main()
{
	int i,j,k;
	int test_count_0;
	int test_count_1;

			//Create include file for simulation program "App_InductionMotor.hpp"
	fp_sdq_d_stator_rotor_mu_ind_test_h = fopen("sdq_d_Stator_Rotor_Mutual_Inductance_Test.h", "w");
	fprintf(fp_sdq_d_stator_rotor_mu_ind_test_h, "\n\n\ndouble Qsyncdsr_t[3][3] = {\n");







	//"phi" is always zero because we are analizing a matrix that has a rotor component (see Eq. 7.4 of "Roberts...)

	phi = 0;

	  for(test_count_0 = 0; test_count_0 <= 3; test_count_0++)
	  {

		if(test_count_0 == 0)
			theta_r = 0;
		else if(test_count_0 == 1)
			theta_r = .23 *  PI;
		else if(test_count_0 == 2)
			theta_r = .356 * PI;
		else
			theta_r = .678 * PI;

		  for(test_count_1 = 0; test_count_1 <= 3; test_count_1++)
		  {
				memset(Mdqsr_t_dTsync_phi_less_omegad_omega_r_terms_t, 0, sizeof(Mdqsr_t_dTsync_phi_less_omegad_omega_r_terms_t));
				memset(Qsyncdsr_t, 0, sizeof(Qsyncdsr_t));
				if(test_count_1 == 0)
					thetad = 0;
				else if(test_count_1 == 1)
					thetad = .23 *  PI;
				else if(test_count_1 == 2)
					thetad = .356 * PI;
				else
					thetad = .678 * PI;

				//From Eq 7.3 page 177 of "Roberts..."

				Tsync_phi[0][0] = cos(1.0* theta_r - thetad + phi);
				Tsync_phi[0][1] = sin(1.0* theta_r - thetad + phi);
				Tsync_phi[1][0] = -sin(1.0* theta_r - thetad + phi);
				Tsync_phi[1][1] = cos(1.0* theta_r - thetad + phi);
				Tsync_phi[2][2] = 1.0;

				//Form page 181 of "Roberts..." (Careful! This is not the tranposed (inverted) form on this page becase we perform the transpose below).
				//It is the derivative of Eq. 7.3 on page 177.

				dTsync_phi_less_omegad_omega_r_terms[0][0] = -sin(1.0* theta_r - thetad + phi);
				dTsync_phi_less_omegad_omega_r_terms[0][1] = cos(1.0* theta_r - thetad + phi);
				dTsync_phi_less_omegad_omega_r_terms[1][0] = -cos(1.0* theta_r - thetad + phi);
				dTsync_phi_less_omegad_omega_r_terms[1][1] = -sin(1.0* theta_r - thetad + phi);


				//   Tsync_phi * Mdqsr * (dTsync_phi_less_omegad_omega_r_terms)_t
							//((dTsync_phi_less_omegad_omega_r_terms)_t same as (dTsync_phi_less_omegad_omega_r_terms)-1  because it is orthogonal)

				 for(i = 0; i < 3; i++)
				 {
					for(j = 0; j < 3; j++)
					{

						for(k = 0; k < 3; k++)
						{
							Mdqsr_t_dTsync_phi_less_omegad_omega_r_terms_t[i][j] =  Mdqsr_t_dTsync_phi_less_omegad_omega_r_terms_t[i][j] +
																		Mdqsr_t[i][k] * dTsync_phi_less_omegad_omega_r_terms[j][k];

						}
					}
				 }

				 for(i = 0; i < 3; i++)
				 {
					for(j = 0; j < 3; j++)
					{

						for(k = 0; k < 3; k++)
						{
							Qsyncdsr_t[i][j] = Qsyncdsr_t[i][j] + Tsync_phi[i][k] * Mdqsr_t_dTsync_phi_less_omegad_omega_r_terms_t[k][j];


						}
					  }
				   }

				 printf("\n\nQsyncdsr_t= \n");
				 printf("%g\t%g\t%g\n", Qsyncdsr_t[0][0], Qsyncdsr_t[0][1], Qsyncdsr_t[0][2]);
				 printf("%g\t%g\t%g\n", Qsyncdsr_t[1][0], Qsyncdsr_t[1][1], Qsyncdsr_t[1][2]);
				 printf("%g\t%g\t%g\n", Qsyncdsr_t[2][0], Qsyncdsr_t[2][1], Qsyncdsr_t[2][2]);
				 printf("The test is true. Tsync * Mdqsr_t  * dTsync == Qsyncdsr_t == Qsyncdsr == (transpose_of_Qsyncdsr)\n");

				if((test_count_0 == 0) && (test_count_1 == 0))
				{
					fprintf(fp_sdq_d_stator_rotor_mu_ind_test_h, "\t\t{%g\t,%g\t,%g},\n", Qsyncdsr_t[0][0],  Qsyncdsr_t[0][1],  Qsyncdsr_t[0][2]);
			 		fprintf(fp_sdq_d_stator_rotor_mu_ind_test_h, "\t\t{%g\t,%g\t,%g},\n", Qsyncdsr_t[1][0],  Qsyncdsr_t[1][1],  Qsyncdsr_t[1][2]);
			 		fprintf(fp_sdq_d_stator_rotor_mu_ind_test_h, "\t\t{%g\t,%g\t,%g},\n", Qsyncdsr_t[2][0],  Qsyncdsr_t[2][1],  Qsyncdsr_t[2][2]);
			 		fprintf(fp_sdq_d_stator_rotor_mu_ind_test_h, "\t\t};\n");
			 		fprintf(fp_sdq_d_stator_rotor_mu_ind_test_h, "The test is true. Tsync * Mdqsr_t  * dTsync == Qsyncdsr_t == Qsyncdsr == (transpose_of_Qsyncdsr)\n");

			 		fclose(fp_sdq_d_stator_rotor_mu_ind_test_h);
				}

		  }
	  }



}


