# Only the matrix M in Eq. 2.59 page 66 is invertable. Ms1, Ms2 and M are diangonol with all
# elements on the diagonal having a non-zero value.

# However Mdq in Eq. 3.32, 3.33 and 3.34 because the third element on the diagonol of Mdq0s1  and Mdq0s2 
# is zero. There is a misrepresentation in Eq. 3.31 when it describes reording Mdqr such that all the
# zero sequence terms are placed at the end of the diagonal and then iqnored due to the fact that they
# do not inflence the d/q part of the equation. I think Eq. 3.31 is in error in that it must also 
# rearrange the zero sequence components in Mdq0s1 and Mdq0s2 as well. By not doing this, no
# "clasical" inversion is possible. However, it can be shown below that the pseudo inverse can
# be performed (see "https://en.wikipedia.org/wiki/Moore%E2%80%93Penrose_pseudoinverse") can be
# performed on "Msync" without regard to existance of the zero sequence terms for the stator and rotor.

# When going to the Msync reference plane, the same holds as it does for the Mdq.


#
# Msync as we define it as used in Eq. 19 of App_InductionMotor.hpp
# 
#  | Msync0s    Msyncsr |
#  | Msyncsr_t  Msyncr  |
#
#

format long 


Msync0s = [0.41813 0  0 ; 0 0.41813 0 ; 0 0 0 ];
Msyncsr = [0.00220448 0 0 ; 0 0.00220448 0 ; 0 0 0 ];
Msyncsr_t = [0.00220448 0 0 ; 0 0.00220448 0 ; 0 0 0 ];
Msyncr = [3.61423e-5 0 0 ; 0 3.61423e-5 0 ; 0 0 9.03557e-6];

Msync = [Msync0s Msyncsr ; Msyncsr_t Msyncr]

# We reduce Msync above to Msync_r and drop ALL the zero (stator and rotor).
# We can do this because "is_sdq_z" and "ir_sdq_z" in Eq. 22 and Eq. 25 of
# App_InductionMotor.hpp do not couple to any other of the equations (Eq. 20,Eq. 21
# Eq. 23, Eq. 24 and Eq. 27 of App_InductanceMotor.hpp). In addition, if we assume
# a balanced system (for control purposes, this is a valid assumption) "is_sdq_z"
# and "ir_sdq_z" are zero.

# The new definitions are (super-script "r"):

Msync0s_r = [0.41813 0 ; 0 0.41813 ];
Msyncsr_r = [0.00220448 0 ; 0 0.00220448 ];
Msyncsr_t_r = [0.00220448 0 ; 0 0.00220448 ];
Msyncr_r = [3.61423e-5 0 ; 0 3.61423e-5 ];

Msync_r = [Msync0s_r Msyncsr_r ; Msyncsr_t_r Msyncr_r]

Msync_ir = inv(Msync_r)    

Identity = Msync_r * Msync_ir

 

# Verify  Blockwise inversion as described by "https://en.wikipedia.org/wiki/Block_matrix"
# and Lemma A.5 on page 234 of "Roberts...". We use the super-script notation "i" as defined by
# "Roberts..." in Eq 3.52 on page 87. These will now be designated with the super-script "ir".

Msync_delta = Msyncr_r - Msyncsr_t_r*inv(Msync0s_r)*Msyncsr_r;

Msync0s_ir = inv(Msync0s_r) + inv(Msync0s_r)*Msyncsr_r*inv(Msync_delta)*Msyncsr_t_r*inv(Msync0s_r)
Msyncsr_ir = - inv(Msync0s_r)*Msyncsr_r*inv(Msync_delta)
Msyncsr_t_ir = - inv(Msync_delta)*Msyncsr_t_r*inv(Msync0s_r)
Msyncr_ir = inv(Msync_delta)

#Finally, we can take the pseudo inverse of Msync and still see the components of "Msync0s_ir",
#"Msyncsr_ir", "Msyncsr_t_ir" and "Msyncr_ir"

Msync_pi = pinv(Msync)


 

 



