#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

FILE * fp_dq_rotor_res_h;

#define PI 3.1415926535897932384626433832795

//There is no verification in "Roberts..." for this transformation. Refer to page 80 of "Roberts...".


//Invocation:
//
// gcc -g Verify_Rr_dq_on_page_80_ideal.c -lm  (Ubuntu 14.04 gcc requires "-lm" after file(s) to be compiled)


////This transformation matrix was also used in test project "Section_B_7_2.c" and was generated by test project "Lemma_A_12.c"
//double Cr[6][6] = {{0.57735,  -0.28868,  -0.28868,   0.57735,  -0.28868,  -0.28868},
//                   {0.00000,   0.50000,  -0.50000,  -0.00000,   0.50000,  -0.50000},
//                   {0.40825,   0.40825,   0.40825,   0.40825,   0.40825,   0.40825},
//                   {0.00000,   0.00000,   0.70711,   0.00000,   0.00000,  -0.70711},
//                   {0.00000,   0.70711,   0.00000,   0.00000,  -0.70711,   0.00000},
//                   {0.70711,  -0.00000,   0.00000,  -0.70711,  -0.00000,   0.00000}};



//double Rr_res_Cr_t[6][6] = {0};
//double Rrdq0[6][6] = {0};

double Cr[3][3] = {0};
double Rr_res_Cr_t[3][3] = {0};
double Rrdq0[3][3] = {0};


//#include "../../InductionMotor/Rotor_Resistance.h"
// Must use the current value of Rr_res[3][3] in "App_InductionMotor.hpp"

#define Rr_matrix_loop  (.0001)
#define Rr_matrix_bar  (-.000025)


double Rr_res[3][3] = {
							{Rr_matrix_loop,    Rr_matrix_bar,    	Rr_matrix_bar },
							{Rr_matrix_bar,     	Rr_matrix_loop,   	Rr_matrix_bar },
							{Rr_matrix_bar,      Rr_matrix_bar,   	Rr_matrix_loop }
					  };


 
main()
{
	int i,j,k;

			//Create include file for simulation program "App_InductionMotor.hpp" 
	fp_dq_rotor_res_h = fopen("dq_Rotor_Resistance_ideal.h", "w");
	fprintf(fp_dq_rotor_res_h, "\n\n\ndouble Rdqr[3][3] = {\n");

	 Cr[0][0] = sqrt(2.0 / 3.0) * cos(1.0 * 0);
	 Cr[0][1] = sqrt(2.0 / 3.0) * cos(1.0 * 0 + 2.0 * PI / 3.0);
	 Cr[0][2] = sqrt(2.0 / 3.0) * cos(1.0 * 0 + 4.0 * PI / 3.0);
	 Cr[1][0] = sqrt(2.0 / 3.0) * sin(1.0 * 0);
	 Cr[1][1] = sqrt(2.0 / 3.0) * sin(1.0 * 0 + 2.0 * PI / 3.0);
	 Cr[1][2] = sqrt(2.0 / 3.0) * sin(1.0 * 0 + 4.0 * PI / 3.0);
	 Cr[2][0] = sqrt(2.0 / 3.0) * 1.0 / sqrt(2.0);
	 Cr[2][1] = sqrt(2.0 / 3.0) * 1.0 / sqrt(2.0);
	 Cr[2][2] = sqrt(2.0 / 3.0) * 1.0 / sqrt(2.0);




	  //Equation 3.15 and information on page 80 of "Roberts..."
	  // Cr * Rr * (Cr)_t



	 for(i = 0; i < 3; i++)
	 {
		for(j = 0; j < 3; j++)
		{

			for(k = 0; k < 3; k++)
			{
				Rr_res_Cr_t[i][j] =  Rr_res_Cr_t[i][j] +  Rr_res[i][k] * Cr[j][k];

			}
		}
	 }

	 for(i = 0; i < 3; i++)
	 {
		for(j = 0; j < 3; j++)
		{

			for(k = 0; k < 3; k++)
			{
				Rrdq0[i][j] = Rrdq0[i][j] + Cr[i][k] * Rr_res_Cr_t[k][j];


			}
		  }
	   }




	 printf("\n\nRdqr = \n");
	 printf("%g\t%g\t%g\n", Rrdq0[0][0], Rrdq0[0][1], Rrdq0[0][2]);
	 printf("%g\t%g\t%g\n", Rrdq0[1][0], Rrdq0[1][1], Rrdq0[1][2]);
	 printf("%g\t%g\t%g\n", Rrdq0[2][0], Rrdq0[2][1], Rrdq0[2][2]);

	 	 //NOTE: As Lemma A.16 on page 243 of "Roberts.." points out "Rrdq0[2][2]" is equal to
	     // "Rr_matrix_loop  - Rr_matrix_bar - Rr_matrix_bar" defined above, or "5e-0"

	 	 //Rrdq0[0][0] and Rrdq0[1][1] = "Rr_matrix_loop*1  - Rr_matrix_bar*(cos(2*PI/3 - jsin(2*PI/3) - Rr_matrix_bar*(cos(4*PI/3 - jsin(4*PI/3) "
	    //
	    // "-jsin()" terms cancel. So "Rr_matrix_loop*1 - Rr_matrix_bar*(-.5) - Rr_matrix_bar*(-.5) or ".000125"

//	 //The result reflects the definition for Eq 3.24 and Lemma A.16 for a symmetric matrix,
//	 //namily Ldqr1 is defined for row/column elements 0/0 and 1/1. 
//	 //Row/column 2/2 is defined as L0r1.
//	 //Row/Column 3/3, 4/4, 5/5 are not zero but are defined to be "not relevent". (This  is the result of the "extended" Cr matrix).
//	 //All other elements on either side of tht diagonal are "ideally zero" (even though in our test, floating point resolution shows
//	 //some elements as small non-zero values.)
//
//	 fprintf(fp_dq_rotor_rotor_mu_ind_h, "\t\t{%g\t,%g\t,%g\t,%g\t,%g\t,%g},\n", Mdqr[0][0], Mdqr[0][1], Mdqr[0][2], Mdqr[0][3], Mdqr[0][4], Mdqr[0][5]);
//	 fprintf(fp_dq_rotor_rotor_mu_ind_h, "\t\t{%g\t,%g\t,%g\t,%g\t,%g\t,%g},\n", Mdqr[1][0], Mdqr[1][1], Mdqr[1][2], Mdqr[1][3], Mdqr[1][4], Mdqr[1][5]);
//	 fprintf(fp_dq_rotor_rotor_mu_ind_h, "\t\t{%g\t,%g\t,%g\t,%g\t,%g\t,%g},\n", Mdqr[2][0], Mdqr[2][1], Mdqr[2][2], Mdqr[2][3], Mdqr[2][4], Mdqr[2][5]);
//	 fprintf(fp_dq_rotor_rotor_mu_ind_h, "\t\t{%g\t,%g\t,%g\t,%g\t,%g\t,%g},\n", Mdqr[3][0], Mdqr[3][1], Mdqr[3][2], Mdqr[3][3], Mdqr[3][4], Mdqr[3][5]);
//	 fprintf(fp_dq_rotor_rotor_mu_ind_h, "\t\t{%g\t,%g\t,%g\t,%g\t,%g\t,%g},\n", Mdqr[4][0], Mdqr[4][1], Mdqr[4][2], Mdqr[4][3], Mdqr[4][4], Mdqr[4][5]);
//	 fprintf(fp_dq_rotor_rotor_mu_ind_h, "\t\t{%g\t,%g\t,%g\t,%g\t,%g\t,%g},\n", Mdqr[5][0], Mdqr[5][1], Mdqr[5][2], Mdqr[5][3], Mdqr[5][4], Mdqr[5][5]);
//	 fprintf(fp_dq_rotor_rotor_mu_ind_h, "\t\t};\n");


//	 fclose(fp_dq_rotor_rotor_mu_ind_h);

	 	 fprintf(fp_dq_rotor_res_h, "\t\t{%g\t,%g\t,%g},\n", Rrdq0[0][0], Rrdq0[0][1], Rrdq0[0][2]);
	 	 fprintf(fp_dq_rotor_res_h, "\t\t{%g\t,%g\t,%g},\n", Rrdq0[1][0], Rrdq0[1][1], Rrdq0[1][2]);
	 	 fprintf(fp_dq_rotor_res_h, "\t\t{%g\t,%g\t,%g},\n", Rrdq0[2][0], Rrdq0[2][1], Rrdq0[2][2]);
	 	 fprintf(fp_dq_rotor_res_h, "\t\t};\n");



	 	fclose(fp_dq_rotor_res_h);

}
