#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

FILE * fp_dq_stator_res_h;

#define PI 3.1415926535897932384626433832795

//There is no verification in "Roberts..." for this transformation. Refer to page 80 of "Roberts...".


//Invocation:
//
// gcc -g Verify_Rr_dq_on_page_80_ideal.c -lm  (Ubuntu 14.04 gcc requires "-lm" after file(s) to be compiled)


////This transformation matrix was also used in test project "Section_B_7_2.c" and was generated by test project "Lemma_A_12.c"
//double Cr[6][6] = {{0.57735,  -0.28868,  -0.28868,   0.57735,  -0.28868,  -0.28868},
//                   {0.00000,   0.50000,  -0.50000,  -0.00000,   0.50000,  -0.50000},
//                   {0.40825,   0.40825,   0.40825,   0.40825,   0.40825,   0.40825},
//                   {0.00000,   0.00000,   0.70711,   0.00000,   0.00000,  -0.70711},
//                   {0.00000,   0.70711,   0.00000,   0.00000,  -0.70711,   0.00000},
//                   {0.70711,  -0.00000,   0.00000,  -0.70711,  -0.00000,   0.00000}};



//double Rr_res_Cr_t[6][6] = {0};
//double Rrdq0[6][6] = {0};

double Cs[3][3] = {0};
double Rs_res_Cs_t[3][3] = {0};
double Rsdq0[3][3] = {0};


//#include "../../InductionMotor/Rotor_Resistance.h"
// Must use the current value of Rs_res[3][3] in "App_InductionMotor.hpp"

#define Rs_matrix_elem  ((1.68e-8/1.13e-6) *  2.0 * .9248 * (10 * 16 * 2) * ((2.0 * PI * ( .175065 / 2.0) * 10.0 / 48.0)  + 0.1955))    //(Evaluates to 2.72855


double Rs_res[3][3] = {
							{Rs_matrix_elem,   0,				0				},
							{0,				   Rs_matrix_elem,	0				},
							{0,				   0,				Rs_matrix_elem	}
					  };


 
main()
{
	int i,j,k;

			//Create include file for simulation program "App_InductionMotor.hpp" 
	fp_dq_stator_res_h = fopen("dq_Stator_Resistance_ideal.h", "w");
	fprintf(fp_dq_stator_res_h, "\n\n\ndouble Rdq0s[3][3] = {\n");

	 Cs[0][0] = sqrt(2.0 / 3.0) * cos(1.0 * 0);
	 Cs[0][1] = sqrt(2.0 / 3.0) * cos(1.0 * 0 + 2.0 * PI / 3.0);
	 Cs[0][2] = sqrt(2.0 / 3.0) * cos(1.0 * 0 + 4.0 * PI / 3.0);
	 Cs[1][0] = sqrt(2.0 / 3.0) * sin(1.0 * 0);
	 Cs[1][1] = sqrt(2.0 / 3.0) * sin(1.0 * 0 + 2.0 * PI / 3.0);
	 Cs[1][2] = sqrt(2.0 / 3.0) * sin(1.0 * 0 + 4.0 * PI / 3.0);
	 Cs[2][0] = sqrt(2.0 / 3.0) * 1.0 / sqrt(2.0);
	 Cs[2][1] = sqrt(2.0 / 3.0) * 1.0 / sqrt(2.0);
	 Cs[2][2] = sqrt(2.0 / 3.0) * 1.0 / sqrt(2.0);




	  //Equation 3.15 and information on page 80 of "Roberts..."
	  // Cr * Rs * (Cr)_t



	 for(i = 0; i < 3; i++)
	 {
		for(j = 0; j < 3; j++)
		{

			for(k = 0; k < 3; k++)
			{
				Rs_res_Cs_t[i][j] =  Rs_res_Cs_t[i][j] +  Rs_res[i][k] * Cs[j][k];

			}
		}
	 }

	 for(i = 0; i < 3; i++)
	 {
		for(j = 0; j < 3; j++)
		{

			for(k = 0; k < 3; k++)
			{
				Rsdq0[i][j] = Rsdq0[i][j] + Cs[i][k] * Rs_res_Cs_t[k][j];


			}
		  }
	   }




	 printf("\n\nRdq0s = \n");
	 printf("%g\t%g\t%g\n", Rsdq0[0][0], Rsdq0[0][1], Rsdq0[0][2]);
	 printf("%g\t%g\t%g\n", Rsdq0[1][0], Rsdq0[1][1], Rsdq0[1][2]);
	 printf("%g\t%g\t%g\n", Rsdq0[2][0], Rsdq0[2][1], Rsdq0[2][2]);

	 	 //NOTE: As Lemma A.16 on page 243 of "Roberts.." points out "Rsdq0[2][2]" is equal to
	     // "Rs_matrix_elem  + 0  + 0" defined above, or "2.72855"

	 	 //Rrdq0[0][0] and Rrdq0[1][1] = "Rs_matrix_elem*1  + 0*(cos(2*PI/3 - jsin(2*PI/3) +0*(cos(4*PI/3 - jsin(4*PI/3) " or "2.72855"

	    //(In other words, the matrix Rs_res = Rdq0s)




	 	 fprintf(fp_dq_stator_res_h, "\t\t{%g\t,%g\t,%g},\n", Rsdq0[0][0], Rsdq0[0][1], Rsdq0[0][2]);
	 	 fprintf(fp_dq_stator_res_h, "\t\t{%g\t,%g\t,%g},\n", Rsdq0[1][0], Rsdq0[1][1], Rsdq0[1][2]);
	 	 fprintf(fp_dq_stator_res_h, "\t\t{%g\t,%g\t,%g},\n", Rsdq0[2][0], Rsdq0[2][1], Rsdq0[2][2]);
	 	 fprintf(fp_dq_stator_res_h, "\t\t};\n");



	 	fclose(fp_dq_stator_res_h);

}
