
# Assumes known values in input parameters for FDTD-GnuPlot
Me_inv_tmp1_x (50,50) = 0;
d_max = 0.0011764705882352942;   


LIGHT_SPEED =    299792458.0;      
LIGHT_SPEED_SQUARED = 89875517873681764.0;        
MU_0 =           (pi*4.0e-7);         
EPSILON_0 =      (1.0/(MU_0*LIGHT_SPEED_SQUARED));    

recp_dt = LIGHT_SPEED*sqrt(1/(d_max*d_max) + 1.0/(d_max*d_max) + 1.0/(d_max*d_max));


for i=1:50
 for j=1:50
 
  	  if i == j 
  	  
			  # First the center of the tri-diagonal
		  Me_inv_tmp1_x(i,j) = d_max * EPSILON_0 *  recp_dt * (2.0/3.0);
			  # The lower part of the tri-diagonal.
		  if i  != 1
		  
			  Me_inv_tmp1_x(i,j-1) = d_max * EPSILON_0 *  recp_dt * (1.0/6.0);
		  endif
			  # The upper part of the tri-diagonal.
		  if i != 50
		  
			  Me_inv_tmp1_x(i,j+1) = d_max * EPSILON_0 *  recp_dt * (1.0/6.0);
		  endif
  	  endif
  endfor
endfor 


inv(Me_inv_tmp1_x)


