/*
 * Rotor_Resistance.h
 *
 *  Created on: Jun 7, 2016
 *      Author: maiello
 */

#ifndef ROTOR_RESISTANCE_H_
#define ROTOR_RESISTANCE_H_

//
//
//  From Section B.7.1, Figure B.8 page 267 calculate the  the elements of the resistor matrix for "6 bar cage rotor design"
#define Rr_matrix_loop  (2.0 * 1.68e-8 * (0.1955 + (2.0 * PI * (0.175065 / 2.0) / 6.0))  / (205.84 / 1.0e6))
#define Rr_matrix_bar   (- 1.68e-8 * 0.1955 *(205.84 / 1.0e6))



double Rr_res[6][6] = {
							{Rr_matrix_loop,    Rr_matrix_bar,    	0,               			0,               			0,               			Rr_matrix_bar  	},
							{Rr_matrix_bar,     	Rr_matrix_loop,   	Rr_matrix_bar,    	0,               			0,               			0             			},
							{0,               			Rr_matrix_bar,   	Rr_matrix_loop,   	Rr_matrix_bar,    	0,               			0             			},
							{0,                			0,               			Rr_matrix_bar,    	Rr_matrix_loop,	  	Rr_matrix_bar,    	0             			},
							{0,                			0,               			0,               			Rr_matrix_bar,    	Rr_matrix_loop,   	Rr_matrix_bar  	},
							{Rr_matrix_bar,      0,               			0,               			0,               			Rr_matrix_bar,    	Rr_matrix_loop 	}
					  };



#endif /* ROTOR_RESISTANCE_H_ */
