T=.00000064;
Fs=1/T;
load vs_a_output_no_omega.dat;
L=length(vs_a_output_no_omega);
NFFT = 2^nextpow2(L);
Y = fft(vs_a_output_no_omega,NFFT)/L;
f = Fs/2*linspace(0,1,NFFT/2+1);
plot(f,2*abs(Y(1:NFFT/2+1))) 
title('Single-Sided Amplitude Spectrum of MLvl\_vs\_a(t)  (NOTE: DC mag. must be divided by 2)')
xlabel('Frequency (Hz)')
ylabel('Magnitude |MLvl\_vs\_a(f)|')
axis([-10 1100 0 1000])

%  Example from "http://www.mathworks.com/help/matlab/ref/fft.html".
%  Numerous references on the WEB note the fact that with a "single-sided FFT", the
%  DC component magnitude (at f=0) ends up to be twice the actual value. The
%  2*abs(Y(1:NFFT/2+1)) is the problem. Without the "2" the amplitude of the AC components
%  are half what the should be. 

