
 
  


#include "SimuCmds.hpp"

#include <signal.h>
#include <stdarg.h>
#include <unistd.h>
#include <math.h>

#include <cstdlib>
#include <cstdio>
#include <cstring>

#include <string>
#include <iostream>
#include <fstream>
#include <sstream>
#include <list>
#include <vector>
#include <stdexcept>

using namespace std;









extern bool ExecuteSimulation(void);
extern void PlotResults(string [], double [], double [], double [], double [], double);

volatile SIMU_CMD SimuCmd;
int ProgressCount;



string TagNamesToPlot[20];
double ScaleFactors[20];
double MinPlotTimes[20];
double MaxPlotTimes[20];
double PlotTimeSteps[20];
double PlotTimeOffset;

void CtrlCHandler(int signal)
{
  string Command;

  cout << "\tEnter the one of the following commands and return:\n\n\t\t\"break\" - break simulation or plot.\n\t\t\"exit\"- exit simulation or plot.\n";

  
  while(TRUE){
 
    cout << "->";
    cin >> Command;
    if(Command == "break"){
      SimuCmd = SIMU_CMD_BreakLoop;
      break;
    }
    else if(Command == "exit"){
      SimuCmd = SIMU_CMD_Exit;
      break;
    }
  }
}



int main(int argc, char *argv[])
{
  string TagName;
  double ScaleFactor;
  double MinPlotTime;
  double MaxPlotTime;
  double PlotTimeStep;
  int i;
  signal(SIGINT, CtrlCHandler);


  
  //All "App_<xxxx>.hpp" use these functions.
  //!!!!!!!! THIS "COMPARE" MAKES NO SENCE,... NEVER TRUE,... FIX LATER !!!!!!!!!)
  if(ExecuteSimulation() == SIMU_CMD_Exit){
    return 0;
  }

  while(TRUE){
    if(SimuCmd == SIMU_CMD_Exit)
      break;
    
    cout << "\tEnter Plot Time Offset followed by\n\tPlot Name<return>\n\tScale factor<return>\n\tMin Time<return>\n\tMax Time<return>\n\t...\n\tUse symbol \"*\" to plot ALL or to terminate names.\n\tUse symbol \"$h\" to plot time stepping parameter \"h\".\n\n";
 
    for(i = 0; i < 20; i++){
      TagNamesToPlot[i] = "";
      ScaleFactors[i] = 1.0;
      PlotTimeSteps[i] = 0;
      PlotTimeOffset = 0;
    }
    //Note: Specifing a plot time offset is not just for visual support. The default precision for the temporary file
    //      generated for "gnuplot_i.cc" provides only 7 digits of precision for each column of data (including time).
    //      As the simulation time grows larger, we begin to truncate the values in the "time" column such that a "zoom"
    //      at the higher time values produces a less accurate picture compared to the "zoom" at the lower time points.
    //      Adding an offset allows us to zoom in near the zero point, making viewing at large time points more accurate.
    cout << "Plot Offset:";
    while(!(cin >> PlotTimeOffset) || (PlotTimeOffset < 0)){
      cout << "Error, bad plot time offset";
      cin.clear();
      cin.ignore();
      cout << "Plot Offset:";
    }
    i = 0;
    while(TRUE){
      cout << "->";
      cin >> TagName;
      if(TagName == "*"){
	break;
      }
      else{
	cout << "Scale Factor:";
	while(!(cin >> ScaleFactor)){
	  cout << "Error, bad scale factor";
	  cin.clear();
	  cin.ignore();
	  cout << "Scale Factor:";
	}
	cout << "Minimum Plot Time:";
	while(!(cin >> MinPlotTime)){
	  cout << "Error, bad minimum plot time";
	  cin.clear();
	  cin.ignore();
	  cout << "Minimum Plot Time:";
	}
	cout << "Maximum Plot Time:";
	while(!(cin >> MaxPlotTime)){
	  cout << "Error, bad maximum plot time";
	  cin.clear();
	  cin.ignore();
	  cout << "Maximum Plot Time:";
	}
	cout << "Plot Time Step:";
	while(!(cin >> PlotTimeStep) || (PlotTimeStep < 0)){
	  cout << "Error, bad plot time step";
	  cin.clear();
	  cin.ignore();
	  cout << "Plot Time Step:";
	}
      }



      TagNamesToPlot[i] = TagName;
      ScaleFactors[i] = ScaleFactor;
      MinPlotTimes[i] = MinPlotTime;
      MaxPlotTimes[i] = MaxPlotTime;
      PlotTimeSteps[i] = PlotTimeStep;
  
      i++;
      if(i == 19)
	break;
      
    }
    SimuCmd = SIMU_CMD_NoCommand;
    PlotResults(TagNamesToPlot, ScaleFactors, MinPlotTimes, MaxPlotTimes, PlotTimeSteps, PlotTimeOffset);
  }

}

void CheckPlotState(void)
{
  while(1){
    if((SimuCmd == SIMU_CMD_BreakLoop) || (SimuCmd == SIMU_CMD_Exit)){
      break;
    }
    pause();
   }
}

bool QuickCheckPlotState(void)
{
  return((SimuCmd == SIMU_CMD_BreakLoop) || (SimuCmd == SIMU_CMD_Exit));
 }


bool CheckSimuState(double CurTime, double SimuTime)
{
  int  CurProgressCount;
  if((SimuCmd == SIMU_CMD_BreakLoop) || (SimuCmd == SIMU_CMD_Exit)){
    cout << "\n\nSimulation stopped...\n\n\n";
    cout << "\t   Current Time - " << CurTime << "\n";
    cout << "\tSimulation Time - " << SimuTime << "\n\n\n";
    return FALSE;
  }
  else{
    CurProgressCount = (int) (100.0 * CurTime / SimuTime);
    if(CurProgressCount > ProgressCount){
      while(CurProgressCount > ProgressCount){
	printf("%3d percent executed...\n", CurProgressCount);
	ProgressCount++;
      }
      
    }
    return TRUE;
  }
}
