

//		 This simulation for a Three Phase Multilevel Converter is dervied from App_MultiLevelDCTest.hpp. Some of the documentation for how this
//       simulation is setup is retained in this file. For the full documentation, refer to App_SpiceTest.hpp.
//
//
//
//
//
// 
//		An outline of one of three phases is shown below.
//
//
//       Nodal currents for the diagram below are designated as follows.
//
//       "-+" for horizontally drawn currents ("------>")
//      
//       "+   for vertically drawn currents ("^
//        |"                                  |
//                                            |")
//
//                 i1 -+
//                ------------        
//               | v11  i1ct  |
//               |-------- +  |
//             |-   |D11  |-  |
//           - |- + ^   <C11> |
//          S11|-|- |i1st |   | 
//               |--------    |
//   1000 VDC ---| v01  i1cb <C1> (Cell 3p)  
//        i01 -+ |-------- +  |
//             |-   |D12  |-  |
//           - |- + ^   <C12> | 
//          S12|-|- |i1sb |   |
//               |-------     |
//        i1_l + | v12        |
//             -  ---+--------
//                   | 
//                   | 
//    ---------------
//   |
//   |             i2 -+
//   |            ------------        
//   |           | v21  i2ct  |
//   |           |-------- +  |
//   |         |-   |D21  |-  |
//   |       - |- + ^   <C21> |
//   |      S21|-|- |i2st |   | 
//   |           |--------    |
//    -----------| v12  i2cb <C2> (Cell 2p)
//        i12 -+ |-------- +  |
//             |-   |D22  |-  |
//           - |- + ^   <C22> |
//          S22|-|- |i2sb |   |
//               |--------    |
//        i2_l + | v23        |
//             -  ---+--------
//                   |
//                   |
//    ---------------   
//   |                         
//   |             i3 -+                               
//   |            ------------                      
//   |           | v31  i3ct  |                    
//   |           |-------- +  |
//   |         |-   |D31  |-  |
//   |       - |- + ^   <C31> |
//   |      S31|-|- |i3st |   |
//   |           |--------    |
//    -----------| v23  i3cb <C3> (Cell 1p)
//        i23 -+ |-------- +  |
//             |-   |D32  |-  |
//           - |- + ^   <C32> |
//          S32|-|- |i3sb |   |
//               |--------    |
//        i3_l + | v34        |
//             -  ---+--------
//                   |
//                   |
//    -- ------------
//   |   
//   |             i4 -+
//   |            ------------        
//   |           | v41  i4ct  |
//   |           |-------- +  |
//   |         |-   |D41  |-  |
//   |       - |- + ^   <C41> |
//   |      S41|-|- |i4st |   |
//   |           |--------    |
//    -----------| v34  i4cb <C4> (Cell 0p)
//        i34 -+ |-------- +  |
//             |-   |D42  |-  |
//           - |- + ^   <C42> |
//          S42|-|- |i4sb |   |
//               |--------    |
//        i4_l + | v44        |
//             -  ---+--------
//             i44 - |
//                 + |
//                   +----
//                  *|    |
//              -- <Lp>  <Rp>
//             |     |    |    ia -+
//             |     +----+------------ vs_a                                             
//             |    *|    |
//              -- <Ln>  <Rn>                          
//                   |    |                          
//    ---------------+----                           
//   |                                     
//   |             i5 -+                           
//   |            ------------                         
//   |           | v51  i5ct  |                        
//   |           |-------- +  |
//   |         |-   |D51  |-  |
//   |       - |- + ^   <C51> |
//   |      S51|-|- |i5st |   |
//   |           |--------    |
//    -----------| v45  i5cb <C5> (Cell 3n)
//        i45 -+ |-------- +  |
//             |-   |D52  |-  |
//           - |- + ^   <C52> |
//          S52|-|- |i5sb |   |
//               |--------    |
//        i5_l + | v56        |
//             -  ---+--------
//                   |
//                   |
//    ---------------
//   |   
//   |             i6 -+ 
//   |            ------------        
//   |           | v61  i6ct  |
//   |       (12)|-------- +  |
//   |         |-   |D61  |-  |
//   |       - |- + ^   <C61> |
//   |      S61|-|- |i6st |   |
//   |           |--------    |
//    -----------| v56  i6cb <C6> (Cell 2n)
//        i56 -+ |-------- +  |
//             |-   |D62  |-  |
//           - |- + ^   <C62> |
//          S62|-|- |i6sb |   |
//               |--------    |
//        i6_l + | v67        |
//             -  ---+-------
//                   |
//                   |
//    ---------------      
//   |                            
//   |             i7 -+                            
//   |            ------------                       
//   |           | v71  i7ct  |                      
//   |       (14)|-------- +  |
//   |         |-   |D71  |-  |
//   |       - |- + ^   <C71> |
//   |      S71|-|- |i7st |   |
//   |           |--------    |
//    -----------| v67  i7cb <C7> (Cell 1n)
//        i67 -+ |-------- +  |
//             |-   |D72  |-  |
//           - |- + ^   <C72> |
//          S72|-|- |i7sb |   |
//               |--------    |
//        i7_l + | v78        |
//             -  ---+--------
//                   |
//                   |
//    ---------------
//   |   
//   |             i8 -+
//   |            ------------        
//   |           | v81  i8ct  |
//   |           |-------- +  |
//   |         |-   |D81  |-  |
//   |       - |- + ^   <C81> |
//   |      S81|-|- |i8st |   |
//   |           |--------    |
//    -----------| v78  i8cb <C8> (Cell 0n)
//        i78 -+ |-------- +  |
//             |-   |D82  |-  |
//           - |- + ^   <C82> |
//          S82|-|- |i8sb |   |
//               |--------    |
//        i8_l + | v88        |
//             -  ---+--------
//                   |              
//                   |- i88
//                   |+
//                   |
//              - 1000 VDC
//
//
//
//
//    Load connection (in ODE form) to "vs_a", "vs_b" and "vs_c" if MOTOR_COUPLED_LOAD is defined.
//
//
//        Lm_a*dia/dt - Mab*dib/dt - Mac*dic/dt = vs_a - Ra*ia + Ka*omega*sin(Nr*theta) - v_n                   (1)
//
//      - Mab*dia/dt + Lm_b*dib/dt - Mbc*dic/dt = vs_b - Rb*ib + Kb*omega*sin(Nr*theta - 2*PI/3) - v_n          (2)
//
//      - Mac*dia/dt - Mbc*dib/dt + Lm_c*dic/dt = vs_c - Rc*ic + Kc*omega*sin(Nr*theta - 4*PI/3) - v_n          (3)
//
//        Jm*domega/dt = - Ka*ia*sin(Nr*theta) - Kb*ib*sin(Nr*theta - 2*PI/3) - Kc*ic*sin(Nr*theta - 4*PI/3) -
//                          Bm*omega - Cm*sgn(omega) - Dm*sin(2*Nr*theta)                                       (4)
//
//        dtheta/dt = omega                                                                                     (5)
//
//
//
//                                                                                                            
//                                                                                                   
//    Load connection to "vs_a,b,c" if MOTOR_COUPLED_LOAD is undefined
//
//
//
//    vs_a --------------- <CONSTANT_CURRENT_SOURCE_LOAD> -------------
//
//    vs_b --------------- <CONSTANT_CURRENT_SOURCE_LOAD> -------------
//
//    vs_c --------------- <CONSTANT_CURRENT_SOURCE_LOAD> -------------
//
//                                               
//   For each of the three phases:
//
//
//	  (NOTE: The equations below relate only to the "Backward Euler" pass. The equations for the "Trapezoidal" pass are not shown
//			 in this outline.)
//
//    For Cell 3p:
//
//            
//      v01/rS11 - v11/rS11 + v01/rD11 - v11/rD11 = i1st    		=>    - v11*(1/rS11 + 1/rD11) - i1st = - v01*(1/rS11 + 1/rD11)    (v01 is a constant)   (1)
//
//      v12/rS12 - v01/rS12 + v12/rD12 - v01/rD12 = i1sb    		=>    v12*(1/rS12 + 1/rD12) - i1sb =  v01*(1/rS12 + 1/rD12)       (v01 is a constant)   (2)
//
//      i01 + i1_l = i1					                   			=>    i01 + i1_l - i1 = 0           				                                    (3)
//
//		i1st + i1ct = i1											=>	  i1st + ilct - il = 0																(4)
//
//		i1sb + i1cb = i1_l											=> 	  i1sb + i1cb - i1_l = 0															(5)
//
//      v11*C1/h - v12*C1/h - v11_*C1/h + v12_*C1/h = i1			=>    v11*C1/h - v12*C1/h - i1 = v11_*C1/h - v12_*C1/h    		               			(6)
//
//      v01*C11/h - v11*C11/h -v01_*C11/h + v11_*C11/h = i1ct 		=>    - v11*C11/h - i1ct = - v11_*C11/h 						(v01 is a constant) (7)
//
//      v12*C12/h - v01*C12/h - v12_*C12/h + v01_*C12/h = i1cb    	=>    v12*C12/h - i1cb = v12_*C12/h  	    					(v01 is a constant) (8)
//
//
//
//    For Cell 2p:
//
//            
//      v12/rS21 - v21/rS21 + v12/rD21 - v21/rD21 = i2st                    =>    v12*(1/rS21 + 1/rD21) - v21*(1/rS21 + 1/rD21) - i2st     = 0          (9)
//
//      v23/rS22 - v12/rS22 + v23/rD22 - v12/rD22 = i2sb                    =>    v23*(1/rS22 + 1/rD22) - v12*(1/rS22 + 1/rD22) - i2sb     = 0          (10)
//
//      i12 + i2_l = i2				                    					=>    i12 + i2_l - i2 = 0                   				              	(11)
//
//		i2st + i2ct = i2													=>    i2st + i2ct - i2 = 0													(12)
//
//		i2sb + i2cb = i2_l													=>	  i2sb + i2cb - i2_l = 0												(13)
//
//      v21*C2/h - v23*C2/h - v21_*C2/h + v23_*C2/h = i2                 	=>    v21*C2/h - v23*C2/h - i2 = v21_*C2/h - v23_*C2/h                    	(14)
//
//      v12*C21/h - v21*C21/h - v12_*C21/h + v21_*C21/h = i2ct          	=>    v12*C21/h - v21*C21/h - i2ct = v12_*C21/h - v21_*C21/h      	   		(15)
//
//      v23*C22/h - v12*C22/h - v23_*C22/h + v12_*C22/h = i2cb       		=>    v23*C22/h - v12*C22/h - i2cb = v23_*C22/h - v12_*C22/h              	(16)
//
//
//
//
//    For Cell 1p:
//
//            
//      v23/rS31 - v31/rS31 + v23/rD31 - v31/rD31 = i3st                    =>    v23*(1/rS31 + 1/rD31) - v31*(1/rS31 + 1/rD31) - i3st     = 0           (17)
//
//      v34/rS32 - v23/rS32 + v34/rD32 - v23/rD32 = i3sb                    =>    v34*(1/rS32 + 1/rD32) - v23*(1/rS32 + 1/rD32) - i3sb     = 0           (18)
//
//      i23 + i3_l = i3                                                     =>    i23 + i3_l - i3 = 0                                                    (19)
//
//		i3st + i3ct = i3													=>    i3st + i3ct - i3 = 0											 		 (20)
//
//		i3sb + i3cb = i3_l													=>	  i3sb + i3cb - i3_l = 0												 (21)
//
//      v31*C3/h - v34*C3/h	- v31_*C3/h + v34_*C3/h = i3                  	=>    v31*C3/h - v34*C3/h - i3 = v31_*C3/h - v34_*C3/h                     	 (22)
//
//      v23*C31/h - v31*C31/h - v23_*C31/h + v31_*C31/h = i3ct				=>    v23*C31/h - v31*C31/h - i3ct = v23_*C31/h - v31_*C31/h         		 (23)
//
//      v34*C32/h - v23*C32/h - v34_*C32/h + v23_*C32/h = i3cb           	=>    v34*C32/h - v23*C32/h - i3cb = v34_*C32/h - v23_*C32/h              	 (24)
//
//
//
//
//    For Cell 0p:
//
//            
//      v34/rS41 - v41/rS41 + v34/rD41 - v41/rD41 = i4st                    =>    v34*(1/rS41 + 1/rD41) - v41*(1/rS41 + 1/rD41) - i4st = 0               (25)
//
//      v44/rS42 - v34/rS42 + v44/rD42 - v34/rD42 = i4sb                	=>    v44*(1/rS42 + 1/rD42) - v34*(1/rS42 + 1/rD42) - i4sb = 0               (26)
//
//      i34 + i4_l = i4                                                     =>    i34 + i4_l - i4 = 0                                                    (27)
//
//		i4st + i4ct = i4													=>    i4st + i4ct - i4 = 0											 		 (28)
//
//		i4sb + i4cb = i4_l													=>	  i4sb + i4cb - i4_l = 0												 (29)
//
//      v41*C4/h - v44*C4/h - v41_*C4/h + v44_*C4/h = i4                  	=>    v41*C4/h - v44*C4/h - i4 = v41_*C4/h - v44_*C4/h                     	 (30)
//
//      v34*C41/h - v41*C41/h - v34_*C41/h + v41_*C41/h = i4ct       		=>    v34*C41/h - v41*C41/h - i4ct = v34_*C41/h - v41_*C41/h         		 (31)
//
//      v44*C42/h - v34*C42/h - v44_*C42/h + v34_*C42/h = i4cb            	=>    v44*C42/h - v34*C42/h - i4cb = v44_*C42/h - v34_*C42/h                 (32)
//
//
//
//
//    For interphase inductance:  	 (Note the negation on the right side of Eq (36) to account for phase reversal in circuit.)
//
//
//      v44/Rp - vs_a/Rp + iLp = i44                                       =>    v44*1/Rp - vs_a*1/Rp + iLp - i44      = 0                               (33)
//      
//      vs_a/Rn - v45/Rn + iLn = i45                                       =>    vs_a*1/Rn - v45*1/Rn + iLn - i45      = 0                               (34)
//      
//      Lp*iLp/h + Mpn*iLn/h - Lp*iLp_/h - Mpn*iLn_/h = v44 - vs_a         =>    Lp*iLp/h + Mpn*iLn/h - v44 + vs_a = Lp*iLp_/h + Mpn*iLn_/h            	 (35)
//     
//      Mnp*iLp/h + Ln*iLn/h - Mnp*iLp_/h - Ln*iLn_/h = vs_a - v45  	   =>    Mnp*iLp/h + Ln*iLn/h - vs_a + v45 = Mnp*iLp_/h + Ln*iLn_/h              (36)
//
//
//    For coupled motor load circuit:
//
//        
//      
//      0 =  i01 - ia - i88                                                =>   i01 - i78 = ia                    (ia is considered a constant here)     (37)
// 
//                i88 = i78                    
//
//																												  (Same for ib and ic)
//
//
//
//
//
//    For Cell 3n:
//
//            
//      v45/rS51 - v51/rS51 + v45/rD51 - v51/rD51 = i5st                   =>   v45*(1/rS51 + 1/rD51) - v51*(1/rS51 + 1/rD51) - i5st     = 0              (38)
//
//      v56/rS52 - v45/rS52 + v56/rD52 - v45/rD52 = i5sb                   =>   v56*(1/rS52 + 1/rD52) - v45*(1/rS52 + 1/rD52) - i5sb     = 0              (39)
//
//      i45 + i5_l = i5                                                    =>   i45 + i5_l - i5 = 0                                                       (40)
//
//		i5st + i5ct = i5												   =>   i5st + i5ct - i5 = 0											 		  (41)
//
//		i5sb + i5cb = i5_l												   =>	i5sb + i5cb - i5_l = 0												      (42)
//
//      v51*C5/h - v56*C5/h - v51_*C5/h + v56_*C5/h = i5                   =>   v51*C5/h - v56*C5/h - i5 = v51_*C5/h - v56_*C5/h                          (43)
//
//      v45*C51/h - v51*C51/h - v45_*C51/h + v51_*C51/h = i5ct             =>   v45*C51/h - v51*C51/h - i5ct = v45_*C51/h - v51_*C51/h            	      (44)
//
//      v56*C52/h - v45*C52/h - v56_*C52/h + v45_*C52/h = i5cb             =>   v56*C52/h - v45*C52/h - i5cb = v56_*C52/h - v45_*C52/h                    (45)
//
//
//
//
//    For Cell 2n:
//
//            
//      v56/rS61 - v61/rS61 + v56/rD61 - v61/rD61 = i6st                    =>   v56*(1/rS61 + 1/rD61) - v61*(1/rS61 + 1/rD61) - i6st     = 0            (46)
//
//      v67/rS62 - v56/rS62 + v67/rD62 - v56/rD62 = i6sb                    =>   v67*(1/rS62 + 1/rD62) - v56*(1/rS62 + 1/rD62) - i6sb     = 0            (47)
//
//      i56 + i6_l = i6                                                     =>   i56 + i6_l - i6 = 0                                                     (48)
//
//		i6st + i6ct = i6												    =>   i6st + i6ct - i6 = 0											 		 (49)
//
//		i6sb + i6cb = i6_l												    =>	 i6sb + i6cb - i6_l = 0												  	 (50)
//
//      v61*C6/h - v67*C/h - v61_*C6/h + v67_*C/h = i6                    	=>   v61*C6/h - v67*C/h - i6  = v61_*C6/h - v67_*C/h                         (51)
//
//      v56*C61/h - v61*C61/h - v56_*C61/h + v61_*C61/h = i6ct    	 		=>   v56*C61/h - v61*C61/h - i6ct = v56_*C61/h - v61_*C61/h          		 (52)
//
//      v67*C62/h - v56*C62/h - v67_*C62/h + v56_*C62/h = i6cb     	    	=>   v67*C62/h - v56*C62/h - i6cb = v67_*C62/h - v56_*C62/h                	 (53)
//
//
//
//
//    For Cell 1n:
//
//            
//      v67/rS71 - v71/rS71 + v67/rD71 - v71/rD71 = i7st                    =>   v67*(1/rS71 + 1/rD71) - v71*(1/rS71 + 1/rD71) - i7st     = 0           (54)
//
//      v78/rS72 - v67/rS72 + v78/rD72 - v67/rD72 = i7sb                    =>   v78*(1/rS72 + 1/rD72) - v67*(1/rS72 + 1/rD72) - i7sb     = 0           (55)
//
//      i67 + i7_l = i7                                                     =>   i67 + i7_l - i7 = 0                                                    (56)
//
//		i7st + i7ct = i7												    =>   i7st + i7ct - i7 = 0											  	    (57)
//
//		i7sb + i7cb = i7_l												    =>	 i7sb + i7cb - i7_l = 0												  	(58)
//
//      v71*C7/h - v78*C7/h - v71_*C7/h + v78_*C7/h = i7                    =>   v71*C7/h - v78*C7/h - i7 = v71_*C7/h - v78_*C7/h                       (59)
//
//      v67*C71/h - v71*C71/h - v67_*C71/h + v71_*C71/h = i7ct     			=>   v67*C71/h - v71*C71/h - i7ct = v67_*C71/h - v71_*C71/h          		(60)
//
//      v78*C72/h - v67*C72/h - v78_*C72/h + v67_*C72/h = i7cb            	=>   v78*C72/h - v67*C72/h - i7cb = v78_*C72/h - v67_*C72/h              	(61)
//
//
//
//    For Cell 0n:
//
//            
//      v78/rS81 - v81/rS81 + v78/rD81 - v81/rD81 = i8st                     =>   v78*(1/rS81 + 1/rD81) - v81*(1/rS81 + 1/rD81) - i8st     = 0                        (62)
//
//      v88/rS82 - v78/rS82 + v88/rD82 - v78/rD82 = i8sb                     =>   - v78*(1/rS82 + 1/rD82) - i8sb = - v88*(1/rS82 + 1/rD82) 		(v88 is a constant)   (63)
//
//      i78 + i8_l = i8                                                      =>   i78 + i8_l - i8 = 0                                                                 (64)
//
//		i8st + i8ct = i8												     =>   i8st + i8ct - i8 = 0											  	    			  (65)
//
//		i8sb + i8cb = i8_l												     =>	  i8sb + i8cb - i8_l = 0												  	          (66)
//
//      v81*C8/h - v81_*C8/h - v88*C8/h + v88_*C8/h  = i8                     =>   v81*C8/h - i8 = v81_*C8/h     					 			(v88 is a constant)   (67)
//
//      v78*C81/h - v81*C81/h - v78_*C81/h + v81_*C81/h = i8ct               =>   v78*C81/h - v81*C81/h - i8ct = v78_*C81/h - v81_*C81/h         					  (68)
//
//      v88*C82/h - v78*C82/h - v88_*C82/h + v78_*C82/h = i8cb               =>   - v78*C82/h - i8cb = - v78_*C82/h 							(v88 is a constant)   (69)
//
//
//
//      The known static quantities
//
//      v01 = 1000 VDC
//      v88 = -1000 VDC
//
//      The know quantities after the ODE pass
//
//
//
//
//      v12_, v11_
//      v23_, v21_
//		v34_, v31_
//			  v41_
//		v44_,
//		v45_
//      v56_, v51_
//		v67_, v61_
//		v78_, v71_
//		      v81_
//		iLp_, iLn_
//
//      ia, ib   (Determined from the ODE pass. Note: "ib" is not part of the DC solution)
//
//      The state vector for the DC solution (before reductions)
//
//      | v11 v12 v21 v23 v31 v34 v41 v44
//		  vs_a
//        v45 v51 v56 v61 v67 v71 v78 v81
//        i1 i1_l i01 i1st i1ct i1sb i1cb
//		  i2 i2_l i12 i2st i2ct i2sb i2cb
//        i3 i3_l i23 i3st i3ct i3sb i3cb
//        i4 i4_l i34 i4st i4ct i4sb i4cb
//		  i44
//		  iLp iLn
//        i5 i5_l i45 i5st i5ct i5sb i5cb
//        i6 i6_l i56 i6st i6ct i6sb i6cb
//        i7 i7_l i67 i7st i7ct i7sb i7cb
//        i8 i8_l i78 i8st i8ct i8sb i8cb
//		  i88 |'
//
//      The vector above can be simplified, given that
//     
//      i01 = i12 = i23 = i34 = i44 = ipl
//
//      and 
//
//      i45 = i56 = i67 = i78 = i88 = inl
//
//      The vector to solve (DC solution), is now
//
//
//      | v11 v12 v21 v23 v31 v34 v41 v44
//		  vs_a
//        v45 v51 v56 v61 v67 v71 v78 v81
//        i1 i1_l ipl i1st i1ct i1sb i1cb
//		  i2 i2_l i2st i2ct i2sb i2cb
//        i3 i3_l i3st i3ct i3sb i3cb
//        i4 i4_l i4st i4ct i4sb i4cb
//		  iLp iLn
//        i5 i5_l inl i5st i5ct i5sb i5cb
//        i6 i6_l i6st i6ct i6sb i6cb
//        i7 i7_l i7st i7ct i7sb i7cb
//        i8 i8_l i8st i8ct i8sb i8cb |'
//
//
//
//
//
//
//
//
//      Further simplification of the DC SOVE equations above, putting constants and known quantities after the ODE pass on right side.
//		(NOTE: The equations below relate only to the "Backward Euler" pass. The equations for the "Trapezoidal" pass are not shown
//			   in this outline.)
//
//
//            - v11*(1/rS11 + 1/rD11) - i1st = - v01*(1/rS11 + 1/rD11)                               (1)
//
//              v12*(1/rS12 + 1/rD12) - i1sb = v01*(1/rS12 + 1/rD12)                                 (2)
//
//              ipl + i1_l - i1 = 0                                                                  (3)
//
//				i1st + ilct - il = 0															     (4)
//
//				i1sb + i1cb - i1_l = 0															     (5)
//
//              v11*C1/h - v12*C1/h - i1 = v11_*C1/h - v12_*C1/h                                     (6)
//
//			  - v11*C11/h - i1ct = - v11_*C11/h 													 (7)
//
//			    v12*C12/h - i1cb = v12_*C12/h  														 (8)
//
//              v12*(1/rS21 + 1/rD21) - v21*(1/rS21 + 1/rD21) - i2st = 0                             (9)
//
//              v23*(1/rS22 + 1/rD22) - v12*(1/rS22 + 1/rD22) - i2sb = 0                             (10)
//
//              ipl + i2_l - i2 = 0                                                                  (11)
//
//				i2st + i2ct - i2 = 0																 (12)
//
//				i2sb + i2cb - i2_l = 0																 (13)
//
//              v21*C2/h - v23*C2/h - i2 = v21_*C2/h - v23_*C2/h                                     (14)
//
//				v12*C21/h - v21*C21/h - i2ct = v12_*C21/h - v21_*C21/h   		    				 (15)
//
//				v23*C22/h - v12*C22/h - i2cb = v23_*C22/h - v12_*C22/h               				 (16)
//
//              v23*(1/rS31 + 1/rD31) - v31*(1/rS31 + 1/rD31) - i3st = 0                             (17)
//
//              v34*(1/rS32 + 1/rD32) - v23*(1/rS32 + 1/rD32) - i3sb = 0                             (18)
//
//              ipl + i3_l - i3 = 0                                                                  (19)
//
//				i3st + i3ct - i3 = 0											 					 (20)
//
//				i3sb + i3cb - i3_l = 0																 (21)
//
//              v31*C3/h - v34*C3/h - i3 = v31_*C3/h - v34_*C3/h                                     (22)
//
//				v23*C31/h - v31*C31/h - i3ct = v23_*C31/h - v31_*C31/h          		   			 (23)
//
//				v34*C32/h - v23*C32/h - i3cb = v34_*C32/h - v23_*C32/h               				 (24)
//
//              v34*(1/rS41 + 1/rD41) - v41*(1/rS41 + 1/rD41) - i4st = 0                             (25)
//
//              v44*(1/rS42 + 1/rD42) - v34*(1/rS42 + 1/rD42) - i4sb = 0                             (26)
//
//              ipl + i4_l - i4 = 0                                                                  (27)
//
//				i4st + i4ct - i4 = 0											 					 (28)
//
//				i4sb + i4cb - i4_l = 0												 				 (29)
//
//              v41*C4/h - v44*C4/h - i4 = v41_*C4/h - v44_*C4/h                                     (30)
//
//				v34*C41/h - v41*C41/h - i4ct = v34_*C41/h - v41_*C41/h           					 (31)
//
//				v44*C42/h - v34*C42/h - i4cb = v44_*C42/h - v34_*C42/h               				 (32)
//
//              v44*1/Rp - vs_a*1/Rp + iLp - ipl = 0                                                 (33)
//
//              vs_a*1/Rn - v45*1/Rn + iLn - inl = 0                                                 (34)
//
//				Lp*iLp/h + Mpn*iLn/h - v44 + vs_a = Lp*iLp_/h + Mpn*iLn_/h						     (35)
//
//				Mnp*iLp/h + Ln*iLn/h - vs_a + v45 = Mnp*iLp_/h + Ln*iLn_/h					     	 (36)
//
//              ipl - inl = ia                                                                       (37)
//
//              v45*(1/rS51 + 1/rD51) - v51*(1/rS51 + 1/rD51) - i5st = 0                             (38)
//
//              v56*(1/rS52 + 1/rD52) - v45*(1/rS52 + 1/rD52) - i5sb = 0                             (39)
//
//              inl + i5_l - i5 = 0                                                                  (40)
//
//				i5st + i5ct - i5 = 0											 					 (41)
//
//				i5sb + i5cb - i5_l = 0												      			 (42)
//
//              v51*C5/h - v56*C5/h - i5 = v51_*C5/h - v56_*C5/h                                     (43)
//
//				v45*C51/h - v51*C51/h - i5ct = v45_*C51/h - v51_*C51/h           					 (44)
//
//				v56*C52/h - v45*C52/h - i5cb = v56_*C52/h - v45_*C52/h               	 			 (45)
//
//              v56*(1/rS61 + 1/rD61) - v61*(1/rS61 + 1/rD61) - i6st = 0                             (46)
//
//              v67*(1/rS62 + 1/rD62) - v56*(1/rS62 + 1/rD62) - i6sb = 0                             (47)
//
//              inl + i6_l - i6 = 0                                                                  (48)
//
//				i6st + i6ct - i6 = 0											 		             (49)
//
//				i6sb + i6cb - i6_l = 0												  	             (50)
//
//              v61*C6/h - v67*C6/h - i6  = v61_*C6/h - v67_*C6/h                                    (51)
//
//				v56*C61/h - v61*C61/h - i6ct = v56_*C61/h - v61_*C61/h                   			 (52)
//
//				v67*C62/h - v56*C62/h - i6cb = v67_*C62/h - v56_*C62/h               				 (53)
//
//              v67*(1/rS71 + 1/rD71) - v71*(1/rS71 + 1/rD71) - i7st = 0                             (54)
//
//              v78*(1/rS72 + 1/rD72) - v67*(1/rS72 + 1/rD72) - i7sb = 0                             (55)
//
//              inl + i7_l - i7 = 0                                                                  (56)
//
//				i7st + i7ct - i7 = 0											  	   				 (57)
//
//				i7sb + i7cb - i7_l = 0												  				 (58)
//
//              v71*C7/h - v78*C7/h - i7 = v71_*C7/h - v78_*C7/h                                     (59)
//
//				v67*C71/h - v71*C71/h - i7ct = v67_*C71/h - v71_*C71/h          					 (60)
//
//				v78*C72/h - v67*C72/h - i7cb = v78_*C72/h - v67_*C72/h               				 (61)
//
//              v78*(1/rS81 + 1/rD81) - v81*(1/rS81 + 1/rD81) - i8st = 0                             (62)
//
//            - v78*(1/rS82 + 1/rD82) - i8sb = - v88*(1/rS82 + 1/rD82)                               (63)
//
//              inl + i8_l - i8 = 0                                                                  (64)
//
//				i8st + i8ct - i8 = 0											  	    			 (65)
//
//				i8sb + i8cb - i8_l = 0												  	             (66)
//
//              v81*C8/h - i8 = v81_*C8/h                           		                         (67)
//
//				v78*C81/h - v81*C81/h - i8ct = v78_*C81/h - v81_*C81/h          					 (68)
//
//			  - v78*C82/h - i8cb = - v78_*C82/h             			               	             (69)
//
//      
//
//
//
//
//
//
//
//
//
//
//
//
//

typedef enum {
  SRC_FUNC_NULL = -1,
  SRC_FUNC_Vm0,
  SRC_FUNC_Vm1,
  SRC_FUNC_Vm2,
  SRC_FUNC_Vm3,

  SRC_FUNC_ECtrl1_0,
  SRC_FUNC_ECtrl2_0,
  SRC_FUNC_ECtrl3_0,
  SRC_FUNC_ECtrl4_0,
  SRC_FUNC_ECtrl5_0,
  SRC_FUNC_ECtrl6_0,
  SRC_FUNC_ECtrl7_0,
  SRC_FUNC_ECtrl8_0,

  SRC_FUNC_ECtrl1_1,
  SRC_FUNC_ECtrl2_1,
  SRC_FUNC_ECtrl3_1,
  SRC_FUNC_ECtrl4_1,
  SRC_FUNC_ECtrl5_1,
  SRC_FUNC_ECtrl6_1,
  SRC_FUNC_ECtrl7_1,
  SRC_FUNC_ECtrl8_1,

  SRC_FUNC_ECtrl1_2,
  SRC_FUNC_ECtrl2_2,
  SRC_FUNC_ECtrl3_2,
  SRC_FUNC_ECtrl4_2,
  SRC_FUNC_ECtrl5_2,
  SRC_FUNC_ECtrl6_2,
  SRC_FUNC_ECtrl7_2,
  SRC_FUNC_ECtrl8_2,

  SRC_FUNC_Vref_0,
  SRC_FUNC_Vref_1,
  SRC_FUNC_Vref_2,


} SRC_FUNCTION;





typedef enum {
  ODE_FUNC_NULL = -1,
  ODE_FUNC_Ia_Ib_Ic_1,
  ODE_FUNC_Ia_Ib_Ic_2,
  ODE_FUNC_Ia_Ib_Ic_3,
  ODE_FUNC_Omega,
  ODE_FUNC_Theta,
  ODE_FUNC_Probe,

} ODE_FUNCTION;


typedef enum {
  CTRL_FUNC_NULL = -1,
  CTRL_FUNC_RefGen,
  CTRL_FUNC_VDqCmd,

} CTRL_FUNCTION;






typedef enum {
	COEF_FUNC_NULL = -1,
	COEF_FUNC_recp_rSrD11_0,
	COEF_FUNC_recp_rSrD12_0,
	COEF_FUNC_C1_h_0,
	COEF_FUNC_C11_h_0,
	COEF_FUNC_C12_h_0,
	COEF_FUNC_v11_v12_h_prev_C1_0,
	COEF_FUNC_minus_v11_h_prev_minus_PlusBus_C11_0,
	COEF_FUNC_v12_h_prev_plus_PlusBus_C12_0,
	COEF_FUNC_recp_rSrD21_0,
	COEF_FUNC_recp_rSrD22_0,
	COEF_FUNC_C2_h_0,
	COEF_FUNC_C21_h_0,
	COEF_FUNC_C22_h_0,
	COEF_FUNC_v21_v23_h_prev_C2_0,
	COEF_FUNC_v12_v21_h_prev_C21_0,
	COEF_FUNC_v23_v12_h_prev_C22_0,
	COEF_FUNC_recp_rSrD31_0,
	COEF_FUNC_recp_rSrD32_0,
	COEF_FUNC_C3_h_0,
	COEF_FUNC_C31_h_0,
	COEF_FUNC_C32_h_0,
	COEF_FUNC_v31_v34_h_prev_C3_0,
	COEF_FUNC_v23_v31_h_prev_C31_0,
	COEF_FUNC_v34_v23_h_prev_C32_0,
	COEF_FUNC_recp_rSrD41_0,
	COEF_FUNC_recp_rSrD42_0,
	COEF_FUNC_C4_h_0,
	COEF_FUNC_C41_h_0,
	COEF_FUNC_C42_h_0,
	COEF_FUNC_v41_v44_h_prev_C4_0,
	COEF_FUNC_v34_v41_h_prev_C41_0,
	COEF_FUNC_v44_v34_h_prev_C42_0,
	COEF_FUNC_Lp_h_0,
	COEF_FUNC_Mpn_h_0,
	COEF_FUNC_Mnp_h_0,
	COEF_FUNC_Ln_h_0,
	COEF_FUNC_iLp_iLn_h_prev_Lp_Mpn_0,
	COEF_FUNC_iLp_iLn_h_prev_Mnp_Ln_0,
	COEF_FUNC_ia_0,
	COEF_FUNC_recp_rSrD51_0,
	COEF_FUNC_recp_rSrD52_0,
	COEF_FUNC_C5_h_0,
	COEF_FUNC_C51_h_0,
	COEF_FUNC_C52_h_0,
	COEF_FUNC_v51_v56_h_prev_C5_0,
	COEF_FUNC_v45_v51_h_prev_C51_0,
	COEF_FUNC_v56_v45_h_prev_C52_0,
	COEF_FUNC_recp_rSrD61_0,
	COEF_FUNC_recp_rSrD62_0,
	COEF_FUNC_C6_h_0,
	COEF_FUNC_C61_h_0,
	COEF_FUNC_C62_h_0,
	COEF_FUNC_v61_v67_h_prev_C6_0,
	COEF_FUNC_v56_v61_h_prev_C61_0,
	COEF_FUNC_v67_v56_h_prev_C62_0,
	COEF_FUNC_recp_rSrD71_0,
	COEF_FUNC_recp_rSrD72_0,
	COEF_FUNC_C7_h_0,
	COEF_FUNC_C71_h_0,
	COEF_FUNC_C72_h_0,
	COEF_FUNC_v71_v78_h_prev_C7_0,
	COEF_FUNC_v67_v71_h_prev_C71_0,
	COEF_FUNC_v78_v67_h_prev_C72_0,
	COEF_FUNC_recp_rSrD81_0,
	COEF_FUNC_recp_rSrD82_0,
	COEF_FUNC_C8_h_0,
	COEF_FUNC_C81_h_0,
	COEF_FUNC_C82_h_0,
	COEF_FUNC_v81_h_prev_plus_MinusBus_C8_0,
	COEF_FUNC_v78_v81_h_prev_C81_0,
	COEF_FUNC_minus_v78_h_prev_minus_MinusBus_C82_0,

	COEF_FUNC_recp_rSrD11_1,
	COEF_FUNC_recp_rSrD12_1,
	COEF_FUNC_C1_h_1,
	COEF_FUNC_C11_h_1,
	COEF_FUNC_C12_h_1,
	COEF_FUNC_v11_v12_h_prev_C1_1,
	COEF_FUNC_minus_v11_h_prev_minus_PlusBus_C11_1,
	COEF_FUNC_v12_h_prev_plus_PlusBus_C12_1,
	COEF_FUNC_recp_rSrD21_1,
	COEF_FUNC_recp_rSrD22_1,
	COEF_FUNC_C2_h_1,
	COEF_FUNC_C21_h_1,
	COEF_FUNC_C22_h_1,
	COEF_FUNC_v21_v23_h_prev_C2_1,
	COEF_FUNC_v12_v21_h_prev_C21_1,
	COEF_FUNC_v23_v12_h_prev_C22_1,
	COEF_FUNC_recp_rSrD31_1,
	COEF_FUNC_recp_rSrD32_1,
	COEF_FUNC_C3_h_1,
	COEF_FUNC_C31_h_1,
	COEF_FUNC_C32_h_1,
	COEF_FUNC_v31_v34_h_prev_C3_1,
	COEF_FUNC_v23_v31_h_prev_C31_1,
	COEF_FUNC_v34_v23_h_prev_C32_1,
	COEF_FUNC_recp_rSrD41_1,
	COEF_FUNC_recp_rSrD42_1,
	COEF_FUNC_C4_h_1,
	COEF_FUNC_C41_h_1,
	COEF_FUNC_C42_h_1,
	COEF_FUNC_v41_v44_h_prev_C4_1,
	COEF_FUNC_v34_v41_h_prev_C41_1,
	COEF_FUNC_v44_v34_h_prev_C42_1,
	COEF_FUNC_Lp_h_1,
	COEF_FUNC_Mpn_h_1,
	COEF_FUNC_Mnp_h_1,
	COEF_FUNC_Ln_h_1,
	COEF_FUNC_iLp_iLn_h_prev_Lp_Mpn_1,
	COEF_FUNC_iLp_iLn_h_prev_Mnp_Ln_1,
	COEF_FUNC_ia_1,
	COEF_FUNC_recp_rSrD51_1,
	COEF_FUNC_recp_rSrD52_1,
	COEF_FUNC_C5_h_1,
	COEF_FUNC_C51_h_1,
	COEF_FUNC_C52_h_1,
	COEF_FUNC_v51_v56_h_prev_C5_1,
	COEF_FUNC_v45_v51_h_prev_C51_1,
	COEF_FUNC_v56_v45_h_prev_C52_1,
	COEF_FUNC_recp_rSrD61_1,
	COEF_FUNC_recp_rSrD62_1,
	COEF_FUNC_C6_h_1,
	COEF_FUNC_C61_h_1,
	COEF_FUNC_C62_h_1,
	COEF_FUNC_v61_v67_h_prev_C6_1,
	COEF_FUNC_v56_v61_h_prev_C61_1,
	COEF_FUNC_v67_v56_h_prev_C62_1,
	COEF_FUNC_recp_rSrD71_1,
	COEF_FUNC_recp_rSrD72_1,
	COEF_FUNC_C7_h_1,
	COEF_FUNC_C71_h_1,
	COEF_FUNC_C72_h_1,
	COEF_FUNC_v71_v78_h_prev_C7_1,
	COEF_FUNC_v67_v71_h_prev_C71_1,
	COEF_FUNC_v78_v67_h_prev_C72_1,
	COEF_FUNC_recp_rSrD81_1,
	COEF_FUNC_recp_rSrD82_1,
	COEF_FUNC_C8_h_1,
	COEF_FUNC_C81_h_1,
	COEF_FUNC_C82_h_1,
	COEF_FUNC_v81_h_prev_plus_MinusBus_C8_1,
	COEF_FUNC_v78_v81_h_prev_C81_1,
	COEF_FUNC_minus_v78_h_prev_minus_MinusBus_C82_1,

	COEF_FUNC_recp_rSrD11_2,
	COEF_FUNC_recp_rSrD12_2,
	COEF_FUNC_C1_h_2,
	COEF_FUNC_C11_h_2,
	COEF_FUNC_C12_h_2,
	COEF_FUNC_v11_v12_h_prev_C1_2,
	COEF_FUNC_minus_v11_h_prev_minus_PlusBus_C11_2,
	COEF_FUNC_v12_h_prev_plus_PlusBus_C12_2,
	COEF_FUNC_recp_rSrD21_2,
	COEF_FUNC_recp_rSrD22_2,
	COEF_FUNC_C2_h_2,
	COEF_FUNC_C21_h_2,
	COEF_FUNC_C22_h_2,
	COEF_FUNC_v21_v23_h_prev_C2_2,
	COEF_FUNC_v12_v21_h_prev_C21_2,
	COEF_FUNC_v23_v12_h_prev_C22_2,
	COEF_FUNC_recp_rSrD31_2,
	COEF_FUNC_recp_rSrD32_2,
	COEF_FUNC_C3_h_2,
	COEF_FUNC_C31_h_2,
	COEF_FUNC_C32_h_2,
	COEF_FUNC_v31_v34_h_prev_C3_2,
	COEF_FUNC_v23_v31_h_prev_C31_2,
	COEF_FUNC_v34_v23_h_prev_C32_2,
	COEF_FUNC_recp_rSrD41_2,
	COEF_FUNC_recp_rSrD42_2,
	COEF_FUNC_C4_h_2,
	COEF_FUNC_C41_h_2,
	COEF_FUNC_C42_h_2,
	COEF_FUNC_v41_v44_h_prev_C4_2,
	COEF_FUNC_v34_v41_h_prev_C41_2,
	COEF_FUNC_v44_v34_h_prev_C42_2,
	COEF_FUNC_Lp_h_2,
	COEF_FUNC_Mpn_h_2,
	COEF_FUNC_Mnp_h_2,
	COEF_FUNC_Ln_h_2,
	COEF_FUNC_iLp_iLn_h_prev_Lp_Mpn_2,
	COEF_FUNC_iLp_iLn_h_prev_Mnp_Ln_2,
	COEF_FUNC_ia_2,
	COEF_FUNC_recp_rSrD51_2,
	COEF_FUNC_recp_rSrD52_2,
	COEF_FUNC_C5_h_2,
	COEF_FUNC_C51_h_2,
	COEF_FUNC_C52_h_1,
	COEF_FUNC_v51_v56_h_prev_C5_2,
	COEF_FUNC_v45_v51_h_prev_C51_2,
	COEF_FUNC_v56_v45_h_prev_C52_2,
	COEF_FUNC_recp_rSrD61_2,
	COEF_FUNC_recp_rSrD62_2,
	COEF_FUNC_C6_h_2,
	COEF_FUNC_C61_h_2,
	COEF_FUNC_C62_h_2,
	COEF_FUNC_v61_v67_h_prev_C6_2,
	COEF_FUNC_v56_v61_h_prev_C61_2,
	COEF_FUNC_v67_v56_h_prev_C62_2,
	COEF_FUNC_recp_rSrD71_2,
	COEF_FUNC_recp_rSrD72_2,
	COEF_FUNC_C7_h_2,
	COEF_FUNC_C71_h_2,
	COEF_FUNC_C72_h_2,
	COEF_FUNC_v71_v78_h_prev_C7_2,
	COEF_FUNC_v67_v71_h_prev_C71_2,
	COEF_FUNC_v78_v67_h_prev_C72_2,
	COEF_FUNC_recp_rSrD81_2,
	COEF_FUNC_recp_rSrD82_2,
	COEF_FUNC_C8_h_2,
	COEF_FUNC_C81_h_2,
	COEF_FUNC_C82_h_2,
	COEF_FUNC_v81_h_prev_plus_MinusBus_C8_2,
	COEF_FUNC_v78_v81_h_prev_C81_2,
	COEF_FUNC_minus_v78_h_prev_minus_MinusBus_C82_2,




} COEF_FUNCTION;



typedef enum {
  SWITCH_FUNC_NULL = -1,
  SWITCH_FUNC_rS11_0,
  SWITCH_FUNC_rS12_0,
  SWITCH_FUNC_rS21_0,
  SWITCH_FUNC_rS22_0,
  SWITCH_FUNC_rS31_0,
  SWITCH_FUNC_rS32_0,
  SWITCH_FUNC_rS41_0,
  SWITCH_FUNC_rS42_0,
  SWITCH_FUNC_rS51_0,
  SWITCH_FUNC_rS52_0,
  SWITCH_FUNC_rS61_0,
  SWITCH_FUNC_rS62_0,
  SWITCH_FUNC_rS71_0,
  SWITCH_FUNC_rS72_0,
  SWITCH_FUNC_rS81_0,
  SWITCH_FUNC_rS82_0,

  SWITCH_FUNC_rS11_1,
  SWITCH_FUNC_rS12_1,
  SWITCH_FUNC_rS21_1,
  SWITCH_FUNC_rS22_1,
  SWITCH_FUNC_rS31_1,
  SWITCH_FUNC_rS32_1,
  SWITCH_FUNC_rS41_1,
  SWITCH_FUNC_rS42_1,
  SWITCH_FUNC_rS51_1,
  SWITCH_FUNC_rS52_1,
  SWITCH_FUNC_rS61_1,
  SWITCH_FUNC_rS62_1,
  SWITCH_FUNC_rS71_1,
  SWITCH_FUNC_rS72_1,
  SWITCH_FUNC_rS81_1,
  SWITCH_FUNC_rS82_1,

  SWITCH_FUNC_rS11_2,
  SWITCH_FUNC_rS12_2,
  SWITCH_FUNC_rS21_2,
  SWITCH_FUNC_rS22_2,
  SWITCH_FUNC_rS31_2,
  SWITCH_FUNC_rS32_2,
  SWITCH_FUNC_rS41_2,
  SWITCH_FUNC_rS42_2,
  SWITCH_FUNC_rS51_2,
  SWITCH_FUNC_rS52_2,
  SWITCH_FUNC_rS61_2,
  SWITCH_FUNC_rS62_2,
  SWITCH_FUNC_rS71_2,
  SWITCH_FUNC_rS72_2,
  SWITCH_FUNC_rS81_2,
  SWITCH_FUNC_rS82_2,



} SWITCH_FUNCTION;


typedef enum {
  SPICE_FUNC_NULL = -1,
  SPICE_FUNC_MultiLevel_0,
  SPICE_FUNC_MultiLevel_1,
  SPICE_FUNC_MultiLevel_2,

} SPICE_FUNCTION;

//define this only for debugging the matrix of any declared SpiceObjects. The size must appropriately.
//#define DEBUG_SPICE_MATRIX
//#define SPICE_DEBUG_MATRIX_SIZE 69

//if "DEBUG_SPICE_MATRIX" defined above, as an option we can also elect to dump the "a_matrix" and "a_equate_vector" for
//analysis using Octave.
//#define DUMP_MATRIX_EQUATE_VECTOR_TO_FILE_FOR_EXTERNAL_ANALYSIS


#include "../Simulation/Simulation.hpp"


//Parameters....

// Cell parameters
#define C1   .0004 
#define C2   .0004
#define C3   .0004
#define C4   .0004
#define C5   .0004
#define C6   .0004
#define C7   .0004
#define C8   .0004


// Switch coupling capacitor parameters
	//(NOTE: I increased these form .0000001 in original App_SpiceTest.hpp file to .0000005.
	//		 The dv/dt was to great causing voltage spikes (e.g.probably because diodes in SwitchObjects
	//       could not respond fast enough to change in current direction.)
#define C11	 .0000005
#define C12	 .0000005
#define C21	 .0000005
#define C22	 .0000005
#define C31	 .0000005
#define C32	 .0000005
#define C41	 .0000005
#define C42	 .0000005
#define C51	 .0000005
#define C52	 .0000005
#define C61	 .0000005
#define C62	 .0000005
#define C71	 .0000005
#define C72	 .0000005
#define C81	 .0000005
#define C82	 .0000005



//set this to the same value as the initial "OffRes" of the "SwitchObject"
//that controls switch coeficients.
#define INIT_COEF_RS_RD  1000000.0


 
// Load parameters (if MOTOR_COUPLED_LOAD is defined)
#define Mab  .495e-3
#define Mbc  Mab
#define Mac  Mab

#define Lm_a  1.0e-3
#define Lm_b  Lm_a
#define Lm_c  Lm_a

#define Ra 1.0
#define Rb Ra
#define Rc Ra

#define Ka .1  //N*m/amp
#define Kb Ka
#define Kc Ka

#define Bm  5e-5   //N*m*sec/rad

#define Cm  0    //.005 //N*m

#define Dm  0    //.001  //N*m

#define Jm  .002  //N*m*sec**2/rad

#define Nr  6


// Load parameters (if MOTOR_COUPLED_LOAD is undefined)
#define CONSTANT_CURRENT_SOURCE_LOAD   20.0



// Interphase filter parameters

#define Lp 	.15e-3
#define Ln  Lp
#define Mpn 0 				//.49e-3   //(.5mH * .98 coupling)
#define Mnp Mpn 

#define Rp  100000.0
#define Rn  Rp

#define RECEP_Rp (1.0/Rp)
#define RECEP_Rn (1.0/Rn)

#define SWITCH_ENABLE_TIME .000750 

#define HALF_PWM_CYCLE 	.0005			//.00005
#define PWM_GAIN 5.0              


#define QUANTUM_PERIOD .0000125  


#define PLUS_DC_BUS_VOLTAGE  1000.0
#define MINUS_DC_BUS_VOLTAGE -1000.0

#define PI   3.1415926535897932384626433832795
  
        // Indices for the vectors to solve.
#define Ind_v11     0
#define Ind_v12     1
#define Ind_v21     2
#define Ind_v23     3
#define Ind_v31     4
#define Ind_v34     5
#define Ind_v41     6
#define Ind_v44     7
#define Ind_vs_a    8
#define Ind_v45     9
#define Ind_v51     10
#define Ind_v56     11
#define Ind_v61     12
#define Ind_v67     13
#define Ind_v71     14
#define Ind_v78     15
#define Ind_v81     16
#define Ind_i1      17
#define Ind_i1_l    18
#define Ind_ipl     19
#define Ind_i1st	20
#define Ind_i1ct	21
#define Ind_i1sb	22
#define Ind_i1cb	23
#define Ind_i2    	24
#define Ind_i2_l  	25
#define Ind_i2st	26
#define Ind_i2ct	27
#define Ind_i2sb	28
#define Ind_i2cb	29
#define Ind_i3      30
#define Ind_i3_l    31
#define Ind_i3st	32
#define Ind_i3ct	33
#define Ind_i3sb	34
#define Ind_i3cb	35
#define Ind_i4      36
#define Ind_i4_l    37
#define Ind_i4st	38
#define Ind_i4ct	39
#define Ind_i4sb	40
#define Ind_i4cb	41
#define Ind_iLp		42
#define Ind_iLn		43
#define Ind_i5      44
#define Ind_i5_l   	45
#define Ind_inl     46
#define Ind_i5st	47
#define Ind_i5ct	48
#define Ind_i5sb	49
#define Ind_i5cb	50
#define Ind_i6      51
#define Ind_i6_l    52
#define Ind_i6st	53
#define Ind_i6ct	54
#define Ind_i6sb	55
#define Ind_i6cb	56
#define Ind_i7      57
#define Ind_i7_l    58
#define Ind_i7st	59
#define Ind_i7ct	60
#define Ind_i7sb	61
#define Ind_i7cb	62
#define Ind_i8      63
#define Ind_i8_l    64
#define Ind_i8st	65
#define Ind_i8ct	66
#define Ind_i8sb	67
#define Ind_i8cb	68






// Define if "Vref" should supply a sin() command. If undefined, "Vref" is supplies by CTRL "RefGen".
#define APPLY_SINEWAVE_VREF_COMMAND



// Define if circulation compensation is to applied to each cell.
//#define ENABLE_CELL_CIRCULATION

// A table to hold the "CircState" variables of SrcObject's ECtrl1 through ECtrl8. These states
// are controlled by SrcObject Vm0. A two dimensional table, the second dimension being the control
// states for ECtrl1 through ECtrl8. This sequence is modeled after the algorythm in EightCellPhase_modulator.vhd
//backed up in external hard drive "E:\DELLDUO_Machine_BACKUP\FanoutCellHubDesign\FanoutBoard\hardware"

unsigned int CircStateTable[][8] = {{0, 1, 2, 3, 0, 1, 2, 3},
								    {1, 2, 3, 0, 0, 1, 2, 3},
								    {1, 2, 3, 0, 1, 2, 3, 0},
								    {2, 3, 0, 1, 1, 2, 3, 0},
								    {2, 3, 0, 1, 2, 3, 0, 1},
								    {3, 0, 1, 2, 2, 3, 0, 1},
								    {3, 0, 1, 2, 3, 0, 1, 2},
								    {0, 1, 2, 3, 3, 0, 1, 2}};

	//Count of the period HALF_PWM_CYCLE that increments the index to the first dimension of
	//"CircStateTable" above.
#define CIRCULAR_STATE_RATE 2

	//Define to set Omega to a value to produce rail-to-rail switching
#define ENABLE_OMEGA_CTRL
	//Set the Omega control (1.0 PU produces no shift)
#define OMEGA_CTRL_FACTOR .2


	//Define to dump "vs_a" to either "vs_a_output_omega.dat" or "vs_a_output_no_omega.dat"
	//depending on the setting of ENABLE_OMEGA_CTRL
	//
	//Run like this in octave to see results:
	//
	//		octave:1> run_filter_plots
	//
#define DUMP_VS_A_OUTPUT_SIGNAL



// Control all the ploting in this application by commenting/un-commenting  the definitions below...

  //#define PLOT_SRCOBJECT_Vm0
  //#define PLOT_SRCOBJECT_Vm1
  //#define PLOT_SRCOBJECT_Vm2
  //#define PLOT_SRCOBJECT_Vm3

//#define PLOT_SRCOBJECT_PROBES_PHASE_NUM 0    // 0, 1 or 2
//#define PLOT_SRCOBJECT_PROBES_ECtrl1
//#define PLOT_SRCOBJECT_PROBES_ECtrl2
//#define PLOT_SRCOBJECT_PROBES_ECtrl3
//#define PLOT_SRCOBJECT_PROBES_ECtrl4
//#define PLOT_SRCOBJECT_PROBES_ECtrl5
//#define PLOT_SRCOBJECT_PROBES_ECtrl6
//#define PLOT_SRCOBJECT_PROBES_ECtrl7
//#define PLOT_SRCOBJECT_PROBES_ECtrl8


//#define PLOT_SRCOBJECT_Vref



//#define PLOT_ODEOBJECT_Ia_Ib_Ic_1
//#define PLOT_ODEOBJECT_Ia_Ib_Ic_2
//#define PLOT_ODEOBJECT_Ia_Ib_Ic_3
//#define PLOT_ODEOBJECT_Omega
//#define PLOT_ODEOBJECT_Theta
//#define PLOT_ODEOBJECT_Probe

//#define PLOT_CTRLOBJECT_VDqCmd
//#define PLOT_CTRLOBJECT_RefGen






//#define PLOT_SWITCHOBJECT_PROBES_PHASE_NUM 0    // 0, 1 or 2
//#define PLOT_SWITCHOBJECT_PROBES_rS11
//#define DO_PROBE_rS11_res
//#define DO_PROBE_rS11_cur
//#define DO_PROBE_rS11_gate

//#define PLOT_SWITCHOBJECT_PROBES_rS12
//#define DO_PROBE_rS12_res
//#define DO_PROBE_rS12_cur
//#define DO_PROBE_rS12_gate

//#define PLOT_SWITCHOBJECT_PROBES_rS21
//#define DO_PROBE_rS21_res
//#define DO_PROBE_rS21_cur
//#define DO_PROBE_rS21_gate

//#define PLOT_SWITCHOBJECT_PROBES_rS22
//#define DO_PROBE_rS22_res
//#define DO_PROBE_rS22_cur
//#define DO_PROBE_rS22_gate

//#define PLOT_SWITCHOBJECT_PROBES_rS31
//#define DO_PROBE_rS31_res
//#define DO_PROBE_rS31_cur
//#define DO_PROBE_rS31_gate

//#define PLOT_SWITCHOBJECT_PROBES_rS32
//#define DO_PROBE_rS32_res
//#define DO_PROBE_rS32_cur
//#define DO_PROBE_rS32_gate

//#define PLOT_SWITCHOBJECT_PROBES_rS41
//#define DO_PROBE_rS41_res
//#define DO_PROBE_rS41_cur
//#define DO_PROBE_rS41_gate

//#define PLOT_SWITCHOBJECT_PROBES_rS42
//#define DO_PROBE_rS42_res
//#define DO_PROBE_rS42_cur
//#define DO_PROBE_rS42_gate

//#define PLOT_SWITCHOBJECT_PROBES_rS51 
//#define DO_PROBE_rS51_res
//#define DO_PROBE_rS51_cur
//#define DO_PROBE_rS51_gate

//#define PLOT_SWITCHOBJECT_PROBES_rS52
//#define DO_PROBE_rS52_res
//#define DO_PROBE_rS52_cur
//#define DO_PROBE_rS52_gate

//#define PLOT_SWITCHOBJECT_PROBES_rS61
//#define DO_PROBE_rS61_res
//#define DO_PROBE_rS61_cur
//#define DO_PROBE_rS61_gate

//#define PLOT_SWITCHOBJECT_PROBES_rS62
//#define DO_PROBE_rS62_res
//#define DO_PROBE_rS62_cur
//#define DO_PROBE_rS62_gate

//#define PLOT_SWITCHOBJECT_PROBES_rS71
//#define DO_PROBE_rS71_res
//#define DO_PROBE_rS71_cur
//#define DO_PROBE_rS71_gate

//#define PLOT_SWITCHOBJECT_PROBES_rS72
//#define DO_PROBE_rS72_res
//#define DO_PROBE_rS72_cur
//#define DO_PROBE_rS72_gate

//#define PLOT_SWITCHOBJECT_PROBES_rS81
//#define DO_PROBE_rS81_res
//#define DO_PROBE_rS81_cur
//#define DO_PROBE_rS81_gate

//#define PLOT_SWITCHOBJECT_PROBES_rS82
//#define DO_PROBE_rS82_res
//#define DO_PROBE_rS82_cur
//#define DO_PROBE_rS82_gate



//#define PLOT_SPICEOBJECT_PROBES_PHASE_NUM 0    // 0, 1 or 2
#define PLOT_SPICEOBJECT_PROBES_solution_vector
  //#define DO_PROBE_v11    
  //#define DO_PROBE_v12    
  //#define DO_PROBE_v21    
  //#define DO_PROBE_v23    
  //#define DO_PROBE_v31    
  //#define DO_PROBE_v34    
  //#define DO_PROBE_v41    
  //#define DO_PROBE_v44
#define DO_PROBE_vs_a
  //#define DO_PROBE_v45
  //#define DO_PROBE_v51    
  //#define DO_PROBE_v56    
  //#define DO_PROBE_v61    
  //#define DO_PROBE_v67    
  //#define DO_PROBE_v71    
  //#define DO_PROBE_v78    
  //#define DO_PROBE_v81    
  //#define DO_PROBE_i1   
  //#define DO_PROBE_i1_l     
 #define DO_PROBE_ipl
  //#define DO_PROBE_i1st
  //#define DO_PROBE_i1ct
  //#define DO_PROBE_i1sb
  //#define DO_PROBE_i1cb
  //#define DO_PROBE_i2
  //#define DO_PROBE_i2_l     
  //#define DO_PROBE_i2st
  //#define DO_PROBE_i2ct
  //#define DO_PROBE_i2sb
  //#define DO_PROBE_i2cb
  //#define DO_PROBE_i3 
  //#define DO_PROBE_i3_l
  //#define DO_PROBE_i3st
  //#define DO_PROBE_i3ct
  //#define DO_PROBE_i3sb
  //#define DO_PROBE_i3cb
  //#define DO_PROBE_i4
  //#define DO_PROBE_i4_l
  //#define DO_PROBE_i4st
  //#define DO_PROBE_i4ct
  //#define DO_PROBE_i4sb
  //#define DO_PROBE_i4cb
  //#define DO_PROBE_iLp
  //#define DO_PROBE_iLn
  //#define DO_PROBE_i5
  //#define DO_PROBE_i5_l
  #define DO_PROBE_inl
  //#define DO_PROBE_i5st
  //#define DO_PROBE_i5ct
  //#define DO_PROBE_i5sb
  //#define DO_PROBE_i5cb
  //#define DO_PROBE_i6 
  //#define DO_PROBE_i6_l   
  //#define DO_PROBE_i6st
  //#define DO_PROBE_i6ct
  //#define DO_PROBE_i6sb
  //#define DO_PROBE_i6cb
  //#define DO_PROBE_i7
  //#define DO_PROBE_i7_l     
  //#define DO_PROBE_i7st
  //#define DO_PROBE_i7ct
  //#define DO_PROBE_i7sb
  //#define DO_PROBE_i7cb
  //#define DO_PROBE_i8
  //#define DO_PROBE_i8_l 
  //#define DO_PROBE_i8st
  //#define DO_PROBE_i8ct
  //#define DO_PROBE_i8sb
  //#define DO_PROBE_i8cb





   
// **** SrcObject Classes ********************************

// ---- Vm0 ---------------------------------------------

class Vm0 : public SrcObject
{
public:
  virtual void SrcFunction(double t);
  virtual void SrcRValueUpdate(void);
  Vm0(void);
  ~Vm0(void);
  double t_mod;
  double t_prev;
  double t_scaled_shifted;
  double t_shift;
  double t_freq_scale;
  double PwmRampDir;
  bool SignalCirculationUpdate;



};


Vm0 Inst_Vm0;


// --------------------------------------------------------

// ---- Vm1 ---------------------------------------

class Vm1 : public SrcObject
{
public:
  virtual void SrcFunction(double t);
  virtual void SrcRValueUpdate(void);
  Vm1(void);
  ~Vm1(void);
  double t_mod;
  double t_prev;
  double t_scaled_shifted;
  double t_shift;
  double t_freq_scale;
  double PwmRampDir;
  bool OmegaCtrl;
  double t_mod_omega;
  double t_prev_omega;
  double t_scaled_shifted_omega;
  double t_shift_omega;
  double PwmRampDir_omega;



};


Vm1 Inst_Vm1;


// --------------------------------------------------------


// ---- Vm2 ----------------------------------------------

class Vm2 : public SrcObject
{
public:
  virtual void SrcFunction(double t);
  virtual void SrcRValueUpdate(void);
  Vm2(void);
  ~Vm2(void);
  double t_mod;
  double t_prev;
  double t_scaled_shifted;
  double t_shift;
  double t_freq_scale;
  double PwmRampDir;
  bool OmegaCtrl;
  double t_mod_omega;
  double t_prev_omega;
  double t_scaled_shifted_omega;
  double t_shift_omega;
  double PwmRampDir_omega;

};


Vm2 Inst_Vm2;


// --------------------------------------------------------


// ---- Vm3 ----------------------------------------------

class Vm3 : public SrcObject
{
public:
  virtual void SrcFunction(double t);
  virtual void SrcRValueUpdate(void);
  Vm3(void);
  ~Vm3(void);
  double t_mod;
  double t_prev;
  double t_scaled_shifted;
  double t_shift;
  double t_freq_scale;
  double PwmRampDir;
  bool OmegaCtrl;
  double t_mod_omega;
  double t_prev_omega;
  double t_scaled_shifted_omega;
  double t_shift_omega;
  double PwmRampDir_omega;

};


Vm3 Inst_Vm3;


// --------------------------------------------------------



// ---- ECtrl1 ---------------------------------------------

class ECtrl1 : public SrcObject
{
  int phase_num;
public:
  virtual void SrcFunction(double t);
  virtual void SwitchRValueUpdate(void);
  //we use some probes in this object to get a better understanding
  //of what is going on.
  virtual void RecordProbes(void);
  virtual void PlotProbes(Gnuplot & SimuPlot, vector<double> & Plot_t, string TagNamesToPlot[]);
  ECtrl1(void);
  ~ECtrl1(void);
  double Time_0;
  double V_112;
  double V_210;
  bool   GateCtrl_111;
  bool   GateCtrl_121;
  unsigned int CircState;
  //storage for probes...
  vector<double> Gate_111;
  vector<double> Gate_121;

};

ECtrl1 Inst_ECtrl1_0(0);
ECtrl1 Inst_ECtrl1_1(1);
ECtrl1 Inst_ECtrl1_2(2);

// --------------------------------------------------------



// ---- ECtrl2 ---------------------------------------------

class ECtrl2 : public SrcObject
{
  int phase_num;
public:
  virtual void SrcFunction(double t);
  virtual void SwitchRValueUpdate(void);
  //we use some probes in this object to get a better understanding
  //of what is going on.
  virtual void RecordProbes(void);
  virtual void PlotProbes(Gnuplot & SimuPlot, vector<double> & Plot_t, string TagNamesToPlot[]);
  ECtrl2(void);
  ~ECtrl2(void);
  double Time_0;
  double V_112;
  double V_110;
  bool   GateCtrl_211;
  bool   GateCtrl_221;
  unsigned int CircState;
  //storage for probes...
  vector<double> Gate_211;
  vector<double> Gate_221;	 

};

ECtrl2 Inst_ECtrl2_0(0);
ECtrl2 Inst_ECtrl2_1(1);
ECtrl2 Inst_ECtrl2_2(2);

// --------------------------------------------------------


// ---- ECtrl3 ---------------------------------------------

class ECtrl3 : public SrcObject
{
  int phase_num;
public:
  virtual void SrcFunction(double t);
  virtual void SwitchRValueUpdate(void);
  //we use some probes in this object to get a better understanding
  //of what is going on.
  virtual void RecordProbes(void);
  virtual void PlotProbes(Gnuplot & SimuPlot, vector<double> & Plot_t, string TagNamesToPlot[]);
  ECtrl3(void);
  ~ECtrl3(void);
  double Time_0;
  double V_112;
  double V_410;
  bool   GateCtrl_311;
  bool   GateCtrl_321;
  unsigned int CircState;
  //storage for probes...
  vector<double> Gate_311;
  vector<double> Gate_321;

};

ECtrl3 Inst_ECtrl3_0(0);
ECtrl3 Inst_ECtrl3_1(1);
ECtrl3 Inst_ECtrl3_2(2);

// --------------------------------------------------------


// ---- ECtrl4 ---------------------------------------------

class ECtrl4 : public SrcObject
{
  int phase_num;
public:
  virtual void SrcFunction(double t);
  virtual void SwitchRValueUpdate(void);
  //we use some probes in this object to get a better understanding
  //of what is going on.
  virtual void RecordProbes(void);
  virtual void PlotProbes(Gnuplot & SimuPlot, vector<double> & Plot_t, string TagNamesToPlot[]);
  ECtrl4(void);
  ~ECtrl4(void);
  double Time_0;
  double V_112;
  double V_310;
  bool   GateCtrl_411;
  bool   GateCtrl_421;
  unsigned int CircState;
  //storage for probes...
  vector<double> Gate_411;
  vector<double> Gate_421;
 

};

ECtrl4 Inst_ECtrl4_0(0);
ECtrl4 Inst_ECtrl4_1(1);
ECtrl4 Inst_ECtrl4_2(2);

// --------------------------------------------------------


// ---- ECtrl5 ---------------------------------------------

class ECtrl5 : public SrcObject
{
  int phase_num;
public:
  virtual void SrcFunction(double t);
  virtual void SwitchRValueUpdate(void);
  //we use some probes in this object to get a better understanding
  //of what is going on.
  virtual void RecordProbes(void);
  virtual void PlotProbes(Gnuplot & SimuPlot, vector<double> & Plot_t, string TagNamesToPlot[]);
  ECtrl5(void);
  ~ECtrl5(void);
  double Time_0;
  double V_112;
  double V_210;
  bool   GateCtrl_511;
  bool   GateCtrl_521;
  unsigned int CircState;
  //storage for probes...
  vector<double> Gate_511;
  vector<double> Gate_521;	 

};

ECtrl5 Inst_ECtrl5_0(0);
ECtrl5 Inst_ECtrl5_1(1);
ECtrl5 Inst_ECtrl5_2(2);

// --------------------------------------------------------


// ---- ECtrl6 ---------------------------------------------

class ECtrl6 : public SrcObject
{
  int phase_num;
public:
  virtual void SrcFunction(double t);
  virtual void SwitchRValueUpdate(void);
  //we use some probes in this object to get a better understanding
  //of what is going on.
  virtual void RecordProbes(void);
  virtual void PlotProbes(Gnuplot & SimuPlot, vector<double> & Plot_t, string TagNamesToPlot[]);
  ECtrl6(void);
  ~ECtrl6(void);
  double Time_0;
  double V_112;
  double V_110;
  bool   GateCtrl_611;
  bool   GateCtrl_621;
  unsigned int CircState;
  //storage for probes...
  vector<double> Gate_611;
  vector<double> Gate_621;
	 

};

ECtrl6 Inst_ECtrl6_0(0);
ECtrl6 Inst_ECtrl6_1(1);
ECtrl6 Inst_ECtrl6_2(2);

// --------------------------------------------------------


// ---- ECtrl7 ---------------------------------------------

class ECtrl7 : public SrcObject
{
  int phase_num;
public:
  virtual void SrcFunction(double t);
  virtual void SwitchRValueUpdate(void);
  //we use some probes in this object to get a better understanding
  //of what is going on.
  virtual void RecordProbes(void);
  virtual void PlotProbes(Gnuplot & SimuPlot, vector<double> & Plot_t, string TagNamesToPlot[]);
  ECtrl7(void);
  ~ECtrl7(void);
  double Time_0;
  double V_112;
  double V_410;
  bool   GateCtrl_711;
  bool   GateCtrl_721;
  unsigned int CircState;
  //storage for probes...
  vector<double> Gate_711;
  vector<double> Gate_721;
	 

};

ECtrl7 Inst_ECtrl7_0(0);
ECtrl7 Inst_ECtrl7_1(1);
ECtrl7 Inst_ECtrl7_2(2);

// --------------------------------------------------------


// ---- ECtrl8 ---------------------------------------------

class ECtrl8 : public SrcObject
{
  int phase_num;
public:
  virtual void SrcFunction(double t);
  virtual void SwitchRValueUpdate(void);
  //we use some probes in this object to get a better understanding
  //of what is going on.
  virtual void RecordProbes(void);
  virtual void PlotProbes(Gnuplot & SimuPlot, vector<double> & Plot_t, string TagNamesToPlot[]);
  ECtrl8(void);
  ~ECtrl8(void);
  double Time_0;
  double V_112;
  double V_310;
  bool   GateCtrl_811;
  bool   GateCtrl_821;
  unsigned int CircState;
  //storage for probes...
  vector<double> Gate_811;
  vector<double> Gate_821;
	 

};

ECtrl8 Inst_ECtrl8_0(0);
ECtrl8 Inst_ECtrl8_1(1);
ECtrl8 Inst_ECtrl8_2(2);

// --------------------------------------------------------

// ---- Vref  ----------------------------------------------------

class Vref : public SrcObject
{
  int phase_num;
public:
  virtual void SrcFunction(double t);
  virtual void SrcRValueUpdate(void);
  Vref(void);
  ~Vref(void);
  unsigned int CircStateIndex;
  unsigned int CircStateRate;
  bool OmegaCtrl;
  bool SignalCirculationUpdate;
  double V_xo;

};

Vref Inst_Vref_0(0);
Vref Inst_Vref_1(1);
Vref Inst_Vref_2(2);

// ---------------------------------------------------------------







SrcObject * SrcObjectList[] = {(SrcObject *) &Inst_Vm0,
			       (SrcObject *) &Inst_Vm1,
			       (SrcObject *) &Inst_Vm2,
			       (SrcObject *) &Inst_Vm3,

			       (SrcObject *) &Inst_ECtrl1_0,
			       (SrcObject *) &Inst_ECtrl2_0,
			       (SrcObject *) &Inst_ECtrl3_0,
			       (SrcObject *) &Inst_ECtrl4_0
			       (SrcObject *) &Inst_ECtrl5_0,
			       (SrcObject *) &Inst_ECtrl6_0,
			       (SrcObject *) &Inst_ECtrl7_0,
			       (SrcObject *) &Inst_ECtrl8_0,

			       (SrcObject *) &Inst_ECtrl1_1,
			       (SrcObject *) &Inst_ECtrl2_1,
			       (SrcObject *) &Inst_ECtrl3_1,
			       (SrcObject *) &Inst_ECtrl4_1
			       (SrcObject *) &Inst_ECtrl5_1,
			       (SrcObject *) &Inst_ECtrl6_1,
			       (SrcObject *) &Inst_ECtrl7_1,
			       (SrcObject *) &Inst_ECtrl8_1,

			       (SrcObject *) &Inst_ECtrl1_2,
			       (SrcObject *) &Inst_ECtrl2_2,
			       (SrcObject *) &Inst_ECtrl3_2,
			       (SrcObject *) &Inst_ECtrl4_2
			       (SrcObject *) &Inst_ECtrl5_2,
			       (SrcObject *) &Inst_ECtrl6_2,
			       (SrcObject *) &Inst_ECtrl7_2,
			       (SrcObject *) &Inst_ECtrl8_2,

			       (SrcObject *) &Inst_Vref_0,
			       (SrcObject *) &Inst_Vref_1,
			       (SrcObject *) &Inst_Vref_2,
			       0};


// ****************************************************************




// **** OdeObject Classes *****************************************

 
// ---- Ia_Ib_Ic_1 -----------------------------------------

class Ia_Ib_Ic_1 : public OdeObject
{
public:
  virtual double OdeFunction(double y, double t);
  virtual void PostOdeFunction(double t);
  virtual void OdeRValueUpdate(void);
  virtual void OdeGroupMSolve(double dydt[],  double dmdt[]);
  //we use some probes in this object to get a better understanding
  //of what is going on.
  virtual void RecordProbes(void);
  virtual void PlotProbes(Gnuplot & SimuPlot, vector<double> & Plot_t, string TagNamesToPlot[]);
  Ia_Ib_Ic_1(void);
  ~Ia_Ib_Ic_1(void);
  //source for this ODE
  double vs_a;
  double pwm_sig;
  double ia;
  double omega;
  double theta;
  double v_n;
  int PositionFeedback;    //(this will ultimately to "FSFCtrl")
  int VelocityFeedback;    //(this will ultimately to "FSFCtrl")
  //storage for probes...
  vector<double> Cemf_a;   //for expression "Ka*omega*sin(Nr*theta)"
  vector<double> VBus_a;   //"vs_a" (processed DC_BUS_VOLTAGE or 0 depending on "pwm_sig")
  vector<double> VRa;      //for expression "Ra*ia"
  vector<double> Theta_enc;     //quantitized motor position based on ENCODER_RESOLUTION (rad).
  vector<double> Omega_enc;     //quantitized motor velocity based on ENCODER_RESOLUTION (rad/sec).
};

Ia_Ib_Ic_1 Inst_Ia_Ib_Ic_1;


// --------------------------------------------------------

// ---- Ia_Ib_Ic_2 -----------------------------------------

class Ia_Ib_Ic_2 : public OdeObject
{
public:
  virtual double OdeFunction(double y, double t);
  virtual void OdeRValueUpdate(void);
  virtual void RecordProbes(void);
  virtual void PlotProbes(Gnuplot & SimuPlot, vector<double> & Plot_t, string TagNamesToPlot[]);
  Ia_Ib_Ic_2(void);
  ~Ia_Ib_Ic_2(void);
  //source for this ODE
  double vs_b;
  double pwm_sig;
  double ib;
  double omega;
  double theta;
  double v_n;
  //storage for probes...
  vector<double> Cemf_b;   //for expression "Kb*omega*sin(Nr*theta - 2*PI/3)"
  vector<double> VBus_b;   //"vs_b" (processed DC_BUS_VOLTAGE or 0 depending on "pwm_sig")
  vector<double> VRb;      //for expression "Rb*ib"
};

Ia_Ib_Ic_2 Inst_Ia_Ib_Ic_2;




// --------------------------------------------------------


// ---- Ia_Ib_Ic_3 -----------------------------------------

class Ia_Ib_Ic_3 : public OdeObject
{
public:
  virtual double OdeFunction(double y, double t);
  virtual void OdeRValueUpdate(void);
  virtual void RecordProbes(void);
  virtual void PlotProbes(Gnuplot & SimuPlot, vector<double> & Plot_t, string TagNamesToPlot[]);
  Ia_Ib_Ic_3(void);
  ~Ia_Ib_Ic_3(void);
  //source for this ODE
  double vs_c;
  double pwm_sig;
  double ic;
  double omega;
  double theta;
  double v_n;
  //storage for probes...
  vector<double> Cemf_c;   //for expression "Kc*omega*sin(Nr*theta - 4*PI/3)"
  vector<double> VBus_c;   //"vs_c" (processed DC_BUS_VOLTAGE or 0 depending on "pwm_sig")
  vector<double> VRc;      //for expression "Rc*ic"
};

Ia_Ib_Ic_3 Inst_Ia_Ib_Ic_3;


// --------------------------------------------------------


// ---- Omega ---------------------------------------------

class Omega : public OdeObject
{
public:
  virtual double OdeFunction(double y, double t);
  virtual void OdeRValueUpdate(void);
  Omega(void);
  ~Omega(void);
  //source for this ODE
  double ia;
  double ib;
  double ic;
  double theta;



};

Omega Inst_Omega;


// --------------------------------------------------------

// ---- Theta ---------------------------------------------

class Theta : public OdeObject
{
public:
  virtual double OdeFunction(double y, double t);
  virtual void OdeRValueUpdate(void);
  virtual void CtrlRValueUpdate(void);
  Theta(void);
  ~Theta(void);
  //source for this ODE
  double omega;

};

Theta Inst_Theta;

// --------------------------------------------------------


// ---- Probe ---------------------------------------------

class Probe : public OdeObject
{
public:
  //(No OdeFunction() here, we are just using this to sync.data for probes.
  //The variable "v_n" is the problem here. It is calculated in a "group solve").
  virtual void RecordProbes(void);
  virtual void PlotProbes(Gnuplot & SimuPlot, vector<double> & Plot_t, string TagNamesToPlot[]);
  Probe(void);
  ~Probe(void);
  //soure for this ODE
  double ia;
  double ib;
  double ic;
  double vs_a;
  double vs_b;
  double vs_c;
  double v_n;
  double omega;
  double theta;
  //storage for probes...
  vector<double> Vcm_a;    //for expression  "vs_a - Ra*ia - Ka*omega*sin(Nr*theta) - v_n"
  vector<double> Vcm_b;    //for expression  "vs_b - Rb*ib - Kb*omega*sin(Nr*theta - 2*PI/3) - v_n"
  vector<double> Vcm_c;    //for expression  "vs_c - Rc*ic - Kc*omega*sin(Nr*theta - 4*PI/3) - v_n"
  vector<double> V_n;       //for the instantanious neutral voltage "v_n"
};

Probe Inst_Probe;

// --------------------------------------------------------


OdeObject * OdeObjectList[] = {(OdeObject *) &Inst_Ia_Ib_Ic_1, //the next three are in a group and must be maintained in this order.
			       (OdeObject *) &Inst_Ia_Ib_Ic_2,
			       (OdeObject *) &Inst_Ia_Ib_Ic_3,
			       (OdeObject *) &Inst_Omega,
			       (OdeObject *) &Inst_Theta,
			       (OdeObject *) &Inst_Probe,
			       0};


// ****************************************************************




// **** CtrlObject Classes ****************************************


// ---- VDqCmd  ---------------------------------------------

class VDqCmd : public CtrlObject
{
public:
  virtual void CtrlFunction(double t);
  virtual void SrcRValueUpdate(void);
  virtual void RecordProbes(void);
  virtual void PlotProbes(Gnuplot & SimuPlot, vector<double> & Plot_t, string TagNamesToPlot[]);
  VDqCmd(void);
  ~VDqCmd(void);
  //source for this CTRL
  double V_xo[3];
  double vdd;
  double vqd;

  //storage for probes..
  vector<double> VCmd_a;  //value of V_xo[0].
  vector<double> VCmd_b;  //value of V_xo[1].
  vector<double> VCmd_c;  //value of V_xo[2].

};



VDqCmd Inst_VDqCmd;

// -------------------------------------------------------------




// ---- RefGen  ---------------------------------------------

class RefGen : public CtrlObject
{

public:
  virtual void CtrlFunction(double t);
  virtual void CtrlRValueUpdate(void);
  virtual void RecordProbes(void);
  virtual void PlotProbes(Gnuplot & SimuPlot, vector<double> & Plot_t, string TagNamesToPlot[]);
  double sgn(double omegad);
  double impulse(double sgn_omegad);
  RefGen(void);
  ~RefGen(void);
  //source for this CTRL
  double betad;
  double alphad;
  double omegad;
  double thetad;
  double zetad;
  double idd;
  double iqd;
  double didd;
  double diqd;
  double vdd;
  double vqd;
  //storage for probes..
  vector<double> beta_d;
  vector<double> alpha_d;
  vector<double> omega_d;
  vector<double> theta_d;
  vector<double> zeta_d;
  vector<double> id_d;
  vector<double> iq_d;
  vector<double> did_d;
  vector<double> diq_d;
  vector<double> vd_d;
  vector<double> vq_d;




};



RefGen Inst_RefGen;

// -------------------------------------------------------------




CtrlObject * CtrlObjectList[] = {(CtrlObject *) &Inst_RefGen,
                                 (CtrlObject *) &Inst_VDqCmd,
				 0};


int CtrlObjectQuantum[] = { REF_GEN_QUANTUM_CNT,
                            VDQ_CMD_QUANTUM_CNT,
                          };



// ****************************************************************





// **** CoefObject Classes ****************************************

// ---- Coef_recp_rSrD11 ---------------------------------------------

class Coef_recp_rSrD11 : public CoefObject
{
  int phase_num;
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_recp_rSrD11(void);
  ~Coef_recp_rSrD11(void);
  double rS11;
  double rD11;

};

Coef_recp_rSrD11 Coef_recp_rSrD11_i_0(0);
Coef_recp_rSrD11 Coef_recp_rSrD11_i_1(1);
Coef_recp_rSrD11 Coef_recp_rSrD11_i_2(2);


// -------------------------------------------------------------

// ---- Coef_recp_rSrD12 ---------------------------------------------

class Coef_recp_rSrD12 : public CoefObject
{
  int phase_num;
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_recp_rSrD12(void);
  ~Coef_recp_rSrD12(void);
  double rS12;
  double rD12;


};

Coef_recp_rSrD12 Coef_recp_rSrD12_i_0(0);
Coef_recp_rSrD12 Coef_recp_rSrD12_i_1(1);
Coef_recp_rSrD12 Coef_recp_rSrD12_i_2(2);

// -------------------------------------------------------------



// ---- Coef_C1_h ---------------------------------------------

class Coef_C1_h : public CoefObject
{
  int phase_num;
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_C1_h(void);
  ~Coef_C1_h(void);

  


};

Coef_C1_h Coef_C1_h_i_0(0);
Coef_C1_h Coef_C1_h_i_1(1);
Coef_C1_h Coef_C1_h_i_2(2);

// -------------------------------------------------------------


// ---- Coef_C11_h ---------------------------------------------

class Coef_C11_h : public CoefObject
{
  int phase_num;
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_C11_h(void);
  ~Coef_C11_h(void);




};

Coef_C11_h Coef_C11_h_i_0(0);
Coef_C11_h Coef_C11_h_i_1(1);
Coef_C11_h Coef_C11_h_i_2(2);

// -------------------------------------------------------------


// ---- Coef_C12_h ---------------------------------------------

class Coef_C12_h : public CoefObject
{
  int phase_num;
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_C12_h(void);
  ~Coef_C12_h(void);




};

Coef_C12_h Coef_C12_h_i_0(0);
Coef_C12_h Coef_C12_h_i_1(1);
Coef_C12_h Coef_C12_h_i_2(2);

// -------------------------------------------------------------


// ---- Coef_v11_v12_h_prev_C1 ---------------------------------

class Coef_v11_v12_h_prev_C1 : public CoefObject
{
  int phase_num;
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_v11_v12_h_prev_C1(void);
  ~Coef_v11_v12_h_prev_C1(void);
  double v11_;
  double v12_;
  	  // When "trapezoilal" pass is run...
  double i1_;




};

Coef_v11_v12_h_prev_C1 Coef_v11_v12_h_prev_C1_i_0(0);
Coef_v11_v12_h_prev_C1 Coef_v11_v12_h_prev_C1_i_1(1);
Coef_v11_v12_h_prev_C1 Coef_v11_v12_h_prev_C1_i_2(2);

// -------------------------------------------------------------


// ---- Coef_minus_v11_h_prev_minus_PlusBus_C11 ----------------------

class Coef_minus_v11_h_prev_minus_PlusBus_C11 : public CoefObject
{
  int phase_num;
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_minus_v11_h_prev_minus_PlusBus_C11(void);
  ~Coef_minus_v11_h_prev_minus_PlusBus_C11(void);
  double v11_;
	  // When "trapezoilal" pass is run...
  double i1ct_;




};

Coef_minus_v11_h_prev_minus_PlusBus_C11 Coef_minus_v11_h_prev_minus_PlusBus_C11_i_0(0);
Coef_minus_v11_h_prev_minus_PlusBus_C11 Coef_minus_v11_h_prev_minus_PlusBus_C11_i_1(1);
Coef_minus_v11_h_prev_minus_PlusBus_C11 Coef_minus_v11_h_prev_minus_PlusBus_C11_i_2(2);

// -------------------------------------------------------------

// ---- Coef_v12_h_prev_plus_PlusBus_C12 -----------------------

class Coef_v12_h_prev_plus_PlusBus_C12 : public CoefObject
{
  int phase_num;
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_v12_h_prev_plus_PlusBus_C12(void);
  ~Coef_v12_h_prev_plus_PlusBus_C12(void);
  double v12_;
	  // When "trapezoilal" pass is run...
  double i1cb_;

  


};

Coef_v12_h_prev_plus_PlusBus_C12 Coef_v12_h_prev_plus_PlusBus_C12_i_0(0);
Coef_v12_h_prev_plus_PlusBus_C12 Coef_v12_h_prev_plus_PlusBus_C12_i_1(1);
Coef_v12_h_prev_plus_PlusBus_C12 Coef_v12_h_prev_plus_PlusBus_C12_i_2(2);

// -------------------------------------------------------------



// ---- Coef_recp_rSrD21 ---------------------------------------------

class Coef_recp_rSrD21 : public CoefObject
{
  int phase_num;
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_recp_rSrD21(void);
  ~Coef_recp_rSrD21(void);
  double rS21;
  double rD21;



};

Coef_recp_rSrD21 Coef_recp_rSrD21_i_0(0);
Coef_recp_rSrD21 Coef_recp_rSrD21_i_1(1);
Coef_recp_rSrD21 Coef_recp_rSrD21_i_2(2);

// -------------------------------------------------------------

// ---- Coef_recp_rSrD22 ---------------------------------------------

class Coef_recp_rSrD22 : public CoefObject
{
  int phase_num;
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_recp_rSrD22(void);
  ~Coef_recp_rSrD22(void);
  double rS22;
  double rD22;



};

Coef_recp_rSrD22 Coef_recp_rSrD22_i_0(0);
Coef_recp_rSrD22 Coef_recp_rSrD22_i_1(1);
Coef_recp_rSrD22 Coef_recp_rSrD22_i_2(2);

// -------------------------------------------------------------


// ---- Coef_C2_h ---------------------------------------------

class Coef_C2_h : public CoefObject
{
  int phase_num;
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_C2_h(void);
  ~Coef_C2_h(void);




};

Coef_C2_h Coef_C2_h_i_0(0);
Coef_C2_h Coef_C2_h_i_1(1);
Coef_C2_h Coef_C2_h_i_2(2);

// -------------------------------------------------------------


// ---- Coef_C21_h ---------------------------------------------

class Coef_C21_h : public CoefObject
{
  int phase_num;
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_C21_h(void);
  ~Coef_C21_h(void);




};

Coef_C21_h Coef_C21_h_i_0(0);
Coef_C21_h Coef_C21_h_i_1(1);
Coef_C21_h Coef_C21_h_i_2(2);

// -------------------------------------------------------------


// ---- Coef_C22_h ---------------------------------------------

class Coef_C22_h : public CoefObject
{
  int phase_num;
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_C22_h(void);
  ~Coef_C22_h(void);




};

Coef_C22_h Coef_C22_h_i_0(0);
Coef_C22_h Coef_C22_h_i_1(1);
Coef_C22_h Coef_C22_h_i_2(2);

// -------------------------------------------------------------



// ---- Coef_v21_v23_h_prev_C2 ---------------------------------

class Coef_v21_v23_h_prev_C2 : public CoefObject
{
  int phase_num;
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_v21_v23_h_prev_C2(void);
  ~Coef_v21_v23_h_prev_C2(void);
  double v21_;
  double v23_;
	  // When "trapezoilal" pass is run...
  double i2_;

};

Coef_v21_v23_h_prev_C2 Coef_v21_v23_h_prev_C2_i_0(0);
Coef_v21_v23_h_prev_C2 Coef_v21_v23_h_prev_C2_i_1(1);
Coef_v21_v23_h_prev_C2 Coef_v21_v23_h_prev_C2_i_2(2);

// -------------------------------------------------------------


// ---- Coef_v12_v21_h_prev_C21 --------------------------------

class Coef_v12_v21_h_prev_C21: public CoefObject
{
   int phase_num;
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_v12_v21_h_prev_C21(void);
  ~Coef_v12_v21_h_prev_C21(void);
  double v12_;
  double v21_;
	  // When "trapezoilal" pass is run...
  double i2ct_;


};

Coef_v12_v21_h_prev_C21 Coef_v12_v21_h_prev_C21_i_0(0);
Coef_v12_v21_h_prev_C21 Coef_v12_v21_h_prev_C21_i_1(1);
Coef_v12_v21_h_prev_C21 Coef_v12_v21_h_prev_C21_i_2(2)

// -------------------------------------------------------------


// ---- Coef_v23_v12_h_prev_C22 --------------------------------

class Coef_v23_v12_h_prev_C22 : public CoefObject
{
  int phase_num;
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_v23_v12_h_prev_C22(void);
  ~Coef_v23_v12_h_prev_C22(void);
  double v23_;
  double v12_;
	  // When "trapezoilal" pass is run...
  double i2cb_;


};

Coef_v23_v12_h_prev_C22 Coef_v23_v12_h_prev_C22_i_0(0);
Coef_v23_v12_h_prev_C22 Coef_v23_v12_h_prev_C22_i_1(1);
Coef_v23_v12_h_prev_C22 Coef_v23_v12_h_prev_C22_i_2(2);

// -------------------------------------------------------------



// ---- Coef_recp_rSrD31 ---------------------------------------------

class Coef_recp_rSrD31 : public CoefObject
{
  int phase_num;
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_recp_rSrD31(void);
  ~Coef_recp_rSrD31(void);
  double rS31;
  double rD31;




};

Coef_recp_rSrD31 Coef_recp_rSrD31_i_0(0);
Coef_recp_rSrD31 Coef_recp_rSrD31_i_1(1);
Coef_recp_rSrD31 Coef_recp_rSrD31_i_2(2);

// -------------------------------------------------------------

// ---- Coef_recp_rSrD32 ---------------------------------------------

class Coef_recp_rSrD32 : public CoefObject
{
  int phase_num;
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_recp_rSrD32(void);
  ~Coef_recp_rSrD32(void);
  double rS32;
  double rD32;



};

Coef_recp_rSrD32 Coef_recp_rSrD32_i_0(0);
Coef_recp_rSrD32 Coef_recp_rSrD32_i_1(1);
Coef_recp_rSrD32 Coef_recp_rSrD32_i_2(2);

// -------------------------------------------------------------


// ---- Coef_C3_h ---------------------------------------------

class Coef_C3_h : public CoefObject
{
  int phase_num;
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_C3_h(void);
  ~Coef_C3_h(void);




};

Coef_C3_h Coef_C3_h_i_0(0);
Coef_C3_h Coef_C3_h_i_1(1);
Coef_C3_h Coef_C3_h_i_2(2);

// -------------------------------------------------------------


// ---- Coef_C31_h ---------------------------------------------

class Coef_C31_h : public CoefObject
{
  int phase_num;
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_C31_h(void);
  ~Coef_C31_h(void);




};

Coef_C31_h Coef_C31_h_i_0(0);
Coef_C31_h Coef_C31_h_i_1(1);
Coef_C31_h Coef_C31_h_i_2(2);

// -------------------------------------------------------------


// ---- Coef_C32_h ---------------------------------------------

class Coef_C32_h : public CoefObject
{
  int phase_num;
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_C32_h(void);
  ~Coef_C32_h(void);




};

Coef_C32_h Coef_C32_h_i_0(0);
Coef_C32_h Coef_C32_h_i_1(1);
Coef_C32_h Coef_C32_h_i_2(2);

// -------------------------------------------------------------



// ---- Coef_v31_v34_h_prev_C3 ---------------------------------

class Coef_v31_v34_h_prev_C3 : public CoefObject
{
  int phase_num;
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_v31_v34_h_prev_C3(void);
  ~Coef_v31_v34_h_prev_C3(void);
  double v31_;
  double v34_;
	  // When "trapezoilal" pass is run...
  double i3_;



};

Coef_v31_v34_h_prev_C3 Coef_v31_v34_h_prev_C3_i_0(0);
Coef_v31_v34_h_prev_C3 Coef_v31_v34_h_prev_C3_i_1(1);
Coef_v31_v34_h_prev_C3 Coef_v31_v34_h_prev_C3_i_2(2);

// -------------------------------------------------------------


// ---- Coef_v23_v31_h_prev_C31 --------------------------------

class Coef_v23_v31_h_prev_C31: public CoefObject
{
  int phase_num;
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_v23_v31_h_prev_C31(void);
  ~Coef_v23_v31_h_prev_C31(void);
  double v23_;
  double v31_;
	  // When "trapezoilal" pass is run...
  double i3ct_;



};

Coef_v23_v31_h_prev_C31 Coef_v23_v31_h_prev_C31_i_0(0);
Coef_v23_v31_h_prev_C31 Coef_v23_v31_h_prev_C31_i_1(1);
Coef_v23_v31_h_prev_C31 Coef_v23_v31_h_prev_C31_i_2(2);

// -------------------------------------------------------------


// ---- Coef_v34_v23_h_prev_C32 --------------------------------

class Coef_v34_v23_h_prev_C32 : public CoefObject
{
  int phase_num;
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_v34_v23_h_prev_C32(void);
  ~Coef_v34_v23_h_prev_C32(void);
  double v34_;
  double v23_;
	  // When "trapezoilal" pass is run...
  double i3cb_;


};

Coef_v34_v23_h_prev_C32 Coef_v34_v23_h_prev_C32_i_0(0);
Coef_v34_v23_h_prev_C32 Coef_v34_v23_h_prev_C32_i_1(1);
Coef_v34_v23_h_prev_C32 Coef_v34_v23_h_prev_C32_i_2(2);

// -------------------------------------------------------------



// ---- Coef_recp_rSrD41 ---------------------------------------------

class Coef_recp_rSrD41 : public CoefObject
{
  int phase_num;
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_recp_rSrD41(void);
  ~Coef_recp_rSrD41(void);
  double rS41;
  double rD41;



};

Coef_recp_rSrD41 Coef_recp_rSrD41_i_0(0);
Coef_recp_rSrD41 Coef_recp_rSrD41_i_1(1);
Coef_recp_rSrD41 Coef_recp_rSrD41_i_2(2);

// -------------------------------------------------------------

// ---- Coef_recp_rSrD42 ---------------------------------------------

class Coef_recp_rSrD42 : public CoefObject
{
  int phase_num;
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_recp_rSrD42(void);
  ~Coef_recp_rSrD42(void);
  double rS42;
  double rD42;



};

Coef_recp_rSrD42 Coef_recp_rSrD42_i_0(0);
Coef_recp_rSrD42 Coef_recp_rSrD42_i_1(1);
Coef_recp_rSrD42 Coef_recp_rSrD42_i_2(2);

// -------------------------------------------------------------



// ---- Coef_C4_h ---------------------------------------------

class Coef_C4_h : public CoefObject
{
  int phase_num;
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_C4_h(void);
  ~Coef_C4_h(void);




};

Coef_C4_h Coef_C4_h_i_0(0);
Coef_C4_h Coef_C4_h_i_1(1);
Coef_C4_h Coef_C4_h_i_2(2);

// -------------------------------------------------------------


// ---- Coef_C41_h ---------------------------------------------

class Coef_C41_h : public CoefObject
{
  int phase_num;
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_C41_h(void);
  ~Coef_C41_h(void);




};

Coef_C41_h Coef_C41_h_i_0(0);
Coef_C41_h Coef_C41_h_i_1(1);
Coef_C41_h Coef_C41_h_i_2(2);

// -------------------------------------------------------------


// ---- Coef_C42_h ---------------------------------------------

class Coef_C42_h : public CoefObject
{
  int phase_num;
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_C42_h(void);
  ~Coef_C42_h(void);




};

Coef_C42_h Coef_C42_h_i_0(0);
Coef_C42_h Coef_C42_h_i_1(1);
Coef_C42_h Coef_C42_h_i_2(2);

// -------------------------------------------------------------



// ---- Coef_v41_v44_h_prev_C4 ---------------------------------

class Coef_v41_v44_h_prev_C4 : public CoefObject
{
  int phase_num;
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_v41_v44_h_prev_C4(void);
  ~Coef_v41_v44_h_prev_C4(void);
  double v41_;
  double v44_;
	  // When "trapezoilal" pass is run...
  double i4_;


};

Coef_v41_v44_h_prev_C4 Coef_v41_v44_h_prev_C4_i_0(0);
Coef_v41_v44_h_prev_C4 Coef_v41_v44_h_prev_C4_i_1(1);
Coef_v41_v44_h_prev_C4 Coef_v41_v44_h_prev_C4_i_2(2);

// -------------------------------------------------------------


// ---- Coef_v34_v41_h_prev_C41 --------------------------------

class Coef_v34_v41_h_prev_C41: public CoefObject
{
  int phase_num;
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_v34_v41_h_prev_C41(void);
  ~Coef_v34_v41_h_prev_C41(void);
  double v34_;
  double v41_;
	  // When "trapezoilal" pass is run...
  double i4ct_;



};

Coef_v34_v41_h_prev_C41 Coef_v34_v41_h_prev_C41_i_0(0);
Coef_v34_v41_h_prev_C41 Coef_v34_v41_h_prev_C41_i_1(1);
Coef_v34_v41_h_prev_C41 Coef_v34_v41_h_prev_C41_i_2(2);

// -------------------------------------------------------------


// ---- Coef_v44_v34_h_prev_C42 --------------------------------

class Coef_v44_v34_h_prev_C42 : public CoefObject
{
  int phase_num;
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_v44_v34_h_prev_C42(void);
  ~Coef_v44_v34_h_prev_C42(void);
  double v44_;
  double v34_;
	  // When "trapezoilal" pass is run...
  double i4cb_;


};

Coef_v44_v34_h_prev_C42 Coef_v44_v34_h_prev_C42_i_0(0);
Coef_v44_v34_h_prev_C42 Coef_v44_v34_h_prev_C42_i_1(1);
Coef_v44_v34_h_prev_C42 Coef_v44_v34_h_prev_C42_i_2(2);

// -------------------------------------------------------------




// ---- Coef_Lp_h ---------------------------------------------

class Coef_Lp_h : public CoefObject
{
  int phase_num;
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_Lp_h(void);
  ~Coef_Lp_h(void);




};

Coef_Lp_h Coef_Lp_h_i_0(0);
Coef_Lp_h Coef_Lp_h_i_1(1);
Coef_Lp_h Coef_Lp_h_i_2(2);

// -------------------------------------------------------------


// ---- Coef_Mpn_h ---------------------------------------------

class Coef_Mpn_h : public CoefObject
{
  int phase_num;
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_Mpn_h(void);
  ~Coef_Mpn_h(void);




};

Coef_Mpn_h Coef_Mpn_h_i_0(0);
Coef_Mpn_h Coef_Mpn_h_i_1(1);
Coef_Mpn_h Coef_Mpn_h_i_2(2);

// -------------------------------------------------------------

// ---- Coef_Mnp_h ---------------------------------------------

class Coef_Mnp_h : public CoefObject
{
  int phase_num;
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_Mnp_h(void);
  ~Coef_Mnp_h(void);




};

Coef_Mnp_h Coef_Mnp_h_i_0(0);
Coef_Mnp_h Coef_Mnp_h_i_1(1);
Coef_Mnp_h Coef_Mnp_h_i_2(2);

// ------------------------------------------------------------

// ---- Coef_Ln_h ---------------------------------------------

class Coef_Ln_h : public CoefObject
{
  int phase_num;
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_Ln_h(void);
  ~Coef_Ln_h(void);

  


};

Coef_Ln_h Coef_Ln_h_i_0(0);
Coef_Ln_h Coef_Ln_h_i_1(1);
Coef_Ln_h Coef_Ln_h_i_2(2);

// -------------------------------------------------------------


// ---- Coef_iLp_iLn_h_prev_Lp_Mpn -------------------------------------

class Coef_iLp_iLn_h_prev_Lp_Mpn : public CoefObject
{
  int phase_num;
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_iLp_iLn_h_prev_Lp_Mpn(void);
  ~Coef_iLp_iLn_h_prev_Lp_Mpn(void);
  double iLp_;
  double iLn_;
  	  // When "trapezoilal" pass is run...
  double v44_;
  double vs_a_;



};

Coef_iLp_iLn_h_prev_Lp_Mpn Coef_iLp_iLn_h_prev_Lp_Mpn_i_0(0);
Coef_iLp_iLn_h_prev_Lp_Mpn Coef_iLp_iLn_h_prev_Lp_Mpn_i_1(1);
Coef_iLp_iLn_h_prev_Lp_Mpn Coef_iLp_iLn_h_prev_Lp_Mpn_i_2(2);

// -------------------------------------------------------------



// ---- Coef_iLp_iLn_h_prev_Mnp_Ln ------------------------------------

class Coef_iLp_iLn_h_prev_Mnp_Ln : public CoefObject
{
  int phase_num;
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_iLp_iLn_h_prev_Mnp_Ln(void);
  ~Coef_iLp_iLn_h_prev_Mnp_Ln(void);
  double iLp_;
  double iLn_;
  	  // When "trapezoilal" pass is run...
  double vs_a_;
  double v45_;



};

Coef_iLp_iLn_h_prev_Mnp_Ln Coef_iLp_iLn_h_prev_Mnp_Ln_i_0(0);
Coef_iLp_iLn_h_prev_Mnp_Ln Coef_iLp_iLn_h_prev_Mnp_Ln_i_1(1);
Coef_iLp_iLn_h_prev_Mnp_Ln Coef_iLp_iLn_h_prev_Mnp_Ln_i_2(2);

// -------------------------------------------------------------

 

// ---- Coef_ia ---------------------------------------------

class Coef_ia : public CoefObject
{
  int phase_num;
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_ia(void);
  ~Coef_ia(void);
  double ia;
  


};

Coef_ia Coef_ia_i_0(0);
Coef_ia Coef_ia_i_1(1);
Coef_ia Coef_ia_i_2(2);

// -------------------------------------------------------------

// ---- Coef_recp_rSrD51 ---------------------------------------------

class Coef_recp_rSrD51 : public CoefObject
{
  int phase_num;
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_recp_rSrD51(void);
  ~Coef_recp_rSrD51(void);
  double rS51;
  double rD51;



};

Coef_recp_rSrD51 Coef_recp_rSrD51_i_0(0);
Coef_recp_rSrD51 Coef_recp_rSrD51_i_1(1);
Coef_recp_rSrD51 Coef_recp_rSrD51_i_2(2);

// -------------------------------------------------------------

// ---- Coef_recp_rSrD52 ---------------------------------------------

class Coef_recp_rSrD52 : public CoefObject
{
  int phase_num;
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_recp_rSrD52(void);
  ~Coef_recp_rSrD52(void);
  double rS52;
  double rD52;



};

Coef_recp_rSrD52 Coef_recp_rSrD52_i_0(0);
Coef_recp_rSrD52 Coef_recp_rSrD52_i_1(1);
Coef_recp_rSrD52 Coef_recp_rSrD52_i_2(2);

// -------------------------------------------------------------




// ---- Coef_C5_h ---------------------------------------------

class Coef_C5_h : public CoefObject
{
  int phase_num;
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_C5_h(void);
  ~Coef_C5_h(void);




};

Coef_C5_h Coef_C5_h_i_0(0);
Coef_C5_h Coef_C5_h_i_1(1);
Coef_C5_h Coef_C5_h_i_2(2);

// -------------------------------------------------------------


// ---- Coef_C51_h ---------------------------------------------

class Coef_C51_h : public CoefObject
{
  int phase_num;
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_C51_h(void);
  ~Coef_C51_h(void);




};

Coef_C51_h Coef_C51_h_i_0(0);
Coef_C51_h Coef_C51_h_i_1(1);
Coef_C51_h Coef_C51_h_i_2(2);

// -------------------------------------------------------------


// ---- Coef_C52_h ---------------------------------------------

class Coef_C52_h : public CoefObject
{
  int phase_num;
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_C52_h(void);
  ~Coef_C52_h(void);




};

Coef_C52_h Coef_C52_h_i_0(0);
Coef_C52_h Coef_C52_h_i_1(1);
Coef_C52_h Coef_C52_h_i_2(2);

// -------------------------------------------------------------



// ---- Coef_v51_v56_h_prev_C5 ---------------------------------

class Coef_v51_v56_h_prev_C5 : public CoefObject
{
  int phase_num;
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_v51_v56_h_prev_C5(void);
  ~Coef_v51_v56_h_prev_C5(void);
  double v51_;
  double v56_;
  	  // When "trapezoilal" pass is run...
  double i5_;


};

Coef_v51_v56_h_prev_C5 Coef_v51_v56_h_prev_C5_i_0(0);
Coef_v51_v56_h_prev_C5 Coef_v51_v56_h_prev_C5_i_1(1);
Coef_v51_v56_h_prev_C5 Coef_v51_v56_h_prev_C5_i_2(2);

// -------------------------------------------------------------


// ---- Coef_v45_v51_h_prev_C51 --------------------------------

class Coef_v45_v51_h_prev_C51: public CoefObject
{
  int phase_num;
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_v45_v51_h_prev_C51(void);
  ~Coef_v45_v51_h_prev_C51(void);
  double v45_;
  double v51_;
  	  // When "trapezoilal" pass is run...
  double i5ct_;


};

Coef_v45_v51_h_prev_C51 Coef_v45_v51_h_prev_C51_i_0(0);
Coef_v45_v51_h_prev_C51 Coef_v45_v51_h_prev_C51_i_1(1);
Coef_v45_v51_h_prev_C51 Coef_v45_v51_h_prev_C51_i_2(2);

// -------------------------------------------------------------


// ---- Coef_v56_v45_h_prev_C52 --------------------------------

class Coef_v56_v45_h_prev_C52 : public CoefObject
{
  int phase_num;
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_v56_v45_h_prev_C52(void);
  ~Coef_v56_v45_h_prev_C52(void);
  double v56_;
  double v45_;
  	  // When "trapezoilal" pass is run...
  double i5cb_;


};

Coef_v56_v45_h_prev_C52 Coef_v56_v45_h_prev_C52_i_0(0);
Coef_v56_v45_h_prev_C52 Coef_v56_v45_h_prev_C52_i_1(1);
Coef_v56_v45_h_prev_C52 Coef_v56_v45_h_prev_C52_i_2(2);

// -------------------------------------------------------------


// ---- Coef_recp_rSrD61 ---------------------------------------------

class Coef_recp_rSrD61 : public CoefObject
{
  int phase_num;
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_recp_rSrD61(void);
  ~Coef_recp_rSrD61(void);
  double rS61;
  double rD61;



};

Coef_recp_rSrD61 Coef_recp_rSrD61_i_0(0);
Coef_recp_rSrD61 Coef_recp_rSrD61_i_1(1);
Coef_recp_rSrD61 Coef_recp_rSrD61_i_2(2);

// -------------------------------------------------------------

// ---- Coef_recp_rSrD62 ---------------------------------------------

class Coef_recp_rSrD62 : public CoefObject
{
  int phase_num;
public:

  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_recp_rSrD62(void);
  ~Coef_recp_rSrD62(void);
  double rS62;
  double rD62;


};

Coef_recp_rSrD62 Coef_recp_rSrD62_i_0(0);
Coef_recp_rSrD62 Coef_recp_rSrD62_i_1(1);
Coef_recp_rSrD62 Coef_recp_rSrD62_i_2(2);

// -------------------------------------------------------------




// ---- Coef_C6_h ---------------------------------------------

class Coef_C6_h : public CoefObject
{
  int phase_num;
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_C6_h(void);
  ~Coef_C6_h(void);




};

Coef_C6_h Coef_C6_h_i_0(0);
Coef_C6_h Coef_C6_h_i_1(1);
Coef_C6_h Coef_C6_h_i_2(2);

// -------------------------------------------------------------


// ---- Coef_C61_h ---------------------------------------------

class Coef_C61_h : public CoefObject
{
  int phase_num;
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_C61_h(void);
  ~Coef_C61_h(void);




};

Coef_C61_h Coef_C61_h_i_0(0);
Coef_C61_h Coef_C61_h_i_1(1);
Coef_C61_h Coef_C61_h_i_2(2);

// -------------------------------------------------------------


// ---- Coef_C62_h ---------------------------------------------

class Coef_C62_h : public CoefObject
{
  int phase_num;
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_C62_h(void);
  ~Coef_C62_h(void);




};

Coef_C62_h Coef_C62_h_i_0(0);
Coef_C62_h Coef_C62_h_i_1(1);
Coef_C62_h Coef_C62_h_i_2(2);

// -------------------------------------------------------------



// ---- Coef_v61_v67_h_prev_C6 ---------------------------------

class Coef_v61_v67_h_prev_C6 : public CoefObject
{
  int phase_num;
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_v61_v67_h_prev_C6(void);
  ~Coef_v61_v67_h_prev_C6(void);
  double v61_;
  double v67_;
  	  // When "trapezoilal" pass is run...
  double i6_;


};

Coef_v61_v67_h_prev_C6 Coef_v61_v67_h_prev_C6_i_0(0);
Coef_v61_v67_h_prev_C6 Coef_v61_v67_h_prev_C6_i_1(1);
Coef_v61_v67_h_prev_C6 Coef_v61_v67_h_prev_C6_i_2(2);

// -------------------------------------------------------------


// ---- Coef_v56_v61_h_prev_C61 --------------------------------

class Coef_v56_v61_h_prev_C61: public CoefObject
{
  int phase_num;
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_v56_v61_h_prev_C61(void);
  ~Coef_v56_v61_h_prev_C61(void);
  double v56_;
  double v61_;
  	  // When "trapezoilal" pass is run...
  double i6ct_;


};

Coef_v56_v61_h_prev_C61 Coef_v56_v61_h_prev_C61_i_0(0);
Coef_v56_v61_h_prev_C61 Coef_v56_v61_h_prev_C61_i_1(1);
Coef_v56_v61_h_prev_C61 Coef_v56_v61_h_prev_C61_i_2(2);

// -------------------------------------------------------------


// ---- Coef_v67_v56_h_prev_C62 --------------------------------

class Coef_v67_v56_h_prev_C62 : public CoefObject
{
  int phase_num;
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_v67_v56_h_prev_C62(void);
  ~Coef_v67_v56_h_prev_C62(void);
  double v67_;
  double v56_;
  	  // When "trapezoilal" pass is run...
  double i6cb_;


};

Coef_v67_v56_h_prev_C62 Coef_v67_v56_h_prev_C62_i_0(0);
Coef_v67_v56_h_prev_C62 Coef_v67_v56_h_prev_C62_i_1(1);
Coef_v67_v56_h_prev_C62 Coef_v67_v56_h_prev_C62_i_2(2);

// -------------------------------------------------------------



// ---- Coef_recp_rSrD71 ---------------------------------------------

class Coef_recp_rSrD71 : public CoefObject
{
  int phase_num;
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_recp_rSrD71(void);
  ~Coef_recp_rSrD71(void);
  double rS71;
  double rD71;



};

Coef_recp_rSrD71 Coef_recp_rSrD71_i_0(0);
Coef_recp_rSrD71 Coef_recp_rSrD71_i_1(1);
Coef_recp_rSrD71 Coef_recp_rSrD71_i_2(2);

// -------------------------------------------------------------

// ---- Coef_recp_rSrD72 ---------------------------------------------

class Coef_recp_rSrD72 : public CoefObject
{
  int phase_num;
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_recp_rSrD72(void);
  ~Coef_recp_rSrD72(void);
  double rS72;
  double rD72;



};

Coef_recp_rSrD72 Coef_recp_rSrD72_i_0(0);
Coef_recp_rSrD72 Coef_recp_rSrD72_i_1(1);
Coef_recp_rSrD72 Coef_recp_rSrD72_i_2(2);

// -------------------------------------------------------------


// ---- Coef_C7_h ---------------------------------------------

class Coef_C7_h : public CoefObject
{
  int phase_num;
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_C7_h(void);
  ~Coef_C7_h(void);




};

Coef_C7_h Coef_C7_h_i_0(0);
Coef_C7_h Coef_C7_h_i_1(1);
Coef_C7_h Coef_C7_h_i_2(2);

// -------------------------------------------------------------


// ---- Coef_C71_h ---------------------------------------------

class Coef_C71_h : public CoefObject
{
  int phase_num;
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_C71_h(void);
  ~Coef_C71_h(void);




};

Coef_C71_h Coef_C71_h_i_0(0);
Coef_C71_h Coef_C71_h_i_1(1);
Coef_C71_h Coef_C71_h_i_2(2);

// -------------------------------------------------------------


// ---- Coef_C72_h ---------------------------------------------

class Coef_C72_h : public CoefObject
{
  int phase_num;
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_C72_h(void);
  ~Coef_C72_h(void);




};

Coef_C72_h Coef_C72_h_i_0(0);
Coef_C72_h Coef_C72_h_i_1(1);
Coef_C72_h Coef_C72_h_i_2(2);

// -------------------------------------------------------------



// ---- Coef_v71_v78_h_prev_C7 ---------------------------------

class Coef_v71_v78_h_prev_C7 : public CoefObject
{
  int phase_num;
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_v71_v78_h_prev_C7(void);
  ~Coef_v71_v78_h_prev_C7(void);
  double v71_;
  double v78_;
  	  // When "trapezoilal" pass is run...
  double i7_;


};

Coef_v71_v78_h_prev_C7 Coef_v71_v78_h_prev_C7_i_0(0);
Coef_v71_v78_h_prev_C7 Coef_v71_v78_h_prev_C7_i_1(1);
Coef_v71_v78_h_prev_C7 Coef_v71_v78_h_prev_C7_i_2(2);

// -------------------------------------------------------------


// ---- Coef_v67_v71_h_prev_C71 --------------------------------

class Coef_v67_v71_h_prev_C71: public CoefObject
{
  int phase_num;
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_v67_v71_h_prev_C71(void);
  ~Coef_v67_v71_h_prev_C71(void);
  double v67_;
  double v71_;
  	  // When "trapezoilal" pass is run...
  double i7ct_;



};

Coef_v67_v71_h_prev_C71 Coef_v67_v71_h_prev_C71_i_0(0);
Coef_v67_v71_h_prev_C71 Coef_v67_v71_h_prev_C71_i_1(1);
Coef_v67_v71_h_prev_C71 Coef_v67_v71_h_prev_C71_i_2(2);

// -------------------------------------------------------------


// ---- Coef_v78_v67_h_prev_C72 --------------------------------

class Coef_v78_v67_h_prev_C72 : public CoefObject
{
  int phase_num;
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_v78_v67_h_prev_C72(void);
  ~Coef_v78_v67_h_prev_C72(void);
  double v78_;
  double v67_;
  	  // When "trapezoilal" pass is run...
  double i7cb_;


};

Coef_v78_v67_h_prev_C72 Coef_v78_v67_h_prev_C72_i_0(0);
Coef_v78_v67_h_prev_C72 Coef_v78_v67_h_prev_C72_i_1(1);
Coef_v78_v67_h_prev_C72 Coef_v78_v67_h_prev_C72_i_2(2);

// -------------------------------------------------------------



// ---- Coef_recp_rSrD81 ---------------------------------------------

class Coef_recp_rSrD81 : public CoefObject
{
  int phase_num;
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_recp_rSrD81(void);
  ~Coef_recp_rSrD81(void);
  double rS81;
  double rD81;



};

Coef_recp_rSrD81 Coef_recp_rSrD81_i_0(0);
Coef_recp_rSrD81 Coef_recp_rSrD81_i_1(1);
Coef_recp_rSrD81 Coef_recp_rSrD81_i_2(2);

// -------------------------------------------------------------



// ---- Coef_recp_rSrD82 ---------------------------------------------

class Coef_recp_rSrD82 : public CoefObject
{
  int phase_num;
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_recp_rSrD82(void);
  ~Coef_recp_rSrD82(void);
  double rS82;
  double rD82;



};

Coef_recp_rSrD82 Coef_recp_rSrD82_i_0(0);
Coef_recp_rSrD82 Coef_recp_rSrD82_i_1(1);
Coef_recp_rSrD82 Coef_recp_rSrD82_i_2(2);

// -------------------------------------------------------------



// ---- Coef_C8_h ---------------------------------------------

class Coef_C8_h : public CoefObject
{
  int phase_num;
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_C8_h(void);
  ~Coef_C8_h(void);




};

Coef_C8_h Coef_C8_h_i_0(0);
Coef_C8_h Coef_C8_h_i_1(1);
Coef_C8_h Coef_C8_h_i_2(2);

// -------------------------------------------------------------


// ---- Coef_C81_h ---------------------------------------------

class Coef_C81_h : public CoefObject
{
  int phase_num;
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_C81_h(void);
  ~Coef_C81_h(void);




};

Coef_C81_h Coef_C81_h_i_0(0);
Coef_C81_h Coef_C81_h_i_1(1);
Coef_C81_h Coef_C81_h_i_2(2);

// -------------------------------------------------------------


// ---- Coef_C82_h ---------------------------------------------

class Coef_C82_h : public CoefObject
{
  int phase_num;
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_C82_h(void);
  ~Coef_C82_h(void);




};

Coef_C82_h Coef_C82_h_i_0(0);
Coef_C82_h Coef_C82_h_i_1(1);
Coef_C82_h Coef_C82_h_i_2(2);

// -------------------------------------------------------------



// ---- Coef_v81_h_prev_plus_MinusBus_C8 -----------------------

class Coef_v81_h_prev_plus_MinusBus_C8 : public CoefObject
{
  int phase_num;
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_v81_h_prev_plus_MinusBus_C8(void);
  ~Coef_v81_h_prev_plus_MinusBus_C8(void);
  double v81_;
  	  // When "trapezoilal" pass is run...
  double i8_;


};

Coef_v81_h_prev_plus_MinusBus_C8 Coef_v81_h_prev_plus_MinusBus_C8_i_0(0);
Coef_v81_h_prev_plus_MinusBus_C8 Coef_v81_h_prev_plus_MinusBus_C8_i_1(1);
Coef_v81_h_prev_plus_MinusBus_C8 Coef_v81_h_prev_plus_MinusBus_C8_i_2(2);

// -------------------------------------------------------------


// ---- Coef_v78_v81_h_prev_C81 --------------------------------

class Coef_v78_v81_h_prev_C81: public CoefObject
{
  int phase_num;
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_v78_v81_h_prev_C81(void);
  ~Coef_v78_v81_h_prev_C81(void);
  double v78_;
  double v81_;
  	  // When "trapezoilal" pass is run...
  double i8ct_;


};

Coef_v78_v81_h_prev_C81 Coef_v78_v81_h_prev_C81_i_0(0);
Coef_v78_v81_h_prev_C81 Coef_v78_v81_h_prev_C81_i_1(1);
Coef_v78_v81_h_prev_C81 Coef_v78_v81_h_prev_C81_i_2(2);

// -------------------------------------------------------------


// ---- Coef_minus_v78_h_prev_minus_MinusBus_C82 ---------------------

class Coef_minus_v78_h_prev_minus_MinusBus_C82 : public CoefObject
{
  int phase_num;
public:
  virtual void CoefFunction(double recp_h, bool DoTrapezoidal);
  Coef_minus_v78_h_prev_minus_MinusBus_C82(void);
  ~Coef_minus_v78_h_prev_minus_MinusBus_C82(void);
  double v78_;
  	  // When "trapezoilal" pass is run...
  double i8cb_;

};

Coef_minus_v78_h_prev_minus_MinusBus_C82 Coef_minus_v78_h_prev_minus_MinusBus_C82_i_0(0);
Coef_minus_v78_h_prev_minus_MinusBus_C82 Coef_minus_v78_h_prev_minus_MinusBus_C82_i_1(1);
Coef_minus_v78_h_prev_minus_MinusBus_C82 Coef_minus_v78_h_prev_minus_MinusBus_C82_i_2(2);

// -------------------------------------------------------------










CoefObject * CoefObjectList[] = {
				 (CoefObject *)  &Coef_recp_rSrD11_i_0,
				 (CoefObject *)  &Coef_recp_rSrD12_i_0,
				 (CoefObject *)  &Coef_C1_h_i_0,
				 (CoefObject *)  &Coef_C11_h_i_0,
				 (CoefObject *)  &Coef_C12_h_i_0,
				 (CoefObject *)  &Coef_v11_v12_h_prev_C1_i_0,
				 (CoefObject *)  &Coef_minus_v11_h_prev_minus_PlusBus_C11_i_0,
				 (CoefObject *)  &Coef_v12_h_prev_plus_PlusBus_C12_i_0,
				 (CoefObject *)  &Coef_recp_rSrD21_i_0,
				 (CoefObject *)  &Coef_recp_rSrD22_i_0,
				 (CoefObject *)  &Coef_C2_h_i_0,
				 (CoefObject *)  &Coef_C21_h_i_0,
				 (CoefObject *)  &Coef_C22_h_i_0,
				 (CoefObject *)  &Coef_v21_v23_h_prev_C2_i_0,
				 (CoefObject *)  &Coef_v12_v21_h_prev_C21_i_0,
				 (CoefObject *)  &Coef_v23_v12_h_prev_C22_i_0,
				 (CoefObject *)  &Coef_recp_rSrD31_i_0,
				 (CoefObject *)  &Coef_recp_rSrD32_i_0,
				 (CoefObject *)  &Coef_C3_h_i_0,
				 (CoefObject *)  &Coef_C31_h_i_0,
				 (CoefObject *)  &Coef_C32_h_i_0,
				 (CoefObject *)  &Coef_v31_v34_h_prev_C3_i_0,
				 (CoefObject *)  &Coef_v23_v31_h_prev_C31_i_0,
				 (CoefObject *)  &Coef_v34_v23_h_prev_C32_i_0,
				 (CoefObject *)  &Coef_recp_rSrD41_i_0,
				 (CoefObject *)  &Coef_recp_rSrD42_i_0,
				 (CoefObject *)  &Coef_C4_h_i_0,
				 (CoefObject *)  &Coef_C41_h_i_0,
				 (CoefObject *)  &Coef_C42_h_i_0,
				 (CoefObject *)  &Coef_v41_v44_h_prev_C4_i_0,
				 (CoefObject *)  &Coef_v34_v41_h_prev_C41_i_0,
				 (CoefObject *)  &Coef_v44_v34_h_prev_C42_i_0,
				 (CoefObject *)  &Coef_Lp_h_i_0,
				 (CoefObject *)  &Coef_Mpn_h_i_0,
				 (CoefObject *)  &Coef_Mnp_h_i_0,
				 (CoefObject *)  &Coef_Ln_h_i_0,
				 (CoefObject *)  &Coef_iLp_iLn_h_prev_Lp_Mpn_i_0,
				 (CoefObject *)  &Coef_iLp_iLn_h_prev_Mnp_Ln_i_0,
				 (CoefObject *)  &Coef_ia_i_0,
				 (CoefObject *)  &Coef_recp_rSrD51_i_0,
				 (CoefObject *)  &Coef_recp_rSrD52_i_0,
				 (CoefObject *)  &Coef_C5_h_i_0,
				 (CoefObject *)  &Coef_C51_h_i_0,
				 (CoefObject *)  &Coef_C52_h_i_0,
				 (CoefObject *)  &Coef_v51_v56_h_prev_C5_i_0,
				 (CoefObject *)  &Coef_v45_v51_h_prev_C51_i_0,
				 (CoefObject *)  &Coef_v56_v45_h_prev_C52_i_0,
				 (CoefObject *)  &Coef_recp_rSrD61_i_0,
				 (CoefObject *)  &Coef_recp_rSrD62_i_0,
				 (CoefObject *)  &Coef_C6_h_i_0,
				 (CoefObject *)  &Coef_C61_h_i_0,
				 (CoefObject *)  &Coef_C62_h_i_0,
				 (CoefObject *)  &Coef_v61_v67_h_prev_C6_i_0,
				 (CoefObject *)  &Coef_v56_v61_h_prev_C61_i_0,
				 (CoefObject *)  &Coef_v67_v56_h_prev_C62_i_0,
				 (CoefObject *)  &Coef_recp_rSrD71_i_0,
				 (CoefObject *)  &Coef_recp_rSrD72_i_0,
				 (CoefObject *)  &Coef_C7_h_i_0,
				 (CoefObject *)  &Coef_C71_h_i_0,
				 (CoefObject *)  &Coef_C72_h_i_0,
				 (CoefObject *)  &Coef_v71_v78_h_prev_C7_i_0,
				 (CoefObject *)  &Coef_v67_v71_h_prev_C71_i_0,
				 (CoefObject *)  &Coef_v78_v67_h_prev_C72_i_0,
				 (CoefObject *)  &Coef_recp_rSrD81_i_0,
				 (CoefObject *)  &Coef_recp_rSrD82_i_0,
				 (CoefObject *)  &Coef_C8_h_i_0,
				 (CoefObject *)  &Coef_C81_h_i_0,
				 (CoefObject *)  &Coef_C82_h_i_0,
				 (CoefObject *)  &Coef_v81_h_prev_plus_MinusBus_C8_i_0,
				 (CoefObject *)  &Coef_v78_v81_h_prev_C81_i_0,
				 (CoefObject *)  &Coef_minus_v78_h_prev_minus_MinusBus_C82_i_0,

				 (CoefObject *)  &Coef_recp_rSrD11_i_1,
				 (CoefObject *)  &Coef_recp_rSrD12_i_1,
				 (CoefObject *)  &Coef_C1_h_i_1,
				 (CoefObject *)  &Coef_C11_h_i_1,
				 (CoefObject *)  &Coef_C12_h_i_1,
				 (CoefObject *)  &Coef_v11_v12_h_prev_C1_i_1,
				 (CoefObject *)  &Coef_minus_v11_h_prev_minus_PlusBus_C11_i_1,
				 (CoefObject *)  &Coef_v12_h_prev_plus_PlusBus_C12_i_1,
				 (CoefObject *)  &Coef_recp_rSrD21_i_1,
				 (CoefObject *)  &Coef_recp_rSrD22_i_1,
				 (CoefObject *)  &Coef_C2_h_i_1,
				 (CoefObject *)  &Coef_C21_h_i_1,
				 (CoefObject *)  &Coef_C22_h_i_1,
				 (CoefObject *)  &Coef_v21_v23_h_prev_C2_i_1,
				 (CoefObject *)  &Coef_v12_v21_h_prev_C21_i_1,
				 (CoefObject *)  &Coef_v23_v12_h_prev_C22_i_1,
				 (CoefObject *)  &Coef_recp_rSrD31_i_1,
				 (CoefObject *)  &Coef_recp_rSrD32_i_1,
				 (CoefObject *)  &Coef_C3_h_i_1,
				 (CoefObject *)  &Coef_C31_h_i_1,
				 (CoefObject *)  &Coef_C32_h_i_1,
				 (CoefObject *)  &Coef_v31_v34_h_prev_C3_i_1,
				 (CoefObject *)  &Coef_v23_v31_h_prev_C31_i_1,
				 (CoefObject *)  &Coef_v34_v23_h_prev_C32_i_1,
				 (CoefObject *)  &Coef_recp_rSrD41_i_1,
				 (CoefObject *)  &Coef_recp_rSrD42_i_1,
				 (CoefObject *)  &Coef_C4_h_i_1,
				 (CoefObject *)  &Coef_C41_h_i_1,
				 (CoefObject *)  &Coef_C42_h_i_1,
				 (CoefObject *)  &Coef_v41_v44_h_prev_C4_i_1,
				 (CoefObject *)  &Coef_v34_v41_h_prev_C41_i_1,
				 (CoefObject *)  &Coef_v44_v34_h_prev_C42_i_1,
				 (CoefObject *)  &Coef_Lp_h_i_1,
				 (CoefObject *)  &Coef_Mpn_h_i_1,
				 (CoefObject *)  &Coef_Mnp_h_i_1,
				 (CoefObject *)  &Coef_Ln_h_i_1,
				 (CoefObject *)  &Coef_iLp_iLn_h_prev_Lp_Mpn_i_1,
				 (CoefObject *)  &Coef_iLp_iLn_h_prev_Mnp_Ln_i_1,
				 (CoefObject *)  &Coef_ia_i_1,
				 (CoefObject *)  &Coef_recp_rSrD51_i_1,
				 (CoefObject *)  &Coef_recp_rSrD52_i_1,
				 (CoefObject *)  &Coef_C5_h_i_1,
				 (CoefObject *)  &Coef_C51_h_i_1,
				 (CoefObject *)  &Coef_C52_h_i_1,
				 (CoefObject *)  &Coef_v51_v56_h_prev_C5_i_1,
				 (CoefObject *)  &Coef_v45_v51_h_prev_C51_i_1,
				 (CoefObject *)  &Coef_v56_v45_h_prev_C52_i_1,
				 (CoefObject *)  &Coef_recp_rSrD61_i_1,
				 (CoefObject *)  &Coef_recp_rSrD62_i_1,
				 (CoefObject *)  &Coef_C6_h_i_1,
				 (CoefObject *)  &Coef_C61_h_i_1,
				 (CoefObject *)  &Coef_C62_h_i_1,
				 (CoefObject *)  &Coef_v61_v67_h_prev_C6_i_1,
				 (CoefObject *)  &Coef_v56_v61_h_prev_C61_i_1,
				 (CoefObject *)  &Coef_v67_v56_h_prev_C62_i_1,
				 (CoefObject *)  &Coef_recp_rSrD71_i_1,
				 (CoefObject *)  &Coef_recp_rSrD72_i_1,
				 (CoefObject *)  &Coef_C7_h_i_1,
				 (CoefObject *)  &Coef_C71_h_i_1,
				 (CoefObject *)  &Coef_C72_h_i_1,
				 (CoefObject *)  &Coef_v71_v78_h_prev_C7_i_1,
				 (CoefObject *)  &Coef_v67_v71_h_prev_C71_i_1,
				 (CoefObject *)  &Coef_v78_v67_h_prev_C72_i_1,
				 (CoefObject *)  &Coef_recp_rSrD81_i_1,
				 (CoefObject *)  &Coef_recp_rSrD82_i_1,
				 (CoefObject *)  &Coef_C8_h_i_1,
				 (CoefObject *)  &Coef_C81_h_i_1,
				 (CoefObject *)  &Coef_C82_h_i_1,
				 (CoefObject *)  &Coef_v81_h_prev_plus_MinusBus_C8_i_1,
				 (CoefObject *)  &Coef_v78_v81_h_prev_C81_i_1,
				 (CoefObject *)  &Coef_minus_v78_h_prev_minus_MinusBus_C82_i_1,

				 (CoefObject *)  &Coef_recp_rSrD11_i_2,
				 (CoefObject *)  &Coef_recp_rSrD12_i_2,
				 (CoefObject *)  &Coef_C1_h_i_2,
				 (CoefObject *)  &Coef_C11_h_i_2,
				 (CoefObject *)  &Coef_C12_h_i_2,
				 (CoefObject *)  &Coef_v11_v12_h_prev_C1_i_2,
				 (CoefObject *)  &Coef_minus_v11_h_prev_minus_PlusBus_C11_i_2,
				 (CoefObject *)  &Coef_v12_h_prev_plus_PlusBus_C12_i_2,
				 (CoefObject *)  &Coef_recp_rSrD21_i_2,
				 (CoefObject *)  &Coef_recp_rSrD22_i_2,
				 (CoefObject *)  &Coef_C2_h_i_2,
				 (CoefObject *)  &Coef_C21_h_i_2,
				 (CoefObject *)  &Coef_C22_h_i_2,
				 (CoefObject *)  &Coef_v21_v23_h_prev_C2_i_2,
				 (CoefObject *)  &Coef_v12_v21_h_prev_C21_i_2,
				 (CoefObject *)  &Coef_v23_v12_h_prev_C22_i_2,
				 (CoefObject *)  &Coef_recp_rSrD31_i_2,
				 (CoefObject *)  &Coef_recp_rSrD32_i_2,
				 (CoefObject *)  &Coef_C3_h_i_2,
				 (CoefObject *)  &Coef_C31_h_i_2,
				 (CoefObject *)  &Coef_C32_h_i_2,
				 (CoefObject *)  &Coef_v31_v34_h_prev_C3_i_2,
				 (CoefObject *)  &Coef_v23_v31_h_prev_C31_i_2,
				 (CoefObject *)  &Coef_v34_v23_h_prev_C32_i_2,
				 (CoefObject *)  &Coef_recp_rSrD41_i_2,
				 (CoefObject *)  &Coef_recp_rSrD42_i_2,
				 (CoefObject *)  &Coef_C4_h_i_2,
				 (CoefObject *)  &Coef_C41_h_i_2,
				 (CoefObject *)  &Coef_C42_h_i_2,
				 (CoefObject *)  &Coef_v41_v44_h_prev_C4_i_2,
				 (CoefObject *)  &Coef_v34_v41_h_prev_C41_i_2,
				 (CoefObject *)  &Coef_v44_v34_h_prev_C42_i_2,
				 (CoefObject *)  &Coef_Lp_h_i_2,
				 (CoefObject *)  &Coef_Mpn_h_i_2,
				 (CoefObject *)  &Coef_Mnp_h_i_2,
				 (CoefObject *)  &Coef_Ln_h_i_2,
				 (CoefObject *)  &Coef_iLp_iLn_h_prev_Lp_Mpn_i_2,
				 (CoefObject *)  &Coef_iLp_iLn_h_prev_Mnp_Ln_i_2,
				 (CoefObject *)  &Coef_ia_i_2,
				 (CoefObject *)  &Coef_recp_rSrD51_i_2,
				 (CoefObject *)  &Coef_recp_rSrD52_i_2,
				 (CoefObject *)  &Coef_C5_h_i_2,
				 (CoefObject *)  &Coef_C51_h_i_2,
				 (CoefObject *)  &Coef_C52_h_i_2,
				 (CoefObject *)  &Coef_v51_v56_h_prev_C5_i_2,
				 (CoefObject *)  &Coef_v45_v51_h_prev_C51_i_2,
				 (CoefObject *)  &Coef_v56_v45_h_prev_C52_i_2,
				 (CoefObject *)  &Coef_recp_rSrD61_i_2,
				 (CoefObject *)  &Coef_recp_rSrD62_i_2,
				 (CoefObject *)  &Coef_C6_h_i_2,
				 (CoefObject *)  &Coef_C61_h_i_2,
				 (CoefObject *)  &Coef_C62_h_i_2,
				 (CoefObject *)  &Coef_v61_v67_h_prev_C6_i_2,
				 (CoefObject *)  &Coef_v56_v61_h_prev_C61_i_2,
				 (CoefObject *)  &Coef_v67_v56_h_prev_C62_i_2,
				 (CoefObject *)  &Coef_recp_rSrD71_i_2,
				 (CoefObject *)  &Coef_recp_rSrD72_i_2,
				 (CoefObject *)  &Coef_C7_h_i_2,
				 (CoefObject *)  &Coef_C71_h_i_2,
				 (CoefObject *)  &Coef_C72_h_i_2,
				 (CoefObject *)  &Coef_v71_v78_h_prev_C7_i_2,
				 (CoefObject *)  &Coef_v67_v71_h_prev_C71_i_2,
				 (CoefObject *)  &Coef_v78_v67_h_prev_C72_i_2,
				 (CoefObject *)  &Coef_recp_rSrD81_i_2,
				 (CoefObject *)  &Coef_recp_rSrD82_i_2,
				 (CoefObject *)  &Coef_C8_h_i_2,
				 (CoefObject *)  &Coef_C81_h_i_2,
				 (CoefObject *)  &Coef_C82_h_i_2,
				 (CoefObject *)  &Coef_v81_h_prev_plus_MinusBus_C8_i_2,
				 (CoefObject *)  &Coef_v78_v81_h_prev_C81_i_2,
				 (CoefObject *)  &Coef_minus_v78_h_prev_minus_MinusBus_C82_i_2,


				 0};



// ****************************************************************





// **** SwitchObject Classes **************************************

// ---- Switch_rS11 -----------------------------------------------

class Switch_rS11 : public SwitchObject
{
  int phase_num;
public:
  virtual void CoefRValueUpdate(void);
  Switch_rS11(void);
  ~Switch_rS11(void);

};

Switch_rS11 Switch_rS11_i_0(0);
Switch_rS11 Switch_rS11_i_1(1);
Switch_rS11 Switch_rS11_i_2(2);

// ----------------------------------------------------------------


// ---- Switch_rS12 -----------------------------------------------

class Switch_rS12 : public SwitchObject
{
  int phase_num;
public:
  virtual void CoefRValueUpdate(void);
  Switch_rS12(void);
  ~Switch_rS12(void);
};

Switch_rS12 Switch_rS12_i_0(0);
Switch_rS12 Switch_rS12_i_1(1);
Switch_rS12 Switch_rS12_i_2(2);

// ----------------------------------------------------------------


// ---- Switch_rS21 -----------------------------------------------

class Switch_rS21 : public SwitchObject
{
  int phase_num;
public:
  virtual void CoefRValueUpdate(void);
  Switch_rS21(void);
  ~Switch_rS21(void);

};

Switch_rS21 Switch_rS21_i_0(0);
Switch_rS21 Switch_rS21_i_1(1);
Switch_rS21 Switch_rS21_i_2(2);

// ----------------------------------------------------------------


// ---- Switch_rS22 -----------------------------------------------

class Switch_rS22 : public SwitchObject
{
  int phase_num;
public:
  virtual void CoefRValueUpdate(void);
  Switch_rS22(void);
  ~Switch_rS22(void);
};

Switch_rS22 Switch_rS22_i_0(0);
Switch_rS22 Switch_rS22_i_1(1);
Switch_rS22 Switch_rS22_i_2(2);

// ----------------------------------------------------------------


// ---- Switch_rS31 -----------------------------------------------

class Switch_rS31 : public SwitchObject
{
  int phase_num;
public:
  virtual void CoefRValueUpdate(void);
  Switch_rS31(void);
  ~Switch_rS31(void);
};

Switch_rS31 Switch_rS31_i_0(0);
Switch_rS31 Switch_rS31_i_1(1);
Switch_rS31 Switch_rS31_i_2(2);

// ----------------------------------------------------------------


// ---- Switch_rS32 -----------------------------------------------

class Switch_rS32 : public SwitchObject
{
  int phase_num;
public:
  virtual void CoefRValueUpdate(void);
  Switch_rS32(void);
  ~Switch_rS32(void);
};

Switch_rS32 Switch_rS32_i_0(0);
Switch_rS32 Switch_rS32_i_1(1);
Switch_rS32 Switch_rS32_i_2(2);

// ----------------------------------------------------------------


// ---- Switch_rS41 -----------------------------------------------

class Switch_rS41 : public SwitchObject
{
  int phase_num;
public:
  virtual void CoefRValueUpdate(void);
  Switch_rS41(void);
  ~Switch_rS41(void);
};

Switch_rS41 Switch_rS41_i_0(0);
Switch_rS41 Switch_rS41_i_1(1);
Switch_rS41 Switch_rS41_i_2(2);

// ----------------------------------------------------------------


// ---- Switch_rS42 -----------------------------------------------

class Switch_rS42 : public SwitchObject
{
  int phase_num;
public:
  virtual void CoefRValueUpdate(void);
  Switch_rS42(void);
  ~Switch_rS42(void);

};

Switch_rS42 Switch_rS42_i_0(0);
Switch_rS42 Switch_rS42_i_1(1);
Switch_rS42 Switch_rS42_i_2(2);

// ----------------------------------------------------------------


// ---- Switch_rS51 -----------------------------------------------

class Switch_rS51 : public SwitchObject
{
  int phase_num;
public:
  virtual void CoefRValueUpdate(void);
  Switch_rS51(void);
  ~Switch_rS51(void);

};

Switch_rS51 Switch_rS51_i_0(0);
Switch_rS51 Switch_rS51_i_1(1);
Switch_rS51 Switch_rS51_i_2(2);


// ----------------------------------------------------------------


// ---- Switch_rS52 -----------------------------------------------

class Switch_rS52 : public SwitchObject
{
  int phase_num;
public:
  virtual void CoefRValueUpdate(void);
  Switch_rS52(void);
  ~Switch_rS52(void);
};

Switch_rS52 Switch_rS52_i_0(0);
Switch_rS52 Switch_rS52_i_1(1);
Switch_rS52 Switch_rS52_i_2(2);

// ----------------------------------------------------------------


// ---- Switch_rS61 -----------------------------------------------

class Switch_rS61 : public SwitchObject
{
  int phase_num;
public:
  virtual void CoefRValueUpdate(void);
  Switch_rS61(void);
  ~Switch_rS61(void);
};

Switch_rS61 Switch_rS61_i_0(0);
Switch_rS61 Switch_rS61_i_1(1);
Switch_rS61 Switch_rS61_i_2(2);

// ----------------------------------------------------------------


// ---- Switch_rS62 -----------------------------------------------

class Switch_rS62 : public SwitchObject
{
  int phase_num;
public:
  virtual void CoefRValueUpdate(void);
  Switch_rS62(void);
  ~Switch_rS62(void);
};

Switch_rS62 Switch_rS62_i_0(0);
Switch_rS62 Switch_rS62_i_1(1);
Switch_rS62 Switch_rS62_i_2(2);

// ----------------------------------------------------------------


// ---- Switch_rS71 -----------------------------------------------

class Switch_rS71 : public SwitchObject
{
  int phase_num;
public:
  virtual void CoefRValueUpdate(void);
  Switch_rS71(void);
  ~Switch_rS71(void);

};

Switch_rS71 Switch_rS71_i_0(0);
Switch_rS71 Switch_rS71_i_1(1);
Switch_rS71 Switch_rS71_i_2(2);

// ----------------------------------------------------------------


// ---- Switch_rS72 -----------------------------------------------

class Switch_rS72 : public SwitchObject
{
  int phase_num;
public:
  virtual void CoefRValueUpdate(void);
  Switch_rS72(void);
  ~Switch_rS72(void);
};

Switch_rS72 Switch_rS72_i_0(0);
Switch_rS72 Switch_rS72_i_1(1);
Switch_rS72 Switch_rS72_i_2(2);

// ----------------------------------------------------------------

// ---- Switch_rS81 -----------------------------------------------

class Switch_rS81 : public SwitchObject
{
  int phase_num;
public:
  virtual void CoefRValueUpdate(void);
  Switch_rS81(void);
  ~Switch_rS81(void);

};

Switch_rS81 Switch_rS81_i_0(0);
Switch_rS81 Switch_rS81_i_1(1);
Switch_rS81 Switch_rS81_i_2(2);

// ----------------------------------------------------------------


// ---- Switch_rS82 -----------------------------------------------

class Switch_rS82 : public SwitchObject
{
  int phase_num;
public:
  virtual void CoefRValueUpdate(void);
  Switch_rS82(void);
  ~Switch_rS82(void);

};

Switch_rS82 Switch_rS82_i_0(0);
Switch_rS82 Switch_rS82_i_1(1);
Switch_rS82 Switch_rS82_i_2(2);

// ----------------------------------------------------------------





SwitchObject * SwitchObjectList[] = {
					 (SwitchObject *) &Switch_rS11_i_0,
				     (SwitchObject *) &Switch_rS12_i_0,
				     (SwitchObject *) &Switch_rS21_i_0,
				     (SwitchObject *) &Switch_rS22_i_0,
				     (SwitchObject *) &Switch_rS31_i_0,
				     (SwitchObject *) &Switch_rS32_i_0,
				     (SwitchObject *) &Switch_rS41_i_0,
				     (SwitchObject *) &Switch_rS42_i_0,
				     (SwitchObject *) &Switch_rS51_i_0,
				     (SwitchObject *) &Switch_rS52_i_0,
				     (SwitchObject *) &Switch_rS61_i_0,
				     (SwitchObject *) &Switch_rS62_i_0,
				     (SwitchObject *) &Switch_rS71_i_0,
				     (SwitchObject *) &Switch_rS72_i_0,
				     (SwitchObject *) &Switch_rS81_i_0,
				     (SwitchObject *) &Switch_rS82_i_0,

					 (SwitchObject *) &Switch_rS11_i_1,
				     (SwitchObject *) &Switch_rS12_i_1,
				     (SwitchObject *) &Switch_rS21_i_1,
				     (SwitchObject *) &Switch_rS22_i_1,
				     (SwitchObject *) &Switch_rS31_i_1,
				     (SwitchObject *) &Switch_rS32_i_1,
				     (SwitchObject *) &Switch_rS41_i_1,
				     (SwitchObject *) &Switch_rS42_i_1,
				     (SwitchObject *) &Switch_rS51_i_1,
				     (SwitchObject *) &Switch_rS52_i_1,
				     (SwitchObject *) &Switch_rS61_i_1,
				     (SwitchObject *) &Switch_rS62_i_1,
				     (SwitchObject *) &Switch_rS71_i_1,
				     (SwitchObject *) &Switch_rS72_i_1,
				     (SwitchObject *) &Switch_rS81_i_1,
				     (SwitchObject *) &Switch_rS82_i_1,

					 (SwitchObject *) &Switch_rS11_i_2,
				     (SwitchObject *) &Switch_rS12_i_2,
				     (SwitchObject *) &Switch_rS21_i_2,
				     (SwitchObject *) &Switch_rS22_i_2,
				     (SwitchObject *) &Switch_rS31_i_2,
				     (SwitchObject *) &Switch_rS32_i_2,
				     (SwitchObject *) &Switch_rS41_i_2,
				     (SwitchObject *) &Switch_rS42_i_2,
				     (SwitchObject *) &Switch_rS51_i_2,
				     (SwitchObject *) &Switch_rS52_i_2,
				     (SwitchObject *) &Switch_rS61_i_2,
				     (SwitchObject *) &Switch_rS62_i_2,
				     (SwitchObject *) &Switch_rS71_i_2,
				     (SwitchObject *) &Switch_rS72_i_2,
				     (SwitchObject *) &Switch_rS81_i_2,
				     (SwitchObject *) &Switch_rS82_i_2,


                                     0};



// ****************************************************************



// **** SpiceObject Classes ***************************************

// ---- Spice_MultiLevel ------------------------------------------

class Spice_MultiLevel : public SpiceObject
{
  int phase_num;
public:

  Spice_MultiLevel(void);
  ~Spice_MultiLevel(void);
  virtual void OdeRValueUpdate(void);
  virtual void SwitchRValueUpdate(void);
  virtual void CoefRValueUpdate(void);
  FILE * fp_vs_a_output;

};


Spice_MultiLevel Spice_MultiLevel_i_0(0);
Spice_MultiLevel Spice_MultiLevel_i_1(1);
Spice_MultiLevel Spice_MultiLevel_i_2(2);


// ---------------------------------------------------------------

SpiceObject * SpiceObjectList[] = {
									(SpiceObject *) &Spice_MultiLevel_i_0,
									(SpiceObject *) &Spice_MultiLevel_i_1,
									(SpiceObject *) &Spice_MultiLevel_i_2,
								   0};
				    



// **************************************************************





// **** SrcObject Functions **************************************

// ---- Vm0  ----------------------------------------------------


Vm0::Vm0(void)
{
 
  SrcObjItem * pCurSrcItem;


  SrcFuncName = SRC_FUNC_Vm0;
  LiteralName = "Vm0";

 //build the SRC Rvalue list.

  pSrcObjRValList = new SrcObjItem;
  pCurSrcItem = pSrcObjRValList;


  pCurSrcItem->pSrcObject = SrcObjectList[SRC_FUNC_ECtrl2];
  pCurSrcItem->pNextSrcItem = new SrcObjItem;
  pCurSrcItem = pCurSrcItem->pNextSrcItem;
  pCurSrcItem->pSrcObject = SrcObjectList[SRC_FUNC_ECtrl6];
  pCurSrcItem->pNextSrcItem = new SrcObjItem;
  pCurSrcItem = pCurSrcItem->pNextSrcItem;
  pCurSrcItem->pSrcObject = SrcObjectList[SRC_FUNC_Vref];


  SignalCirculationUpdate = FALSE;


  t_freq_scale = 1.0;
  t_shift = 0;
 
  PwmRampDir = 1.0;


#ifdef PLOT_SRCOBJECT_Vm0
  PlotThisOutput = TRUE;
#endif

  Plot_Tag = "Vm0";
}


Vm0::~Vm0(void)
{



}

void Vm0::SrcFunction(double t)
{
	SignalCirculationUpdate = FALSE;

  t_scaled_shifted = t * t_freq_scale + t_shift;

  if (t_scaled_shifted >= t_prev){

    t_mod += (t_scaled_shifted - t_prev);
    t_prev = t_scaled_shifted;  

    if(t_mod > HALF_PWM_CYCLE){
      t_mod -=  HALF_PWM_CYCLE;
      PwmRampDir *= -1.0;

      if(PwmRampDir > 0)
    	  SignalCirculationUpdate = TRUE;


    }

 
    y = PWM_GAIN*(t_mod/HALF_PWM_CYCLE - .5)*PwmRampDir;

  }

}

void Vm0::SrcRValueUpdate(void)         
{
  SrcObjItem * pCurSrcItem;
 

  //Update Rvalues
  pCurSrcItem = pSrcObjRValList;


  ((ECtrl2 *) pCurSrcItem->pSrcObject)->V_110 = y;
  pCurSrcItem = pCurSrcItem->pNextSrcItem;
  ((ECtrl6 *) pCurSrcItem->pSrcObject)->V_110 = y;
  pCurSrcItem = pCurSrcItem->pNextSrcItem;
  ((Vref *) pCurSrcItem->pSrcObject)->SignalCirculationUpdate = SignalCirculationUpdate;

}

// -----------------------------------------------------------------

// ---- Vm1  ----------------------------------------------------

Vm1::Vm1(void)
{
 
  SrcObjItem * pCurSrcItem;


  SrcFuncName = SRC_FUNC_Vm1;
  LiteralName = "Vm1";

 //build the SRC Rvalue list.

  pSrcObjRValList = new SrcObjItem;
  pCurSrcItem = pSrcObjRValList;

  pCurSrcItem->pSrcObject = SrcObjectList[SRC_FUNC_ECtrl1];
  pCurSrcItem->pNextSrcItem = new SrcObjItem;
  pCurSrcItem = pCurSrcItem->pNextSrcItem;
  pCurSrcItem->pSrcObject = SrcObjectList[SRC_FUNC_ECtrl5];

  t_freq_scale = 1.0;
  t_shift = HALF_PWM_CYCLE/2.0 ;

 
  PwmRampDir = 1.0;
  PwmRampDir_omega = 1.0;

  OmegaCtrl = FALSE;
  t_shift_omega = (HALF_PWM_CYCLE/2.0) * OMEGA_CTRL_FACTOR;

#ifdef PLOT_SRCOBJECT_Vm1 
  PlotThisOutput = TRUE;
#endif 

  Plot_Tag = "Vm1";
}


Vm1::~Vm1(void)
{


}

void Vm1::SrcFunction(double t)
{
  t_scaled_shifted = t * t_freq_scale + t_shift;

  if (t_scaled_shifted >= t_prev){

    t_mod += (t_scaled_shifted - t_prev);
    t_prev = t_scaled_shifted;  

    if(t_mod > HALF_PWM_CYCLE){
      t_mod -=  HALF_PWM_CYCLE;
      PwmRampDir *= -1.0;
    }
 
  }

#ifdef ENABLE_OMEGA_CTRL

    t_scaled_shifted_omega = t * t_freq_scale + t_shift_omega;

    if (t_scaled_shifted_omega >= t_prev_omega){

      t_mod_omega += (t_scaled_shifted_omega - t_prev_omega);
      t_prev_omega = t_scaled_shifted_omega;

      if(t_mod_omega > HALF_PWM_CYCLE){
        t_mod_omega -=  HALF_PWM_CYCLE;
        PwmRampDir_omega *= -1.0;
      }

    }
#endif

    if(OmegaCtrl)
    	y = PWM_GAIN*(t_mod_omega/HALF_PWM_CYCLE - .5)*PwmRampDir_omega;
    else
    	y = PWM_GAIN*(t_mod/HALF_PWM_CYCLE - .5)*PwmRampDir;



}

void Vm1::SrcRValueUpdate(void)         
{
  SrcObjItem * pCurSrcItem;
 

  //Update Rvalues
  pCurSrcItem = pSrcObjRValList;

  ((ECtrl1 *) pCurSrcItem->pSrcObject)->V_210 = y;
  pCurSrcItem = pCurSrcItem->pNextSrcItem;    
  ((ECtrl5 *) pCurSrcItem->pSrcObject)->V_210 = y;



}


// -----------------------------------------------------------------

// ---- Vm2  ----------------------------------------------------

Vm2::Vm2(void)
{
 
  SrcObjItem * pCurSrcItem;


  SrcFuncName = SRC_FUNC_Vm2;
  LiteralName = "Vm2";

 //build the SRC Rvalue list.

  pSrcObjRValList = new SrcObjItem;
  pCurSrcItem = pSrcObjRValList;

  pCurSrcItem->pSrcObject = SrcObjectList[SRC_FUNC_ECtrl4];
  pCurSrcItem->pNextSrcItem = new SrcObjItem;
  pCurSrcItem = pCurSrcItem->pNextSrcItem;
  pCurSrcItem->pSrcObject = SrcObjectList[SRC_FUNC_ECtrl8];

  t_freq_scale = 1.0;
  t_shift = HALF_PWM_CYCLE;

 
  PwmRampDir = 1.0;
  PwmRampDir_omega = 1.0;

  OmegaCtrl = FALSE;
  t_shift_omega = HALF_PWM_CYCLE * OMEGA_CTRL_FACTOR;

#ifdef PLOT_SRCOBJECT_Vm2
  PlotThisOutput = TRUE;
#endif

  Plot_Tag = "Vm2";
}


Vm2::~Vm2(void)
{



}

void Vm2::SrcFunction(double t)
{
  t_scaled_shifted = t * t_freq_scale + t_shift;

  if (t_scaled_shifted >= t_prev){

    t_mod += (t_scaled_shifted - t_prev);
    t_prev = t_scaled_shifted;  

    if(t_mod > HALF_PWM_CYCLE){
      t_mod -=  HALF_PWM_CYCLE;
      PwmRampDir *= -1.0;
    }
 
  }
#ifdef ENABLE_OMEGA_CTRL

    t_scaled_shifted_omega = t * t_freq_scale + t_shift_omega;

    if (t_scaled_shifted_omega >= t_prev_omega){

      t_mod_omega += (t_scaled_shifted_omega - t_prev_omega);
      t_prev_omega = t_scaled_shifted_omega;

      if(t_mod_omega > HALF_PWM_CYCLE){
        t_mod_omega -=  HALF_PWM_CYCLE;
        PwmRampDir_omega *= -1.0;
      }

    }
#endif

    if(OmegaCtrl)
    	y = PWM_GAIN*(t_mod_omega/HALF_PWM_CYCLE - .5)*PwmRampDir_omega;
    else
    	y = PWM_GAIN*(t_mod/HALF_PWM_CYCLE - .5)*PwmRampDir;



}

void Vm2::SrcRValueUpdate(void)         
{
  SrcObjItem * pCurSrcItem;
 

  //Update Rvalues
  pCurSrcItem = pSrcObjRValList;

  ((ECtrl4 *) pCurSrcItem->pSrcObject)->V_310 = y;
  pCurSrcItem = pCurSrcItem->pNextSrcItem;    
  ((ECtrl8 *) pCurSrcItem->pSrcObject)->V_310 = y;



}


// -----------------------------------------------------------------

// ---- Vm3  ----------------------------------------------------

Vm3::Vm3(void)
{
 
  SrcObjItem * pCurSrcItem;


  SrcFuncName = SRC_FUNC_Vm3;
  LiteralName = "Vm3";

 //build the SRC Rvalue list.

  pSrcObjRValList = new SrcObjItem;
  pCurSrcItem = pSrcObjRValList;

  pCurSrcItem->pSrcObject = SrcObjectList[SRC_FUNC_ECtrl3];
  pCurSrcItem->pNextSrcItem = new SrcObjItem;
  pCurSrcItem = pCurSrcItem->pNextSrcItem;
  pCurSrcItem->pSrcObject = SrcObjectList[SRC_FUNC_ECtrl7];

  t_freq_scale = 1.0;
  t_shift = 3.0*HALF_PWM_CYCLE/2.0;

 
  PwmRampDir = 1.0;
  PwmRampDir_omega = 1.0;

  OmegaCtrl = FALSE;
  t_shift_omega = (3.0*HALF_PWM_CYCLE/2.0) * OMEGA_CTRL_FACTOR;

#ifdef PLOT_SRCOBJECT_Vm3
  PlotThisOutput = TRUE;
#endif

  Plot_Tag = "Vm3";
}


Vm3::~Vm3(void)
{



}

void Vm3::SrcFunction(double t)
{
  t_scaled_shifted = t * t_freq_scale + t_shift;

  if (t_scaled_shifted >= t_prev){

    t_mod += (t_scaled_shifted - t_prev);
    t_prev = t_scaled_shifted;  

    if(t_mod > HALF_PWM_CYCLE){
      t_mod -=  HALF_PWM_CYCLE;
      PwmRampDir *= -1.0;
    }
 
  }
#ifdef ENABLE_OMEGA_CTRL

    t_scaled_shifted_omega = t * t_freq_scale + t_shift_omega;

    if (t_scaled_shifted_omega >= t_prev_omega){

      t_mod_omega += (t_scaled_shifted_omega - t_prev_omega);
      t_prev_omega = t_scaled_shifted_omega;

      if(t_mod_omega > HALF_PWM_CYCLE){
        t_mod_omega -=  HALF_PWM_CYCLE;
        PwmRampDir_omega *= -1.0;
      }

    }
#endif

    if(OmegaCtrl)
    	y = PWM_GAIN*(t_mod_omega/HALF_PWM_CYCLE - .5)*PwmRampDir_omega;
    else
    	y = PWM_GAIN*(t_mod/HALF_PWM_CYCLE - .5)*PwmRampDir;



}

void Vm3::SrcRValueUpdate(void)         
{
  SrcObjItem * pCurSrcItem;
 

  //Update Rvalues
  pCurSrcItem = pSrcObjRValList;

  ((ECtrl3 *) pCurSrcItem->pSrcObject)->V_410 = y;
  pCurSrcItem = pCurSrcItem->pNextSrcItem;    
  ((ECtrl7 *) pCurSrcItem->pSrcObject)->V_410 = y;



}


// -----------------------------------------------------------------




// ---- ECtrl1  ----------------------------------------------------

ECtrl1::ECtrl1(void)
{
  SwitchObjItem * pCurSwitchItem;

  if(phase_num == 0)
  {
	  SrcFuncName = SRC_FUNC_ECtrl1_0;
	  LiteralName = "ECtrl1_0";
  }
  else if(phase_num == 1)
  {
	  SrcFuncName = SRC_FUNC_ECtrl1_1;
	  LiteralName = "ECtrl1_1";

  }
  else
  {
	  SrcFuncName = SRC_FUNC_ECtrl1_2;
	  LiteralName = "ECtrl1_2";

  }

  Time_0 = SWITCH_ENABLE_TIME;
  V_112 = 0;
  V_210 = 0;
  GateCtrl_111 = 0;
  GateCtrl_121 = 0;
  	  //default circulating state for this cell.
  CircState = 0;

 //build the Switch Rvalue list.

  pSwitchObjRValList = new SwitchObjItem;
  pCurSwitchItem = pSwitchObjRValList;

  if(phase_num == 0)
  {
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS11_0];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS12_0];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS21_0];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS22_0];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS31_0];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS32_0];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS41_0];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS42_0];
  }
  else if(phase_num == 1)
  {
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS11_1];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS12_1];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS21_1];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS22_1];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS31_1];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS32_1];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS41_1];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS42_1];

  }
  else
  {
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS11_2];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS12_2];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS21_2];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS22_2];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS31_2];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS32_2];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS41_2];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS42_2];


  }



#ifdef PLOT_SRCOBJECT_PROBES_ECtrl1
#if PLOT_SRCOBJECT_PROBES_PHASE_NUM = 0
  if(phase_num == 0)
	  DoProbes = TRUE;
#elif PLOT_SRCOBJECT_PROBES_PHASE_NUM = 1
  if(phase_num == 1)
	  DoProbes = TRUE;
#else
  if(phase_num == 2)
	  DoProbes = TRUE;
#endif
#endif

}

ECtrl1::~ECtrl1(void)
{



}

void ECtrl1::SrcFunction(double t) 
{

  if(t > Time_0){
    if((V_210 + V_112) > 0){
        GateCtrl_111 = 1;
    }
    else{
        GateCtrl_111 = 0;
    }

    if((-V_210 - V_112) > 0){
      GateCtrl_121 = 1;
    }
    else{
      GateCtrl_121 = 0;
    }
  }
  else{
    GateCtrl_111 = 0;
    GateCtrl_121 = 0;   

  }
     
}

void ECtrl1::RecordProbes(void)
{
  Gate_111.push_back((double) GateCtrl_111);
  Gate_121.push_back((double) GateCtrl_121);
}

void ECtrl1::PlotProbes(Gnuplot & SimuPlot, vector<double> & Plot_t, string TagNamesToPlot[])
{
  int i;

#if PLOT_SRCOBJECT_PROBES_PHASE_NUM = 0
  if(TagNamesToPlot[0] == ""){
    SimuPlot.plot_xy(Plot_t, Gate_111, "Gate_111_0");
    SimuPlot.plot_xy(Plot_t, Gate_121, "Gate_121_0");
  }
  else{
    for(i = 0; i < 20; i++){
      if(TagNamesToPlot[i] == "Gate_111_0"){
	SimuPlot.plot_xy(Plot_t, Gate_111, "Gate_111_0");
      }
      else if(TagNamesToPlot[i] == "Gate_121_0"){
	SimuPlot.plot_xy(Plot_t, Gate_121, "Gate_121_0");
      }
      else if(TagNamesToPlot[i] == ""){
	break;
      }
    }
  }   


#elif PLOT_SRCOBJECT_PROBES_PHASE_NUM = 1
  if(TagNamesToPlot[0] == ""){
    SimuPlot.plot_xy(Plot_t, Gate_111, "Gate_111_1");
    SimuPlot.plot_xy(Plot_t, Gate_121, "Gate_121_1");
  }
  else{
    for(i = 0; i < 20; i++){
      if(TagNamesToPlot[i] == "Gate_111_1"){
	SimuPlot.plot_xy(Plot_t, Gate_111, "Gate_111_1");
      }
      else if(TagNamesToPlot[i] == "Gate_121_1"){
	SimuPlot.plot_xy(Plot_t, Gate_121, "Gate_121_1");
      }
      else if(TagNamesToPlot[i] == ""){
	break;
      }
    }
  }

#else

  if(TagNamesToPlot[0] == ""){
    SimuPlot.plot_xy(Plot_t, Gate_111, "Gate_111_2");
    SimuPlot.plot_xy(Plot_t, Gate_121, "Gate_121_2");
  }
  else{
    for(i = 0; i < 20; i++){
      if(TagNamesToPlot[i] == "Gate_111_2"){
	SimuPlot.plot_xy(Plot_t, Gate_111, "Gate_111_2");
      }
      else if(TagNamesToPlot[i] == "Gate_121_2"){
	SimuPlot.plot_xy(Plot_t, Gate_121, "Gate_121_2");
      }
      else if(TagNamesToPlot[i] == ""){
	break;
      }
    }
  }


#endif


}

void ECtrl1::SwitchRValueUpdate(void)
{
  SwitchObjItem * pCurSwitchItem;

  //Update RValues
  pCurSwitchItem = pSwitchObjRValList;

  if(CircState == 0){((Switch_rS11 *) pCurSwitchItem->pSwitchObject)->DevGate = GateCtrl_111;}
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  if(CircState == 0){((Switch_rS12 *) pCurSwitchItem->pSwitchObject)->DevGate = GateCtrl_121; return;}
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  if(CircState == 1){((Switch_rS21 *) pCurSwitchItem->pSwitchObject)->DevGate = GateCtrl_111;}
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  if(CircState == 1){((Switch_rS22 *) pCurSwitchItem->pSwitchObject)->DevGate = GateCtrl_121; return;}
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  if(CircState == 2){((Switch_rS31 *) pCurSwitchItem->pSwitchObject)->DevGate = GateCtrl_111;}
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  if(CircState == 2){((Switch_rS32 *) pCurSwitchItem->pSwitchObject)->DevGate = GateCtrl_121; return;}
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  if(CircState == 3){((Switch_rS41 *) pCurSwitchItem->pSwitchObject)->DevGate = GateCtrl_111;}
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  if(CircState == 3){((Switch_rS42 *) pCurSwitchItem->pSwitchObject)->DevGate = GateCtrl_121; return;}



}



// -----------------------------------------------------------------






// ---- ECtrl2  ----------------------------------------------------

ECtrl2::ECtrl2(void)
{
  SwitchObjItem * pCurSwitchItem;


  if(phase_num == 0)
  {
	  SrcFuncName = SRC_FUNC_ECtrl2_0;
	  LiteralName = "ECtrl2_0";
  }
  else if(phase_num == 1)
  {
	  SrcFuncName = SRC_FUNC_ECtrl2_1;
	  LiteralName = "ECtrl2_1";

  }
  else
  {
	  SrcFuncName = SRC_FUNC_ECtrl2_2;
	  LiteralName = "ECtrl2_2";

  }



  Time_0 = SWITCH_ENABLE_TIME;
  V_112 = 0;
  V_110 = 0;
  GateCtrl_211 = 0;
  GateCtrl_221 = 0;
	 //default circulating state for this cell.
  CircState = 1;

 //build the Switch Rvalue list.

  pSwitchObjRValList = new SwitchObjItem;
  pCurSwitchItem = pSwitchObjRValList;

  if(phase_num == 0)
  {

	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS11_0];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS12_0];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS21_0];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS22_0];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS31_0];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS32_0];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS41_0];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS42_0];
  }
  else if(phase_num == 1)
  {

	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS11_1];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS12_1];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS21_1];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS22_1];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS31_1];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS32_1];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS41_1];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS42_1];
  }
  else
  {
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS11_2];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS12_12;
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS21_2];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS22_2];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS31_2];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS32_2];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS41_2];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS42_2];

  }




#ifdef PLOT_SRCOBJECT_PROBES_ECtrl2
#if PLOT_SRCOBJECT_PROBES_PHASE_NUM = 0
  if(phase_num == 0)
	  DoProbes = TRUE;
#elif PLOT_SRCOBJECT_PROBES_PHASE_NUM = 1
  if(phase_num == 1)
	  DoProbes = TRUE;
#else
  if(phase_num == 2)
	  DoProbes = TRUE;
#endif
#endif

}

ECtrl2::~ECtrl2(void)
{



}

void ECtrl2::SrcFunction(double t)
{

  if(t > Time_0){
    if((V_110 + V_112) > 0){
        GateCtrl_211 = 1;
    }
    else{
        GateCtrl_211 = 0;
    }

    if((-V_110 - V_112) > 0){
      GateCtrl_221 = 1;
    }
    else{
      GateCtrl_221 = 0;
    }
  }
  else{
    GateCtrl_211 = 0;
    GateCtrl_221 = 0;    

  }

}

void ECtrl2::RecordProbes(void)
{
  Gate_211.push_back((double) GateCtrl_211);
  Gate_221.push_back((double) GateCtrl_221);
}

void ECtrl2::PlotProbes(Gnuplot & SimuPlot, vector<double> & Plot_t, string TagNamesToPlot[])
{
  int i;

#if PLOT_SRCOBJECT_PROBES_PHASE_NUM = 0
  if(TagNamesToPlot[0] == ""){
    SimuPlot.plot_xy(Plot_t, Gate_211, "Gate_211_0");
    SimuPlot.plot_xy(Plot_t, Gate_221, "Gate_221_0");
  }
  else{
    for(i = 0; i < 20; i++){
      if(TagNamesToPlot[i] == "Gate_211_0"){
	SimuPlot.plot_xy(Plot_t, Gate_211, "Gate_211_0");
      }
      else if(TagNamesToPlot[i] == "Gate_221_0"){
	SimuPlot.plot_xy(Plot_t, Gate_221, "Gate_221_0");
      }
      else if(TagNamesToPlot[i] == ""){
	break;
      }
    }
  }   

#elif PLOT_SRCOBJECT_PROBES_PHASE_NUM = 1
  if(TagNamesToPlot[0] == ""){
     SimuPlot.plot_xy(Plot_t, Gate_211, "Gate_211_1");
     SimuPlot.plot_xy(Plot_t, Gate_221, "Gate_221_1");
   }
   else{
     for(i = 0; i < 20; i++){
       if(TagNamesToPlot[i] == "Gate_211_1"){
 	SimuPlot.plot_xy(Plot_t, Gate_211, "Gate_211_1");
       }
       else if(TagNamesToPlot[i] == "Gate_221_1"){
 	SimuPlot.plot_xy(Plot_t, Gate_221, "Gate_221_1");
       }
       else if(TagNamesToPlot[i] == ""){
 	break;
       }
     }
   }

#else
  if(TagNamesToPlot[0] == ""){
     SimuPlot.plot_xy(Plot_t, Gate_211, "Gate_211_2");
     SimuPlot.plot_xy(Plot_t, Gate_221, "Gate_221_2");
   }
   else{
     for(i = 0; i < 20; i++){
       if(TagNamesToPlot[i] == "Gate_211_2"){
 	SimuPlot.plot_xy(Plot_t, Gate_211, "Gate_211_2");
       }
       else if(TagNamesToPlot[i] == "Gate_221_2"){
 	SimuPlot.plot_xy(Plot_t, Gate_221, "Gate_221_2");
       }
       else if(TagNamesToPlot[i] == ""){
 	break;
       }
     }
   }

#endif

}

void ECtrl2::SwitchRValueUpdate(void)
{
  SwitchObjItem * pCurSwitchItem;

  //Update RValues
  pCurSwitchItem = pSwitchObjRValList;

  if(CircState == 0){((Switch_rS11 *) pCurSwitchItem->pSwitchObject)->DevGate = GateCtrl_211;}
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  if(CircState == 0){((Switch_rS12 *) pCurSwitchItem->pSwitchObject)->DevGate = GateCtrl_221; return;}
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  if(CircState == 1){((Switch_rS21 *) pCurSwitchItem->pSwitchObject)->DevGate = GateCtrl_211;}
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  if(CircState == 1){((Switch_rS22 *) pCurSwitchItem->pSwitchObject)->DevGate = GateCtrl_221; return;}
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  if(CircState == 2){((Switch_rS31 *) pCurSwitchItem->pSwitchObject)->DevGate = GateCtrl_211;}
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  if(CircState == 2){((Switch_rS32 *) pCurSwitchItem->pSwitchObject)->DevGate = GateCtrl_221; return;}
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  if(CircState == 3){((Switch_rS41 *) pCurSwitchItem->pSwitchObject)->DevGate = GateCtrl_211;}
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  if(CircState == 3){((Switch_rS42 *) pCurSwitchItem->pSwitchObject)->DevGate = GateCtrl_221; return;}

}




// -----------------------------------------------------------------

// ---- ECtrl3  ----------------------------------------------------

ECtrl3::ECtrl3(void)
{
  SwitchObjItem * pCurSwitchItem;

  if(phase_num == 0)
  {
	  SrcFuncName = SRC_FUNC_ECtrl3_0;
	  LiteralName = "ECtrl3_0";
  }
  else if(phase_num == 1)
  {
	  SrcFuncName = SRC_FUNC_ECtrl3_1;
	  LiteralName = "ECtrl3_1";

  }
  else
  {
	  SrcFuncName = SRC_FUNC_ECtrl3_2;
	  LiteralName = "ECtrl3_2";

  }



  Time_0 = SWITCH_ENABLE_TIME;
  V_112 = 0;
  V_410 = 0;
  GateCtrl_311 = 0;
  GateCtrl_321 = 0;
	 //default circulating state for this cell.
  CircState = 2;

 //build the Switch Rvalue list.

  pSwitchObjRValList = new SwitchObjItem;
  pCurSwitchItem = pSwitchObjRValList;


  if(phase_num == 0)
  {

	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS11_0];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS12_0];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS21_0];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS22_0];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS31_0];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS32_0];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS41_0];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS42_0];
  }
  else if(phase_num == 1)
  {
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS11_1];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS12_1];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS21_1];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS22_1];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS31_1];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS32_1];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS41_1];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS42_1];

  }
  else
  {

	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS11_2];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS12_2];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS21_2];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS22_2];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS31_2];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS32_2];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS41_2];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS42_2];

  }

#ifdef PLOT_SRCOBJECT_PROBES_ECtrl3
#if PLOT_SRCOBJECT_PROBES_PHASE_NUM = 0
  if(phase_num == 0)
	  DoProbes = TRUE;
#elif PLOT_SRCOBJECT_PROBES_PHASE_NUM = 1
  if(phase_num == 1)
	  DoProbes = TRUE;
#else
  if(phase_num == 2)
	  DoProbes = TRUE;
#endif
#endif


}

ECtrl3::~ECtrl3(void)
{



}

void ECtrl3::SrcFunction(double t)
{

  if(t > Time_0){
    if((V_410 + V_112) > 0){
        GateCtrl_311 = 1;
    }
    else{
        GateCtrl_311 = 0;
    }

    if((-V_410 - V_112) > 0){
      GateCtrl_321 = 1;
    }
    else{
      GateCtrl_321 = 0;
    }
  }
  else{
    GateCtrl_311 = 0;
    GateCtrl_321 = 0;    

  }

}

void ECtrl3::RecordProbes(void)
{
  Gate_311.push_back((double) GateCtrl_311);
  Gate_321.push_back((double) GateCtrl_321);
}

void ECtrl3::PlotProbes(Gnuplot & SimuPlot, vector<double> & Plot_t, string TagNamesToPlot[])
{
  int i;

#if PLOT_SRCOBJECT_PROBES_PHASE_NUM = 0

  if(TagNamesToPlot[0] == ""){
    SimuPlot.plot_xy(Plot_t, Gate_311, "Gate_311_0");
    SimuPlot.plot_xy(Plot_t, Gate_321, "Gate_321_0");
  }
  else{
    for(i = 0; i < 20; i++){
      if(TagNamesToPlot[i] == "Gate_311_0"){
	SimuPlot.plot_xy(Plot_t, Gate_311, "Gate_311_0");
      }
      else if(TagNamesToPlot[i] == "Gate_321_0"){
	SimuPlot.plot_xy(Plot_t, Gate_321, "Gate_321_0");
      }
      else if(TagNamesToPlot[i] == ""){
	break;
      }
    }
  }   

#elif PLOT_SRCOBJECT_PROBES_PHASE_NUM = 1

  if(TagNamesToPlot[0] == ""){
    SimuPlot.plot_xy(Plot_t, Gate_311, "Gate_311_1");
    SimuPlot.plot_xy(Plot_t, Gate_321, "Gate_321_1");
  }
  else{
    for(i = 0; i < 20; i++){
      if(TagNamesToPlot[i] == "Gate_311_1"){
	SimuPlot.plot_xy(Plot_t, Gate_311, "Gate_311_1");
      }
      else if(TagNamesToPlot[i] == "Gate_321_1"){
	SimuPlot.plot_xy(Plot_t, Gate_321, "Gate_321_1");
      }
      else if(TagNamesToPlot[i] == ""){
	break;
      }
    }
  }

#else

  if(TagNamesToPlot[0] == ""){
    SimuPlot.plot_xy(Plot_t, Gate_311, "Gate_311_2");
    SimuPlot.plot_xy(Plot_t, Gate_321, "Gate_321_2");
  }
  else{
    for(i = 0; i < 20; i++){
      if(TagNamesToPlot[i] == "Gate_311_2"){
	SimuPlot.plot_xy(Plot_t, Gate_311, "Gate_311_2");
      }
      else if(TagNamesToPlot[i] == "Gate_321_2"){
	SimuPlot.plot_xy(Plot_t, Gate_321, "Gate_321_2");
      }
      else if(TagNamesToPlot[i] == ""){
	break;
      }
    }
  }





#endif


}

void ECtrl3::SwitchRValueUpdate(void)
{
  SwitchObjItem * pCurSwitchItem;

  //Update RValues
  pCurSwitchItem = pSwitchObjRValList;

  if(CircState == 0){((Switch_rS11 *) pCurSwitchItem->pSwitchObject)->DevGate = GateCtrl_311;}
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  if(CircState == 0){((Switch_rS12 *) pCurSwitchItem->pSwitchObject)->DevGate = GateCtrl_321; return;}
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  if(CircState == 1){((Switch_rS21 *) pCurSwitchItem->pSwitchObject)->DevGate = GateCtrl_311;}
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  if(CircState == 1){((Switch_rS22 *) pCurSwitchItem->pSwitchObject)->DevGate = GateCtrl_321; return;}
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  if(CircState == 2){((Switch_rS31 *) pCurSwitchItem->pSwitchObject)->DevGate = GateCtrl_311;}
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  if(CircState == 2){((Switch_rS32 *) pCurSwitchItem->pSwitchObject)->DevGate = GateCtrl_321; return;}
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  if(CircState == 3){((Switch_rS41 *) pCurSwitchItem->pSwitchObject)->DevGate = GateCtrl_311;}
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  if(CircState == 3){((Switch_rS42 *) pCurSwitchItem->pSwitchObject)->DevGate = GateCtrl_321; return;}

}


// -----------------------------------------------------------------

// ---- ECtrl4  ----------------------------------------------------

ECtrl4::ECtrl4(void)
{
  SwitchObjItem * pCurSwitchItem;

  if(phase_num == 0)
   {
 	  SrcFuncName = SRC_FUNC_ECtrl4_0;
 	  LiteralName = "ECtrl4_0";
   }
   else if(phase_num == 1)
   {
 	  SrcFuncName = SRC_FUNC_ECtrl4_1;
 	  LiteralName = "ECtrl4_1";

   }
   else
   {
 	  SrcFuncName = SRC_FUNC_ECtrl4_2;
 	  LiteralName = "ECtrl4_2";

   }


  Time_0 = SWITCH_ENABLE_TIME;
  V_112 = 0;
  V_310 = 0;
  GateCtrl_411 = 0;
  GateCtrl_421 = 0;
	 //default circulating state for this cell.
  CircState = 3;

 //build the Switch Rvalue list.

  pSwitchObjRValList = new SwitchObjItem;
  pCurSwitchItem = pSwitchObjRValList;

  if(phase_num == 0)
  {

	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS11_0];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS12_0];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS21_0];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS22_0];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS31_0];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS32_0];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS41_0];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS42_0];
  }
  else if(phase_num == 1)
  {
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS11_1];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS12_1];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS21_1];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS22_1];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS31_1];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS32_1];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS41_1];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS42_1];


  }
  else
  {

	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS11_2];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS12_2];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS21_2];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS22_2];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS31_2];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS32_2];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS41_2];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS42_2];

  }

#ifdef PLOT_SRCOBJECT_PROBES_ECtrl4
#if PLOT_SRCOBJECT_PROBES_PHASE_NUM = 0
  if(phase_num == 0)
	  DoProbes = TRUE;
#elif PLOT_SRCOBJECT_PROBES_PHASE_NUM = 1
  if(phase_num == 1)
	  DoProbes = TRUE;
#else
  if(phase_num == 2)
	  DoProbes = TRUE;
#endif
#endif


}

ECtrl4::~ECtrl4(void)
{



}

void ECtrl4::SrcFunction(double t)
{

  if(t > Time_0){
    if((V_310 + V_112) > 0){
        GateCtrl_411 = 1;
    }
    else{
        GateCtrl_411 = 0;
    }

    if((-V_310 - V_112) > 0){
      GateCtrl_421 = 1;
    }
    else{
      GateCtrl_421 = 0;
    }
  }
  else{
    GateCtrl_411 = 0;
    GateCtrl_421 = 0;    

  }

}

void ECtrl4::RecordProbes(void)
{
  Gate_411.push_back((double) GateCtrl_411);
  Gate_421.push_back((double) GateCtrl_421);
}

void ECtrl4::PlotProbes(Gnuplot & SimuPlot, vector<double> & Plot_t, string TagNamesToPlot[])
{
  int i;

#if PLOT_SRCOBJECT_PROBES_PHASE_NUM = 0

  if(TagNamesToPlot[0] == ""){
    SimuPlot.plot_xy(Plot_t, Gate_411, "Gate_411_0");
    SimuPlot.plot_xy(Plot_t, Gate_421, "Gate_421_0");
  }
  else{
    for(i = 0; i < 20; i++){
      if(TagNamesToPlot[i] == "Gate_411_0"){
	SimuPlot.plot_xy(Plot_t, Gate_411, "Gate_411_0");
      }
      else if(TagNamesToPlot[i] == "Gate_421_0"){
	SimuPlot.plot_xy(Plot_t, Gate_421, "Gate_421_0");
      }
      else if(TagNamesToPlot[i] == ""){
	break;
      }
    }
  }   

#elif PLOT_SRCOBJECT_PROBES_PHASE_NUM = 1

  if(TagNamesToPlot[0] == ""){
    SimuPlot.plot_xy(Plot_t, Gate_411, "Gate_411_1");
    SimuPlot.plot_xy(Plot_t, Gate_421, "Gate_421_1");
  }
  else{
    for(i = 0; i < 20; i++){
      if(TagNamesToPlot[i] == "Gate_411_1"){
	SimuPlot.plot_xy(Plot_t, Gate_411, "Gate_411_1");
      }
      else if(TagNamesToPlot[i] == "Gate_421_1"){
	SimuPlot.plot_xy(Plot_t, Gate_421, "Gate_421_1");
      }
      else if(TagNamesToPlot[i] == ""){
	break;
      }
    }
  }



#else

  if(TagNamesToPlot[0] == ""){
    SimuPlot.plot_xy(Plot_t, Gate_411, "Gate_411_2");
    SimuPlot.plot_xy(Plot_t, Gate_421, "Gate_421_2");
  }
  else{
    for(i = 0; i < 20; i++){
      if(TagNamesToPlot[i] == "Gate_411_2"){
	SimuPlot.plot_xy(Plot_t, Gate_411, "Gate_411_2");
      }
      else if(TagNamesToPlot[i] == "Gate_421_2"){
	SimuPlot.plot_xy(Plot_t, Gate_421, "Gate_421_2");
      }
      else if(TagNamesToPlot[i] == ""){
	break;
      }
    }
  }


#endif

}

void ECtrl4::SwitchRValueUpdate(void)
{
  SwitchObjItem * pCurSwitchItem;

  //Update RValues
  pCurSwitchItem = pSwitchObjRValList;

  if(CircState == 0){((Switch_rS11 *) pCurSwitchItem->pSwitchObject)->DevGate = GateCtrl_411;}
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  if(CircState == 0){((Switch_rS12 *) pCurSwitchItem->pSwitchObject)->DevGate = GateCtrl_421; return;}
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  if(CircState == 1){((Switch_rS21 *) pCurSwitchItem->pSwitchObject)->DevGate = GateCtrl_411;}
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  if(CircState == 1){((Switch_rS22 *) pCurSwitchItem->pSwitchObject)->DevGate = GateCtrl_421; return;}
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  if(CircState == 2){((Switch_rS31 *) pCurSwitchItem->pSwitchObject)->DevGate = GateCtrl_411;}
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  if(CircState == 2){((Switch_rS32 *) pCurSwitchItem->pSwitchObject)->DevGate = GateCtrl_421; return;}
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  if(CircState == 3){((Switch_rS41 *) pCurSwitchItem->pSwitchObject)->DevGate = GateCtrl_411;}
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  if(CircState == 3){((Switch_rS42 *) pCurSwitchItem->pSwitchObject)->DevGate = GateCtrl_421; return;}

}



// -----------------------------------------------------------------


// ---- ECtrl5  ----------------------------------------------------

ECtrl5::ECtrl5(void)
{
  SwitchObjItem * pCurSwitchItem;

  if(phase_num == 0)
   {
 	  SrcFuncName = SRC_FUNC_ECtrl5_0;
 	  LiteralName = "ECtrl5_0";
   }
   else if(phase_num == 1)
   {
 	  SrcFuncName = SRC_FUNC_ECtrl5_1;
 	  LiteralName = "ECtrl5_1";

   }
   else
   {
 	  SrcFuncName = SRC_FUNC_ECtrl5_2;
 	  LiteralName = "ECtrl5_2";

   }

  Time_0 = SWITCH_ENABLE_TIME;
  V_112 = 0;
  V_210 = 0;
  GateCtrl_511 = 0;
  GateCtrl_521 = 0;
	 //default circulating state for this cell.
  CircState = 0;

 //build the Switch Rvalue list.

  pSwitchObjRValList = new SwitchObjItem;
  pCurSwitchItem = pSwitchObjRValList;

  if(phase_num == 0)
  {

	pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS51_0];
	pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS52_0];
	pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS61_0];
	pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS62_0];
	pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS71_0];
	pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS72_0];
	pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS81_0];
	pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS82_0];

  }
  else if(phase_num == 1)
  {
	pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS51_1];
	pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS52_1];
	pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS61_1];
	pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS62_1];
	pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS71_1];
	pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS72_1];
	pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS81_1];
	pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS82_1];


  }
  else
  {
	pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS51_2];
	pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS52_2];
	pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS61_2];
	pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS62_2];
	pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS71_2];
	pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS72_2];
	pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS81_2];
	pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS82_2];

  }






#ifdef PLOT_SRCOBJECT_PROBES_ECtrl5
#if PLOT_SRCOBJECT_PROBES_PHASE_NUM = 0
  if(phase_num == 0)
	  DoProbes = TRUE;
#elif PLOT_SRCOBJECT_PROBES_PHASE_NUM = 1
  if(phase_num == 1)
	  DoProbes = TRUE;
#else
  if(phase_num == 2)
	  DoProbes = TRUE;
#endif
#endif


}

ECtrl5::~ECtrl5(void)
{



}

void ECtrl5::SrcFunction(double t)
{

  if(t > Time_0){
    if((-V_210 - V_112) > 0){
        GateCtrl_511 = 1;
    }
    else{
        GateCtrl_511 = 0;
    }

    if((V_210 + V_112) > 0){
      GateCtrl_521 = 1;
    }
    else{
      GateCtrl_521 = 0;
    }
  }
  else{
    GateCtrl_511 = 0;
    GateCtrl_521 = 0;    

  }

}

void ECtrl5::RecordProbes(void)
{
  Gate_511.push_back((double) GateCtrl_511);
  Gate_521.push_back((double) GateCtrl_521);
}

void ECtrl5::PlotProbes(Gnuplot & SimuPlot, vector<double> & Plot_t, string TagNamesToPlot[])
{
  int i;

#if PLOT_SRCOBJECT_PROBES_PHASE_NUM = 0

  if(TagNamesToPlot[0] == ""){
    SimuPlot.plot_xy(Plot_t, Gate_511, "Gate_511_0");
    SimuPlot.plot_xy(Plot_t, Gate_521, "Gate_521_0");
  }
  else{
    for(i = 0; i < 20; i++){
      if(TagNamesToPlot[i] == "Gate_511_0"){
	SimuPlot.plot_xy(Plot_t, Gate_511, "Gate_511_0");
      }
      else if(TagNamesToPlot[i] == "Gate_521_0"){
	SimuPlot.plot_xy(Plot_t, Gate_521, "Gate_521_0");
      }
      else if(TagNamesToPlot[i] == ""){
	break;
      }
    }
  }   

#elif PLOT_SRCOBJECT_PROBES_PHASE_NUM = 1

  if(TagNamesToPlot[0] == ""){
    SimuPlot.plot_xy(Plot_t, Gate_511, "Gate_511_1");
    SimuPlot.plot_xy(Plot_t, Gate_521, "Gate_521_1");
  }
  else{
    for(i = 0; i < 20; i++){
      if(TagNamesToPlot[i] == "Gate_511_1"){
	SimuPlot.plot_xy(Plot_t, Gate_511, "Gate_511_1");
      }
      else if(TagNamesToPlot[i] == "Gate_521_1"){
	SimuPlot.plot_xy(Plot_t, Gate_521, "Gate_521_1");
      }
      else if(TagNamesToPlot[i] == ""){
	break;
      }
    }
  }

#else

  if(TagNamesToPlot[0] == ""){
    SimuPlot.plot_xy(Plot_t, Gate_511, "Gate_511_2");
    SimuPlot.plot_xy(Plot_t, Gate_521, "Gate_521_2");
  }
  else{
    for(i = 0; i < 20; i++){
      if(TagNamesToPlot[i] == "Gate_511_2"){
	SimuPlot.plot_xy(Plot_t, Gate_511, "Gate_511_2");
      }
      else if(TagNamesToPlot[i] == "Gate_521_2"){
	SimuPlot.plot_xy(Plot_t, Gate_521, "Gate_521_2");
      }
      else if(TagNamesToPlot[i] == ""){
	break;
      }
    }
  }



#endif




}


void ECtrl5::SwitchRValueUpdate(void)
{
  SwitchObjItem * pCurSwitchItem;

  //Update RValues
  pCurSwitchItem = pSwitchObjRValList;

  if(CircState == 0){((Switch_rS51 *) pCurSwitchItem->pSwitchObject)->DevGate = GateCtrl_511;}
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  if(CircState == 0){((Switch_rS52 *) pCurSwitchItem->pSwitchObject)->DevGate = GateCtrl_521; return;}
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  if(CircState == 1){((Switch_rS61 *) pCurSwitchItem->pSwitchObject)->DevGate = GateCtrl_511;}
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  if(CircState == 1){((Switch_rS62 *) pCurSwitchItem->pSwitchObject)->DevGate = GateCtrl_521; return;}
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  if(CircState == 2){((Switch_rS71 *) pCurSwitchItem->pSwitchObject)->DevGate = GateCtrl_511;}
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  if(CircState == 2){((Switch_rS72 *) pCurSwitchItem->pSwitchObject)->DevGate = GateCtrl_521; return;}
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  if(CircState == 3){((Switch_rS81 *) pCurSwitchItem->pSwitchObject)->DevGate = GateCtrl_511;}
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  if(CircState == 3){((Switch_rS82 *) pCurSwitchItem->pSwitchObject)->DevGate = GateCtrl_521; return;}



}




// -----------------------------------------------------------------


// ---- ECtrl6  ----------------------------------------------------

ECtrl6::ECtrl6(void)
{
  SwitchObjItem * pCurSwitchItem;

  if(phase_num == 0)
   {
 	  SrcFuncName = SRC_FUNC_ECtrl6_0;
 	  LiteralName = "ECtrl6_0";
   }
   else if(phase_num == 1)
   {
 	  SrcFuncName = SRC_FUNC_ECtrl6_1;
 	  LiteralName = "ECtrl6_1";

   }
   else
   {
 	  SrcFuncName = SRC_FUNC_ECtrl6_2;
 	  LiteralName = "ECtrl6_2";

   }

  Time_0 = SWITCH_ENABLE_TIME;
  V_112 = 0;
  V_110 = 0;
  GateCtrl_611 = 0;
  GateCtrl_621 = 0;
	 //default circulating state for this cell.
  CircState = 1;

 //build the Switch Rvalue list.

  pSwitchObjRValList = new SwitchObjItem;
  pCurSwitchItem = pSwitchObjRValList;


  if(phase_num == 0)
  {
	pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS51_0];
	pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS52_0];
	pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS61_0];
	pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS62_0];
	pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS71_0];
	pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS72_0];
	pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS81_0];
	pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS82_0];
  }
  else if(phase_num == 1)
  {
	pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS51_1];
	pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS52_1];
	pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS61_1];
	pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS62_1];
	pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS71_1];
	pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS72_1];
	pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS81_1];
	pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS82_1];

  }
  else
  {

	pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS51_3];
	pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS52_3];
	pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS61_3];
	pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS62_3];
	pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS71_3];
	pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS72_3];
	pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS81_3];
	pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS82_3];



  }


#ifdef PLOT_SRCOBJECT_PROBES_ECtrl6
#if PLOT_SRCOBJECT_PROBES_PHASE_NUM = 0
  if(phase_num == 0)
	  DoProbes = TRUE;
#elif PLOT_SRCOBJECT_PROBES_PHASE_NUM = 1
  if(phase_num == 1)
	  DoProbes = TRUE;
#else
  if(phase_num == 2)
	  DoProbes = TRUE;
#endif
#endif


}

ECtrl6::~ECtrl6(void)
{



}

void ECtrl6::SrcFunction(double t)
{

  if(t > Time_0){
    if((-V_110 - V_112) > 0){
        GateCtrl_611 = 1;
    }
    else{
        GateCtrl_611 = 0;
    }

    if((V_110 + V_112) > 0){
      GateCtrl_621 = 1;
    }
    else{
      GateCtrl_621 = 0;
    }
  }
  else{
    GateCtrl_611 = 0;
    GateCtrl_621 = 0;    

  }

}

void ECtrl6::RecordProbes(void)
{
  Gate_611.push_back((double) GateCtrl_611);
  Gate_621.push_back((double) GateCtrl_621);
}

void ECtrl6::PlotProbes(Gnuplot & SimuPlot, vector<double> & Plot_t, string TagNamesToPlot[])
{
  int i;


#if PLOT_SRCOBJECT_PROBES_PHASE_NUM = 0

  if(TagNamesToPlot[0] == ""){
    SimuPlot.plot_xy(Plot_t, Gate_611, "Gate_611_0");
    SimuPlot.plot_xy(Plot_t, Gate_621, "Gate_621_0");
  }
  else{
    for(i = 0; i < 20; i++){
      if(TagNamesToPlot[i] == "Gate_611_0"){
	SimuPlot.plot_xy(Plot_t, Gate_611, "Gate_611_0");
      }
      else if(TagNamesToPlot[i] == "Gate_621_0"){
	SimuPlot.plot_xy(Plot_t, Gate_621, "Gate_621_0");
      }
      else if(TagNamesToPlot[i] == ""){
	break;
      }
    }
  }   

#elif PLOT_SRCOBJECT_PROBES_PHASE_NUM = 1

  if(TagNamesToPlot[0] == ""){
    SimuPlot.plot_xy(Plot_t, Gate_611, "Gate_611_1");
    SimuPlot.plot_xy(Plot_t, Gate_621, "Gate_621_1");
  }
  else{
    for(i = 0; i < 20; i++){
      if(TagNamesToPlot[i] == "Gate_611_1"){
	SimuPlot.plot_xy(Plot_t, Gate_611, "Gate_611_1");
      }
      else if(TagNamesToPlot[i] == "Gate_621_1"){
	SimuPlot.plot_xy(Plot_t, Gate_621, "Gate_621_1");
      }
      else if(TagNamesToPlot[i] == ""){
	break;
      }
    }
  }



#else
  if(TagNamesToPlot[0] == ""){
    SimuPlot.plot_xy(Plot_t, Gate_611, "Gate_611_2");
    SimuPlot.plot_xy(Plot_t, Gate_621, "Gate_621_2");
  }
  else{
    for(i = 0; i < 20; i++){
      if(TagNamesToPlot[i] == "Gate_611_2"){
	SimuPlot.plot_xy(Plot_t, Gate_611, "Gate_611_2");
      }
      else if(TagNamesToPlot[i] == "Gate_621_2"){
	SimuPlot.plot_xy(Plot_t, Gate_621, "Gate_621_2");
      }
      else if(TagNamesToPlot[i] == ""){
	break;
      }
    }
  }


#endif




}


void ECtrl6::SwitchRValueUpdate(void)
{
  SwitchObjItem * pCurSwitchItem;

  //Update RValues
  pCurSwitchItem = pSwitchObjRValList;

  if(CircState == 0){((Switch_rS51 *) pCurSwitchItem->pSwitchObject)->DevGate = GateCtrl_611;}
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  if(CircState == 0){((Switch_rS52 *) pCurSwitchItem->pSwitchObject)->DevGate = GateCtrl_621; return;}
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  if(CircState == 1){((Switch_rS61 *) pCurSwitchItem->pSwitchObject)->DevGate = GateCtrl_611;}
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  if(CircState == 1){((Switch_rS62 *) pCurSwitchItem->pSwitchObject)->DevGate = GateCtrl_621; return;}
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  if(CircState == 2){((Switch_rS71 *) pCurSwitchItem->pSwitchObject)->DevGate = GateCtrl_611;}
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  if(CircState == 2){((Switch_rS72 *) pCurSwitchItem->pSwitchObject)->DevGate = GateCtrl_621; return;}
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  if(CircState == 3){((Switch_rS81 *) pCurSwitchItem->pSwitchObject)->DevGate = GateCtrl_611;}
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  if(CircState == 3){((Switch_rS82 *) pCurSwitchItem->pSwitchObject)->DevGate = GateCtrl_621; return;}

}




// -----------------------------------------------------------------


// ---- ECtrl7  ----------------------------------------------------

ECtrl7::ECtrl7(void)
{
  SwitchObjItem * pCurSwitchItem;

  if(phase_num == 0)
   {
 	  SrcFuncName = SRC_FUNC_ECtrl7_0;
 	  LiteralName = "ECtrl7_0";
   }
   else if(phase_num == 1)
   {
 	  SrcFuncName = SRC_FUNC_ECtrl7_1;
 	  LiteralName = "ECtrl7_1";

   }
   else
   {
 	  SrcFuncName = SRC_FUNC_ECtrl7_2;
 	  LiteralName = "ECtrl7_2";

   }

  Time_0 = SWITCH_ENABLE_TIME;
  V_112 = 0;
  V_410 = 0;
  GateCtrl_711 = 0;
  GateCtrl_721 = 0;
	 //default circulating state for this cell.
  CircState = 2;

 //build the Switch Rvalue list.

  pSwitchObjRValList = new SwitchObjItem;
  pCurSwitchItem = pSwitchObjRValList;

  if(phase_num == 0)
  {

	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS51_0];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS52_0];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS61_0];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS62_0];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS71_0];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS72_0];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS81_0];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS82_0];
  }
  else if(phase_num == 1)
  {
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS51_1];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS52_1];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS61_1];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS62_1];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS71_1];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS72_1];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS81_1];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS82_1];

  }
  else
  {
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS51_2];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS52_2];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS61_2];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS62_2];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS71_2];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS72_2];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS81_2];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS82_2];


  }




#ifdef PLOT_SRCOBJECT_PROBES_ECtrl7
#if PLOT_SRCOBJECT_PROBES_PHASE_NUM = 0
  if(phase_num == 0)
	  DoProbes = TRUE;
#elif PLOT_SRCOBJECT_PROBES_PHASE_NUM = 1
  if(phase_num == 1)
	  DoProbes = TRUE;
#else
  if(phase_num == 2)
	  DoProbes = TRUE;
#endif
#endif


}

ECtrl7::~ECtrl7(void)
{



}

void ECtrl7::SrcFunction(double t)
{

  if(t > Time_0){
    if((-V_410 - V_112) > 0){
        GateCtrl_711 = 1;
    }
    else{
        GateCtrl_711 = 0;
    }

    if((V_410 + V_112) > 0){
      GateCtrl_721 = 1;
    }
    else{
      GateCtrl_721 = 0;
    }
  }
  else{
    GateCtrl_711 = 0;
    GateCtrl_721 = 0;    

  }

}

void ECtrl7::RecordProbes(void)
{
  Gate_711.push_back((double) GateCtrl_711);
  Gate_721.push_back((double) GateCtrl_721);
}

void ECtrl7::PlotProbes(Gnuplot & SimuPlot, vector<double> & Plot_t, string TagNamesToPlot[])
{
  int i;


#if PLOT_SRCOBJECT_PROBES_PHASE_NUM = 0

  if(TagNamesToPlot[0] == ""){
    SimuPlot.plot_xy(Plot_t, Gate_711, "Gate_711_0");
    SimuPlot.plot_xy(Plot_t, Gate_721, "Gate_721_0");
  }
  else{
    for(i = 0; i < 20; i++){
      if(TagNamesToPlot[i] == "Gate_711_0"){
	SimuPlot.plot_xy(Plot_t, Gate_711, "Gate_711_0");
      }
      else if(TagNamesToPlot[i] == "Gate_721_0"){
	SimuPlot.plot_xy(Plot_t, Gate_721, "Gate_721_0");
      }
      else if(TagNamesToPlot[i] == ""){
	break;
      }
    }
  }   

#elif PLOT_SRCOBJECT_PROBES_PHASE_NUM = 1

  if(TagNamesToPlot[0] == ""){
     SimuPlot.plot_xy(Plot_t, Gate_711, "Gate_711_1");
     SimuPlot.plot_xy(Plot_t, Gate_721, "Gate_721_1");
   }
   else{
     for(i = 0; i < 20; i++){
       if(TagNamesToPlot[i] == "Gate_711_1"){
 	SimuPlot.plot_xy(Plot_t, Gate_711, "Gate_711_1");
       }
       else if(TagNamesToPlot[i] == "Gate_721_1"){
 	SimuPlot.plot_xy(Plot_t, Gate_721, "Gate_721_1");
       }
       else if(TagNamesToPlot[i] == ""){
 	break;
       }
     }
   }


#else
  if(TagNamesToPlot[0] == ""){
     SimuPlot.plot_xy(Plot_t, Gate_711, "Gate_711_2");
     SimuPlot.plot_xy(Plot_t, Gate_721, "Gate_721_2");
   }
   else{
     for(i = 0; i < 20; i++){
       if(TagNamesToPlot[i] == "Gate_711_2"){
 	SimuPlot.plot_xy(Plot_t, Gate_711, "Gate_711_2");
       }
       else if(TagNamesToPlot[i] == "Gate_721_2"){
 	SimuPlot.plot_xy(Plot_t, Gate_721, "Gate_721_2");
       }
       else if(TagNamesToPlot[i] == ""){
 	break;
       }
     }
   }


#endif


}




void ECtrl7::SwitchRValueUpdate(void)
{
  SwitchObjItem * pCurSwitchItem;

  //Update RValues
  pCurSwitchItem = pSwitchObjRValList;

  if(CircState == 0){((Switch_rS51 *) pCurSwitchItem->pSwitchObject)->DevGate = GateCtrl_711;}
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  if(CircState == 0){((Switch_rS52 *) pCurSwitchItem->pSwitchObject)->DevGate = GateCtrl_721; return;}
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  if(CircState == 1){((Switch_rS61 *) pCurSwitchItem->pSwitchObject)->DevGate = GateCtrl_711;}
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  if(CircState == 1){((Switch_rS62 *) pCurSwitchItem->pSwitchObject)->DevGate = GateCtrl_721; return;}
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  if(CircState == 2){((Switch_rS71 *) pCurSwitchItem->pSwitchObject)->DevGate = GateCtrl_711;}
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  if(CircState == 2){((Switch_rS72 *) pCurSwitchItem->pSwitchObject)->DevGate = GateCtrl_721; return;}
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  if(CircState == 3){((Switch_rS81 *) pCurSwitchItem->pSwitchObject)->DevGate = GateCtrl_711;}
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  if(CircState == 3){((Switch_rS82 *) pCurSwitchItem->pSwitchObject)->DevGate = GateCtrl_721; return;}

}




// -----------------------------------------------------------------


// ---- ECtrl8  ----------------------------------------------------

ECtrl8::ECtrl8(void)
{
  SwitchObjItem * pCurSwitchItem;

   if(phase_num == 0)
   {
 	  SrcFuncName = SRC_FUNC_ECtrl8_0;
 	  LiteralName = "ECtrl8_0";
   }
   else if(phase_num == 1)
   {
 	  SrcFuncName = SRC_FUNC_ECtrl8_1;
 	  LiteralName = "ECtrl8_1";

   }
   else
   {
 	  SrcFuncName = SRC_FUNC_ECtrl8_2;
 	  LiteralName = "ECtrl8_2";

   }

  Time_0 = SWITCH_ENABLE_TIME;
  V_112 = 0;
  V_310 = 0;
  GateCtrl_811 = 0;
  GateCtrl_821 = 0;
	 //default circulating state for this cell.
  CircState = 3;

 //build the Switch Rvalue list.

  pSwitchObjRValList = new SwitchObjItem;
  pCurSwitchItem = pSwitchObjRValList;

  if(phase_num == 0)
  {

	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS51_0];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS52_0];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS61_0];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS62_0];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS71_0];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS72_0];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS81_0];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS82_0];

  }
  else if(phase_num == 1)
  {
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS51_1];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS52_1];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS61_1];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS62_1];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS71_1];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS72_1];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS81_1];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS82_1];

  }
  else
  {
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS51_2];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS52_2];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS61_2];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS62_2];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS71_2];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS72_2];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS81_2];
	  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
	  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
	  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS82_2];

  }

#ifdef PLOT_SRCOBJECT_PROBES_ECtrl8
#if PLOT_SRCOBJECT_PROBES_PHASE_NUM = 0
  if(phase_num == 0)
	  DoProbes = TRUE;
#elif PLOT_SRCOBJECT_PROBES_PHASE_NUM = 1
  if(phase_num == 1)
	  DoProbes = TRUE;
#else
  if(phase_num == 2)
	  DoProbes = TRUE;
#endif
#endif


}

ECtrl8::~ECtrl8(void)
{



}

void ECtrl8::SrcFunction(double t)
{

  if(t > Time_0){
    if((-V_310 - V_112) > 0){
        GateCtrl_811 = 1;
    }
    else{
        GateCtrl_811 = 0;
    }

    if((V_310 + V_112) > 0){
      GateCtrl_821 = 1;
    }
    else{
      GateCtrl_821 = 0;
    }
  }
  else{
    GateCtrl_811 = 0;
    GateCtrl_821 = 0;    

  }

}

void ECtrl8::RecordProbes(void)
{
  Gate_811.push_back((double) GateCtrl_811);
  Gate_821.push_back((double) GateCtrl_821);
}

void ECtrl8::PlotProbes(Gnuplot & SimuPlot, vector<double> & Plot_t, string TagNamesToPlot[])
{
  int i;


#if PLOT_SRCOBJECT_PROBES_PHASE_NUM = 0

  if(TagNamesToPlot[0] == ""){
    SimuPlot.plot_xy(Plot_t, Gate_811, "Gate_811_0");
    SimuPlot.plot_xy(Plot_t, Gate_821, "Gate_821_0");
  }
  else{
    for(i = 0; i < 20; i++){
      if(TagNamesToPlot[i] == "Gate_811_0"){
	SimuPlot.plot_xy(Plot_t, Gate_811, "Gate_811_0");
      }
      else if(TagNamesToPlot[i] == "Gate_821_0"){
	SimuPlot.plot_xy(Plot_t, Gate_821, "Gate_821_0");
      }
      else if(TagNamesToPlot[i] == ""){
	break;
      }
    }
  }   

#elif PLOT_SRCOBJECT_PROBES_PHASE_NUM = 1

  if(TagNamesToPlot[0] == ""){
    SimuPlot.plot_xy(Plot_t, Gate_811, "Gate_811_1");
    SimuPlot.plot_xy(Plot_t, Gate_821, "Gate_821_1");
  }
  else{
    for(i = 0; i < 20; i++){
      if(TagNamesToPlot[i] == "Gate_811_1"){
	SimuPlot.plot_xy(Plot_t, Gate_811, "Gate_811_1");
      }
      else if(TagNamesToPlot[i] == "Gate_821_1"){
	SimuPlot.plot_xy(Plot_t, Gate_821, "Gate_821_1");
      }
      else if(TagNamesToPlot[i] == ""){
	break;
      }
    }
  }


#else

  if(TagNamesToPlot[0] == ""){
    SimuPlot.plot_xy(Plot_t, Gate_811, "Gate_811_2");
    SimuPlot.plot_xy(Plot_t, Gate_821, "Gate_821_2");
  }
  else{
    for(i = 0; i < 20; i++){
      if(TagNamesToPlot[i] == "Gate_811_2"){
	SimuPlot.plot_xy(Plot_t, Gate_811, "Gate_811_2");
      }
      else if(TagNamesToPlot[i] == "Gate_821_2"){
	SimuPlot.plot_xy(Plot_t, Gate_821, "Gate_821_2");
      }
      else if(TagNamesToPlot[i] == ""){
	break;
      }
    }
  }


#endif


}





void ECtrl8::SwitchRValueUpdate(void)
{
  SwitchObjItem * pCurSwitchItem;

  //Update RValues
  pCurSwitchItem = pSwitchObjRValList;

  if(CircState == 0){((Switch_rS51 *) pCurSwitchItem->pSwitchObject)->DevGate = GateCtrl_811;}
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  if(CircState == 0){((Switch_rS52 *) pCurSwitchItem->pSwitchObject)->DevGate = GateCtrl_821; return;}
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  if(CircState == 1){((Switch_rS61 *) pCurSwitchItem->pSwitchObject)->DevGate = GateCtrl_811;}
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  if(CircState == 1){((Switch_rS62 *) pCurSwitchItem->pSwitchObject)->DevGate = GateCtrl_821; return;}
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  if(CircState == 2){((Switch_rS71 *) pCurSwitchItem->pSwitchObject)->DevGate = GateCtrl_811;}
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  if(CircState == 2){((Switch_rS72 *) pCurSwitchItem->pSwitchObject)->DevGate = GateCtrl_821; return;}
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  if(CircState == 3){((Switch_rS81 *) pCurSwitchItem->pSwitchObject)->DevGate = GateCtrl_811;}
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  if(CircState == 3){((Switch_rS82 *) pCurSwitchItem->pSwitchObject)->DevGate = GateCtrl_821; return;}

}



// -----------------------------------------------------------------






// ---- Vref  ----------------------------------------------------

Vref::Vref(void)
{
 
  SrcObjItem * pCurSrcItem;

  if(phase_num == 0)
  {
	  SrcFuncName = SRC_FUNC_Vref_0;
	  LiteralName = "Vref_0";
  }
  else if(phase_num == 0)
  {
	  SrcFuncName = SRC_FUNC_Vref_1;
	  LiteralName = "Vref_1";

  }
  else
  {
	  SrcFuncName = SRC_FUNC_Vref_2;
	  LiteralName = "Vref_2";

  }


  //build the SRC Rvalue list.

  pSrcObjRValList = new SrcObjItem;
  pCurSrcItem = pSrcObjRValList;


  if(phase_num == 0)
  {
	  pCurSrcItem->pSrcObject = SrcObjectList[SRC_FUNC_ECtrl1_0];
	  pCurSrcItem->pNextSrcItem = new SrcObjItem;
	  pCurSrcItem = pCurSrcItem->pNextSrcItem;
	  pCurSrcItem->pSrcObject = SrcObjectList[SRC_FUNC_ECtrl2_0];
	  pCurSrcItem->pNextSrcItem = new SrcObjItem;
	  pCurSrcItem = pCurSrcItem->pNextSrcItem;
	  pCurSrcItem->pSrcObject = SrcObjectList[SRC_FUNC_ECtrl3_0];
	  pCurSrcItem->pNextSrcItem = new SrcObjItem;
	  pCurSrcItem = pCurSrcItem->pNextSrcItem;
	  pCurSrcItem->pSrcObject = SrcObjectList[SRC_FUNC_ECtrl4_0];
	  pCurSrcItem->pNextSrcItem = new SrcObjItem;
	  pCurSrcItem = pCurSrcItem->pNextSrcItem;
	  pCurSrcItem->pSrcObject = SrcObjectList[SRC_FUNC_ECtrl5_0];
	  pCurSrcItem->pNextSrcItem = new SrcObjItem;
	  pCurSrcItem = pCurSrcItem->pNextSrcItem;
	  pCurSrcItem->pSrcObject = SrcObjectList[SRC_FUNC_ECtrl6_0];
	  pCurSrcItem->pNextSrcItem = new SrcObjItem;
	  pCurSrcItem = pCurSrcItem->pNextSrcItem;
	  pCurSrcItem->pSrcObject = SrcObjectList[SRC_FUNC_ECtrl7_0];
	  pCurSrcItem->pNextSrcItem = new SrcObjItem;
	  pCurSrcItem = pCurSrcItem->pNextSrcItem;
	  pCurSrcItem->pSrcObject = SrcObjectList[SRC_FUNC_ECtrl8_0];
	  pCurSrcItem->pNextSrcItem = new SrcObjItem;
	  pCurSrcItem = pCurSrcItem->pNextSrcItem;
	  pCurSrcItem->pSrcObject = SrcObjectList[SRC_FUNC_Vm1];
	  pCurSrcItem->pNextSrcItem = new SrcObjItem;
	  pCurSrcItem = pCurSrcItem->pNextSrcItem;
	  pCurSrcItem->pSrcObject = SrcObjectList[SRC_FUNC_Vm2];
	  pCurSrcItem->pNextSrcItem = new SrcObjItem;
	  pCurSrcItem = pCurSrcItem->pNextSrcItem;
	  pCurSrcItem->pSrcObject = SrcObjectList[SRC_FUNC_Vm3];
  }
  else if(phase_num == 1)
  {

	  pCurSrcItem->pSrcObject = SrcObjectList[SRC_FUNC_ECtrl1_1];
	  pCurSrcItem->pNextSrcItem = new SrcObjItem;
	  pCurSrcItem = pCurSrcItem->pNextSrcItem;
	  pCurSrcItem->pSrcObject = SrcObjectList[SRC_FUNC_ECtrl2_1];
	  pCurSrcItem->pNextSrcItem = new SrcObjItem;
	  pCurSrcItem = pCurSrcItem->pNextSrcItem;
	  pCurSrcItem->pSrcObject = SrcObjectList[SRC_FUNC_ECtrl3_1];
	  pCurSrcItem->pNextSrcItem = new SrcObjItem;
	  pCurSrcItem = pCurSrcItem->pNextSrcItem;
	  pCurSrcItem->pSrcObject = SrcObjectList[SRC_FUNC_ECtrl4_1];
	  pCurSrcItem->pNextSrcItem = new SrcObjItem;
	  pCurSrcItem = pCurSrcItem->pNextSrcItem;
	  pCurSrcItem->pSrcObject = SrcObjectList[SRC_FUNC_ECtrl5_1];
	  pCurSrcItem->pNextSrcItem = new SrcObjItem;
	  pCurSrcItem = pCurSrcItem->pNextSrcItem;
	  pCurSrcItem->pSrcObject = SrcObjectList[SRC_FUNC_ECtrl6_1];
	  pCurSrcItem->pNextSrcItem = new SrcObjItem;
	  pCurSrcItem = pCurSrcItem->pNextSrcItem;
	  pCurSrcItem->pSrcObject = SrcObjectList[SRC_FUNC_ECtrl7_1];
	  pCurSrcItem->pNextSrcItem = new SrcObjItem;
	  pCurSrcItem = pCurSrcItem->pNextSrcItem;
	  pCurSrcItem->pSrcObject = SrcObjectList[SRC_FUNC_ECtrl8_1];
	  pCurSrcItem->pNextSrcItem = new SrcObjItem;
	  pCurSrcItem = pCurSrcItem->pNextSrcItem;
	  pCurSrcItem->pSrcObject = SrcObjectList[SRC_FUNC_Vm1];
	  pCurSrcItem->pNextSrcItem = new SrcObjItem;
	  pCurSrcItem = pCurSrcItem->pNextSrcItem;
	  pCurSrcItem->pSrcObject = SrcObjectList[SRC_FUNC_Vm2];
	  pCurSrcItem->pNextSrcItem = new SrcObjItem;
	  pCurSrcItem = pCurSrcItem->pNextSrcItem;
	  pCurSrcItem->pSrcObject = SrcObjectList[SRC_FUNC_Vm3];

  }
  else
  {

	  pCurSrcItem->pSrcObject = SrcObjectList[SRC_FUNC_ECtrl1_2];
	  pCurSrcItem->pNextSrcItem = new SrcObjItem;
	  pCurSrcItem = pCurSrcItem->pNextSrcItem;
	  pCurSrcItem->pSrcObject = SrcObjectList[SRC_FUNC_ECtrl2_2];
	  pCurSrcItem->pNextSrcItem = new SrcObjItem;
	  pCurSrcItem = pCurSrcItem->pNextSrcItem;
	  pCurSrcItem->pSrcObject = SrcObjectList[SRC_FUNC_ECtrl3_2];
	  pCurSrcItem->pNextSrcItem = new SrcObjItem;
	  pCurSrcItem = pCurSrcItem->pNextSrcItem;
	  pCurSrcItem->pSrcObject = SrcObjectList[SRC_FUNC_ECtrl4_2];
	  pCurSrcItem->pNextSrcItem = new SrcObjItem;
	  pCurSrcItem = pCurSrcItem->pNextSrcItem;
	  pCurSrcItem->pSrcObject = SrcObjectList[SRC_FUNC_ECtrl5_2];
	  pCurSrcItem->pNextSrcItem = new SrcObjItem;
	  pCurSrcItem = pCurSrcItem->pNextSrcItem;
	  pCurSrcItem->pSrcObject = SrcObjectList[SRC_FUNC_ECtrl6_2];
	  pCurSrcItem->pNextSrcItem = new SrcObjItem;
	  pCurSrcItem = pCurSrcItem->pNextSrcItem;
	  pCurSrcItem->pSrcObject = SrcObjectList[SRC_FUNC_ECtrl7_2];
	  pCurSrcItem->pNextSrcItem = new SrcObjItem;
	  pCurSrcItem = pCurSrcItem->pNextSrcItem;
	  pCurSrcItem->pSrcObject = SrcObjectList[SRC_FUNC_ECtrl8_2];
	  pCurSrcItem->pNextSrcItem = new SrcObjItem;
	  pCurSrcItem = pCurSrcItem->pNextSrcItem;
	  pCurSrcItem->pSrcObject = SrcObjectList[SRC_FUNC_Vm1];
	  pCurSrcItem->pNextSrcItem = new SrcObjItem;
	  pCurSrcItem = pCurSrcItem->pNextSrcItem;
	  pCurSrcItem->pSrcObject = SrcObjectList[SRC_FUNC_Vm2];
	  pCurSrcItem->pNextSrcItem = new SrcObjItem;
	  pCurSrcItem = pCurSrcItem->pNextSrcItem;
	  pCurSrcItem->pSrcObject = SrcObjectList[SRC_FUNC_Vm3];


  }




  CircStateIndex = 0;
  CircStateRate = 0;

  SignalCirculationUpdate = FALSE;

  OmegaCtrl = FALSE;


#ifdef PLOT_SRCOBJECT_Vref
#if PLOT_SRCOBJECT_PROBES_PHASE_NUM = 0
  if(phase_num == 0)
	  PlotThisOutput = TRUE;
#elif PLOT_SRCOBJECT_PROBES_PHASE_NUM = 1
  if(phase_num == 1)
	  PlotThisOutput = TRUE;
#else
  if(phase_num == 2)
	  PlotThisOutput = TRUE;
#endif
#endif

  Plot_Tag = "Vref";
}

Vref::~Vref(void)
{


}

void Vref::SrcFunction(double t)
{

#ifdef ENABLE_CELL_CIRCULATION

  if(SignalCirculationUpdate == TRUE)
  {

	  if(CircStateRate == CIRCULAR_STATE_RATE)
	  {
		  CircStateIndex = (CircStateIndex + 1) & 0x7;
		  CircStateRate = 0;
	  }
	  else
	  {
		  CircStateRate++;
	  }

  }

#endif





#ifdef ENABLE_OMEGA_CTRL

  	  OmegaCtrl = TRUE;

#endif





#ifdef APPLY_SINEWAVE_VREF_COMMAND
  y = 2 * sin(2*PI*60*t);
#else


  y = V_xo;


#endif 
  
 

}

void Vref::SrcRValueUpdate(void)
{
  SrcObjItem * pCurSrcItem;

  //Update Rvalues
  pCurSrcItem = pSrcObjRValList;

#ifndef ENABLE_CELL_CIRCULATION
  ((ECtrl1 *) pCurSrcItem->pSrcObject)->V_112 = y;
  pCurSrcItem = pCurSrcItem->pNextSrcItem;    
  ((ECtrl2 *) pCurSrcItem->pSrcObject)->V_112 = y;
  pCurSrcItem = pCurSrcItem->pNextSrcItem;    
  ((ECtrl3 *) pCurSrcItem->pSrcObject)->V_112 = y;
  pCurSrcItem = pCurSrcItem->pNextSrcItem;    
  ((ECtrl4 *) pCurSrcItem->pSrcObject)->V_112 = y;
  pCurSrcItem = pCurSrcItem->pNextSrcItem;    
  ((ECtrl5 *) pCurSrcItem->pSrcObject)->V_112 = y;
  pCurSrcItem = pCurSrcItem->pNextSrcItem;    
  ((ECtrl6 *) pCurSrcItem->pSrcObject)->V_112 = y;
  pCurSrcItem = pCurSrcItem->pNextSrcItem;    
  ((ECtrl7 *) pCurSrcItem->pSrcObject)->V_112 = y;
  pCurSrcItem = pCurSrcItem->pNextSrcItem;    
  ((ECtrl8 *) pCurSrcItem->pSrcObject)->V_112 = y;
#ifdef ENABLE_OMEGA_CTRL
  pCurSrcItem = pCurSrcItem->pNextSrcItem;
  ((Vm1 *) pCurSrcItem->pSrcObject)->OmegaCtrl = OmegaCtrl;
  pCurSrcItem = pCurSrcItem->pNextSrcItem;
  ((Vm2 *) pCurSrcItem->pSrcObject)->OmegaCtrl = OmegaCtrl;
  pCurSrcItem = pCurSrcItem->pNextSrcItem;
  ((Vm3 *) pCurSrcItem->pSrcObject)->OmegaCtrl = OmegaCtrl;
#endif

#else

  ((ECtrl1 *) pCurSrcItem->pSrcObject)->V_112 = y;
  ((ECtrl1 *) pCurSrcItem->pSrcObject)->CircState = CircStateTable[CircStateIndex][0];
  pCurSrcItem = pCurSrcItem->pNextSrcItem;
  ((ECtrl2 *) pCurSrcItem->pSrcObject)->V_112 = y;
  ((ECtrl2 *) pCurSrcItem->pSrcObject)->CircState = CircStateTable[CircStateIndex][1];
  pCurSrcItem = pCurSrcItem->pNextSrcItem;
  ((ECtrl3 *) pCurSrcItem->pSrcObject)->V_112 = y;
  ((ECtrl3 *) pCurSrcItem->pSrcObject)->CircState = CircStateTable[CircStateIndex][2];
  pCurSrcItem = pCurSrcItem->pNextSrcItem;
  ((ECtrl4 *) pCurSrcItem->pSrcObject)->V_112 = y;
  ((ECtrl4 *) pCurSrcItem->pSrcObject)->CircState = CircStateTable[CircStateIndex][3];
  pCurSrcItem = pCurSrcItem->pNextSrcItem;
  ((ECtrl5 *) pCurSrcItem->pSrcObject)->V_112 = y;
  ((ECtrl5 *) pCurSrcItem->pSrcObject)->CircState = CircStateTable[CircStateIndex][4];
  pCurSrcItem = pCurSrcItem->pNextSrcItem;
  ((ECtrl6 *) pCurSrcItem->pSrcObject)->V_112 = y;
  ((ECtrl6 *) pCurSrcItem->pSrcObject)->CircState = CircStateTable[CircStateIndex][5];
  pCurSrcItem = pCurSrcItem->pNextSrcItem;
  ((ECtrl7 *) pCurSrcItem->pSrcObject)->V_112 = y;
  ((ECtrl7 *) pCurSrcItem->pSrcObject)->CircState = CircStateTable[CircStateIndex][6];
  pCurSrcItem = pCurSrcItem->pNextSrcItem;
  ((ECtrl8 *) pCurSrcItem->pSrcObject)->V_112 = y;
  ((ECtrl8 *) pCurSrcItem->pSrcObject)->CircState = CircStateTable[CircStateIndex][7];
#ifdef ENABLE_OMEGA_CTRL
  pCurSrcItem = pCurSrcItem->pNextSrcItem;
  ((Vm1 *) pCurSrcItem->pSrcObject)->OmegaCtrl = OmegaCtrl;
  pCurSrcItem = pCurSrcItem->pNextSrcItem;
  ((Vm2 *) pCurSrcItem->pSrcObject)->OmegaCtrl = OmegaCtrl;
  pCurSrcItem = pCurSrcItem->pNextSrcItem;
  ((Vm3 *) pCurSrcItem->pSrcObject)->OmegaCtrl = OmegaCtrl;
#endif

#endif

}




// -----------------------------------------------------------------

// ******************************************************************





// **** OdeObject Functions ****************************************

// ---- Ia_Ib_Ic_1  ----------------------------------------------------

Ia_Ib_Ic_1::Ia_Ib_Ic_1(void)
{
  OdeObjItem * pCurOdeItem;

  OdeFuncName = ODE_FUNC_Ia_Ib_Ic_1;
  LiteralName = "Ia_Ib_Ic_1";


  //this object marks the beginning of a "group solve" of
  //three objects.
  GroupSolve = 1;
  NumberOfGrpOdes = 3;

  //build the ODE Rvalue list.

  pOdeObjRValList = new OdeObjItem;
  pCurOdeItem = pOdeObjRValList;

  pCurOdeItem->pOdeObject = OdeObjectList[ODE_FUNC_Omega];
  pCurOdeItem->pNextOdeItem = new OdeObjItem;
  pCurOdeItem = pCurOdeItem->pNextOdeItem;
  pCurOdeItem->pOdeObject = OdeObjectList[ODE_FUNC_Probe];
  pCurOdeItem->pNextOdeItem = new OdeObjItem;
  pCurOdeItem = pCurOdeItem->pNextOdeItem;
  pCurOdeItem->pOdeObject = OdeObjectList[ODE_FUNC_Probe];
  pCurOdeItem->pNextOdeItem = new OdeObjItem;
  pCurOdeItem = pCurOdeItem->pNextOdeItem;
  pCurOdeItem->pOdeObject = OdeObjectList[ODE_FUNC_Probe];


  pwm_sig = 0;
  ia = 0;

  Plot_Tag = "Ia";

#ifdef PLOT_ODEOBJECT_Ia_Ib_Ic_1
  PlotThisOutput = TRUE;
  DoProbes = TRUE;
#endif

}

Ia_Ib_Ic_1::~Ia_Ib_Ic_1(void)
{

}

double Ia_Ib_Ic_1::OdeFunction(double y, double t)
{

  //Note: This is within a "group" ODE so we are really returning for "dm/dt + v_n"

  //(Note: "v_n" is really part of the LValue when we are doing the calculations).
  return(vs_a - Ra*y + Ka*omega*sin(Nr*theta));
}

void Ia_Ib_Ic_1::PostOdeFunction(double t)
{
  //un-comment this to allow encoder single to generated.
  //#define GENERATE_ENCODER_FEEDBACK
#ifdef GENERATE_ENCODER_FEEDBACK

  PositionFeedback = (int) (theta/(2*PI) * ENCODER_RESOLUTION);
  VelocityFeedback = (int) (omega/(2*PI) * ENCODER_RESOLUTION);
#endif

}


void Ia_Ib_Ic_1::RecordProbes(void)
{
  VBus_a.push_back(vs_a);
  Cemf_a.push_back(Ka*omega*sin(Nr*theta));
  //"Ra*ia"
  VRa.push_back(Ra*y);
#ifdef GENERATE_ENCODER_FEEDBACK
  Theta_enc.push_back((double) PositionFeedback * 2 * PI / ENCODER_RESOLUTION);
  Omega_enc.push_back((double) VelocityFeedback * 2 * PI / ENCODER_RESOLUTION);
#endif

}

void Ia_Ib_Ic_1::PlotProbes(Gnuplot & SimuPlot, vector<double> & Plot_t, string TagNamesToPlot[])
{
  int i;
  if(TagNamesToPlot[0] == ""){
    SimuPlot.plot_xy(Plot_t, Cemf_a, "Cemf_a");
    SimuPlot.plot_xy(Plot_t, VBus_a, "VBus_a");
    SimuPlot.plot_xy(Plot_t, VRa, "VRa");
#ifdef GENERATE_ENCODER_FEEDBACK
    SimuPlot.plot_xy(Plot_t, Theta_enc, "Theta_enc");
    SimuPlot.plot_xy(Plot_t, Omega_enc, "Omega_enc");
#endif
  }
  else{
    for(i = 0; i < 20; i++){
      if(TagNamesToPlot[i] == "Cemf_a"){
	SimuPlot.plot_xy(Plot_t, Cemf_a, "Cemf_a");
      }
      else if(TagNamesToPlot[i] == "VBus_a"){
	SimuPlot.plot_xy(Plot_t, VBus_a, "VBus_a");
      }
      else if(TagNamesToPlot[i] == "VRa"){
	SimuPlot.plot_xy(Plot_t, VRa, "VRa");
      }
#ifdef GENERATE_ENCODER_FEEDBACK
      else if(TagNamesToPlot[i] == "Theta_enc"){
	SimuPlot.plot_xy(Plot_t, Theta_enc, "Theta_enc");
      }
      else if(TagNamesToPlot[i] == "Omega_enc"){
	SimuPlot.plot_xy(Plot_t, Omega_enc, "Omega_enc");
      }
#endif
      else if(TagNamesToPlot[i] == ""){
	break;
      }
    }

  }
}



void Ia_Ib_Ic_1::OdeGroupMSolve(double dydt[], double dmdt[])
{
  //Note: This instance is the first of the group. As such, this
  //      is where the "group solve" of the individual
  //      "dy/dt's" is performed.

  //
  //   We must solve for dia/dt, dib/dt, dic/t and v_n in (1), (2), and (3)
  //   where the right side of these equations is passed to us, the values
  //   in "dmdt[]". The "dydt[]" array hold the results. The value "v_n"
  //   is an intermediate value need to solve for dia/dt, dib/dt, and dic/d.
  //
  //
  //   Let
  //         dia = dia/dt, dib = dib/dt and dic = dic/dt
  //
  //
  //       Lm_a*dia - Mab*dib - Mac*dic + v_n = dmdt[0]       (a)
  //
  //       - Mab*dia + Lm_b*dib - Mbc*dic + v_n = dmdt[1]     (b)
  //
  //       - Mac*dia - Mbc*dib + Lm_c*dic + v_n = dmdt[2]     (c)
  //
  //
  //
  //   Solve for dia in (b) and (c) and subtract (c) from (b)
  //
  //
  //
  //       dia = (Lm_b*dib - Mbc*dic + v_n - dmdt[1])/Mab
  //
  //       dia = (- Mbc*dib + Lm_c*dic + v_n - dmdt[2])/Mac
  //
  //       (Lm_b*dib - Mbc*dic + v_n - dmdt[1])/Mab = (- Mbc*dib + Lm_c*dic + v_n - dmdt[2])/Mac
  //
  //       (Lm_b/Mab + Mbc/Mac)*dib + (- Lm_c/Mac - Mbc/Mab)*dic = - v_n/Mab + dmdt[1]/Mab + v_n/Mac - dmdt[2]/Mac       (d)
  //
  //
  //
  //
  //
  //   Solve for dia in (a) and (b) and subtract (b) from (a)
  //
  //
  //       dia = (Mab*dib + Mac*dic - v_n + dmdt[0])/Lm_a
  //
  //       dia = (Lm_b*dib - Mbc*dic + v_n - dmdt[1])/Mab
  //
  //       (Mab*dib + Mac*dic - v_n + dmdt[0])/Lm_a = (Lm_b*dib - Mbc*dic + v_n - dmdt[1])/Mab
  //
  //       (Mab/Lm_a - Lm_b/Mab)*dib + (Mac/Lm_a + Mbc/Mab)*dic = v_n/Lm_a + v_n/Mab - dmdt[0]/Lm_a - dmdt[1]/Mab       (e)
  //
  //
  //
  //
  //       Simplify (d) and (e)
  //
  //       A1*dib + B1*dic = C1                 (f)
  //
  //       A2*dib + B2*dic = C2                 (g)
  //
  //                 Where...
  //
  //       A1 = (Lm_b/Mab + Mbc/Mac)
  //       B1 = (- Lm_c/Mac - Mbc/Mab)
  //       C1 = - v_n/Mab + dmdt[1]/Mab + v_n/Mac - dmdt[2]/Mac
  //       A2 = (Mab/Lm_a - Lm_b/Mab)
  //       B2 = (Mac/Lm_a + Mbc/Mab)
  //       C2 = v_n/Lm_a + v_n/Mab - dmdt[0]/Lm_a - dmdt[1]/Mab
  //
  //
  //
  //
  //       Solve for dib and dic, (g) into (f)
  //
  //       A1*dib + B1*(C2 - A2*dib)/B2 = C1
  //
  //       A1*dib - B1*A2*dib/B2 = C1 - B1*C2/B2
  //
  //       dib = (C1 - B1*C2/B2)/(A1 - B1*A2/B2) = (B2*C1 - B1*C2)/(B2*A1 - B1*A2)     (h)
  //
  //       Note that (h) can be simplified further (see below)
  //
  //       And (h) into (g)
  //
  //       A2*(B2*C1 - B1*C2)/(B2*A1 - B1*A2) + B2*dic = C2
  //
  //       dic = (C2 - A2*(B2*C1 - B1*C2)/(B2*A1 - B1*A2))/B2 = (C2 - A2*dib)/B2       (i)
  //
  //       (h) and (i) into (a) and solve for dia
  //
  //       dia = (Mab*dib + Mac*dic - v_n + dmdt[0])/Lm_a                              (j)
  //
  //
  //
  //
  //       Now, using the identity,
  //
  //           dia + dib + dic = 0   and (h), (i), (j)
  //
  //       Solve for v_n
  //
  //       (Mab*(B2*C1 - B1*C2)/(B2*A1 - B1*A2) + Mac*(C2 - A2*(B2*C1 - B1*C2)/(B2*A1 - B1*A2))/B2 - v_n + dmdt[0])/Lm_a +
  //       (B2*C1 - B1*C2)/(B2*A1 - B1*A2) +
  //       (C2 - A2*(B2*C1 - B1*C2)/(B2*A1 - B1*A2))/B2
  //       = 0
  //
  //       Simplify
  //
  //       (Mab*E/D + Mac*(C2 - A2*E/D)/B2 - v_n + dmdt[0])/Lm_a +
  //       E/D +
  //       (C2 - A2*E/D)/B2
  //       = 0
  //
  //                Where...
  //
  //                       D = (B2*A1 - B1*A2)                                  (k)
  //                       E = (B2*C1 - B1*C2)
  //
  //       Expand
  //
  //       Mab*E/(D*Lm_a) + Mac*C2/(B2*Lm_a) - Mac*A2*E/(D*B2*Lm_a) - v_n/Lm_a + dmdt[0]/Lm_a + E/D + C2/B2 - A2*E/(D*B2) = 0
  //
  //       And
  //
  //       Mab*E/(D*Lm_a) + Mac*C2/(B2*Lm_a) - Mac*A2*E/(F*Lm_a) - v_n/Lm_a + dmdt[0]/Lm_a + E/D + C2/B2 - A2*E/F = 0
  //
  //                Where...
  //
  //                       F = (D*B2)
  //
  //       Group C2 and E expressions to the left
  //
  //
  //       Mab*E/(D*Lm_a) - Mac*A2*E/(F*Lm_a) + E/D - A2*E/F + Mac*C2/(B2*Lm_a) + C2/B2  = v_n/Lm_a - dmdt[0]/Lm_a
  //
  //       E*(Mab/(D*Lm_a) - Mac*A2/(F*Lm_a) + 1/D - A2/F) + C2*(Mac/(B2*Lm_a) + 1/B2)  = v_n/Lm_a - dmdt[0]/Lm_a
  //
  //       And
  //
  //       E*G + C2*H = v_n/Lm_a - dmdt[0]/Lm_a
  //
  //               Where...
  //
  //                       G = (Mab/(D*Lm_a) - Mac*A2/(F*Lm_a) + 1/D - A2/F)
  //                       H = (Mac/(B2*Lm_a) + 1/B2)
  //
  //
  //       Expand E and group terms
  //
  //       (B2*C1 - B1*C2)*G + C2*H = v_n/Lm_a - dmdt[0]/Lm_a
  //
  //       C1*B2*G + C2*(H - B1*G) = v_n/Lm_a - dmdt[0]/Lm_a
  //
  //
  //       Expand C1 and C2 and group terms
  //
  //       (- v_n/Mab + dmdt[1]/Mab + v_n/Mac - dmdt[2]/Mac)*B2*G + (v_n/Lm_a + v_n/Mab - dmdt[0]/Lm_a - dmdt[1]/Mab)*(H - B1*G) =
  //                  v_n/Lm_a - dmdt[0]/Lm_a
  //
  //       v_n*(-B2*G/Mab + B2*G/Mac + (H - B1*G)/Lm_a + (H - B1*G)/Mab - 1/Lm_a) = (dmdt[2]/Mac - dmdt[1]/Mab)*B2*G +
  //                                                       (dmdt[0]/Lm_a + dmdt[1]/Mab)*(H - B1*G) - dmdt[0]/Lm_a
  //
  //
  //       Finally,
  //
  //
  //       v_n = ((dmdt[2]/Mac - dmdt[1]/Mab)*B2*G + (dmdt[0]/Lm_a + dmdt[1]/Mab)*(H - B1*G) - dmdt[0]/Lm_a)/
  //                     (-B2*G/Mab + B2*G/Mac + (H - B1*G)/Lm_a + (H - B1*G)/Mab - 1/Lm_a)                     (l)
  //
  //
  //       Note that (h) and be further simplified by (k).
  //
  //       dib = (B2*C1 - B1*C2)/D
  //
  //       And (l) can be reduced further
  //
  //       v_n = ((dmdt[2]/Mac - dmdt[1]/Mab)*J + (dmdt[0]/Lm_a + dmdt[1]/Mab)*I - dmdt[0]/Lm_a)/
  //                     (-J/Mab + J/Mac + I/Lm_a + I/Mab - 1/Lm_a)
  //
  //
  //           Where...
  //
  //                   I = (H - B1*G)
  //                   J = (B2*G)
  //
  //


#define A1  (Lm_b/Mab + Mbc/Mac)
#define B1  (- Lm_c/Mac - Mbc/Mab)
#define A2  (Mab/Lm_a - Lm_b/Mab)
#define B2  (Mac/Lm_a + Mbc/Mab)

#define D   (B2*A1 - B1*A2)
#define F   (D*B2)
#define G   (Mab/(D*Lm_a) - Mac*A2/(F*Lm_a) + 1/D - A2/F)
#define H   (Mac/(B2*Lm_a) + 1/B2)

#define I   (H - B1*G)
#define J   (B2*G)


  double dia;
  double dib;
  double dic;

  double C1;
  double C2;

  v_n = ((dmdt[2]/Mac - dmdt[1]/Mab)*J + (dmdt[0]/Lm_a + dmdt[1]/Mab)*I - dmdt[0]/Lm_a) /
    (-J/Mab + J/Mac + I/Lm_a + I/Mab - 1/Lm_a);

  C1 = - v_n/Mab + dmdt[1]/Mab + v_n/Mac - dmdt[2]/Mac;
  C2 = v_n/Lm_a + v_n/Mab - dmdt[0]/Lm_a - dmdt[1]/Mab;

  dib = (B2*C1 - B1*C2)/D;
  dic = (C2 - A2*dib)/B2;
  dia = (Mab*dib + Mac*dic - v_n + dmdt[0])/Lm_a;

  dydt[0] = dia;
  dydt[1] = dib;
  dydt[2] = dic;

}

void Ia_Ib_Ic_1::OdeRValueUpdate(void)
{
  OdeObjItem * pCurOdeItem;

  //Update Rvalues
  pCurOdeItem = pOdeObjRValList;

  ((Omega *) pCurOdeItem->pOdeObject)->ia = y;
  pCurOdeItem = pCurOdeItem->pNextOdeItem;
  ((Probe *) pCurOdeItem->pOdeObject)->ia = y;
  pCurOdeItem = pCurOdeItem->pNextOdeItem;
  ((Probe *) pCurOdeItem->pOdeObject)->vs_a = vs_a;
  pCurOdeItem = pCurOdeItem->pNextOdeItem;
  ((Probe *) pCurOdeItem->pOdeObject)->v_n = v_n;


}

// -----------------------------------------------------------------


// ---- Ia_Ib_Ic_2  ----------------------------------------------------



Ia_Ib_Ic_2::Ia_Ib_Ic_2(void)
{
  OdeObjItem * pCurOdeItem;

  OdeFuncName = ODE_FUNC_Ia_Ib_Ic_2;
  LiteralName = "Ia_Ib_Ic_2";

  //build the ODE Rvalue list.

  pOdeObjRValList = new OdeObjItem;
  pCurOdeItem = pOdeObjRValList;

  pCurOdeItem->pOdeObject = OdeObjectList[ODE_FUNC_Omega];
  pCurOdeItem->pNextOdeItem = new OdeObjItem;
  pCurOdeItem = pCurOdeItem->pNextOdeItem;
  pCurOdeItem->pOdeObject = OdeObjectList[ODE_FUNC_Probe];
  pCurOdeItem->pNextOdeItem = new OdeObjItem;
  pCurOdeItem = pCurOdeItem->pNextOdeItem;
  pCurOdeItem->pOdeObject = OdeObjectList[ODE_FUNC_Probe];


  pwm_sig = 0;
  ib = 0;

  Plot_Tag = "Ib";

#ifdef PLOT_ODEOBJECT_Ia_Ib_Ic_2
  PlotThisOutput = TRUE;
  DoProbes = TRUE;
#endif

}



Ia_Ib_Ic_2::~Ia_Ib_Ic_2(void)
{

}



double Ia_Ib_Ic_2::OdeFunction(double y, double t)
{

  //Note: This is within a "group" ODE so we are really returning for "dm/dt + v_n"

          //"vs_b - Rb*ib + Kb*omega*sin(Nr*theta - 2*PI/3))"

  //(Note: "v_n" is really part of the LValue when we are doing the calculations).
  return(vs_b - Rb*y + Kb*omega*sin(Nr*theta - 2*PI/3));
}


void Ia_Ib_Ic_2::RecordProbes(void)
{
  VBus_b.push_back(vs_b);
  Cemf_b.push_back(Kb*omega*sin(Nr*theta - 2*PI/3));
  //"Rb*ib"
  VRb.push_back(Rb*y);
}




void Ia_Ib_Ic_2::PlotProbes(Gnuplot & SimuPlot, vector<double> & Plot_t, string TagNamesToPlot[])
{
  int i;
  if(TagNamesToPlot[0] == ""){
    SimuPlot.plot_xy(Plot_t, Cemf_b, "Cemf_b");
    SimuPlot.plot_xy(Plot_t, VBus_b, "VBus_b");
    SimuPlot.plot_xy(Plot_t, VRb, "VRb");
  }
  else{
    for(i = 0; i < 20; i++){
      if(TagNamesToPlot[i] == "Cemf_b"){
	SimuPlot.plot_xy(Plot_t, Cemf_b, "Cemf_b");
      }
      else if(TagNamesToPlot[i] == "VBus_b"){
	SimuPlot.plot_xy(Plot_t, VBus_b, "VBus_b");
      }
      else if(TagNamesToPlot[i] == "VRb"){
	SimuPlot.plot_xy(Plot_t, VRb, "VRb");
      }
      else if(TagNamesToPlot[i] == ""){
	break;
      }
    }

  }
}




void Ia_Ib_Ic_2::OdeRValueUpdate(void)
{
  OdeObjItem * pCurOdeItem;

  //Update Rvalues
  pCurOdeItem = pOdeObjRValList;

  ((Omega *) pCurOdeItem->pOdeObject)->ib = y;
  pCurOdeItem = pCurOdeItem->pNextOdeItem;
  ((Probe *) pCurOdeItem->pOdeObject)->ib = y;
  pCurOdeItem = pCurOdeItem->pNextOdeItem;
  ((Probe *) pCurOdeItem->pOdeObject)->vs_b = vs_b;


}





// -----------------------------------------------------------------



// ---- Ia_Ib_Ic_3  ----------------------------------------------------


Ia_Ib_Ic_3::Ia_Ib_Ic_3(void)
{
  OdeObjItem * pCurOdeItem;

  OdeFuncName = ODE_FUNC_Ia_Ib_Ic_3;
  LiteralName = "Ia_Ib_Ic_3";

  //build the ODE Rvalue list.

  pOdeObjRValList = new OdeObjItem;
  pCurOdeItem = pOdeObjRValList;

  pCurOdeItem->pOdeObject = OdeObjectList[ODE_FUNC_Omega];
  pCurOdeItem->pNextOdeItem = new OdeObjItem;
  pCurOdeItem = pCurOdeItem->pNextOdeItem;
  pCurOdeItem->pOdeObject = OdeObjectList[ODE_FUNC_Probe];
  pCurOdeItem->pNextOdeItem = new OdeObjItem;
  pCurOdeItem = pCurOdeItem->pNextOdeItem;
  pCurOdeItem->pOdeObject = OdeObjectList[ODE_FUNC_Probe];




  pwm_sig = 0;
  ic = 0;

  Plot_Tag = "Ic";

#ifdef PLOT_ODEOBJECT_Ia_Ib_Ic_3
  PlotThisOutput = TRUE;
  DoProbes = TRUE;
#endif

}



Ia_Ib_Ic_3::~Ia_Ib_Ic_3(void)
{

}

double Ia_Ib_Ic_3::OdeFunction(double y, double t)
{

  //Note: This is within a "group" ODE so we are really returning for "dm/dt + v_n"

          //"vs_c - Rc*ic + Kc*omega*sin(Nr*theta - 4*PI/3))"

  //(Note: "v_n" is really part of the LValue when we are doing the calculations).
  return(vs_c - Rc*y + Kc*omega*sin(Nr*theta - 4*PI/3));
}


void Ia_Ib_Ic_3::RecordProbes(void)
{
  VBus_c.push_back(vs_c);
  Cemf_c.push_back(Kc*omega*sin(Nr*theta - 4*PI/3));
  //"Rc*ic"
  VRc.push_back(Rc*y);
}



void Ia_Ib_Ic_3::PlotProbes(Gnuplot & SimuPlot, vector<double> & Plot_t, string TagNamesToPlot[])
{
  int i;
  if(TagNamesToPlot[0] == ""){
    SimuPlot.plot_xy(Plot_t, Cemf_c, "Cemf_c");
    SimuPlot.plot_xy(Plot_t, VBus_c, "VBus_c");
    SimuPlot.plot_xy(Plot_t, VRc, "VRc");
  }
  else{
    for(i = 0; i < 20; i++){
      if(TagNamesToPlot[i] == "Cemf_c"){
	SimuPlot.plot_xy(Plot_t, Cemf_c, "Cemf_c");
      }
      else if(TagNamesToPlot[i] == "VBus_c"){
	SimuPlot.plot_xy(Plot_t, VBus_c, "VBus_c");
      }
      else if(TagNamesToPlot[i] == "VRc"){
	SimuPlot.plot_xy(Plot_t, VRc, "VRc");
      }
      else if(TagNamesToPlot[i] == ""){
	break;
      }
    }

  }
}



void Ia_Ib_Ic_3::OdeRValueUpdate(void)
{
  OdeObjItem * pCurOdeItem;

  //Update Rvalues
  pCurOdeItem = pOdeObjRValList;

  ((Omega *) pCurOdeItem->pOdeObject)->ic = y;
  pCurOdeItem = pCurOdeItem->pNextOdeItem;
  ((Probe *) pCurOdeItem->pOdeObject)->ic = y;
  pCurOdeItem = pCurOdeItem->pNextOdeItem;
  ((Probe *) pCurOdeItem->pOdeObject)->vs_c = vs_c;


}

// -----------------------------------------------------------------

// ---- Omega  ----------------------------------------------------

Omega::Omega(void)
{

  OdeObjItem * pCurOdeItem;

  OdeFuncName = ODE_FUNC_Omega;
  LiteralName = "Omega";

  //build the ODE Rvalue list.

  pOdeObjRValList = new OdeObjItem;
  pCurOdeItem = pOdeObjRValList;

  pCurOdeItem->pOdeObject = OdeObjectList[ODE_FUNC_Ia_Ib_Ic_1];
  pCurOdeItem->pNextOdeItem = new OdeObjItem;
  pCurOdeItem = pCurOdeItem->pNextOdeItem;
  pCurOdeItem->pOdeObject = OdeObjectList[ODE_FUNC_Ia_Ib_Ic_2];
  pCurOdeItem->pNextOdeItem = new OdeObjItem;
  pCurOdeItem = pCurOdeItem->pNextOdeItem;
  pCurOdeItem->pOdeObject = OdeObjectList[ODE_FUNC_Ia_Ib_Ic_3];
  pCurOdeItem->pNextOdeItem = new OdeObjItem;
  pCurOdeItem = pCurOdeItem->pNextOdeItem;
  pCurOdeItem->pOdeObject = OdeObjectList[ODE_FUNC_Theta];
  pCurOdeItem->pNextOdeItem = new OdeObjItem;
  pCurOdeItem = pCurOdeItem->pNextOdeItem;
  pCurOdeItem->pOdeObject = OdeObjectList[ODE_FUNC_Probe];


  ia = 0;
  ib = 0;
  ic = 0;

#ifdef PLOT_ODEOBJECT_Omega
  PlotThisOutput = TRUE;
#endif


  Plot_Tag = "Omega";

}

Omega::~Omega(void)
{

}

double Omega::OdeFunction(double y, double t)
{

  //#define FORCE_CONSTANT_OMEGA   //un-comment this generate constant "Omega" to test phase characteristics
#ifdef FORCE_CONSTANT_OMEGA
  //Force "dOmega/dt" to some constant value so that probes like "Cemf_a" and "VBus_a" can be compared.
  //This gives us an Omega that starts from zero and increases in time.

  return(2*PI*100);  //rad/sec**2 (we should see a change of 2*PI*10 radians/sec every .1 sec?)

#else

         //(- Ka*ia*sin(Nr*theta) - Kb*ib*sin(Nr*theta - 2*PI/3) - Kc*ic*sin(Nr*theta - 4*PI/3) -
         //                        Bm*omega - Cm*sgn(omega) - Dm*sin(2*Nr*theta))/Jm

  return((- Ka*ia*sin(Nr*theta) - Kb*ib*sin(Nr*theta - 2*PI/3) - Kc*ic*sin(Nr*theta - 4*PI/3) -
	              Bm*y - Cm*(y < 0 ? -1 : (y > 0 ? 1 : 0)) - Dm*sin(2*Nr*theta))/Jm);

#endif

}

void Omega::OdeRValueUpdate(void)
{
  OdeObjItem * pCurOdeItem;

  //Update Rvalues
  pCurOdeItem = pOdeObjRValList;

  ((Ia_Ib_Ic_1 *) pCurOdeItem->pOdeObject)->omega = y;
  pCurOdeItem = pCurOdeItem->pNextOdeItem;
  ((Ia_Ib_Ic_2 *) pCurOdeItem->pOdeObject)->omega = y;
  pCurOdeItem = pCurOdeItem->pNextOdeItem;
  ((Ia_Ib_Ic_3 *) pCurOdeItem->pOdeObject)->omega = y;
  pCurOdeItem = pCurOdeItem->pNextOdeItem;
  ((Theta *) pCurOdeItem->pOdeObject)->omega = y;
  pCurOdeItem = pCurOdeItem->pNextOdeItem;
  ((Probe *) pCurOdeItem->pOdeObject)->omega = y;



}


// -----------------------------------------------------------------




// ---- Theta  ----------------------------------------------------

Theta::Theta(void)
{

  OdeObjItem * pCurOdeItem;
  CtrlObjItem * pCurCtrlItem;

  OdeFuncName = ODE_FUNC_Theta;
  LiteralName = "Theta";

  //build the ODE Rvalue list.

  pOdeObjRValList = new OdeObjItem;
  pCurOdeItem = pOdeObjRValList;

  pCurOdeItem->pOdeObject = OdeObjectList[ODE_FUNC_Ia_Ib_Ic_1];
  pCurOdeItem->pNextOdeItem = new OdeObjItem;
  pCurOdeItem = pCurOdeItem->pNextOdeItem;
  pCurOdeItem->pOdeObject = OdeObjectList[ODE_FUNC_Ia_Ib_Ic_2];
  pCurOdeItem->pNextOdeItem = new OdeObjItem;
  pCurOdeItem = pCurOdeItem->pNextOdeItem;
  pCurOdeItem->pOdeObject = OdeObjectList[ODE_FUNC_Ia_Ib_Ic_3];
  pCurOdeItem->pNextOdeItem = new OdeObjItem;
  pCurOdeItem = pCurOdeItem->pNextOdeItem;
  pCurOdeItem->pOdeObject = OdeObjectList[ODE_FUNC_Omega];
  pCurOdeItem->pNextOdeItem = new OdeObjItem;
  pCurOdeItem = pCurOdeItem->pNextOdeItem;
  pCurOdeItem->pOdeObject = OdeObjectList[ODE_FUNC_Probe];


  //build the CTRL Rvalue list

  pCtrlObjRValList = new CtrlObjItem;
  pCurCtrlItem = pCtrlObjRValList;

  pCurCtrlItem->pCtrlObject = CtrlObjectList[CTRL_FUNC_VDqCmd];


  omega = 0;

#ifdef PLOT_ODEOBJECT_Theta
  PlotThisOutput = TRUE;
#endif

  Plot_Tag = "Theta";

}

Theta::~Theta(void)
{

}

double Theta::OdeFunction(double y, double t)
{

     //omega;
  return(omega);

}

void Theta::OdeRValueUpdate(void)
{
  OdeObjItem * pCurOdeItem;

  //Update Rvalues
  pCurOdeItem = pOdeObjRValList;

  ((Ia_Ib_Ic_1 *) pCurOdeItem->pOdeObject)->theta = y;
  pCurOdeItem = pCurOdeItem->pNextOdeItem;
  ((Ia_Ib_Ic_2 *) pCurOdeItem->pOdeObject)->theta = y;
  pCurOdeItem = pCurOdeItem->pNextOdeItem;
  ((Ia_Ib_Ic_3 *) pCurOdeItem->pOdeObject)->theta = y;
  pCurOdeItem = pCurOdeItem->pNextOdeItem;
  ((Omega *) pCurOdeItem->pOdeObject)->theta = y;
  pCurOdeItem = pCurOdeItem->pNextOdeItem;
  ((Probe *) pCurOdeItem->pOdeObject)->theta = y;
}

void Theta::CtrlRValueUpdate(void)
{
  CtrlObjItem * pCurCtrlItem;

  //Update Rvalues
  pCurCtrlItem = pCtrlObjRValList;

  ((VDqCmd *) pCurCtrlItem->pCtrlObject)->theta = y;


}


// -----------------------------------------------------------------


// ---- Probe  ----------------------------------------------------

Probe::Probe(void)
{

  //This is a receptical for viewing probes only. Thus,
  //no "OdeRValueUpdate()" or "OdeFunction() functions
  //are used.

  //(NOTE 10/5/08: A better way of doing this is to use "PostOdeFunction()" in "Ia_Ib_Ic_1"
  //               to immediately update "v_n" in "Ia_Ib_Ic_2" and "Ia_Ib_Ic_3". This way
  //               we get rid of the state delay in viewing "Vcm_x" relative to the the
  //               probes in these other ODE's.)

  OdeFuncName = ODE_FUNC_Probe;
  LiteralName = "Probe";

#ifdef PLOT_ODEOBJECT_Probe
  DoProbes = TRUE;
#endif

}

Probe::~Probe(void)
{

}


void Probe::RecordProbes(void)
{

  Vcm_a.push_back(vs_a - Ra*ia + Ka*omega*sin(Nr*theta) - v_n);
  Vcm_b.push_back(vs_b - Rb*ib + Kb*omega*sin(Nr*theta - 2*PI/3) - v_n);
  Vcm_c.push_back(vs_c - Rc*ic + Kc*omega*sin(Nr*theta - 4*PI/3) - v_n);
  V_n.push_back(v_n);
}



void Probe::PlotProbes(Gnuplot & SimuPlot, vector<double> & Plot_t, string TagNamesToPlot[])
{
  int i;
  if(TagNamesToPlot[0] == ""){
    SimuPlot.plot_xy(Plot_t, Vcm_a, "Vcm_a");
    SimuPlot.plot_xy(Plot_t, Vcm_b, "Vcm_b");
    SimuPlot.plot_xy(Plot_t, Vcm_c, "Vcm_c");
    SimuPlot.plot_xy(Plot_t, V_n, "V_n");
  }
  else{
    for(i = 0; i < 20; i++){
      if(TagNamesToPlot[i] == "Vcm_a"){
	SimuPlot.plot_xy(Plot_t, Vcm_a, "Vcm_a");
      }
      else if(TagNamesToPlot[i] == "Vcm_b"){
	SimuPlot.plot_xy(Plot_t, Vcm_b, "Vcm_b");
      }
      else if(TagNamesToPlot[i] == "Vcm_c"){
	SimuPlot.plot_xy(Plot_t, Vcm_c, "Vcm_c");
      }
      else if(TagNamesToPlot[i] == "V_n"){
	SimuPlot.plot_xy(Plot_t, V_n, "V_n");
      }
      else if(TagNamesToPlot[i] == ""){
	break;
      }
    }

  }
}

// -----------------------------------------------------------------




// ******************************************************************




// **** CtrlObject Functions ****************************************

// ---- VDqCmd  ---------------------------------------------------

VDqCmd::VDqCmd(void)
{
  SrcObjItem * pCurSrcItem;


  CtrlFuncName = CTRL_FUNC_VDqCmd;
  LiteralName = "VDqCmd";



  //build the SRC Rvalue list.

  pSrcObjRValList = new SrcObjItem;
  pCurSrcItem = pSrcObjRValList;

  pCurSrcItem->pSrcObject = SrcObjectList[SRC_FUNC_Vref_0];
  pCurSrcItem->pNextSrcItem = new SrcObjItem;
  pCurSrcItem = pCurSrcItem->pNextSrcItem;
  pCurSrcItem->pSrcObject = SrcObjectList[SRC_FUNC_Vref_1];
  pCurSrcItem->pNextSrcItem = new SrcObjItem;
  pCurSrcItem = pCurSrcItem->pNextSrcItem;
  pCurSrcItem->pSrcObject = SrcObjectList[SRC_FUNC_Vref_2];


#ifdef PLOT_CTRLOBJECT_VDqCmd
  DoProbes = TRUE;
#endif

}

VDqCmd::~VDqCmd(void)
{



}



void VDqCmd::CtrlFunction(double t)
{
	double CtrlAngle;
	double Amplitude;

  	CtrlAngle = Nr*theta;


  	Amplitude = (2.0/3.0)*PWM_GAIN;
  	V_xo[0] = Amplitude*(vdd*cos(CtrlAngle) - vqd*sin(CtrlAngle)) / (PLUS_DC_BUS_VOLTAGE - MINUS_DC_BUS_VOLTAGE);
  	V_xo[1] = Amplitude*(vdd*cos(CtrlAngle - 2*PI/3) - vqd*sin(CtrlAngle - 2*PI/3)) / (PLUS_DC_BUS_VOLTAGE - MINUS_DC_BUS_VOLTAGE);
  	V_xo[2] = Amplitude*(vdd*cos(CtrlAngle - 4*PI/3) - vqd*sin(CtrlAngle - 4*PI/3)) / (PLUS_DC_BUS_VOLTAGE - MINUS_DC_BUS_VOLTAGE);




}

void VDqCmd::RecordProbes(void)
{

  VCmd_a.push_back(V_xo[0]);
  VCmd_b.push_back(V_xo[1]);
  VCmd_c.push_back(V_xo[2]);

}

void VDqCmd::PlotProbes(Gnuplot & SimuPlot, vector<double> & Plot_t, string TagNamesToPlot[])
{

  int i;
  if(TagNamesToPlot[0] == ""){
    SimuPlot.plot_xy(Plot_t, VCmd_a, "VCmd_a");
    SimuPlot.plot_xy(Plot_t, VCmd_b, "VCmd_b");
    SimuPlot.plot_xy(Plot_t, VCmd_c, "VCmd_c");
  }
  else{
    for(i = 0; i < 20; i++){
      if(TagNamesToPlot[i] == "VCmd_a"){
	SimuPlot.plot_xy(Plot_t, VCmd_a, "VCmd_a");
      }
      else if(TagNamesToPlot[i] == "VCmd_b"){
	SimuPlot.plot_xy(Plot_t, VCmd_b, "VCmd_b");
      }
      else if(TagNamesToPlot[i] == "VCmd_c"){
	SimuPlot.plot_xy(Plot_t, VCmd_c, "VCmd_c");
      }
    }
  }


}

void  VDqCmd::SrcRValueUpdate(void)
{
  SrcObjItem * pCurSrcItem;

  //Update Rvalues
  pCurSrcItem = pSrcObjRValList;

  ((Vref *) pCurSrcItem->pSrcObject)->V_xo = V_xo[0];
  pCurSrcItem = pCurSrcItem->pNextSrcItem;
  ((Vref *) pCurSrcItem->pSrcObject)->V_xo = V_xo[1];
  pCurSrcItem = pCurSrcItem->pNextSrcItem;
  ((Vref *) pCurSrcItem->pSrcObject)->V_xo = V_xo[2];


}





// ---------------------------------------------------------------



// ---- RefGen  ---------------------------------------------------

RefGen::RefGen(void)
{
  CtrlObjItem * pCurCtrlItem;

  CtrlFuncName = CTRL_FUNC_RefGen;
  LiteralName = "RefGen";

    //We want this "RefGen" to immediately update "VDqCmd" and other selected CtrlObject's ahead of it after it's
    //control function is executed.
  DoImmedCtrlUpdate = TRUE;

    //build the CTRL Rvalue list

  pCtrlObjRValList = new CtrlObjItem;
  pCurCtrlItem = pCtrlObjRValList;

  pCurCtrlItem->pCtrlObject = CtrlObjectList[CTRL_FUNC_VDqCmd];
  pCurCtrlItem->pNextCtrlItem = new CtrlObjItem;
  pCurCtrlItem = pCurCtrlItem->pNextCtrlItem;
  pCurCtrlItem->pCtrlObject = CtrlObjectList[CTRL_FUNC_VDqCmd];



#ifdef PLOT_CTRLOBJECT_RefGen
  DoProbes = TRUE;
#endif


}

RefGen::~RefGen(void)
{



}



void RefGen::CtrlFunction(double t)
{
  //Here we generate trajectory and feedforward copensation.
  //Here, the design is based on work presented in Section 3.1 "Reference Trajectory" of document
  //"High Performance Non-Linear Control of Perminant Magnet stepper Motor". A PDF file was generated
  //to highlight this section (see "ReferenceTrajectory.pdf").

  //The system described in the documents above must be translated for use on a AC Brushless Motor
  //(ref "Marc's Original, NOT John's)
  //Refer to documents "AcMotorNotes.pdf" for the model of a AC Brushless Motor, and document
  //"MotorEquations.txt" for a varification of the model. Note that "MotorEquations.txt" MUST be
  //viewed using Microsoft "WordPad". Also refer to document "LagrangeMultipliers.txt" which must
  //be viewed using "emacs".

  //  Equations (13), (14), (15), and (16) of "ReferenceTrajectory.pdf" translated to the equivilent
  //  AC Brushless motor model are as follows (here, variables are stated as "desired" as opposed to "actual").
  //
  //     didd = (vdd - Ridd + omegad*(Lm + M)*iqd)/(Lm + M)                                       (a)
  //
  //     diqd = (vqd - Riqd - omegad*(Lm + M)*idd - 3*K*omegad/2)/(Lm + M)                        (b)
  //
  //     domegad = (K*iqd - Bm*omegad - Cm*sgn(omegad) - Dm*sin(2*Nr*thetad))/Jm                  (c)
  //
  //     dthetad = omegad                                                                         (d)
  //
  //                   where:
  //                          didd => didd/dt
  //                          diqd => diqd/dt
  //                          domegad => domegad/dt
  //                          dthetad => dthetad/dt
  //
  //  In the D/Q form, the following conditions are assumed:
  //
  //      Lm = (Lm_a + Lm_b + Lm_c) / 3
  //      M = (Mab + Mac + Mbc) / 3
  //      R = (Ra + Rb + Rc) / 3
  //      K = (Ka + Kb + Kc) / 3
  //
  //  Similar to  (17), (18), (19), and (20) of "ReferenceTrajectory.pdf",
  //
  //      idd = - ((Lm + M)*K*(3/2)*Nr*omegad**2) / (R**2 + ((Lm + M)*Nr*omegad)**2)               (e)
  //
  //      iqd = (Jm*alphad  + Bm*omegad + Cm*sgn(omegad) + Dm*sin(2*Nr*thetad)) / K                (f)
  //
  //      didd = - (2*K*(3/2)*(Lm + M)*R**2*Nr*omegad*alphad) / (R**2 + (Nr*omegad*(Lm + M))**2)   (g)
  //
  //      diqd = (Jm*betad  + Bm*alphad  + Cm*sgn(omegad) + Dm*sin(2*Nr*thetad)) / K               (h)
  //
  //                    where:
  //                           alphad => domagad
  //                           betad => dalphad
  //
  //
  //                    Note: The equation for "idd" (equation "(e)" above) is an approximation that assumes
  //                          that "alphad" and it's higher order derivitives are are zero. It derivation is
  //                          provided in document "LagrangeMultipliers.txt"
  //
  //                          Also note the "3/2" scale factor added "K" in equation (e) and (g) that differeciates the AC
  //                          Brushless motor expression for "idd" from the Stepping motor expression for "idd".
  //
  //
  //
  //  The values for "dtheda", "domega", "dalpha", and "dbeta" are derived from the trajectory generator
  //  which is explained below. These values are used to determine "idd", "iqd", "didd" and "diqd" in
  //  equations (e) through (h) above.
  //
  //  In turn, these values are used to determine "desired" voltage command "vdd" and "vqd" described
  //  in equations (a) and (b) above.
  //
  //      vdd = (Lm + M)*didd + R*idd - Nr*omegad*(Lm + M)*iqd                                     (i)
  //
  //      vqd = (Lm + M)*idq + R*iqd + Nr*omegad*(Lm + M)*idd + K*(3/2)*omegad                     (j)
  //
  //
  //                  (Again, note the "3/2" scale factor applied to "K" in equation (j))
  //
  //
  //  Equations (i) and (j) provide the feed forward command voltages "vdd" and "vqd" that are used to
  //  calculate "vcmd_mag" and "vcmd_ang" in CtrlObject "VDqCmd".
  //
  //
  //


  double Lm = (Lm_a + Lm_b + Lm_c) / 3.0;
  double M = (Mab + Mac + Mbc) / 3.0;
  double R = (Ra + Rb + Rc) / 3.0;
  double K = (Ka + Kb + Kc) / 3.0;




  //#define EXPONENTIAL_RAMPING
#ifdef EXPONENTIAL_RAMPING

  //  To do:
  //
  //   Implement exponential ramping (with linear ramping within accel/decel segments)
  //
  //     Something like this....
  //
  //     - Generate a velocity profile out of seven (7) segments.
  //     - For t0 <= t < t1, v = t**k
  //     - For t1 <= t < t2, v = t1**k + k*(t - t1)**k-1
  //     - For t2 <= t < t3, v = t1**k + k*(t2 - t1)**k-1 + (t1**k - ((t1 - t0) - (t - t2))**k
  //     - For t3 <= t < t4, v = v_const = t1**k + k*(t2 - t1)**k-1 + (t1**k - ((t1 - t0) - (t3 - t2))**k
  //     - (Similar calculations for ramping down...)
  //
  //
  //     - Now, integrate the final equation above for t between t0 and t7 and equate it to the desired position.
  //
  //     - Given t0, t1, t2, k, v_const and position with t7 - t6 == t1 - t0, t6 - t5 == t2 - t1, and t5 - t4 == t3 - t2
  //       and t3 - t2 == t1 - t0, solve for t3, t4, t5, t6 and t7.
  //
  //     - Execute each equation based on the current value of t within it's time segment.
  //
  //


#else


  //Point to point, "modified sin" trajectory generator.


  if(t < RT_TRAJ){
    omegad = VO_TRAJ*(sin(t*PI/RT_TRAJ - PI/2.0) + 1)/2.0;
    thetad =  VO_TRAJ*(-(RT_TRAJ/PI)*cos(t*PI/RT_TRAJ - PI/2.0) + t)/2.0;
    alphad = VO_TRAJ*(PI/RT_TRAJ)*cos(t*PI/RT_TRAJ - PI/2.0)/2.0;
    betad = VO_TRAJ*(-PI/RT_TRAJ)*(PI/RT_TRAJ)*sin(t*PI/RT_TRAJ - PI/2.0)/2.0;

  }
  else if(t < (RT_TRAJ + CT_TRAJ)){
    omegad = VO_TRAJ;
    thetad = VO_TRAJ*RT_TRAJ/2.0 + VO_TRAJ*(t-RT_TRAJ);
    alphad = 0;
    betad = 0;

  }
  else if(t < (2*RT_TRAJ + CT_TRAJ)){
    omegad = VO_TRAJ*(sin((CT_TRAJ+2*RT_TRAJ-t)*PI/RT_TRAJ - PI/2.0) + 1)/2.0;
    thetad =  VO_TRAJ*RT_TRAJ/2.0 + VO_TRAJ*(CT_TRAJ) + VO_TRAJ*(-(RT_TRAJ/PI)*cos((CT_TRAJ+RT_TRAJ-t)*PI/RT_TRAJ - PI/2.0) +
							      t-(RT_TRAJ+CT_TRAJ))/2.0;
    alphad = VO_TRAJ*(-PI/RT_TRAJ)*cos((CT_TRAJ+2*RT_TRAJ-t)*PI/RT_TRAJ - PI/2.0)/2.0;
    betad = VO_TRAJ*(PI/RT_TRAJ)*(-PI/RT_TRAJ)*sin((CT_TRAJ+2*RT_TRAJ-t)*PI/RT_TRAJ - PI/2.0)/2.0;

  }
  else{
    omegad = 0;
    thetad = VO_TRAJ*RT_TRAJ + VO_TRAJ*(CT_TRAJ);
    alphad = 0;
    betad = VO_TRAJ*(PI/RT_TRAJ)*(-PI/RT_TRAJ)*(-1.0/2.0);

  }



  //"betad" being discontinuous causes small trajectory generation.

  betad = 0;

  //This is why exponential based ramping is ideal (no discontinuities at higher differencials)
  //Interesting howerver, if we force to "0", we can get a pretty good representation without generating
  //a "bump" on vdq.

  //In any event, this enforces the idea that the trajectory should be generated with using exponential ramping.



#endif





  //generate the commands "vdd" and "vqd"


  idd = - ((Lm + M)*K*(3.0/2.0)*Nr*omegad*omegad) / (R*R + (Lm + M)*(Lm + M)*Nr*Nr*omegad*omegad);
  iqd = (Jm*alphad  + Bm*omegad + Cm*sgn(omegad) + Dm*sin(2*Nr*thetad)) / K;
  didd = - (2*K*(3.0/2.0)*(Lm + M)*R*R*Nr*omegad*alphad) / (R*R + (Lm + M)*(Lm + M)*Nr*Nr*omegad*omegad);
  diqd = (Jm*betad  + Bm*alphad  + Cm*impulse(sgn(omegad)) + Dm*2*Nr*cos(2*Nr*thetad)) / K;


  vdd = (Lm + M)*didd + R*idd - Nr*omegad*(Lm + M)*iqd;
                           //Like above, note the "3/2" scale factor on "K" below.
  vqd = (Lm + M)*diqd + R*iqd + Nr*omegad*(Lm + M)*idd + K*(3.0/2.0)*omegad;

  //For the full state feedback controller, we will integrate "thedad"

  zetad = zetad + thetad*(QUANTUM_PERIOD  * (double) REF_GEN_QUANTUM_CNT);

}

void RefGen::RecordProbes(void)
{

  beta_d.push_back(betad);
  alpha_d.push_back(alphad);
  omega_d.push_back(omegad);
  theta_d.push_back(thetad);
  zeta_d.push_back(zetad);
  id_d.push_back(idd);
  iq_d.push_back(iqd);
  did_d.push_back(didd);
  diq_d.push_back(diqd);
  vd_d.push_back(vdd);
  vq_d.push_back(vqd);

}


void RefGen::PlotProbes(Gnuplot & SimuPlot, vector<double> & Plot_t, string TagNamesToPlot[])
{

  int i;
  if(TagNamesToPlot[0] == ""){
    SimuPlot.plot_xy(Plot_t, beta_d, "betad");
    SimuPlot.plot_xy(Plot_t, alpha_d, "alphad");
    SimuPlot.plot_xy(Plot_t, omega_d, "omegad");
    SimuPlot.plot_xy(Plot_t, theta_d, "thetad");
    SimuPlot.plot_xy(Plot_t, zeta_d, "zetad");
    SimuPlot.plot_xy(Plot_t, id_d, "idd");
    SimuPlot.plot_xy(Plot_t, iq_d, "iqd");
    SimuPlot.plot_xy(Plot_t, did_d, "didd");
    SimuPlot.plot_xy(Plot_t, diq_d, "diqd");
    SimuPlot.plot_xy(Plot_t, vd_d, "vdd");
    SimuPlot.plot_xy(Plot_t, vq_d, "vqd");
  }
  else{
    for(i = 0; i < 20; i++){
      if(TagNamesToPlot[i] == "betad"){
	SimuPlot.plot_xy(Plot_t, beta_d, "betad");
      }
      else if(TagNamesToPlot[i] == "alphad"){
	SimuPlot.plot_xy(Plot_t, alpha_d, "alphad");
      }
      else if(TagNamesToPlot[i] == "omegad"){
	SimuPlot.plot_xy(Plot_t, omega_d, "omegad");
      }
      else if(TagNamesToPlot[i] == "thetad"){
	SimuPlot.plot_xy(Plot_t, theta_d, "thetad");
      }
      else if(TagNamesToPlot[i] == "zetad"){
	SimuPlot.plot_xy(Plot_t, zeta_d, "zetad");
      }
      else if(TagNamesToPlot[i] == "idd"){
	SimuPlot.plot_xy(Plot_t, id_d, "idd");
      }
      else if(TagNamesToPlot[i] == "iqd"){
	SimuPlot.plot_xy(Plot_t, iq_d, "iqd");
      }
      else if(TagNamesToPlot[i] == "didd"){
	SimuPlot.plot_xy(Plot_t, did_d, "didd");
      }
      else if(TagNamesToPlot[i] == "diqd"){
	SimuPlot.plot_xy(Plot_t, diq_d, "diqd");
      }
      else if(TagNamesToPlot[i] == "vdd"){
	SimuPlot.plot_xy(Plot_t, vd_d, "vdd");
      }
      else if(TagNamesToPlot[i] == "vqd"){
	SimuPlot.plot_xy(Plot_t, vq_d, "vqd");
      }
    }
  }


}

void RefGen::CtrlRValueUpdate(void)
{
  CtrlObjItem * pCurCtrlItem;

  //Update Rvalues
  pCurCtrlItem = pCtrlObjRValList;

  ((VDqCmd *) pCurCtrlItem->pCtrlObject)->vdd = vdd;
  pCurCtrlItem = pCurCtrlItem->pNextCtrlItem;
  ((VDqCmd *) pCurCtrlItem->pCtrlObject)->vqd = vqd;


}





double RefGen::sgn(double omegad)
{
  //code needs to be written here...
  return 0;
}

double RefGen::impulse(double sgn_omegad)
{

  //code needs to be written here...

  return 0;
}





// ---------------------------------------------------------------



// ******************************************************************



// **** CoefObject Functions ****************************************

// ---- Coef_recp_rSrD11 ---------------------------------------------

Coef_recp_rSrD11::Coef_recp_rSrD11(void)
{
  CoefFuncName = COEF_FUNC_recp_rSrD11;
  LiteralName = "recp_rSrD11"; 
  rS11 = INIT_COEF_RS_RD;
  rD11 = INIT_COEF_RS_RD;

}

Coef_recp_rSrD11::~Coef_recp_rSrD11(void)
{


}

void Coef_recp_rSrD11::CoefFunction(double recp_h, bool DoTrapezoidal)
{

  y = 1/rS11 + 1/rD11;

}



// ------------------------------------------------------------------

// ---- Coef_recp_rSrD12 ---------------------------------------------

Coef_recp_rSrD12::Coef_recp_rSrD12(void)
{
  CoefFuncName = COEF_FUNC_recp_rSrD12;
  LiteralName = "recp_rSrD12"; 
  rS12 = INIT_COEF_RS_RD;
  rD12 = INIT_COEF_RS_RD;

}

Coef_recp_rSrD12::~Coef_recp_rSrD12(void)
{


}

void Coef_recp_rSrD12::CoefFunction(double recp_h, bool DoTrapezoidal)
{

  y = 1/rS12 + 1/rD12;

}



// ------------------------------------------------------------------        


// ---- Coef_C1_h ----------------------------------------------------

Coef_C1_h::Coef_C1_h(void)
{
  CoefFuncName = COEF_FUNC_C1_h;
  LiteralName = "C1_h";

}

Coef_C1_h::~Coef_C1_h(void)
{


}

void Coef_C1_h::CoefFunction(double recp_h, bool DoTrapezoidal)
{

	if(DoTrapezoidal)
		y = 2 * C1 * recp_h;
	else
		y = C1 * recp_h;

}

// ------------------------------------------------------------------



// ---- Coef_C11_h ----------------------------------------------------

Coef_C11_h::Coef_C11_h(void)
{
  CoefFuncName = COEF_FUNC_C11_h;
  LiteralName = "C11_h";

}

Coef_C11_h::~Coef_C11_h(void)
{


}

void Coef_C11_h::CoefFunction(double recp_h, bool DoTrapezoidal)
{

	if(DoTrapezoidal)
		y = 2 * C11 * recp_h;
	else
		y = C11 * recp_h;

}

// ------------------------------------------------------------------

// ---- Coef_C12_h ----------------------------------------------------

Coef_C12_h::Coef_C12_h(void)
{
  CoefFuncName = COEF_FUNC_C12_h;
  LiteralName = "C12_h";

}

Coef_C12_h::~Coef_C12_h(void)
{


}

void Coef_C12_h::CoefFunction(double recp_h, bool DoTrapezoidal)
{

	if(DoTrapezoidal)
		y = 2 * C12 * recp_h;
	else
		y = C12 * recp_h;

}

// ------------------------------------------------------------------




// ---- Coef_v11_v12_h_prev_C1 ----------------------------------------------------

Coef_v11_v12_h_prev_C1::Coef_v11_v12_h_prev_C1(void)
{
  CoefFuncName = COEF_FUNC_v11_v12_h_prev_C1;
  LiteralName = "v11_v12_h_prev_C1";

	//Assign initial states...
  v11_ = (6.0 * (PLUS_DC_BUS_VOLTAGE - MINUS_DC_BUS_VOLTAGE) / 6.0) + MINUS_DC_BUS_VOLTAGE + ((PLUS_DC_BUS_VOLTAGE - MINUS_DC_BUS_VOLTAGE) / 4.0); //(+1500)
  v12_ = (6.0 * (PLUS_DC_BUS_VOLTAGE - MINUS_DC_BUS_VOLTAGE) / 6.0) + MINUS_DC_BUS_VOLTAGE;														 //(+1000)

}

Coef_v11_v12_h_prev_C1::~Coef_v11_v12_h_prev_C1(void)
{


}

void Coef_v11_v12_h_prev_C1::CoefFunction(double recp_h, bool DoTrapezoidal)
{

	if(DoTrapezoidal)
		y = 2 * (v11_ - v12_) * C1 * recp_h - i1_;
	else
		y = (v11_ - v12_) * C1 * recp_h;

}

// ------------------------------------------------------------------    


// ---- Coef_minus_v11_h_prev_minus_PlusBus_C11 ----------------------------------------------------

Coef_minus_v11_h_prev_minus_PlusBus_C11::Coef_minus_v11_h_prev_minus_PlusBus_C11(void)
{
  CoefFuncName = COEF_FUNC_minus_v11_h_prev_minus_PlusBus_C11;
  LiteralName = "minus_v11_h_prev_minus_PlusBus_C11";

	//Assign initial states...
  v11_ = (6.0 * (PLUS_DC_BUS_VOLTAGE - MINUS_DC_BUS_VOLTAGE) / 6.0) + MINUS_DC_BUS_VOLTAGE + ((PLUS_DC_BUS_VOLTAGE - MINUS_DC_BUS_VOLTAGE) / 4.0); //(+1500)

}

Coef_minus_v11_h_prev_minus_PlusBus_C11::~Coef_minus_v11_h_prev_minus_PlusBus_C11(void)
{



}

void Coef_minus_v11_h_prev_minus_PlusBus_C11::CoefFunction(double recp_h, bool DoTrapezoidal)
{

	if(DoTrapezoidal)
		y = - 2 * v11_ * C11 * recp_h - i1ct_;
	else
		y = - v11_ * C11 * recp_h;

}

// ------------------------------------------------------------------




// ---- Coef_v12_h_prev_plus_PlusBus_C12 ----------------------------------------------------

Coef_v12_h_prev_plus_PlusBus_C12::Coef_v12_h_prev_plus_PlusBus_C12(void)
{
  CoefFuncName = COEF_FUNC_v12_h_prev_plus_PlusBus_C12;
  LiteralName = "v12_h_prev_plus_PlusBus_C12";

	//Assign initial states...
  v12_ = (6.0 * (PLUS_DC_BUS_VOLTAGE - MINUS_DC_BUS_VOLTAGE) / 6.0) + MINUS_DC_BUS_VOLTAGE;														 //(+1000)

}

Coef_v12_h_prev_plus_PlusBus_C12::~Coef_v12_h_prev_plus_PlusBus_C12(void)
{

}

void Coef_v12_h_prev_plus_PlusBus_C12::CoefFunction(double recp_h, bool DoTrapezoidal)
{

	if(DoTrapezoidal)
		y =  2 * v12_ * C12 * recp_h - i1cb_;
	else
		y =  v12_ * C12 * recp_h;

}

// ------------------------------------------------------------------





// ---- Coef_recp_rSrD21 ---------------------------------------------

Coef_recp_rSrD21::Coef_recp_rSrD21(void)
{
  CoefFuncName = COEF_FUNC_recp_rSrD21;
  LiteralName = "recp_rSrD21"; 
  rS21 = INIT_COEF_RS_RD;
  rD21 = INIT_COEF_RS_RD;

}

Coef_recp_rSrD21::~Coef_recp_rSrD21(void)
{


}

void Coef_recp_rSrD21::CoefFunction(double recp_h, bool DoTrapezoidal)
{

  y = 1/rS21 + 1/rD21;

}



// ------------------------------------------------------------------

// ---- Coef_recp_rSrD22 ---------------------------------------------

Coef_recp_rSrD22::Coef_recp_rSrD22(void)
{
  CoefFuncName = COEF_FUNC_recp_rSrD22;
  LiteralName = "recp_rSrD22"; 
  rS22 = INIT_COEF_RS_RD;
  rD22 = INIT_COEF_RS_RD;

}

Coef_recp_rSrD22::~Coef_recp_rSrD22(void)
{


}

void Coef_recp_rSrD22::CoefFunction(double recp_h, bool DoTrapezoidal)
{

  y = 1/rS22 + 1/rD22;

}

// ------------------------------------------------------------------  




// ---- Coef_C2_h ----------------------------------------------------

Coef_C2_h::Coef_C2_h(void)
{
  CoefFuncName = COEF_FUNC_C2_h;
  LiteralName = "C2_h";

}

Coef_C2_h::~Coef_C2_h(void)
{


}

void Coef_C2_h::CoefFunction(double recp_h, bool DoTrapezoidal)
{

	if(DoTrapezoidal)
		y = 2 * C2 * recp_h;
	else
		y = C2 * recp_h;

}

// ------------------------------------------------------------------



// ---- Coef_C21_h ----------------------------------------------------

Coef_C21_h::Coef_C21_h(void)
{
  CoefFuncName = COEF_FUNC_C21_h;
  LiteralName = "C21_h";

}

Coef_C21_h::~Coef_C21_h(void)
{


}

void Coef_C21_h::CoefFunction(double recp_h, bool DoTrapezoidal)
{

	if(DoTrapezoidal)
		y = 2 * C21 * recp_h;
	else
		y = C21 * recp_h;

}

// ------------------------------------------------------------------

// ---- Coef_C22_h ----------------------------------------------------

Coef_C22_h::Coef_C22_h(void)
{
  CoefFuncName = COEF_FUNC_C22_h;
  LiteralName = "C22_h";

}

Coef_C22_h::~Coef_C22_h(void)
{


}

void Coef_C22_h::CoefFunction(double recp_h, bool DoTrapezoidal)
{

	if(DoTrapezoidal)
		y = 2 * C22 * recp_h;
	else
		y = C22 * recp_h;

}

// ------------------------------------------------------------------




// ---- Coef_v21_v23_h_prev_C2 ----------------------------------------------------

Coef_v21_v23_h_prev_C2::Coef_v21_v23_h_prev_C2(void)
{
  CoefFuncName = COEF_FUNC_v21_v23_h_prev_C2;
  LiteralName = "v21_v23_h_prev_C2";

	//Assign initial states...
  v21_ = (5.0 * (PLUS_DC_BUS_VOLTAGE - MINUS_DC_BUS_VOLTAGE) / 6.0) + MINUS_DC_BUS_VOLTAGE + ((PLUS_DC_BUS_VOLTAGE - MINUS_DC_BUS_VOLTAGE) / 4.0); //(+1166.66)
  v23_ = (5.0 * (PLUS_DC_BUS_VOLTAGE - MINUS_DC_BUS_VOLTAGE) / 6.0) + MINUS_DC_BUS_VOLTAGE;														 //(+666.66)

}

Coef_v21_v23_h_prev_C2::~Coef_v21_v23_h_prev_C2(void)
{



}

void Coef_v21_v23_h_prev_C2::CoefFunction(double recp_h, bool DoTrapezoidal)
{

	if(DoTrapezoidal)
		y = 2 * (v21_ - v23_) * C2 * recp_h - i2_;
	else
		y = (v21_ - v23_) * C2 * recp_h;

}

// ------------------------------------------------------------------


// ---- Coef_v12_v21_h_prev_C21 ----------------------------------------------------

Coef_v12_v21_h_prev_C21::Coef_v12_v21_h_prev_C21(void)
{
  CoefFuncName = COEF_FUNC_v12_v21_h_prev_C21;
  LiteralName = "v12_v21_h_prev_C21";

	//Assign initial states...
  v12_ = (6.0 * (PLUS_DC_BUS_VOLTAGE - MINUS_DC_BUS_VOLTAGE) / 6.0) + MINUS_DC_BUS_VOLTAGE;														 //(+1000)
  v21_ = (5.0 * (PLUS_DC_BUS_VOLTAGE - MINUS_DC_BUS_VOLTAGE) / 6.0) + MINUS_DC_BUS_VOLTAGE + ((PLUS_DC_BUS_VOLTAGE - MINUS_DC_BUS_VOLTAGE) / 4.0); //(+1166.66)

}

Coef_v12_v21_h_prev_C21::~Coef_v12_v21_h_prev_C21(void)
{


}

void Coef_v12_v21_h_prev_C21::CoefFunction(double recp_h, bool DoTrapezoidal)
{

	if(DoTrapezoidal)
		y = 2 * (v12_ - v21_) * C21 * recp_h - i2ct_;
	else
		y = (v12_ - v21_) * C21 * recp_h;

}

// ------------------------------------------------------------------


// ---- Coef_v23_v12_h_prev_C22 ----------------------------------------------------

Coef_v23_v12_h_prev_C22::Coef_v23_v12_h_prev_C22(void)
{
  CoefFuncName = COEF_FUNC_v23_v12_h_prev_C22;
  LiteralName = "v23_v12_h_prev_C22";

	//Assign initial states...
  v12_ = (6.0 * (PLUS_DC_BUS_VOLTAGE - MINUS_DC_BUS_VOLTAGE) / 6.0) + MINUS_DC_BUS_VOLTAGE;														 //(+1000)
  v23_ = (5.0 * (PLUS_DC_BUS_VOLTAGE - MINUS_DC_BUS_VOLTAGE) / 6.0) + MINUS_DC_BUS_VOLTAGE;														 //(+666.66)


}

Coef_v23_v12_h_prev_C22::~Coef_v23_v12_h_prev_C22(void)
{

}

void Coef_v23_v12_h_prev_C22::CoefFunction(double recp_h, bool DoTrapezoidal)
{

	if(DoTrapezoidal)
		y = 2 * (v23_ - v12_) * C22 * recp_h - i2cb_;
	else
		y = (v23_ - v12_) * C22 * recp_h;

}

// ------------------------------------------------------------------    



// ---- Coef_recp_rSrD31 ---------------------------------------------

Coef_recp_rSrD31::Coef_recp_rSrD31(void)
{
  CoefFuncName = COEF_FUNC_recp_rSrD31;
  LiteralName = "recp_rSrD31";
  rS31 = INIT_COEF_RS_RD;
  rD31 = INIT_COEF_RS_RD;

}

Coef_recp_rSrD31::~Coef_recp_rSrD31(void)
{


}

void Coef_recp_rSrD31::CoefFunction(double recp_h, bool DoTrapezoidal)
{

  y = 1/rS31 + 1/rD31;

}

// ------------------------------------------------------------------

// ---- Coef_recp_rSrD32 ---------------------------------------------

Coef_recp_rSrD32::Coef_recp_rSrD32(void)
{
  CoefFuncName = COEF_FUNC_recp_rSrD32;
  LiteralName = "recp_rSrD32";
  rS32 = INIT_COEF_RS_RD;
  rD32 = INIT_COEF_RS_RD;

}

Coef_recp_rSrD32::~Coef_recp_rSrD32(void)
{


}

void Coef_recp_rSrD32::CoefFunction(double recp_h, bool DoTrapezoidal)
{

  y = 1/rS32 + 1/rD32;

}
// ------------------------------------------------------------------




// ---- Coef_C3_h ----------------------------------------------------

Coef_C3_h::Coef_C3_h(void)
{
  CoefFuncName = COEF_FUNC_C3_h;
  LiteralName = "C3_h";

}

Coef_C3_h::~Coef_C3_h(void)
{


}

void Coef_C3_h::CoefFunction(double recp_h, bool DoTrapezoidal)
{

	if(DoTrapezoidal)
		y = 2 * C3 *  recp_h;
	else
		y = C3 * recp_h;

}

// ------------------------------------------------------------------



// ---- Coef_C31_h ----------------------------------------------------

Coef_C31_h::Coef_C31_h(void)
{
  CoefFuncName = COEF_FUNC_C31_h;
  LiteralName = "C31_h";

}

Coef_C31_h::~Coef_C31_h(void)
{


}

void Coef_C31_h::CoefFunction(double recp_h, bool DoTrapezoidal)
{

	if(DoTrapezoidal)
		y = 2 * C31 * recp_h;
	else
		y = C31 * recp_h;

}

// ------------------------------------------------------------------



// ---- Coef_C32_h ----------------------------------------------------

Coef_C32_h::Coef_C32_h(void)
{
  CoefFuncName = COEF_FUNC_C32_h;
  LiteralName = "C32_h";

}

Coef_C32_h::~Coef_C32_h(void)
{


}

void Coef_C32_h::CoefFunction(double recp_h, bool DoTrapezoidal)
{

	if(DoTrapezoidal)
		y = 2 * C32 * recp_h;
	else
		y = C32 * recp_h;

}

// ------------------------------------------------------------------




// ---- Coef_v31_v34_h_prev_C3 ----------------------------------------------------

Coef_v31_v34_h_prev_C3::Coef_v31_v34_h_prev_C3(void)
{
  CoefFuncName = COEF_FUNC_v31_v34_h_prev_C3;
  LiteralName = "v31_v34_h_prev_C3";

	//Assign initial states...
  v31_ = (4.0 * (PLUS_DC_BUS_VOLTAGE - MINUS_DC_BUS_VOLTAGE) / 6.0) + MINUS_DC_BUS_VOLTAGE + ((PLUS_DC_BUS_VOLTAGE - MINUS_DC_BUS_VOLTAGE) / 4.0); //(+833.33)
  v34_ = (4.0 * (PLUS_DC_BUS_VOLTAGE - MINUS_DC_BUS_VOLTAGE) / 6.0) + MINUS_DC_BUS_VOLTAGE;														 //(+333.33)

}

Coef_v31_v34_h_prev_C3::~Coef_v31_v34_h_prev_C3(void)
{

}

void Coef_v31_v34_h_prev_C3::CoefFunction(double recp_h, bool DoTrapezoidal)
{

	if(DoTrapezoidal)
		y = 2 * (v31_ - v34_) * C3 * recp_h - i3_;
	else
		y = (v31_ - v34_) * C3 * recp_h;

}

// ------------------------------------------------------------------


// ---- Coef_v23_v31_h_prev_C31 ----------------------------------------------------

Coef_v23_v31_h_prev_C31::Coef_v23_v31_h_prev_C31(void)
{
  CoefFuncName = COEF_FUNC_v23_v31_h_prev_C31;
  LiteralName = "v23_v31_h_prev_C31";

	//Assign initial states...
  v31_ = (4.0 * (PLUS_DC_BUS_VOLTAGE - MINUS_DC_BUS_VOLTAGE) / 6.0) + MINUS_DC_BUS_VOLTAGE + ((PLUS_DC_BUS_VOLTAGE - MINUS_DC_BUS_VOLTAGE) / 4.0); //(+833.33)
  v23_ = (5.0 * (PLUS_DC_BUS_VOLTAGE - MINUS_DC_BUS_VOLTAGE) / 6.0) + MINUS_DC_BUS_VOLTAGE;														 //(+666.66)

}

Coef_v23_v31_h_prev_C31::~Coef_v23_v31_h_prev_C31(void)
{

}

void Coef_v23_v31_h_prev_C31::CoefFunction(double recp_h, bool DoTrapezoidal)
{

	if(DoTrapezoidal)
		y = 2 * (v23_ - v31_) * C31 * recp_h - i3ct_;
	else
		y = (v23_ - v31_) * C31 * recp_h;

}

// ------------------------------------------------------------------


// ---- Coef_v34_v23_h_prev_C32 ----------------------------------------------------

Coef_v34_v23_h_prev_C32::Coef_v34_v23_h_prev_C32(void)
{
  CoefFuncName = COEF_FUNC_v34_v23_h_prev_C32;
  LiteralName = "v34_v23_h_prev_C32";

	//Assign initial states...
  v23_ = (5.0 * (PLUS_DC_BUS_VOLTAGE - MINUS_DC_BUS_VOLTAGE) / 6.0) + MINUS_DC_BUS_VOLTAGE;														 //(+666.66)
  v34_ = (4.0 * (PLUS_DC_BUS_VOLTAGE - MINUS_DC_BUS_VOLTAGE) / 6.0) + MINUS_DC_BUS_VOLTAGE;														 //(+333.33)

}

Coef_v34_v23_h_prev_C32::~Coef_v34_v23_h_prev_C32(void)
{

}

void Coef_v34_v23_h_prev_C32::CoefFunction(double recp_h, bool DoTrapezoidal)
{

	if(DoTrapezoidal)
		y = 2 * (v34_ - v23_) * C32 * recp_h - i3cb_;
	else
		y = (v34_ - v23_) * C32 * recp_h;

}

// ------------------------------------------------------------------




// ---- Coef_recp_rSrD41 ---------------------------------------------

Coef_recp_rSrD41::Coef_recp_rSrD41(void)
{
  CoefFuncName = COEF_FUNC_recp_rSrD41;
  LiteralName = "recp_rSrD41"; 
  rS41 = INIT_COEF_RS_RD;
  rD41 = INIT_COEF_RS_RD;

}

Coef_recp_rSrD41::~Coef_recp_rSrD41(void)
{


}

void Coef_recp_rSrD41::CoefFunction(double recp_h, bool DoTrapezoidal)
{

  y = 1/rS41 + 1/rD41;

}

// ------------------------------------------------------------------

// ---- Coef_recp_rSrD42 ---------------------------------------------

Coef_recp_rSrD42::Coef_recp_rSrD42(void)
{
  CoefFuncName = COEF_FUNC_recp_rSrD42;
  LiteralName = "recp_rSrD42"; 
  rS42 = INIT_COEF_RS_RD;
  rD42 = INIT_COEF_RS_RD;

}

Coef_recp_rSrD42::~Coef_recp_rSrD42(void)
{


}

void Coef_recp_rSrD42::CoefFunction(double recp_h, bool DoTrapezoidal)
{

  y = 1/rS42 + 1/rD42;

}

// ------------------------------------------------------------------  




// ---- Coef_C4_h ----------------------------------------------------

Coef_C4_h::Coef_C4_h(void)
{
  CoefFuncName = COEF_FUNC_C4_h;
  LiteralName = "C4_h";

}

Coef_C4_h::~Coef_C4_h(void)
{


}

void Coef_C4_h::CoefFunction(double recp_h, bool DoTrapezoidal)
{

	if(DoTrapezoidal)
		y = 2 * C4 * recp_h;
	else
		y = C4 * recp_h;

}

// ------------------------------------------------------------------



// ---- Coef_C41_h ----------------------------------------------------

Coef_C41_h::Coef_C41_h(void)
{
  CoefFuncName = COEF_FUNC_C41_h;
  LiteralName = "C41_h";

}

Coef_C41_h::~Coef_C41_h(void)
{


}

void Coef_C41_h::CoefFunction(double recp_h, bool DoTrapezoidal)
{

	if(DoTrapezoidal)
		y = 2 * C41 * recp_h;
	else
		y = C41 * recp_h;

}

// ------------------------------------------------------------------



// ---- Coef_C42_h ----------------------------------------------------

Coef_C42_h::Coef_C42_h(void)
{
  CoefFuncName = COEF_FUNC_C42_h;
  LiteralName = "C42_h";

}

Coef_C42_h::~Coef_C42_h(void)
{


}

void Coef_C42_h::CoefFunction(double recp_h, bool DoTrapezoidal)
{

	if(DoTrapezoidal)
		y = 2 * C42 * recp_h;
	else
		y = C42 * recp_h;

}

// ------------------------------------------------------------------




// ---- Coef_v41_v44_h_prev_C4 ----------------------------------------------------

Coef_v41_v44_h_prev_C4::Coef_v41_v44_h_prev_C4(void)
{
  CoefFuncName = COEF_FUNC_v41_v44_h_prev_C4;
  LiteralName = "v41_v44_h_prev_C4";

	//Assign initial states...
  v41_ = (3.0 * (PLUS_DC_BUS_VOLTAGE - MINUS_DC_BUS_VOLTAGE) / 6.0) + MINUS_DC_BUS_VOLTAGE + ((PLUS_DC_BUS_VOLTAGE - MINUS_DC_BUS_VOLTAGE) / 4.0); //(+500.00)
  v44_ = (3.0 * (PLUS_DC_BUS_VOLTAGE - MINUS_DC_BUS_VOLTAGE) / 6.0) + MINUS_DC_BUS_VOLTAGE;														 //(0.0)

}

Coef_v41_v44_h_prev_C4::~Coef_v41_v44_h_prev_C4(void)
{


}

void Coef_v41_v44_h_prev_C4::CoefFunction(double recp_h, bool DoTrapezoidal)
{

	if(DoTrapezoidal)
		y = 2 * (v41_ - v44_) * C4 * recp_h - i4_;
	else
		y = (v41_ - v44_) * C4 * recp_h;

}

// ------------------------------------------------------------------


// ---- Coef_v34_v41_h_prev_C41 ----------------------------------------------------

Coef_v34_v41_h_prev_C41::Coef_v34_v41_h_prev_C41(void)
{
  CoefFuncName = COEF_FUNC_v34_v41_h_prev_C41;
  LiteralName = "v34_v41_h_prev_C41";

	//Assign initial states...
  v41_ = (3.0 * (PLUS_DC_BUS_VOLTAGE - MINUS_DC_BUS_VOLTAGE) / 6.0) + MINUS_DC_BUS_VOLTAGE + ((PLUS_DC_BUS_VOLTAGE - MINUS_DC_BUS_VOLTAGE) / 4.0); //(+500.00)
  v34_ = (4.0 * (PLUS_DC_BUS_VOLTAGE - MINUS_DC_BUS_VOLTAGE) / 6.0) + MINUS_DC_BUS_VOLTAGE;														 //(+333.33)

}

Coef_v34_v41_h_prev_C41::~Coef_v34_v41_h_prev_C41(void)
{

}

void Coef_v34_v41_h_prev_C41::CoefFunction(double recp_h, bool DoTrapezoidal)
{

	if(DoTrapezoidal)
		y = 2 * (v34_ - v41_) * C41 * recp_h - i4ct_;
	else
		y = (v34_ - v41_) * C41 * recp_h;

}

// ------------------------------------------------------------------


// ---- Coef_v44_v34_h_prev_C42 ----------------------------------------------------

Coef_v44_v34_h_prev_C42::Coef_v44_v34_h_prev_C42(void)
{
  CoefFuncName = COEF_FUNC_v44_v34_h_prev_C42;
  LiteralName = "v44_v34_h_prev_C42";

	//Assign initial states...
  v34_ = (4.0 * (PLUS_DC_BUS_VOLTAGE - MINUS_DC_BUS_VOLTAGE) / 6.0) + MINUS_DC_BUS_VOLTAGE;														 //(+333.33)
  v44_ = (3.0 * (PLUS_DC_BUS_VOLTAGE - MINUS_DC_BUS_VOLTAGE) / 6.0) + MINUS_DC_BUS_VOLTAGE;														 //(0.0)



}

Coef_v44_v34_h_prev_C42::~Coef_v44_v34_h_prev_C42(void)
{

}

void Coef_v44_v34_h_prev_C42::CoefFunction(double recp_h, bool DoTrapezoidal)
{

	if(DoTrapezoidal)
		y = 2 * (v44_ - v34_) * C42 * recp_h - i4cb_;
	else
		y = (v44_ - v34_) * C42 * recp_h;

}

// ------------------------------------------------------------------




// ---- Coef_Lp_h ---------------------------------------------------


Coef_Lp_h::Coef_Lp_h(void)
{
	CoefFuncName = COEF_FUNC_Lp_h;
	LiteralName = "Lp_h";
}

Coef_Lp_h::~Coef_Lp_h(void)
{



}

void Coef_Lp_h::CoefFunction(double recp_h, bool DoTrapezoidal)
{

	if(DoTrapezoidal)
		y = 2 * Lp * recp_h;
	else
		y = Lp * recp_h;

}


// ------------------------------------------------------------------

// ---- Coef_Mpn_h ---------------------------------------------------

Coef_Mpn_h::Coef_Mpn_h(void)
{
	CoefFuncName = COEF_FUNC_Mpn_h;
	LiteralName = "Mpn_h";
}

Coef_Mpn_h::~Coef_Mpn_h(void)
{



}

void Coef_Mpn_h::CoefFunction(double recp_h, bool DoTrapezoidal)
{

	if(DoTrapezoidal)
		y = 2 * Mpn * recp_h;
	else
		y = Mpn * recp_h;

}


// ------------------------------------------------------------------


// ---- Coef_Mnp_h ---------------------------------------------------

Coef_Mnp_h::Coef_Mnp_h(void)
{
	CoefFuncName = COEF_FUNC_Mnp_h;
	LiteralName = "Mnp_h";
}

Coef_Mnp_h::~Coef_Mnp_h(void)
{



}

void Coef_Mnp_h::CoefFunction(double recp_h, bool DoTrapezoidal)
{

	if(DoTrapezoidal)
		y = 2 * Mnp * recp_h;
	else
		y = Mnp * recp_h;

}


// ------------------------------------------------------------------

// ---- Coef_Ln_h ---------------------------------------------------


Coef_Ln_h::Coef_Ln_h(void)
{
	CoefFuncName = COEF_FUNC_Ln_h;
	LiteralName = "Ln_h";
}

Coef_Ln_h::~Coef_Ln_h(void)
{



}

void Coef_Ln_h::CoefFunction(double recp_h, bool DoTrapezoidal)
{

	if(DoTrapezoidal)
		y = 2 * Ln * recp_h;
	else
		y = Ln * recp_h;

}


// ------------------------------------------------------------------




// ---- Coef_iLp_iLn_h_prev_Lp_Mpn ----------------------------------

Coef_iLp_iLn_h_prev_Lp_Mpn::Coef_iLp_iLn_h_prev_Lp_Mpn(void)
{
	CoefFuncName = COEF_FUNC_iLp_iLn_h_prev_Lp_Mpn;
	LiteralName = "iLp_iLn_h_prev_Lp_Mpn";


}

Coef_iLp_iLn_h_prev_Lp_Mpn::~Coef_iLp_iLn_h_prev_Lp_Mpn(void)
{


}

void Coef_iLp_iLn_h_prev_Lp_Mpn::CoefFunction(double recp_h, bool DoTrapezoidal)
{
	if(DoTrapezoidal)
		y = 2 * (Lp*iLp_*recp_h + Mpn*iLn_*recp_h) + v44_ - vs_a_;
	else
		y = Lp*iLp_*recp_h + Mpn*iLn_*recp_h;

}


// ------------------------------------------------------------------





// ---- Coef_iLp_iLn_h_prev_Mnp_Ln ----------------------------------

Coef_iLp_iLn_h_prev_Mnp_Ln::Coef_iLp_iLn_h_prev_Mnp_Ln(void)
{
	CoefFuncName = COEF_FUNC_iLp_iLn_h_prev_Mnp_Ln;
	LiteralName = "iLp_iLn_h_prev_Mnp_Ln";

}

Coef_iLp_iLn_h_prev_Mnp_Ln::~Coef_iLp_iLn_h_prev_Mnp_Ln(void)
{


}

void Coef_iLp_iLn_h_prev_Mnp_Ln::CoefFunction(double recp_h, bool DoTrapezoidal)
{
	if(DoTrapezoidal)
		y = 2 * (Mnp*iLp_*recp_h + Ln*iLn_*recp_h) + vs_a_ - v45_;
	else
		y = Mnp*iLp_*recp_h +  Ln*iLn_*recp_h;

}


// ------------------------------------------------------------------




// ---- Coef_ia ----------------------------------------------------

Coef_ia::Coef_ia(void)
{
  CoefFuncName = COEF_FUNC_ia;
  LiteralName = "ia"; 

}

Coef_ia::~Coef_ia(void)
{


}

void Coef_ia::CoefFunction(double recp_h, bool DoTrapezoidal)
{

  y = ia;

}

// ------------------------------------------------------------------    




// ---- Coef_recp_rSrD51 ---------------------------------------------

Coef_recp_rSrD51::Coef_recp_rSrD51(void)
{
  CoefFuncName = COEF_FUNC_recp_rSrD51;
  LiteralName = "recp_rSrD51"; 
  rS51 = INIT_COEF_RS_RD;
  rD51 = INIT_COEF_RS_RD;

}

Coef_recp_rSrD51::~Coef_recp_rSrD51(void)
{


}

void Coef_recp_rSrD51::CoefFunction(double recp_h, bool DoTrapezoidal)
{

  y = 1/rS51 + 1/rD51;

}

// ------------------------------------------------------------------

// ---- Coef_recp_rSrD52 ---------------------------------------------

Coef_recp_rSrD52::Coef_recp_rSrD52(void)
{
  CoefFuncName = COEF_FUNC_recp_rSrD52;
  LiteralName = "recp_rSrD52"; 
  rS52 = INIT_COEF_RS_RD;
  rD52 = INIT_COEF_RS_RD;

}

Coef_recp_rSrD52::~Coef_recp_rSrD52(void)
{


}

void Coef_recp_rSrD52::CoefFunction(double recp_h, bool DoTrapezoidal)
{

  y = 1/rS52 + 1/rD52;

}

// ------------------------------------------------------------------  




// ---- Coef_C5_h ----------------------------------------------------

Coef_C5_h::Coef_C5_h(void)
{
  CoefFuncName = COEF_FUNC_C5_h;
  LiteralName = "C5_h";

}

Coef_C5_h::~Coef_C5_h(void)
{


}

void Coef_C5_h::CoefFunction(double recp_h, bool DoTrapezoidal)
{

	if(DoTrapezoidal)
		y = 2 * C5 * recp_h;
	else
		y = C5 * recp_h;

}

// ------------------------------------------------------------------



// ---- Coef_C51_h ----------------------------------------------------

Coef_C51_h::Coef_C51_h(void)
{
  CoefFuncName = COEF_FUNC_C51_h;
  LiteralName = "C51_h";

}

Coef_C51_h::~Coef_C51_h(void)
{


}

void Coef_C51_h::CoefFunction(double recp_h, bool DoTrapezoidal)
{

	if(DoTrapezoidal)
		y = 2 * C51 * recp_h;
	else
		y = C51 * recp_h;

}

// ------------------------------------------------------------------



// ---- Coef_C52_h ----------------------------------------------------

Coef_C52_h::Coef_C52_h(void)
{
  CoefFuncName = COEF_FUNC_C52_h;
  LiteralName = "C52_h";

}

Coef_C52_h::~Coef_C52_h(void)
{


}

void Coef_C52_h::CoefFunction(double recp_h, bool DoTrapezoidal)
{

	if(DoTrapezoidal)
		y = 2 * C52 * recp_h;
	else
		y = C52 * recp_h;

}

// ------------------------------------------------------------------




// ---- Coef_v51_v56_h_prev_C5 ----------------------------------------------------

Coef_v51_v56_h_prev_C5::Coef_v51_v56_h_prev_C5(void)
{
  CoefFuncName = COEF_FUNC_v51_v56_h_prev_C5;
  LiteralName = "v51_v56_h_prev_C5";

	//Assign initial states...
  v51_ = (2.0 * (PLUS_DC_BUS_VOLTAGE - MINUS_DC_BUS_VOLTAGE) / 6.0) + MINUS_DC_BUS_VOLTAGE + ((PLUS_DC_BUS_VOLTAGE - MINUS_DC_BUS_VOLTAGE) / 4.0); //(+166.66)
  v56_ = (2.0 * (PLUS_DC_BUS_VOLTAGE - MINUS_DC_BUS_VOLTAGE) / 6.0) + MINUS_DC_BUS_VOLTAGE;														 //(-333.33)

}

Coef_v51_v56_h_prev_C5::~Coef_v51_v56_h_prev_C5(void)
{


}

void Coef_v51_v56_h_prev_C5::CoefFunction(double recp_h, bool DoTrapezoidal)
{

	if(DoTrapezoidal)
		y = 2 * (v51_ - v56_) * C5 * recp_h - i5_;
	else
		y = (v51_ - v56_) * C5 * recp_h;

}

// ------------------------------------------------------------------


// ---- Coef_v45_v51_h_prev_C51 ----------------------------------------------------

Coef_v45_v51_h_prev_C51::Coef_v45_v51_h_prev_C51(void)
{
  CoefFuncName = COEF_FUNC_v45_v51_h_prev_C51;
  LiteralName = "v45_v51_h_prev_C51";

	//Assign initial states...
  v51_ = (2.0 * (PLUS_DC_BUS_VOLTAGE - MINUS_DC_BUS_VOLTAGE) / 6.0) + MINUS_DC_BUS_VOLTAGE + ((PLUS_DC_BUS_VOLTAGE - MINUS_DC_BUS_VOLTAGE) / 4.0); //(+166.66)
  v45_ = (3.0 * (PLUS_DC_BUS_VOLTAGE - MINUS_DC_BUS_VOLTAGE) / 6.0) + MINUS_DC_BUS_VOLTAGE;														 //(0.0)

}

Coef_v45_v51_h_prev_C51::~Coef_v45_v51_h_prev_C51(void)
{

}

void Coef_v45_v51_h_prev_C51::CoefFunction(double recp_h, bool DoTrapezoidal)
{

	if(DoTrapezoidal)
		y = 2 * (v45_ - v51_) * C51 * recp_h - i5ct_;
	else
		y = (v45_ - v51_) * C51 * recp_h;

}

// ------------------------------------------------------------------


// ---- Coef_v56_v45_h_prev_C52 ----------------------------------------------------

Coef_v56_v45_h_prev_C52::Coef_v56_v45_h_prev_C52(void)
{
  CoefFuncName = COEF_FUNC_v56_v45_h_prev_C52;
  LiteralName = "v56_v45_h_prev_C52";

	//Assign initial states...
  v56_ = (2.0 * (PLUS_DC_BUS_VOLTAGE - MINUS_DC_BUS_VOLTAGE) / 6.0) + MINUS_DC_BUS_VOLTAGE;														 //(-333.33)
  v45_ = (3.0 * (PLUS_DC_BUS_VOLTAGE - MINUS_DC_BUS_VOLTAGE) / 6.0) + MINUS_DC_BUS_VOLTAGE;														 //(0.0)

}

Coef_v56_v45_h_prev_C52::~Coef_v56_v45_h_prev_C52(void)
{


}

void Coef_v56_v45_h_prev_C52::CoefFunction(double recp_h, bool DoTrapezoidal)
{

	if(DoTrapezoidal)
		y = 2 * (v56_ - v45_) * C52 * recp_h - i5cb_;
	else
		y = (v56_ - v45_) * C52 * recp_h;

}

// ------------------------------------------------------------------



// ---- Coef_recp_rSrD61 ---------------------------------------------

Coef_recp_rSrD61::Coef_recp_rSrD61(void)
{
  CoefFuncName = COEF_FUNC_recp_rSrD61;
  LiteralName = "recp_rSrD61"; 
  rS61 = INIT_COEF_RS_RD;
  rD61 = INIT_COEF_RS_RD;

}

Coef_recp_rSrD61::~Coef_recp_rSrD61(void)
{


}

void Coef_recp_rSrD61::CoefFunction(double recp_h, bool DoTrapezoidal)
{

  y = 1/rS61 + 1/rD61;

}

// ------------------------------------------------------------------

// ---- Coef_recp_rSrD62 ---------------------------------------------

Coef_recp_rSrD62::Coef_recp_rSrD62(void)
{
  CoefFuncName = COEF_FUNC_recp_rSrD62;
  LiteralName = "recp_rSrD62"; 
  rS62 = INIT_COEF_RS_RD;
  rD62 = INIT_COEF_RS_RD;

}

Coef_recp_rSrD62::~Coef_recp_rSrD62(void)
{


}

void Coef_recp_rSrD62::CoefFunction(double recp_h, bool DoTrapezoidal)
{

  y = 1/rS62 + 1/rD62;

}

// ------------------------------------------------------------------ 



// ---- Coef_C6_h ----------------------------------------------------

Coef_C6_h::Coef_C6_h(void)
{
  CoefFuncName = COEF_FUNC_C6_h;
  LiteralName = "C6_h";

}

Coef_C6_h::~Coef_C6_h(void)
{


}

void Coef_C6_h::CoefFunction(double recp_h, bool DoTrapezoidal)
{

	if(DoTrapezoidal)
		y = 2 * C6 * recp_h;
	else
		y = C6 * recp_h;

}

// ------------------------------------------------------------------



// ---- Coef_C61_h ----------------------------------------------------

Coef_C61_h::Coef_C61_h(void)
{
  CoefFuncName = COEF_FUNC_C61_h;
  LiteralName = "C61_h";

}

Coef_C61_h::~Coef_C61_h(void)
{


}

void Coef_C61_h::CoefFunction(double recp_h, bool DoTrapezoidal)
{

	if(DoTrapezoidal)
		y = 2 * C61 * recp_h;
	else
		y = C61 * recp_h;

}

// ------------------------------------------------------------------



// ---- Coef_C62_h ----------------------------------------------------

Coef_C62_h::Coef_C62_h(void)
{
  CoefFuncName = COEF_FUNC_C62_h;
  LiteralName = "C62_h";

}

Coef_C62_h::~Coef_C62_h(void)
{


}

void Coef_C62_h::CoefFunction(double recp_h, bool DoTrapezoidal)
{

	if(DoTrapezoidal)
		y = 2 * C62 * recp_h;
	else
		y = C62 * recp_h;

}

// ------------------------------------------------------------------




// ---- Coef_v61_v67_h_prev_C6 ----------------------------------------------------

Coef_v61_v67_h_prev_C6::Coef_v61_v67_h_prev_C6(void)
{
  CoefFuncName = COEF_FUNC_v61_v67_h_prev_C6;
  LiteralName = "v61_v67_h_prev_C6";

	//Assign initial states...
  v61_ = (1.0 * (PLUS_DC_BUS_VOLTAGE - MINUS_DC_BUS_VOLTAGE) / 6.0) + MINUS_DC_BUS_VOLTAGE + ((PLUS_DC_BUS_VOLTAGE - MINUS_DC_BUS_VOLTAGE) / 4.0); //(-166.66)
  v67_ = (1.0 * (PLUS_DC_BUS_VOLTAGE - MINUS_DC_BUS_VOLTAGE) / 6.0) + MINUS_DC_BUS_VOLTAGE;														 //(-666.66)

}

Coef_v61_v67_h_prev_C6::~Coef_v61_v67_h_prev_C6(void)
{


}

void Coef_v61_v67_h_prev_C6::CoefFunction(double recp_h, bool DoTrapezoidal)
{

	if(DoTrapezoidal)
		y = 2 * (v61_ - v67_) * C6 * recp_h - i6_;
	else
		y = (v61_ - v67_) * C6 * recp_h;

}

// ------------------------------------------------------------------


// ---- Coef_v56_v61_h_prev_C61 ----------------------------------------------------

Coef_v56_v61_h_prev_C61::Coef_v56_v61_h_prev_C61(void)
{
  CoefFuncName = COEF_FUNC_v56_v61_h_prev_C61;
  LiteralName = "v56_v61_h_prev_C61";

	//Assign initial states...
  v61_ = (1.0 * (PLUS_DC_BUS_VOLTAGE - MINUS_DC_BUS_VOLTAGE) / 6.0) + MINUS_DC_BUS_VOLTAGE + ((PLUS_DC_BUS_VOLTAGE - MINUS_DC_BUS_VOLTAGE) / 4.0); //(-166.66)
  v56_ = (2.0 * (PLUS_DC_BUS_VOLTAGE - MINUS_DC_BUS_VOLTAGE) / 6.0) + MINUS_DC_BUS_VOLTAGE;														 //(-333.33)

}

Coef_v56_v61_h_prev_C61::~Coef_v56_v61_h_prev_C61(void)
{

}

void Coef_v56_v61_h_prev_C61::CoefFunction(double recp_h, bool DoTrapezoidal)
{

	if(DoTrapezoidal)
		y = 2 * (v56_ - v61_) * C61 * recp_h - i6ct_;
	else
		y = (v56_ - v61_) * C61 * recp_h;

}

// ------------------------------------------------------------------


// ---- Coef_v67_v56_h_prev_C62 ----------------------------------------------------

Coef_v67_v56_h_prev_C62::Coef_v67_v56_h_prev_C62(void)
{
  CoefFuncName = COEF_FUNC_v67_v56_h_prev_C62;
  LiteralName = "v67_v56_h_prev_C62";

	//Assign initial states...
  v56_ = (2.0 * (PLUS_DC_BUS_VOLTAGE - MINUS_DC_BUS_VOLTAGE) / 6.0) + MINUS_DC_BUS_VOLTAGE;														 //(-333.33)
  v67_ = (1.0 * (PLUS_DC_BUS_VOLTAGE - MINUS_DC_BUS_VOLTAGE) / 6.0) + MINUS_DC_BUS_VOLTAGE;

}

Coef_v67_v56_h_prev_C62::~Coef_v67_v56_h_prev_C62(void)
{
										 //(-666.66)
}

void Coef_v67_v56_h_prev_C62::CoefFunction(double recp_h, bool DoTrapezoidal)
{

	if(DoTrapezoidal)
		y = 2 * (v67_ - v56_) * C62 * recp_h - i6cb_;
	else
		y = (v67_ - v56_) * C62 * recp_h;

}

// ------------------------------------------------------------------






// ---- Coef_recp_rSrD71 ---------------------------------------------

Coef_recp_rSrD71::Coef_recp_rSrD71(void)
{
  CoefFuncName = COEF_FUNC_recp_rSrD71;
  LiteralName = "recp_rSrD71";
  rS71 = INIT_COEF_RS_RD;
  rD71 = INIT_COEF_RS_RD;

}

Coef_recp_rSrD71::~Coef_recp_rSrD71(void)
{


}

void Coef_recp_rSrD71::CoefFunction(double recp_h, bool DoTrapezoidal)
{

  y = 1/rS71 + 1/rD71;

}


// ------------------------------------------------------------------

// ---- Coef_recp_rSrD72 ---------------------------------------------

Coef_recp_rSrD72::Coef_recp_rSrD72(void)
{
  CoefFuncName = COEF_FUNC_recp_rSrD72;
  LiteralName = "recp_rSrD72"; 
  rS72 = INIT_COEF_RS_RD;
  rD72 = INIT_COEF_RS_RD;

}

Coef_recp_rSrD72::~Coef_recp_rSrD72(void)
{


}

void Coef_recp_rSrD72::CoefFunction(double recp_h, bool DoTrapezoidal)
{

  y = 1/rS72 + 1/rD72;

}


// ------------------------------------------------------------------





// ---- Coef_C7_h ----------------------------------------------------

Coef_C7_h::Coef_C7_h(void)
{
  CoefFuncName = COEF_FUNC_C7_h;
  LiteralName = "C7_h";

}

Coef_C7_h::~Coef_C7_h(void)
{


}

void Coef_C7_h::CoefFunction(double recp_h, bool DoTrapezoidal)
{

	if(DoTrapezoidal)
		y = 2 * C7 * recp_h;
	else
		y = C7 * recp_h;

}

// ------------------------------------------------------------------



// ---- Coef_C71_h ----------------------------------------------------

Coef_C71_h::Coef_C71_h(void)
{
  CoefFuncName = COEF_FUNC_C71_h;
  LiteralName = "C71_h";

}

Coef_C71_h::~Coef_C71_h(void)
{


}

void Coef_C71_h::CoefFunction(double recp_h, bool DoTrapezoidal)
{

	if(DoTrapezoidal)
		y = 2 * C71 * recp_h;
	else
		y = C71 * recp_h;

}

// ------------------------------------------------------------------



// ---- Coef_C72_h ----------------------------------------------------

Coef_C72_h::Coef_C72_h(void)
{
  CoefFuncName = COEF_FUNC_C72_h;
  LiteralName = "C72_h";

}

Coef_C72_h::~Coef_C72_h(void)
{


}

void Coef_C72_h::CoefFunction(double recp_h, bool DoTrapezoidal)
{

	if(DoTrapezoidal)
		y = 2 * C72 * recp_h;
	else
		y = C72 * recp_h;

}

// ------------------------------------------------------------------




// ---- Coef_v71_v78_h_prev_C7 ----------------------------------------------------

Coef_v71_v78_h_prev_C7::Coef_v71_v78_h_prev_C7(void)
{
  CoefFuncName = COEF_FUNC_v71_v78_h_prev_C7;
  LiteralName = "v71_v78_h_prev_C7";

  	  //Assign initial states...
  v71_ = (0.0 * (PLUS_DC_BUS_VOLTAGE - MINUS_DC_BUS_VOLTAGE) / 6.0) + MINUS_DC_BUS_VOLTAGE + ((PLUS_DC_BUS_VOLTAGE - MINUS_DC_BUS_VOLTAGE) / 4.0); //(-500.00)
  v78_ = (0.0 * (PLUS_DC_BUS_VOLTAGE - MINUS_DC_BUS_VOLTAGE) / 6.0) + MINUS_DC_BUS_VOLTAGE;														 //(-1000.0)

}

Coef_v71_v78_h_prev_C7::~Coef_v71_v78_h_prev_C7(void)
{


}

void Coef_v71_v78_h_prev_C7::CoefFunction(double recp_h, bool DoTrapezoidal)
{

	if(DoTrapezoidal)
		y = 2 * (v71_ - v78_) * C7 * recp_h - i7_;
	else
		y = (v71_ - v78_) * C7 * recp_h;

}

// ------------------------------------------------------------------


// ---- Coef_v67_v71_h_prev_C71 ----------------------------------------------------

Coef_v67_v71_h_prev_C71::Coef_v67_v71_h_prev_C71(void)
{
  CoefFuncName = COEF_FUNC_v67_v71_h_prev_C71;
  LiteralName = "v67_v71_h_prev_C71";

	//Assign initial states...
  v71_ = (0.0 * (PLUS_DC_BUS_VOLTAGE - MINUS_DC_BUS_VOLTAGE) / 6.0) + MINUS_DC_BUS_VOLTAGE + ((PLUS_DC_BUS_VOLTAGE - MINUS_DC_BUS_VOLTAGE) / 4.0); //(-500.00)
  v67_ = (1.0 * (PLUS_DC_BUS_VOLTAGE - MINUS_DC_BUS_VOLTAGE) / 6.0) + MINUS_DC_BUS_VOLTAGE;														 //(-666.66)

}

Coef_v67_v71_h_prev_C71::~Coef_v67_v71_h_prev_C71(void)
{

}

void Coef_v67_v71_h_prev_C71::CoefFunction(double recp_h, bool DoTrapezoidal)
{

	if(DoTrapezoidal)
		y = 2 * (v67_ - v71_) * C71 * recp_h - i7ct_;
	else
		y = (v67_ - v71_) * C71 * recp_h;

}

// ------------------------------------------------------------------


// ---- Coef_v78_v67_h_prev_C72 ----------------------------------------------------

Coef_v78_v67_h_prev_C72::Coef_v78_v67_h_prev_C72(void)
{
  CoefFuncName = COEF_FUNC_v78_v67_h_prev_C72;
  LiteralName = "v78_v67_h_prev_C72";

   //Assign initial states...
  v78_ = (0.0 * (PLUS_DC_BUS_VOLTAGE - MINUS_DC_BUS_VOLTAGE) / 6.0) + MINUS_DC_BUS_VOLTAGE;														 //(-1000.0)
  v67_ = (1.0 * (PLUS_DC_BUS_VOLTAGE - MINUS_DC_BUS_VOLTAGE) / 6.0) + MINUS_DC_BUS_VOLTAGE;														 //(-666.66)

}

Coef_v78_v67_h_prev_C72::~Coef_v78_v67_h_prev_C72(void)
{

}

void Coef_v78_v67_h_prev_C72::CoefFunction(double recp_h, bool DoTrapezoidal)
{

	if(DoTrapezoidal)
		y = 2 * (v78_ - v67_) * C72 * recp_h - i7cb_;
	else
		y = (v78_ - v67_) * C72 * recp_h;

}

// ------------------------------------------------------------------




// ---- Coef_recp_rSrD81 ---------------------------------------------

Coef_recp_rSrD81::Coef_recp_rSrD81(void)
{
  CoefFuncName = COEF_FUNC_recp_rSrD81;
  LiteralName = "recp_rSrD81"; 
  rS81 = INIT_COEF_RS_RD;
  rD81 = INIT_COEF_RS_RD;

}

Coef_recp_rSrD81::~Coef_recp_rSrD81(void)
{


}

void Coef_recp_rSrD81::CoefFunction(double recp_h, bool DoTrapezoidal)
{

  y = 1/rS81 + 1/rD81;

}



// ------------------------------------------------------------------

// ---- Coef_recp_rSrD82 ---------------------------------------------

Coef_recp_rSrD82::Coef_recp_rSrD82(void)
{
  CoefFuncName = COEF_FUNC_recp_rSrD82;
  LiteralName = "recp_rSrD82"; 
  rS82 = INIT_COEF_RS_RD;
  rD82 = INIT_COEF_RS_RD;

}

Coef_recp_rSrD82::~Coef_recp_rSrD82(void)
{


}

void Coef_recp_rSrD82::CoefFunction(double recp_h, bool DoTrapezoidal)
{

  y = 1/rS82 + 1/rD82;

}



// ------------------------------------------------------------------  




// ---- Coef_C8_h ----------------------------------------------------

Coef_C8_h::Coef_C8_h(void)
{
  CoefFuncName = COEF_FUNC_C8_h;
  LiteralName = "C8_h";

}

Coef_C8_h::~Coef_C8_h(void)
{


}

void Coef_C8_h::CoefFunction(double recp_h, bool DoTrapezoidal)
{

	if(DoTrapezoidal)
		y = 2 * C8 * recp_h;
	else
		y = C8 * recp_h;

}

// ------------------------------------------------------------------



// ---- Coef_C81_h ----------------------------------------------------

Coef_C81_h::Coef_C81_h(void)
{
  CoefFuncName = COEF_FUNC_C81_h;
  LiteralName = "C81_h";

}

Coef_C81_h::~Coef_C81_h(void)
{


}

void Coef_C81_h::CoefFunction(double recp_h, bool DoTrapezoidal)
{

	if(DoTrapezoidal)
		y = 2 * C81 * recp_h;
	else
		y = C81 * recp_h;

}

// ------------------------------------------------------------------



// ---- Coef_C82_h --------------------------------------------------

Coef_C82_h::Coef_C82_h(void)
{
  CoefFuncName = COEF_FUNC_C82_h;
  LiteralName = "C78_h";

}

Coef_C82_h::~Coef_C82_h(void)
{


}

void Coef_C82_h::CoefFunction(double recp_h, bool DoTrapezoidal)
{

	if(DoTrapezoidal)
		y = 2 * C82 * recp_h;
	else
		y = C82 * recp_h;

}

// ------------------------------------------------------------------


// ---- Coef_v81_h_prev_plus_MinusBus_C8 -----------------------------


Coef_v81_h_prev_plus_MinusBus_C8::Coef_v81_h_prev_plus_MinusBus_C8(void)
{
	  CoefFuncName = COEF_FUNC_v81_h_prev_plus_MinusBus_C8;
	  LiteralName = "v81_h_prev_plus_MinusBus_C8";

	  //Assign initial states...
	  v81_ = MINUS_DC_BUS_VOLTAGE + ((PLUS_DC_BUS_VOLTAGE - MINUS_DC_BUS_VOLTAGE) / 4.0); 															 //(-500.00)

}

Coef_v81_h_prev_plus_MinusBus_C8::~Coef_v81_h_prev_plus_MinusBus_C8(void)
{



}

void Coef_v81_h_prev_plus_MinusBus_C8::CoefFunction(double recp_h, bool DoTrapezoidal)
{

	if(DoTrapezoidal)
		y = 2 * v81_ * C8 * recp_h - i8_;
	else
		y = v81_ * C8 * recp_h;
}


// ------------------------------------------------------------------


// ---- Coef_v78_v81_h_prev_C81 ----------------------------------------------------

Coef_v78_v81_h_prev_C81::Coef_v78_v81_h_prev_C81(void)
{
  CoefFuncName = COEF_FUNC_v78_v81_h_prev_C81;
  LiteralName = "v78_v81_h_prev_C81";

  //Assign initial states...
  	v78_ = (0.0 * (PLUS_DC_BUS_VOLTAGE - MINUS_DC_BUS_VOLTAGE) / 6.0) + MINUS_DC_BUS_VOLTAGE;														 //(-1000.0)
  	v81_ = MINUS_DC_BUS_VOLTAGE + ((PLUS_DC_BUS_VOLTAGE - MINUS_DC_BUS_VOLTAGE) / 4.0); 															 //(-500.00)

}

Coef_v78_v81_h_prev_C81::~Coef_v78_v81_h_prev_C81(void)
{

}

void Coef_v78_v81_h_prev_C81::CoefFunction(double recp_h, bool DoTrapezoidal)
{

	if(DoTrapezoidal)
		y = 2 * (v78_ - v81_) * C81 * recp_h - i8ct_;
	else
		y = (v78_ - v81_) * C81 * recp_h;

}

// ------------------------------------------------------------------


// ---- Coef_minus_v78_h_prev_minus_MinusBus_C82 -----------------------------


Coef_minus_v78_h_prev_minus_MinusBus_C82::Coef_minus_v78_h_prev_minus_MinusBus_C82(void)
{
	  CoefFuncName = COEF_FUNC_minus_v78_h_prev_minus_MinusBus_C82;
	  LiteralName = "minus_v78_h_prev_minus_MinusBus_C82";

	//Assign initial states...
	v78_ = (0.0 * (PLUS_DC_BUS_VOLTAGE - MINUS_DC_BUS_VOLTAGE) / 6.0) + MINUS_DC_BUS_VOLTAGE;														 //(-1000.0)

}

Coef_minus_v78_h_prev_minus_MinusBus_C82::~Coef_minus_v78_h_prev_minus_MinusBus_C82(void)
{



}

void Coef_minus_v78_h_prev_minus_MinusBus_C82::CoefFunction(double recp_h, bool DoTrapezoidal)
{

	if(DoTrapezoidal)
		y = - 2 * - v78_ * C82 * recp_h - i8cb_;
	else
		y = - v78_ * C82 * recp_h;
}


// ------------------------------------------------------------------




// ******************************************************************






// **** SwitchObject Functions **************************************

// ---- Switch_rS11 -----------------------------------------------

Switch_rS11::Switch_rS11(void)
{

  CoefObjItem * pCurCoefItem;

  if(phase_num == 0)
  {
	  SwitchFuncName = SWITCH_FUNC_rS11_0;
	  LiteralName = "rS11_0";
  }
  else if(phase_num == 1)
  {
	  SwitchFuncName = SWITCH_FUNC_rS11_1;
	  LiteralName = "rS11_1";

  }
  else
  {
	  SwitchFuncName = SWITCH_FUNC_rS11_2;
	  LiteralName = "rS11_2";
  }

  //build the COEF Rvalue list.

  pCoefObjRValList = new CoefObjItem;          
  pCurCoefItem = pCoefObjRValList;
 
  if(phase_num == 0)
  {
	  pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_recp_rSrD11_0];
  }
  else if(phase_num == 1)
  {
	  pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_recp_rSrD11_1];
  }
  else
  {
	  pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_recp_rSrD11_2];
  }

  IsIgbt = TRUE;
  IsMinusPol = FALSE;


#ifdef PLOT_SWITCHOBJECT_PROBES_rS11
#if PLOT_SWITCHOBJECT_PROBES_PHASE_NUM = 0
  if(phase_num == 0)
  {
	  DoProbes = TRUE;
#ifdef DO_PROBE_rS11_res
	  DoProbes_res = TRUE;
#endif
#ifdef DO_PROBE_rS11_cur
	  DoProbes_cur = TRUE;
#endif
#ifdef DO_PROBE_rS11_gate
	  DoProbes_gate = TRUE;
#endif
  }
#elsif PLOT_SWITCHOBJECT_PROBES_PHASE_NUM = 1
  if(phase_num == 1)
  {
	  DoProbes = TRUE;
#ifdef DO_PROBE_rS11_res
	  DoProbes_res = TRUE;
#endif
#ifdef DO_PROBE_rS11_cur
	  DoProbes_cur = TRUE;
#endif
#ifdef DO_PROBE_rS11_gate
	  DoProbes_gate = TRUE;
#endif
  }
#else
  if(phase_num == 2)
  {
	  DoProbes = TRUE;
#ifdef DO_PROBE_rS11_res
	  DoProbes_res = TRUE;
#endif
#ifdef DO_PROBE_rS11_cur
	  DoProbes_cur = TRUE;
#endif
#ifdef DO_PROBE_rS11_gate
	  DoProbes_gate = TRUE;
#endif
  }

#endif 
#endif


}

Switch_rS11::~Switch_rS11(void)
{

}

void Switch_rS11::CoefRValueUpdate(void)
{
  CoefObjItem * pCurCoefItem;

  //Update Rvalues
  pCurCoefItem = pCoefObjRValList;

  ((Coef_recp_rSrD11 *) pCurCoefItem->pCoefObject)->rS11 = y_igbt;
  ((Coef_recp_rSrD11 *) pCurCoefItem->pCoefObject)->rD11 = y_diode;

}

// ------------------------------------------------------------------





// ---- Switch_rS12 -----------------------------------------------

Switch_rS12::Switch_rS12(void)
{

  CoefObjItem * pCurCoefItem;

  if(phase_num == 0)
  {
	  SwitchFuncName = SWITCH_FUNC_rS12_0;
	  LiteralName = "rS12_0";
  }
  else if(phase_num == 1)
  {
	  SwitchFuncName = SWITCH_FUNC_rS12_1;
	  LiteralName = "rS12_1";
  }
  else
  {
	  SwitchFuncName = SWITCH_FUNC_rS12_2;
	  LiteralName = "rS12_2";
  }

  //build the COEF Rvalue list.

  pCoefObjRValList = new CoefObjItem;          
  pCurCoefItem = pCoefObjRValList;

  if(phase_num == 0)
  {
	  pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_recp_rSrD12_0];
  }
  else if(phase_num == 1)
  {
	  pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_recp_rSrD12_1];
  }
  else
  {
	  pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_recp_rSrD12_2];
  }

  IsIgbt = TRUE;
  IsMinusPol = FALSE;


#ifdef PLOT_SWITCHOBJECT_PROBES_rS12
#if PLOT_SWITCHOBJECT_PROBES_PHASE_NUM = 0
  if(phase_num == 0)
  {
	  DoProbes = TRUE;
#ifdef DO_PROBE_rS12_res
	  DoProbes_res = TRUE;
#endif
#ifdef DO_PROBE_rS12_cur
	  DoProbes_cur = TRUE;
#endif
#ifdef DO_PROBE_rS12_gate
  DoProbes_gate = TRUE;
#endif 
  }
#elsif PLOT_SWITCHOBJECT_PROBES_PHASE_NUM = 1
  if(phase_num == 1)
  {
	  DoProbes = TRUE;
#ifdef DO_PROBE_rS12_res
	  DoProbes_res = TRUE;
#endif
#ifdef DO_PROBE_rS12_cur
	  DoProbes_cur = TRUE;
#endif
#ifdef DO_PROBE_rS12_gate
  DoProbes_gate = TRUE;
#endif
  }
#else
  if(phase_num == 2)
  {
	  DoProbes = TRUE;
#ifdef DO_PROBE_rS12_res
	  DoProbes_res = TRUE;
#endif
#ifdef DO_PROBE_rS12_cur
	  DoProbes_cur = TRUE;
#endif
#ifdef DO_PROBE_rS12_gate
  DoProbes_gate = TRUE;
#endif

  }

#endif
#endif


}

Switch_rS12::~Switch_rS12(void)
{

}

void Switch_rS12::CoefRValueUpdate(void)
{
  CoefObjItem * pCurCoefItem;

  //Update Rvalues
  pCurCoefItem = pCoefObjRValList;

  ((Coef_recp_rSrD12 *) pCurCoefItem->pCoefObject)->rS12 = y_igbt;
  ((Coef_recp_rSrD12 *) pCurCoefItem->pCoefObject)->rD12 = y_diode;

}


// ------------------------------------------------------------------


// ---- Switch_rS21 -----------------------------------------------

Switch_rS21::Switch_rS21(void)
{

  CoefObjItem * pCurCoefItem;

  if(phase_num == 0)
  {
  	  SwitchFuncName = SWITCH_FUNC_rS21_0;
	  LiteralName = "rS21_0";
  }
  else if(phase_num == 1)
  {
  	  SwitchFuncName = SWITCH_FUNC_rS21_1;
	  LiteralName = "rS21_1";
  }
  else
  {
  	  SwitchFuncName = SWITCH_FUNC_rS21_2;
	  LiteralName = "rS21_2";

  }

  //build the COEF Rvalue list.

  pCoefObjRValList = new CoefObjItem;          
  pCurCoefItem = pCoefObjRValList;
 
  if(phase_num == 0)
  {
 	  pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_recp_rSrD21_0];
  }
  else if(phase_num == 1)
  {
 	  pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_recp_rSrD21_1];
  }
  else
  {
 	  pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_recp_rSrD21_2];
  }

  IsIgbt = TRUE;
  IsMinusPol = FALSE;



#ifdef PLOT_SWITCHOBJECT_PROBES_rS21
#if PLOT_SWITCHOBJECT_PROBES_PHASE_NUM = 0
  if(phase_num == 0)
  {
	  DoProbes = TRUE;
#ifdef DO_PROBE_rS21_res
	  DoProbes_res = TRUE;
#endif
#ifdef DO_PROBE_rS21_cur
	  DoProbes_cur = TRUE;
#endif
#ifdef DO_PROBE_rS21_gate
	  DoProbes_gate = TRUE;
#endif
  }
#elsif PLOT_SWITCHOBJECT_PROBES_PHASE_NUM = 1
  if(phase_num == 1)
  {
	  DoProbes = TRUE;
#ifdef DO_PROBE_rS21_res
	  DoProbes_res = TRUE;
#endif
#ifdef DO_PROBE_rS21_cur
	  DoProbes_cur = TRUE;
#endif
#ifdef DO_PROBE_rS21_gate
	  DoProbes_gate = TRUE;
#endif
  }
#else
  if(phase_num == 2)
  {
	  DoProbes = TRUE;
#ifdef DO_PROBE_rS21_res
	  DoProbes_res = TRUE;
#endif
#ifdef DO_PROBE_rS21_cur
	  DoProbes_cur = TRUE;
#endif
#ifdef DO_PROBE_rS21_gate
	  DoProbes_gate = TRUE;
#endif
  }

#endif 
#endif



}

Switch_rS21::~Switch_rS21(void)
{

}

void Switch_rS21::CoefRValueUpdate(void)
{
  CoefObjItem * pCurCoefItem;

  //Update Rvalues
  pCurCoefItem = pCoefObjRValList;

  ((Coef_recp_rSrD21 *) pCurCoefItem->pCoefObject)->rS21 = y_igbt;
  ((Coef_recp_rSrD21 *) pCurCoefItem->pCoefObject)->rD21 = y_diode;

}


// ------------------------------------------------------------------


// ---- Switch_rS22 -----------------------------------------------

Switch_rS22::Switch_rS22(void)
{

  CoefObjItem * pCurCoefItem;

  if(phase_num == 0)
  {
	  SwitchFuncName = SWITCH_FUNC_rS22_0;
	  LiteralName = "rS22_0";
  }
  else if(phase_num == 1)
  {
	  SwitchFuncName = SWITCH_FUNC_rS22_1;
	  LiteralName = "rS22_1";

  }
  else
  {
	  SwitchFuncName = SWITCH_FUNC_rS22_2;
	  LiteralName = "rS22_2";
  }



  //build the COEF Rvalue list.

  pCoefObjRValList = new CoefObjItem;          
  pCurCoefItem = pCoefObjRValList;
 

  if(phase_num == 0)
  {
	  pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_recp_rSrD22_0];
  }
  else if(phase_num == 1)
  {
	  pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_recp_rSrD22_1];
  }
  else
  {
	  pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_recp_rSrD22_2];
  }




  IsIgbt = TRUE;
  IsMinusPol = FALSE;




#ifdef PLOT_SWITCHOBJECT_PROBES_rS22
#if PLOT_SWITCHOBJECT_PROBES_PHASE_NUM = 0
  if(phase_num == 0)
  {
	  DoProbes = TRUE;
#ifdef DO_PROBE_rS22_res
	  DoProbes_res = TRUE;
#endif
#ifdef DO_PROBE_rS22_cur
	  DoProbes_cur = TRUE;
#endif
#ifdef DO_PROBE_rS22_gate
	  DoProbes_gate = TRUE;
#endif
  }
#elsif PLOT_SWITCHOBJECT_PROBES_PHASE_NUM = 1
  if(phase_num == 1)
  {
	  DoProbes = TRUE;
#ifdef DO_PROBE_rS22_res
	  DoProbes_res = TRUE;
#endif
#ifdef DO_PROBE_rS22_cur
	  DoProbes_cur = TRUE;
#endif
#ifdef DO_PROBE_rS22_gate
	  DoProbes_gate = TRUE;
#endif
  }
#else
  if(phase_num == 2)
  {
	  DoProbes = TRUE;
#ifdef DO_PROBE_rS22_res
	  DoProbes_res = TRUE;
#endif
#ifdef DO_PROBE_rS22_cur
	  DoProbes_cur = TRUE;
#endif
#ifdef DO_PROBE_rS22_gate
	  DoProbes_gate = TRUE;
#endif
  }

#endif 
#endif




}

Switch_rS22::~Switch_rS22(void)
{

}

void Switch_rS22::CoefRValueUpdate(void)
{
  CoefObjItem * pCurCoefItem;

  //Update Rvalues
  pCurCoefItem = pCoefObjRValList;

  ((Coef_recp_rSrD22 *) pCurCoefItem->pCoefObject)->rS22 = y_igbt;
  ((Coef_recp_rSrD22 *) pCurCoefItem->pCoefObject)->rD22 = y_diode;

}



// ------------------------------------------------------------------







// ---- Switch_rS31 -----------------------------------------------

Switch_rS31::Switch_rS31(void)
{

  CoefObjItem * pCurCoefItem;


  if(phase_num == 0)
  {
	  SwitchFuncName = SWITCH_FUNC_rS31_0;
	  LiteralName = "rS31_0";
  }
  else if(phase_num == 1)
  {
	  SwitchFuncName = SWITCH_FUNC_rS31_1;
	  LiteralName = "rS31_1";
  }
  else
  {
	  SwitchFuncName = SWITCH_FUNC_rS31_2;
	  LiteralName = "rS31_2";
  }



  //build the COEF Rvalue list.

  pCoefObjRValList = new CoefObjItem;          
  pCurCoefItem = pCoefObjRValList;
 

  if(phase_num == 0)
  {
	  pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_recp_rSrD31_0];
  }
  else if(phase_num == 1)
  {
	  pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_recp_rSrD31_1];
  }
  else
  {
	  pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_recp_rSrD31_2];
  }


  IsIgbt = TRUE;
  IsMinusPol = FALSE;


#ifdef PLOT_SWITCHOBJECT_PROBES_rS31
#if PLOT_SWITCHOBJECT_PROBES_PHASE_NUM = 0
  if(phase_num == 0)
  {
	  DoProbes = TRUE;
#ifdef DO_PROBE_rS31_res
	  DoProbes_res = TRUE;
#endif
#ifdef DO_PROBE_rS31_cur
	  DoProbes_cur = TRUE;
#endif
#ifdef DO_PROBE_rS31_gate
	  DoProbes_gate = TRUE;
#endif
  }
#elsif PLOT_SWITCHOBJECT_PROBES_PHASE_NUM = 1
  if(phase_num == 1)
  {
	  DoProbes = TRUE;
#ifdef DO_PROBE_rS31_res
	  DoProbes_res = TRUE;
#endif
#ifdef DO_PROBE_rS31_cur
	  DoProbes_cur = TRUE;
#endif
#ifdef DO_PROBE_rS31_gate
	  DoProbes_gate = TRUE;
#endif
  }
#else
  if(phase_num == 2)
  {
	  DoProbes = TRUE;
#ifdef DO_PROBE_rS31_res
	  DoProbes_res = TRUE;
#endif
#ifdef DO_PROBE_rS31_cur
	  DoProbes_cur = TRUE;
#endif
#ifdef DO_PROBE_rS31_gate
	  DoProbes_gate = TRUE;
#endif
  }

#endif 
#endif





}

Switch_rS31::~Switch_rS31(void)
{

}

void Switch_rS31::CoefRValueUpdate(void)
{
  CoefObjItem * pCurCoefItem;

  //Update Rvalues
  pCurCoefItem = pCoefObjRValList;

  ((Coef_recp_rSrD31 *) pCurCoefItem->pCoefObject)->rS31 = y_igbt;
  ((Coef_recp_rSrD31 *) pCurCoefItem->pCoefObject)->rD31 = y_diode;

}



// ------------------------------------------------------------------


// ---- Switch_rS32 -----------------------------------------------

Switch_rS32::Switch_rS32(void)
{

  CoefObjItem * pCurCoefItem;


  if(phase_num == 0)
  {
	  SwitchFuncName = SWITCH_FUNC_rS32_0;
	  LiteralName = "rS32_0";
  }
  else if(phase_num == 1)
  {
	  SwitchFuncName = SWITCH_FUNC_rS32_1;
	  LiteralName = "rS32_1";

  }
  else
  {
	  SwitchFuncName = SWITCH_FUNC_rS32_2;
	  LiteralName = "rS32_2";
  }

  //build the COEF Rvalue list.

  pCoefObjRValList = new CoefObjItem;          
  pCurCoefItem = pCoefObjRValList;
 

  if(phase_num == 0)
  {
	  pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_recp_rSrD32_0];
  }
  else if(phase_num == 1)
  {
	  pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_recp_rSrD32_1];
  }
  else
  {
	  pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_recp_rSrD32_2];
  }



  IsIgbt = TRUE;
  IsMinusPol = FALSE;



#ifdef PLOT_SWITCHOBJECT_PROBES_rS32
#if PLOT_SWITCHOBJECT_PROBES_PHASE_NUM = 0
  if(phase_num == 0)
  {
	  DoProbes = TRUE;
#ifdef DO_PROBE_rS32_res
	  DoProbes_res = TRUE;
#endif
#ifdef DO_PROBE_rS32_cur
	  DoProbes_cur = TRUE;
#endif
#ifdef DO_PROBE_rS32_gate
	  DoProbes_gate = TRUE;
#endif
  }
#elsif PLOT_SWITCHOBJECT_PROBES_PHASE_NUM = 1
  if(phase_num == 1)
  {
	  DoProbes = TRUE;
#ifdef DO_PROBE_rS32_res
	  DoProbes_res = TRUE;
#endif
#ifdef DO_PROBE_rS32_cur
	  DoProbes_cur = TRUE;
#endif
#ifdef DO_PROBE_rS32_gate
	  DoProbes_gate = TRUE;
#endif
  }
#else
  if(phase_num == 2)
  {
	  DoProbes = TRUE;
#ifdef DO_PROBE_rS32_res
	  DoProbes_res = TRUE;
#endif
#ifdef DO_PROBE_rS32_cur
	  DoProbes_cur = TRUE;
#endif
#ifdef DO_PROBE_rS32_gate
	  DoProbes_gate = TRUE;
#endif
  }

#endif
#endif


}

Switch_rS32::~Switch_rS32(void)
{

}

void Switch_rS32::CoefRValueUpdate(void)
{
  CoefObjItem * pCurCoefItem;

  //Update Rvalues
  pCurCoefItem = pCoefObjRValList;

  ((Coef_recp_rSrD32 *) pCurCoefItem->pCoefObject)->rS32 = y_igbt;
  ((Coef_recp_rSrD32 *) pCurCoefItem->pCoefObject)->rD32 = y_diode;

}


// ------------------------------------------------------------------


// ---- Switch_rS41 -----------------------------------------------

Switch_rS41::Switch_rS41(void)
{

  CoefObjItem * pCurCoefItem;


  if(phase_num == 0)
  {
	  SwitchFuncName = SWITCH_FUNC_rS41_0;
	  LiteralName = "rS41_0";
  }
  else if(phase_num == 1)
  {
	  SwitchFuncName = SWITCH_FUNC_rS41_1;
	  LiteralName = "rS41_1";

  }
  else
  {
	  SwitchFuncName = SWITCH_FUNC_rS41_2;
	  LiteralName = "rS41_2";
  }



  //build the COEF Rvalue list.

  pCoefObjRValList = new CoefObjItem;          
  pCurCoefItem = pCoefObjRValList;
 

  if(phase_num == 0)
  {
	  pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_recp_rSrD41_0];
  }
  else if(phase_num == 1)
  {
	  pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_recp_rSrD41_1];
  }
  else
  {
	  pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_recp_rSrD41_2];
  }



  IsIgbt = TRUE;
  IsMinusPol = FALSE;


#ifdef PLOT_SWITCHOBJECT_PROBES_rS41
#if PLOT_SWITCHOBJECT_PROBES_PHASE_NUM = 0
  if(phase_num == 0)
  {
	  DoProbes = TRUE;
#ifdef DO_PROBE_rS41_res
	  DoProbes_res = TRUE;
#endif
#ifdef DO_PROBE_rS41_cur
	  DoProbes_cur = TRUE;
#endif
#ifdef DO_PROBE_rS41_gate
	  DoProbes_gate = TRUE;
#endif
  }
#elsif PLOT_SWITCHOBJECT_PROBES_PHASE_NUM = 1
  if(phase_num == 1)
  {
	  DoProbes = TRUE;
#ifdef DO_PROBE_rS41_res
	  DoProbes_res = TRUE;
#endif
#ifdef DO_PROBE_rS41_cur
	  DoProbes_cur = TRUE;
#endif
#ifdef DO_PROBE_rS41_gate
	  DoProbes_gate = TRUE;
#endif
  }
#else
  if(phase_num == 2)
  {
	  DoProbes = TRUE;
#ifdef DO_PROBE_rS41_res
	  DoProbes_res = TRUE;
#endif
#ifdef DO_PROBE_rS41_cur
	  DoProbes_cur = TRUE;
#endif
#ifdef DO_PROBE_rS41_gate
	  DoProbes_gate = TRUE;
#endif
  }

#endif 
#endif


}

Switch_rS41::~Switch_rS41(void)
{

}

void Switch_rS41::CoefRValueUpdate(void)
{
  CoefObjItem * pCurCoefItem;

  //Update Rvalues
  pCurCoefItem = pCoefObjRValList;

  ((Coef_recp_rSrD41 *) pCurCoefItem->pCoefObject)->rS41 = y_igbt;
  ((Coef_recp_rSrD41 *) pCurCoefItem->pCoefObject)->rD41 = y_diode;

}



// ------------------------------------------------------------------


// ---- Switch_rS42 -----------------------------------------------

Switch_rS42::Switch_rS42(void)
{

  CoefObjItem * pCurCoefItem;


  if(phase_num == 0)
  {
	  SwitchFuncName = SWITCH_FUNC_rS42_0;
	  LiteralName = "rS42_0";
  }
  else if(phase_num == 1)
  {
	  SwitchFuncName = SWITCH_FUNC_rS42_1;
	  LiteralName = "rS42_1";

  }
  else
  {
	  SwitchFuncName = SWITCH_FUNC_rS42_2;
	  LiteralName = "rS42_2";
  }


  //build the COEF Rvalue list.

  pCoefObjRValList = new CoefObjItem;          
  pCurCoefItem = pCoefObjRValList;
 

  if(phase_num == 0)
  {
	  pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_recp_rSrD42_0];
  }
  else if(phase_num == 1)
  {
	  pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_recp_rSrD42_1];
  }
  else
  {
	  pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_recp_rSrD42_2];
  }



  IsIgbt = TRUE;
  IsMinusPol = FALSE;


#ifdef PLOT_SWITCHOBJECT_PROBES_rS42
#if PLOT_SWITCHOBJECT_PROBES_PHASE_NUM = 0
  if(phase_num == 0)
  {
	  DoProbes = TRUE;
#ifdef DO_PROBE_rS42_res
	  DoProbes_res = TRUE;
#endif
#ifdef DO_PROBE_rS42_cur
	  DoProbes_cur = TRUE;
#endif
#ifdef DO_PROBE_rS42_gate
	  DoProbes_gate = TRUE;
#endif
  }
#elsif PLOT_SWITCHOBJECT_PROBES_PHASE_NUM = 1
  if(phase_num == 1)
  {
	  DoProbes = TRUE;
#ifdef DO_PROBE_rS42_res
	  DoProbes_res = TRUE;
#endif
#ifdef DO_PROBE_rS42_cur
	  DoProbes_cur = TRUE;
#endif
#ifdef DO_PROBE_rS42_gate
	  DoProbes_gate = TRUE;
#endif
  }
#else
  if(phase_num == 2)
  {
	  DoProbes = TRUE;
#ifdef DO_PROBE_rS42_res
	  DoProbes_res = TRUE;
#endif
#ifdef DO_PROBE_rS42_cur
	  DoProbes_cur = TRUE;
#endif
#ifdef DO_PROBE_rS42_gate
	  DoProbes_gate = TRUE;
#endif
  }

#endif
#endif


}

Switch_rS42::~Switch_rS42(void)
{

}

void Switch_rS42::CoefRValueUpdate(void)
{
  CoefObjItem * pCurCoefItem;

  //Update Rvalues
  pCurCoefItem = pCoefObjRValList;

  ((Coef_recp_rSrD42 *) pCurCoefItem->pCoefObject)->rS42 = y_igbt;
  ((Coef_recp_rSrD42 *) pCurCoefItem->pCoefObject)->rD42 = y_diode;

}


// ------------------------------------------------------------------


// ---- Switch_rS51 -----------------------------------------------

Switch_rS51::Switch_rS51(void)
{

  CoefObjItem * pCurCoefItem;

  if(phase_num == 0)
  {
	  SwitchFuncName = SWITCH_FUNC_rS51_0;
	  LiteralName = "rS51_0";
  }
  else if(phase_num == 1)
  {
	  SwitchFuncName = SWITCH_FUNC_rS51_1;
	  LiteralName = "rS51_1";

  }
  else
  {
	  SwitchFuncName = SWITCH_FUNC_rS51_2;
	  LiteralName = "rS51_2";
  }



  //build the COEF Rvalue list.

  pCoefObjRValList = new CoefObjItem;          
  pCurCoefItem = pCoefObjRValList;
 

  if(phase_num == 0)
  {
	  pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_recp_rSrD51_0];
  }
  else if(phase_num == 1)
  {
	  pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_recp_rSrD51_1];
  }
  else
  {
	  pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_recp_rSrD51_2];
  }



  IsIgbt = TRUE;
  IsMinusPol = FALSE;


#ifdef PLOT_SWITCHOBJECT_PROBES_rS51
#if PLOT_SWITCHOBJECT_PROBES_PHASE_NUM = 0
  if(phase_num == 0)
  {
	  DoProbes = TRUE;
#ifdef DO_PROBE_rS51_res
	  DoProbes_res = TRUE;
#endif
#ifdef DO_PROBE_rS51_cur
	  DoProbes_cur = TRUE;
#endif
#ifdef DO_PROBE_rS51_gate
	  DoProbes_gate = TRUE;
#endif
  }
#elsif PLOT_SWITCHOBJECT_PROBES_PHASE_NUM = 1
  if(phase_num == 1)
  {
	  DoProbes = TRUE;
#ifdef DO_PROBE_rS51_res
	  DoProbes_res = TRUE;
#endif
#ifdef DO_PROBE_rS51_cur
	  DoProbes_cur = TRUE;
#endif
#ifdef DO_PROBE_rS51_gate
	  DoProbes_gate = TRUE;
#endif
  }
#else
  if(phase_num == 2)
  {
	  DoProbes = TRUE;
#ifdef DO_PROBE_rS51_res
	  DoProbes_res = TRUE;
#endif
#ifdef DO_PROBE_rS51_cur
	  DoProbes_cur = TRUE;
#endif
#ifdef DO_PROBE_rS51_gate
	  DoProbes_gate = TRUE;
#endif
  }

#endif
#endif 



}
Switch_rS51::~Switch_rS51(void)
{

}

void Switch_rS51::CoefRValueUpdate(void)
{
  CoefObjItem * pCurCoefItem;

  //Update Rvalues
  pCurCoefItem = pCoefObjRValList;

  ((Coef_recp_rSrD51 *) pCurCoefItem->pCoefObject)->rS51 = y_igbt;
  ((Coef_recp_rSrD51 *) pCurCoefItem->pCoefObject)->rD51 = y_diode;

}



// ------------------------------------------------------------------


// ---- Switch_rS52 -----------------------------------------------

Switch_rS52::Switch_rS52(void)
{

  CoefObjItem * pCurCoefItem;

  if(phase_num == 0)
  {
	  SwitchFuncName = SWITCH_FUNC_rS52_0;
	  LiteralName = "rS52_0";
  }
  else if(phase_num == 1)
  {
	  SwitchFuncName = SWITCH_FUNC_rS52_1;
	  LiteralName = "rS52_1";

  }
  else
  {
	  SwitchFuncName = SWITCH_FUNC_rS52_2;
	  LiteralName = "rS52_2";
  }



  //build the COEF Rvalue list.

  pCoefObjRValList = new CoefObjItem;          
  pCurCoefItem = pCoefObjRValList;
 

  if(phase_num == 0)
  {
	  pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_recp_rSrD52_0];
  }
  else if(phase_num == 1)
  {
	  pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_recp_rSrD52_1];
  }
  else
  {
	  pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_recp_rSrD52_2];
  }



  IsIgbt = TRUE;
  IsMinusPol = FALSE;


#ifdef PLOT_SWITCHOBJECT_PROBES_rS52
#if PLOT_SWITCHOBJECT_PROBES_PHASE_NUM = 0
  if(phase_num == 0)
  {
	  DoProbes = TRUE;
#ifdef DO_PROBE_rS52_res
	  DoProbes_res = TRUE;
#endif
#ifdef DO_PROBE_rS52_cur
	  DoProbes_cur = TRUE;
#endif
#ifdef DO_PROBE_rS52_gate
	  DoProbes_gate = TRUE;
#endif
  }
#elsif PLOT_SWITCHOBJECT_PROBES_PHASE_NUM = 1
  if(phase_num == 1)
  {
	  DoProbes = TRUE;
#ifdef DO_PROBE_rS52_res
	  DoProbes_res = TRUE;
#endif
#ifdef DO_PROBE_rS52_cur
	  DoProbes_cur = TRUE;
#endif
#ifdef DO_PROBE_rS52_gate
	  DoProbes_gate = TRUE;
#endif
  }
#else
  if(phase_num == 2)
  {
	  DoProbes = TRUE;
#ifdef DO_PROBE_rS52_res
	  DoProbes_res = TRUE;
#endif
#ifdef DO_PROBE_rS52_cur
	  DoProbes_cur = TRUE;
#endif
#ifdef DO_PROBE_rS52_gate
	  DoProbes_gate = TRUE;
#endif
  }

#endif 
#endif



}

Switch_rS52::~Switch_rS52(void)
{

}

void Switch_rS52::CoefRValueUpdate(void)
{
  CoefObjItem * pCurCoefItem;

  //Update Rvalues
  pCurCoefItem = pCoefObjRValList;

  ((Coef_recp_rSrD52 *) pCurCoefItem->pCoefObject)->rS52 = y_igbt;
  ((Coef_recp_rSrD52 *) pCurCoefItem->pCoefObject)->rD52 = y_diode;

}




// ------------------------------------------------------------------


// ---- Switch_rS61 -----------------------------------------------

Switch_rS61::Switch_rS61(void)
{

  CoefObjItem * pCurCoefItem;


  if(phase_num == 0)
  {
	  SwitchFuncName = SWITCH_FUNC_rS61_0;
	  LiteralName = "rS61_0";
  }
  else if(phase_num == 1)
  {
	  SwitchFuncName = SWITCH_FUNC_rS61_1;
	  LiteralName = "rS61_1";

  }
  else
  {
	  SwitchFuncName = SWITCH_FUNC_rS61_2;
	  LiteralName = "rS61_2";
  }



  //build the COEF Rvalue list.

  pCoefObjRValList = new CoefObjItem;          
  pCurCoefItem = pCoefObjRValList;
 

  if(phase_num == 0)
  {
	  pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_recp_rSrD61_0];
  }
  else if(phase_num == 1)
  {
	  pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_recp_rSrD61_1];
  }
  else
  {
	  pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_recp_rSrD61_2];
  }


  IsIgbt = TRUE;
  IsMinusPol = FALSE;



#ifdef PLOT_SWITCHOBJECT_PROBES_rS61
#if PLOT_SWITCHOBJECT_PROBES_PHASE_NUM = 0
  if(phase_num == 0)
  {
	  DoProbes = TRUE;
#ifdef DO_PROBE_rS61_res
	  DoProbes_res = TRUE;
#endif
#ifdef DO_PROBE_rS61_cur
	  DoProbes_cur = TRUE;
#endif
#ifdef DO_PROBE_rS61_gate
	  DoProbes_gate = TRUE;
#endif
  }
#elsif PLOT_SWITCHOBJECT_PROBES_PHASE_NUM = 1
  if(phase_num == 1)
  {
	  DoProbes = TRUE;
#ifdef DO_PROBE_rS61_res
	  DoProbes_res = TRUE;
#endif
#ifdef DO_PROBE_rS61_cur
	  DoProbes_cur = TRUE;
#endif
#ifdef DO_PROBE_rS61_gate
	  DoProbes_gate = TRUE;
#endif
  }
#else
  if(phase_num == 2)
  {
	  DoProbes = TRUE;
#ifdef DO_PROBE_rS61_res
	  DoProbes_res = TRUE;
#endif
#ifdef DO_PROBE_rS61_cur
	  DoProbes_cur = TRUE;
#endif
#ifdef DO_PROBE_rS61_gate
	  DoProbes_gate = TRUE;
#endif
  }

#endif 
#endif



}

Switch_rS61::~Switch_rS61(void)
{

}

void Switch_rS61::CoefRValueUpdate(void)
{
  CoefObjItem * pCurCoefItem;

  //Update Rvalues
  pCurCoefItem = pCoefObjRValList;

  ((Coef_recp_rSrD61 *) pCurCoefItem->pCoefObject)->rS61 = y_igbt;
  ((Coef_recp_rSrD61 *) pCurCoefItem->pCoefObject)->rD61 = y_diode;

}



// ------------------------------------------------------------------





// ---- Switch_rS62 -----------------------------------------------

Switch_rS62::Switch_rS62(void)
{

  CoefObjItem * pCurCoefItem;


  if(phase_num == 0)
  {
	  SwitchFuncName = SWITCH_FUNC_rS62_0;
	  LiteralName = "rS62_0";
  }
  else if(phase_num == 1)
  {
	  SwitchFuncName = SWITCH_FUNC_rS62_1;
	  LiteralName = "rS62_1";

  }
  else
  {
	  SwitchFuncName = SWITCH_FUNC_rS62_2;
	  LiteralName = "rS62_2";
  }




  //build the COEF Rvalue list.

  pCoefObjRValList = new CoefObjItem;          
  pCurCoefItem = pCoefObjRValList;

  if(phase_num == 0)
   {
 	  pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_recp_rSrD62_0];
   }
   else if(phase_num == 1)
   {
 	  pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_recp_rSrD62_1];
   }
   else
   {
 	  pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_recp_rSrD62_2];
   }




  IsIgbt = TRUE;
  IsMinusPol = FALSE;



#ifdef PLOT_SWITCHOBJECT_PROBES_rS62
#if PLOT_SWITCHOBJECT_PROBES_PHASE_NUM = 0
  if(phase_num == 0)
  {
	  DoProbes = TRUE;
#ifdef DO_PROBE_rS62_res
	  DoProbes_res = TRUE;
#endif
#ifdef DO_PROBE_rS62_cur
	  DoProbes_cur = TRUE;
#endif
#ifdef DO_PROBE_rS62_gate
	  DoProbes_gate = TRUE;
#endif
  }
#elsif PLOT_SWITCHOBJECT_PROBES_PHASE_NUM = 1
  if(phase_num == 1)
  {
	  DoProbes = TRUE;
#ifdef DO_PROBE_rS62_res
	  DoProbes_res = TRUE;
#endif
#ifdef DO_PROBE_rS62_cur
	  DoProbes_cur = TRUE;
#endif
#ifdef DO_PROBE_rS62_gate
	  DoProbes_gate = TRUE;
#endif
  }
#else
  if(phase_num == 2)
  {
	  DoProbes = TRUE;
#ifdef DO_PROBE_rS62_res
	  DoProbes_res = TRUE;
#endif
#ifdef DO_PROBE_rS62_cur
	  DoProbes_cur = TRUE;
#endif
#ifdef DO_PROBE_rS62_gate
	  DoProbes_gate = TRUE;
#endif
  }

#endif 
#endif


}

Switch_rS62::~Switch_rS62(void)
{

}

void Switch_rS62::CoefRValueUpdate(void)
{
  CoefObjItem * pCurCoefItem;

  //Update Rvalues
  pCurCoefItem = pCoefObjRValList;

  ((Coef_recp_rSrD62 *) pCurCoefItem->pCoefObject)->rS62 = y_igbt;
  ((Coef_recp_rSrD62 *) pCurCoefItem->pCoefObject)->rD62 = y_diode;

}


// ------------------------------------------------------------------


// ---- Switch_rS71 -----------------------------------------------

Switch_rS71::Switch_rS71(void)
{

  CoefObjItem * pCurCoefItem;


  if(phase_num == 0)
  {
	  SwitchFuncName = SWITCH_FUNC_rS71_0;
	  LiteralName = "rS71_0";
  }
  else if(phase_num == 1)
  {
	  SwitchFuncName = SWITCH_FUNC_rS71_1;
	  LiteralName = "rS71_1";

  }
  else
  {
	  SwitchFuncName = SWITCH_FUNC_rS71_2;
	  LiteralName = "rS71_2";
  }



  //build the COEF Rvalue list.

  pCoefObjRValList = new CoefObjItem;          
  pCurCoefItem = pCoefObjRValList;
 

  if(phase_num == 0)
  {
	  pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_recp_rSrD71_0];
  }
  else if(phase_num == 1)
  {
	  pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_recp_rSrD71_1];
  }
  else
  {
	  pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_recp_rSrD71_2];
  }



  
  IsIgbt = TRUE;
  IsMinusPol = FALSE;


#ifdef PLOT_SWITCHOBJECT_PROBES_rS71
#if PLOT_SWITCHOBJECT_PROBES_PHASE_NUM = 0
  if(phase_num == 0)
  {
	  DoProbes = TRUE;
#ifdef DO_PROBE_rS71_res
	  DoProbes_res = TRUE;
#endif
#ifdef DO_PROBE_rS71_cur
	  DoProbes_cur = TRUE;
#endif
#ifdef DO_PROBE_rS71_gate
	  DoProbes_gate = TRUE;
#endif
  }
#elsif PLOT_SWITCHOBJECT_PROBES_PHASE_NUM = 1
  if(phase_num == 1)
  {
	  DoProbes = TRUE;
#ifdef DO_PROBE_rS71_res
	  DoProbes_res = TRUE;
#endif
#ifdef DO_PROBE_rS71_cur
	  DoProbes_cur = TRUE;
#endif
#ifdef DO_PROBE_rS71_gate
	  DoProbes_gate = TRUE;
#endif
  }
#else
  if(phase_num == 2)
  {
	  DoProbes = TRUE;
#ifdef DO_PROBE_rS71_res
	  DoProbes_res = TRUE;
#endif
#ifdef DO_PROBE_rS71_cur
	  DoProbes_cur = TRUE;
#endif
#ifdef DO_PROBE_rS71_gate
	  DoProbes_gate = TRUE;
#endif
  }

#endif 
#endif

}

Switch_rS71::~Switch_rS71(void)
{

}

void Switch_rS71::CoefRValueUpdate(void)
{
  CoefObjItem * pCurCoefItem;

  //Update Rvalues
  pCurCoefItem = pCoefObjRValList;

  ((Coef_recp_rSrD71 *) pCurCoefItem->pCoefObject)->rS71 = y_igbt;
  ((Coef_recp_rSrD71 *) pCurCoefItem->pCoefObject)->rD71 = y_diode;

}


// ------------------------------------------------------------------


// ---- Switch_rS72 -----------------------------------------------

Switch_rS72::Switch_rS72(void)
{

  CoefObjItem * pCurCoefItem;


  if(phase_num == 0)
  {
	  SwitchFuncName = SWITCH_FUNC_rS72_0;
	  LiteralName = "rS72_0";
  }
  else if(phase_num == 1)
  {
	  SwitchFuncName = SWITCH_FUNC_rS72_1;
	  LiteralName = "rS72_1";

  }
  else
  {
	  SwitchFuncName = SWITCH_FUNC_rS72_2;
	  LiteralName = "rS72_2";
  }


  //build the COEF Rvalue list.

  pCoefObjRValList = new CoefObjItem;          
  pCurCoefItem = pCoefObjRValList;
 

  if(phase_num == 0)
  {
	  pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_recp_rSrD72_0];
  }
  else if(phase_num == 1)
  {
	  pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_recp_rSrD72_1];
  }
  else
  {
	  pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_recp_rSrD72_2];
  }

  IsIgbt = TRUE;
  IsMinusPol = FALSE;



#ifdef PLOT_SWITCHOBJECT_PROBES_rS72
#if PLOT_SWITCHOBJECT_PROBES_PHASE_NUM = 0
  if(phase_num == 0)
  {
	  DoProbes = TRUE;
#ifdef DO_PROBE_rS72_res
	  DoProbes_res = TRUE;
#endif
#ifdef DO_PROBE_rS72_cur
	  DoProbes_cur = TRUE;
#endif
#ifdef DO_PROBE_rS72_gate
	  DoProbes_gate = TRUE;
#endif
  }
#elsif PLOT_SWITCHOBJECT_PROBES_PHASE_NUM = 1
  if(phase_num == 1)
  {
	  DoProbes = TRUE;
#ifdef DO_PROBE_rS72_res
	  DoProbes_res = TRUE;
#endif
#ifdef DO_PROBE_rS72_cur
	  DoProbes_cur = TRUE;
#endif
#ifdef DO_PROBE_rS72_gate
	  DoProbes_gate = TRUE;
#endif
  }
#else
  if(phase_num == 2)
  {
	  DoProbes = TRUE;
#ifdef DO_PROBE_rS72_res
	  DoProbes_res = TRUE;
#endif
#ifdef DO_PROBE_rS72_cur
	  DoProbes_cur = TRUE;
#endif
#ifdef DO_PROBE_rS72_gate
	  DoProbes_gate = TRUE;
#endif
  }

#endif 
#endif




}

Switch_rS72::~Switch_rS72(void)
{

}

void Switch_rS72::CoefRValueUpdate(void)
{
  CoefObjItem * pCurCoefItem;

  //Update Rvalues
  pCurCoefItem = pCoefObjRValList;

  ((Coef_recp_rSrD72 *) pCurCoefItem->pCoefObject)->rS72 = y_igbt;
  ((Coef_recp_rSrD72 *) pCurCoefItem->pCoefObject)->rD72 = y_diode;

}


// ------------------------------------------------------------------



// ---- Switch_rS81 -----------------------------------------------

Switch_rS81::Switch_rS81(void)
{

  CoefObjItem * pCurCoefItem;


  if(phase_num == 0)
  {
	  SwitchFuncName = SWITCH_FUNC_rS81_0;
	  LiteralName = "rS81_0";
  }
  else if(phase_num == 1)
  {
	  SwitchFuncName = SWITCH_FUNC_rS81_1;
	  LiteralName = "rS81_1";

  }
  else
  {
	  SwitchFuncName = SWITCH_FUNC_rS81_2;
	  LiteralName = "rS81_2";
  }



  //build the COEF Rvalue list.

  pCoefObjRValList = new CoefObjItem;          
  pCurCoefItem = pCoefObjRValList;
 

  if(phase_num == 0)
  {
	  pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_recp_rSrD81_0];
  }
  else if(phase_num == 1)
  {
	  pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_recp_rSrD81_1];
  }
  else
  {
	  pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_recp_rSrD81_2];
  }



  IsIgbt = TRUE;
  IsMinusPol = FALSE;



#ifdef PLOT_SWITCHOBJECT_PROBES_rS81
#if PLOT_SWITCHOBJECT_PROBES_PHASE_NUM = 0
  if(phase_num == 0)
  {
	  DoProbes = TRUE;
#ifdef DO_PROBE_rS81_res
	  DoProbes_res = TRUE;
#endif
#ifdef DO_PROBE_rS81_cur
	  DoProbes_cur = TRUE;
#endif
#ifdef DO_PROBE_rS81_gate
	  DoProbes_gate = TRUE;
#endif
  }
#elsif PLOT_SWITCHOBJECT_PROBES_PHASE_NUM = 1
  if(phase_num == 1)
  {
	  DoProbes = TRUE;
#ifdef DO_PROBE_rS81_res
	  DoProbes_res = TRUE;
#endif
#ifdef DO_PROBE_rS81_cur
	  DoProbes_cur = TRUE;
#endif
#ifdef DO_PROBE_rS81_gate
	  DoProbes_gate = TRUE;
#endif
  }
#else
  if(phase_num == 2)
  {
	  DoProbes = TRUE;
#ifdef DO_PROBE_rS81_res
	  DoProbes_res = TRUE;
#endif
#ifdef DO_PROBE_rS81_cur
	  DoProbes_cur = TRUE;
#endif
#ifdef DO_PROBE_rS81_gate
	  DoProbes_gate = TRUE;
#endif
  }

#endif 
#endif




}

Switch_rS81::~Switch_rS81(void)
{

}

void Switch_rS81::CoefRValueUpdate(void)
{
  CoefObjItem * pCurCoefItem;

  //Update Rvalues
  pCurCoefItem = pCoefObjRValList;

  ((Coef_recp_rSrD81 *) pCurCoefItem->pCoefObject)->rS81 = y_igbt;
  ((Coef_recp_rSrD81 *) pCurCoefItem->pCoefObject)->rD81 = y_diode;

}


// ------------------------------------------------------------------


// ---- Switch_rS82 -----------------------------------------------

Switch_rS82::Switch_rS82(void)
{

  CoefObjItem * pCurCoefItem;


  if(phase_num == 0)
  {
	  SwitchFuncName = SWITCH_FUNC_rS82_0;
	  LiteralName = "rS82_0";
  }
  else if(phase_num == 1)
  {
	  SwitchFuncName = SWITCH_FUNC_rS82_1;
	  LiteralName = "rS82_1";

  }
  else
  {
	  SwitchFuncName = SWITCH_FUNC_rS82_2;
	  LiteralName = "rS82_2";
  }


  //build the COEF Rvalue list.

  pCoefObjRValList = new CoefObjItem;          
  pCurCoefItem = pCoefObjRValList;
 

  if(phase_num == 0)
  {
	  pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_recp_rSrD82_0];
  }
  else if(phase_num == 1)
  {
	  pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_recp_rSrD82_1];
  }
  else
  {
	  pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_recp_rSrD82_2];
  }




  IsIgbt = TRUE;
  IsMinusPol = FALSE;




#ifdef PLOT_SWITCHOBJECT_PROBES_rS82
#if PLOT_SWITCHOBJECT_PROBES_PHASE_NUM = 0
  if(phase_num == 0)
  {
	  DoProbes = TRUE;
#ifdef DO_PROBE_rS82_res
	  DoProbes_res = TRUE;
#endif
#ifdef DO_PROBE_rS82_cur
	  DoProbes_cur = TRUE;
#endif
#ifdef DO_PROBE_rS82_gate
	  DoProbes_gate = TRUE;
#endif
  }
#elsif PLOT_SWITCHOBJECT_PROBES_PHASE_NUM = 1
  if(phase_num == 1)
  {
	  DoProbes = TRUE;
#ifdef DO_PROBE_rS82_res
	  DoProbes_res = TRUE;
#endif
#ifdef DO_PROBE_rS82_cur
	  DoProbes_cur = TRUE;
#endif
#ifdef DO_PROBE_rS82_gate
	  DoProbes_gate = TRUE;
#endif
  }
#else
  if(phase_num == 2)
  {
	  DoProbes = TRUE;
#ifdef DO_PROBE_rS82_res
	  DoProbes_res = TRUE;
#endif
#ifdef DO_PROBE_rS82_cur
	  DoProbes_cur = TRUE;
#endif
#ifdef DO_PROBE_rS82_gate
	  DoProbes_gate = TRUE;
#endif
  }

#endif 
#endif




}

Switch_rS82::~Switch_rS82(void)
{

}

void Switch_rS82::CoefRValueUpdate(void)
{
  CoefObjItem * pCurCoefItem;

  //Update Rvalues
  pCurCoefItem = pCoefObjRValList;

  ((Coef_recp_rSrD82 *) pCurCoefItem->pCoefObject)->rS82 = y_igbt;
  ((Coef_recp_rSrD82 *) pCurCoefItem->pCoefObject)->rD82 = y_diode;

}


// ------------------------------------------------------------------

   


// ******************************************************************







// **** SpiceObject Functions ***************************************

// ---- Spice_MultiLevel ------------------------------------------

Spice_MultiLevel::Spice_MultiLevel(void)
{
  SpiceObjItem * pCurSpiceItem;
  OdeObjItem * pCurOdeItem;
  SwitchObjItem * pCurSwitchItem;
  CoefObjItem * pCurCoefItem;
    
  if(phase_num == 0)
  {
	  SpiceFuncName = SPICE_FUNC_MultiLevel_0;
	  LiteralName = "MLvl_0";
  }
  else if(phase_num == 0)
  {
	  SpiceFuncName = SPICE_FUNC_MultiLevel_1;
	  LiteralName = "MLvl_1";

  }
  else
  {
	  SpiceFuncName = SPICE_FUNC_MultiLevel_2;
	  LiteralName = "MLvl_2";

  }



  
  InitializeMatrix(69);   //(69 rows, 70 columns)
  

  if(phase_num == 0)
  {


  //Eq. (1)
  a_CoefObj[0][Ind_v11] = &Coef_recp_rSrD11_i_0;
  a_Static[0][Ind_v11] = -1.0;
  a_CoefObj[0][Ind_i1st] = 0;
  a_Static[0][Ind_i1st] = -1.0;
  a_CoefObj[0][69] = &Coef_recp_rSrD11_i_0;
  a_Static[0][69] = -PLUS_DC_BUS_VOLTAGE;
  
  //Eq. (2)
  a_CoefObj[1][Ind_v12] = &Coef_recp_rSrD12_i_0;
  a_Static[1][Ind_v12] = 1.0;
  a_CoefObj[1][Ind_i1sb] = 0;
  a_Static[1][Ind_i1sb] = -1.0;
  a_CoefObj[1][69] = &Coef_recp_rSrD12_i_0;
  a_Static[1][69] = PLUS_DC_BUS_VOLTAGE;

  //Eq. (3)
  a_CoefObj[2][Ind_ipl] = 0;
  a_Static[2][Ind_ipl] = 1.0;
  a_CoefObj[2][Ind_i1_l] = 0;
  a_Static[2][Ind_i1_l] = 1.0;
  a_CoefObj[2][Ind_i1] = 0;
  a_Static[2][Ind_i1] = -1.0;
  a_CoefObj[2][69] = 0;
  a_Static[2][69] = 0;

  //Eq. (4)
  a_CoefObj[3][Ind_i1st] = 0;
  a_Static[3][Ind_i1st] = 1.0;
  a_CoefObj[3][Ind_i1ct] = 0;
  a_Static[3][Ind_i1ct] = 1.0;
  a_CoefObj[3][Ind_i1] = 0;
  a_Static[3][Ind_i1] = -1.0;
  a_CoefObj[3][69] = 0;
  a_Static[3][69] = 0;

  //Eq. (5)
  a_CoefObj[4][Ind_i1sb] = 0;
  a_Static[4][Ind_i1sb] = 1.0;
  a_CoefObj[4][Ind_i1cb] = 0;
  a_Static[4][Ind_i1cb] = 1.0;
  a_CoefObj[4][Ind_i1_l] = 0;
  a_Static[4][Ind_i1_l] = -1.0;
  a_CoefObj[4][69] = 0;
  a_Static[4][69] = 0;

   //Eq. (6)
  a_CoefObj[5][Ind_v11] = &Coef_C1_h_i_0;
  a_Static[5][Ind_v11] = 1.0;
  a_CoefObj[5][Ind_v12] = &Coef_C1_h_i_0;
  a_Static[5][Ind_v12] = -1.0;
  a_CoefObj[5][Ind_i1] = 0;
  a_Static[5][Ind_i1] = -1.0;
  a_CoefObj[5][69] = &Coef_v11_v12_h_prev_C1_i_0;
  a_Static[5][69] = 1.0;

   //Eq. (7)
  a_CoefObj[6][Ind_v11] = &Coef_C11_h_i_0;
  a_Static[6][Ind_v11] = -1.0;
  a_CoefObj[6][Ind_i1ct] = 0;
  a_Static[6][Ind_i1ct] = -1.0;
  a_CoefObj[6][69] = &Coef_minus_v11_h_prev_minus_PlusBus_C11_i_0;
  a_Static[6][69] = 1.0;

   //Eq. (8)
  a_CoefObj[7][Ind_v12] = &Coef_C12_h_i_0;
  a_Static[7][Ind_v12] = 1.0;
  a_CoefObj[7][Ind_i1cb] = 0;
  a_Static[7][Ind_i1cb] = -1.0;
  a_CoefObj[7][69] = &Coef_v12_h_prev_plus_PlusBus_C12_i_0;
  a_Static[7][69] = 1.0;

   //Eq. (9)
  a_CoefObj[8][Ind_v12] = &Coef_recp_rSrD21_i_0;
  a_Static[8][Ind_v12] = 1.0;
  a_CoefObj[8][Ind_v21] = &Coef_recp_rSrD21_i_0;
  a_Static[8][Ind_v21] = -1.0;
  a_CoefObj[8][Ind_i2st] = 0;
  a_Static[8][Ind_i2st] = -1.0;
  a_CoefObj[8][69] = 0;
  a_Static[8][69] = 0;
  
  //Eq. (10)
  a_CoefObj[9][Ind_v23] = &Coef_recp_rSrD22_i_0;
  a_Static[9][Ind_v23] = 1.0;
  a_CoefObj[9][Ind_v12] = &Coef_recp_rSrD22_i_0;
  a_Static[9][Ind_v12] = -1.0;
  a_CoefObj[9][Ind_i2sb] = 0;
  a_Static[9][Ind_i2sb] = -1.0;
  a_CoefObj[9][69] = 0;
  a_Static[9][69] = 0;

  //Eq. (11)
  a_CoefObj[10][Ind_ipl] = 0;
  a_Static[10][Ind_ipl] = 1.0;
  a_CoefObj[10][Ind_i2_l] = 0;
  a_Static[10][Ind_i2_l] = 1.0;
  a_CoefObj[10][Ind_i2] = 0;
  a_Static[10][Ind_i2] = -1.0;
  a_CoefObj[10][69] = 0;
  a_Static[10][69] = 0;

  //Eq. (12)
  a_CoefObj[11][Ind_i2st] = 0;
  a_Static[11][Ind_i2st] = 1.0;
  a_CoefObj[11][Ind_i2ct] = 0;
  a_Static[11][Ind_i2ct] = 1.0;
  a_CoefObj[11][Ind_i2] = 0;
  a_Static[11][Ind_i2] = -1.0;
  a_CoefObj[11][69] = 0;
  a_Static[11][69] = 0;

  //Eq. (13)
  a_CoefObj[12][Ind_i2sb] = 0;
  a_Static[12][Ind_i2sb] = 1.0;
  a_CoefObj[12][Ind_i2cb] = 0;
  a_Static[12][Ind_i2cb] = 1.0;
  a_CoefObj[12][Ind_i2_l] = 0;
  a_Static[12][Ind_i2_l] = -1.0;
  a_CoefObj[12][69] = 0;
  a_Static[12][69] = 0;


  //Eq. (14)
  a_CoefObj[13][Ind_v21] = &Coef_C2_h_i_0;
  a_Static[13][Ind_v21] = 1.0;
  a_CoefObj[13][Ind_v23] = &Coef_C2_h_i_0;
  a_Static[13][Ind_v23] = -1.0;
  a_CoefObj[13][Ind_i2] = 0;
  a_Static[13][Ind_i2] = -1.0;
  a_CoefObj[13][69] = &Coef_v21_v23_h_prev_C2_i_0;
  a_Static[13][69] = 1.0;



  //Eq. (15)
  a_CoefObj[14][Ind_v12] = &Coef_C21_h_i_0;
  a_Static[14][Ind_v12] = 1.0;
  a_CoefObj[14][Ind_v21] = &Coef_C21_h_i_0;
  a_Static[14][Ind_v21] = -1.0;
  a_CoefObj[14][Ind_i2ct] = 0;
  a_Static[14][Ind_i2ct] = -1.0;
  a_CoefObj[14][69] = &Coef_v12_v21_h_prev_C21_i_0;
  a_Static[14][69] = 1.0;


  //Eq. (16)
  a_CoefObj[15][Ind_v23] = &Coef_C22_h_i_0;
  a_Static[15][Ind_v23] = 1.0;
  a_CoefObj[15][Ind_v12] = &Coef_C22_h_i_0;
  a_Static[15][Ind_v12] = -1.0;
  a_CoefObj[15][Ind_i2cb] = 0;
  a_Static[15][Ind_i2cb] = -1.0;
  a_CoefObj[15][69] = &Coef_v23_v12_h_prev_C22_i_0;
  a_Static[15][69] = 1.0;


  //Eq. (17)
  a_CoefObj[16][Ind_v23] = &Coef_recp_rSrD31_i_0;
  a_Static[16][Ind_v23] = 1.0;
  a_CoefObj[16][Ind_v31] = &Coef_recp_rSrD31_i_0;
  a_Static[16][Ind_v31] = -1.0;
  a_CoefObj[16][Ind_i3st] = 0;
  a_Static[16][Ind_i3st] = -1.0;
  a_CoefObj[16][69] = 0;
  a_Static[16][69] = 0;
  
  //Eq. (18)
  a_CoefObj[17][Ind_v34] = &Coef_recp_rSrD32_i_0;
  a_Static[17][Ind_v34] = 1.0;
  a_CoefObj[17][Ind_v23] = &Coef_recp_rSrD32_i_0;
  a_Static[17][Ind_v23] = -1.0;
  a_CoefObj[17][Ind_i3sb] = 0;
  a_Static[17][Ind_i3sb] = -1.0;
  a_CoefObj[17][69] = 0;
  a_Static[17][69] = 0;

  
  //Eq. (19)
  a_CoefObj[18][Ind_ipl] = 0;
  a_Static[18][Ind_ipl] = 1.0;
  a_CoefObj[18][Ind_i3_l] = 0;
  a_Static[18][Ind_i3_l] = 1.0;
  a_CoefObj[18][Ind_i3] = 0;
  a_Static[18][Ind_i3] = -1.0;
  a_CoefObj[18][69] = 0;
  a_Static[18][69] = 0;


  //Eq. (20)
  a_CoefObj[19][Ind_i3st] = 0;
  a_Static[19][Ind_i3st] = 1.0;
  a_CoefObj[19][Ind_i3ct] = 0;
  a_Static[19][Ind_i3ct] = 1.0;
  a_CoefObj[19][Ind_i3] = 0;
  a_Static[19][Ind_i3] = -1.0;
  a_CoefObj[19][69] = 0;
  a_Static[19][69] = 0;


  //Eq. (21)
  a_CoefObj[20][Ind_i3sb] = 0;
  a_Static[20][Ind_i3sb] = 1.0;
  a_CoefObj[20][Ind_i3cb] = 0;
  a_Static[20][Ind_i3cb] = 1.0;
  a_CoefObj[20][Ind_i3_l] = 0;
  a_Static[20][Ind_i3_l] = -1.0;
  a_CoefObj[20][69] = 0;
  a_Static[20][69] = 0;


   //Eq. (22)
  a_CoefObj[21][Ind_v31] = &Coef_C3_h_i_0;
  a_Static[21][Ind_v31] = 1.0;
  a_CoefObj[21][Ind_v34] = &Coef_C3_h_i_0;
  a_Static[21][Ind_v34] = -1.0;
  a_CoefObj[21][Ind_i3] = 0;
  a_Static[21][Ind_i3] = -1.0;
  a_CoefObj[21][69] = &Coef_v31_v34_h_prev_C3_i_0;
  a_Static[21][69] = 1.0;


  //Eq. (23)
  a_CoefObj[22][Ind_v23] = &Coef_C31_h_i_0;
  a_Static[22][Ind_v23] = 1.0;
  a_CoefObj[22][Ind_v31] = &Coef_C31_h_i_0;
  a_Static[22][Ind_v31] = -1.0;
  a_CoefObj[22][Ind_i3ct] = 0;
  a_Static[22][Ind_i3ct] = -1.0;
  a_CoefObj[22][69] = &Coef_v23_v31_h_prev_C31_i_0;
  a_Static[22][69] = 1.0;


  //Eq. (24)
  a_CoefObj[23][Ind_v34] = &Coef_C32_h_i_0;
  a_Static[23][Ind_v34] = 1.0;
  a_CoefObj[23][Ind_v23] = &Coef_C32_h_i_0;
  a_Static[23][Ind_v23] = -1.0;
  a_CoefObj[23][Ind_i3cb] = 0;
  a_Static[23][Ind_i3cb] = -1.0;
  a_CoefObj[23][69] = &Coef_v34_v23_h_prev_C32_i_0;
  a_Static[23][69] = 1.0;


  //Eq. (25)
  a_CoefObj[24][Ind_v34] = &Coef_recp_rSrD41_i_0;
  a_Static[24][Ind_v34] = 1.0;
  a_CoefObj[24][Ind_v41] = &Coef_recp_rSrD41_i_0;
  a_Static[24][Ind_v41] = -1.0;
  a_CoefObj[24][Ind_i4st] = 0;
  a_Static[24][Ind_i4st] = -1.0;
  a_CoefObj[24][69] = 0;
  a_Static[24][69] = 0;
  
  //Eq. (26)
  a_CoefObj[25][Ind_v44] = &Coef_recp_rSrD42_i_0;
  a_Static[25][Ind_v44] = 1.0;
  a_CoefObj[25][Ind_v34] = &Coef_recp_rSrD42_i_0;
  a_Static[25][Ind_v34] = -1.0;
  a_CoefObj[25][Ind_i4sb] = 0;
  a_Static[25][Ind_i4sb] = -1.0;
  a_CoefObj[25][69] = 0;
  a_Static[25][69] = 0;

  //Eq. (27)
  a_CoefObj[26][Ind_ipl] = 0;
  a_Static[26][Ind_ipl] = 1.0;
  a_CoefObj[26][Ind_i4_l] = 0;
  a_Static[26][Ind_i4_l] = 1.0;
  a_CoefObj[26][Ind_i4] = 0;
  a_Static[26][Ind_i4] = -1.0;
  a_CoefObj[26][69] = 0;
  a_Static[26][69] = 0;


  //Eq. (28)
  a_CoefObj[27][Ind_i4st] = 0;
  a_Static[27][Ind_i4st] = 1.0;
  a_CoefObj[27][Ind_i4ct] = 0;
  a_Static[27][Ind_i4ct] = 1.0;
  a_CoefObj[27][Ind_i4] = 0;
  a_Static[27][Ind_i4] = -1.0;
  a_CoefObj[27][69] = 0;
  a_Static[27][69] = 0;


  //Eq. (29)
  a_CoefObj[28][Ind_i4sb] = 0;
  a_Static[28][Ind_i4sb] = 1.0;
  a_CoefObj[28][Ind_i4cb] = 0;
  a_Static[28][Ind_i4cb] = 1.0;
  a_CoefObj[28][Ind_i4_l] = 0;
  a_Static[28][Ind_i4_l] = -1.0;
  a_CoefObj[28][69] = 0;
  a_Static[28][69] = 0;


  //Eq. (30)
  a_CoefObj[29][Ind_v41] = &Coef_C4_h_i_0;
  a_Static[29][Ind_v41] = 1.0;
  a_CoefObj[29][Ind_v44] = &Coef_C4_h_i_0;
  a_Static[29][Ind_v44] = -1.0;
  a_CoefObj[29][Ind_i4] = 0;
  a_Static[29][Ind_i4] = -1.0;
  a_CoefObj[29][69] = &Coef_v41_v44_h_prev_C4_i_0;
  a_Static[29][69] = 1.0;


  //Eq. (31)
  a_CoefObj[30][Ind_v34] = &Coef_C41_h_i_0;
  a_Static[30][Ind_v34] = 1.0;
  a_CoefObj[30][Ind_v41] = &Coef_C41_h_i_0;
  a_Static[30][Ind_v41] = -1.0;
  a_CoefObj[30][Ind_i4ct] = 0;
  a_Static[30][Ind_i4ct] = -1.0;
  a_CoefObj[30][69] = &Coef_v34_v41_h_prev_C41_i_0;
  a_Static[30][69] = 1.0;


  //Eq. (32)
  a_CoefObj[31][Ind_v44] = &Coef_C42_h_i_0;
  a_Static[31][Ind_v44] = 1.0;
  a_CoefObj[31][Ind_v34] = &Coef_C42_h_i_0;
  a_Static[31][Ind_v34] = -1.0;
  a_CoefObj[31][Ind_i4cb] = 0;
  a_Static[31][Ind_i4cb] = -1.0;
  a_CoefObj[31][69] = &Coef_v44_v34_h_prev_C42_i_0;
  a_Static[31][69] = 1.0;

  
  //Eq. (33)
  a_CoefObj[32][Ind_v44] = 0;
  a_Static[32][Ind_v44] = RECEP_Rp;
  a_CoefObj[32][Ind_vs_a] = 0;
  a_Static[32][Ind_vs_a] = -RECEP_Rp;
  a_CoefObj[32][Ind_iLp] = 0;
  a_Static[32][Ind_iLp] = 1.0;
  a_CoefObj[32][Ind_ipl] = 0;
  a_Static[32][Ind_ipl] = -1.0;
  a_CoefObj[32][69] = 0;
  a_Static[32][69] = 0;
  
  //Eq. (34)
  a_CoefObj[33][Ind_v45] = 0;
  a_Static[33][Ind_v45] = -RECEP_Rn;
  a_CoefObj[33][Ind_vs_a] = 0;
  a_Static[33][Ind_vs_a] = RECEP_Rn;
  a_CoefObj[33][Ind_iLn] = 0;
  a_Static[33][Ind_iLn] = 1.0;
  a_CoefObj[33][Ind_inl] = 0;
  a_Static[33][Ind_inl] = -1.0;
  a_CoefObj[33][69] = 0;
  a_Static[33][69] = 0;


  
  //Eq. (35)
  a_CoefObj[34][Ind_iLp] = &Coef_Lp_h_i_0;
  a_Static[34][Ind_iLp] = 1.0;
  a_CoefObj[34][Ind_iLn] = &Coef_Mpn_h_i_0;
  a_Static[34][Ind_iLn] = 1.0;
  a_CoefObj[34][Ind_v44] = 0;
  a_Static[34][Ind_v44] = -1.0;
  a_CoefObj[34][Ind_vs_a] = 0;
  a_Static[34][Ind_vs_a] = 1.0;
  a_CoefObj[34][69] = &Coef_iLp_iLn_h_prev_Lp_Mpn_i_0;
  a_Static[34][69] = 1.0;


  //Eq. (36)
  a_CoefObj[35][Ind_iLp] = &Coef_Mnp_h_i_0;
  a_Static[35][Ind_iLp] = 1.0;
  a_CoefObj[35][Ind_iLn] = &Coef_Ln_h_i_0;
  a_Static[35][Ind_iLn] = 1.0;
  a_CoefObj[35][Ind_vs_a] = 0;
  a_Static[35][Ind_vs_a] = -1.0;
  a_CoefObj[35][Ind_v45] = 0;
  a_Static[35][Ind_v45] = 1.0;
  a_CoefObj[35][69] = &Coef_iLp_iLn_h_prev_Mnp_Ln_i_0;
  a_Static[35][69] = 1.0;


  //Eq. (37)
  a_CoefObj[36][Ind_ipl] = 0;
  a_Static[36][Ind_ipl] = 1.0;
  a_CoefObj[36][Ind_inl] = 0;
  a_Static[36][Ind_inl] = -1.0;
  a_CoefObj[36][69] = &Coef_ia_i_0;
  a_Static[36][69] = 1.0;


   
  //Eq. (38)
  a_CoefObj[37][Ind_v45] = &Coef_recp_rSrD51_i_0;
  a_Static[37][Ind_v45] = 1.0;
  a_CoefObj[37][Ind_v51] = &Coef_recp_rSrD51_i_0;
  a_Static[37][Ind_v51] = -1.0;
  a_CoefObj[37][Ind_i5st] = 0;
  a_Static[37][Ind_i5st] = -1.0;
  a_CoefObj[37][69] = 0;
  a_Static[37][69] = 0;
  

  //Eq. (39)
  a_CoefObj[38][Ind_v56] = &Coef_recp_rSrD52_i_0;
  a_Static[38][Ind_v56] = 1.0;
  a_CoefObj[38][Ind_v45] = &Coef_recp_rSrD52_i_0;
  a_Static[38][Ind_v45] = -1.0;
  a_CoefObj[38][Ind_i5sb] = 0;
  a_Static[38][Ind_i5sb] = -1.0;
  a_CoefObj[38][69] = 0;
  a_Static[38][69] = 0;

  //Eq. (40)
  a_CoefObj[39][Ind_inl] = 0;
  a_Static[39][Ind_inl] = 1.0;
  a_CoefObj[39][Ind_i5_l] = 0;
  a_Static[39][Ind_i5_l] = 1.0;
  a_CoefObj[39][Ind_i5] = 0;
  a_Static[39][Ind_i5] = -1.0;
  a_CoefObj[39][69] = 0;
  a_Static[39][69] = 0;

  //Eq. (41)
  a_CoefObj[40][Ind_i5st] = 0;
  a_Static[40][Ind_i5st] = 1.0;
  a_CoefObj[40][Ind_i5ct] = 0;
  a_Static[40][Ind_i5ct] = 1.0;
  a_CoefObj[40][Ind_i5] = 0;
  a_Static[40][Ind_i5] = -1.0;
  a_CoefObj[40][69] = 0;
  a_Static[40][69] = 0;


  //Eq. (42)
  a_CoefObj[41][Ind_i5sb] = 0;
  a_Static[41][Ind_i5sb] = 1.0;
  a_CoefObj[41][Ind_i5cb] = 0;
  a_Static[41][Ind_i5cb] = 1.0;
  a_CoefObj[41][Ind_i5_l] = 0;
  a_Static[41][Ind_i5_l] = -1.0;
  a_CoefObj[41][69] = 0;
  a_Static[41][69] = 0;


  //Eq. (43)
  a_CoefObj[42][Ind_v51] = &Coef_C5_h_i_0;
  a_Static[42][Ind_v51] = 1.0;
  a_CoefObj[42][Ind_v56] = &Coef_C5_h_i_0;
  a_Static[42][Ind_v56] = -1.0;
  a_CoefObj[42][Ind_i5] = 0;
  a_Static[42][Ind_i5] = -1.0;
  a_CoefObj[42][69] = &Coef_v51_v56_h_prev_C5_i_0;
  a_Static[42][69] = 1.0;


  //Eq. (44)
  a_CoefObj[43][Ind_v45] = &Coef_C51_h_i_0;
  a_Static[43][Ind_v45] = 1.0;
  a_CoefObj[43][Ind_v51] = &Coef_C51_h_i_0;
  a_Static[43][Ind_v51] = -1.0;
  a_CoefObj[43][Ind_i5ct] = 0;
  a_Static[43][Ind_i5ct] = -1.0;
  a_CoefObj[43][69] = &Coef_v45_v51_h_prev_C51_i_0;
  a_Static[43][69] = 1.0;


  //Eq. (45)
  a_CoefObj[44][Ind_v56] = &Coef_C52_h_i_0;
  a_Static[44][Ind_v56] = 1.0;
  a_CoefObj[44][Ind_v45] = &Coef_C52_h_i_0;
  a_Static[44][Ind_v45] = -1.0;
  a_CoefObj[44][Ind_i5cb] = 0;
  a_Static[44][Ind_i5cb] = -1.0;
  a_CoefObj[44][69] = &Coef_v56_v45_h_prev_C52_i_0;
  a_Static[44][69] = 1.0;



  //Eq. (46)
  a_CoefObj[45][Ind_v56] = &Coef_recp_rSrD61_i_0;
  a_Static[45][Ind_v56] = 1.0;
  a_CoefObj[45][Ind_v61] = &Coef_recp_rSrD61_i_0;
  a_Static[45][Ind_v61] = -1.0;
  a_CoefObj[45][Ind_i6st] = 0;
  a_Static[45][Ind_i6st] = -1.0;
  a_CoefObj[45][69] = 0;
  a_Static[45][69] = 0;

  //Eq. (47)
  a_CoefObj[46][Ind_v67] = &Coef_recp_rSrD62_i_0;
  a_Static[46][Ind_v67] = 1.0;
  a_CoefObj[46][Ind_v56] = &Coef_recp_rSrD62_i_0;
  a_Static[46][Ind_v56] = -1.0;
  a_CoefObj[46][Ind_i6sb] = 0;
  a_Static[46][Ind_i6sb] = -1.0;
  a_CoefObj[46][69] = 0;
  a_Static[46][69] = 0;

  //Eq. (48)
  a_CoefObj[47][Ind_inl] = 0;
  a_Static[47][Ind_inl] = 1.0;
  a_CoefObj[47][Ind_i6_l] = 0;
  a_Static[47][Ind_i6_l] = 1.0;
  a_CoefObj[47][Ind_i6] = 0;
  a_Static[47][Ind_i6] = -1.0;
  a_CoefObj[47][69] = 0;
  a_Static[47][69] = 0;

  //Eq. (49)
  a_CoefObj[48][Ind_i6st] = 0;
  a_Static[48][Ind_i6st] = 1.0;
  a_CoefObj[48][Ind_i6ct] = 0;
  a_Static[48][Ind_i6ct] = 1.0;
  a_CoefObj[48][Ind_i6] = 0;
  a_Static[48][Ind_i6] = -1.0;
  a_CoefObj[48][69] = 0;
  a_Static[48][69] = 0;


  //Eq. (50)
  a_CoefObj[49][Ind_i6sb] = 0;
  a_Static[49][Ind_i6sb] = 1.0;
  a_CoefObj[49][Ind_i6cb] = 0;
  a_Static[49][Ind_i6cb] = 1.0;
  a_CoefObj[49][Ind_i6_l] = 0;
  a_Static[49][Ind_i6_l] = -1.0;
  a_CoefObj[49][69] = 0;
  a_Static[49][69] = 0;


  //Eq. (51)
  a_CoefObj[50][Ind_v61] =  &Coef_C6_h_i_0;
  a_Static[50][Ind_v61] = 1.0;
  a_CoefObj[50][Ind_v67] =  &Coef_C6_h_i_0;
  a_Static[50][Ind_v67] = -1.0;
  a_CoefObj[50][Ind_i6] = 0;
  a_Static[50][Ind_i6] = -1.0;
  a_CoefObj[50][69] = &Coef_v61_v67_h_prev_C6_i_0;
  a_Static[50][69] = 1.0;

  //Eq. (52)
  a_CoefObj[51][Ind_v56] = &Coef_C61_h_i_0;
  a_Static[51][Ind_v56] = 1.0;
  a_CoefObj[51][Ind_v61] = &Coef_C61_h_i_0;
  a_Static[51][Ind_v61] = -1.0;
  a_CoefObj[51][Ind_i6ct] = 0;
  a_Static[51][Ind_i6ct] = -1.0;
  a_CoefObj[51][69] = &Coef_v56_v61_h_prev_C61_i_0;
  a_Static[51][69] = 1.0;


  //Eq. (53)
  a_CoefObj[52][Ind_v67] = &Coef_C62_h_i_0;
  a_Static[52][Ind_v67] = 1.0;
  a_CoefObj[52][Ind_v56] = &Coef_C62_h_i_0;
  a_Static[52][Ind_v56] = -1.0;
  a_CoefObj[52][Ind_i6cb] = 0;
  a_Static[52][Ind_i6cb] = -1.0;
  a_CoefObj[52][69] = &Coef_v67_v56_h_prev_C62_i_0;
  a_Static[52][69] = 1.0;


  //Eq. (54)
  a_CoefObj[53][Ind_v67] = &Coef_recp_rSrD71_i_0;
  a_Static[53][Ind_v67] = 1.0;
  a_CoefObj[53][Ind_v71] = &Coef_recp_rSrD71_i_0;
  a_Static[53][Ind_v71] = -1.0;
  a_CoefObj[53][Ind_i7st] = 0;
  a_Static[53][Ind_i7st] = -1.0;
  a_CoefObj[53][69] = 0;
  a_Static[53][69] = 0;

  //Eq. (55)
  a_CoefObj[54][Ind_v78] = &Coef_recp_rSrD72_i_0;
  a_Static[54][Ind_v78] = 1.0;
  a_CoefObj[54][Ind_v67] = &Coef_recp_rSrD72_i_0;
  a_Static[54][Ind_v67] = -1.0;
  a_CoefObj[54][Ind_i7sb] = 0;
  a_Static[54][Ind_i7sb] = -1.0;
  a_CoefObj[54][69] = 0;
  a_Static[54][69] = 0;

  //Eq. (56)
  a_CoefObj[55][Ind_inl] = 0;
  a_Static[55][Ind_inl] = 1.0;
  a_CoefObj[55][Ind_i7_l] = 0;
  a_Static[55][Ind_i7_l] = 1.0;
  a_CoefObj[55][Ind_i7] = 0;
  a_Static[55][Ind_i7] = -1.0;
  a_CoefObj[55][69] = 0;
  a_Static[55][69] = 0;

  //Eq. (57)
  a_CoefObj[56][Ind_i7st] = 0;
  a_Static[56][Ind_i7st] = 1.0;
  a_CoefObj[56][Ind_i7ct] = 0;
  a_Static[56][Ind_i7ct] = 1.0;
  a_CoefObj[56][Ind_i7] = 0;
  a_Static[56][Ind_i7] = -1.0;
  a_CoefObj[56][69] = 0;
  a_Static[56][69] = 0;


  //Eq. (58)
  a_CoefObj[57][Ind_i7sb] = 0;
  a_Static[57][Ind_i7sb] = 1.0;
  a_CoefObj[57][Ind_i7cb] = 0;
  a_Static[57][Ind_i7cb] = 1.0;
  a_CoefObj[57][Ind_i7_l] = 0;
  a_Static[57][Ind_i7_l] = -1.0;
  a_CoefObj[57][69] = 0;
  a_Static[57][69] = 0;


  //Eq. (59)
  a_CoefObj[58][Ind_v71] = &Coef_C7_h_i_0;
  a_Static[58][Ind_v71] = 1.0;
  a_CoefObj[58][Ind_v78] = &Coef_C7_h_i_0;
  a_Static[58][Ind_v78] = -1.0;
  a_CoefObj[58][Ind_i7] = 0;
  a_Static[58][Ind_i7] = -1.0;
  a_CoefObj[58][69] = &Coef_v71_v78_h_prev_C7_i_0;
  a_Static[58][69] = 1.0;

  //Eq. (60)
  a_CoefObj[59][Ind_v67] = &Coef_C71_h_i_0;
  a_Static[59][Ind_v67] = 1.0;
  a_CoefObj[59][Ind_v71] = &Coef_C71_h_i_0;
  a_Static[59][Ind_v71] = -1.0;
  a_CoefObj[59][Ind_i7ct] = 0;
  a_Static[59][Ind_i7ct] = -1.0;
  a_CoefObj[59][69] = &Coef_v67_v71_h_prev_C71_i_0;
  a_Static[59][69] = 1.0;


  //Eq. (61)
  a_CoefObj[60][Ind_v78] = &Coef_C72_h_i_0;
  a_Static[60][Ind_v78] = 1.0;
  a_CoefObj[60][Ind_v67] = &Coef_C72_h_i_0;
  a_Static[60][Ind_v67] = -1.0;
  a_CoefObj[60][Ind_i7cb] = 0;
  a_Static[60][Ind_i7cb] = -1.0;
  a_CoefObj[60][69] = &Coef_v78_v67_h_prev_C72_i_0;
  a_Static[60][69] = 1.0;
  

  //Eq. (62)
  a_CoefObj[61][Ind_v78] = &Coef_recp_rSrD81_i_0;
  a_Static[61][Ind_v78] = 1.0;
  a_CoefObj[61][Ind_v81] = &Coef_recp_rSrD81_i_0;
  a_Static[61][Ind_v81] = -1.0;
  a_CoefObj[61][Ind_i8st] = 0;
  a_Static[61][Ind_i8st] = -1.0;
  a_CoefObj[61][69] = 0;
  a_Static[61][69] = 0;


  //Eq. (63)
  a_CoefObj[62][Ind_v78] = &Coef_recp_rSrD82_i_0;
  a_Static[62][Ind_v78] = -1.0;
  a_CoefObj[62][Ind_i8sb] = 0;
  a_Static[62][Ind_i8sb] = -1.0;
  a_CoefObj[62][69] = &Coef_recp_rSrD82_i_0;
  a_Static[62][69] = - MINUS_DC_BUS_VOLTAGE;

  //Eq. (64)
  a_CoefObj[63][Ind_inl] = 0;
  a_Static[63][Ind_inl] = 1.0;
  a_CoefObj[63][Ind_i8_l] = 0;
  a_Static[63][Ind_i8_l] = 1.0;
  a_CoefObj[63][Ind_i8] = 0;
  a_Static[63][Ind_i8] = -1.0;
  a_CoefObj[63][69] = 0;
  a_Static[63][69] = 0;

  //Eq. (65)
  a_CoefObj[64][Ind_i8st] = 0;
  a_Static[64][Ind_i8st] = 1.0;
  a_CoefObj[64][Ind_i8ct] = 0;
  a_Static[64][Ind_i8ct] = 1.0;
  a_CoefObj[64][Ind_i8] = 0;
  a_Static[64][Ind_i8] = -1.0;
  a_CoefObj[64][69] = 0;
  a_Static[64][69] = 0;


  //Eq. (66)
  a_CoefObj[65][Ind_i8sb] = 0;
  a_Static[65][Ind_i8sb] = 1.0;
  a_CoefObj[65][Ind_i8cb] = 0;
  a_Static[65][Ind_i8cb] = 1.0;
  a_CoefObj[65][Ind_i8_l] = 0;
  a_Static[65][Ind_i8_l] = -1.0;
  a_CoefObj[65][69] = 0;
  a_Static[65][69] = 0;



  //Eq. (67)
  a_CoefObj[66][Ind_v81] = &Coef_C8_h_i_0;
  a_Static[66][Ind_v81] = 1.0;
  a_CoefObj[66][Ind_i8] = 0;
  a_Static[66][Ind_i8] = -1.0;
  a_CoefObj[66][69] = &Coef_v81_h_prev_plus_MinusBus_C8_i_0;
  a_Static[66][69] = 1.0;

  //Eq. (68)
  a_CoefObj[67][Ind_v78] = &Coef_C81_h_i_0;
  a_Static[67][Ind_v78] = 1.0;
  a_CoefObj[67][Ind_v81] = &Coef_C81_h_i_0;
  a_Static[67][Ind_v81] = -1.0;
  a_CoefObj[67][Ind_i8ct] = 0;
  a_Static[67][Ind_i8ct] = -1.0;
  a_CoefObj[67][69] = &Coef_v78_v81_h_prev_C81_i_0;
  a_Static[67][69] = 1.0;

  //Eq. (69)
  a_CoefObj[68][Ind_v78] = &Coef_C82_h_i_0;
  a_Static[68][Ind_v78] = -1.0;
  a_CoefObj[68][Ind_i8cb] = 0;
  a_Static[68][Ind_i8cb] = -1.0;
  a_CoefObj[68][69] = &Coef_minus_v78_h_prev_minus_MinusBus_C82_i_0;
  a_Static[68][69] = 1.0;

  }
  else if(phase_num == 1)
  {
	  //Eq. (1)
	  a_CoefObj[0][Ind_v11] = &Coef_recp_rSrD11_i_1;
	  a_Static[0][Ind_v11] = -1.0;
	  a_CoefObj[0][Ind_i1st] = 0;
	  a_Static[0][Ind_i1st] = -1.0;
	  a_CoefObj[0][69] = &Coef_recp_rSrD11_i_1;
	  a_Static[0][69] = -PLUS_DC_BUS_VOLTAGE;

	  //Eq. (2)
	  a_CoefObj[1][Ind_v12] = &Coef_recp_rSrD12_i_1;
	  a_Static[1][Ind_v12] = 1.0;
	  a_CoefObj[1][Ind_i1sb] = 0;
	  a_Static[1][Ind_i1sb] = -1.0;
	  a_CoefObj[1][69] = &Coef_recp_rSrD12_i_1;
	  a_Static[1][69] = PLUS_DC_BUS_VOLTAGE;

	  //Eq. (3)
	  a_CoefObj[2][Ind_ipl] = 0;
	  a_Static[2][Ind_ipl] = 1.0;
	  a_CoefObj[2][Ind_i1_l] = 0;
	  a_Static[2][Ind_i1_l] = 1.0;
	  a_CoefObj[2][Ind_i1] = 0;
	  a_Static[2][Ind_i1] = -1.0;
	  a_CoefObj[2][69] = 0;
	  a_Static[2][69] = 0;

	  //Eq. (4)
	  a_CoefObj[3][Ind_i1st] = 0;
	  a_Static[3][Ind_i1st] = 1.0;
	  a_CoefObj[3][Ind_i1ct] = 0;
	  a_Static[3][Ind_i1ct] = 1.0;
	  a_CoefObj[3][Ind_i1] = 0;
	  a_Static[3][Ind_i1] = -1.0;
	  a_CoefObj[3][69] = 0;
	  a_Static[3][69] = 0;

	  //Eq. (5)
	  a_CoefObj[4][Ind_i1sb] = 0;
	  a_Static[4][Ind_i1sb] = 1.0;
	  a_CoefObj[4][Ind_i1cb] = 0;
	  a_Static[4][Ind_i1cb] = 1.0;
	  a_CoefObj[4][Ind_i1_l] = 0;
	  a_Static[4][Ind_i1_l] = -1.0;
	  a_CoefObj[4][69] = 0;
	  a_Static[4][69] = 0;

	   //Eq. (6)
	  a_CoefObj[5][Ind_v11] = &Coef_C1_h_i_1;
	  a_Static[5][Ind_v11] = 1.0;
	  a_CoefObj[5][Ind_v12] = &Coef_C1_h_i_1;
	  a_Static[5][Ind_v12] = -1.0;
	  a_CoefObj[5][Ind_i1] = 0;
	  a_Static[5][Ind_i1] = -1.0;
	  a_CoefObj[5][69] = &Coef_v11_v12_h_prev_C1_i_1;
	  a_Static[5][69] = 1.0;

	   //Eq. (7)
	  a_CoefObj[6][Ind_v11] = &Coef_C11_h_i_1;
	  a_Static[6][Ind_v11] = -1.0;
	  a_CoefObj[6][Ind_i1ct] = 0;
	  a_Static[6][Ind_i1ct] = -1.0;
	  a_CoefObj[6][69] = &Coef_minus_v11_h_prev_minus_PlusBus_C11_i_1;
	  a_Static[6][69] = 1.0;

	   //Eq. (8)
	  a_CoefObj[7][Ind_v12] = &Coef_C12_h_i_1;
	  a_Static[7][Ind_v12] = 1.0;
	  a_CoefObj[7][Ind_i1cb] = 0;
	  a_Static[7][Ind_i1cb] = -1.0;
	  a_CoefObj[7][69] = &Coef_v12_h_prev_plus_PlusBus_C12_i_1;
	  a_Static[7][69] = 1.0;

	   //Eq. (9)
	  a_CoefObj[8][Ind_v12] = &Coef_recp_rSrD21_i_1;
	  a_Static[8][Ind_v12] = 1.0;
	  a_CoefObj[8][Ind_v21] = &Coef_recp_rSrD21_i_1;
	  a_Static[8][Ind_v21] = -1.0;
	  a_CoefObj[8][Ind_i2st] = 0;
	  a_Static[8][Ind_i2st] = -1.0;
	  a_CoefObj[8][69] = 0;
	  a_Static[8][69] = 0;

	  //Eq. (10)
	  a_CoefObj[9][Ind_v23] = &Coef_recp_rSrD22_i_1;
	  a_Static[9][Ind_v23] = 1.0;
	  a_CoefObj[9][Ind_v12] = &Coef_recp_rSrD22_i_1;
	  a_Static[9][Ind_v12] = -1.0;
	  a_CoefObj[9][Ind_i2sb] = 0;
	  a_Static[9][Ind_i2sb] = -1.0;
	  a_CoefObj[9][69] = 0;
	  a_Static[9][69] = 0;

	  //Eq. (11)
	  a_CoefObj[10][Ind_ipl] = 0;
	  a_Static[10][Ind_ipl] = 1.0;
	  a_CoefObj[10][Ind_i2_l] = 0;
	  a_Static[10][Ind_i2_l] = 1.0;
	  a_CoefObj[10][Ind_i2] = 0;
	  a_Static[10][Ind_i2] = -1.0;
	  a_CoefObj[10][69] = 0;
	  a_Static[10][69] = 0;

	  //Eq. (12)
	  a_CoefObj[11][Ind_i2st] = 0;
	  a_Static[11][Ind_i2st] = 1.0;
	  a_CoefObj[11][Ind_i2ct] = 0;
	  a_Static[11][Ind_i2ct] = 1.0;
	  a_CoefObj[11][Ind_i2] = 0;
	  a_Static[11][Ind_i2] = -1.0;
	  a_CoefObj[11][69] = 0;
	  a_Static[11][69] = 0;

	  //Eq. (13)
	  a_CoefObj[12][Ind_i2sb] = 0;
	  a_Static[12][Ind_i2sb] = 1.0;
	  a_CoefObj[12][Ind_i2cb] = 0;
	  a_Static[12][Ind_i2cb] = 1.0;
	  a_CoefObj[12][Ind_i2_l] = 0;
	  a_Static[12][Ind_i2_l] = -1.0;
	  a_CoefObj[12][69] = 0;
	  a_Static[12][69] = 0;


	  //Eq. (14)
	  a_CoefObj[13][Ind_v21] = &Coef_C2_h_i_1;
	  a_Static[13][Ind_v21] = 1.0;
	  a_CoefObj[13][Ind_v23] = &Coef_C2_h_i_1;
	  a_Static[13][Ind_v23] = -1.0;
	  a_CoefObj[13][Ind_i2] = 0;
	  a_Static[13][Ind_i2] = -1.0;
	  a_CoefObj[13][69] = &Coef_v21_v23_h_prev_C2_i_1;
	  a_Static[13][69] = 1.0;



	  //Eq. (15)
	  a_CoefObj[14][Ind_v12] = &Coef_C21_h_i_1;
	  a_Static[14][Ind_v12] = 1.0;
	  a_CoefObj[14][Ind_v21] = &Coef_C21_h_i_1;
	  a_Static[14][Ind_v21] = -1.0;
	  a_CoefObj[14][Ind_i2ct] = 0;
	  a_Static[14][Ind_i2ct] = -1.0;
	  a_CoefObj[14][69] = &Coef_v12_v21_h_prev_C21_i_1;
	  a_Static[14][69] = 1.0;


	  //Eq. (16)
	  a_CoefObj[15][Ind_v23] = &Coef_C22_h_i_1;
	  a_Static[15][Ind_v23] = 1.0;
	  a_CoefObj[15][Ind_v12] = &Coef_C22_h_i_1;
	  a_Static[15][Ind_v12] = -1.0;
	  a_CoefObj[15][Ind_i2cb] = 0;
	  a_Static[15][Ind_i2cb] = -1.0;
	  a_CoefObj[15][69] = &Coef_v23_v12_h_prev_C22_i_1;
	  a_Static[15][69] = 1.0;


	  //Eq. (17)
	  a_CoefObj[16][Ind_v23] = &Coef_recp_rSrD31_i_1;
	  a_Static[16][Ind_v23] = 1.0;
	  a_CoefObj[16][Ind_v31] = &Coef_recp_rSrD31_i_1;
	  a_Static[16][Ind_v31] = -1.0;
	  a_CoefObj[16][Ind_i3st] = 0;
	  a_Static[16][Ind_i3st] = -1.0;
	  a_CoefObj[16][69] = 0;
	  a_Static[16][69] = 0;

	  //Eq. (18)
	  a_CoefObj[17][Ind_v34] = &Coef_recp_rSrD32_i_1;
	  a_Static[17][Ind_v34] = 1.0;
	  a_CoefObj[17][Ind_v23] = &Coef_recp_rSrD32_i_1;
	  a_Static[17][Ind_v23] = -1.0;
	  a_CoefObj[17][Ind_i3sb] = 0;
	  a_Static[17][Ind_i3sb] = -1.0;
	  a_CoefObj[17][69] = 0;
	  a_Static[17][69] = 0;


	  //Eq. (19)
	  a_CoefObj[18][Ind_ipl] = 0;
	  a_Static[18][Ind_ipl] = 1.0;
	  a_CoefObj[18][Ind_i3_l] = 0;
	  a_Static[18][Ind_i3_l] = 1.0;
	  a_CoefObj[18][Ind_i3] = 0;
	  a_Static[18][Ind_i3] = -1.0;
	  a_CoefObj[18][69] = 0;
	  a_Static[18][69] = 0;


	  //Eq. (20)
	  a_CoefObj[19][Ind_i3st] = 0;
	  a_Static[19][Ind_i3st] = 1.0;
	  a_CoefObj[19][Ind_i3ct] = 0;
	  a_Static[19][Ind_i3ct] = 1.0;
	  a_CoefObj[19][Ind_i3] = 0;
	  a_Static[19][Ind_i3] = -1.0;
	  a_CoefObj[19][69] = 0;
	  a_Static[19][69] = 0;


	  //Eq. (21)
	  a_CoefObj[20][Ind_i3sb] = 0;
	  a_Static[20][Ind_i3sb] = 1.0;
	  a_CoefObj[20][Ind_i3cb] = 0;
	  a_Static[20][Ind_i3cb] = 1.0;
	  a_CoefObj[20][Ind_i3_l] = 0;
	  a_Static[20][Ind_i3_l] = -1.0;
	  a_CoefObj[20][69] = 0;
	  a_Static[20][69] = 0;


	   //Eq. (22)
	  a_CoefObj[21][Ind_v31] = &Coef_C3_h_i_1;
	  a_Static[21][Ind_v31] = 1.0;
	  a_CoefObj[21][Ind_v34] = &Coef_C3_h_i_1;
	  a_Static[21][Ind_v34] = -1.0;
	  a_CoefObj[21][Ind_i3] = 0;
	  a_Static[21][Ind_i3] = -1.0;
	  a_CoefObj[21][69] = &Coef_v31_v34_h_prev_C3_i_1;
	  a_Static[21][69] = 1.0;


	  //Eq. (23)
	  a_CoefObj[22][Ind_v23] = &Coef_C31_h_i_1;
	  a_Static[22][Ind_v23] = 1.0;
	  a_CoefObj[22][Ind_v31] = &Coef_C31_h_i_1;
	  a_Static[22][Ind_v31] = -1.0;
	  a_CoefObj[22][Ind_i3ct] = 0;
	  a_Static[22][Ind_i3ct] = -1.0;
	  a_CoefObj[22][69] = &Coef_v23_v31_h_prev_C31_i_1;
	  a_Static[22][69] = 1.0;


	  //Eq. (24)
	  a_CoefObj[23][Ind_v34] = &Coef_C32_h_i_1;
	  a_Static[23][Ind_v34] = 1.0;
	  a_CoefObj[23][Ind_v23] = &Coef_C32_h_i_1;
	  a_Static[23][Ind_v23] = -1.0;
	  a_CoefObj[23][Ind_i3cb] = 0;
	  a_Static[23][Ind_i3cb] = -1.0;
	  a_CoefObj[23][69] = &Coef_v34_v23_h_prev_C32_i_1;
	  a_Static[23][69] = 1.0;


	  //Eq. (25)
	  a_CoefObj[24][Ind_v34] = &Coef_recp_rSrD41_i_1;
	  a_Static[24][Ind_v34] = 1.0;
	  a_CoefObj[24][Ind_v41] = &Coef_recp_rSrD41_i_1;
	  a_Static[24][Ind_v41] = -1.0;
	  a_CoefObj[24][Ind_i4st] = 0;
	  a_Static[24][Ind_i4st] = -1.0;
	  a_CoefObj[24][69] = 0;
	  a_Static[24][69] = 0;

	  //Eq. (26)
	  a_CoefObj[25][Ind_v44] = &Coef_recp_rSrD42_i_1;
	  a_Static[25][Ind_v44] = 1.0;
	  a_CoefObj[25][Ind_v34] = &Coef_recp_rSrD42_i_1;
	  a_Static[25][Ind_v34] = -1.0;
	  a_CoefObj[25][Ind_i4sb] = 0;
	  a_Static[25][Ind_i4sb] = -1.0;
	  a_CoefObj[25][69] = 0;
	  a_Static[25][69] = 0;

	  //Eq. (27)
	  a_CoefObj[26][Ind_ipl] = 0;
	  a_Static[26][Ind_ipl] = 1.0;
	  a_CoefObj[26][Ind_i4_l] = 0;
	  a_Static[26][Ind_i4_l] = 1.0;
	  a_CoefObj[26][Ind_i4] = 0;
	  a_Static[26][Ind_i4] = -1.0;
	  a_CoefObj[26][69] = 0;
	  a_Static[26][69] = 0;


	  //Eq. (28)
	  a_CoefObj[27][Ind_i4st] = 0;
	  a_Static[27][Ind_i4st] = 1.0;
	  a_CoefObj[27][Ind_i4ct] = 0;
	  a_Static[27][Ind_i4ct] = 1.0;
	  a_CoefObj[27][Ind_i4] = 0;
	  a_Static[27][Ind_i4] = -1.0;
	  a_CoefObj[27][69] = 0;
	  a_Static[27][69] = 0;


	  //Eq. (29)
	  a_CoefObj[28][Ind_i4sb] = 0;
	  a_Static[28][Ind_i4sb] = 1.0;
	  a_CoefObj[28][Ind_i4cb] = 0;
	  a_Static[28][Ind_i4cb] = 1.0;
	  a_CoefObj[28][Ind_i4_l] = 0;
	  a_Static[28][Ind_i4_l] = -1.0;
	  a_CoefObj[28][69] = 0;
	  a_Static[28][69] = 0;


	  //Eq. (30)
	  a_CoefObj[29][Ind_v41] = &Coef_C4_h_i_1;
	  a_Static[29][Ind_v41] = 1.0;
	  a_CoefObj[29][Ind_v44] = &Coef_C4_h_i_1;
	  a_Static[29][Ind_v44] = -1.0;
	  a_CoefObj[29][Ind_i4] = 0;
	  a_Static[29][Ind_i4] = -1.0;
	  a_CoefObj[29][69] = &Coef_v41_v44_h_prev_C4_i_1;
	  a_Static[29][69] = 1.0;


	  //Eq. (31)
	  a_CoefObj[30][Ind_v34] = &Coef_C41_h_i_1;
	  a_Static[30][Ind_v34] = 1.0;
	  a_CoefObj[30][Ind_v41] = &Coef_C41_h_i_1;
	  a_Static[30][Ind_v41] = -1.0;
	  a_CoefObj[30][Ind_i4ct] = 0;
	  a_Static[30][Ind_i4ct] = -1.0;
	  a_CoefObj[30][69] = &Coef_v34_v41_h_prev_C41_i_1;
	  a_Static[30][69] = 1.0;


	  //Eq. (32)
	  a_CoefObj[31][Ind_v44] = &Coef_C42_h_i_1;
	  a_Static[31][Ind_v44] = 1.0;
	  a_CoefObj[31][Ind_v34] = &Coef_C42_h_i_1;
	  a_Static[31][Ind_v34] = -1.0;
	  a_CoefObj[31][Ind_i4cb] = 0;
	  a_Static[31][Ind_i4cb] = -1.0;
	  a_CoefObj[31][69] = &Coef_v44_v34_h_prev_C42_i_1;
	  a_Static[31][69] = 1.0;


	  //Eq. (33)
	  a_CoefObj[32][Ind_v44] = 0;
	  a_Static[32][Ind_v44] = RECEP_Rp;
	  a_CoefObj[32][Ind_vs_a] = 0;
	  a_Static[32][Ind_vs_a] = -RECEP_Rp;
	  a_CoefObj[32][Ind_iLp] = 0;
	  a_Static[32][Ind_iLp] = 1.0;
	  a_CoefObj[32][Ind_ipl] = 0;
	  a_Static[32][Ind_ipl] = -1.0;
	  a_CoefObj[32][69] = 0;
	  a_Static[32][69] = 0;

	  //Eq. (34)
	  a_CoefObj[33][Ind_v45] = 0;
	  a_Static[33][Ind_v45] = -RECEP_Rn;
	  a_CoefObj[33][Ind_vs_a] = 0;
	  a_Static[33][Ind_vs_a] = RECEP_Rn;
	  a_CoefObj[33][Ind_iLn] = 0;
	  a_Static[33][Ind_iLn] = 1.0;
	  a_CoefObj[33][Ind_inl] = 0;
	  a_Static[33][Ind_inl] = -1.0;
	  a_CoefObj[33][69] = 0;
	  a_Static[33][69] = 0;



	  //Eq. (35)
	  a_CoefObj[34][Ind_iLp] = &Coef_Lp_h_i_1;
	  a_Static[34][Ind_iLp] = 1.0;
	  a_CoefObj[34][Ind_iLn] = &Coef_Mpn_h_i_1;
	  a_Static[34][Ind_iLn] = 1.0;
	  a_CoefObj[34][Ind_v44] = 0;
	  a_Static[34][Ind_v44] = -1.0;
	  a_CoefObj[34][Ind_vs_a] = 0;
	  a_Static[34][Ind_vs_a] = 1.0;
	  a_CoefObj[34][69] = &Coef_iLp_iLn_h_prev_Lp_Mpn_i_1;
	  a_Static[34][69] = 1.0;


	  //Eq. (36)
	  a_CoefObj[35][Ind_iLp] = &Coef_Mnp_h_i_1;
	  a_Static[35][Ind_iLp] = 1.0;
	  a_CoefObj[35][Ind_iLn] = &Coef_Ln_h_i_1;
	  a_Static[35][Ind_iLn] = 1.0;
	  a_CoefObj[35][Ind_vs_a] = 0;
	  a_Static[35][Ind_vs_a] = -1.0;
	  a_CoefObj[35][Ind_v45] = 0;
	  a_Static[35][Ind_v45] = 1.0;
	  a_CoefObj[35][69] = &Coef_iLp_iLn_h_prev_Mnp_Ln_i_1;
	  a_Static[35][69] = 1.0;


	  //Eq. (37)
	  a_CoefObj[36][Ind_ipl] = 0;
	  a_Static[36][Ind_ipl] = 1.0;
	  a_CoefObj[36][Ind_inl] = 0;
	  a_Static[36][Ind_inl] = -1.0;
	  a_CoefObj[36][69] = &Coef_ia_i_1;
	  a_Static[36][69] = 1.0;



	  //Eq. (38)
	  a_CoefObj[37][Ind_v45] = &Coef_recp_rSrD51_i_1;
	  a_Static[37][Ind_v45] = 1.0;
	  a_CoefObj[37][Ind_v51] = &Coef_recp_rSrD51_i_1;
	  a_Static[37][Ind_v51] = -1.0;
	  a_CoefObj[37][Ind_i5st] = 0;
	  a_Static[37][Ind_i5st] = -1.0;
	  a_CoefObj[37][69] = 0;
	  a_Static[37][69] = 0;


	  //Eq. (39)
	  a_CoefObj[38][Ind_v56] = &Coef_recp_rSrD52_i_1;
	  a_Static[38][Ind_v56] = 1.0;
	  a_CoefObj[38][Ind_v45] = &Coef_recp_rSrD52_i_1;
	  a_Static[38][Ind_v45] = -1.0;
	  a_CoefObj[38][Ind_i5sb] = 0;
	  a_Static[38][Ind_i5sb] = -1.0;
	  a_CoefObj[38][69] = 0;
	  a_Static[38][69] = 0;

	  //Eq. (40)
	  a_CoefObj[39][Ind_inl] = 0;
	  a_Static[39][Ind_inl] = 1.0;
	  a_CoefObj[39][Ind_i5_l] = 0;
	  a_Static[39][Ind_i5_l] = 1.0;
	  a_CoefObj[39][Ind_i5] = 0;
	  a_Static[39][Ind_i5] = -1.0;
	  a_CoefObj[39][69] = 0;
	  a_Static[39][69] = 0;

	  //Eq. (41)
	  a_CoefObj[40][Ind_i5st] = 0;
	  a_Static[40][Ind_i5st] = 1.0;
	  a_CoefObj[40][Ind_i5ct] = 0;
	  a_Static[40][Ind_i5ct] = 1.0;
	  a_CoefObj[40][Ind_i5] = 0;
	  a_Static[40][Ind_i5] = -1.0;
	  a_CoefObj[40][69] = 0;
	  a_Static[40][69] = 0;


	  //Eq. (42)
	  a_CoefObj[41][Ind_i5sb] = 0;
	  a_Static[41][Ind_i5sb] = 1.0;
	  a_CoefObj[41][Ind_i5cb] = 0;
	  a_Static[41][Ind_i5cb] = 1.0;
	  a_CoefObj[41][Ind_i5_l] = 0;
	  a_Static[41][Ind_i5_l] = -1.0;
	  a_CoefObj[41][69] = 0;
	  a_Static[41][69] = 0;


	  //Eq. (43)
	  a_CoefObj[42][Ind_v51] = &Coef_C5_h_i_1;
	  a_Static[42][Ind_v51] = 1.0;
	  a_CoefObj[42][Ind_v56] = &Coef_C5_h_i_1;
	  a_Static[42][Ind_v56] = -1.0;
	  a_CoefObj[42][Ind_i5] = 0;
	  a_Static[42][Ind_i5] = -1.0;
	  a_CoefObj[42][69] = &Coef_v51_v56_h_prev_C5_i_1;
	  a_Static[42][69] = 1.0;


	  //Eq. (44)
	  a_CoefObj[43][Ind_v45] = &Coef_C51_h_i_1;
	  a_Static[43][Ind_v45] = 1.0;
	  a_CoefObj[43][Ind_v51] = &Coef_C51_h_i_1;
	  a_Static[43][Ind_v51] = -1.0;
	  a_CoefObj[43][Ind_i5ct] = 0;
	  a_Static[43][Ind_i5ct] = -1.0;
	  a_CoefObj[43][69] = &Coef_v45_v51_h_prev_C51_i_1;
	  a_Static[43][69] = 1.0;


	  //Eq. (45)
	  a_CoefObj[44][Ind_v56] = &Coef_C52_h_i_1;
	  a_Static[44][Ind_v56] = 1.0;
	  a_CoefObj[44][Ind_v45] = &Coef_C52_h_i_1;
	  a_Static[44][Ind_v45] = -1.0;
	  a_CoefObj[44][Ind_i5cb] = 0;
	  a_Static[44][Ind_i5cb] = -1.0;
	  a_CoefObj[44][69] = &Coef_v56_v45_h_prev_C52_i_1;
	  a_Static[44][69] = 1.0;



	  //Eq. (46)
	  a_CoefObj[45][Ind_v56] = &Coef_recp_rSrD61_i_1;
	  a_Static[45][Ind_v56] = 1.0;
	  a_CoefObj[45][Ind_v61] = &Coef_recp_rSrD61_i_1;
	  a_Static[45][Ind_v61] = -1.0;
	  a_CoefObj[45][Ind_i6st] = 0;
	  a_Static[45][Ind_i6st] = -1.0;
	  a_CoefObj[45][69] = 0;
	  a_Static[45][69] = 0;

	  //Eq. (47)
	  a_CoefObj[46][Ind_v67] = &Coef_recp_rSrD62_i_1;
	  a_Static[46][Ind_v67] = 1.0;
	  a_CoefObj[46][Ind_v56] = &Coef_recp_rSrD62_i_1;
	  a_Static[46][Ind_v56] = -1.0;
	  a_CoefObj[46][Ind_i6sb] = 0;
	  a_Static[46][Ind_i6sb] = -1.0;
	  a_CoefObj[46][69] = 0;
	  a_Static[46][69] = 0;

	  //Eq. (48)
	  a_CoefObj[47][Ind_inl] = 0;
	  a_Static[47][Ind_inl] = 1.0;
	  a_CoefObj[47][Ind_i6_l] = 0;
	  a_Static[47][Ind_i6_l] = 1.0;
	  a_CoefObj[47][Ind_i6] = 0;
	  a_Static[47][Ind_i6] = -1.0;
	  a_CoefObj[47][69] = 0;
	  a_Static[47][69] = 0;

	  //Eq. (49)
	  a_CoefObj[48][Ind_i6st] = 0;
	  a_Static[48][Ind_i6st] = 1.0;
	  a_CoefObj[48][Ind_i6ct] = 0;
	  a_Static[48][Ind_i6ct] = 1.0;
	  a_CoefObj[48][Ind_i6] = 0;
	  a_Static[48][Ind_i6] = -1.0;
	  a_CoefObj[48][69] = 0;
	  a_Static[48][69] = 0;


	  //Eq. (50)
	  a_CoefObj[49][Ind_i6sb] = 0;
	  a_Static[49][Ind_i6sb] = 1.0;
	  a_CoefObj[49][Ind_i6cb] = 0;
	  a_Static[49][Ind_i6cb] = 1.0;
	  a_CoefObj[49][Ind_i6_l] = 0;
	  a_Static[49][Ind_i6_l] = -1.0;
	  a_CoefObj[49][69] = 0;
	  a_Static[49][69] = 0;


	  //Eq. (51)
	  a_CoefObj[50][Ind_v61] =  &Coef_C6_h_i_1;
	  a_Static[50][Ind_v61] = 1.0;
	  a_CoefObj[50][Ind_v67] =  &Coef_C6_h_i_1;
	  a_Static[50][Ind_v67] = -1.0;
	  a_CoefObj[50][Ind_i6] = 0;
	  a_Static[50][Ind_i6] = -1.0;
	  a_CoefObj[50][69] = &Coef_v61_v67_h_prev_C6_i_1;
	  a_Static[50][69] = 1.0;

	  //Eq. (52)
	  a_CoefObj[51][Ind_v56] = &Coef_C61_h_i_1;
	  a_Static[51][Ind_v56] = 1.0;
	  a_CoefObj[51][Ind_v61] = &Coef_C61_h_i_1;
	  a_Static[51][Ind_v61] = -1.0;
	  a_CoefObj[51][Ind_i6ct] = 0;
	  a_Static[51][Ind_i6ct] = -1.0;
	  a_CoefObj[51][69] = &Coef_v56_v61_h_prev_C61_i_1;
	  a_Static[51][69] = 1.0;


	  //Eq. (53)
	  a_CoefObj[52][Ind_v67] = &Coef_C62_h_i_1;
	  a_Static[52][Ind_v67] = 1.0;
	  a_CoefObj[52][Ind_v56] = &Coef_C62_h_i_1;
	  a_Static[52][Ind_v56] = -1.0;
	  a_CoefObj[52][Ind_i6cb] = 0;
	  a_Static[52][Ind_i6cb] = -1.0;
	  a_CoefObj[52][69] = &Coef_v67_v56_h_prev_C62_i_1;
	  a_Static[52][69] = 1.0;


	  //Eq. (54)
	  a_CoefObj[53][Ind_v67] = &Coef_recp_rSrD71_i_1;
	  a_Static[53][Ind_v67] = 1.0;
	  a_CoefObj[53][Ind_v71] = &Coef_recp_rSrD71_i_1;
	  a_Static[53][Ind_v71] = -1.0;
	  a_CoefObj[53][Ind_i7st] = 0;
	  a_Static[53][Ind_i7st] = -1.0;
	  a_CoefObj[53][69] = 0;
	  a_Static[53][69] = 0;

	  //Eq. (55)
	  a_CoefObj[54][Ind_v78] = &Coef_recp_rSrD72_i_1;
	  a_Static[54][Ind_v78] = 1.0;
	  a_CoefObj[54][Ind_v67] = &Coef_recp_rSrD72_i_1;
	  a_Static[54][Ind_v67] = -1.0;
	  a_CoefObj[54][Ind_i7sb] = 0;
	  a_Static[54][Ind_i7sb] = -1.0;
	  a_CoefObj[54][69] = 0;
	  a_Static[54][69] = 0;

	  //Eq. (56)
	  a_CoefObj[55][Ind_inl] = 0;
	  a_Static[55][Ind_inl] = 1.0;
	  a_CoefObj[55][Ind_i7_l] = 0;
	  a_Static[55][Ind_i7_l] = 1.0;
	  a_CoefObj[55][Ind_i7] = 0;
	  a_Static[55][Ind_i7] = -1.0;
	  a_CoefObj[55][69] = 0;
	  a_Static[55][69] = 0;

	  //Eq. (57)
	  a_CoefObj[56][Ind_i7st] = 0;
	  a_Static[56][Ind_i7st] = 1.0;
	  a_CoefObj[56][Ind_i7ct] = 0;
	  a_Static[56][Ind_i7ct] = 1.0;
	  a_CoefObj[56][Ind_i7] = 0;
	  a_Static[56][Ind_i7] = -1.0;
	  a_CoefObj[56][69] = 0;
	  a_Static[56][69] = 0;


	  //Eq. (58)
	  a_CoefObj[57][Ind_i7sb] = 0;
	  a_Static[57][Ind_i7sb] = 1.0;
	  a_CoefObj[57][Ind_i7cb] = 0;
	  a_Static[57][Ind_i7cb] = 1.0;
	  a_CoefObj[57][Ind_i7_l] = 0;
	  a_Static[57][Ind_i7_l] = -1.0;
	  a_CoefObj[57][69] = 0;
	  a_Static[57][69] = 0;


	  //Eq. (59)
	  a_CoefObj[58][Ind_v71] = &Coef_C7_h_i_1;
	  a_Static[58][Ind_v71] = 1.0;
	  a_CoefObj[58][Ind_v78] = &Coef_C7_h_i_1;
	  a_Static[58][Ind_v78] = -1.0;
	  a_CoefObj[58][Ind_i7] = 0;
	  a_Static[58][Ind_i7] = -1.0;
	  a_CoefObj[58][69] = &Coef_v71_v78_h_prev_C7_i_1;
	  a_Static[58][69] = 1.0;

	  //Eq. (60)
	  a_CoefObj[59][Ind_v67] = &Coef_C71_h_i_1;
	  a_Static[59][Ind_v67] = 1.0;
	  a_CoefObj[59][Ind_v71] = &Coef_C71_h_i_1;
	  a_Static[59][Ind_v71] = -1.0;
	  a_CoefObj[59][Ind_i7ct] = 0;
	  a_Static[59][Ind_i7ct] = -1.0;
	  a_CoefObj[59][69] = &Coef_v67_v71_h_prev_C71_i_1;
	  a_Static[59][69] = 1.0;


	  //Eq. (61)
	  a_CoefObj[60][Ind_v78] = &Coef_C72_h_i_1;
	  a_Static[60][Ind_v78] = 1.0;
	  a_CoefObj[60][Ind_v67] = &Coef_C72_h_i_1;
	  a_Static[60][Ind_v67] = -1.0;
	  a_CoefObj[60][Ind_i7cb] = 0;
	  a_Static[60][Ind_i7cb] = -1.0;
	  a_CoefObj[60][69] = &Coef_v78_v67_h_prev_C72_i_1;
	  a_Static[60][69] = 1.0;


	  //Eq. (62)
	  a_CoefObj[61][Ind_v78] = &Coef_recp_rSrD81_i_1;
	  a_Static[61][Ind_v78] = 1.0;
	  a_CoefObj[61][Ind_v81] = &Coef_recp_rSrD81_i_1;
	  a_Static[61][Ind_v81] = -1.0;
	  a_CoefObj[61][Ind_i8st] = 0;
	  a_Static[61][Ind_i8st] = -1.0;
	  a_CoefObj[61][69] = 0;
	  a_Static[61][69] = 0;


	  //Eq. (63)
	  a_CoefObj[62][Ind_v78] = &Coef_recp_rSrD82_i_1;
	  a_Static[62][Ind_v78] = -1.0;
	  a_CoefObj[62][Ind_i8sb] = 0;
	  a_Static[62][Ind_i8sb] = -1.0;
	  a_CoefObj[62][69] = &Coef_recp_rSrD82_i_1;
	  a_Static[62][69] = - MINUS_DC_BUS_VOLTAGE;

	  //Eq. (64)
	  a_CoefObj[63][Ind_inl] = 0;
	  a_Static[63][Ind_inl] = 1.0;
	  a_CoefObj[63][Ind_i8_l] = 0;
	  a_Static[63][Ind_i8_l] = 1.0;
	  a_CoefObj[63][Ind_i8] = 0;
	  a_Static[63][Ind_i8] = -1.0;
	  a_CoefObj[63][69] = 0;
	  a_Static[63][69] = 0;

	  //Eq. (65)
	  a_CoefObj[64][Ind_i8st] = 0;
	  a_Static[64][Ind_i8st] = 1.0;
	  a_CoefObj[64][Ind_i8ct] = 0;
	  a_Static[64][Ind_i8ct] = 1.0;
	  a_CoefObj[64][Ind_i8] = 0;
	  a_Static[64][Ind_i8] = -1.0;
	  a_CoefObj[64][69] = 0;
	  a_Static[64][69] = 0;


	  //Eq. (66)
	  a_CoefObj[65][Ind_i8sb] = 0;
	  a_Static[65][Ind_i8sb] = 1.0;
	  a_CoefObj[65][Ind_i8cb] = 0;
	  a_Static[65][Ind_i8cb] = 1.0;
	  a_CoefObj[65][Ind_i8_l] = 0;
	  a_Static[65][Ind_i8_l] = -1.0;
	  a_CoefObj[65][69] = 0;
	  a_Static[65][69] = 0;



	  //Eq. (67)
	  a_CoefObj[66][Ind_v81] = &Coef_C8_h_i_1;
	  a_Static[66][Ind_v81] = 1.0;
	  a_CoefObj[66][Ind_i8] = 0;
	  a_Static[66][Ind_i8] = -1.0;
	  a_CoefObj[66][69] = &Coef_v81_h_prev_plus_MinusBus_C8_i_1;
	  a_Static[66][69] = 1.0;

	  //Eq. (68)
	  a_CoefObj[67][Ind_v78] = &Coef_C81_h_i_1;
	  a_Static[67][Ind_v78] = 1.0;
	  a_CoefObj[67][Ind_v81] = &Coef_C81_h_i_1;
	  a_Static[67][Ind_v81] = -1.0;
	  a_CoefObj[67][Ind_i8ct] = 0;
	  a_Static[67][Ind_i8ct] = -1.0;
	  a_CoefObj[67][69] = &Coef_v78_v81_h_prev_C81_i_1;
	  a_Static[67][69] = 1.0;

	  //Eq. (69)
	  a_CoefObj[68][Ind_v78] = &Coef_C82_h_i_1;
	  a_Static[68][Ind_v78] = -1.0;
	  a_CoefObj[68][Ind_i8cb] = 0;
	  a_Static[68][Ind_i8cb] = -1.0;
	  a_CoefObj[68][69] = &Coef_minus_v78_h_prev_minus_MinusBus_C82_i_1;
	  a_Static[68][69] = 1.0;


  }
  else
  {
	  //Eq. (1)
	  a_CoefObj[0][Ind_v11] = &Coef_recp_rSrD11_i_2;
	  a_Static[0][Ind_v11] = -1.0;
	  a_CoefObj[0][Ind_i1st] = 0;
	  a_Static[0][Ind_i1st] = -1.0;
	  a_CoefObj[0][69] = &Coef_recp_rSrD11_i_2;
	  a_Static[0][69] = -PLUS_DC_BUS_VOLTAGE;

	  //Eq. (2)
	  a_CoefObj[1][Ind_v12] = &Coef_recp_rSrD12_i_2;
	  a_Static[1][Ind_v12] = 1.0;
	  a_CoefObj[1][Ind_i1sb] = 0;
	  a_Static[1][Ind_i1sb] = -1.0;
	  a_CoefObj[1][69] = &Coef_recp_rSrD12_i_2;
	  a_Static[1][69] = PLUS_DC_BUS_VOLTAGE;

	  //Eq. (3)
	  a_CoefObj[2][Ind_ipl] = 0;
	  a_Static[2][Ind_ipl] = 1.0;
	  a_CoefObj[2][Ind_i1_l] = 0;
	  a_Static[2][Ind_i1_l] = 1.0;
	  a_CoefObj[2][Ind_i1] = 0;
	  a_Static[2][Ind_i1] = -1.0;
	  a_CoefObj[2][69] = 0;
	  a_Static[2][69] = 0;

	  //Eq. (4)
	  a_CoefObj[3][Ind_i1st] = 0;
	  a_Static[3][Ind_i1st] = 1.0;
	  a_CoefObj[3][Ind_i1ct] = 0;
	  a_Static[3][Ind_i1ct] = 1.0;
	  a_CoefObj[3][Ind_i1] = 0;
	  a_Static[3][Ind_i1] = -1.0;
	  a_CoefObj[3][69] = 0;
	  a_Static[3][69] = 0;

	  //Eq. (5)
	  a_CoefObj[4][Ind_i1sb] = 0;
	  a_Static[4][Ind_i1sb] = 1.0;
	  a_CoefObj[4][Ind_i1cb] = 0;
	  a_Static[4][Ind_i1cb] = 1.0;
	  a_CoefObj[4][Ind_i1_l] = 0;
	  a_Static[4][Ind_i1_l] = -1.0;
	  a_CoefObj[4][69] = 0;
	  a_Static[4][69] = 0;

	   //Eq. (6)
	  a_CoefObj[5][Ind_v11] = &Coef_C1_h_i_2;
	  a_Static[5][Ind_v11] = 1.0;
	  a_CoefObj[5][Ind_v12] = &Coef_C1_h_i_1;
	  a_Static[5][Ind_v12] = -1.0;
	  a_CoefObj[5][Ind_i1] = 0;
	  a_Static[5][Ind_i1] = -1.0;
	  a_CoefObj[5][69] = &Coef_v11_v12_h_prev_C1_i_2;
	  a_Static[5][69] = 1.0;

	   //Eq. (7)
	  a_CoefObj[6][Ind_v11] = &Coef_C11_h_i_2;
	  a_Static[6][Ind_v11] = -1.0;
	  a_CoefObj[6][Ind_i1ct] = 0;
	  a_Static[6][Ind_i1ct] = -1.0;
	  a_CoefObj[6][69] = &Coef_minus_v11_h_prev_minus_PlusBus_C11_i_2;
	  a_Static[6][69] = 1.0;

	   //Eq. (8)
	  a_CoefObj[7][Ind_v12] = &Coef_C12_h_i_2;
	  a_Static[7][Ind_v12] = 1.0;
	  a_CoefObj[7][Ind_i1cb] = 0;
	  a_Static[7][Ind_i1cb] = -1.0;
	  a_CoefObj[7][69] = &Coef_v12_h_prev_plus_PlusBus_C12_i_2;
	  a_Static[7][69] = 1.0;

	   //Eq. (9)
	  a_CoefObj[8][Ind_v12] = &Coef_recp_rSrD21_i_2;
	  a_Static[8][Ind_v12] = 1.0;
	  a_CoefObj[8][Ind_v21] = &Coef_recp_rSrD21_i_2;
	  a_Static[8][Ind_v21] = -1.0;
	  a_CoefObj[8][Ind_i2st] = 0;
	  a_Static[8][Ind_i2st] = -1.0;
	  a_CoefObj[8][69] = 0;
	  a_Static[8][69] = 0;

	  //Eq. (10)
	  a_CoefObj[9][Ind_v23] = &Coef_recp_rSrD22_i_2;
	  a_Static[9][Ind_v23] = 1.0;
	  a_CoefObj[9][Ind_v12] = &Coef_recp_rSrD22_i_2;
	  a_Static[9][Ind_v12] = -1.0;
	  a_CoefObj[9][Ind_i2sb] = 0;
	  a_Static[9][Ind_i2sb] = -1.0;
	  a_CoefObj[9][69] = 0;
	  a_Static[9][69] = 0;

	  //Eq. (11)
	  a_CoefObj[10][Ind_ipl] = 0;
	  a_Static[10][Ind_ipl] = 1.0;
	  a_CoefObj[10][Ind_i2_l] = 0;
	  a_Static[10][Ind_i2_l] = 1.0;
	  a_CoefObj[10][Ind_i2] = 0;
	  a_Static[10][Ind_i2] = -1.0;
	  a_CoefObj[10][69] = 0;
	  a_Static[10][69] = 0;

	  //Eq. (12)
	  a_CoefObj[11][Ind_i2st] = 0;
	  a_Static[11][Ind_i2st] = 1.0;
	  a_CoefObj[11][Ind_i2ct] = 0;
	  a_Static[11][Ind_i2ct] = 1.0;
	  a_CoefObj[11][Ind_i2] = 0;
	  a_Static[11][Ind_i2] = -1.0;
	  a_CoefObj[11][69] = 0;
	  a_Static[11][69] = 0;

	  //Eq. (13)
	  a_CoefObj[12][Ind_i2sb] = 0;
	  a_Static[12][Ind_i2sb] = 1.0;
	  a_CoefObj[12][Ind_i2cb] = 0;
	  a_Static[12][Ind_i2cb] = 1.0;
	  a_CoefObj[12][Ind_i2_l] = 0;
	  a_Static[12][Ind_i2_l] = -1.0;
	  a_CoefObj[12][69] = 0;
	  a_Static[12][69] = 0;


	  //Eq. (14)
	  a_CoefObj[13][Ind_v21] = &Coef_C2_h_i_2;
	  a_Static[13][Ind_v21] = 1.0;
	  a_CoefObj[13][Ind_v23] = &Coef_C2_h_i_2;
	  a_Static[13][Ind_v23] = -1.0;
	  a_CoefObj[13][Ind_i2] = 0;
	  a_Static[13][Ind_i2] = -1.0;
	  a_CoefObj[13][69] = &Coef_v21_v23_h_prev_C2_i_2;
	  a_Static[13][69] = 1.0;



	  //Eq. (15)
	  a_CoefObj[14][Ind_v12] = &Coef_C21_h_i_2;
	  a_Static[14][Ind_v12] = 1.0;
	  a_CoefObj[14][Ind_v21] = &Coef_C21_h_i_2;
	  a_Static[14][Ind_v21] = -1.0;
	  a_CoefObj[14][Ind_i2ct] = 0;
	  a_Static[14][Ind_i2ct] = -1.0;
	  a_CoefObj[14][69] = &Coef_v12_v21_h_prev_C21_i_2;
	  a_Static[14][69] = 1.0;


	  //Eq. (16)
	  a_CoefObj[15][Ind_v23] = &Coef_C22_h_i_2;
	  a_Static[15][Ind_v23] = 1.0;
	  a_CoefObj[15][Ind_v12] = &Coef_C22_h_i_2;
	  a_Static[15][Ind_v12] = -1.0;
	  a_CoefObj[15][Ind_i2cb] = 0;
	  a_Static[15][Ind_i2cb] = -1.0;
	  a_CoefObj[15][69] = &Coef_v23_v12_h_prev_C22_i_2;
	  a_Static[15][69] = 1.0;


	  //Eq. (17)
	  a_CoefObj[16][Ind_v23] = &Coef_recp_rSrD31_i_2;
	  a_Static[16][Ind_v23] = 1.0;
	  a_CoefObj[16][Ind_v31] = &Coef_recp_rSrD31_i_2;
	  a_Static[16][Ind_v31] = -1.0;
	  a_CoefObj[16][Ind_i3st] = 0;
	  a_Static[16][Ind_i3st] = -1.0;
	  a_CoefObj[16][69] = 0;
	  a_Static[16][69] = 0;

	  //Eq. (18)
	  a_CoefObj[17][Ind_v34] = &Coef_recp_rSrD32_i_2;
	  a_Static[17][Ind_v34] = 1.0;
	  a_CoefObj[17][Ind_v23] = &Coef_recp_rSrD32_i_2;
	  a_Static[17][Ind_v23] = -1.0;
	  a_CoefObj[17][Ind_i3sb] = 0;
	  a_Static[17][Ind_i3sb] = -1.0;
	  a_CoefObj[17][69] = 0;
	  a_Static[17][69] = 0;


	  //Eq. (19)
	  a_CoefObj[18][Ind_ipl] = 0;
	  a_Static[18][Ind_ipl] = 1.0;
	  a_CoefObj[18][Ind_i3_l] = 0;
	  a_Static[18][Ind_i3_l] = 1.0;
	  a_CoefObj[18][Ind_i3] = 0;
	  a_Static[18][Ind_i3] = -1.0;
	  a_CoefObj[18][69] = 0;
	  a_Static[18][69] = 0;


	  //Eq. (20)
	  a_CoefObj[19][Ind_i3st] = 0;
	  a_Static[19][Ind_i3st] = 1.0;
	  a_CoefObj[19][Ind_i3ct] = 0;
	  a_Static[19][Ind_i3ct] = 1.0;
	  a_CoefObj[19][Ind_i3] = 0;
	  a_Static[19][Ind_i3] = -1.0;
	  a_CoefObj[19][69] = 0;
	  a_Static[19][69] = 0;


	  //Eq. (21)
	  a_CoefObj[20][Ind_i3sb] = 0;
	  a_Static[20][Ind_i3sb] = 1.0;
	  a_CoefObj[20][Ind_i3cb] = 0;
	  a_Static[20][Ind_i3cb] = 1.0;
	  a_CoefObj[20][Ind_i3_l] = 0;
	  a_Static[20][Ind_i3_l] = -1.0;
	  a_CoefObj[20][69] = 0;
	  a_Static[20][69] = 0;


	   //Eq. (22)
	  a_CoefObj[21][Ind_v31] = &Coef_C3_h_i_2;
	  a_Static[21][Ind_v31] = 1.0;
	  a_CoefObj[21][Ind_v34] = &Coef_C3_h_i_2;
	  a_Static[21][Ind_v34] = -1.0;
	  a_CoefObj[21][Ind_i3] = 0;
	  a_Static[21][Ind_i3] = -1.0;
	  a_CoefObj[21][69] = &Coef_v31_v34_h_prev_C3_i_2;
	  a_Static[21][69] = 1.0;


	  //Eq. (23)
	  a_CoefObj[22][Ind_v23] = &Coef_C31_h_i_2;
	  a_Static[22][Ind_v23] = 1.0;
	  a_CoefObj[22][Ind_v31] = &Coef_C31_h_i_2;
	  a_Static[22][Ind_v31] = -1.0;
	  a_CoefObj[22][Ind_i3ct] = 0;
	  a_Static[22][Ind_i3ct] = -1.0;
	  a_CoefObj[22][69] = &Coef_v23_v31_h_prev_C31_i_2;
	  a_Static[22][69] = 1.0;


	  //Eq. (24)
	  a_CoefObj[23][Ind_v34] = &Coef_C32_h_i_2;
	  a_Static[23][Ind_v34] = 1.0;
	  a_CoefObj[23][Ind_v23] = &Coef_C32_h_i_2;
	  a_Static[23][Ind_v23] = -1.0;
	  a_CoefObj[23][Ind_i3cb] = 0;
	  a_Static[23][Ind_i3cb] = -1.0;
	  a_CoefObj[23][69] = &Coef_v34_v23_h_prev_C32_i_2;
	  a_Static[23][69] = 1.0;


	  //Eq. (25)
	  a_CoefObj[24][Ind_v34] = &Coef_recp_rSrD41_i_2;
	  a_Static[24][Ind_v34] = 1.0;
	  a_CoefObj[24][Ind_v41] = &Coef_recp_rSrD41_i_2;
	  a_Static[24][Ind_v41] = -1.0;
	  a_CoefObj[24][Ind_i4st] = 0;
	  a_Static[24][Ind_i4st] = -1.0;
	  a_CoefObj[24][69] = 0;
	  a_Static[24][69] = 0;

	  //Eq. (26)
	  a_CoefObj[25][Ind_v44] = &Coef_recp_rSrD42_i_2;
	  a_Static[25][Ind_v44] = 1.0;
	  a_CoefObj[25][Ind_v34] = &Coef_recp_rSrD42_i_2;
	  a_Static[25][Ind_v34] = -1.0;
	  a_CoefObj[25][Ind_i4sb] = 0;
	  a_Static[25][Ind_i4sb] = -1.0;
	  a_CoefObj[25][69] = 0;
	  a_Static[25][69] = 0;

	  //Eq. (27)
	  a_CoefObj[26][Ind_ipl] = 0;
	  a_Static[26][Ind_ipl] = 1.0;
	  a_CoefObj[26][Ind_i4_l] = 0;
	  a_Static[26][Ind_i4_l] = 1.0;
	  a_CoefObj[26][Ind_i4] = 0;
	  a_Static[26][Ind_i4] = -1.0;
	  a_CoefObj[26][69] = 0;
	  a_Static[26][69] = 0;


	  //Eq. (28)
	  a_CoefObj[27][Ind_i4st] = 0;
	  a_Static[27][Ind_i4st] = 1.0;
	  a_CoefObj[27][Ind_i4ct] = 0;
	  a_Static[27][Ind_i4ct] = 1.0;
	  a_CoefObj[27][Ind_i4] = 0;
	  a_Static[27][Ind_i4] = -1.0;
	  a_CoefObj[27][69] = 0;
	  a_Static[27][69] = 0;


	  //Eq. (29)
	  a_CoefObj[28][Ind_i4sb] = 0;
	  a_Static[28][Ind_i4sb] = 1.0;
	  a_CoefObj[28][Ind_i4cb] = 0;
	  a_Static[28][Ind_i4cb] = 1.0;
	  a_CoefObj[28][Ind_i4_l] = 0;
	  a_Static[28][Ind_i4_l] = -1.0;
	  a_CoefObj[28][69] = 0;
	  a_Static[28][69] = 0;


	  //Eq. (30)
	  a_CoefObj[29][Ind_v41] = &Coef_C4_h_i_2;
	  a_Static[29][Ind_v41] = 1.0;
	  a_CoefObj[29][Ind_v44] = &Coef_C4_h_i_2;
	  a_Static[29][Ind_v44] = -1.0;
	  a_CoefObj[29][Ind_i4] = 0;
	  a_Static[29][Ind_i4] = -1.0;
	  a_CoefObj[29][69] = &Coef_v41_v44_h_prev_C4_i_2;
	  a_Static[29][69] = 1.0;


	  //Eq. (31)
	  a_CoefObj[30][Ind_v34] = &Coef_C41_h_i_2;
	  a_Static[30][Ind_v34] = 1.0;
	  a_CoefObj[30][Ind_v41] = &Coef_C41_h_i_2;
	  a_Static[30][Ind_v41] = -1.0;
	  a_CoefObj[30][Ind_i4ct] = 0;
	  a_Static[30][Ind_i4ct] = -1.0;
	  a_CoefObj[30][69] = &Coef_v34_v41_h_prev_C41_i_2;
	  a_Static[30][69] = 1.0;


	  //Eq. (32)
	  a_CoefObj[31][Ind_v44] = &Coef_C42_h_i_2;
	  a_Static[31][Ind_v44] = 1.0;
	  a_CoefObj[31][Ind_v34] = &Coef_C42_h_i_2;
	  a_Static[31][Ind_v34] = -1.0;
	  a_CoefObj[31][Ind_i4cb] = 0;
	  a_Static[31][Ind_i4cb] = -1.0;
	  a_CoefObj[31][69] = &Coef_v44_v34_h_prev_C42_i_2;
	  a_Static[31][69] = 1.0;


	  //Eq. (33)
	  a_CoefObj[32][Ind_v44] = 0;
	  a_Static[32][Ind_v44] = RECEP_Rp;
	  a_CoefObj[32][Ind_vs_a] = 0;
	  a_Static[32][Ind_vs_a] = -RECEP_Rp;
	  a_CoefObj[32][Ind_iLp] = 0;
	  a_Static[32][Ind_iLp] = 1.0;
	  a_CoefObj[32][Ind_ipl] = 0;
	  a_Static[32][Ind_ipl] = -1.0;
	  a_CoefObj[32][69] = 0;
	  a_Static[32][69] = 0;

	  //Eq. (34)
	  a_CoefObj[33][Ind_v45] = 0;
	  a_Static[33][Ind_v45] = -RECEP_Rn;
	  a_CoefObj[33][Ind_vs_a] = 0;
	  a_Static[33][Ind_vs_a] = RECEP_Rn;
	  a_CoefObj[33][Ind_iLn] = 0;
	  a_Static[33][Ind_iLn] = 1.0;
	  a_CoefObj[33][Ind_inl] = 0;
	  a_Static[33][Ind_inl] = -1.0;
	  a_CoefObj[33][69] = 0;
	  a_Static[33][69] = 0;



	  //Eq. (35)
	  a_CoefObj[34][Ind_iLp] = &Coef_Lp_h_i_2;
	  a_Static[34][Ind_iLp] = 1.0;
	  a_CoefObj[34][Ind_iLn] = &Coef_Mpn_h_i_2;
	  a_Static[34][Ind_iLn] = 1.0;
	  a_CoefObj[34][Ind_v44] = 0;
	  a_Static[34][Ind_v44] = -1.0;
	  a_CoefObj[34][Ind_vs_a] = 0;
	  a_Static[34][Ind_vs_a] = 1.0;
	  a_CoefObj[34][69] = &Coef_iLp_iLn_h_prev_Lp_Mpn_i_2;
	  a_Static[34][69] = 1.0;


	  //Eq. (36)
	  a_CoefObj[35][Ind_iLp] = &Coef_Mnp_h_i_2;
	  a_Static[35][Ind_iLp] = 1.0;
	  a_CoefObj[35][Ind_iLn] = &Coef_Ln_h_i_2;
	  a_Static[35][Ind_iLn] = 1.0;
	  a_CoefObj[35][Ind_vs_a] = 0;
	  a_Static[35][Ind_vs_a] = -1.0;
	  a_CoefObj[35][Ind_v45] = 0;
	  a_Static[35][Ind_v45] = 1.0;
	  a_CoefObj[35][69] = &Coef_iLp_iLn_h_prev_Mnp_Ln_i_2;
	  a_Static[35][69] = 1.0;


	  //Eq. (37)
	  a_CoefObj[36][Ind_ipl] = 0;
	  a_Static[36][Ind_ipl] = 1.0;
	  a_CoefObj[36][Ind_inl] = 0;
	  a_Static[36][Ind_inl] = -1.0;
	  a_CoefObj[36][69] = &Coef_ia_i_2;
	  a_Static[36][69] = 1.0;



	  //Eq. (38)
	  a_CoefObj[37][Ind_v45] = &Coef_recp_rSrD51_i_2;
	  a_Static[37][Ind_v45] = 1.0;
	  a_CoefObj[37][Ind_v51] = &Coef_recp_rSrD51_i_2;
	  a_Static[37][Ind_v51] = -1.0;
	  a_CoefObj[37][Ind_i5st] = 0;
	  a_Static[37][Ind_i5st] = -1.0;
	  a_CoefObj[37][69] = 0;
	  a_Static[37][69] = 0;


	  //Eq. (39)
	  a_CoefObj[38][Ind_v56] = &Coef_recp_rSrD52_i_2;
	  a_Static[38][Ind_v56] = 1.0;
	  a_CoefObj[38][Ind_v45] = &Coef_recp_rSrD52_i_2;
	  a_Static[38][Ind_v45] = -1.0;
	  a_CoefObj[38][Ind_i5sb] = 0;
	  a_Static[38][Ind_i5sb] = -1.0;
	  a_CoefObj[38][69] = 0;
	  a_Static[38][69] = 0;

	  //Eq. (40)
	  a_CoefObj[39][Ind_inl] = 0;
	  a_Static[39][Ind_inl] = 1.0;
	  a_CoefObj[39][Ind_i5_l] = 0;
	  a_Static[39][Ind_i5_l] = 1.0;
	  a_CoefObj[39][Ind_i5] = 0;
	  a_Static[39][Ind_i5] = -1.0;
	  a_CoefObj[39][69] = 0;
	  a_Static[39][69] = 0;

	  //Eq. (41)
	  a_CoefObj[40][Ind_i5st] = 0;
	  a_Static[40][Ind_i5st] = 1.0;
	  a_CoefObj[40][Ind_i5ct] = 0;
	  a_Static[40][Ind_i5ct] = 1.0;
	  a_CoefObj[40][Ind_i5] = 0;
	  a_Static[40][Ind_i5] = -1.0;
	  a_CoefObj[40][69] = 0;
	  a_Static[40][69] = 0;


	  //Eq. (42)
	  a_CoefObj[41][Ind_i5sb] = 0;
	  a_Static[41][Ind_i5sb] = 1.0;
	  a_CoefObj[41][Ind_i5cb] = 0;
	  a_Static[41][Ind_i5cb] = 1.0;
	  a_CoefObj[41][Ind_i5_l] = 0;
	  a_Static[41][Ind_i5_l] = -1.0;
	  a_CoefObj[41][69] = 0;
	  a_Static[41][69] = 0;


	  //Eq. (43)
	  a_CoefObj[42][Ind_v51] = &Coef_C5_h_i_2;
	  a_Static[42][Ind_v51] = 1.0;
	  a_CoefObj[42][Ind_v56] = &Coef_C5_h_i_2;
	  a_Static[42][Ind_v56] = -1.0;
	  a_CoefObj[42][Ind_i5] = 0;
	  a_Static[42][Ind_i5] = -1.0;
	  a_CoefObj[42][69] = &Coef_v51_v56_h_prev_C5_i_2;
	  a_Static[42][69] = 1.0;


	  //Eq. (44)
	  a_CoefObj[43][Ind_v45] = &Coef_C51_h_i_2;
	  a_Static[43][Ind_v45] = 1.0;
	  a_CoefObj[43][Ind_v51] = &Coef_C51_h_i_2;
	  a_Static[43][Ind_v51] = -1.0;
	  a_CoefObj[43][Ind_i5ct] = 0;
	  a_Static[43][Ind_i5ct] = -1.0;
	  a_CoefObj[43][69] = &Coef_v45_v51_h_prev_C51_i_2;
	  a_Static[43][69] = 1.0;


	  //Eq. (45)
	  a_CoefObj[44][Ind_v56] = &Coef_C52_h_i_2;
	  a_Static[44][Ind_v56] = 1.0;
	  a_CoefObj[44][Ind_v45] = &Coef_C52_h_i_2;
	  a_Static[44][Ind_v45] = -1.0;
	  a_CoefObj[44][Ind_i5cb] = 0;
	  a_Static[44][Ind_i5cb] = -1.0;
	  a_CoefObj[44][69] = &Coef_v56_v45_h_prev_C52_i_2;
	  a_Static[44][69] = 1.0;



	  //Eq. (46)
	  a_CoefObj[45][Ind_v56] = &Coef_recp_rSrD61_i_2;
	  a_Static[45][Ind_v56] = 1.0;
	  a_CoefObj[45][Ind_v61] = &Coef_recp_rSrD61_i_2;
	  a_Static[45][Ind_v61] = -1.0;
	  a_CoefObj[45][Ind_i6st] = 0;
	  a_Static[45][Ind_i6st] = -1.0;
	  a_CoefObj[45][69] = 0;
	  a_Static[45][69] = 0;

	  //Eq. (47)
	  a_CoefObj[46][Ind_v67] = &Coef_recp_rSrD62_i_2;
	  a_Static[46][Ind_v67] = 1.0;
	  a_CoefObj[46][Ind_v56] = &Coef_recp_rSrD62_i_2;
	  a_Static[46][Ind_v56] = -1.0;
	  a_CoefObj[46][Ind_i6sb] = 0;
	  a_Static[46][Ind_i6sb] = -1.0;
	  a_CoefObj[46][69] = 0;
	  a_Static[46][69] = 0;

	  //Eq. (48)
	  a_CoefObj[47][Ind_inl] = 0;
	  a_Static[47][Ind_inl] = 1.0;
	  a_CoefObj[47][Ind_i6_l] = 0;
	  a_Static[47][Ind_i6_l] = 1.0;
	  a_CoefObj[47][Ind_i6] = 0;
	  a_Static[47][Ind_i6] = -1.0;
	  a_CoefObj[47][69] = 0;
	  a_Static[47][69] = 0;

	  //Eq. (49)
	  a_CoefObj[48][Ind_i6st] = 0;
	  a_Static[48][Ind_i6st] = 1.0;
	  a_CoefObj[48][Ind_i6ct] = 0;
	  a_Static[48][Ind_i6ct] = 1.0;
	  a_CoefObj[48][Ind_i6] = 0;
	  a_Static[48][Ind_i6] = -1.0;
	  a_CoefObj[48][69] = 0;
	  a_Static[48][69] = 0;


	  //Eq. (50)
	  a_CoefObj[49][Ind_i6sb] = 0;
	  a_Static[49][Ind_i6sb] = 1.0;
	  a_CoefObj[49][Ind_i6cb] = 0;
	  a_Static[49][Ind_i6cb] = 1.0;
	  a_CoefObj[49][Ind_i6_l] = 0;
	  a_Static[49][Ind_i6_l] = -1.0;
	  a_CoefObj[49][69] = 0;
	  a_Static[49][69] = 0;


	  //Eq. (51)
	  a_CoefObj[50][Ind_v61] =  &Coef_C6_h_i_2;
	  a_Static[50][Ind_v61] = 1.0;
	  a_CoefObj[50][Ind_v67] =  &Coef_C6_h_i_2;
	  a_Static[50][Ind_v67] = -1.0;
	  a_CoefObj[50][Ind_i6] = 0;
	  a_Static[50][Ind_i6] = -1.0;
	  a_CoefObj[50][69] = &Coef_v61_v67_h_prev_C6_i_2;
	  a_Static[50][69] = 1.0;

	  //Eq. (52)
	  a_CoefObj[51][Ind_v56] = &Coef_C61_h_i_2;
	  a_Static[51][Ind_v56] = 1.0;
	  a_CoefObj[51][Ind_v61] = &Coef_C61_h_i_2;
	  a_Static[51][Ind_v61] = -1.0;
	  a_CoefObj[51][Ind_i6ct] = 0;
	  a_Static[51][Ind_i6ct] = -1.0;
	  a_CoefObj[51][69] = &Coef_v56_v61_h_prev_C61_i_2;
	  a_Static[51][69] = 1.0;


	  //Eq. (53)
	  a_CoefObj[52][Ind_v67] = &Coef_C62_h_i_2;
	  a_Static[52][Ind_v67] = 1.0;
	  a_CoefObj[52][Ind_v56] = &Coef_C62_h_i_2;
	  a_Static[52][Ind_v56] = -1.0;
	  a_CoefObj[52][Ind_i6cb] = 0;
	  a_Static[52][Ind_i6cb] = -1.0;
	  a_CoefObj[52][69] = &Coef_v67_v56_h_prev_C62_i_2;
	  a_Static[52][69] = 1.0;


	  //Eq. (54)
	  a_CoefObj[53][Ind_v67] = &Coef_recp_rSrD71_i_2;
	  a_Static[53][Ind_v67] = 1.0;
	  a_CoefObj[53][Ind_v71] = &Coef_recp_rSrD71_i_2;
	  a_Static[53][Ind_v71] = -1.0;
	  a_CoefObj[53][Ind_i7st] = 0;
	  a_Static[53][Ind_i7st] = -1.0;
	  a_CoefObj[53][69] = 0;
	  a_Static[53][69] = 0;

	  //Eq. (55)
	  a_CoefObj[54][Ind_v78] = &Coef_recp_rSrD72_i_2;
	  a_Static[54][Ind_v78] = 1.0;
	  a_CoefObj[54][Ind_v67] = &Coef_recp_rSrD72_i_2;
	  a_Static[54][Ind_v67] = -1.0;
	  a_CoefObj[54][Ind_i7sb] = 0;
	  a_Static[54][Ind_i7sb] = -1.0;
	  a_CoefObj[54][69] = 0;
	  a_Static[54][69] = 0;

	  //Eq. (56)
	  a_CoefObj[55][Ind_inl] = 0;
	  a_Static[55][Ind_inl] = 1.0;
	  a_CoefObj[55][Ind_i7_l] = 0;
	  a_Static[55][Ind_i7_l] = 1.0;
	  a_CoefObj[55][Ind_i7] = 0;
	  a_Static[55][Ind_i7] = -1.0;
	  a_CoefObj[55][69] = 0;
	  a_Static[55][69] = 0;

	  //Eq. (57)
	  a_CoefObj[56][Ind_i7st] = 0;
	  a_Static[56][Ind_i7st] = 1.0;
	  a_CoefObj[56][Ind_i7ct] = 0;
	  a_Static[56][Ind_i7ct] = 1.0;
	  a_CoefObj[56][Ind_i7] = 0;
	  a_Static[56][Ind_i7] = -1.0;
	  a_CoefObj[56][69] = 0;
	  a_Static[56][69] = 0;


	  //Eq. (58)
	  a_CoefObj[57][Ind_i7sb] = 0;
	  a_Static[57][Ind_i7sb] = 1.0;
	  a_CoefObj[57][Ind_i7cb] = 0;
	  a_Static[57][Ind_i7cb] = 1.0;
	  a_CoefObj[57][Ind_i7_l] = 0;
	  a_Static[57][Ind_i7_l] = -1.0;
	  a_CoefObj[57][69] = 0;
	  a_Static[57][69] = 0;


	  //Eq. (59)
	  a_CoefObj[58][Ind_v71] = &Coef_C7_h_i_2;
	  a_Static[58][Ind_v71] = 1.0;
	  a_CoefObj[58][Ind_v78] = &Coef_C7_h_i_2;
	  a_Static[58][Ind_v78] = -1.0;
	  a_CoefObj[58][Ind_i7] = 0;
	  a_Static[58][Ind_i7] = -1.0;
	  a_CoefObj[58][69] = &Coef_v71_v78_h_prev_C7_i_2;
	  a_Static[58][69] = 1.0;

	  //Eq. (60)
	  a_CoefObj[59][Ind_v67] = &Coef_C71_h_i_2;
	  a_Static[59][Ind_v67] = 1.0;
	  a_CoefObj[59][Ind_v71] = &Coef_C71_h_i_2;
	  a_Static[59][Ind_v71] = -1.0;
	  a_CoefObj[59][Ind_i7ct] = 0;
	  a_Static[59][Ind_i7ct] = -1.0;
	  a_CoefObj[59][69] = &Coef_v67_v71_h_prev_C71_i_2;
	  a_Static[59][69] = 1.0;


	  //Eq. (61)
	  a_CoefObj[60][Ind_v78] = &Coef_C72_h_i_2;
	  a_Static[60][Ind_v78] = 1.0;
	  a_CoefObj[60][Ind_v67] = &Coef_C72_h_i_2;
	  a_Static[60][Ind_v67] = -1.0;
	  a_CoefObj[60][Ind_i7cb] = 0;
	  a_Static[60][Ind_i7cb] = -1.0;
	  a_CoefObj[60][69] = &Coef_v78_v67_h_prev_C72_i_2;
	  a_Static[60][69] = 1.0;


	  //Eq. (62)
	  a_CoefObj[61][Ind_v78] = &Coef_recp_rSrD81_i_2;
	  a_Static[61][Ind_v78] = 1.0;
	  a_CoefObj[61][Ind_v81] = &Coef_recp_rSrD81_i_2;
	  a_Static[61][Ind_v81] = -1.0;
	  a_CoefObj[61][Ind_i8st] = 0;
	  a_Static[61][Ind_i8st] = -1.0;
	  a_CoefObj[61][69] = 0;
	  a_Static[61][69] = 0;


	  //Eq. (63)
	  a_CoefObj[62][Ind_v78] = &Coef_recp_rSrD82_i_2;
	  a_Static[62][Ind_v78] = -1.0;
	  a_CoefObj[62][Ind_i8sb] = 0;
	  a_Static[62][Ind_i8sb] = -1.0;
	  a_CoefObj[62][69] = &Coef_recp_rSrD82_i_2;
	  a_Static[62][69] = - MINUS_DC_BUS_VOLTAGE;

	  //Eq. (64)
	  a_CoefObj[63][Ind_inl] = 0;
	  a_Static[63][Ind_inl] = 1.0;
	  a_CoefObj[63][Ind_i8_l] = 0;
	  a_Static[63][Ind_i8_l] = 1.0;
	  a_CoefObj[63][Ind_i8] = 0;
	  a_Static[63][Ind_i8] = -1.0;
	  a_CoefObj[63][69] = 0;
	  a_Static[63][69] = 0;

	  //Eq. (65)
	  a_CoefObj[64][Ind_i8st] = 0;
	  a_Static[64][Ind_i8st] = 1.0;
	  a_CoefObj[64][Ind_i8ct] = 0;
	  a_Static[64][Ind_i8ct] = 1.0;
	  a_CoefObj[64][Ind_i8] = 0;
	  a_Static[64][Ind_i8] = -1.0;
	  a_CoefObj[64][69] = 0;
	  a_Static[64][69] = 0;


	  //Eq. (66)
	  a_CoefObj[65][Ind_i8sb] = 0;
	  a_Static[65][Ind_i8sb] = 1.0;
	  a_CoefObj[65][Ind_i8cb] = 0;
	  a_Static[65][Ind_i8cb] = 1.0;
	  a_CoefObj[65][Ind_i8_l] = 0;
	  a_Static[65][Ind_i8_l] = -1.0;
	  a_CoefObj[65][69] = 0;
	  a_Static[65][69] = 0;



	  //Eq. (67)
	  a_CoefObj[66][Ind_v81] = &Coef_C8_h_i_2;
	  a_Static[66][Ind_v81] = 1.0;
	  a_CoefObj[66][Ind_i8] = 0;
	  a_Static[66][Ind_i8] = -1.0;
	  a_CoefObj[66][69] = &Coef_v81_h_prev_plus_MinusBus_C8_i_2;
	  a_Static[66][69] = 1.0;

	  //Eq. (68)
	  a_CoefObj[67][Ind_v78] = &Coef_C81_h_i_2;
	  a_Static[67][Ind_v78] = 1.0;
	  a_CoefObj[67][Ind_v81] = &Coef_C81_h_i_2;
	  a_Static[67][Ind_v81] = -1.0;
	  a_CoefObj[67][Ind_i8ct] = 0;
	  a_Static[67][Ind_i8ct] = -1.0;
	  a_CoefObj[67][69] = &Coef_v78_v81_h_prev_C81_i_2;
	  a_Static[67][69] = 1.0;

	  //Eq. (69)
	  a_CoefObj[68][Ind_v78] = &Coef_C82_h_i_2;
	  a_Static[68][Ind_v78] = -1.0;
	  a_CoefObj[68][Ind_i8cb] = 0;
	  a_Static[68][Ind_i8cb] = -1.0;
	  a_CoefObj[68][69] = &Coef_minus_v78_h_prev_minus_MinusBus_C82_i_2;
	  a_Static[68][69] = 1.0;



  }
  
  	  !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! STOP !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!



  //build the ODE Rvalue list.

  pOdeObjRValList = new OdeObjItem;          
  pCurOdeItem = pOdeObjRValList;
 
  pCurOdeItem->pOdeObject = OdeObjectList[ODE_FUNC_ia_ib_1];    




  //build the SWITCH Rvalue list.

  pSwitchObjRValList = new SwitchObjItem;
  pCurSwitchItem = pSwitchObjRValList;

  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS11];
  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;  
  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS12];
  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem; 
  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS21];
  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem; 
  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS22];
  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem; 
  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS31];
  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem; 
  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS32];
  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem; 
  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS41];
  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem; 
  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS42];
  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem; 
  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS51];
  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem; 
  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS52];
  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem; 
  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS61];
  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem; 
  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS62];
  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem; 
  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS71];
  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem; 
  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS72];
  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem; 
  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS81];
  pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem; 
  pCurSwitchItem->pSwitchObject = SwitchObjectList[SWITCH_FUNC_rS82];


  //build the COEF Rvalue list.

  pCoefObjRValList = new CoefObjItem;
  pCurCoefItem = pCoefObjRValList;

  pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_v11_v12_h_prev_C1];
  pCurCoefItem->pNextCoefItem = new CoefObjItem;
  pCurCoefItem = pCurCoefItem->pNextCoefItem;
  pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_minus_v11_h_prev_minus_PlusBus_C11];
  pCurCoefItem->pNextCoefItem = new CoefObjItem;
  pCurCoefItem = pCurCoefItem->pNextCoefItem;
  pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_v12_h_prev_plus_PlusBus_C12];
  pCurCoefItem->pNextCoefItem = new CoefObjItem;
  pCurCoefItem = pCurCoefItem->pNextCoefItem;
  pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_v21_v23_h_prev_C2];
  pCurCoefItem->pNextCoefItem = new CoefObjItem;
  pCurCoefItem = pCurCoefItem->pNextCoefItem;
  pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_v12_v21_h_prev_C21];
  pCurCoefItem->pNextCoefItem = new CoefObjItem;
  pCurCoefItem = pCurCoefItem->pNextCoefItem;
  pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_v23_v12_h_prev_C22];
  pCurCoefItem->pNextCoefItem = new CoefObjItem;
  pCurCoefItem = pCurCoefItem->pNextCoefItem;
  pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_v31_v34_h_prev_C3];
  pCurCoefItem->pNextCoefItem = new CoefObjItem;
  pCurCoefItem = pCurCoefItem->pNextCoefItem;
  pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_v23_v31_h_prev_C31];
  pCurCoefItem->pNextCoefItem = new CoefObjItem;
  pCurCoefItem = pCurCoefItem->pNextCoefItem;
  pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_v34_v23_h_prev_C32];
  pCurCoefItem->pNextCoefItem = new CoefObjItem;
  pCurCoefItem = pCurCoefItem->pNextCoefItem;
  pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_v41_v44_h_prev_C4];
  pCurCoefItem->pNextCoefItem = new CoefObjItem;
  pCurCoefItem = pCurCoefItem->pNextCoefItem;
  pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_v34_v41_h_prev_C41];
  pCurCoefItem->pNextCoefItem = new CoefObjItem;
  pCurCoefItem = pCurCoefItem->pNextCoefItem;
  pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_v44_v34_h_prev_C42];
  pCurCoefItem->pNextCoefItem = new CoefObjItem;
  pCurCoefItem = pCurCoefItem->pNextCoefItem;
  pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_iLp_iLn_h_prev_Lp_Mpn];
  pCurCoefItem->pNextCoefItem = new CoefObjItem;
  pCurCoefItem = pCurCoefItem->pNextCoefItem;
  pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_iLp_iLn_h_prev_Mnp_Ln];
  pCurCoefItem->pNextCoefItem = new CoefObjItem;
  pCurCoefItem = pCurCoefItem->pNextCoefItem;
  pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_v51_v56_h_prev_C5];
  pCurCoefItem->pNextCoefItem = new CoefObjItem;
  pCurCoefItem = pCurCoefItem->pNextCoefItem;
  pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_v45_v51_h_prev_C51];
  pCurCoefItem->pNextCoefItem = new CoefObjItem;
  pCurCoefItem = pCurCoefItem->pNextCoefItem;
  pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_v56_v45_h_prev_C52];
  pCurCoefItem->pNextCoefItem = new CoefObjItem;
  pCurCoefItem = pCurCoefItem->pNextCoefItem;
  pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_v61_v67_h_prev_C6];
  pCurCoefItem->pNextCoefItem = new CoefObjItem;
  pCurCoefItem = pCurCoefItem->pNextCoefItem;
  pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_v56_v61_h_prev_C61];
  pCurCoefItem->pNextCoefItem = new CoefObjItem;
  pCurCoefItem = pCurCoefItem->pNextCoefItem;
  pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_v67_v56_h_prev_C62];
  pCurCoefItem->pNextCoefItem = new CoefObjItem;
  pCurCoefItem = pCurCoefItem->pNextCoefItem;
  pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_v71_v78_h_prev_C7];
  pCurCoefItem->pNextCoefItem = new CoefObjItem;
  pCurCoefItem = pCurCoefItem->pNextCoefItem;
  pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_v67_v71_h_prev_C71];
  pCurCoefItem->pNextCoefItem = new CoefObjItem;
  pCurCoefItem = pCurCoefItem->pNextCoefItem;
  pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_v78_v67_h_prev_C72];
  pCurCoefItem->pNextCoefItem = new CoefObjItem;
  pCurCoefItem = pCurCoefItem->pNextCoefItem;
  pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_v81_h_prev_plus_MinusBus_C8];
  pCurCoefItem->pNextCoefItem = new CoefObjItem;
  pCurCoefItem = pCurCoefItem->pNextCoefItem;
  pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_v78_v81_h_prev_C81];
  pCurCoefItem->pNextCoefItem = new CoefObjItem;
  pCurCoefItem = pCurCoefItem->pNextCoefItem;
  pCurCoefItem->pCoefObject = CoefObjectList[COEF_FUNC_minus_v78_h_prev_minus_MinusBus_C82];




#ifdef PLOT_SPICEOBJECT_PROBES_solution_vector
  DoProbes = TRUE;
#endif
#ifdef DO_PROBE_v11    
  pDoProbes_[Ind_v11] = TRUE;
  pProbeName[Ind_v11] = "v11";
#endif
#ifdef DO_PROBE_v12   
  pDoProbes_[Ind_v12] = TRUE;
  pProbeName[Ind_v12] = "v12";
#endif 
#ifdef DO_PROBE_v21   
  pDoProbes_[Ind_v21] = TRUE;
  pProbeName[Ind_v21] = "v21";
#endif 
#ifdef DO_PROBE_v23   
  pDoProbes_[Ind_v23] = TRUE;
  pProbeName[Ind_v23] = "v23";
#endif 
#ifdef DO_PROBE_v31   
  pDoProbes_[Ind_v31] = TRUE;
  pProbeName[Ind_v31] = "v31";
#endif 
#ifdef DO_PROBE_v34 
  pDoProbes_[Ind_v34] = TRUE;
  pProbeName[Ind_v34] = "v34";
#endif   
#ifdef DO_PROBE_v41  
  pDoProbes_[Ind_v41] = TRUE;
  pProbeName[Ind_v41] = "v41";
#endif  
#ifdef DO_PROBE_v44  
  pDoProbes_[Ind_v44] = TRUE;
  pProbeName[Ind_v44] = "v44";
#endif  
#ifdef DO_PROBE_v45   
  pDoProbes_[Ind_v45] = TRUE;
  pProbeName[Ind_v45] = "v45";
#endif 
#ifdef DO_PROBE_vs_a   
  pDoProbes_[Ind_vs_a] = TRUE;
  pProbeName[Ind_vs_a] = "vs_a";
#endif
#ifdef DO_PROBE_v51    
  pDoProbes_[Ind_v51] = TRUE;
  pProbeName[Ind_v51] = "v51";
#endif
#ifdef DO_PROBE_v56   
  pDoProbes_[Ind_v56] = TRUE;
  pProbeName[Ind_v56] = "v56";
#endif 
#ifdef DO_PROBE_v61   
  pDoProbes_[Ind_v61] = TRUE;
  pProbeName[Ind_v61] = "v61";
#endif 
#ifdef DO_PROBE_v67    
  pDoProbes_[Ind_v67] = TRUE;
  pProbeName[Ind_v67] = "v67";
#endif
#ifdef DO_PROBE_v71    
  pDoProbes_[Ind_v71] = TRUE;
  pProbeName[Ind_v71] = "v71";
#endif
#ifdef DO_PROBE_v78    
  pDoProbes_[Ind_v78] = TRUE;
  pProbeName[Ind_v78] = "v78";
#endif
#ifdef DO_PROBE_v81    
  pDoProbes_[Ind_v81] = TRUE;
  pProbeName[Ind_v81] = "v81";
#endif
#ifdef DO_PROBE_i1    
  pDoProbes_[Ind_i1] = TRUE;
  pProbeName[Ind_i1] = "i1";
#endif
#ifdef DO_PROBE_i1_l  
  pDoProbes_[Ind_i1_l] = TRUE;
  pProbeName[Ind_i1_l] = "i1_l";
#endif
#ifdef DO_PROBE_ipl   
  pDoProbes_[Ind_ipl] = TRUE;
  pProbeName[Ind_ipl] = "ipl";
#endif 
#ifdef DO_PROBE_i1st
  pDoProbes_[Ind_i1st] = TRUE;
  pProbeName[Ind_i1st] = "i1st";
#endif
#ifdef DO_PROBE_i1ct
  pDoProbes_[Ind_i1ct] = TRUE;
  pProbeName[Ind_i1ct] = "i1ct";
#endif
#ifdef DO_PROBE_i1sb
  pDoProbes_[Ind_i1sb] = TRUE;
  pProbeName[Ind_i1sb] = "i1sb";
#endif
#ifdef DO_PROBE_i1cb
  pDoProbes_[Ind_i1cb] = TRUE;
  pProbeName[Ind_i1cb] = "i1cb";
#endif
#ifdef DO_PROBE_i2    
  pDoProbes_[Ind_i2] = TRUE;
  pProbeName[Ind_i2] = "i2";
#endif 
#ifdef DO_PROBE_i2_l    
  pDoProbes_[Ind_i2_l] = TRUE;
  pProbeName[Ind_i2_l] = "i2_l";
#endif 
#ifdef DO_PROBE_i2st
  pDoProbes_[Ind_i2st] = TRUE;
  pProbeName[Ind_i2st] = "i2st";
#endif
#ifdef DO_PROBE_i2ct
  pDoProbes_[Ind_i2ct] = TRUE;
  pProbeName[Ind_i2ct] = "i2ct";
#endif
#ifdef DO_PROBE_i2sb
  pDoProbes_[Ind_i2sb] = TRUE;
  pProbeName[Ind_i2sb] = "i2sb";
#endif
#ifdef DO_PROBE_i2cb
  pDoProbes_[Ind_i2cb] = TRUE;
  pProbeName[Ind_i2cb] = "i2cb";
#endif
#ifdef DO_PROBE_i3   
  pDoProbes_[Ind_i3] = TRUE;
  pProbeName[Ind_i3] = "i3";
#endif  
#ifdef DO_PROBE_i3_l   
  pDoProbes_[Ind_i3_l] = TRUE;
  pProbeName[Ind_i3_l] = "i3_l";
#endif 
#ifdef DO_PROBE_i3st
  pDoProbes_[Ind_i3st] = TRUE;
  pProbeName[Ind_i3st] = "i3st";
#endif
#ifdef DO_PROBE_i3ct
  pDoProbes_[Ind_i3ct] = TRUE;
  pProbeName[Ind_i3ct] = "i3ct";
#endif
#ifdef DO_PROBE_i3sb
  pDoProbes_[Ind_i3sb] = TRUE;
  pProbeName[Ind_i3sb] = "i3sb";
#endif
#ifdef DO_PROBE_i3cb
  pDoProbes_[Ind_i3cb] = TRUE;
  pProbeName[Ind_i3cb] = "i3cb";
#endif
#ifdef DO_PROBE_i4 
  pDoProbes_[Ind_i4] = TRUE;
  pProbeName[Ind_i4] = "i4";
#endif    
#ifdef DO_PROBE_i4_l 
  pDoProbes_[Ind_i4_l] = TRUE;
  pProbeName[Ind_i4_l] = "i4_l";
#endif 
#ifdef DO_PROBE_i4st
  pDoProbes_[Ind_i4st] = TRUE;
  pProbeName[Ind_i4st] = "i4st";
#endif
#ifdef DO_PROBE_i4ct
  pDoProbes_[Ind_i4ct] = TRUE;
  pProbeName[Ind_i4ct] = "i4ct";
#endif
#ifdef DO_PROBE_i4sb
  pDoProbes_[Ind_i4sb] = TRUE;
  pProbeName[Ind_i4sb] = "i4sb";
#endif
#ifdef DO_PROBE_i4cb
  pDoProbes_[Ind_i4cb] = TRUE;
  pProbeName[Ind_i4cb] = "i4cb";
#endif
#ifdef DO_PROBE_i5  
  pDoProbes_[Ind_i5] = TRUE;
  pProbeName[Ind_i5] = "i5";
#endif   
#ifdef DO_PROBE_i5_l  
  pDoProbes_[Ind_i5_l] = TRUE;
  pProbeName[Ind_i5_l] = "i5_l";
#endif   
#ifdef DO_PROBE_i5st
  pDoProbes_[Ind_i5st] = TRUE;
  pProbeName[Ind_i5st] = "i5st";
#endif
#ifdef DO_PROBE_i5ct
  pDoProbes_[Ind_i5ct] = TRUE;
  pProbeName[Ind_i5ct] = "i5ct";
#endif
#ifdef DO_PROBE_i5sb
  pDoProbes_[Ind_i5sb] = TRUE;
  pProbeName[Ind_i5sb] = "i5sb";
#endif
#ifdef DO_PROBE_i5cb
  pDoProbes_[Ind_i5cb] = TRUE;
  pProbeName[Ind_i5cb] = "i5cb";
#endif
#ifdef DO_PROBE_inl  
  pDoProbes_[Ind_inl] = TRUE;
  pProbeName[Ind_inl] = "inl";
#endif  
#ifdef DO_PROBE_i6   
 pDoProbes_[Ind_i6] = TRUE;
 pProbeName[Ind_i6] = "i6";
#endif  
#ifdef DO_PROBE_i6_l   
 pDoProbes_[Ind_i6_l] = TRUE;
 pProbeName[Ind_i6_l] = "i6_l";
#endif  
#ifdef DO_PROBE_i6st
  pDoProbes_[Ind_i6st] = TRUE;
  pProbeName[Ind_i6st] = "i6st";
#endif
#ifdef DO_PROBE_i6ct
  pDoProbes_[Ind_i6ct] = TRUE;
  pProbeName[Ind_i6ct] = "i6ct";
#endif
#ifdef DO_PROBE_i6sb
  pDoProbes_[Ind_i6sb] = TRUE;
  pProbeName[Ind_i6sb] = "i6sb";
#endif
#ifdef DO_PROBE_i6cb
  pDoProbes_[Ind_i6cb] = TRUE;
  pProbeName[Ind_i6cb] = "i6cb";
#endif
#ifdef DO_PROBE_i7  
 pDoProbes_[Ind_i7] = TRUE;
 pProbeName[Ind_i7] = "i7";
#endif   
#ifdef DO_PROBE_i7_l  
 pDoProbes_[Ind_i7_l] = TRUE;
 pProbeName[Ind_i7_l] = "i7_l";
#endif
#ifdef DO_PROBE_i7st
  pDoProbes_[Ind_i7st] = TRUE;
  pProbeName[Ind_i7st] = "i7st";
#endif
#ifdef DO_PROBE_i7ct
  pDoProbes_[Ind_i7ct] = TRUE;
  pProbeName[Ind_i7ct] = "i7ct";
#endif
#ifdef DO_PROBE_i7sb
  pDoProbes_[Ind_i7sb] = TRUE;
  pProbeName[Ind_i7sb] = "i7sb";
#endif
#ifdef DO_PROBE_i7cb
  pDoProbes_[Ind_i7cb] = TRUE;
  pProbeName[Ind_i7cb] = "i7cb";
#endif
#ifdef DO_PROBE_i8  
  pDoProbes_[Ind_i8] = TRUE;
  pProbeName[Ind_i8] = "i8";
#endif
#ifdef DO_PROBE_i8_l  
  pDoProbes_[Ind_i8_l] = TRUE;
  pProbeName[Ind_i8_l] = "i8_l";
#endif
#ifdef DO_PROBE_i8st
  pDoProbes_[Ind_i8st] = TRUE;
  pProbeName[Ind_i8st] = "i8st";
#endif
#ifdef DO_PROBE_i8ct
  pDoProbes_[Ind_i8ct] = TRUE;
  pProbeName[Ind_i8ct] = "i8ct";
#endif
#ifdef DO_PROBE_i8sb
  pDoProbes_[Ind_i8sb] = TRUE;
  pProbeName[Ind_i8sb] = "i8sb";
#endif
#ifdef DO_PROBE_i8cb
  pDoProbes_[Ind_i8cb] = TRUE;
  pProbeName[Ind_i8cb] = "i8cb";
#endif


#ifdef DUMP_VS_A_OUTPUT_SIGNAL
#ifdef ENABLE_OMEGA_CTRL
	fp_vs_a_output = fopen("vs_a_output_omega.dat", "w");
#else
	fp_vs_a_output = fopen("vs_a_output_no_omega.dat", "w");
#endif


#endif


}

Spice_MultiLevel::~Spice_MultiLevel(void)
{
#ifdef DUMP_VS_A_OUTPUT_SIGNAL
	fclose(fp_vs_a_output);
#endif
}



void Spice_MultiLevel::OdeRValueUpdate(void)
{

  OdeObjItem * pCurOdeItem;

  //Update Rvalues
  pCurOdeItem = pOdeObjRValList;

  ((class ia_ib_1 *) pCurOdeItem->pOdeObject)->vs_a = a[Ind_vs_a][69];

#ifdef DUMP_VS_A_OUTPUT_SIGNAL
  fprintf(fp_vs_a_output, "%g\n", a[Ind_vs_a][69]);

#endif

}

void Spice_MultiLevel::SwitchRValueUpdate(void)
{
  SwitchObjItem * pCurSwitchItem;

  //Update Rvalues
  pCurSwitchItem = pSwitchObjRValList;

  ((class Switch_rS11 *) pCurSwitchItem->pSwitchObject)->DevCur = a[Ind_i1st][69];
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  ((class Switch_rS12 *) pCurSwitchItem->pSwitchObject)->DevCur = a[Ind_i1sb][69];
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  ((class Switch_rS21 *) pCurSwitchItem->pSwitchObject)->DevCur = a[Ind_i2st][69];
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  ((class Switch_rS22 *) pCurSwitchItem->pSwitchObject)->DevCur = a[Ind_i2sb][69];
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  ((class Switch_rS31 *) pCurSwitchItem->pSwitchObject)->DevCur = a[Ind_i3st][69];
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  ((class Switch_rS32 *) pCurSwitchItem->pSwitchObject)->DevCur = a[Ind_i3sb][69];
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  ((class Switch_rS41 *) pCurSwitchItem->pSwitchObject)->DevCur = a[Ind_i4st][69];
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  ((class Switch_rS42 *) pCurSwitchItem->pSwitchObject)->DevCur = a[Ind_i4sb][69];
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  ((class Switch_rS51 *) pCurSwitchItem->pSwitchObject)->DevCur = a[Ind_i5st][69];
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  ((class Switch_rS52 *) pCurSwitchItem->pSwitchObject)->DevCur = a[Ind_i5sb][69];
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  ((class Switch_rS61 *) pCurSwitchItem->pSwitchObject)->DevCur = a[Ind_i6st][69];
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  ((class Switch_rS62 *) pCurSwitchItem->pSwitchObject)->DevCur = a[Ind_i6sb][69];
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  ((class Switch_rS71 *) pCurSwitchItem->pSwitchObject)->DevCur = a[Ind_i7st][69];
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  ((class Switch_rS72 *) pCurSwitchItem->pSwitchObject)->DevCur = a[Ind_i7sb][69];
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  ((class Switch_rS81 *) pCurSwitchItem->pSwitchObject)->DevCur = a[Ind_i8st][69];
  pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  ((class Switch_rS82 *) pCurSwitchItem->pSwitchObject)->DevCur = a[Ind_i8sb][69];




}


void Spice_MultiLevel::CoefRValueUpdate(void)
{

  CoefObjItem * pCurCoefItem;

  //Update Rvalues
  pCurCoefItem = pCoefObjRValList;

  ((Coef_v11_v12_h_prev_C1 *) pCurCoefItem->pCoefObject)->v11_ = a[Ind_v11][69];
  ((Coef_v11_v12_h_prev_C1 *) pCurCoefItem->pCoefObject)->v12_ = a[Ind_v12][69];
  ((Coef_v11_v12_h_prev_C1 *) pCurCoefItem->pCoefObject)->i1_ = a[Ind_i1][69];
  pCurCoefItem = pCurCoefItem->pNextCoefItem;
  ((Coef_minus_v11_h_prev_minus_PlusBus_C11 *) pCurCoefItem->pCoefObject)->v11_ = a[Ind_v11][69];
  ((Coef_minus_v11_h_prev_minus_PlusBus_C11 *) pCurCoefItem->pCoefObject)->i1ct_ = a[Ind_i1ct][69];
  pCurCoefItem = pCurCoefItem->pNextCoefItem;
  ((Coef_v12_h_prev_plus_PlusBus_C12 *) pCurCoefItem->pCoefObject)->v12_ = a[Ind_v12][69];
  ((Coef_v12_h_prev_plus_PlusBus_C12 *) pCurCoefItem->pCoefObject)->i1cb_ = a[Ind_i1cb][69];
  pCurCoefItem = pCurCoefItem->pNextCoefItem;
  ((Coef_v21_v23_h_prev_C2 *) pCurCoefItem->pCoefObject)->v21_ = a[Ind_v21][69];
  ((Coef_v21_v23_h_prev_C2 *) pCurCoefItem->pCoefObject)->v23_ = a[Ind_v23][69];
  ((Coef_v21_v23_h_prev_C2 *) pCurCoefItem->pCoefObject)->i2_ = a[Ind_i2][69];
  pCurCoefItem = pCurCoefItem->pNextCoefItem;
  ((Coef_v12_v21_h_prev_C21 *) pCurCoefItem->pCoefObject)->v12_ = a[Ind_v12][69];
  ((Coef_v12_v21_h_prev_C21 *) pCurCoefItem->pCoefObject)->v21_ = a[Ind_v21][69];
  ((Coef_v12_v21_h_prev_C21 *) pCurCoefItem->pCoefObject)->i2ct_ = a[Ind_i2ct][69];
  pCurCoefItem = pCurCoefItem->pNextCoefItem;
  ((Coef_v23_v12_h_prev_C22 *) pCurCoefItem->pCoefObject)->v23_ = a[Ind_v23][69];
  ((Coef_v23_v12_h_prev_C22 *) pCurCoefItem->pCoefObject)->v12_ = a[Ind_v12][69];
  ((Coef_v23_v12_h_prev_C22 *) pCurCoefItem->pCoefObject)->i2cb_ = a[Ind_i2cb][69];
  pCurCoefItem = pCurCoefItem->pNextCoefItem;
  ((Coef_v31_v34_h_prev_C3 *) pCurCoefItem->pCoefObject)->v31_ = a[Ind_v31][69];
  ((Coef_v31_v34_h_prev_C3 *) pCurCoefItem->pCoefObject)->v34_ = a[Ind_v34][69];
  ((Coef_v31_v34_h_prev_C3 *) pCurCoefItem->pCoefObject)->i3_ = a[Ind_i3][69];
  pCurCoefItem = pCurCoefItem->pNextCoefItem;
  ((Coef_v23_v31_h_prev_C31 *) pCurCoefItem->pCoefObject)->v23_ = a[Ind_v23][69];
  ((Coef_v23_v31_h_prev_C31 *) pCurCoefItem->pCoefObject)->v31_ = a[Ind_v31][69];
  ((Coef_v23_v31_h_prev_C31 *) pCurCoefItem->pCoefObject)->i3ct_ = a[Ind_i3ct][69];
  pCurCoefItem = pCurCoefItem->pNextCoefItem;
  ((Coef_v34_v23_h_prev_C32 *) pCurCoefItem->pCoefObject)->v34_ = a[Ind_v34][69];
  ((Coef_v34_v23_h_prev_C32 *) pCurCoefItem->pCoefObject)->v23_ = a[Ind_v23][69];
  ((Coef_v34_v23_h_prev_C32 *) pCurCoefItem->pCoefObject)->i3cb_ = a[Ind_i3cb][69];
  pCurCoefItem = pCurCoefItem->pNextCoefItem;
  ((Coef_v41_v44_h_prev_C4 *) pCurCoefItem->pCoefObject)->v41_ = a[Ind_v41][69];
  ((Coef_v41_v44_h_prev_C4 *) pCurCoefItem->pCoefObject)->v44_ = a[Ind_v44][69];
  ((Coef_v41_v44_h_prev_C4 *) pCurCoefItem->pCoefObject)->i4_ = a[Ind_i4][69];
  pCurCoefItem = pCurCoefItem->pNextCoefItem;
  ((Coef_v34_v41_h_prev_C41 *) pCurCoefItem->pCoefObject)->v34_ = a[Ind_v34][69];
  ((Coef_v34_v41_h_prev_C41 *) pCurCoefItem->pCoefObject)->v41_ = a[Ind_v41][69];
  ((Coef_v34_v41_h_prev_C41 *) pCurCoefItem->pCoefObject)->i4ct_ = a[Ind_i4ct][69];
  pCurCoefItem = pCurCoefItem->pNextCoefItem;
  ((Coef_v44_v34_h_prev_C42 *) pCurCoefItem->pCoefObject)->v44_ = a[Ind_v44][69];
  ((Coef_v44_v34_h_prev_C42 *) pCurCoefItem->pCoefObject)->v34_ = a[Ind_v34][69];
  ((Coef_v44_v34_h_prev_C42 *) pCurCoefItem->pCoefObject)->i4cb_ = a[Ind_i4cb][69];
  pCurCoefItem = pCurCoefItem->pNextCoefItem;


  ((Coef_iLp_iLn_h_prev_Lp_Mpn *) pCurCoefItem->pCoefObject)->iLp_ = a[Ind_iLp][69];
  ((Coef_iLp_iLn_h_prev_Lp_Mpn *) pCurCoefItem->pCoefObject)->iLn_ = a[Ind_iLn][69];
  ((Coef_iLp_iLn_h_prev_Lp_Mpn *) pCurCoefItem->pCoefObject)->v44_ = a[Ind_v44][69];
  ((Coef_iLp_iLn_h_prev_Lp_Mpn *) pCurCoefItem->pCoefObject)->vs_a_ = a[Ind_vs_a][69];
  pCurCoefItem = pCurCoefItem->pNextCoefItem;
  ((Coef_iLp_iLn_h_prev_Mnp_Ln *) pCurCoefItem->pCoefObject)->iLp_ = a[Ind_iLp][69];
  ((Coef_iLp_iLn_h_prev_Mnp_Ln *) pCurCoefItem->pCoefObject)->iLn_ = a[Ind_iLn][69];
  ((Coef_iLp_iLn_h_prev_Mnp_Ln *) pCurCoefItem->pCoefObject)->vs_a_ = a[Ind_vs_a][69];
  ((Coef_iLp_iLn_h_prev_Mnp_Ln *) pCurCoefItem->pCoefObject)->v45_ = a[Ind_v45][69];
  pCurCoefItem = pCurCoefItem->pNextCoefItem;


  ((Coef_v51_v56_h_prev_C5 *) pCurCoefItem->pCoefObject)->v51_ = a[Ind_v51][69];
  ((Coef_v51_v56_h_prev_C5 *) pCurCoefItem->pCoefObject)->v56_ = a[Ind_v56][69];
  ((Coef_v51_v56_h_prev_C5 *) pCurCoefItem->pCoefObject)->i5_ = a[Ind_i5][69];
  pCurCoefItem = pCurCoefItem->pNextCoefItem;
  ((Coef_v45_v51_h_prev_C51 *) pCurCoefItem->pCoefObject)->v45_ = a[Ind_v45][69];
  ((Coef_v45_v51_h_prev_C51 *) pCurCoefItem->pCoefObject)->v51_ = a[Ind_v51][69];
  ((Coef_v45_v51_h_prev_C51 *) pCurCoefItem->pCoefObject)->i5ct_ = a[Ind_i5ct][69];
  pCurCoefItem = pCurCoefItem->pNextCoefItem;
  ((Coef_v56_v45_h_prev_C52 *) pCurCoefItem->pCoefObject)->v56_ = a[Ind_v56][69];
  ((Coef_v56_v45_h_prev_C52 *) pCurCoefItem->pCoefObject)->v45_ = a[Ind_v45][69];
  ((Coef_v56_v45_h_prev_C52 *) pCurCoefItem->pCoefObject)->i5cb_ = a[Ind_i5cb][69];
  pCurCoefItem = pCurCoefItem->pNextCoefItem;
  ((Coef_v61_v67_h_prev_C6 *) pCurCoefItem->pCoefObject)->v61_ = a[Ind_v61][69];
  ((Coef_v61_v67_h_prev_C6 *) pCurCoefItem->pCoefObject)->v67_ = a[Ind_v67][69];
  ((Coef_v61_v67_h_prev_C6 *) pCurCoefItem->pCoefObject)->i6_ = a[Ind_i6][69];
  pCurCoefItem = pCurCoefItem->pNextCoefItem;
  ((Coef_v56_v61_h_prev_C61 *) pCurCoefItem->pCoefObject)->v56_ = a[Ind_v56][69];
  ((Coef_v56_v61_h_prev_C61 *) pCurCoefItem->pCoefObject)->v61_ = a[Ind_v61][69];
  ((Coef_v56_v61_h_prev_C61 *) pCurCoefItem->pCoefObject)->i6ct_ = a[Ind_i6ct][69];
  pCurCoefItem = pCurCoefItem->pNextCoefItem;
  ((Coef_v67_v56_h_prev_C62 *) pCurCoefItem->pCoefObject)->v67_ = a[Ind_v67][69];
  ((Coef_v67_v56_h_prev_C62 *) pCurCoefItem->pCoefObject)->v56_ = a[Ind_v56][69];
  ((Coef_v67_v56_h_prev_C62 *) pCurCoefItem->pCoefObject)->i6cb_ = a[Ind_i6cb][69];
  pCurCoefItem = pCurCoefItem->pNextCoefItem;
  ((Coef_v71_v78_h_prev_C7 *) pCurCoefItem->pCoefObject)->v71_ = a[Ind_v71][69];
  ((Coef_v71_v78_h_prev_C7 *) pCurCoefItem->pCoefObject)->v78_ = a[Ind_v78][69];
  ((Coef_v71_v78_h_prev_C7 *) pCurCoefItem->pCoefObject)->i7_ = a[Ind_i7][69];
  pCurCoefItem = pCurCoefItem->pNextCoefItem;
  ((Coef_v67_v71_h_prev_C71 *) pCurCoefItem->pCoefObject)->v67_ = a[Ind_v67][69];
  ((Coef_v67_v71_h_prev_C71 *) pCurCoefItem->pCoefObject)->v71_ = a[Ind_v71][69];
  ((Coef_v67_v71_h_prev_C71 *) pCurCoefItem->pCoefObject)->i7ct_ = a[Ind_i7ct][69];
  pCurCoefItem = pCurCoefItem->pNextCoefItem;
  ((Coef_v78_v67_h_prev_C72 *) pCurCoefItem->pCoefObject)->v78_ = a[Ind_v78][69];
  ((Coef_v78_v67_h_prev_C72 *) pCurCoefItem->pCoefObject)->v67_ = a[Ind_v67][69];
  ((Coef_v78_v67_h_prev_C72 *) pCurCoefItem->pCoefObject)->i7cb_ = a[Ind_i7cb][69];
  pCurCoefItem = pCurCoefItem->pNextCoefItem;
  ((Coef_v81_h_prev_plus_MinusBus_C8 *) pCurCoefItem->pCoefObject)->v81_ = a[Ind_v81][69];
  ((Coef_v81_h_prev_plus_MinusBus_C8 *) pCurCoefItem->pCoefObject)->i8_ = a[Ind_i8][69];
  pCurCoefItem = pCurCoefItem->pNextCoefItem;
  ((Coef_v78_v81_h_prev_C81 *) pCurCoefItem->pCoefObject)->v78_ = a[Ind_v78][69];
  ((Coef_v78_v81_h_prev_C81 *) pCurCoefItem->pCoefObject)->v81_ = a[Ind_v81][69];
  ((Coef_v78_v81_h_prev_C81 *) pCurCoefItem->pCoefObject)->i8ct_ = a[Ind_i8ct][69];
  pCurCoefItem = pCurCoefItem->pNextCoefItem;
  ((Coef_minus_v78_h_prev_minus_MinusBus_C82 *) pCurCoefItem->pCoefObject)->v78_ = a[Ind_v78][69];
  ((Coef_minus_v78_h_prev_minus_MinusBus_C82 *) pCurCoefItem->pCoefObject)->i8cb_ = a[Ind_i8cb][69];

}





// ---------------------------------------------------------------

// **************************************************************

 
                                                                                  

// **** SimuObject ************************************************




SimuObject Simulation;

SimuObject::SimuObject(void)
{
  OdeObjItem * pCurOdeItem;
  SrcObjItem * pCurSrcItem;
  CtrlObjItem * pCurCtrlItem;
  CtrlObjGroup * pCurCtrlGroup;
  CoefObjItem * pCurCoefItem;         
  SpiceObjItem * pCurSpiceItem;
  SwitchObjItem * pCurSwitchItem;


  int i;


  SimuTime = .2;

  
  MinimumPlotTime = 0;
  MaximumPlotTime = 1;



  ExceptionTime = .05;

  //For this example the setting of "RelTol" is important. If it is set to large
  //the system will become unstable. 
  RelTol =  .0000000001;
  //Setting "AbsTol" too small will make a system with a decaying oscillation 
  //take too long to finish.
  AbsTol =  .0000000000001;
  //typical error correction setting as per "RungeKutta_java.htm" (never set higher then "1.0")
  Safety = .98;
//  h_start = .000000001;
// !!!!!!!!!!!! TEMPORARY !!!!!!!!!!!!!!!!!!1
  h_start = .00000064;		//App_NgSpiceTest.cir produces 93868 steps over 60 mSec. We will match this here
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!1

  h = h_start;


// !!!!!!!!!!!! TEMPORARY !!!!!!!!!!!!!!!!!!1
  OdeSimuFixed = true;		//Run fixed mode. We do not have adaptive time stepping workin yet for Spice mode.


// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!1



  //set to a value other then "0" to clamp maximum "h";
//  h_max = .0000002;
// !!!!!!!!!!!! TEMPORARY !!!!!!!!!!!!!!!!!!1
  h_max = .00000064;
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!


  //set to store and plot "h" parameter.
  Do_h_Plot = 1;
  
  TimeQuantum = h;
  CtrlTimeQuantum = QUANTUM_PERIOD;

  //set tp force CTRL update on first ODE update.
  CtrlTimeAccumulator = 0;

  SrcPeriodQuantum = QUANTUM_PERIOD;
  SrcPeriodAccumulator = 0;
 

  //build the SRC equation list
  pSrcEquationList = new SrcObjItem;
  pCurSrcItem = pSrcEquationList;
  i = 0;
  while(SrcObjectList[i]){
    pCurSrcItem->pSrcObject = SrcObjectList[i];
    i++;
    if(!SrcObjectList[i])
      break;
    pCurSrcItem->pNextSrcItem = new SrcObjItem;
    pCurSrcItem = pCurSrcItem->pNextSrcItem;


  }

  //build the ODE equation list.
  pOdeEquationList = new OdeObjItem;
  pCurOdeItem = pOdeEquationList;
  i = 0;
  while(1){
    pCurOdeItem->pOdeObject = OdeObjectList[i];
    i++;
    if(!OdeObjectList[i])
      break;
    pCurOdeItem->pNextOdeItem = new OdeObjItem;
    pCurOdeItem = pCurOdeItem->pNextOdeItem;
  }



  if(CtrlObjectList[0]){

    pCtrlGroupList = new CtrlObjGroup;
    pCurCtrlGroup = pCtrlGroupList;

    pCurCtrlGroup->pCtrlEquationList = new CtrlObjItem;
    pCurCtrlItem = pCurCtrlGroup->pCtrlEquationList;
    //set tp force CTRL update on first ODE update.
    pCurCtrlGroup->QuantumCount = 1;
    pCurCtrlGroup->QuantumNum = CtrlObjectQuantum[0];

    i = 0;
    while(1){
      pCurCtrlItem->pCtrlObject = CtrlObjectList[i];   
      i++;
      if(!CtrlObjectList[i])                 
	break;

      if(CtrlObjectQuantum[i] == CtrlObjectQuantum[i-1]){
	pCurCtrlItem->pNextCtrlItem = new CtrlObjItem;
	pCurCtrlItem = pCurCtrlItem->pNextCtrlItem;
      }
      else{
	//create a new group...
	pCtrlGroupList->pNextCtrlGroup = new CtrlObjGroup;
	pCurCtrlGroup = pCtrlGroupList->pNextCtrlGroup;

	pCurCtrlGroup->pCtrlEquationList = new CtrlObjItem;
	pCurCtrlItem = pCurCtrlGroup->pCtrlEquationList;
	//set tp force CTRL update on first ODE update.
	pCurCtrlGroup->QuantumCount = 1;
	pCurCtrlGroup->QuantumNum = CtrlObjectQuantum[i];  
      }
    }
  }

  //build the COEF equation list.              //NOTE: The COEF list is used only for exception processing.
  pCoefEquationList = new CoefObjItem;
  pCurCoefItem = pCoefEquationList;
  i = 0;
  while(1){
    pCurCoefItem->pCoefObject = CoefObjectList[i];
    i++;
    if(!CoefObjectList[i])
      break;
    pCurCoefItem->pNextCoefItem = new CoefObjItem;
    pCurCoefItem = pCurCoefItem->pNextCoefItem;
  }



  //build the SPICE equation list.
  pSpiceEquationList = new SpiceObjItem;
  pCurSpiceItem = pSpiceEquationList;
  i = 0;
  while(1){
    pCurSpiceItem->pSpiceObject = SpiceObjectList[i];
    i++;
    if(!SpiceObjectList[i])
      break;
    pCurSpiceItem->pNextSpiceItem = new SpiceObjItem;
    pCurSpiceItem = pCurSpiceItem->pNextSpiceItem;
  }
 
  //build the SWITCH equation list.
  pSwitchEquationList = new SwitchObjItem;
  pCurSwitchItem = pSwitchEquationList;
  i = 0;
  while(1){
    pCurSwitchItem->pSwitchObject = SwitchObjectList[i];
    i++;
    if(!SwitchObjectList[i])
      break;
    pCurSwitchItem->pNextSwitchItem = new SwitchObjItem;
    pCurSwitchItem = pCurSwitchItem->pNextSwitchItem;
  }





}

SimuObject::~SimuObject(void)
{

  //(ideally we should delete all make allocation make in the constructor, here)

}



// ************************************************************






bool ExecuteSimulation(void)
{

   

  Simulation.OdeSimuType = ODE_SIMU_56;

  while(Simulation.t < Simulation.SimuTime){               

    if(!Simulation.DoOneInteration())
      return FALSE;
    
  }
  if(Simulation.GotException){
    cout << Simulation.ExceptionMessageBuffer.str().c_str();
  }

  return TRUE;
}

void PlotResults(string TagNamesToPlot[], double ScaleFactors[], double MinPlotTimes[], double MaxPlotTimes[], 
		 double PlotTimeSteps[], double PlotTimeOffset)
{
  Simulation.PlotSimuResults(TagNamesToPlot, ScaleFactors, MinPlotTimes, MaxPlotTimes, PlotTimeSteps, PlotTimeOffset);


}
