 
     
                  
//
//
//
//                                                                                             ----- vm_a
//                                                                                            |
//     vs_a ---<CM-inductor phase a>------------<Inductor phase a>--------<RLa>-------------- +-------------<Ra>---<Ca>---
//                      |                                                                     |                           |
//                      |                                                                     |                           |
//                      |                                                                     |    ----- vm_b             |
//                      |                                                                     |   |                       |             
//     vs_b ---<CM-inductor phase b>------------<Inductor phase b>--------<RLb>-------------------+---------<Rb>---<Cb>---|-----
//                      |                                                                     |   |                       |     |
//                      |                                                                     |   |                       |    GND
//                      |                                                                     |   |    ----- vm_c         |
//                      |                                                                     |   |   |                   |             
//     vs_c ---<CM-inductor phase b>------------<Inductor phase c>--------<RLc>-----------------------+-----<Rc>---<Cc>---
//                                                                                            |   |   |
//                                                                                            |   |   |
//    vs_a1 ---<CM-inductor phase a1>-----------<Inductor phase a1>-------<RL1a>--------------    |   |
//                      |                                                                         |   |                  
//                      |                                                                         |   |                   
//                      |                                                                         |   |    
//                      |                                                                         |   |                             
//    vs_b1 ---<CM-inductor phase b1>-----------<Inductor phase b1>-------<RL1b>------------------    |
//                      |                                                                             |                        
//                      |                                                                             |                       
//                      |                                                                             |  
//                      |                                                                             |                               
//    vs_c1 ---<CM-inductor phase b1>-----------<Inductor phase c1>-------<RL1c>----------------------
//
//
//
//




typedef enum {
  ODE_FUNC_NULL = -1,
  ODE_FUNC_Qa,
  ODE_FUNC_Qb,
  ODE_FUNC_Qc,
  ODE_FUNC_QQa_QQb_QQc_1,
  ODE_FUNC_QQa_QQb_QQc_2,
  ODE_FUNC_QQa_QQb_QQc_3,
  ODE_FUNC_QQa_QQb_QQc1_1,
  ODE_FUNC_QQa_QQb_QQc1_2,
  ODE_FUNC_QQa_QQb_QQc1_3,

  
} ODE_FUNCTION;


typedef enum {
  CTRL_FUNC_NULL = -1,
  CTRL_FUNC_RefA,
  CTRL_FUNC_RefB,
  CTRL_FUNC_RefC,
  CTRL_FUNC_RefA1,
  CTRL_FUNC_RefB1,
  CTRL_FUNC_RefC1,


} CTRL_FUNCTION;


typedef enum {
  SRC_FUNC_NULL = -1,
  SRC_FUNC_VSrc3Phase,

} SRC_FUNCTION;


#include "Simulation.hpp" 


//Parameters....

#define Mab  .098e-3          
#define Mbc  Mab
#define Mac  Mab
#define Mab1  .098e-3         
#define Mbc1  Mab
#define Mac1  Mab



#define Lm_a  .1e-3             
#define Lm_b  Lm_a
#define Lm_c  Lm_a
#define Lm_a1  .1e-3               
#define Lm_b1  Lm_a
#define Lm_c1  Lm_a



#define La .1e-3            
#define Lb La
#define Lc La
#define La1 .1e-3             
#define Lb1 La
#define Lc1 La

#define RLa   .1
#define RLb   .1
#define RLc   .1
#define RL1a  .1
#define RL1b  .1
#define RL1c  .1





#define Ra 10.0   //Now, with the right setting of "RelTol" and "AbsTol", putting a "1.0" gives us an accurate plot that simulates fast!!! 
#define Rb Ra
#define Rc Ra

#define Ca .3e-6  
#define Cb Ca
#define Cc Ca

#define QUARTER_PWM_CYCLE .001         
#define PWM_GAIN 5.0

#define DC_BUS_VOLTAGE 100.0

#define SRC_SLEW_RATE 50000000.0  //volts/sec


// **** SrcObject Classes ********************************

// ---- VSrc3Phase ---------------------------------------

class VSrc3Phase : public SrcObject
{
public:
  virtual void SrcFunction(double t);
  virtual void OdeRValueUpdate(void);
  VSrc3Phase(void);
  ~VSrc3Phase(void);
  double t_mod;
  double t_prev;
  double PwmRampDir;
  



};


VSrc3Phase Inst_VSrc3Phase;


// --------------------------------------------------------

SrcObject * SrcObjectList[] = {(SrcObject *) &Inst_VSrc3Phase,
			       0};


// ***********************************************************

// **** OdeObject Classes ********************************

// ---- Qa -----------------------------------------

class Qa : public OdeObject
{
public:
  virtual double OdeFunction(double y, double t);
  virtual void OdeRValueUpdate(void);
  Qa(void);
  ~Qa(void);
  //source for this ODE
  double qqa;
  double qqa1;

};

Qa Inst_Qa;


// --------------------------------------------------------

// ---- Qb -----------------------------------------

class Qb : public OdeObject
{
public:
  virtual double OdeFunction(double y, double t);
  virtual void OdeRValueUpdate(void);
  Qb(void);
  ~Qb(void);
  //source for this ODE
  double qqb;
  double qqb1;

};

Qb Inst_Qb;


// --------------------------------------------------------

// ---- Qc -----------------------------------------

class Qc : public OdeObject
{
public:
  virtual double OdeFunction(double y, double t);
  virtual void OdeRValueUpdate(void);
  Qc(void);
  ~Qc(void);
  //source for this ODE
  double qqc;
  double qqc1;

};

Qc Inst_Qc;


// --------------------------------------------------------

// ---- QQa_QQb_QQc_1 -----------------------------------------

class QQa_QQb_QQc_1 : public OdeObject
{
public:
  virtual double OdeFunction(double y, double t);
  virtual void OdeRValueUpdate(void);
  virtual void OdeGroupMSolve(double dydt[],  double dmdt[]);
  //we use some probes in this object to get a better understanding
  //of what is going on.
  virtual void RecordProbes(void);
  virtual void PlotProbes(Gnuplot & SimuPlot, vector<double> & Plot_t, string TagNamesToPlot[]);
  QQa_QQb_QQc_1(void);
  ~QQa_QQb_QQc_1(void);
  //source for this ODE
  double Ref_a;
  double Pwm_sig;
  double qqa1;
  double qa;
  double vs_a;
  //storage for probes...
  //(NOTE: "qa" below is really the Integral(qqa + qqa1)
  vector<double> Vcm_a;    //for expression "vs_a - L_a*dqqa - RLa*qqa - Ra*(qqa + qqa1) - qa/Ca" 
  vector<double> C_a;      //for expression "qa/Ca"
  vector<double> R_a;      //for expression "Ra*(qqa + qqa1)
  vector<double> VL_a;    //for expression "L_a*dqqa"
  vector<double> VBus_a;   //"vs_a" (processed DC_BUS_VOLTAGE or - DC_BUS_VOLTAGE depending on reference value)
};

QQa_QQb_QQc_1 Inst_QQa_QQb_QQc_1;


// --------------------------------------------------------

// ---- QQa_QQb_QQc_2 -----------------------------------------

class QQa_QQb_QQc_2 : public OdeObject
{
public:
  virtual double OdeFunction(double y, double t);
  virtual void OdeRValueUpdate(void);
  //we use some probes in this object to get a better understanding
  //of what is going on.
  virtual void RecordProbes(void);
  virtual void PlotProbes(Gnuplot & SimuPlot, vector<double> & Plot_t, string TagNamesToPlot[]);
  QQa_QQb_QQc_2(void);
  ~QQa_QQb_QQc_2(void);
  //source for this ODE
  double vs_b;
  double Ref_b;
  double Pwm_sig;
  double qqb1;
  double qb;
  //storage for probes...
  //(NOTE: "qb" below is really the Integral(qqb + qqb1)
  vector<double> Vcm_b;    //for expression "vs_b - L_b*dqqb - RLb*qqb - Rb*(qqb + qqb1) - qb/Cb" 
  vector<double> C_b;      //for expression "qb/Cb"
  vector<double> R_b;      //for expression "Rb*(qqb + qqb1)
  vector<double> VL_b;    //for expression "L_b*dqqb"
  vector<double> VBus_b;   //"vs_b" (processed DC_BUS_VOLTAGE or - DC_BUS_VOLTAGE depending on reference value)

};

QQa_QQb_QQc_2 Inst_QQa_QQb_QQc_2;


// --------------------------------------------------------


// ---- QQa_QQb_QQc_3 -----------------------------------------

class QQa_QQb_QQc_3 : public OdeObject
{
public:
  virtual double OdeFunction(double y, double t);
  virtual void OdeRValueUpdate(void);
  //we use some probes in this object to get a better understanding
  //of what is going on.
  virtual void RecordProbes(void);
  virtual void PlotProbes(Gnuplot & SimuPlot, vector<double> & Plot_t, string TagNamesToPlot[]);
  QQa_QQb_QQc_3(void);
  ~QQa_QQb_QQc_3(void);
  //source for this ODE
  double vs_c;
  double Ref_c;
  double Pwm_sig;
  double qqc1;
  double qc;
  //storage for probes...
  //(NOTE: "qc" below is really the Integral(qqc + qqc1)
  vector<double> Vcm_c;    //for expression "vs_c - L_c*dqqc - RLc*qqc - Rc*(qqc + qqc1) - qc/Cc" 
  vector<double> C_c;      //for expression "qc/Cc"
  vector<double> R_c;      //for expression "Rc*(qqc + qqc1)
  vector<double> VL_c;    //for expression "L_c*dqqc"
  vector<double> VBus_c;   //"vs_c" (processed DC_BUS_VOLTAGE or - DC_BUS_VOLTAGE depending on reference value)

};

QQa_QQb_QQc_3 Inst_QQa_QQb_QQc_3;

            


// --------------------------------------------------------


// ---- QQa_QQb_QQc1_1 -----------------------------------------

class QQa_QQb_QQc1_1 : public OdeObject
{
public:
  virtual double OdeFunction(double y, double t);
  virtual void OdeRValueUpdate(void);
  virtual void OdeGroupMSolve(double dydt[],  double dmdt[]);
  //we use some probes in this object to get a better understanding
  //of what is going on.
  virtual void RecordProbes(void);
  virtual void PlotProbes(Gnuplot & SimuPlot, vector<double> & Plot_t, string TagNamesToPlot[]);
  QQa_QQb_QQc1_1(void);
  ~QQa_QQb_QQc1_1(void);
  //source for this ODE
  double vs_a1;
  double Ref_a1;
  double Pwm_sig;
  double qqa;
  double qa;
  //storage for probes...
  //(NOTE: "qa" below is really the Integral(qqa + qqa1)
  vector<double> Vcm_a1;    //for expression "vs_a1 - L_a1*dqqa1 - RLa1*qqa1 - Ra*(qqa + qqa1) - qa/Ca" 
  vector<double> VL_a1;    //for expression "L_a1*dqqa1"
  vector<double> VBus_a1;   //"vs_a1" (processed DC_BUS_VOLTAGE or - DC_BUS_VOLTAGE depending on reference value)




 
};

QQa_QQb_QQc1_1 Inst_QQa_QQb_QQc1_1;


// --------------------------------------------------------


// ---- QQa_QQb_QQc1_2 -----------------------------------------

class QQa_QQb_QQc1_2 : public OdeObject
{
public:
  virtual double OdeFunction(double y, double t);
  virtual void OdeRValueUpdate(void);
  //we use some probes in this object to get a better understanding
  //of what is going on.
  virtual void RecordProbes(void);
  virtual void PlotProbes(Gnuplot & SimuPlot, vector<double> & Plot_t, string TagNamesToPlot[]);
  QQa_QQb_QQc1_2(void);
  ~QQa_QQb_QQc1_2(void);
  //source for this ODE
  double vs_b1;
  double Ref_b1;
  double Pwm_sig;
  double qqb;
  double qb;
  //storage for probes...
  //(NOTE: "qb" below is really the Integral(qqb + qqb1)
  vector<double> Vcm_b1;    //for expression "vs_b1 - L_b1*dqqb1 - RLb1*qqb1 - Rb*(qqb + qqb1) - qb/Cb" 
  vector<double> VL_b1;    //for expression "L_b1*dqqb1"
  vector<double> VBus_b1;   //"vs_b1" (processed DC_BUS_VOLTAGE or - DC_BUS_VOLTAGE depending on reference value)

};

QQa_QQb_QQc1_2 Inst_QQa_QQb_QQc1_2;


// --------------------------------------------------------


// ---- QQa_QQb_QQc1_3 -----------------------------------------

class QQa_QQb_QQc1_3 : public OdeObject
{
public:
  virtual double OdeFunction(double y, double t);
  virtual void OdeRValueUpdate(void);
  //we use some probes in this object to get a better understanding
  //of what is going on.
  virtual void RecordProbes(void);
  virtual void PlotProbes(Gnuplot & SimuPlot, vector<double> & Plot_t, string TagNamesToPlot[]);
  QQa_QQb_QQc1_3(void);
  ~QQa_QQb_QQc1_3(void);
  //source for this ODE
  double vs_c1;
  double Ref_c1;
  double Pwm_sig;
  double qqc;
  double qc;
  //storage for probes...
  //(NOTE: "qc" below is really the Integral(qqc + qqc1)
  vector<double> Vcm_c1;    //for expression "vs_c1 - L_c1*dqqc1 - RLc1*qqc1 - Rc*(qqc + qqc1) - qc/Cc" 
  vector<double> VL_c1;    //for expression "L_c1*dqqc1"
  vector<double> VBus_c1;   //"vs_c1" (processed DC_BUS_VOLTAGE or - DC_BUS_VOLTAGE depending on reference value)

};

QQa_QQb_QQc1_3 Inst_QQa_QQb_QQc1_3;


// --------------------------------------------------------


OdeObject * OdeObjectList[] = {(OdeObject *) &Inst_Qa,
			       (OdeObject *) &Inst_Qb,
			       (OdeObject *) &Inst_Qc,
			       (OdeObject *) &Inst_QQa_QQb_QQc_1, //the next three are in a group and must be maintained in this order.
			       (OdeObject *) &Inst_QQa_QQb_QQc_2,
			       (OdeObject *) &Inst_QQa_QQb_QQc_3,
			       (OdeObject *) &Inst_QQa_QQb_QQc1_1, //the next three are in a group and must be maintained in this order.
			       (OdeObject *) &Inst_QQa_QQb_QQc1_2,
			       (OdeObject *) &Inst_QQa_QQb_QQc1_3,
			       0};





// ***********************************************************

    

// **** CtrlObject Classes (Translation) *********************

// ---- RefA  ---------------------------------------------

class RefA : public CtrlObject
{
public:
  virtual void CtrlFunction(double t);
  virtual void OdeRValueUpdate(void);
  RefA(void);
  ~RefA(void);

};



RefA Inst_RefA;

// -------------------------------------------------------------

// ---- RefB  ---------------------------------------------

class RefB : public CtrlObject
{
public:
  virtual void CtrlFunction(double t);
  virtual void OdeRValueUpdate(void);
  RefB(void);
  ~RefB(void);

};



RefB Inst_RefB;

// -------------------------------------------------------------


// ---- RefC  ---------------------------------------------

class RefC : public CtrlObject
{
public:
  virtual void CtrlFunction(double t);
  virtual void OdeRValueUpdate(void);
  RefC(void);
  ~RefC(void);

};



RefC Inst_RefC;

// -------------------------------------------------------------



// ---- RefA1  ---------------------------------------------

class RefA1 : public CtrlObject
{
public:
  virtual void CtrlFunction(double t);
  virtual void OdeRValueUpdate(void);
  RefA1(void);
  ~RefA1(void);

};



RefA1 Inst_RefA1;

// -------------------------------------------------------------



// ---- RefB1  ---------------------------------------------

class RefB1 : public CtrlObject
{
public:
  virtual void CtrlFunction(double t);
  virtual void OdeRValueUpdate(void);
  RefB1(void);
  ~RefB1(void);

};



RefB1 Inst_RefB1;

// -------------------------------------------------------------


// ---- RefC1  ---------------------------------------------

class RefC1 : public CtrlObject
{
public:
  virtual void CtrlFunction(double t);
  virtual void OdeRValueUpdate(void);
  RefC1(void);
  ~RefC1(void);

};



RefC1 Inst_RefC1;

// -------------------------------------------------------------


CtrlObject * CtrlTranObjectList[] = {(CtrlObject *) &Inst_RefA,
				     (CtrlObject *) &Inst_RefB,
				     (CtrlObject *) &Inst_RefC,
                                     (CtrlObject *) &Inst_RefA1,
				     (CtrlObject *) &Inst_RefB1,
				     (CtrlObject *) &Inst_RefC1,
				     0};

// **************************************************************

// **** CtrlObject Classes (Trajectory) **************************

// "CtrlTrajObjectList[]" added here.
// ***************************************************************


// **** SrcObject Functions **************************************

// ---- VSrc3Phase  ----------------------------------------------------

VSrc3Phase::VSrc3Phase(void)
{
 
  OdeObjItem * pCurOdeItem;
 

  SrcFuncName = SRC_FUNC_VSrc3Phase;


  //build the ODE Rvalue list.

  pOdeObjRValList = new OdeObjItem;
  pCurOdeItem = pOdeObjRValList;

  pCurOdeItem->pOdeObject = OdeObjectList[ODE_FUNC_QQa_QQb_QQc_1];
  pCurOdeItem->pNextOdeItem = new OdeObjItem;
  pCurOdeItem = pCurOdeItem->pNextOdeItem;
  pCurOdeItem->pOdeObject = OdeObjectList[ODE_FUNC_QQa_QQb_QQc_2];
  pCurOdeItem->pNextOdeItem = new OdeObjItem;
  pCurOdeItem = pCurOdeItem->pNextOdeItem;
  pCurOdeItem->pOdeObject = OdeObjectList[ODE_FUNC_QQa_QQb_QQc_3];
  pCurOdeItem->pNextOdeItem = new OdeObjItem;
  pCurOdeItem = pCurOdeItem->pNextOdeItem;
  pCurOdeItem->pOdeObject = OdeObjectList[ODE_FUNC_QQa_QQb_QQc1_1];
  pCurOdeItem->pNextOdeItem = new OdeObjItem;
  pCurOdeItem = pCurOdeItem->pNextOdeItem;
  pCurOdeItem->pOdeObject = OdeObjectList[ODE_FUNC_QQa_QQb_QQc1_2];
  pCurOdeItem->pNextOdeItem = new OdeObjItem;
  pCurOdeItem = pCurOdeItem->pNextOdeItem;
  pCurOdeItem->pOdeObject = OdeObjectList[ODE_FUNC_QQa_QQb_QQc1_3];


  PwmRampDir = 1.0;

  //  PlotThisOutput = TRUE;
  Plot_Tag = "VSrc";
}

VSrc3Phase::~VSrc3Phase(void)
{



}

void VSrc3Phase::SrcFunction(double t)
{
  t_mod += (t - t_prev);
  t_prev = t;

  if(t_mod > QUARTER_PWM_CYCLE){
    t_mod -=  QUARTER_PWM_CYCLE;
    PwmRampDir *= -1.0;
  }

  y = PWM_GAIN*(t_mod/QUARTER_PWM_CYCLE - .5)*PwmRampDir;

}

void VSrc3Phase::OdeRValueUpdate(void)
{
  OdeObjItem * pCurOdeItem;

  //Update Rvalues
  pCurOdeItem = pOdeObjRValList;

  ((QQa_QQb_QQc_1 *) pCurOdeItem->pOdeObject)->Pwm_sig= y;
  pCurOdeItem = pCurOdeItem->pNextOdeItem;    
  ((QQa_QQb_QQc_2 *) pCurOdeItem->pOdeObject)->Pwm_sig= y;
  pCurOdeItem = pCurOdeItem->pNextOdeItem;    
  ((QQa_QQb_QQc_3 *) pCurOdeItem->pOdeObject)->Pwm_sig= y;
  pCurOdeItem = pCurOdeItem->pNextOdeItem;   
  ((QQa_QQb_QQc1_1 *) pCurOdeItem->pOdeObject)->Pwm_sig= y;
  pCurOdeItem = pCurOdeItem->pNextOdeItem;    
  ((QQa_QQb_QQc1_2 *) pCurOdeItem->pOdeObject)->Pwm_sig= y;
  pCurOdeItem = pCurOdeItem->pNextOdeItem;    
  ((QQa_QQb_QQc1_3 *) pCurOdeItem->pOdeObject)->Pwm_sig= y;

 

}




// -----------------------------------------------------------------

// ***************************************************************


// **** OdeObject Functions **************************************

// ---- Qa  ----------------------------------------------------

Qa::Qa(void)
{

  OdeObjItem * pCurOdeItem;

  OdeFuncName = ODE_FUNC_Qa;
  

  //build the ODE Rvalue list.

  pOdeObjRValList = new OdeObjItem;          
  pCurOdeItem = pOdeObjRValList;

  pCurOdeItem->pOdeObject = OdeObjectList[ODE_FUNC_QQa_QQb_QQc_1];
  pCurOdeItem->pNextOdeItem = new OdeObjItem;
  pCurOdeItem = pCurOdeItem->pNextOdeItem;
  pCurOdeItem->pOdeObject = OdeObjectList[ODE_FUNC_QQa_QQb_QQc1_1];

  qqa = 0;
  qqa1 = 0;
  
  //  PlotThisOutput = TRUE;
  Plot_Tag = "Qa";

}

Qa::~Qa(void)
{

}

double Qa::OdeFunction(double y, double t)
{
  return(qqa + qqa1);
}

void Qa::OdeRValueUpdate(void)
{
  OdeObjItem * pCurOdeItem;

  //Update Rvalues
  pCurOdeItem = pOdeObjRValList;

  ((QQa_QQb_QQc_1 *) pCurOdeItem->pOdeObject)->qa = y;
  pCurOdeItem = pCurOdeItem->pNextOdeItem; 
  ((QQa_QQb_QQc1_1 *) pCurOdeItem->pOdeObject)->qa = y;    


}

// -----------------------------------------------------------------



// ---- Qb  ----------------------------------------------------

Qb::Qb(void)
{

  OdeObjItem * pCurOdeItem;

  OdeFuncName = ODE_FUNC_Qb;
  

  //build the ODE Rvalue list.

  pOdeObjRValList = new OdeObjItem;          
  pCurOdeItem = pOdeObjRValList;

  pCurOdeItem->pOdeObject = OdeObjectList[ODE_FUNC_QQa_QQb_QQc_2];
  pCurOdeItem->pNextOdeItem = new OdeObjItem;
  pCurOdeItem = pCurOdeItem->pNextOdeItem;
  pCurOdeItem->pOdeObject = OdeObjectList[ODE_FUNC_QQa_QQb_QQc1_2];

  qqb = 0;
  qqb1 = 0;

  //  PlotThisOutput = TRUE;
  Plot_Tag = "Qb";

}


Qb::~Qb(void)
{

}

double Qb::OdeFunction(double y, double t)
{
  return(qqb + qqb1);
}

void Qb::OdeRValueUpdate(void)
{
  OdeObjItem * pCurOdeItem;

  //Update Rvalues
  pCurOdeItem = pOdeObjRValList;

  ((QQa_QQb_QQc_2 *) pCurOdeItem->pOdeObject)->qb = y;
  pCurOdeItem = pCurOdeItem->pNextOdeItem;
  ((QQa_QQb_QQc1_2 *) pCurOdeItem->pOdeObject)->qb = y;

}

// -----------------------------------------------------------------


// ---- Qc  ----------------------------------------------------



Qc::Qc(void)
{

  OdeObjItem * pCurOdeItem;

  OdeFuncName = ODE_FUNC_Qc;
  

  //build the ODE Rvalue list.

  pOdeObjRValList = new OdeObjItem;          
  pCurOdeItem = pOdeObjRValList;

  pCurOdeItem->pOdeObject = OdeObjectList[ODE_FUNC_QQa_QQb_QQc_3];
  pCurOdeItem->pNextOdeItem = new OdeObjItem;
  pCurOdeItem = pCurOdeItem->pNextOdeItem;
  pCurOdeItem->pOdeObject = OdeObjectList[ODE_FUNC_QQa_QQb_QQc1_3];

  qqc = 0;
  qqc1 = 0;

  //  PlotThisOutput = TRUE;
  Plot_Tag = "Qc";

}
Qc::~Qc(void)
{

}

double Qc::OdeFunction(double y, double t)
{
  return(qqc + qqc1);
}

void Qc::OdeRValueUpdate(void)
{
  OdeObjItem * pCurOdeItem;

  //Update Rvalues
  pCurOdeItem = pOdeObjRValList;

  ((QQa_QQb_QQc_3 *) pCurOdeItem->pOdeObject)->qc = y;
  pCurOdeItem = pCurOdeItem->pNextOdeItem;
  ((QQa_QQb_QQc1_3 *) pCurOdeItem->pOdeObject)->qc = y;

}

// -----------------------------------------------------------------

// ---- QQa_QQb_QQc_1  ----------------------------------------------------

QQa_QQb_QQc_1::QQa_QQb_QQc_1(void)
{
  OdeObjItem * pCurOdeItem;

  OdeFuncName = ODE_FUNC_QQa_QQb_QQc_1;
 
  

  //this object marks the beginning of a "group solve" of
  //three objects.
  GroupSolve = 1;
  NumberOfGrpOdes = 3;

  //build the ODE Rvalue list.
 
  pOdeObjRValList = new OdeObjItem;
  pCurOdeItem = pOdeObjRValList;

  pCurOdeItem->pOdeObject = OdeObjectList[ODE_FUNC_Qa];
  pCurOdeItem->pNextOdeItem = new OdeObjItem;
  pCurOdeItem = pCurOdeItem->pNextOdeItem;
  pCurOdeItem->pOdeObject = OdeObjectList[ODE_FUNC_QQa_QQb_QQc1_1];


  Ref_a = 0;
  Pwm_sig = 0;
  qqa1 = 0;
  qa = 0;

  PlotThisOutput = TRUE;
  Plot_Tag = "QQa";
  DoProbes = TRUE;
  
}

QQa_QQb_QQc_1::~QQa_QQb_QQc_1(void)
{

}

  

double QQa_QQb_QQc_1::OdeFunction(double y, double t)
{
  //Note: This is within a "group" ODE so we are really solving for "dm/dt"

          //"vs_a - RLa*qqa - Ra*(qqa + qqa1) - qa/Ca" 
  vs_a = ShapeSquareWaveSource(((Ref_a > Pwm_sig) ? DC_BUS_VOLTAGE : - DC_BUS_VOLTAGE), SRC_SLEW_RATE ,t);
  return(vs_a - RLa*y - Ra*(y + qqa1) - qa/Ca);
}

void QQa_QQb_QQc_1::RecordProbes(void)
{
  //value for "vs_a - L_a*dqqa - RLa*qqa - Ra*(qqa + qqa1) - qa/Ca"
  Vcm_a.push_back(vs_a - La*dydt - RLa*y - Ra*(y + qqa1) - qa/Ca);
  C_a.push_back(qa/Ca);
  VBus_a.push_back(vs_a);
  VL_a.push_back(La*dydt);   
  R_a.push_back(Ra*(y + qqa1));   
  
  
}

void QQa_QQb_QQc_1 ::PlotProbes(Gnuplot & SimuPlot, vector<double> & Plot_t, string TagNamesToPlot[])
{
  int i;
  if(TagNamesToPlot[0] == ""){
    SimuPlot.plot_xy(Plot_t, Vcm_a, "Vcm_a");
    SimuPlot.plot_xy(Plot_t, C_a, "C_a");
    SimuPlot.plot_xy(Plot_t, VBus_a, "VBus_a");
    SimuPlot.plot_xy(Plot_t, VL_a, "VL_a");   
    SimuPlot.plot_xy(Plot_t, R_a, "R_a");  
  }
  else{
    for(i = 0; i < 20; i++){
      if(TagNamesToPlot[i] == "Vcm_a"){
	SimuPlot.plot_xy(Plot_t, Vcm_a, "Vcm_a");
      }
      else if(TagNamesToPlot[i] == "C_a"){
	SimuPlot.plot_xy(Plot_t, C_a, "C_a");
      }
      else if(TagNamesToPlot[i] == "VBus_a"){
	SimuPlot.plot_xy(Plot_t, VBus_a, "VBus_a");
      }
      else if(TagNamesToPlot[i] == "VL_a"){
	SimuPlot.plot_xy(Plot_t, VL_a, "VL_a");
      }
      else if(TagNamesToPlot[i] == "R_a"){
	SimuPlot.plot_xy(Plot_t, R_a, "R_a");
      }
      else if(TagNamesToPlot[i] == ""){
	break;
      }
    }

  }
}


void QQa_QQb_QQc_1::OdeGroupMSolve(double dydt[], double dmdt[])
{
  //Note: This instance is the first of the group. As such, this
  //      is where the "group solve" of the individual 
  //      "dy/dt's" is performed.

#define A1 (- Lm_b/Mab - Lb/Mab + Mbc/Mac)
#define B1 (Lm_c/Mac + Lc/Mac - Mbc/Mab)
#define A2 (- Mab/(Lm_a + La) + (Lm_b + Lb)/Mab) 
#define B2 (- Mac/(Lm_a + La) + Mbc/Mab) 
 


  double dqqa;
  double dqqb;
  double dqqc;


  double C1 = - dmdt[1]/Mab + dmdt[2]/Mac;
  double C2 = - dmdt[0]/(Lm_a + La) + dmdt[1]/Mab; 


  dqqb = (B2*C1 - B1*C2)/(B2*A1 - B1*A2);
  dqqc = (C2 - A2*dqqb)/B2;
  dqqa = (- Mab*dqqb - Mac*dqqc + dmdt[0])/(Lm_a + La);

  dydt[0] = dqqa;
  dydt[1] = dqqb;
  dydt[2] = dqqc;
 
}

void QQa_QQb_QQc_1::OdeRValueUpdate(void)
{
  OdeObjItem * pCurOdeItem;

  //Update Rvalues
  pCurOdeItem = pOdeObjRValList;

  ((Qa *) pCurOdeItem->pOdeObject)->qqa = y;
  pCurOdeItem = pCurOdeItem->pNextOdeItem;
  ((QQa_QQb_QQc1_1 *) pCurOdeItem->pOdeObject)->qqa = y;
  
}

// -----------------------------------------------------------------


// ---- QQa_QQb_QQc_2  ----------------------------------------------------


QQa_QQb_QQc_2::QQa_QQb_QQc_2(void)
{
  OdeObjItem * pCurOdeItem;

  OdeFuncName = ODE_FUNC_QQa_QQb_QQc_2;
 
  
  //build the ODE Rvalue list.
 
  pOdeObjRValList = new OdeObjItem;
  pCurOdeItem = pOdeObjRValList;

  pCurOdeItem->pOdeObject = OdeObjectList[ODE_FUNC_Qb];
  pCurOdeItem->pNextOdeItem = new OdeObjItem;
  pCurOdeItem = pCurOdeItem->pNextOdeItem;
  pCurOdeItem->pOdeObject = OdeObjectList[ODE_FUNC_QQa_QQb_QQc1_2];


  Ref_b = 0;
  Pwm_sig = 0;
  qqb1 = 0;
  qb = 0;

  PlotThisOutput = TRUE;
  Plot_Tag = "QQb";
  DoProbes = TRUE;
  
}




QQa_QQb_QQc_2::~QQa_QQb_QQc_2(void)
{

}

double QQa_QQb_QQc_2::OdeFunction(double y, double t)
{
  //Note: This is within a "group" ODE so we are really solving for "dm/dt"

           //"vs_b - RLb*qqb - Rb*(qqb + qqb1) - qb/Cb"
  vs_b = ShapeSquareWaveSource(((Ref_b > Pwm_sig) ? DC_BUS_VOLTAGE : - DC_BUS_VOLTAGE), SRC_SLEW_RATE ,t);
  return(vs_b - RLb*y - Rb*(y + qqb1) - qb/Cb);
}

void QQa_QQb_QQc_2::RecordProbes(void)
{
  //value for "vs_b - L_b*dqqb - RLb*qqb - Rb*(qqb + qqb1) - qb/Cb"
  Vcm_b.push_back(vs_b - Lb*dydt - RLb*y - Rb*(y + qqb1) - qb/Cb);
  C_b.push_back(qb/Cb);
  VBus_b.push_back(vs_b);
  VL_b.push_back(Lb*dydt);   
  R_b.push_back(Rb*(y + qqb1));   
  
  
}

void QQa_QQb_QQc_2 ::PlotProbes(Gnuplot & SimuPlot, vector<double> & Plot_t, string TagNamesToPlot[])
{
  int i;
  if(TagNamesToPlot[0] == ""){
    SimuPlot.plot_xy(Plot_t, Vcm_b, "Vcm_b");
    SimuPlot.plot_xy(Plot_t, C_b, "C_b");
    SimuPlot.plot_xy(Plot_t, VBus_b, "VBus_b");
    SimuPlot.plot_xy(Plot_t, VL_b, "VL_b");   
    SimuPlot.plot_xy(Plot_t, R_b, "R_b");  
  }
  else{
    for(i = 0; i < 20; i++){
      if(TagNamesToPlot[i] == "Vcm_b"){
	SimuPlot.plot_xy(Plot_t, Vcm_b, "Vcm_b");
      }
      else if(TagNamesToPlot[i] == "C_b"){
	SimuPlot.plot_xy(Plot_t, C_b, "C_b");
      }
      else if(TagNamesToPlot[i] == "VBus_b"){
	SimuPlot.plot_xy(Plot_t, VBus_b, "VBus_b");
      }
      else if(TagNamesToPlot[i] == "VL_b"){
	SimuPlot.plot_xy(Plot_t, VL_b, "VL_b");
      }
      else if(TagNamesToPlot[i] == "R_b"){
	SimuPlot.plot_xy(Plot_t, R_b, "R_b");
      }
      else if(TagNamesToPlot[i] == ""){
	break;
      }
    }

  }
}

void QQa_QQb_QQc_2::OdeRValueUpdate(void)
{
  OdeObjItem * pCurOdeItem;

  //Update Rvalues
  pCurOdeItem = pOdeObjRValList;

  ((Qb *) pCurOdeItem->pOdeObject)->qqb = y;
  pCurOdeItem = pCurOdeItem->pNextOdeItem;
  ((QQa_QQb_QQc1_2 *) pCurOdeItem->pOdeObject)->qqb = y;
}





// -----------------------------------------------------------------


// ---- QQa_QQb_QQc_3  ----------------------------------------------------



QQa_QQb_QQc_3::QQa_QQb_QQc_3(void)
{
  OdeObjItem * pCurOdeItem;

  OdeFuncName = ODE_FUNC_QQa_QQb_QQc_3;
 
  
  //build the ODE Rvalue list.
 
  pOdeObjRValList = new OdeObjItem;
  pCurOdeItem = pOdeObjRValList;

  pCurOdeItem->pOdeObject = OdeObjectList[ODE_FUNC_Qc];
  pCurOdeItem->pNextOdeItem = new OdeObjItem;
  pCurOdeItem = pCurOdeItem->pNextOdeItem;
  pCurOdeItem->pOdeObject = OdeObjectList[ODE_FUNC_QQa_QQb_QQc1_3];

  Ref_c = 0;
  Pwm_sig = 0;
  qqc1 = 0;
  qc = 0;

  PlotThisOutput = TRUE;
  Plot_Tag = "QQc";
  DoProbes = TRUE;

}



QQa_QQb_QQc_3::~QQa_QQb_QQc_3(void)
{

}

double QQa_QQb_QQc_3::OdeFunction(double y, double t)
{
  //Note: This is within a "group" ODE so we are really solving for "dm/dt"

                //"vs_c - RLc*qqc - Rc*(qqc + qqc1) - qc/Cc"
  vs_c = ShapeSquareWaveSource(((Ref_c > Pwm_sig) ? DC_BUS_VOLTAGE : - DC_BUS_VOLTAGE), SRC_SLEW_RATE ,t);
  return(vs_c - RLc*y - Rc*(y + qqc1) - qc/Cc);
}

void QQa_QQb_QQc_3::RecordProbes(void)
{
  //value for "vs_c - L_c*dqqc - RLc*qqc - Rc*(qqc + qqc1) - qc/Cc"
  Vcm_c.push_back(vs_c - Lc*dydt - RLc*y - Rc*(y + qqc1) - qc/Cc);
  C_c.push_back(qc/Cc);
  VBus_c.push_back(vs_c);
  VL_c.push_back(Lc*dydt);   
  R_c.push_back(Rc*(y + qqc1));   
  
  
}



void QQa_QQb_QQc_3 ::PlotProbes(Gnuplot & SimuPlot, vector<double> & Plot_t, string TagNamesToPlot[])
{
  int i;
  if(TagNamesToPlot[0] == ""){
    SimuPlot.plot_xy(Plot_t, Vcm_c, "Vcm_c");
    SimuPlot.plot_xy(Plot_t, C_c, "C_c");
    SimuPlot.plot_xy(Plot_t, VBus_c, "VBus_c");
    SimuPlot.plot_xy(Plot_t, VL_c, "VL_c");   
    SimuPlot.plot_xy(Plot_t, R_c, "R_c");  
  }
  else{
    for(i = 0; i < 20; i++){
      if(TagNamesToPlot[i] == "Vcm_c"){
	SimuPlot.plot_xy(Plot_t, Vcm_c, "Vcm_c");
      }
      else if(TagNamesToPlot[i] == "C_c"){
	SimuPlot.plot_xy(Plot_t, C_c, "C_c");
      }
      else if(TagNamesToPlot[i] == "VBus_c"){
	SimuPlot.plot_xy(Plot_t, VBus_c, "VBus_c");
      }
      else if(TagNamesToPlot[i] == "VL_c"){
	SimuPlot.plot_xy(Plot_t, VL_c, "VL_c");
      }
      else if(TagNamesToPlot[i] == "R_c"){
	SimuPlot.plot_xy(Plot_t, R_c, "R_c");
      }
      else if(TagNamesToPlot[i] == ""){
	break;
      }
    }

  }
}

void QQa_QQb_QQc_3::OdeRValueUpdate(void)
{
  OdeObjItem * pCurOdeItem;

  //Update Rvalues
  pCurOdeItem = pOdeObjRValList;

  ((Qc *) pCurOdeItem->pOdeObject)->qqc = y;
  pCurOdeItem = pCurOdeItem->pNextOdeItem;
  ((QQa_QQb_QQc1_3 *) pCurOdeItem->pOdeObject)->qqc = y;
}





// -----------------------------------------------------------------


// ---- QQa_QQb_QQc1_1  ----------------------------------------------------

QQa_QQb_QQc1_1::QQa_QQb_QQc1_1(void)
{
  OdeObjItem * pCurOdeItem;

  OdeFuncName = ODE_FUNC_QQa_QQb_QQc1_1;
 
  

  //this object marks the beginning of a "group solve" of
  //three objects.
  GroupSolve = 1;
  NumberOfGrpOdes = 3;

  //build the ODE Rvalue list.
 
  pOdeObjRValList = new OdeObjItem;
  pCurOdeItem = pOdeObjRValList;

  pCurOdeItem->pOdeObject = OdeObjectList[ODE_FUNC_Qa];
  pCurOdeItem->pNextOdeItem = new OdeObjItem;
  pCurOdeItem = pCurOdeItem->pNextOdeItem;
  pCurOdeItem->pOdeObject = OdeObjectList[ODE_FUNC_QQa_QQb_QQc_1];

  Ref_a1 = 0;
  Pwm_sig = 0;
  qqa = 0;
  qa = 0;

  PlotThisOutput = TRUE;
  Plot_Tag = "QQa1";
  DoProbes = TRUE;
  
}

QQa_QQb_QQc1_1::~QQa_QQb_QQc1_1(void)
{

}

double QQa_QQb_QQc1_1::OdeFunction(double y, double t)
{
  //Note: This is within a "group" ODE so we are really solving for "dm/dt"

          //"vs_a1 - RL1a*qqa1 - Ra*(qqa + qqa1) - qa/Ca" 
  vs_a1 = ShapeSquareWaveSource(((Ref_a1 > Pwm_sig) ? DC_BUS_VOLTAGE : - DC_BUS_VOLTAGE), SRC_SLEW_RATE ,t);
  return(vs_a1 - RL1a*y - Ra*(qqa + y) - qa/Ca);
}

void QQa_QQb_QQc1_1::RecordProbes(void)
{
  //value for "vs_a1 - L_a1*dqqa1 - RLa1*qqa1 - Ra*(qqa + qqa1) - qa/Ca"
  Vcm_a1.push_back(vs_a1 - La1*dydt - RL1a*y - Ra*(qqa + y) - qa/Ca);
  VBus_a1.push_back(vs_a1);
  VL_a1.push_back(La1*dydt);   
  
}

void QQa_QQb_QQc1_1 ::PlotProbes(Gnuplot & SimuPlot, vector<double> & Plot_t, string TagNamesToPlot[])
{
  int i;
  if(TagNamesToPlot[0] == ""){
    SimuPlot.plot_xy(Plot_t, Vcm_a1, "Vcm_a1");
    SimuPlot.plot_xy(Plot_t, VBus_a1, "VBus_a1");
    SimuPlot.plot_xy(Plot_t, VL_a1, "VL_a1");   
  }
  else{
    for(i = 0; i < 20; i++){
      if(TagNamesToPlot[i] == "Vcm_a1"){
	SimuPlot.plot_xy(Plot_t, Vcm_a1, "Vcm_a1");
      }
      else if(TagNamesToPlot[i] == "VBus_a1"){
	SimuPlot.plot_xy(Plot_t, VBus_a1, "VBus_a1");
      }
      else if(TagNamesToPlot[i] == "VL_a1"){
	SimuPlot.plot_xy(Plot_t, VL_a1, "VL_a1");
      }
      else if(TagNamesToPlot[i] == ""){
	break;
      }
    }

  }
}


void QQa_QQb_QQc1_1::OdeGroupMSolve(double dydt[], double dmdt[])
{
  //Note: This instance is the first of the group. As such, this
  //      is where the "group solve" of the individual 
  //      "dy/dt's" is performed.


#define A1_1 (- Lm_b1/Mab1 - Lb1/Mab1 + Mbc1/Mac1)
#define B1_1 (Lm_c1/Mac1 + Lc1/Mac1 - Mbc1/Mab1)
#define A2_1 (- Mab1/(Lm_a1 + La1) + (Lm_b1 + Lb1)/Mab1) 
#define B2_1 (- Mac1/(Lm_a1 + La1) + Mbc1/Mab1) 
 


  double dqqa1;
  double dqqb1;
  double dqqc1;


  double C1_1 = - dmdt[1]/Mab1 + dmdt[2]/Mac1;
  double C2_1 = - dmdt[0]/(Lm_a1 + La1) + dmdt[1]/Mab1; 


  dqqb1 = (B2_1*C1_1 - B1_1*C2_1)/(B2_1*A1_1 - B1_1*A2_1);
  dqqc1 = (C2_1 - A2_1*dqqb1)/B2_1;
  dqqa1 = (- Mab1*dqqb1 - Mac1*dqqc1 + dmdt[0])/(Lm_a1 + La1);

  dydt[0] = dqqa1;
  dydt[1] = dqqb1;
  dydt[2] = dqqc1;


}
        

void QQa_QQb_QQc1_1::OdeRValueUpdate(void)
{
  OdeObjItem * pCurOdeItem;

  //Update Rvalues
  pCurOdeItem = pOdeObjRValList;

  ((Qa *) pCurOdeItem->pOdeObject)->qqa1 = y;
   pCurOdeItem = pCurOdeItem->pNextOdeItem;
  ((QQa_QQb_QQc_1 *) pCurOdeItem->pOdeObject)->qqa1 = y; 
}

// -----------------------------------------------------------------


// ---- QQa_QQb_QQc1_2  ----------------------------------------------------


QQa_QQb_QQc1_2::QQa_QQb_QQc1_2(void)
{
  OdeObjItem * pCurOdeItem;

  OdeFuncName = ODE_FUNC_QQa_QQb_QQc1_2;
 
  
  //build the ODE Rvalue list.
 
  pOdeObjRValList = new OdeObjItem;
  pCurOdeItem = pOdeObjRValList;

  pCurOdeItem->pOdeObject = OdeObjectList[ODE_FUNC_Qb];
  pCurOdeItem->pNextOdeItem = new OdeObjItem;
  pCurOdeItem = pCurOdeItem->pNextOdeItem;
  pCurOdeItem->pOdeObject = OdeObjectList[ODE_FUNC_QQa_QQb_QQc_2];

  Ref_b1 = 0;
  Pwm_sig = 0;
  qqb = 0;
  qb = 0;

  PlotThisOutput = TRUE;
  Plot_Tag = "QQb1";
  DoProbes = TRUE;
  
}




QQa_QQb_QQc1_2::~QQa_QQb_QQc1_2(void)
{

}

double QQa_QQb_QQc1_2::OdeFunction(double y, double t)
{
  //Note: This is within a "group" ODE so we are really solving for "dm/dt"

           //"vs_b1 - RL1b*qqb1 - Rb*(qqb + qqb1) - qb/Cb"
  vs_b1 = ShapeSquareWaveSource(((Ref_b1 > Pwm_sig) ? DC_BUS_VOLTAGE : - DC_BUS_VOLTAGE), SRC_SLEW_RATE ,t);
  return(vs_b1 - RL1b*y - Rb*(qqb + y) - qb/Cb);
}

void QQa_QQb_QQc1_2::RecordProbes(void)
{
  //value for "vs_b1 - L_b1*dqqb1 - RLb1*qqb1 - Rb*(qqb + qqb1) - qb/Cb"
  Vcm_b1.push_back(vs_b1 - Lb1*dydt - RL1b*y - Rb*(qqb + y) - qb/Cb);
  VBus_b1.push_back(vs_b1);
  VL_b1.push_back(Lb1*dydt);   
  
}

void QQa_QQb_QQc1_2 ::PlotProbes(Gnuplot & SimuPlot, vector<double> & Plot_t, string TagNamesToPlot[])
{
  int i;
  if(TagNamesToPlot[0] == ""){
    SimuPlot.plot_xy(Plot_t, Vcm_b1, "Vcm_b1");
    SimuPlot.plot_xy(Plot_t, VBus_b1, "VBus_b1");
    SimuPlot.plot_xy(Plot_t, VL_b1, "VL_b1");   
  }
  else{
    for(i = 0; i < 20; i++){
      if(TagNamesToPlot[i] == "Vcm_b1"){
	SimuPlot.plot_xy(Plot_t, Vcm_b1, "Vcm_b1");
      }
      else if(TagNamesToPlot[i] == "VBus_b1"){
	SimuPlot.plot_xy(Plot_t, VBus_b1, "VBus_b1");
      }
      else if(TagNamesToPlot[i] == "VL_b1"){
	SimuPlot.plot_xy(Plot_t, VL_b1, "VL_b1");
      }
      else if(TagNamesToPlot[i] == ""){
	break;
      }
    }

  }
}



void QQa_QQb_QQc1_2::OdeRValueUpdate(void)
{
  OdeObjItem * pCurOdeItem;

  //Update Rvalues
  pCurOdeItem = pOdeObjRValList;

  ((Qb *) pCurOdeItem->pOdeObject)->qqb1 = y;
   pCurOdeItem = pCurOdeItem->pNextOdeItem;
  ((QQa_QQb_QQc_2 *) pCurOdeItem->pOdeObject)->qqb1 = y; 
}





// -----------------------------------------------------------------


// ---- QQa_QQb_QQc1_3  ----------------------------------------------------



QQa_QQb_QQc1_3::QQa_QQb_QQc1_3(void)
{
  OdeObjItem * pCurOdeItem;

  OdeFuncName = ODE_FUNC_QQa_QQb_QQc1_3;
 
  
  //build the ODE Rvalue list.
 
  pOdeObjRValList = new OdeObjItem;
  pCurOdeItem = pOdeObjRValList;

  pCurOdeItem->pOdeObject = OdeObjectList[ODE_FUNC_Qc];
  pCurOdeItem->pNextOdeItem = new OdeObjItem;
  pCurOdeItem = pCurOdeItem->pNextOdeItem;
  pCurOdeItem->pOdeObject = OdeObjectList[ODE_FUNC_QQa_QQb_QQc_3];

  Ref_c1 = 0;
  Pwm_sig = 0;
  qqc = 0;
  qc = 0;

  PlotThisOutput = TRUE;
  Plot_Tag = "QQc1";
  DoProbes = TRUE;
  
}



QQa_QQb_QQc1_3::~QQa_QQb_QQc1_3(void)
{

}

double QQa_QQb_QQc1_3::OdeFunction(double y, double t)
{
  //Note: This is within a "group" ODE so we are really solving for "dm/dt"

                //"vs_c1 - RL1c*qqc1 - Rc*(qqc + qqc1) - qc/Cc"
  vs_c1 = ShapeSquareWaveSource(((Ref_c1 > Pwm_sig) ? DC_BUS_VOLTAGE : - DC_BUS_VOLTAGE), SRC_SLEW_RATE ,t);
  return(vs_c1 - RL1c*y - Rc*(qqc + y) - qc/Cc);
}

void QQa_QQb_QQc1_3::RecordProbes(void)
{
  //value for "vs_c1 - L_c1*dqqc1 - RLc1*qqc1 - Rc*(qqc + qqc1) - qc/Cc"
  Vcm_c1.push_back(vs_c1 - Lc1*dydt - RL1c*y - Rc*(qqc + y) - qc/Cc);
  VBus_c1.push_back(vs_c1);
  VL_c1.push_back(Lc1*dydt);   
  
}

void QQa_QQb_QQc1_3 ::PlotProbes(Gnuplot & SimuPlot, vector<double> & Plot_t, string TagNamesToPlot[])
{
  int i;
  if(TagNamesToPlot[0] == ""){
    SimuPlot.plot_xy(Plot_t, Vcm_c1, "Vcm_c1");
    SimuPlot.plot_xy(Plot_t, VBus_c1, "VBus_c1");
    SimuPlot.plot_xy(Plot_t, VL_c1, "VL_c1");   
  }
  else{
    for(i = 0; i < 20; i++){
      if(TagNamesToPlot[i] == "Vcm_c1"){
	SimuPlot.plot_xy(Plot_t, Vcm_c1, "Vcm_c1");
      }
      else if(TagNamesToPlot[i] == "VBus_c1"){
	SimuPlot.plot_xy(Plot_t, VBus_c1, "VBus_c1");
      }
      else if(TagNamesToPlot[i] == "VL_c1"){
	SimuPlot.plot_xy(Plot_t, VL_c1, "VL_c1");
      }
      else if(TagNamesToPlot[i] == ""){
	break;
      }
    }

  }
}

void QQa_QQb_QQc1_3::OdeRValueUpdate(void)
{
  OdeObjItem * pCurOdeItem;

  //Update Rvalues
  pCurOdeItem = pOdeObjRValList;

  ((Qc *) pCurOdeItem->pOdeObject)->qqc1 = y;
   pCurOdeItem = pCurOdeItem->pNextOdeItem;
  ((QQa_QQb_QQc_3 *) pCurOdeItem->pOdeObject)->qqc1 = y; 
}





// -----------------------------------------------------------------




// ****************************************************************

// ***** CtrlObject Functions (Translation) ************************

// ---- RefA ---------------------------------------------------

RefA::RefA(void)
{
  OdeObjItem * pCurOdeItem;

  CtrlFuncName = CTRL_FUNC_RefA;

  
  //build the ODE Rvalue list.

  pOdeObjRValList = new OdeObjItem;
  pCurOdeItem = pOdeObjRValList;

  pCurOdeItem->pOdeObject = OdeObjectList[ODE_FUNC_QQa_QQb_QQc_1];  

}

RefA::~RefA(void)
{


}


void RefA::CtrlFunction(double t)
{
  //For now, just command a constant of "0"
  y = .23; 
}

void RefA::OdeRValueUpdate(void)
{
  OdeObjItem * pCurOdeItem;

  //Update Rvalues
  pCurOdeItem = pOdeObjRValList;

  ((QQa_QQb_QQc_1 *) pCurOdeItem->pOdeObject)->Ref_a = y;

}


// -----------------------------------------------------------------

// ---- RefB ---------------------------------------------------


RefB::RefB(void)
{
  OdeObjItem * pCurOdeItem;

  CtrlFuncName = CTRL_FUNC_RefB;

  
  //build the ODE Rvalue list.

  pOdeObjRValList = new OdeObjItem;
  pCurOdeItem = pOdeObjRValList;

  pCurOdeItem->pOdeObject = OdeObjectList[ODE_FUNC_QQa_QQb_QQc_2];  

}


RefB::~RefB(void)
{


}


void RefB::CtrlFunction(double t)
{
  //For now, just command a constant of "0"
  y =  0; 
}

void RefB::OdeRValueUpdate(void)
{
  OdeObjItem * pCurOdeItem;

  //Update Rvalues
  pCurOdeItem = pOdeObjRValList;

  ((QQa_QQb_QQc_2 *) pCurOdeItem->pOdeObject)->Ref_b = y;


}

// ----------------------------------------------------------------- 

// ---- RefC ---------------------------------------------------

RefC::RefC(void)
{
  OdeObjItem * pCurOdeItem;

  CtrlFuncName = CTRL_FUNC_RefC;

  
  //build the ODE Rvalue list.

  pOdeObjRValList = new OdeObjItem;
  pCurOdeItem = pOdeObjRValList;

  pCurOdeItem->pOdeObject = OdeObjectList[ODE_FUNC_QQa_QQb_QQc_3];  

}

RefC::~RefC(void)
{


}


void RefC::CtrlFunction(double t)
{
  //For now, just command a constant of "0"
  y =  0; 
}

void RefC::OdeRValueUpdate(void)
{
  OdeObjItem * pCurOdeItem;

  //Update Rvalues
  pCurOdeItem = pOdeObjRValList;

  ((QQa_QQb_QQc_3 *) pCurOdeItem->pOdeObject)->Ref_c = y;


}

// ----------------------------------------------------------------- 


// ---- RefA1 ---------------------------------------------------

RefA1::RefA1(void)
{
  OdeObjItem * pCurOdeItem;

  CtrlFuncName = CTRL_FUNC_RefA1;

  
  //build the ODE Rvalue list.

  pOdeObjRValList = new OdeObjItem;
  pCurOdeItem = pOdeObjRValList;

  pCurOdeItem->pOdeObject = OdeObjectList[ODE_FUNC_QQa_QQb_QQc1_1];  

}

RefA1::~RefA1(void)
{


}


void RefA1::CtrlFunction(double t)
{
  //For now, just command a constant of "0"
  y = 0; 
}

void RefA1::OdeRValueUpdate(void)
{
  OdeObjItem * pCurOdeItem;

  //Update Rvalues
  pCurOdeItem = pOdeObjRValList;

  ((QQa_QQb_QQc1_1 *) pCurOdeItem->pOdeObject)->Ref_a1 = y;

}


// -----------------------------------------------------------------


// ---- RefB ---------------------------------------------------


RefB1::RefB1(void)
{
  OdeObjItem * pCurOdeItem;

  CtrlFuncName = CTRL_FUNC_RefB1;

  
  //build the ODE Rvalue list.

  pOdeObjRValList = new OdeObjItem;
  pCurOdeItem = pOdeObjRValList;

  pCurOdeItem->pOdeObject = OdeObjectList[ODE_FUNC_QQa_QQb_QQc1_2];  

}


RefB1::~RefB1(void)
{


}


void RefB1::CtrlFunction(double t)
{
  //For now, just command a constant of "0"
  y = 0;  
}

void RefB1::OdeRValueUpdate(void)
{
  OdeObjItem * pCurOdeItem;

  //Update Rvalues
  pCurOdeItem = pOdeObjRValList;

  ((QQa_QQb_QQc1_2 *) pCurOdeItem->pOdeObject)->Ref_b1 = y;


}

// ----------------------------------------------------------------- 


// ---- RefC1 ---------------------------------------------------

RefC1::RefC1(void)
{
  OdeObjItem * pCurOdeItem;

  CtrlFuncName = CTRL_FUNC_RefC1;

  
  //build the ODE Rvalue list.

  pOdeObjRValList = new OdeObjItem;
  pCurOdeItem = pOdeObjRValList;

  pCurOdeItem->pOdeObject = OdeObjectList[ODE_FUNC_QQa_QQb_QQc1_3];  

}

RefC1::~RefC1(void)
{


}


void RefC1::CtrlFunction(double t)
{
  //For now, just command a constant of "0"
  y = 0;   
}

void RefC1::OdeRValueUpdate(void)
{
  OdeObjItem * pCurOdeItem;

  //Update Rvalues
  pCurOdeItem = pOdeObjRValList;

  ((QQa_QQb_QQc1_3 *) pCurOdeItem->pOdeObject)->Ref_c1 = y;


}

// ----------------------------------------------------------------- 




// *****************************************************************

// ***** CtrlObject Functions (Trajectory) *************************

// *****************************************************************



// **** SimuObject ************************************************




SimuObject Simulation;

SimuObject::SimuObject(void)
{
  OdeObjItem * pCurOdeItem;
  SrcObjItem * pCurSrcItem;
  CtrlObjItem * pCurCtrlItem;
  int i;

  //The simulation run time.
  SimuTime = .01;      

  //set the plot time range.
  MinimumPlotTime = 0;
  MaximumPlotTime = SimuTime;

  //For this example the setting of "RelTol" is important. If it is set to large
  //the system will become unstable. 
  RelTol = .0000000001;           
  //Setting "AbsTol" too small will make a system with a decaying oscillation 
  //take too long to finish.
  AbsTol = .0000000000001;   
  //typical error correction setting as per "RungeKutta_java.htm" (never set higher then "1.0")
  Safety = .98;  
  h_start = .000000001;            

  h = h_start;

  //set to a value other then "0" to clamp maximum "h";
  h_max = .0000002;            //(before, we could not go past ".0000001". Now, we should be able to go higher then this.)

  //set to store and plot "h" parameter.
  // Do_h_Plot = 1;
  
  TimeQuantum = h;
  CtrlTimeQuantum = .005;

  TranslationQuantumCount = 1;
  TranslationQuantumNum = 1;
  
  CtrlTimeAccumulator = 0;

  SrcPeriodQuantum = QUARTER_PWM_CYCLE;
  SrcPeriodAccumulator = 0;
 

  //build the SRC equation list
  pSrcEquationList = new SrcObjItem;
  pCurSrcItem = pSrcEquationList;
  i = 0;
  while(SrcObjectList[i]){
    pCurSrcItem->pSrcObject = SrcObjectList[i];
    i++;
    if(!SrcObjectList[i])
      break;
    pCurSrcItem->pNextSrcItem = new SrcObjItem;
    pCurSrcItem = pCurSrcItem->pNextSrcItem;


  }

  //build the ODE equation list.
  pOdeEquationList = new OdeObjItem;
  pCurOdeItem = pOdeEquationList;
  i = 0;
  while(1){
    pCurOdeItem->pOdeObject = OdeObjectList[i];
    i++;
    if(!OdeObjectList[i])
      break;
    pCurOdeItem->pNextOdeItem = new OdeObjItem;
    pCurOdeItem = pCurOdeItem->pNextOdeItem;
  }

  //build the CTRL (Translation) equation list.
  pTranslationList = new CtrlObjItem;
  pCurCtrlItem = pTranslationList;
  i = 0;
  while(1){
    pCurCtrlItem->pCtrlObject = CtrlTranObjectList[i];
    i++;
    if(!CtrlTranObjectList[i])
      break;
    pCurCtrlItem->pNextCtrlItem = new CtrlObjItem;
    pCurCtrlItem = pCurCtrlItem->pNextCtrlItem;
  }

 

 

}


SimuObject::~SimuObject(void)
{

  //(ideally we should delete all make allocation make in the constructor, here)

}



// ************************************************************





bool ExecuteSimulation(void)
{

   

  Simulation.OdeSimuType = ODE_SIMU_56;

  while(Simulation.t < Simulation.SimuTime){               

    if(!Simulation.DoOneInteration())
      return FALSE;
    
  }
  return TRUE;
}

void PlotResults(string TagNamesToPlot[], double ScaleFactors[], double MinPlotTimes[], double MaxPlotTimes[],
		 double PlotTimeSteps[], double PlotTimeOffset)
{
  Simulation.PlotSimuResults(TagNamesToPlot, ScaleFactors, MinPlotTimes, MaxPlotTimes, PlotTimeSteps, PlotTimeOffset);


}
