

typedef enum {
  ODE_FUNC_NULL,
  ODE_FUNC_TestRC1,
 
 
  
} ODE_FUNCTION;


typedef enum {
  CTRL_FUNC_NULL,
  CTRL_FUNC_TestRC,


} CTRL_FUNCTION;


#include "Simulation.hpp"


class TestRC1 : public OdeObject
{
public:
 
  virtual double OdeFunction(double y, double h);
  TestRC1(void);
  ~TestRC1(void);
  double VSrc;
};

TestRC1::TestRC1(void)
{
  OdeFuncName = ODE_FUNC_TestRC1;
  VSrc = 50.0;
  

}
TestRC1::~TestRC1(void)
{


}

double TestRC1::OdeFunction(double y, double h)
{  
 
  return (VSrc - .03*y);
}

TestRC1  Inst_TestRC1;


class TestCtrl1 : public CtrlObject
{
public:
  virtual void CtrlFunction(double t);
  virtual void OdeRValueUpdate(void);
  TestCtrl1(void);
  ~TestCtrl1(void);
 



};

TestCtrl1::TestCtrl1(void)
{
  y = 50;
   //(for multiple Object's, the next two statements are executed in a loop).
  pOdeObjRValList = new OdeObjItem;

  pOdeObjRValList->pOdeObject = &Inst_TestRC1;

  CtrlFuncName = CTRL_FUNC_TestRC;

}

TestCtrl1::~TestCtrl1(void)
{
  
  //(ideally we should delete all make allocation make in the constructor, here)
}

void TestCtrl1::CtrlFunction(double t)
{
  if((t >= 30.0) && (t < 60.0))
    y = 0;
  else if(t >= 60.0)
    y = 50;
}

void TestCtrl1::OdeRValueUpdate(void)
{
  OdeObjItem * pCurOdeItem;
  pCurOdeItem = pOdeObjRValList;
  while(pCurOdeItem){
    if(pCurOdeItem->pOdeObject->OdeFuncName == ODE_FUNC_TestRC1){
      ((TestRC1 *) pCurOdeItem->pOdeObject)->VSrc = y;

    }
    pCurOdeItem = pCurOdeItem->pNextOdeItem;

  }


}

TestCtrl1 Inst_TestCtrl1;






//This is our simulation object. Only the constructor is called for
//parameter initialization. No user defined destructor is defined because this
//application is always built as an ".exe" (The operating system's memory manager always
//takes care of clean-up).
SimuObject Simulation;

SimuObject::SimuObject(void)
{
  RelTol = .000001;
  AbsTol = .000001;
  h_start = .0001;

  h = .0001;
  
  TimeQuantum = h;
  CtrlTimeQuantum = 30.0;

  TranslationQuantumCount = 1;
  TranslationQuantumNum = 1;
  
  CtrlTimeAccumulator = 0;

  //(for multiple Object's, the next two statements are executed in a loop).
  pOdeEquationList = new OdeObjItem;

  pOdeEquationList->pOdeObject = &Inst_TestRC1;


  //(for multiple Object's, the next two statements are executed in a loop).

  pTranslationList = new CtrlObjItem;

  pTranslationList->pCtrlObject = &Inst_TestCtrl1;

 

}


SimuObject::~SimuObject(void)
{

  //(ideally we should delete all make allocation make in the constructor, here)

}



void ExecuteSimulation(void)
{

  //Note: For this test, we are not using the built-in plot Gnuplot utilities because we are comparisons with
  //      four sets of plots, one for each ODE simulation type.



  // My conclusions for the test is that ODE_SIMU_56 is the best simulation mode based on
  // the size of the "h" increments.



  vector<double> x;
  vector<double> y2;
  vector<double> y1;
  vector<double> y3;
 

  int i;
  
  Gnuplot g1 = Gnuplot("lines");
  
  x.clear();
  y1.clear();
  y2.clear();
  y3.clear();
 

  Simulation.OdeSimuType = ODE_SIMU_56;

  while(Simulation.t < 100.0){

    Simulation.DoOneInteration();  
    
    x.push_back(Simulation.t);                              
    y1.push_back(Simulation.h);
    y2.push_back(Simulation.MaxOdeErr);
    y3.push_back(Simulation.pOdeEquationList->pOdeObject->y*.01);  //scale "Out" to fit on screen
    
  }

  g1.reset_plot();
  g1.set_style("lines");
   g1.plot_xy(x,y1, "h_1");

    g1.plot_xy(x,y2, "Err_1");
    g1.plot_xy(x,y3, "Out_1");
  
  x.clear();
  y1.clear();
  y2.clear();
  y3.clear();
 
  
  Simulation.h = .0001;
  Simulation.CtrlTimeAccumulator = 0;
  Simulation.TimeQuantum = .0001;
  Simulation.MaxOdeErr = 0;
  Simulation.t = 0;
  Simulation.pOdeEquationList->pOdeObject->y = 0;
  

   Simulation.OdeSimuType = ODE_SIMU_24;

  while(Simulation.t < 100.0){

    Simulation.DoOneInteration();  
    
    x.push_back(Simulation.t);                             
    y1.push_back(Simulation.h);
    y2.push_back(Simulation.MaxOdeErr);
     y3.push_back(Simulation.pOdeEquationList->pOdeObject->y*.01);  //scale "Out" to fit on screen
  }

  g1.plot_xy(x,y1, "h_56");

   g1.plot_xy(x,y2, "Err_56");

   g1.plot_xy(x,y3, "Out_56");

  x.clear();
  y1.clear();
  y2.clear();
  y3.clear();
  
  Simulation.h = .0001;
  Simulation.CtrlTimeAccumulator = 0; 
  Simulation.TimeQuantum = .0001;
  Simulation.MaxOdeErr = 0;
  Simulation.t = 0;
  Simulation.pOdeEquationList->pOdeObject->y = 0;

   Simulation.OdeSimuType = ODE_SIMU_34;

  while(Simulation.t < 100.0){

    Simulation.DoOneInteration();  
    
    x.push_back(Simulation.t);                              
    y1.push_back(Simulation.h);
    y2.push_back(Simulation.MaxOdeErr);
     y3.push_back(Simulation.pOdeEquationList->pOdeObject->y*.01);  //scale "Out" to fit on screen
  }

  g1.plot_xy(x,y1, "h_34");

  g1.plot_xy(x,y2, "Err_34");

  g1.plot_xy(x,y3, "Out_34");
 
   x.clear();
  y1.clear();
  y2.clear();
  y3.clear();

 Simulation.h = .0001;
  Simulation.CtrlTimeAccumulator = 0; 
  Simulation.TimeQuantum = .0001;
  Simulation.MaxOdeErr = 0;
  Simulation.t = 0;
  Simulation.pOdeEquationList->pOdeObject->y = 0;

   Simulation.OdeSimuType = ODE_SIMU_24;
 

  while(Simulation.t < 100.0){

    Simulation.DoOneInteration();  
    
    x.push_back(Simulation.t);                               
    y1.push_back(Simulation.h);
    y2.push_back(Simulation.MaxOdeErr);
     y3.push_back(Simulation.pOdeEquationList->pOdeObject->y*.01);  //scale "Out" to fit on screen
  }

   g1.plot_xy(x,y1, "h_24");

   g1.plot_xy(x,y2, "Err_24");
   

   g1.plot_xy(x,y3, "Out_24");

 

   //******* This last test takes a long time ***********
   //(We test only ODE_SIMU_24 in "fixed" increment mode)


  x.clear();
  y1.clear();
  y2.clear();
  y3.clear();

 Simulation.h = .0001;
  Simulation.CtrlTimeAccumulator = 0; 
  Simulation.TimeQuantum = .0001;
  Simulation.MaxOdeErr = 0;
  Simulation.t = 0;
  Simulation.pOdeEquationList->pOdeObject->y = 0;

   Simulation.OdeSimuType = ODE_SIMU_24;
   Simulation.OdeSimuFixed = 1;

  while(Simulation.t < 100.0){

    Simulation.DoOneInteration();  
    
    x.push_back(Simulation.t);                               
 
     y3.push_back(Simulation.pOdeEquationList->pOdeObject->y*.01);  //scale "Out" to fit on screen
  }

  
   

   g1.plot_xy(x,y3, "Out_24_fixed");










  Simulation.h = .0001;



}


void PlotResults(void)
{
  Simulation.PlotSimuResults();


}
