

typedef enum {
  ODE_FUNC_NULL,
  ODE_FUNC_TestRC1,
 
 
  
} ODE_FUNCTION;


typedef enum {
  CTRL_FUNC_NULL,
  CTRL_FUNC_TestRC,


} CTRL_FUNCTION;


#include "Simulation.hpp"


class TestRC1 : public OdeObject
{
public:
 
  virtual double OdeFunction(double y, double h);
  TestRC1(void);
  ~TestRC1(void);
  double VSrc;
};

TestRC1::TestRC1(void)
{
  OdeFuncName = ODE_FUNC_TestRC1;
  VSrc = 50.0;
  PlotThisOutput = TRUE;
  Plot_Tag = "OutSig";

}
TestRC1::~TestRC1(void)
{


}

double TestRC1::OdeFunction(double y, double h)
{  
 
  return (VSrc - .03*y);
}

TestRC1  Inst_TestRC1;


class TestCtrl1 : public CtrlObject
{
public:
  virtual void CtrlFunction(double t);
  virtual void OdeRValueUpdate(void);
  TestCtrl1(void);
  ~TestCtrl1(void);
 
  


};

TestCtrl1::TestCtrl1(void)
{
  y = 50;
   //(for multiple Object's, the next two statements are executed in a loop).
  pOdeObjRValList = new OdeObjItem;

  pOdeObjRValList->pOdeObject = &Inst_TestRC1;

  CtrlFuncName = CTRL_FUNC_TestRC;

  PlotThisOutput = TRUE;
  Plot_Tag = "VSrc";

}

TestCtrl1::~TestCtrl1(void)
{
  
  //(ideally we should delete all make allocation make in the constructor, here)
}

void TestCtrl1::CtrlFunction(double t)
{
  if((t >= 30.0) && (t < 60.0))
    y = 0;
  else if(t >= 60.0)
    y = 50;
}

void TestCtrl1::OdeRValueUpdate(void)
{
  OdeObjItem * pCurOdeItem;
  pCurOdeItem = pOdeObjRValList;
  while(pCurOdeItem){
    if(pCurOdeItem->pOdeObject->OdeFuncName == ODE_FUNC_TestRC1){
      ((TestRC1 *) pCurOdeItem->pOdeObject)->VSrc = y;

    }
    pCurOdeItem = pCurOdeItem->pNextOdeItem;

  }


}

TestCtrl1 Inst_TestCtrl1;







SimuObject Simulation;

SimuObject::SimuObject(void)
{
  RelTol = .000001;
  AbsTol = .000001;
  h_start = .0001;

  h = .0001;
  
  TimeQuantum = h;
  CtrlTimeQuantum = 30.0;

  TranslationQuantumCount = 1;
  TranslationQuantumNum = 1;
  
  CtrlTimeAccumulator = 0;

  //(for multiple Object's, the next two statements are executed in a loop).
  pOdeEquationList = new OdeObjItem;

  pOdeEquationList->pOdeObject = &Inst_TestRC1;


  //(for multiple Object's, the next two statements are executed in a loop).

  pTranslationList = new CtrlObjItem;

  pTranslationList->pCtrlObject = &Inst_TestCtrl1;

 

}


SimuObject::~SimuObject(void)
{

  //(ideally we should delete all make allocation make in the constructor, here)

}



void ExecuteSimulation(void)
{

 
 

  Simulation.OdeSimuType = ODE_SIMU_56;

  while(Simulation.t < 100.0){

    Simulation.DoOneInteration();  
  
    
  }

}

void PlotResults(void)
{
  Simulation.PlotSimuResults();


}
