
// ****************************************************************************************************************************************************************************
//
//
//      This file is a copy of the original Cygwin Project file for "Simulation". Modifications have been
//      made to process the auto-generated input file "gauss.in" generated by "Simulation".
//
//      One major problem with the original algorythm for "TEST_gauss_c_txt" below was the inclusion of code
//      in the "partial pivot" section. It is required to check the pivot point using "fabs()". With out this,
//      the value "0" is treated as a magnitude that is greater then a "minus" value. Thus the potential for "divide by zero"
//      in the forward calculation. See file "./Gaussian-Elimination-With-Partial-Pivoting/GaussianEliminationWithPartialPivoting.c".
//      This algorythm is virtually identical to the algorythm below except for the inclusion of the "fabs()" in the "forwardSubstitution() function.
//
//
//      Partial pivoting (row minpulation) can be augmented with Full pivoting (row and column). The cost is that the resultant column vector must be rearranged with
//      if one or more matrix columns are re-arranged.
//
//      This may not be a difficult task to implement. We only need to keep a map of the modified column index vs. the original column index. When the solution is complete,
//      just re-arrange the modified column result back to it's original position. See document "lecture08.pdf" in directory "./Gaussian-Elimination-With-Partial-Pivoting" for
//      an explaination into the techiques required for full pivoting.
//
//
//
//
//
//
//
//
//
//
//
//
// ****************************************************************************************************************************************************************************



// Both sets of code were tested using the problem matrix 
//
//			4x + 8y + 4z = 80
//			2x + 1y - 4z = 7
//			3x - 1y + 2z = 22
//
//	in file 
//
//		"C:\ClassDAmplifier\PwmSimulation\Simulation\MultiLevelConverter\
//	GaussianElimination-SparseMatrix-Docs\General-Info-On-Gaussian-Elimination\
//	Gaussian Elimination.htm"
//
//
//	Both provide the correct result:
//
//
//		x = 7
//		y = 5
//          z = 3
//
//
//


   	// un-comment to test code in  "gauss_c.txt"      **** ONLY THIS VERSION APPLIES TO THE MODIFICATIONS STATED ABOVE.
#define TEST_gauss_c_txt   

	// un-comment to test code in  "gauss_c_1.txt"    **** NOT USED IN THIS MODIFICATION ****
//#define TEST_gauss_c_1_txt


#ifdef TEST_gauss_c_txt

		//This is code extracted from "gauss_c.txt"
#include<stdlib.h>
#include <stdio.h>
#include<math.h>

int n;
//float a[10][11];
double a[27][28];  // resized to accomodate "a_matrix" and make double precision

void forwardSubstitution() {
	int i, j, k, max;
	//float t;
	double t;
	for (i = 0; i < n; ++i) {
		max = i;
		for (j = i + 1; j < n; ++j)
		  //	if (a[j][i] > a[max][i])
		  if (fabs(a[j][i]) > fabs(a[max][i]))    //(!!!! This is where the mistake was made, see note at begining of this file !!!!!)
				max = j;
		
		for (j = 0; j < n + 1; ++j) {
			t = a[max][j];
			a[max][j] = a[i][j];
			a[i][j] = t;
		}
		
		for (j = n; j >= i; --j)
			for (k = i + 1; k < n; ++k)
				a[k][j] -= a[k][i]/a[i][i] * a[i][j];

/*		for (k = 0; k < n; ++k) {
			for (j = 0; j < n + 1; ++j)
				printf("%.2f\t", a[k][j]);
			printf("\n");
		}*/
	}
}

void reverseElimination() {
	int i, j;
	for (i = n - 1; i >= 0; --i) {
		a[i][n] = a[i][n] / a[i][i];
		a[i][i] = 1;
		for (j = i - 1; j >= 0; --j) {
			a[j][n] -= a[j][i] * a[i][n];
			a[j][i] = 0;
		}
	}
}

void gauss() {
	int i, j;

	forwardSubstitution();
	reverseElimination();
	
	for (i = 0; i < n; ++i) {
		for (j = 0; j < n + 1; ++j)
			printf("%.2f\t", a[i][j]);
		printf("\n");
	}
}

int main(int argc, char *argv[]) {
	int i, j;

	//	FILE *fin = fopen("gauss.in", "r");
	FILE *fin = fopen("../gauss.in", "r");            // *** Auto-generated file from Simulation project **
	fscanf(fin, "%d", &n);
	for (i = 0; i < n; ++i)
		for (j = 0; j < n + 1; ++j)
			fscanf(fin, "%f", &a[i][j]);
	fclose(fin);
	
	gauss();
	
	return 0;
}


#endif 


// *************************************************************************************************
// ***** (The section below was from the original Cygwin project and is not used in this test) *****
// ************************************************************************************************

#ifdef TEST_gauss_c_1_txt

		//This is code extracted from "gauss_c_1.txt"


/* Gaussian Elimination */
#include <math.h>
#include <stdio.h>

main()
{
double matrix[16][16];
double b[16],x[16];
int n,i,count,j;
double ratio,temp;

/* Read in matrix and b */
scanf("%d",&n);
printf("The matrix is %d by %d\n",n,n);
printf("Matrix:\n");
for(i=0;i<n;i++){
        for(j=0;j<n;j++){
                scanf("%lf ",&matrix[i][j]);  // *** This line was commented out in original ***
                /* for Hilbert matrix */
               /* matrix[i][j] = 1. / (i+j+1); */  // *** We comment out this line from original ***
        }
        scanf("%lf ",&b[i]);
        scanf("\n");
     //   b[i] = 1.;			// *** This line was commented out in original ***

}
for(i=0;i<n;i++){
        for(j=0;j<n;j++){
                printf("%lf ",matrix[i][j]);
        }
        printf("\n");
}
printf("Right Hand Side:\n");
for(i=0;i<n;i++){
        printf("%lf ",b[i]);
}
printf("\n");
/* Gaussian elimination */
for(i=0;i<(n-1);i++){
        for(j=(i+1);j<n;j++){
                ratio = matrix[j][i] / matrix[i][i];
                for(count=i;count<n;count++) {
                        matrix[j][count] -= (ratio * matrix[i][count]);
                }
                b[j] -= (ratio * b[i]);
        }
}
for (i=0;i<=n-1;i++){
        for(j=0;j<n;j++){
                printf("%lf ",matrix[i][j]);
        }
        printf("\n");
}
/* Back substitution */
x[n-1] = b[n-1] / matrix[n-1][n-1];
for(i=(n-2);i>=0;i--){
        temp = b[i];
        for(j=(i+1);j<n;j++){
                temp -= (matrix[i][j] * x[j]);
        }
        x[i] = temp / matrix[i][i];
}
printf("Answer:\n");
for(i=0;i<n;i++){
        printf("x%d = %lf\n",i,x[i]);
}
}










#endif 


